/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.impact;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.LongNameObjectSelection;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.impact.ImpA_PK_UK;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class ImpA_KeyObject
extends LongNameObjectSelection {
    private KeyObject keyObject;

    public ImpA_KeyObject(KeyObject keyObject, ModelIdObjectSelection modelIdObjectSelection, boolean bl) {
        super(keyObject);
        this.keyObject = keyObject;
        this.setParent(modelIdObjectSelection);
        if (bl) {
            this.load();
        }
    }

    @Override
    public void load() {
        this.addKeyNodes(this);
        this.loaded = true;
    }

    private void addKeyNodes(ImpA_KeyObject impA_KeyObject) {
        ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("ImpA_KeyObject.Mappings"));
        modelIdObjectSelection.setIcon(GUIConfiguration.getInstance().getIcon("KEY_ICON"));
        impA_KeyObject.addChild(modelIdObjectSelection);
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(Messages.getString("ImpA_KeyObject.RelationalModels"));
        modelIdObjectSelection2.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_GROUP_ICON"));
        modelIdObjectSelection.addChild(modelIdObjectSelection2);
        Iterator iterator = this.keyObject.getDesign().getRelationalDesigns().iterator();
        while (iterator.hasNext()) {
            RelationalDesign relationalDesign = (RelationalDesign)iterator.next();
            if (this.keyObject.getObjectID() == null) continue;
            ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(relationalDesign.getName());
            modelIdObjectSelection3.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_ICON"));
            modelIdObjectSelection2.addChild(modelIdObjectSelection3);
            List list = relationalDesign.getDesign().getExtendedMap().getMappingsForDesignPart(this.keyObject, relationalDesign.getObjectID());
            for (XtdMapping xtdMapping : list) {
                Index index = (Index)xtdMapping.getObjectMappedTo(this.keyObject);
                if (index == null) continue;
                if (!modelIdObjectSelection3.hasAsParent(index)) {
                    modelIdObjectSelection3.addChild(new ImpA_PK_UK(index, modelIdObjectSelection3, false));
                    continue;
                }
                modelIdObjectSelection3.addChild(new LongNameObjectSelection(index));
            }
        }
    }

    @Override
    public String toString() {
        if (this.keyObject.isPK()) {
            return "(PK) " + this.keyObject.getLongName();
        }
        return this.keyObject.getLongName();
    }
}

