/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.impact;

import java.util.List;
import oracle.dbtools.crest.model.LongNameObjectSelection;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.impact.ImpA_Column;
import oracle.dbtools.crest.model.design.impact.ImpA_Relation;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class ImpA_FKAssociation
extends LongNameObjectSelection {
    private FKIndexAssociation fkIndex;

    public ImpA_FKAssociation(FKIndexAssociation fKIndexAssociation, ModelIdObjectSelection modelIdObjectSelection, boolean bl) {
        super(fKIndexAssociation);
        this.fkIndex = fKIndexAssociation;
        this.setParent(modelIdObjectSelection);
        if (bl) {
            this.load();
        }
    }

    @Override
    public void load() {
        this.addFKColumns();
        this.addMappings(this);
        this.loaded = true;
    }

    private void addMappings(ImpA_FKAssociation impA_FKAssociation) {
        ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("ImpA_FKAssociation.Mappings"));
        modelIdObjectSelection.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON"));
        impA_FKAssociation.addChild(modelIdObjectSelection);
        if (this.fkIndex.getObjectID() != null) {
            List list = this.fkIndex.getDesign().getExtendedMap().getMappingsForDesignPart(this.fkIndex, this.fkIndex.getDesign().getLogicalDesign().getObjectID());
            for (XtdMapping xtdMapping : list) {
                Relation relation = (Relation)xtdMapping.getObjectMappedTo(this.fkIndex);
                if (relation == null) continue;
                if (!modelIdObjectSelection.hasAsParent(relation)) {
                    modelIdObjectSelection.addChild(new ImpA_Relation(relation, modelIdObjectSelection, false));
                    continue;
                }
                modelIdObjectSelection.addChild(new ModelIdObjectSelection(relation));
            }
        }
    }

    private void addFKColumns() {
        Index index = this.fkIndex.getLocalFKIndex();
        if (index != null && index.getElementsCollection().size() > 0) {
            ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("ImpA_FKAssociation.FKColumns"));
            modelIdObjectSelection.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON"));
            this.addChild(modelIdObjectSelection);
            for (Column column : index.getElementsCollection()) {
                if (!modelIdObjectSelection.hasAsParent(column)) {
                    modelIdObjectSelection.addChild(new ImpA_Column(column, modelIdObjectSelection, false));
                    continue;
                }
                modelIdObjectSelection.addChild(new LongNameObjectSelection(column));
            }
        }
    }
}

