/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.impact;

import java.util.ArrayList;
import java.util.Iterator;
import oracle.dbtools.crest.model.LongNameObjectSelection;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.impact.ImpA_Attribute;
import oracle.dbtools.crest.model.design.impact.ImpA_ColumnView;
import oracle.dbtools.crest.model.design.impact.ImpA_PK_UK;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class ImpA_Column
extends LongNameObjectSelection {
    private Column column;

    public ImpA_Column(Column column, ModelIdObjectSelection modelIdObjectSelection, boolean bl) {
        super(column);
        this.column = column;
        this.setParent(modelIdObjectSelection);
        if (bl) {
            this.load();
        }
    }

    @Override
    public void load() {
        this.addColumnNodes(this);
        this.addDependentColumns();
        this.addColumnViews();
        this.loaded = true;
    }

    private void addColumnNodes(ImpA_Column impA_Column) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("ImpA_Column.Mappings"));
        modelIdObjectSelection.setIcon(GUIConfiguration.getInstance().getIcon("ATTRIBUTE_FOLDER_ICON"));
        impA_Column.addChild(modelIdObjectSelection);
        if (this.column.getObjectID() != null) {
            object4 = this.column.getDesign().getExtendedMap().getMappingsForDesignPart(this.column, this.column.getDesign().getLogicalDesign().getObjectID());
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (XtdMapping)object3.next();
                object = (Attribute)((XtdMapping)object2).getObjectMappedTo(this.column);
                if (object == null) continue;
                if (!modelIdObjectSelection.hasAsParent((ModelIDObject)object)) {
                    modelIdObjectSelection.addChild(new ImpA_Attribute((Attribute)object, modelIdObjectSelection, false));
                    continue;
                }
                modelIdObjectSelection.addChild(new LongNameObjectSelection((ModelIDObject)object));
            }
        }
        modelIdObjectSelection.sortAsString();
        object4 = new ModelIdObjectSelection(Messages.getString("ImpA_Column.PKAndUKConstraints"));
        ((ModelObject)object4).setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON"));
        impA_Column.addChild((ModelIdObjectSelection)object4);
        object3 = new ModelIdObjectSelection(Messages.getString("ImpA_Column.ForeignKeys"));
        ((ModelObject)object3).setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON"));
        impA_Column.addChild((ModelIdObjectSelection)object3);
        object2 = new ModelIdObjectSelection(Messages.getString("ImpA_Column.Indexes"));
        ((ModelObject)object2).setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON"));
        impA_Column.addChild((ModelIdObjectSelection)object2);
        object = this.column.getContainerWithKeyObject().getKeySet().iterator();
        while (object.hasNext()) {
            Index index = (Index)object.next();
            if ((index.isPK() || index.isUnique()) && index.getElementsCollection().contains(this.column)) {
                if (!((ModelIdObjectSelection)object4).hasAsParent(index)) {
                    ((ModelIdObjectSelection)object4).addChild(new ImpA_PK_UK(index, (ModelIdObjectSelection)object4, false));
                    continue;
                }
                ((ModelIdObjectSelection)object4).addChild(new LongNameObjectSelection(index));
                continue;
            }
            if (index.isFK() && index.getElementsCollection().contains(this.column)) {
                ((ModelIdObjectSelection)object3).addChild(new LongNameObjectSelection(index.getFKAssociation()));
                continue;
            }
            if (!index.getElementsCollection().contains(this.column)) continue;
            ((ModelIdObjectSelection)object2).addChild(new LongNameObjectSelection(index));
        }
    }

    private void addDependentColumns() {
        ModelObject modelObject;
        ArrayList<ModelObject> arrayList = new ArrayList<ModelObject>();
        Iterator iterator = this.column.getDesignObjectSet().iterator();
        while (iterator.hasNext()) {
            modelObject = (Column)iterator.next();
            if (((Column)modelObject).getDelegate() != this.column) continue;
            arrayList.add(modelObject);
        }
        if (arrayList.size() > 0) {
            modelObject = new ModelIdObjectSelection(Messages.getString("ImpA_Column.DependentFKColumns"));
            modelObject.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON"));
            this.addChild((ModelIdObjectSelection)modelObject);
            for (Column column : arrayList) {
                if (!((ModelIdObjectSelection)modelObject).hasAsParent(column)) {
                    ((ModelIdObjectSelection)modelObject).addChild(new ImpA_Column(column, (ModelIdObjectSelection)modelObject, false));
                    continue;
                }
                ((ModelIdObjectSelection)modelObject).addChild(new LongNameObjectSelection(column));
            }
            ((ModelIdObjectSelection)modelObject).sortAsString();
        }
    }

    private void addColumnViews() {
        ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("ImpA_Column.DependentViewColumns"));
        modelIdObjectSelection.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_FOLDER_ICON"));
        this.addChild(modelIdObjectSelection);
        ArrayList<ColumnView> arrayList = new ArrayList<ColumnView>();
        Iterator iterator = ((RelationalDesign)this.column.getDesignPart()).getColumnViewSet().iterator();
        while (iterator.hasNext()) {
            ColumnView columnView = (ColumnView)iterator.next();
            if (columnView.getReferencedColumn() == null || columnView.getReferencedColumn() != this.column || columnView.getReferencedColumnView() != null) continue;
            arrayList.add(columnView);
        }
        for (ColumnView columnView : arrayList) {
            if (!modelIdObjectSelection.hasAsParent(columnView)) {
                modelIdObjectSelection.addChild(new ImpA_ColumnView(columnView, modelIdObjectSelection, false));
                continue;
            }
            modelIdObjectSelection.addChild(new ModelIdObjectSelection(columnView));
        }
        modelIdObjectSelection.sortAsString();
    }
}

