/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.impact;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import oracle.dbtools.crest.model.LongNameObjectSelection;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.impact.ImpA_AttributeView;
import oracle.dbtools.crest.model.design.impact.ImpA_Column;
import oracle.dbtools.crest.model.design.impact.ImpA_KeyObject;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.Process;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.GUIConfiguration;

public class ImpA_Attribute
extends LongNameObjectSelection {
    private Attribute attribute;

    public ImpA_Attribute(Attribute attribute, ModelIdObjectSelection modelIdObjectSelection, boolean bl) {
        super(attribute);
        this.attribute = attribute;
        this.setParent(modelIdObjectSelection);
        if (bl) {
            this.load();
        }
    }

    @Override
    public void load() {
        this.addAttributeNodes(this);
        this.addDependentFKAttributes();
        this.addViews();
        this.addProcessModel();
        this.addDimensionalModels();
        this.loaded = true;
    }

    private void addAttributeNodes(ImpA_Attribute impA_Attribute) {
        ModelIDObject modelIDObject;
        Iterator iterator;
        ModelIdObjectSelection modelIdObjectSelection;
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.Mappings"));
        modelIdObjectSelection2.setIcon(GUIConfiguration.getInstance().getIcon("ATTRIBUTE_FOLDER_ICON"));
        impA_Attribute.addChild(modelIdObjectSelection2);
        if (this.attribute.getObjectID() != null) {
            modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.RelationalModels"));
            modelIdObjectSelection.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_GROUP_ICON"));
            modelIdObjectSelection2.addChild(modelIdObjectSelection);
            iterator = this.attribute.getDesign().getRelationalDesigns().iterator();
            while (iterator.hasNext()) {
                modelIDObject = (RelationalDesign)iterator.next();
                ModelIdObjectSelection modelIdObjectSelection3 = null;
                if (((DesignPart)modelIDObject).isLoaded()) {
                    modelIdObjectSelection3 = new ModelIdObjectSelection(((RelationalDesign)modelIDObject).getName());
                    modelIdObjectSelection3.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_ICON"));
                    modelIdObjectSelection.addChild(modelIdObjectSelection3);
                } else {
                    modelIdObjectSelection3 = new ModelIdObjectSelection(((RelationalDesign)modelIDObject).getName() + "(not loaded)");
                    modelIdObjectSelection3.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_ICON"));
                    modelIdObjectSelection.addChild(modelIdObjectSelection3);
                }
                List list = modelIDObject.getDesign().getExtendedMap().getMappingsForDesignPart(this.attribute, modelIDObject.getObjectID());
                for (XtdMapping xtdMapping : list) {
                    Object object;
                    if (((DesignPart)modelIDObject).isLoaded()) {
                        object = (Column)xtdMapping.getObjectMappedTo(this.attribute);
                        if (object == null) continue;
                        if (!modelIdObjectSelection3.hasAsParent((ModelIDObject)object)) {
                            modelIdObjectSelection3.addChild(new ImpA_Column((Column)object, modelIdObjectSelection3, false));
                            continue;
                        }
                        modelIdObjectSelection3.addChild(new LongNameObjectSelection((ModelIDObject)object));
                        continue;
                    }
                    object = xtdMapping.getOtherName(this.attribute.getObjectID());
                    modelIdObjectSelection3.addChild(new ModelIdObjectSelection((String)object + "(not loaded)"));
                }
            }
        }
        modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.PKAndUKConstraints"));
        modelIdObjectSelection.setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON"));
        impA_Attribute.addChild(modelIdObjectSelection);
        if (this.attribute.isUnique() || this.attribute.isPKElement()) {
            iterator = this.attribute.getContainerWithKeyObject().getKeySet().iterator();
            while (iterator.hasNext()) {
                modelIDObject = (KeyObject)iterator.next();
                if (!((ContainerObject)modelIDObject).getElementsCollection().contains(this.attribute)) continue;
                if (!modelIdObjectSelection.hasAsParent(modelIDObject)) {
                    modelIdObjectSelection.addChild(new ImpA_KeyObject((KeyObject)modelIDObject, modelIdObjectSelection, false));
                    continue;
                }
                modelIdObjectSelection.addChild(new LongNameObjectSelection(modelIDObject));
            }
        }
    }

    private void addProcessModel() {
        ModelIdObjectSelection modelIdObjectSelection;
        DesignObject designObject;
        int n;
        Object object;
        Object object22;
        ModelObject modelObject;
        Object object3;
        ModelObject modelObject2;
        ModelObject modelObject3;
        TreeMap<String, DFDholder> treeMap = new TreeMap<String, DFDholder>();
        TreeMap<String, DFDholder> treeMap2 = new TreeMap<String, DFDholder>();
        TreeMap<String, DFDholder> treeMap3 = new TreeMap<String, DFDholder>();
        ProcessModel processModel = this.attribute.getDesign().getProcessModel();
        Iterator iterator = processModel.getDataFlowDesigns().iterator();
        while (iterator.hasNext()) {
            modelObject3 = (DataFlowDesign)iterator.next();
            modelObject2 = ((DataFlowDesign)modelObject3).getTopLevelDataFlowDesign();
            object3 = ((DataFlowDesign)modelObject3).getProcessSet().iterator();
            while (object3.hasNext()) {
                modelObject = (Process)object3.next();
                if (((Process)modelObject).getType() != 0) continue;
                for (Object object22 : ((Process)modelObject).getProcessedAttributesAndFlows(false, this.attribute)) {
                    if (((Process.ProcessedObject)object22).getObject() != this.attribute) continue;
                    if (((Process.ProcessedObject)object22).isInbound()) {
                        object = (DFDholder)treeMap.get(((DataFlowDesign)modelObject2).getName());
                        if (object == null) {
                            object = new DFDholder();
                            ((DFDholder)object).dfd = modelObject2;
                            ((DFDholder)object).list = new ArrayList();
                            treeMap.put(((DataFlowDesign)modelObject2).getName(), (DFDholder)object);
                        }
                        if (!((DFDholder)object).list.contains(modelObject)) {
                            ((DFDholder)object).list.add(modelObject);
                        }
                    } else {
                        object = (DFDholder)treeMap2.get(((DataFlowDesign)modelObject2).getName());
                        if (object == null) {
                            object = new DFDholder();
                            ((DFDholder)object).dfd = modelObject2;
                            ((DFDholder)object).list = new ArrayList();
                            treeMap2.put(((DataFlowDesign)modelObject2).getName(), (DFDholder)object);
                        }
                        if (!((DFDholder)object).list.contains(modelObject)) {
                            ((DFDholder)object).list.add(modelObject);
                        }
                    }
                    object = (DFDholder)treeMap3.get(((DataFlowDesign)modelObject2).getName());
                    if (object == null) {
                        object = new DFDholder();
                        ((DFDholder)object).dfd = modelObject2;
                        ((DFDholder)object).list = new ArrayList();
                        treeMap3.put(((DataFlowDesign)modelObject2).getName(), (DFDholder)object);
                    }
                    if (((DFDholder)object).list.contains(((Process.ProcessedObject)object22).getFlow())) continue;
                    ((DFDholder)object).list.add(((Process.ProcessedObject)object22).getFlow());
                }
            }
        }
        modelObject3 = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.ProcessModel"));
        modelObject3.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_ICON"));
        this.addChild((ModelIdObjectSelection)modelObject3);
        modelObject2 = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.InboundProcesses"));
        modelObject2.setIcon(GUIConfiguration.getInstance().getIcon("PROCESS_ICON"));
        ((ModelIdObjectSelection)modelObject3).addChild((ModelIdObjectSelection)modelObject2);
        object3 = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.OutboundProcesses"));
        ((ModelObject)object3).setIcon(GUIConfiguration.getInstance().getIcon("PROCESS_ICON"));
        ((ModelIdObjectSelection)modelObject3).addChild((ModelIdObjectSelection)object3);
        modelObject = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.Flows"));
        modelObject.setIcon(GUIConfiguration.getInstance().getIcon("FLOW_ICON"));
        ((ModelIdObjectSelection)modelObject3).addChild((ModelIdObjectSelection)modelObject);
        for (Object object4 : treeMap.keySet()) {
            object22 = (DFDholder)treeMap.get(object4);
            if (((DFDholder)object22).list.size() <= 0) continue;
            Collections.sort(((DFDholder)object22).list, ModelObjectSet.UPPERCASE_NAME_COMPARATOR);
            object = new ModelIdObjectSelection(((DFDholder)object22).dfd);
            ((ModelIdObjectSelection)modelObject2).addChild((ModelIdObjectSelection)object);
            for (n = 0; n < ((DFDholder)object22).list.size(); ++n) {
                designObject = (Process)((DFDholder)object22).list.get(n);
                modelIdObjectSelection = new ModelIdObjectSelection(designObject);
                ((ModelIdObjectSelection)object).addChild(modelIdObjectSelection);
            }
        }
        for (Object object4 : treeMap2.keySet()) {
            object22 = (DFDholder)treeMap2.get(object4);
            if (((DFDholder)object22).list.size() <= 0) continue;
            Collections.sort(((DFDholder)object22).list, ModelObjectSet.UPPERCASE_NAME_COMPARATOR);
            object = new ModelIdObjectSelection(((DFDholder)object22).dfd);
            ((ModelIdObjectSelection)object3).addChild((ModelIdObjectSelection)object);
            for (n = 0; n < ((DFDholder)object22).list.size(); ++n) {
                designObject = (Process)((DFDholder)object22).list.get(n);
                modelIdObjectSelection = new ModelIdObjectSelection(designObject);
                ((ModelIdObjectSelection)object).addChild(modelIdObjectSelection);
            }
        }
        for (Object object4 : treeMap3.keySet()) {
            object22 = (DFDholder)treeMap3.get(object4);
            if (((DFDholder)object22).list.size() <= 0) continue;
            Collections.sort(((DFDholder)object22).list, ModelObjectSet.UPPERCASE_NAME_COMPARATOR);
            object = new ModelIdObjectSelection(((DFDholder)object22).dfd);
            ((ModelIdObjectSelection)modelObject).addChild((ModelIdObjectSelection)object);
            for (n = 0; n < ((DFDholder)object22).list.size(); ++n) {
                designObject = (DesignObject)((DFDholder)object22).list.get(n);
                modelIdObjectSelection = new ModelIdObjectSelection(designObject);
                ((ModelIdObjectSelection)object).addChild(modelIdObjectSelection);
            }
        }
    }

    private void addDependentFKAttributes() {
        ModelObject modelObject;
        ArrayList<ModelObject> arrayList = new ArrayList<ModelObject>();
        Iterator iterator = this.attribute.getDesignObjectSet().iterator();
        while (iterator.hasNext()) {
            modelObject = (Attribute)iterator.next();
            if (((Attribute)modelObject).getDelegate() != this.attribute) continue;
            arrayList.add(modelObject);
        }
        if (arrayList.size() > 0) {
            modelObject = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.DependentFKAttributes"));
            modelObject.setIcon(GUIConfiguration.getInstance().getIcon("FK_ICON"));
            this.addChild((ModelIdObjectSelection)modelObject);
            for (Attribute attribute : arrayList) {
                if (!((ModelIdObjectSelection)modelObject).hasAsParent(attribute)) {
                    ((ModelIdObjectSelection)modelObject).addChild(new ImpA_Attribute(attribute, (ModelIdObjectSelection)modelObject, false));
                    continue;
                }
                ((ModelIdObjectSelection)modelObject).addChild(new LongNameObjectSelection(attribute));
            }
        }
    }

    private void addViews() {
        ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.DependentViewAttributes"));
        modelIdObjectSelection.setIcon(GUIConfiguration.getInstance().getIcon("ATTRIBUTE_FOLDER_ICON"));
        this.addChild(modelIdObjectSelection);
        ArrayList<AttributeView> arrayList = new ArrayList<AttributeView>();
        Iterator iterator = this.attribute.getDesign().getLogicalDesign().getAttributeViewSet().iterator();
        while (iterator.hasNext()) {
            AttributeView attributeView = (AttributeView)iterator.next();
            if (attributeView.getReferencedAttribute() == null || attributeView.getReferencedColumnView() != null || attributeView.getReferencedAttribute() != this.attribute) continue;
            arrayList.add(attributeView);
        }
        for (AttributeView attributeView : arrayList) {
            if (!modelIdObjectSelection.hasAsParent(attributeView)) {
                modelIdObjectSelection.addChild(new ImpA_AttributeView(attributeView, modelIdObjectSelection));
                continue;
            }
            modelIdObjectSelection.addChild(new ModelIdObjectSelection(attributeView));
        }
    }

    private void addDimensionalModels() {
        ModelIdObjectSelection modelIdObjectSelection = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.DimensionalModels"));
        modelIdObjectSelection.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_GROUP_ICON"));
        this.addChild(modelIdObjectSelection);
        Iterator iterator = this.attribute.getDesign().getMultidimensionalDesigns().iterator();
        while (iterator.hasNext()) {
            MultidimensionalDesign multidimensionalDesign = (MultidimensionalDesign)iterator.next();
            this.addDimensionalModel(multidimensionalDesign, modelIdObjectSelection);
        }
    }

    private void addDimensionalModel(MultidimensionalDesign multidimensionalDesign, ModelIdObjectSelection modelIdObjectSelection) {
        Object object;
        ModelObject modelObject;
        Iterator iterator;
        Object object22;
        Object object3;
        ModelObject modelObject2;
        ModelIdObjectSelection modelIdObjectSelection2 = new ModelIdObjectSelection(multidimensionalDesign);
        modelIdObjectSelection2.setIcon(GUIConfiguration.getInstance().getIcon("PACKAGE_ICON"));
        modelIdObjectSelection.addChild(modelIdObjectSelection2);
        ModelIdObjectSelection modelIdObjectSelection3 = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.Measures"));
        modelIdObjectSelection3.setIcon(GUIConfiguration.getInstance().getIcon("MEASURE_ICON"));
        modelIdObjectSelection2.addChild(modelIdObjectSelection3);
        Iterator iterator2 = multidimensionalDesign.getCubeSet().iterator();
        while (iterator2.hasNext()) {
            modelObject2 = (Cube)iterator2.next();
            object3 = new ArrayList<Measure>();
            for (Object object22 : ((Cube)modelObject2).getMeasures()) {
                if (((Measure)object22).getMeasureFact() != this.attribute) continue;
                object3.add(object22);
            }
            if (object3.size() <= 0) continue;
            object22 = new ModelIdObjectSelection((ModelIDObject)modelObject2);
            modelIdObjectSelection3.addChild((ModelIdObjectSelection)object22);
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                modelObject = (Measure)iterator.next();
                ((ModelIdObjectSelection)object22).addChild(new LongNameObjectSelection((ModelIDObject)modelObject));
            }
        }
        modelObject2 = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.LevelAttributes"));
        modelObject2.setIcon(GUIConfiguration.getInstance().getIcon("ATTRIBUTE_FOLDER_ICON"));
        modelIdObjectSelection2.addChild((ModelIdObjectSelection)modelObject2);
        iterator2 = multidimensionalDesign.getLevelSet().iterator();
        while (iterator2.hasNext()) {
            object3 = (Level)iterator2.next();
            object = new ArrayList();
            object22 = new ArrayList();
            object22.addAll(((Level)object3).getLevelKey());
            object22.addAll(((Level)object3).getSlowChangingAttributes());
            object22.addAll(((Level)object3).getJoinAttributes());
            iterator = object22.iterator();
            while (iterator.hasNext()) {
                modelObject = iterator.next();
                if (modelObject != this.attribute && (!(modelObject instanceof SlowChangingAttribute) || this.attribute != ((SlowChangingAttribute)((Object)modelObject)).getAttribute())) continue;
                object.add(modelObject);
            }
            if (object.size() <= 0) continue;
            modelObject = new ModelIdObjectSelection((ModelIDObject)object3);
            ((ModelIdObjectSelection)modelObject2).addChild((ModelIdObjectSelection)modelObject);
            iterator = object.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof Attribute) {
                    ((ModelIdObjectSelection)modelObject).addChild(new ModelIdObjectSelection(this.attribute.getName()));
                    continue;
                }
                if (!(e instanceof SlowChangingAttribute)) continue;
                ((ModelIdObjectSelection)modelObject).addChild(new ModelIdObjectSelection(((SlowChangingAttribute)e).getName()));
            }
        }
        object3 = new ModelIdObjectSelection(Messages.getString("ImpA_Attribute.JoinsRollupLinks"));
        ((ModelObject)object3).setIcon(GUIConfiguration.getInstance().getIcon("LINK_ICON"));
        modelIdObjectSelection2.addChild((ModelIdObjectSelection)object3);
        iterator2 = multidimensionalDesign.getRollupLinkSet().iterator();
        while (iterator2.hasNext()) {
            object = (RollupLink)iterator2.next();
            if (object == null || !((RollupLink)object).getChildToParentAttributes().contains(this.attribute)) continue;
            ((ModelIdObjectSelection)object3).addChild(new ModelIdObjectSelection((ModelIDObject)object));
        }
    }

    class DFDholder {
        DataFlowDesign dfd;
        List list;

        DFDholder() {
        }
    }
}

