/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.glossary;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.engineering.EngEmptyPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngFilteredSelection;
import oracle.dbtools.crest.model.design.engineering.EngineeringObjectSelection;
import oracle.dbtools.crest.model.design.glossary.Glossary;
import oracle.dbtools.crest.model.design.glossary.GlossaryWord;
import oracle.dbtools.crest.model.design.glossary.GlossaryWordSelection;
import oracle.dbtools.crest.model.design.glossary.WordPropertiesComparator;
import oracle.dbtools.crest.model.design.process.EventSet;

public class GlossaryImportSelection
extends EngFilteredSelection {
    private EngineeringObjectSelection rightRoot;
    private Map comparatorsMap = new TreeMap();
    private List impWords;
    private List existingWords = new ArrayList();

    public GlossaryImportSelection(Glossary glossary, Glossary glossary2, Design design) {
        super(glossary.getName());
        this.setDesign(design);
        this.setName(Messages.getString("GlossaryImportSelection.WordsToImport"));
        this.rightRoot = new EngFilteredSelection(glossary2.getName());
        this.rightRoot.setName(MessageFormat.format(Messages.getString("GlossaryImportSelection.CorrespondingWordsIn"), glossary2.getName()));
        this.setCorrespondentNode(this.rightRoot);
        this.rightRoot.setCorrespondentNode(this);
        this.setEmptyComparator(this);
        this.setEmptyComparator(this.rightRoot);
        glossary.sortWords();
        this.impWords = glossary.getWords();
        this.existingWords = glossary2.getWords();
        this.addWords();
    }

    private void setEmptyComparator(EngineeringObjectSelection engineeringObjectSelection) {
        engineeringObjectSelection.setPropertiesComparator(new EngEmptyPropertiesComparator(null, null));
    }

    private GlossaryWord getWordByImportedID(List list, String string) {
        for (GlossaryWord glossaryWord : list) {
            String string2 = glossaryWord.getImportID();
            if (string2 == null || !string.equalsIgnoreCase(string2)) continue;
            return glossaryWord;
        }
        return null;
    }

    private GlossaryWord getWordByID(List list, String string) {
        for (GlossaryWord glossaryWord : list) {
            if (!string.equalsIgnoreCase(glossaryWord.getId())) continue;
            return glossaryWord;
        }
        return null;
    }

    private GlossaryWord getWordByName(List list, String string) {
        for (GlossaryWord glossaryWord : list) {
            if (!string.equalsIgnoreCase(glossaryWord.getName())) continue;
            return glossaryWord;
        }
        return null;
    }

    private void addWord(GlossaryWord glossaryWord, EngineeringObjectSelection engineeringObjectSelection, EngineeringObjectSelection engineeringObjectSelection2, boolean bl) {
        GlossaryWordSelection glossaryWordSelection = new GlossaryWordSelection(glossaryWord);
        boolean bl2 = true;
        GlossaryWord glossaryWord2 = this.getWordByImportedID(this.existingWords, glossaryWord.getId());
        if (glossaryWord2 == null) {
            glossaryWord2 = this.getWordByID(this.existingWords, glossaryWord.getId());
        }
        if (glossaryWord2 == null && glossaryWord.getImportID() != null && !"".equals(glossaryWord.getImportID()) && (glossaryWord2 = this.getWordByID(this.existingWords, glossaryWord.getImportID())) == null) {
            glossaryWord2 = this.getWordByImportedID(this.existingWords, glossaryWord.getImportID());
        }
        if (glossaryWord2 == null && (glossaryWord2 = this.getWordByName(this.existingWords, glossaryWord.getName())) != null) {
            bl2 = false;
        }
        glossaryWordSelection.setSelected(bl2);
        EngineeringObjectSelection engineeringObjectSelection3 = null;
        if (glossaryWord2 != null) {
            engineeringObjectSelection3 = new GlossaryWordSelection(glossaryWord2);
            WordPropertiesComparator wordPropertiesComparator = new WordPropertiesComparator(glossaryWord, glossaryWord2);
            glossaryWordSelection.setPropertiesComparator(wordPropertiesComparator);
            engineeringObjectSelection3.setPropertiesComparator(wordPropertiesComparator);
            engineeringObjectSelection3.setSelected(wordPropertiesComparator.isModified());
            this.comparatorsMap.put(wordPropertiesComparator.getID(), wordPropertiesComparator);
        } else {
            engineeringObjectSelection3 = new EngineeringObjectSelection(glossaryWord.getName());
            glossaryWordSelection.setStatus(ModelIdObjectSelection.STATE_NEW);
            engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_NEW);
            WordPropertiesComparator wordPropertiesComparator = new WordPropertiesComparator(glossaryWord, null);
            glossaryWordSelection.setPropertiesComparator(wordPropertiesComparator);
            engineeringObjectSelection3.setPropertiesComparator(wordPropertiesComparator);
        }
        glossaryWordSelection.setElementDescriptor(EventSet.class);
        engineeringObjectSelection3.setElementDescriptor(EventSet.class);
        engineeringObjectSelection3.setCorrespondentNode(glossaryWordSelection);
        glossaryWordSelection.setCorrespondentNode(engineeringObjectSelection3);
        engineeringObjectSelection.addChild(glossaryWordSelection);
        engineeringObjectSelection2.addChild(engineeringObjectSelection3);
    }

    private void addWords() {
        for (GlossaryWord glossaryWord : this.impWords) {
            this.addWord(glossaryWord, this, this.rightRoot, true);
        }
    }

    public EngineeringObjectSelection getLeftRoot() {
        return this;
    }

    public EngineeringObjectSelection getRightRoot() {
        return this.rightRoot;
    }

    public Map getComparatorsMap() {
        return this.comparatorsMap;
    }
}

