/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.List;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.relational.TableView;

public class TableViewEntityViewComparator
extends EngPropertiesComparator {
    private TableView tableView;
    private EntityView entityView;

    TableViewEntityViewComparator(TableView tableView, EntityView entityView) {
        super(tableView, entityView);
        this.tableView = tableView;
        this.entityView = entityView;
        this.initPropertiesList();
    }

    TableViewEntityViewComparator(TableView tableView, EntityView entityView, List list) {
        this(tableView, entityView);
        this.applyCompareFilter(list, tableView.getDesign().getShowSelPropsOnly());
    }

    @Override
    public void copySelectedProperties() {
        if (!this.isReadOnly()) {
            this.copyPropertiesFromLeftToRight();
            this.copyPropertiesFromEntityViewToTableView();
        }
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentsAndNotes();
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(STRUCTURED_TYPE);
        if (this.tableView != null && this.tableView.getBasedOnStructuredType() != null) {
            engPropertyHolder.setLeftValue(this.tableView.getBasedOnStructuredType().getName());
        } else {
            engPropertyHolder.setLeftValue("");
        }
        if (this.entityView != null && this.entityView.getBasedOnStructuredType() != null) {
            engPropertyHolder.setRightValue(this.entityView.getBasedOnStructuredType().getName());
        } else {
            engPropertyHolder.setRightValue("");
        }
        if (this.tableView != null && this.entityView != null && this.tableView.getBasedOnStructuredType() != this.entityView.getBasedOnStructuredType()) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(WHERE_PROPERTY);
        engPropertyHolder.setLeftValue(this.tableView != null ? this.tableView.getWhere() : "");
        engPropertyHolder.setRightValue(this.entityView != null ? this.entityView.getWhere() : "");
        if (this.tableView != null && this.entityView != null && !this.tableView.getWhere().equals(this.entityView.getWhere())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(HAVING_PROPERTY);
        engPropertyHolder.setLeftValue(this.tableView != null ? this.tableView.getHaving() : "");
        engPropertyHolder.setRightValue(this.entityView != null ? this.entityView.getHaving() : "");
        if (this.tableView != null && this.entityView != null && !this.tableView.getHaving().equals(this.entityView.getHaving())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(USER_DEFINED_DQL);
        engPropertyHolder.setLeftValue(this.tableView != null ? this.tableView.getUserDefinedSQL() : "");
        engPropertyHolder.setRightValue(this.entityView != null ? this.entityView.getUserDefinedSQL() : "");
        if (this.tableView != null && this.entityView != null && this.entityView.getUserDefined() && this.tableView.getUserDefined() && !this.tableView.getUserDefinedSQL().equals(this.entityView.getUserDefinedSQL())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
    }

    private void copyPropertiesFromEntityViewToTableView() {
        if (this.tableView != null && this.entityView != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(STRUCTURED_TYPE)) {
                    this.entityView.setBasedOnStructuredType(this.tableView.getBasedOnStructuredType());
                    continue;
                }
                if (engPropertyHolder.getName().equals(WHERE_PROPERTY)) {
                    this.entityView.setWhere(this.tableView.getWhere());
                    continue;
                }
                if (engPropertyHolder.getName().equals(HAVING_PROPERTY)) {
                    this.entityView.setHaving(this.tableView.getHaving());
                    continue;
                }
                if (!engPropertyHolder.getName().equals(USER_DEFINED_DQL)) continue;
                this.entityView.setUserDefinedSQL(this.tableView.getUserDefinedSQL());
                this.entityView.setLayoutSQL(this.tableView.getLayoutSQL());
                this.entityView.setParsed(this.tableView.isParsed());
                this.entityView.setIncorrectSQL(this.tableView.isIncorrectSQL());
                this.entityView.setValidSQL(this.tableView.isValidSQL());
            }
        }
    }

    @Override
    protected boolean shouldApplyNametranslation() {
        return false;
    }
}

