/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.text.MessageFormat;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.Table;

public class TableEntityComparator
extends EngPropertiesComparator {
    private final Table table;
    private final Entity entity;

    public TableEntityComparator(Table table, Entity entity) {
        super(table, entity);
        this.table = table;
        this.entity = entity;
        this.initPropertiesList();
    }

    public TableEntityComparator(Table table, Entity entity, List list) {
        this(table, entity);
        this.applyCompareFilter(list, table.getDesign().getShowSelPropsOnly());
    }

    @Override
    public void copySelectedProperties() {
        if (!this.isReadOnly()) {
            this.copyPropertiesFromLeftToRight();
            this.copyPropertiesFromEntityToTable();
        }
    }

    @Override
    protected void initNameProperty() {
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(NAME);
        engPropertyHolder.setLeftValue(this.table != null ? this.table.getName() : "");
        engPropertyHolder.setRightValue(this.entity != null ? this.entity.getName() : "");
        if (this.table != null && this.entity != null && !this.table.getName().equals(this.entity.getName())) {
            boolean bl = false;
            if (this.getDesign().isApplyNameStandardization()) {
                String string = "";
                string = this.getDesign().transformNameFromRelationalToLogical(this.table);
                if (!string.equals(this.entity.getName())) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl) {
                if (this.entity.getFwdEngineeringStrategyName().equals("Single Table") && !this.entity.isHierarchicalRoot()) {
                    bl = false;
                }
                if (this.entity.getFwdEngineeringStrategyName().equals("Table per child") && this.entity.getHierarchicalChildrenCount() > 0) {
                    bl = false;
                }
                if (bl) {
                    engPropertyHolder.setModified(true);
                    engPropertyHolder.setSelected(true);
                }
            }
        }
        this.propertiesList.add(engPropertyHolder);
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        if (this.getDesign().isApplyNameStandardization()) {
            this.initNameTranslationProperty();
        }
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(SHORT_NAME_ABBR);
        engPropertyHolder.setLeftValue(this.table != null ? this.table.getAbbreviation() : "");
        engPropertyHolder.setRightValue(this.entity != null ? this.entity.getShortName() : "");
        if (this.table != null && this.entity != null && !this.table.getAbbreviation().equals(this.entity.getShortName())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        this.initCommentsAndNotes();
        engPropertyHolder = new EngPropertyHolder(TEMP_TABLE_SCOPE);
        engPropertyHolder.setLeftValue(this.table != null ? this.table.getScope() : "");
        engPropertyHolder.setRightValue(this.entity != null ? this.entity.getScope() : "");
        if (this.table != null && this.entity != null && !this.table.getScope().equals(this.entity.getScope())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(TABLE_TYPE);
        engPropertyHolder.setLeftValue(this.table != null ? this.table.getDesign().getDLSettings().getClassificationTypeNameByID(this.table.getTypeID()) : "");
        engPropertyHolder.setRightValue(this.entity != null ? this.entity.getDesign().getDLSettings().getClassificationTypeNameByID(this.entity.getTypeID()) : "");
        if (this.table != null && this.entity != null && !this.table.getTypeID().equals(this.entity.getTypeID())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(STRUCTURED_TYPE);
        if (this.table != null && this.table.getBasedOnStructuredType() != null) {
            engPropertyHolder.setLeftValue(this.table.getBasedOnStructuredType().getName());
        } else {
            engPropertyHolder.setLeftValue("");
        }
        if (this.entity != null && this.entity.getBasedOnStructuredType() != null) {
            engPropertyHolder.setRightValue(this.entity.getBasedOnStructuredType().getName());
        } else {
            engPropertyHolder.setRightValue("");
        }
        if (this.table != null && this.entity != null && this.table.getBasedOnStructuredType() != this.entity.getBasedOnStructuredType()) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(ENT_TABLE_TYPE_SUBSTITUTION);
        engPropertyHolder.setLeftValue(this.table != null && this.table.getTypeSubstitution() != null ? String.valueOf(this.table.getTypeSubstitution().getParentContainerObject().getName()) : "");
        engPropertyHolder.setRightValue(this.entity != null && this.entity.getTypeSubstitution() != null ? String.valueOf(this.entity.getTypeSubstitution().getParentContainerObject().getName()) : "");
        if (this.table != null && this.entity != null) {
            if (this.table.getTypeSubstitution() != null) {
                Table table = (Table)this.table.getTypeSubstitution().getParentContainerObject();
                Entity entity = null;
                if (this.entity.getTypeSubstitution() != null) {
                    entity = (Entity)this.entity.getTypeSubstitution().getParentContainerObject();
                }
                if (table.getEngEntity() != entity) {
                    engPropertyHolder.setModified(true);
                    engPropertyHolder.setSelected(true);
                }
            } else if (this.entity.getTypeSubstitution() != null) {
                engPropertyHolder.setModified(true);
                engPropertyHolder.setSelected(true);
            }
        } else if (this.table != null && this.table.getTypeSubstitution() != null) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(MIN_VOLUMES);
        engPropertyHolder.setLeftValue(this.table != null ? this.table.getMinVolumes() : "");
        engPropertyHolder.setRightValue(this.entity != null ? this.entity.getMinVolumes() : "");
        if (this.table != null && this.entity != null && !this.table.getMinVolumes().equals(this.entity.getMinVolumes())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(EXPECTED_VOLUMES);
        engPropertyHolder.setLeftValue(this.table != null ? this.table.getExpectedVolumes() : "");
        engPropertyHolder.setRightValue(this.entity != null ? this.entity.getExpectedVolumes() : "");
        if (this.table != null && this.entity != null && !this.table.getExpectedVolumes().equals(this.entity.getExpectedVolumes())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(MAX_VOLUMES);
        engPropertyHolder.setLeftValue(this.table != null ? this.table.getMaxVolumes() : "");
        engPropertyHolder.setRightValue(this.entity != null ? this.entity.getMaxVolumes() : "");
        if (this.table != null && this.entity != null && !this.table.getMaxVolumes().equals(this.entity.getMaxVolumes())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(GROWTH_PERCENT);
        engPropertyHolder.setLeftValue(this.table != null ? this.table.getGrowthPercent() : "");
        engPropertyHolder.setRightValue(this.entity != null ? this.entity.getGrowthPercent() : "");
        if (this.table != null && this.entity != null && !this.table.getGrowthPercent().equals(this.entity.getGrowthPercent())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(GROWTH_TYPE);
        engPropertyHolder.setLeftValue(this.table != null ? this.table.getGrowthType() : "");
        engPropertyHolder.setRightValue(this.entity != null ? this.entity.getGrowthType() : "");
        if (this.table != null && this.entity != null && !this.table.getGrowthType().equals(this.entity.getGrowthType())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(NORMAL_FORM);
        engPropertyHolder.setLeftValue(this.table != null ? this.table.getNormalForm() : "");
        engPropertyHolder.setRightValue(this.entity != null ? this.entity.getNormalForm() : "");
        if (this.table != null && this.entity != null && !this.table.getNormalForm().equals(this.entity.getNormalForm())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(ADEQUATELY_NORMALIZED);
        engPropertyHolder.setLeftValue(this.table != null ? this.table.getAdequatelyNormalized() : "");
        engPropertyHolder.setRightValue(this.entity != null ? this.entity.getAdequatelyNormalized() : "");
        if (this.table != null && this.entity != null && !this.table.getAdequatelyNormalized().equals(this.entity.getAdequatelyNormalized())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
    }

    private void copyPropertiesFromEntityToTable() {
        if (this.table != null && this.entity != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(TEMP_TABLE_SCOPE)) {
                    this.entity.setScope(this.table.getScope());
                    continue;
                }
                if (engPropertyHolder.getName().equals(TABLE_TYPE)) {
                    this.entity.setTypeID(this.table.getTypeID());
                    continue;
                }
                if (engPropertyHolder.getName().equals(SHORT_NAME_ABBR)) {
                    this.entity.setShortName(this.table.getAbbreviation());
                    continue;
                }
                if (engPropertyHolder.getName().equals(STRUCTURED_TYPE)) {
                    this.entity.setBasedOnStructuredType(this.table.getBasedOnStructuredType());
                    continue;
                }
                if (engPropertyHolder.getName().equals(MIN_VOLUMES)) {
                    this.entity.setMinVolumes(this.table.getMinVolumes());
                    continue;
                }
                if (engPropertyHolder.getName().equals(EXPECTED_VOLUMES)) {
                    this.entity.setExpectedVolumes(this.table.getExpectedVolumes());
                    continue;
                }
                if (engPropertyHolder.getName().equals(MAX_VOLUMES)) {
                    this.entity.setMaxVolumes(this.table.getMaxVolumes());
                    continue;
                }
                if (engPropertyHolder.getName().equals(GROWTH_PERCENT)) {
                    this.entity.setGrowthPercent(this.table.getGrowthPercent());
                    continue;
                }
                if (engPropertyHolder.getName().equals(GROWTH_TYPE)) {
                    this.entity.setGrowthType(this.table.getGrowthType());
                    continue;
                }
                if (engPropertyHolder.getName().equals(NORMAL_FORM)) {
                    this.entity.setNormalForm(this.table.getNormalForm());
                    continue;
                }
                if (!engPropertyHolder.getName().equals(ADEQUATELY_NORMALIZED)) continue;
                this.entity.setAdequatelyNormalized(this.table.getAdequatelyNormalized());
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.table != null ? MessageFormat.format(Messages.getString("TableEntityComparator.Table"), this.table.getName()) : "";
    }

    @Override
    public String getRightName() {
        return this.entity != null ? MessageFormat.format(Messages.getString("TableEntityComparator.Entity"), this.entity.getName()) : "";
    }
}

