/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.List;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.engineering.FWDEngineering;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;

public class RelationFKComparator
extends EngPropertiesComparator {
    private Relation rel;
    private FKIndexAssociation fk;
    private boolean mandatoryDefined = false;

    public RelationFKComparator(Relation relation, FKIndexAssociation fKIndexAssociation) {
        super(relation, fKIndexAssociation);
        this.rel = relation;
        this.fk = fKIndexAssociation;
        this.initPropertiesList();
    }

    public RelationFKComparator(Relation relation, FKIndexAssociation fKIndexAssociation, List list) {
        this(relation, fKIndexAssociation);
        this.applyCompareFilter(list, relation.getDesign().getShowSelPropsOnly());
    }

    @Override
    public void copySelectedProperties() {
        if (!this.isReadOnly()) {
            this.copyPropertiesFromLeftToRight();
            if (this.isMandatoryDefined() && this.rel != null && this.fk != null) {
                for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                    if (!engPropertyHolder.isSelected()) continue;
                    if (engPropertyHolder.getName().equals(MANDATORY)) {
                        String string = engPropertyHolder.getLeftValue();
                        try {
                            this.fk.setMandatory(Boolean.valueOf(string));
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (!engPropertyHolder.getName().equals(DELETE_RULE)) continue;
                    this.fk.setDeleteRule(engPropertyHolder.getLeftValue());
                }
            }
        }
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        this.initMandatory();
        this.initDeleteRule();
        this.initCommentsAndNotes();
    }

    @Override
    protected void initNameProperty() {
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(NAME);
        engPropertyHolder.setLeftValue(this.rel != null ? this.rel.getName() : "");
        engPropertyHolder.setRightValue(this.fk != null ? this.fk.getName() : "");
        if (this.rel != null && this.fk != null && !this.rel.getName().equals(this.fk.getName())) {
            if (this.getDesign().isApplyNameStandardization()) {
                String string = "";
                string = this.rel.getDesignPart() instanceof LogicalDesign ? this.getDesign().transformNameFromLogicalToRelational(this.rel) : this.getDesign().transformNameFromRelationalToLogical(this.rel);
                if (!string.equals(this.fk.getName())) {
                    engPropertyHolder.setModified(true);
                    engPropertyHolder.setSelected(true);
                }
            } else {
                engPropertyHolder.setModified(true);
                engPropertyHolder.setSelected(true);
            }
        }
        this.propertiesList.add(engPropertyHolder);
    }

    private void initMandatory() {
        Object object;
        String string = "";
        if (this.fk != null) {
            string = String.valueOf(this.fk.isMandatory());
        }
        String string2 = "";
        if (this.rel != null && ((int[])(object = this.rel.getPKProviderEndPoint())).length == 1) {
            int n = object[0];
            int n2 = this.rel.getOtherEndPoint(n);
            string2 = String.valueOf(!this.rel.isOptional(n2));
            this.mandatoryDefined = true;
        }
        if (this.mandatoryDefined) {
            object = new PropertyHolder(MANDATORY);
            ((EngPropertyHolder)object).setLeftValue(string2);
            ((EngPropertyHolder)object).setRightValue(string);
            if (!string2.equalsIgnoreCase(string)) {
                ((EngPropertyHolder)object).setModified(true);
                ((EngPropertyHolder)object).setSelected(true);
                ((EngPropertyHolder)object).setEditable(true);
            }
            this.propertiesList.add(object);
        }
    }

    public boolean isMandatoryDefined() {
        return this.mandatoryDefined;
    }

    private void initDeleteRule() {
        PropertyHolder propertyHolder = new PropertyHolder(DELETE_RULE);
        String string = "";
        if (this.fk != null) {
            string = this.fk.getDeleteRule();
        }
        boolean bl = false;
        String string2 = "";
        if (this.rel != null) {
            int[] nArray = this.rel.getPKProviderEndPoint();
            int n = nArray[0];
            if (nArray.length == 2 && this.fk != null) {
                Entity entity = this.rel.getEntity(n);
                if (!this.fk.getTable().hasMappingWithEntity(entity)) {
                    n = this.rel.getOtherEndPoint(n);
                }
            }
            if (this.fk != null) {
                string2 = FWDEngineering.getDeleteRule(this.rel, this.fk, n);
                int n2 = this.rel.getOtherEndPoint(n);
                bl = this.rel.getOptional(n2);
            }
        }
        propertyHolder.setLeftValue(string2);
        propertyHolder.setRightValue(string);
        if (!string2.equalsIgnoreCase(string)) {
            propertyHolder.setModified(bl);
            propertyHolder.setSelected(bl);
            propertyHolder.setEditable(bl);
        }
        this.propertiesList.add(propertyHolder);
    }
}

