/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.GeneralPropertiesComparator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.engineering.ColumnAttributeComparator;
import oracle.dbtools.crest.model.design.engineering.DesignObjectComparator;
import oracle.dbtools.crest.model.design.engineering.EngEmptyPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngFilteredSelection;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngineeringObjectSelection;
import oracle.dbtools.crest.model.design.engineering.FK_RelationComparator;
import oracle.dbtools.crest.model.design.engineering.IndexKeyComparator;
import oracle.dbtools.crest.model.design.engineering.TableEntityComparator;
import oracle.dbtools.crest.model.design.engineering.TableSubviewEntitySubviewComparator;
import oracle.dbtools.crest.model.design.engineering.TableViewEntityViewComparator;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.metadata.ID_ObjectPropertyTranslator;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMapBase;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.logical.DPVLogicalSubView;
import oracle.dbtools.crest.swingui.relational.DPVRelationalSubView;

public class RE_RelationalToLogical
extends EngineeringObjectSelection {
    private static String NO_ENGINEERING = "no engineering";
    private RelationalDesign phdes;
    LogicalDesign ldes;
    private EngineeringObjectSelection logicalRoot;
    private Map comparatorsMap = new TreeMap();
    private List deletedMappings = new ArrayList();
    private Map multiMapped = new TreeMap();

    public RE_RelationalToLogical(RelationalDesign relationalDesign) {
        super(relationalDesign.getName());
        this.setDesign(relationalDesign.getDesign());
        this.phdes = relationalDesign;
        this.setName(relationalDesign.getName());
        this.ldes = relationalDesign.getDesign().getLogicalDesign();
        this.logicalRoot = new EngineeringObjectSelection(this.ldes.getName());
        this.logicalRoot.setName(this.ldes.getName());
        this.setCorrespondentNode(this.logicalRoot);
        this.logicalRoot.setCorrespondentNode(this);
        this.setEmptyComparator(this);
        this.setEmptyComparator(this.logicalRoot);
        this.addFromRelationalModel();
    }

    private void setEmptyComparator(EngineeringObjectSelection engineeringObjectSelection) {
        engineeringObjectSelection.setPropertiesComparator(new EngEmptyPropertiesComparator(null, null));
    }

    private void addTableMulti(Table table, EngineeringObjectSelection engineeringObjectSelection, EngineeringObjectSelection engineeringObjectSelection2, boolean bl) {
        String string = this.ldes.getObjectID();
        List list = this.ldes.getDesign().getExtendedMap().getMappingsForDesignPart(table, string);
        for (XtdMapping xtdMapping : list) {
            Object object;
            DesignObject designObject = xtdMapping.getObjectMappedTo(table);
            if (!(designObject instanceof Entity)) continue;
            EngineeringObjectSelection engineeringObjectSelection3 = new EngineeringObjectSelection((ModelIDObject)table, xtdMapping);
            Entity entity = (Entity)designObject;
            EngineeringObjectSelection engineeringObjectSelection4 = null;
            Relation relation = table.getEngRelation();
            if (entity != null) {
                engineeringObjectSelection4 = new EngineeringObjectSelection(entity);
                object = new TableEntityComparator(table, entity, table.getDesign().getEntTablePropertyList());
                engineeringObjectSelection3.setPropertiesComparator((GeneralPropertiesComparator)object);
                engineeringObjectSelection4.setPropertiesComparator((GeneralPropertiesComparator)object);
                this.comparatorsMap.put(((EngPropertiesComparator)object).getID(), object);
            } else if (relation != null || table.isMtoNjoinCandidate()) {
                if (relation == null) {
                    engineeringObjectSelection4 = new EngineeringObjectSelection(NEW_RELATION);
                    engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_NEW);
                    engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_NEW);
                    object = new DesignObjectComparator(table, relation, table.getDesign().getRelFKPropertyList());
                    engineeringObjectSelection3.setPropertiesComparator((GeneralPropertiesComparator)object);
                    engineeringObjectSelection4.setPropertiesComparator((GeneralPropertiesComparator)object);
                } else {
                    engineeringObjectSelection4 = new EngineeringObjectSelection(relation);
                    engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_UNCHANGED);
                    engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_UNCHANGED);
                    object = new DesignObjectComparator(table, relation, table.getDesign().getRelFKPropertyList());
                    engineeringObjectSelection3.setPropertiesComparator((GeneralPropertiesComparator)object);
                    engineeringObjectSelection4.setPropertiesComparator((GeneralPropertiesComparator)object);
                    this.comparatorsMap.put(((EngPropertiesComparator)object).getID(), object);
                }
                engineeringObjectSelection4.setElementDescriptor(Relation.class);
            } else if (relation == null && !table.isMtoNjoinCandidate()) {
                object = this.getDesign().transformNameFromRelationalToLogical(table);
                engineeringObjectSelection4 = new EngineeringObjectSelection((String)object);
                engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_NEW);
                engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_NEW);
                engineeringObjectSelection4.setElementDescriptor(Entity.class);
                TableEntityComparator tableEntityComparator = new TableEntityComparator(table, entity, table.getDesign().getEntTablePropertyList());
                engineeringObjectSelection3.setPropertiesComparator(tableEntityComparator);
                engineeringObjectSelection4.setPropertiesComparator(tableEntityComparator);
                this.comparatorsMap.put(tableEntityComparator.getID(), tableEntityComparator);
            }
            engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
            engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
            if (bl && table != null && relation == null) {
                this.addTableDetails(table, engineeringObjectSelection3, entity, engineeringObjectSelection4, xtdMapping);
            }
            engineeringObjectSelection.addChild(engineeringObjectSelection3);
            engineeringObjectSelection2.addChild(engineeringObjectSelection4);
        }
    }

    private void addTable(Table table, EngineeringObjectSelection engineeringObjectSelection, EngineeringObjectSelection engineeringObjectSelection2, boolean bl) {
        List list = table.getMappingsToEntities();
        int n = 0;
        do {
            Object object;
            XtdMapping xtdMapping = null;
            DesignObject designObject = null;
            if (n < list.size() && !((designObject = (xtdMapping = (XtdMapping)list.get(n)).getObjectMappedTo(table)) instanceof Entity)) {
                ++n;
                continue;
            }
            ++n;
            EngineeringObjectSelection engineeringObjectSelection3 = new EngineeringObjectSelection((ModelIDObject)table, xtdMapping);
            engineeringObjectSelection3.setSelected(table.getShouldEngineer());
            Entity entity = (Entity)designObject;
            EngineeringObjectSelection engineeringObjectSelection4 = null;
            Relation relation = table.getEngRelation();
            if (list.size() > 0 && entity != null) {
                if (table == null || !table.shouldBeEngineered() && table.getDesign().getExcludeFromTree()) continue;
                engineeringObjectSelection4 = new EngineeringObjectSelection(entity);
                object = new TableEntityComparator(table, entity, table.getDesign().getEntTablePropertyList());
                engineeringObjectSelection3.setPropertiesComparator((GeneralPropertiesComparator)object);
                engineeringObjectSelection4.setPropertiesComparator((GeneralPropertiesComparator)object);
                this.comparatorsMap.put(((EngPropertiesComparator)object).getID(), object);
                engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
                engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
                if (bl) {
                    this.addTableDetails(table, engineeringObjectSelection3, entity, engineeringObjectSelection4, xtdMapping);
                }
                engineeringObjectSelection.addChild(engineeringObjectSelection3);
                engineeringObjectSelection2.addChild(engineeringObjectSelection4);
                if (xtdMapping.getInheritanceType() <= 0) continue;
                if (xtdMapping.getInheritanceType() == 1) {
                    if (!entity.getFwdEngineeringStrategyName().equals("Single Table")) continue;
                    if (entity.isHierarchicalRoot()) {
                        engineeringObjectSelection3.setSelected(true);
                        continue;
                    }
                    engineeringObjectSelection3.setSelected(false);
                    continue;
                }
                if (xtdMapping.getInheritanceType() != 2 || !entity.getFwdEngineeringStrategyName().equals("Table per child")) continue;
                if (entity.getHierarchicalChildrenCount() == 0) {
                    engineeringObjectSelection3.setSelected(true);
                    continue;
                }
                engineeringObjectSelection3.setSelected(false);
                continue;
            }
            if (relation != null || table.isMtoNjoinCandidate()) {
                if (relation == null) {
                    engineeringObjectSelection4 = new EngineeringObjectSelection(NEW_RELATION);
                    engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_NEW);
                    engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_NEW);
                    object = new DesignObjectComparator(table, relation, table.getDesign().getRelFKPropertyList());
                    engineeringObjectSelection3.setPropertiesComparator((GeneralPropertiesComparator)object);
                    engineeringObjectSelection4.setPropertiesComparator((GeneralPropertiesComparator)object);
                } else if (relation.shouldBeEngineered() || !relation.getDesign().getExcludeFromTree()) {
                    engineeringObjectSelection4 = new EngineeringObjectSelection(relation);
                    engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_UNCHANGED);
                    engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_UNCHANGED);
                    object = new DesignObjectComparator(table, relation, table.getDesign().getRelFKPropertyList());
                    engineeringObjectSelection3.setPropertiesComparator((GeneralPropertiesComparator)object);
                    engineeringObjectSelection4.setPropertiesComparator((GeneralPropertiesComparator)object);
                    this.comparatorsMap.put(((EngPropertiesComparator)object).getID(), object);
                }
                if (engineeringObjectSelection4 != null) {
                    engineeringObjectSelection4.setElementDescriptor(Relation.class);
                    engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
                    engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
                }
                if (!bl || table != null) {
                    // empty if block
                }
                engineeringObjectSelection.addChild(engineeringObjectSelection3);
                engineeringObjectSelection2.addChild(engineeringObjectSelection4);
                continue;
            }
            if (relation != null || table.isMtoNjoinCandidate() || !table.shouldBeEngineered() && table.getDesign().getExcludeFromTree()) continue;
            object = this.getDesign().transformNameFromRelationalToLogical(table);
            engineeringObjectSelection4 = new EngineeringObjectSelection((String)object);
            engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_NEW);
            engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_NEW);
            engineeringObjectSelection4.setElementDescriptor(Entity.class);
            TableEntityComparator tableEntityComparator = new TableEntityComparator(table, entity, table.getDesign().getEntTablePropertyList());
            engineeringObjectSelection3.setPropertiesComparator(tableEntityComparator);
            engineeringObjectSelection4.setPropertiesComparator(tableEntityComparator);
            this.comparatorsMap.put(tableEntityComparator.getID(), tableEntityComparator);
            engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
            engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
            if (bl && table != null) {
                this.addTableDetails(table, engineeringObjectSelection3, entity, engineeringObjectSelection4, xtdMapping);
            }
            engineeringObjectSelection.addChild(engineeringObjectSelection3);
            engineeringObjectSelection2.addChild(engineeringObjectSelection4);
        } while (n < list.size());
    }

    private void addTableView(TableView tableView, EngineeringObjectSelection engineeringObjectSelection, EngineeringObjectSelection engineeringObjectSelection2) {
        EngineeringObjectSelection engineeringObjectSelection3 = new EngineeringObjectSelection(tableView);
        engineeringObjectSelection3.setSelected(tableView.getShouldEngineer());
        EntityView entityView = tableView.getEngEntityView();
        EngineeringObjectSelection engineeringObjectSelection4 = null;
        if (entityView != null) {
            if (tableView.getShouldEngineer() || !tableView.getDesign().getExcludeFromTree()) {
                engineeringObjectSelection4 = new EngineeringObjectSelection(entityView);
                TableViewEntityViewComparator tableViewEntityViewComparator = new TableViewEntityViewComparator(tableView, entityView, tableView.getDesign().getViewPropertyList());
                engineeringObjectSelection3.setPropertiesComparator(tableViewEntityViewComparator);
                engineeringObjectSelection4.setPropertiesComparator(tableViewEntityViewComparator);
                this.comparatorsMap.put(tableViewEntityViewComparator.getID(), tableViewEntityViewComparator);
                engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
                engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
                engineeringObjectSelection.addChild(engineeringObjectSelection3);
                engineeringObjectSelection2.addChild(engineeringObjectSelection4);
            }
        } else if (tableView.getShouldEngineer() || !tableView.getDesign().getExcludeFromTree()) {
            String string = this.getDesign().transformNameFromRelationalToLogical(tableView);
            engineeringObjectSelection4 = new EngineeringObjectSelection(string);
            engineeringObjectSelection4.setElementDescriptor(EntityView.class);
            TableViewEntityViewComparator tableViewEntityViewComparator = new TableViewEntityViewComparator(tableView, entityView, tableView.getDesign().getViewPropertyList());
            engineeringObjectSelection3.setPropertiesComparator(tableViewEntityViewComparator);
            engineeringObjectSelection4.setPropertiesComparator(tableViewEntityViewComparator);
            this.comparatorsMap.put(tableViewEntityViewComparator.getID(), tableViewEntityViewComparator);
            engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_NEW);
            engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_NEW);
            engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
            engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
            engineeringObjectSelection.addChild(engineeringObjectSelection3);
            engineeringObjectSelection2.addChild(engineeringObjectSelection4);
        }
    }

    private void addFK(FKIndexAssociation fKIndexAssociation, EngineeringObjectSelection engineeringObjectSelection, EngineeringObjectSelection engineeringObjectSelection2) {
        if (fKIndexAssociation.getEngInheritanceRelation() != null) {
            return;
        }
        EngineeringObjectSelection engineeringObjectSelection3 = new EngineeringObjectSelection(fKIndexAssociation);
        String string = fKIndexAssociation.getName() + " (" + fKIndexAssociation.getContainerWithKeyObject().getName() + " : " + fKIndexAssociation.getRemoteTable().getName() + " )";
        engineeringObjectSelection3.setName(string);
        engineeringObjectSelection3.setSelected(fKIndexAssociation.getShouldEngineer());
        Relation relation = fKIndexAssociation.getEngRelation();
        EngineeringObjectSelection engineeringObjectSelection4 = null;
        if (relation != null) {
            if (fKIndexAssociation.shouldBeEngineered() || !fKIndexAssociation.getDesign().getExcludeFromTree()) {
                engineeringObjectSelection4 = new EngineeringObjectSelection(relation);
                FK_RelationComparator fK_RelationComparator = new FK_RelationComparator(fKIndexAssociation, relation, fKIndexAssociation.getDesign().getRelFKPropertyList());
                engineeringObjectSelection3.setPropertiesComparator(fK_RelationComparator);
                engineeringObjectSelection4.setPropertiesComparator(fK_RelationComparator);
                Entity entity = ((Table)fKIndexAssociation.getContainerWithKeyObject()).getEngEntity();
                Entity entity2 = fKIndexAssociation.getRemoteTable().getEngEntity();
                if (entity != null && entity2 != null) {
                    String string2 = relation.getName() + " (" + entity.getName() + " : " + entity2.getName() + ")";
                    engineeringObjectSelection4.setName(string2);
                }
                this.comparatorsMap.put(fK_RelationComparator.getID(), fK_RelationComparator);
                engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
                engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
                engineeringObjectSelection.addChild(engineeringObjectSelection3);
                engineeringObjectSelection2.addChild(engineeringObjectSelection4);
            }
        } else if (fKIndexAssociation.shouldBeEngineered() || !fKIndexAssociation.getDesign().getExcludeFromTree()) {
            engineeringObjectSelection4 = new EngineeringObjectSelection(NEW_RELATION);
            engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_NEW);
            engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_NEW);
            engineeringObjectSelection4.setElementDescriptor(Relation.class);
            DesignObjectComparator designObjectComparator = new DesignObjectComparator(fKIndexAssociation, relation, fKIndexAssociation.getDesign().getRelFKPropertyList());
            engineeringObjectSelection3.setPropertiesComparator(designObjectComparator);
            engineeringObjectSelection4.setPropertiesComparator(designObjectComparator);
            engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
            engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
            engineeringObjectSelection.addChild(engineeringObjectSelection3);
            engineeringObjectSelection2.addChild(engineeringObjectSelection4);
        }
    }

    private void addFromRelationalModel() {
        ID_ObjectPropertyTranslator iD_ObjectPropertyTranslator;
        DesignObject designObject;
        ModelObject modelObject2;
        EngFilteredSelection engFilteredSelection;
        Iterator iterator;
        List list = this.getTablesWitnMultiMappings();
        if (list.size() > 0) {
            iterator = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.TablesWithMultipleMappings"));
            ((ModelObject)((Object)iterator)).setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
            engFilteredSelection = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.Entities"));
            engFilteredSelection.setIcon(GUIConfiguration.getInstance().getIcon("ENTITY_FOLDER_ICON"));
            ((EngineeringObjectSelection)((Object)iterator)).setCorrespondentNode(engFilteredSelection);
            engFilteredSelection.setCorrespondentNode((EngineeringObjectSelection)((Object)iterator));
            this.setEmptyComparator((EngineeringObjectSelection)((Object)iterator));
            this.setEmptyComparator(engFilteredSelection);
            for (ModelObject modelObject2 : list) {
                this.addTableMulti((Table)modelObject2, (EngineeringObjectSelection)((Object)iterator), engFilteredSelection, true);
            }
            this.addChild((ModelIdObjectSelection)((Object)iterator));
            this.logicalRoot.addChild(engFilteredSelection);
        }
        iterator = this.getTablesToNoneHierarchicalEntity().iterator();
        engFilteredSelection = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.Tables"));
        engFilteredSelection.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
        Object object = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.Entities"));
        ((ModelObject)object).setIcon(GUIConfiguration.getInstance().getIcon("ENTITY_FOLDER_ICON"));
        modelObject2 = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.Views"));
        modelObject2.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON"));
        EngFilteredSelection engFilteredSelection2 = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.Views"));
        engFilteredSelection2.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON"));
        EngFilteredSelection engFilteredSelection3 = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.Subviews"));
        engFilteredSelection3.setIcon(GUIConfiguration.getInstance().getIcon("SUBVIEW_ICON"));
        EngFilteredSelection engFilteredSelection4 = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.Subviews"));
        engFilteredSelection4.setIcon(GUIConfiguration.getInstance().getIcon("SUBVIEW_ICON"));
        engFilteredSelection.setCorrespondentNode((EngineeringObjectSelection)object);
        ((EngineeringObjectSelection)object).setCorrespondentNode(engFilteredSelection);
        ((EngineeringObjectSelection)modelObject2).setCorrespondentNode(engFilteredSelection2);
        engFilteredSelection2.setCorrespondentNode((EngineeringObjectSelection)modelObject2);
        engFilteredSelection3.setCorrespondentNode(engFilteredSelection4);
        engFilteredSelection4.setCorrespondentNode(engFilteredSelection3);
        this.setEmptyComparator((EngineeringObjectSelection)object);
        this.setEmptyComparator(engFilteredSelection2);
        this.setEmptyComparator(engFilteredSelection4);
        ((EngineeringObjectSelection)object).setSelected(false);
        engFilteredSelection2.setSelected(false);
        engFilteredSelection4.setSelected(false);
        this.setEmptyComparator(engFilteredSelection);
        this.setEmptyComparator((EngineeringObjectSelection)modelObject2);
        this.setEmptyComparator(engFilteredSelection3);
        while (iterator.hasNext()) {
            designObject = (Table)iterator.next();
            this.addTable((Table)designObject, engFilteredSelection, (EngineeringObjectSelection)object, true);
        }
        iterator = this.phdes.getTableViewSet().iterator();
        while (iterator.hasNext()) {
            designObject = (TableView)iterator.next();
            this.addTableView((TableView)designObject, (EngineeringObjectSelection)modelObject2, engFilteredSelection2);
        }
        iterator = this.phdes.getPhysicalDesignSubviews().iterator();
        while (iterator.hasNext()) {
            designObject = (DesignPartViewPlaceHolder)iterator.next();
            iD_ObjectPropertyTranslator = (DPVRelationalSubView)((DesignPartViewPlaceHolder)designObject).getDesignPartView();
            this.addTableSubView((DPVRelationalSubView)iD_ObjectPropertyTranslator, engFilteredSelection3, engFilteredSelection4);
        }
        this.addDeletedTables(engFilteredSelection, (EngineeringObjectSelection)object);
        this.addChild(engFilteredSelection);
        this.logicalRoot.addChild((ModelIdObjectSelection)object);
        iterator = this.getTablesMappetToRelations().iterator();
        engFilteredSelection = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.TablesMappedToRelations"));
        engFilteredSelection.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
        object = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.Relations"));
        ((ModelObject)object).setIcon(GUIConfiguration.getInstance().getIcon("ONE_TO_N_RELATION_ICON"));
        engFilteredSelection.setCorrespondentNode((EngineeringObjectSelection)object);
        ((EngineeringObjectSelection)object).setCorrespondentNode(engFilteredSelection);
        this.setEmptyComparator((EngineeringObjectSelection)object);
        ((EngineeringObjectSelection)object).setSelected(false);
        this.setEmptyComparator(engFilteredSelection);
        while (iterator.hasNext()) {
            designObject = (Table)iterator.next();
            this.addTable((Table)designObject, engFilteredSelection, (EngineeringObjectSelection)object, false);
        }
        this.addChild(engFilteredSelection);
        this.logicalRoot.addChild((ModelIdObjectSelection)object);
        iterator = this.getTablesToEntHierarchies().iterator();
        engFilteredSelection = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.TablesMappedToHierarchies"));
        engFilteredSelection.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
        object = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.EntitiesHierarchies"));
        ((ModelObject)object).setIcon(GUIConfiguration.getInstance().getIcon("HIERARCHY_ICON"));
        engFilteredSelection.setCorrespondentNode((EngineeringObjectSelection)object);
        ((EngineeringObjectSelection)object).setCorrespondentNode(engFilteredSelection);
        this.setEmptyComparator((EngineeringObjectSelection)object);
        ((EngineeringObjectSelection)object).setSelected(false);
        this.setEmptyComparator(engFilteredSelection);
        while (iterator.hasNext()) {
            designObject = (Table)iterator.next();
            this.addTable((Table)designObject, engFilteredSelection, (EngineeringObjectSelection)object, true);
        }
        this.addChild(engFilteredSelection);
        this.logicalRoot.addChild((ModelIdObjectSelection)object);
        iterator = this.phdes.getFKIndexAssociationSet().iterator();
        engFilteredSelection = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.References"));
        engFilteredSelection.setIcon(GUIConfiguration.getInstance().getIcon("M_TO_N_RELATION_ICON"));
        object = new EngFilteredSelection(Messages.getString("RE_RelationalToLogical.Relations"));
        ((ModelObject)object).setIcon(GUIConfiguration.getInstance().getIcon("M_TO_N_RELATION_ICON"));
        engFilteredSelection.setCorrespondentNode((EngineeringObjectSelection)object);
        ((EngineeringObjectSelection)object).setCorrespondentNode(engFilteredSelection);
        this.setEmptyComparator((EngineeringObjectSelection)object);
        ((EngineeringObjectSelection)object).setSelected(false);
        this.setEmptyComparator(engFilteredSelection);
        while (iterator.hasNext()) {
            designObject = (FKIndexAssociation)iterator.next();
            iD_ObjectPropertyTranslator = ((FKIndexAssociation)designObject).getTable();
            if (((Table)iD_ObjectPropertyTranslator).getEngRelation() != null) continue;
            this.addFK((FKIndexAssociation)designObject, engFilteredSelection, (EngineeringObjectSelection)object);
        }
        this.addChild(engFilteredSelection);
        this.logicalRoot.addChild((ModelIdObjectSelection)object);
        this.addDeletedTableViews((EngineeringObjectSelection)modelObject2, engFilteredSelection2);
        this.addChild((ModelIdObjectSelection)modelObject2);
        this.logicalRoot.addChild(engFilteredSelection2);
        this.addDeletedTableSubViews(engFilteredSelection3, engFilteredSelection4);
        this.addChild(engFilteredSelection3);
        this.logicalRoot.addChild(engFilteredSelection4);
    }

    private void addColumn(Column column, Entity entity, EngineeringObjectSelection engineeringObjectSelection, EngineeringObjectSelection engineeringObjectSelection2, XtdMapping xtdMapping) {
        List list = column.getMappingsFor(entity);
        int n = 0;
        do {
            XtdMapping xtdMapping2 = null;
            DesignObject designObject = null;
            if (n < list.size() && !((designObject = (xtdMapping2 = (XtdMapping)list.get(n)).getObjectMappedTo(column)) instanceof Attribute)) {
                ++n;
                continue;
            }
            EngineeringObjectSelection engineeringObjectSelection3 = new EngineeringObjectSelection(column, xtdMapping2, xtdMapping);
            engineeringObjectSelection3.setSelected(column.getShouldEngineer());
            EngineeringObjectSelection engineeringObjectSelection4 = null;
            Attribute attribute = null;
            if (entity != null && xtdMapping2 != null && (attribute = (Attribute)designObject) != null) {
                engineeringObjectSelection4 = new EngineeringObjectSelection(attribute);
                ColumnAttributeComparator columnAttributeComparator = new ColumnAttributeComparator(column, attribute, column.getDesign().getAttrColPropertyList());
                engineeringObjectSelection3.setPropertiesComparator(columnAttributeComparator);
                engineeringObjectSelection4.setPropertiesComparator(columnAttributeComparator);
                this.comparatorsMap.put(columnAttributeComparator.getID(), columnAttributeComparator);
            }
            if (attribute == null) {
                Object object;
                Object object2;
                attribute = column.getEngAttribute();
                boolean bl = false;
                if (attribute != null && entity != null && entity.isHierarchicalEntityType()) {
                    bl = entity.hasHierarchicalRelationWith((Entity)attribute.getContainerWithKeyObject());
                }
                Attribute attribute2 = null;
                if (!bl && (object2 = column.getDesign().getExtendedMap().getMappingsForDesignPart(column, column.getDesign().getLogicalDesign().getObjectID())).size() == 1) {
                    object = (XtdMapping)object2.get(0);
                    bl = ((XtdMapping)object).getInheritanceType() == 5;
                    DesignObject designObject2 = ((XtdMapping)object).getObjectMappedTo(column);
                    if (designObject instanceof Attribute) {
                        attribute2 = (Attribute)designObject2;
                    }
                }
                if (bl) {
                    object2 = NO_ENGINEERING;
                    engineeringObjectSelection4 = new EngineeringObjectSelection((String)object2);
                    engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_UNCHANGED);
                    engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_UNCHANGED);
                    engineeringObjectSelection3.setSelected(false);
                    object = null;
                    object = attribute2 != null ? new ColumnAttributeComparator(column, attribute2, column.getDesign().getAttrColPropertyList()) : new ColumnAttributeComparator(column, attribute, column.getDesign().getAttrColPropertyList());
                    ((EngPropertiesComparator)object).setReadOnly(true);
                    engineeringObjectSelection3.setEditable(false);
                    engineeringObjectSelection3.setPropertiesComparator((GeneralPropertiesComparator)object);
                    engineeringObjectSelection4.setPropertiesComparator((GeneralPropertiesComparator)object);
                } else {
                    object2 = this.getDesign().transformNameFromRelationalToLogical(column);
                    engineeringObjectSelection4 = new EngineeringObjectSelection((String)object2);
                    engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_NEW);
                    engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_NEW);
                    object = new ColumnAttributeComparator(column, attribute, column.getDesign().getAttrColPropertyList());
                    engineeringObjectSelection3.setPropertiesComparator((GeneralPropertiesComparator)object);
                    engineeringObjectSelection4.setPropertiesComparator((GeneralPropertiesComparator)object);
                    this.comparatorsMap.put(((EngPropertiesComparator)object).getID(), object);
                }
                engineeringObjectSelection4.setElementDescriptor(Attribute.class);
                if (entity == null || !this.getDesign().isApplyNameStandardization()) {
                    // empty if block
                }
            }
            engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
            engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
            engineeringObjectSelection.addChild(engineeringObjectSelection3);
            engineeringObjectSelection2.addChild(engineeringObjectSelection4);
            ++n;
        } while (n < list.size());
    }

    private void addTableDetails(Table table, EngineeringObjectSelection engineeringObjectSelection, Entity entity, EngineeringObjectSelection engineeringObjectSelection2, XtdMapping xtdMapping) {
        ModelObject modelObject2;
        EngineeringObjectSelection engineeringObjectSelection3 = new EngineeringObjectSelection(Messages.getString("RE_RelationalToLogical.Columns"));
        engineeringObjectSelection3.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_FOLDER_ICON"));
        EngineeringObjectSelection engineeringObjectSelection4 = new EngineeringObjectSelection(Messages.getString("RE_RelationalToLogical.Attributes"));
        engineeringObjectSelection4.setIcon(GUIConfiguration.getInstance().getIcon("ATTRIBUTE_FOLDER_ICON"));
        engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
        engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
        this.setEmptyComparator(engineeringObjectSelection3);
        this.setEmptyComparator(engineeringObjectSelection4);
        engineeringObjectSelection4.setSelected(false);
        for (ModelObject modelObject2 : table.getElementsCollection()) {
            this.addColumn((Column)modelObject2, entity, engineeringObjectSelection3, engineeringObjectSelection4, xtdMapping);
        }
        if (entity != null) {
            this.addDeletedColumns(table, engineeringObjectSelection3, entity, engineeringObjectSelection4);
        }
        engineeringObjectSelection.addChild(engineeringObjectSelection3);
        engineeringObjectSelection2.addChild(engineeringObjectSelection4);
        modelObject2 = new EngineeringObjectSelection(Messages.getString("RE_RelationalToLogical.PKAndUKConstraints"));
        modelObject2.setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON"));
        EngineeringObjectSelection engineeringObjectSelection5 = new EngineeringObjectSelection(Messages.getString("RE_RelationalToLogical.Keys"));
        engineeringObjectSelection5.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON"));
        ((EngineeringObjectSelection)modelObject2).setCorrespondentNode(engineeringObjectSelection5);
        engineeringObjectSelection5.setCorrespondentNode((EngineeringObjectSelection)modelObject2);
        this.setEmptyComparator((EngineeringObjectSelection)modelObject2);
        this.setEmptyComparator(engineeringObjectSelection5);
        engineeringObjectSelection5.setSelected(false);
        for (Index index : table.getPKandUKConstraints()) {
            this.addIndex(index, entity, (EngineeringObjectSelection)modelObject2, engineeringObjectSelection5, xtdMapping);
        }
        if (entity != null) {
            this.addDeletedIndexes(table, (EngineeringObjectSelection)modelObject2, entity, engineeringObjectSelection5);
        }
        engineeringObjectSelection.addChild((ModelIdObjectSelection)modelObject2);
        engineeringObjectSelection2.addChild(engineeringObjectSelection5);
    }

    private void addIndex(Index index, Entity entity, EngineeringObjectSelection engineeringObjectSelection, EngineeringObjectSelection engineeringObjectSelection2, XtdMapping xtdMapping) {
        XtdMapping xtdMapping2 = index.getMappingFor(entity);
        EngineeringObjectSelection engineeringObjectSelection3 = new EngineeringObjectSelection(index, xtdMapping2, xtdMapping);
        EngineeringObjectSelection engineeringObjectSelection4 = null;
        CandidateKey candidateKey = null;
        if (entity != null && (candidateKey = index.getEngCandidateKey(entity)) != null) {
            engineeringObjectSelection4 = new EngineeringObjectSelection(candidateKey);
            IndexKeyComparator indexKeyComparator = new IndexKeyComparator(index, candidateKey, index.getDesign().getKeyIdxPropertyList());
            engineeringObjectSelection3.setPropertiesComparator(indexKeyComparator);
            engineeringObjectSelection4.setPropertiesComparator(indexKeyComparator);
            this.comparatorsMap.put(indexKeyComparator.getID(), indexKeyComparator);
        }
        if (candidateKey == null || candidateKey != null && candidateKey.isPK() && entity.isHierarchicalEntityType()) {
            Object object;
            if (candidateKey == null) {
                candidateKey = index.getEngCandidateKey();
            }
            boolean bl = false;
            if (candidateKey != null && entity != null && entity.isHierarchicalEntityType()) {
                bl = entity.hasHierarchicalRelationWith((Entity)candidateKey.getContainerWithKeyObject());
            }
            if (bl) {
                engineeringObjectSelection4 = new EngineeringObjectSelection(NO_ENGINEERING);
                engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_UNCHANGED);
                engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_UNCHANGED);
            } else {
                object = this.getDesign().transformNameFromRelationalToLogical(index);
                engineeringObjectSelection4 = new EngineeringObjectSelection((String)object);
                engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_NEW);
                engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_NEW);
            }
            engineeringObjectSelection4.setElementDescriptor(CandidateKey.class);
            if (entity != null) {
                // empty if block
            }
            object = new IndexKeyComparator(index, candidateKey, index.getDesign().getKeyIdxPropertyList());
            engineeringObjectSelection3.setPropertiesComparator((GeneralPropertiesComparator)object);
            engineeringObjectSelection4.setPropertiesComparator((GeneralPropertiesComparator)object);
            this.comparatorsMap.put(((EngPropertiesComparator)object).getID(), object);
            if (bl) {
                ((EngPropertiesComparator)object).setReadOnly(true);
                engineeringObjectSelection3.setSelected(false);
                engineeringObjectSelection3.setEditable(false);
            }
        }
        engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
        engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
        engineeringObjectSelection2.addChild(engineeringObjectSelection4);
        engineeringObjectSelection.addChild(engineeringObjectSelection3);
    }

    public EngineeringObjectSelection getRelationalRoot() {
        return this;
    }

    public EngineeringObjectSelection getLogicalRoot() {
        return this.logicalRoot;
    }

    public Map getComparatorsMap() {
        return this.comparatorsMap;
    }

    private void addDeletedColumns(Table table, EngineeringObjectSelection engineeringObjectSelection, Entity entity, EngineeringObjectSelection engineeringObjectSelection2) {
        for (Attribute attribute : entity.getElementsCollection()) {
            XtdMapping xtdMapping = attribute.getDeletedMapping(table);
            if (xtdMapping == null || xtdMapping.getDeletedID() == null) continue;
            String string = xtdMapping.getNameFor(xtdMapping.getDeletedID());
            EngineeringObjectSelection engineeringObjectSelection3 = new EngineeringObjectSelection(string);
            this.deletedMappings.add(engineeringObjectSelection3);
            engineeringObjectSelection3.setSelected(false);
            EngineeringObjectSelection engineeringObjectSelection4 = new EngineeringObjectSelection(attribute);
            engineeringObjectSelection3.setElementDescriptor(Attribute.class);
            this.setEmptyComparator(engineeringObjectSelection3);
            this.setEmptyComparator(engineeringObjectSelection4);
            engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_DELETED);
            engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_DELETED);
            engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
            engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
            engineeringObjectSelection.addChild(engineeringObjectSelection3);
            engineeringObjectSelection2.addChild(engineeringObjectSelection4);
        }
    }

    private void addDeletedIndexes(Table table, EngineeringObjectSelection engineeringObjectSelection, Entity entity, EngineeringObjectSelection engineeringObjectSelection2) {
        Iterator iterator = entity.getKeySet().iterator();
        while (iterator.hasNext()) {
            KeyObject keyObject = (KeyObject)iterator.next();
            XtdMapping xtdMapping = keyObject.getDeletedMapping(table);
            if (xtdMapping == null || xtdMapping.getDeletedID() == null) continue;
            String string = xtdMapping.getNameFor(xtdMapping.getDeletedID());
            EngineeringObjectSelection engineeringObjectSelection3 = new EngineeringObjectSelection(string);
            this.deletedMappings.add(engineeringObjectSelection3);
            engineeringObjectSelection3.setSelected(false);
            EngineeringObjectSelection engineeringObjectSelection4 = new EngineeringObjectSelection(keyObject);
            engineeringObjectSelection3.setElementDescriptor(Attribute.class);
            this.setEmptyComparator(engineeringObjectSelection3);
            this.setEmptyComparator(engineeringObjectSelection4);
            engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_DELETED);
            engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_DELETED);
            engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
            engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
            engineeringObjectSelection.addChild(engineeringObjectSelection3);
            engineeringObjectSelection2.addChild(engineeringObjectSelection4);
        }
    }

    private void addDeletedTables(EngineeringObjectSelection engineeringObjectSelection, EngineeringObjectSelection engineeringObjectSelection2) {
        Iterator iterator = this.ldes.getEntitySet().iterator();
        String string = this.phdes.getObjectID();
        while (iterator.hasNext()) {
            Table table;
            Entity entity = (Entity)iterator.next();
            XtdMapping xtdMapping = entity.getDeletedMapping(string);
            if (xtdMapping == null || (table = entity.getEngTable(this.phdes)) != null || xtdMapping.getDeletedID() == null) continue;
            String string2 = xtdMapping.getNameFor(xtdMapping.getDeletedID());
            EngineeringObjectSelection engineeringObjectSelection3 = new EngineeringObjectSelection(string2);
            this.deletedMappings.add(engineeringObjectSelection3);
            engineeringObjectSelection3.setSelected(false);
            EngineeringObjectSelection engineeringObjectSelection4 = new EngineeringObjectSelection(entity);
            engineeringObjectSelection3.setElementDescriptor(Attribute.class);
            this.setEmptyComparator(engineeringObjectSelection3);
            this.setEmptyComparator(engineeringObjectSelection4);
            engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_DELETED);
            engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_DELETED);
            engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
            engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
            engineeringObjectSelection.addChild(engineeringObjectSelection3);
            engineeringObjectSelection2.addChild(engineeringObjectSelection4);
        }
    }

    private void addDeletedTableViews(EngineeringObjectSelection engineeringObjectSelection, EngineeringObjectSelection engineeringObjectSelection2) {
        Iterator iterator = this.ldes.getEntityViewSet().iterator();
        String string = this.phdes.getObjectID();
        while (iterator.hasNext()) {
            EntityView entityView = (EntityView)iterator.next();
            XtdMapping xtdMapping = entityView.getDeletedMapping(string);
            if (xtdMapping == null || xtdMapping.getDeletedID() == null) continue;
            String string2 = xtdMapping.getNameFor(xtdMapping.getDeletedID());
            EngineeringObjectSelection engineeringObjectSelection3 = new EngineeringObjectSelection(string2);
            this.deletedMappings.add(engineeringObjectSelection3);
            engineeringObjectSelection3.setSelected(false);
            EngineeringObjectSelection engineeringObjectSelection4 = new EngineeringObjectSelection(entityView);
            engineeringObjectSelection3.setElementDescriptor(Attribute.class);
            this.setEmptyComparator(engineeringObjectSelection3);
            this.setEmptyComparator(engineeringObjectSelection4);
            engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_DELETED);
            engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_DELETED);
            engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
            engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
            engineeringObjectSelection.addChild(engineeringObjectSelection3);
            engineeringObjectSelection2.addChild(engineeringObjectSelection4);
        }
    }

    public List getDeletedMappings() {
        return this.deletedMappings;
    }

    private List getTablesToEntHierarchies() {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        Iterator iterator = this.phdes.getTableSet().iterator();
        while (iterator.hasNext()) {
            Entity entity;
            Entity entity2;
            Table table = (Table)iterator.next();
            if (this.multiMapped.get(table.getObjectID()) != null || (entity2 = table.getEngEntity()) == null || !(entity2 instanceof Entity) || !(entity = entity2).isHierarchicalEntityType()) continue;
            arrayList.add(table);
        }
        return arrayList;
    }

    private List getTablesToNoneHierarchicalEntity() {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        Iterator iterator = this.phdes.getTableSet().iterator();
        while (iterator.hasNext()) {
            DesignObject designObject;
            Table table = (Table)iterator.next();
            DesignObject designObject2 = table.getEngEntity();
            if (this.multiMapped.get(table.getObjectID()) != null) continue;
            if (designObject2 == null) {
                designObject2 = table.getEngRelation();
            }
            if (designObject2 == null && !table.isMtoNjoinCandidate()) {
                arrayList.add(table);
                continue;
            }
            if (designObject2 == null || !(designObject2 instanceof Entity) || ((Entity)(designObject = designObject2)).isHierarchicalEntityType()) continue;
            arrayList.add(table);
        }
        return arrayList;
    }

    private List getTablesWitnMultiMappings() {
        Object object;
        Object object2;
        RepositoryObject repositoryObject;
        ArrayList<RepositoryObject> arrayList = new ArrayList<RepositoryObject>();
        Iterator iterator = this.phdes.getTableSet().iterator();
        while (iterator.hasNext()) {
            repositoryObject = (Table)iterator.next();
            object2 = ((Table)repositoryObject).getEngEntity();
            if (object2 == null && !((Table)repositoryObject).isMtoNjoinCandidate()) {
                arrayList.add(repositoryObject);
                continue;
            }
            if (object2 == null || !(object2 instanceof Entity) || ((Entity)(object = (Entity)object2)).isHierarchicalEntityType()) continue;
            arrayList.add(repositoryObject);
        }
        repositoryObject = this.phdes.getDesign().getExtendedMap();
        object2 = this.phdes.getDesign().getLogicalDesign().getObjectID();
        object = new ArrayList();
        for (Table table : arrayList) {
            List list = ((ExtendedMapBase)repositoryObject).getMappingsForDesignPart(table, (String)object2);
            if (list.size() <= 1) continue;
            object.add(table);
            this.multiMapped.put(table.getObjectID(), table);
        }
        return object;
    }

    private List getTablesMappetToRelations() {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        Iterator iterator = this.phdes.getTableSet().iterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            if (this.multiMapped.get(table.getObjectID()) != null) continue;
            DesignObject designObject = table.getEngEntity();
            if (designObject != null) {
                if (!(designObject instanceof Relation)) continue;
                arrayList.add(table);
                continue;
            }
            designObject = table.getEngRelation();
            if (designObject != null && designObject instanceof Relation) {
                arrayList.add(table);
                continue;
            }
            if (designObject != null || !table.isMtoNjoinCandidate()) continue;
            arrayList.add(table);
        }
        return arrayList;
    }

    private void addTableSubView(DPVRelationalSubView dPVRelationalSubView, EngineeringObjectSelection engineeringObjectSelection, EngineeringObjectSelection engineeringObjectSelection2) {
        EngineeringObjectSelection engineeringObjectSelection3 = new EngineeringObjectSelection(dPVRelationalSubView.getPlaceHolder());
        engineeringObjectSelection3.setSelected(dPVRelationalSubView.getPlaceHolder().getShouldEngineer());
        DPVLogicalSubView dPVLogicalSubView = ((DesignPartViewPlaceHolder)dPVRelationalSubView.getPlaceHolder()).getEngEntSubView(this.ldes);
        EngineeringObjectSelection engineeringObjectSelection4 = null;
        if (dPVLogicalSubView != null) {
            if (dPVRelationalSubView.getPlaceHolder().shouldBeEngineered() || !dPVRelationalSubView.getDesign().getExcludeFromTree()) {
                engineeringObjectSelection4 = new EngineeringObjectSelection(dPVLogicalSubView.getPlaceHolder());
                TableSubviewEntitySubviewComparator tableSubviewEntitySubviewComparator = new TableSubviewEntitySubviewComparator((DesignPartViewPlaceHolder)dPVRelationalSubView.getPlaceHolder(), (DesignPartViewPlaceHolder)dPVLogicalSubView.getPlaceHolder());
                engineeringObjectSelection3.setPropertiesComparator(tableSubviewEntitySubviewComparator);
                engineeringObjectSelection4.setPropertiesComparator(tableSubviewEntitySubviewComparator);
                this.comparatorsMap.put(tableSubviewEntitySubviewComparator.getID(), tableSubviewEntitySubviewComparator);
                engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
                engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
                engineeringObjectSelection.addChild(engineeringObjectSelection3);
                engineeringObjectSelection2.addChild(engineeringObjectSelection4);
            }
        } else if (dPVRelationalSubView.getPlaceHolder().shouldBeEngineered() || !dPVRelationalSubView.getDesign().getExcludeFromTree()) {
            String string = "From_RM_" + dPVRelationalSubView.getPlaceHolder();
            engineeringObjectSelection4 = new EngineeringObjectSelection(string);
            engineeringObjectSelection4.setElementDescriptor(DesignPartViewPlaceHolder.class);
            TableSubviewEntitySubviewComparator tableSubviewEntitySubviewComparator = new TableSubviewEntitySubviewComparator((DesignPartViewPlaceHolder)dPVRelationalSubView.getPlaceHolder(), null);
            engineeringObjectSelection3.setPropertiesComparator(tableSubviewEntitySubviewComparator);
            engineeringObjectSelection4.setPropertiesComparator(tableSubviewEntitySubviewComparator);
            this.comparatorsMap.put(tableSubviewEntitySubviewComparator.getID(), tableSubviewEntitySubviewComparator);
            engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_NEW);
            engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_NEW);
            engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
            engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
            engineeringObjectSelection.addChild(engineeringObjectSelection3);
            engineeringObjectSelection2.addChild(engineeringObjectSelection4);
        }
    }

    private void addDeletedTableSubViews(EngineeringObjectSelection engineeringObjectSelection, EngineeringObjectSelection engineeringObjectSelection2) {
        Iterator iterator = this.ldes.getLogicalDesignSubviews().iterator();
        String string = this.phdes.getObjectID();
        while (iterator.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
            XtdMapping xtdMapping = designPartViewPlaceHolder.getDeletedMapping(string);
            if (xtdMapping == null || xtdMapping.getDeletedID() == null) continue;
            String string2 = xtdMapping.getNameFor(xtdMapping.getDeletedID());
            EngineeringObjectSelection engineeringObjectSelection3 = new EngineeringObjectSelection(string2);
            this.deletedMappings.add(engineeringObjectSelection3);
            engineeringObjectSelection3.setSelected(false);
            EngineeringObjectSelection engineeringObjectSelection4 = new EngineeringObjectSelection(designPartViewPlaceHolder);
            engineeringObjectSelection3.setElementDescriptor(DesignPartViewPlaceHolder.class);
            this.setEmptyComparator(engineeringObjectSelection3);
            this.setEmptyComparator(engineeringObjectSelection4);
            engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_DELETED);
            engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_DELETED);
            engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
            engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
            engineeringObjectSelection.addChild(engineeringObjectSelection3);
            engineeringObjectSelection2.addChild(engineeringObjectSelection4);
        }
    }
}

