/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.engineering.FWDEngineering;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.Index;

public class KeyIndexComparator
extends EngPropertiesComparator {
    private CandidateKey key;
    private Index index;

    public KeyIndexComparator(CandidateKey candidateKey, Index index) {
        super(candidateKey, index);
        this.key = candidateKey;
        this.index = index;
        this.initPropertiesList();
    }

    public KeyIndexComparator(CandidateKey candidateKey, Index index, List list) {
        this(candidateKey, index);
        this.applyCompareFilter(list, candidateKey.getDesign().getShowSelPropsOnly());
    }

    protected void initPropertiesList() {
        Entity entity;
        this.initNameProperty();
        this.initCommentsAndNotes();
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(PRIMARY_KEY);
        engPropertyHolder.setLeftValue(this.key != null ? (this.key.isPK() ? YES : NO) : "");
        engPropertyHolder.setRightValue(this.index != null ? (this.index.isPK() ? YES : NO) : "");
        if (this.key != null && this.index != null && this.key.isPK() != this.index.isPK() && (!(entity = (Entity)this.key.getContainerWithKeyObject()).isHierarchicalEntityType() || entity.isHierarchicalRoot() || "Table for each entity".equals(entity.getFwdEngineeringStrategyName()))) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
            engPropertyHolder.setEditable(false);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(ATTRIBUTES_COLUMNS);
        engPropertyHolder.setLeftValue(this.key != null ? this.getElementsToString(this.key) : "");
        engPropertyHolder.setRightValue(this.index != null ? this.getElementsToString(this.index) : "");
        if (this.key != null && this.index != null && !FWDEngineering.haveIdenticalColumns(this.key, this.index)) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
            engPropertyHolder.setEditable(false);
        }
        this.propertiesList.add(engPropertyHolder);
    }

    private String getElementsToString(KeyObject keyObject) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = keyObject.getElementsCollection().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            ContainedObject containedObject = (ContainedObject)iterator.next();
            if (bl) {
                stringBuffer.append(containedObject.getName());
                bl = false;
                continue;
            }
            stringBuffer.append("; ").append(containedObject.getName());
        }
        return stringBuffer.toString();
    }

    @Override
    public void copySelectedProperties() {
        if (!this.isReadOnly()) {
            this.copyPropertiesFromLeftToRight();
            this.copyPropertiesFromKeyToIndex();
        }
    }

    protected void copyPropertiesFromKeyToIndex() {
        if (this.key != null && this.index != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(PRIMARY_KEY)) {
                    this.index.setPK(this.key.isPK());
                    continue;
                }
                if (!engPropertyHolder.getName().equals(ATTRIBUTES_COLUMNS)) continue;
                FWDEngineering.synchronizeColumnsFromKeyToIndex(this.key, this.index);
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.key != null ? this.key.getLongName() : "";
    }

    @Override
    public String getRightName() {
        return this.index != null ? this.index.getLongName() : "";
    }

    @Override
    protected boolean shouldApplyNametranslation() {
        return false;
    }
}

