/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.engineering.FWDEngineering;
import oracle.dbtools.crest.model.design.engineering.ReverseEngineering;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.relational.Index;

public class IndexKeyComparator
extends EngPropertiesComparator {
    private Index index;
    private CandidateKey key;

    public IndexKeyComparator(Index index, CandidateKey candidateKey) {
        super(index, candidateKey);
        this.index = index;
        this.key = candidateKey;
        this.initPropertiesList();
    }

    public IndexKeyComparator(Index index, CandidateKey candidateKey, List list) {
        this(index, candidateKey);
        this.applyCompareFilter(list, index.getDesign().getShowSelPropsOnly());
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentsAndNotes();
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(PRIMARY_KEY);
        engPropertyHolder.setLeftValue(this.index != null ? (this.index.isPK() ? YES : NO) : "");
        engPropertyHolder.setRightValue(this.key != null ? (this.key.isPK() ? YES : NO) : "");
        if (this.key != null && this.index != null && this.key.isPK() != this.index.isPK()) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
            engPropertyHolder.setEditable(false);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(ATTRIBUTES_COLUMNS);
        engPropertyHolder.setLeftValue(this.index != null ? this.getElementsToString(this.index) : "");
        engPropertyHolder.setRightValue(this.key != null ? this.getElementsToString(this.key) : "");
        if (this.key != null && this.index != null && !FWDEngineering.haveIdenticalColumns(this.key, this.index)) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
            engPropertyHolder.setEditable(false);
        }
        this.propertiesList.add(engPropertyHolder);
    }

    private String getElementsToString(KeyObject keyObject) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = keyObject.getElementsCollection().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            ContainedObject containedObject = (ContainedObject)iterator.next();
            if (bl) {
                stringBuffer.append(containedObject.getName());
                bl = false;
                continue;
            }
            stringBuffer.append("; ").append(containedObject.getName());
        }
        return stringBuffer.toString();
    }

    @Override
    public void copySelectedProperties() {
        if (!this.isReadOnly()) {
            this.copyPropertiesFromLeftToRight();
            this.copyPropertiesFromIndexToKey();
        }
    }

    private void copyPropertiesFromIndexToKey() {
        if (this.key != null && this.index != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(PRIMARY_KEY)) {
                    this.key.setPK(this.index.isPK());
                    continue;
                }
                if (!engPropertyHolder.getName().equals(ATTRIBUTES_COLUMNS)) continue;
                ReverseEngineering.synchronizeColumnsFromIndexToKey(this.index, this.key);
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.index != null ? this.index.getLongName() : "";
    }

    @Override
    public String getRightName() {
        return this.key != null ? this.key.getLongName() : "";
    }

    @Override
    protected boolean shouldApplyNametranslation() {
        return false;
    }
}

