/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.SubsetCO;
import oracle.dbtools.crest.model.TypeSubstitution;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.engineering.AbstractEngineering;
import oracle.dbtools.crest.model.design.engineering.EngCOPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.engineering.FEEntityHierarchy;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKArc;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TVTypeSubstitution;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.logical.DPVLogicalSubView;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVEntityView;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.DPVRelationalSubView;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.swingui.relational.TVView;
import oracle.dbtools.crest.util.logging.Logger;

public class FWDEngineering
extends AbstractEngineering {
    private RelationalDesign pdes;
    private FEEntityHierarchy feEntityHierarchy;
    private List newEngineeredEntities = new ArrayList();
    private List newEngineeredEntityViews = new ArrayList();
    private boolean notForNewObjects = false;
    private String typeName = "";
    private List properties = new ArrayList();
    private static final Logger LOGGER = new Logger(FWDEngineering.class);

    public FWDEngineering(Design design) {
        super(design);
    }

    @Override
    public void execute(Map map) {
        this.execute(null, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DesignPartView designPartView, Map map) {
        this.comparatorsMap = map;
        AbstractEngineering.useSameOptionForAll = false;
        this.processedDPV = designPartView;
        this.pdes = this.design.getRelationalDesign();
        this.pdes.getUndoManager().setLocked(true);
        this.targetDesPartID = this.pdes.getObjectID();
        this.design.setPropagatePKChahges(false);
        int n = this.getDesign().getAppView().getSettings().getDeleteFKColumnStrategy();
        try {
            this.getDesign().getAppView().getSettings().setDeleteFKColumnStrategy(1);
            this.newEngineeredEntities.clear();
            this.newEngineeredEntityViews.clear();
            this.feEntityHierarchy = new FEEntityHierarchy(this, this.design, this.pdes);
            this.feEntityHierarchy.setComparatorsMap(map);
            this.notForNewObjects = this.design.getNotForNewObjects();
            this.checkFKAttributesByRelation(this.pdes);
            this.processEntities();
            this.processRelations();
            this.processTypeSubstitutions();
            this.fixColumnOrder(this.design);
            this.fixColumnOrderHierLeaf(this.design);
            this.fixColumnOrderHierSingle(this.design);
            this.processEntityViews();
            if (designPartView == designPartView.getDesignPart().getMainView()) {
                this.engineerAllSubviews(this.design);
            } else {
                this.engineerSubviewElementsToMainView(this.design, designPartView);
                if (this.design.isEngineerAsSubView()) {
                    this.engineerSubviewElementsToSubView(this.design, designPartView);
                }
            }
            this.pdes.showFkeysInSubviews();
            this.processArcs();
            this.processSQLNames();
            Iterator iterator = this.pdes.getFKIndexAssociationSet().iterator();
            while (iterator.hasNext()) {
                FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)iterator.next();
                fKIndexAssociation.resetEdgeParams();
            }
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error("FWDEngineering.execute()", runtimeException);
        }
        finally {
            this.getDesign().getAppView().getSettings().setDeleteFKColumnStrategy(n);
            this.design.setPropagatePKChahges(true);
            this.pdes.getUndoManager().setLocked(false);
        }
    }

    private void processEntities() {
        Object object2;
        DesignObject[] designObjectArray = this.getProcessedObjects(this.design.getLogicalDesign().getEntitySet());
        for (int i = 0; i < designObjectArray.length; ++i) {
            Entity entity = (Entity)designObjectArray[i];
            if (entity.isHierarchicalEntityType()) continue;
            this.processEntity(entity);
        }
        List list = this.getRoots(designObjectArray);
        for (Object object2 : list) {
            this.feEntityHierarchy.processRoot((Entity)object2);
        }
        object2 = this.getEntitiesInHiearatchies(list);
        this.feEntityHierarchy.inheritancePostProcessing(object2.toArray());
    }

    private List getEntitiesInHiearatchies(List list) {
        ArrayList arrayList = new ArrayList();
        for (Entity entity : list) {
            if (!entity.getShouldEngineer()) continue;
            this.addEntity(entity, arrayList);
        }
        return arrayList;
    }

    private void processEntityViews() {
        DesignObject[] designObjectArray = this.getProcessedObjects(this.design.getLogicalDesign().getEntityViewSet());
        for (int i = 0; i < designObjectArray.length; ++i) {
            EntityView entityView = (EntityView)designObjectArray[i];
            this.processEntityView(entityView);
        }
    }

    boolean shouldDelete(DesignObject designObject) {
        return true;
    }

    private void processRelations() {
        DesignObject[] designObjectArray = this.getProcessedObjects(this.design.getLogicalDesign().getRelationSet());
        for (int i = 0; i < designObjectArray.length; ++i) {
            Relation relation = (Relation)designObjectArray[i];
            if (!relation.shouldBeEngineered()) continue;
            this.feEntityHierarchy.processRelation(relation);
        }
    }

    private void checkFKAttributesByRelation(RelationalDesign relationalDesign) {
        DesignObject[] designObjectArray = this.getProcessedObjects(this.design.getLogicalDesign().getRelationSet());
        for (int i = 0; i < designObjectArray.length; ++i) {
            Attribute attribute;
            int n;
            XtdMapping xtdMapping;
            Object object;
            Relation relation = (Relation)designObjectArray[i];
            if (!relation.shouldBeEngineered()) continue;
            ArrayList<ContainedObject> arrayList = new ArrayList<ContainedObject>();
            Entity entity = relation.getSourceEntity();
            ContainedObject[] containedObjectArray = entity.getAllElementsGeneratedBy(relation.getObjectID());
            if (containedObjectArray.length > 0) {
                for (int j = 0; j < containedObjectArray.length; ++j) {
                    arrayList.add(containedObjectArray[j]);
                }
                object = entity.getEngTables(relationalDesign);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    xtdMapping = (XtdMapping)iterator.next();
                    for (n = 0; n < containedObjectArray.length; ++n) {
                        attribute = (Attribute)containedObjectArray[n];
                        if (xtdMapping.getAttributes().contains(attribute.getObjectID())) continue;
                        xtdMapping.getAttributes().add(attribute.getObjectID());
                    }
                }
            }
            if ((containedObjectArray = (entity = relation.getTargetEntity()).getAllElementsGeneratedBy(relation.getObjectID())).length > 0) {
                for (int j = 0; j < containedObjectArray.length; ++j) {
                    arrayList.add(containedObjectArray[j]);
                }
                object = entity.getEngTables(relationalDesign);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    xtdMapping = (XtdMapping)iterator.next();
                    for (n = 0; n < containedObjectArray.length; ++n) {
                        attribute = (Attribute)containedObjectArray[n];
                        if (xtdMapping.getAttributes().contains(attribute.getObjectID())) continue;
                        xtdMapping.getAttributes().add(attribute.getObjectID());
                    }
                }
            }
            for (DesignObject designObject : arrayList) {
                designObject.setShouldEngineer(true);
                designObject.setEngineerTo(relationalDesign.getObjectID(), true);
            }
        }
    }

    void synchronizeDeleteRule(Relation relation, FKIndexAssociation fKIndexAssociation, int n) {
        EngPropertyHolder engPropertyHolder = Design.getEngPropertyHolder(relation.getDesign().getRelFKPropertyList(), PropertyNames.DELETE_RULE);
        boolean bl = true;
        if (engPropertyHolder != null && !engPropertyHolder.isSelected()) {
            bl = false;
        }
        if (bl) {
            fKIndexAssociation.setDeleteRule(FWDEngineering.getDeleteRule(relation, fKIndexAssociation, n));
        }
    }

    public static String getDeleteRule(Relation relation, FKIndexAssociation fKIndexAssociation, int n) {
        String string = "";
        int n2 = relation.getOtherEndPoint(n);
        boolean bl = relation.isOptional(n);
        if (relation.isOptional(n2)) {
            boolean bl2 = false;
            Column[] columnArray = fKIndexAssociation.getColumns();
            for (int i = 0; i < columnArray.length; ++i) {
                if (!columnArray[i].getNullsAllowed()) continue;
                bl2 = true;
                break;
            }
            string = bl2 ? relation.getDeleteRule() : "NO ACTION";
        } else {
            string = bl ? "RESTRICT" : "CASCADE";
        }
        return string;
    }

    void copyPropertiesFromRelationToFK(Relation relation, FKIndexAssociation fKIndexAssociation) {
        if (!this.notForNewObjects) {
            this.typeName = Design.RELATION_FK;
            this.properties = this.design.getRelFKPropertyList();
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT)) {
                fKIndexAssociation.setComment(relation.getComment());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.NOTES)) {
                fKIndexAssociation.setNotes(relation.getNotes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT_IN_RDBMS)) {
                fKIndexAssociation.setCommentInRDBMS(relation.getCommentInRDBMS());
            }
        } else {
            fKIndexAssociation.setComment(relation.getComment());
            fKIndexAssociation.setNotes(relation.getNotes());
            fKIndexAssociation.setCommentInRDBMS(relation.getCommentInRDBMS());
        }
        if (relation.isOneToOne()) {
            Index index;
            Table table = fKIndexAssociation.getTable();
            Column[] columnArray = fKIndexAssociation.getColumns();
            if (columnArray.length > 0 && (index = table.getUniqueIndex_PK_UK(columnArray)) == null) {
                index = table.getIndex(columnArray);
                if (index == null) {
                    index = table.createIndex();
                    for (int i = 0; i < columnArray.length; ++i) {
                        index.add(columnArray[i]);
                    }
                }
                index.setIndexState("Unique Plain Index");
            }
        }
    }

    private void processEntity(Entity entity) {
        List list = this.xmap.getMappingsForDesignPart(entity, this.targetDesPartID);
        if (list.size() == 0) {
            if (entity.shouldBeEngineered()) {
                String string = entity.getDesign().transformNameFromLogicalToRelational(entity);
                Table table = this.pdes.createTable(string);
                XtdMapping xtdMapping = this.xmap.createMapping(entity, table);
                xtdMapping.initializeContained();
                this.copyPropertiesFromEntityToTable(entity, table);
                if (this.design.isEngineerCoordinates()) {
                    this.setGraphicalPropertiesOnNewObject(entity, table);
                }
                this.newEngineeredEntities.add(entity);
                XtdMapping xtdMapping2 = entity.getDeletedMapping(table.getDesignPartId());
                if (xtdMapping2 != null) {
                    entity.updateDeletedMappings(xtdMapping2.getDeletedID(), table.getObjectID(), table.getDesignPartId());
                    this.xmap.removeMapping(xtdMapping2);
                }
                if (entity.getBasedOnStructuredType() == null && !entity.isHierarchicalEntityType()) {
                    this.processAttributes(entity, table, xtdMapping);
                    this.processKeys(entity, table, xtdMapping);
                } else {
                    this.processAttributesBST(entity, table, xtdMapping);
                    this.processKeys(entity, table, xtdMapping);
                }
            }
        } else {
            for (XtdMapping xtdMapping : list) {
                if (!xtdMapping.isFwEngineer()) continue;
                Table table = (Table)xtdMapping.getObjectMappedTo(entity);
                if (table != null) {
                    EngPropertiesComparator engPropertiesComparator = (EngPropertiesComparator)this.comparatorsMap.get(entity.getObjectID() + table.getObjectID());
                    if (engPropertiesComparator != null) {
                        engPropertiesComparator.copySelectedProperties();
                        if (this.design.isEngineerCoordinates()) {
                            this.setGraphicalPropertiesOnNewObject(entity, table);
                        }
                    }
                    if (entity.getBasedOnStructuredType() == null) {
                        this.processAttributes(entity, table, xtdMapping);
                        this.processKeys(entity, table, xtdMapping);
                        continue;
                    }
                    this.processAttributesBST(entity, table, xtdMapping);
                    this.processKeys(entity, table, xtdMapping);
                    continue;
                }
                System.out.println("Table mapped to entity is null - entity " + entity.getName() + "  - id " + entity.getObjectID());
            }
        }
    }

    private void copyPropertiesFromEntityToTable(Entity entity, Table table) {
        table.setGeneratorID(entity.getObjectID());
        table.setBasedOnStructuredType(entity.getBasedOnStructuredType());
        if (!this.notForNewObjects) {
            this.typeName = Design.ENTITY_TABLE;
            this.properties = this.design.getEntTablePropertyList();
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT)) {
                table.setComment(entity.getComment());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.NOTES)) {
                table.setNotes(entity.getNotes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT_IN_RDBMS)) {
                table.setCommentInRDBMS(entity.getCommentInRDBMS());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.TABLE_TYPE)) {
                table.setTypeID(entity.getTypeID());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.SCOPE)) {
                table.setScope(entity.getScope());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.MIN_VOLUMES)) {
                table.setMinVolumes(entity.getMinVolumes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.EXPECTED_VOLUMES)) {
                table.setExpectedVolumes(entity.getExpectedVolumes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.MAX_VOLUMES)) {
                table.setMaxVolumes(entity.getMaxVolumes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.GROWTH_PERCENT)) {
                table.setGrowthPercent(entity.getGrowthPercent());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.GROWTH_TYPE)) {
                table.setGrowthType(entity.getGrowthType());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.NORMAL_FORM)) {
                table.setNormalForm(entity.getNormalForm());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.ADEQUATELY_NORMALIZED)) {
                table.setAdequatelyNormalized(entity.getAdequatelyNormalized());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.SHORT_NAME_ABBR)) {
                table.setAbbreviation(entity.getShortName());
            }
        } else {
            table.setComment(entity.getComment());
            table.setNotes(entity.getNotes());
            table.setCommentInRDBMS(entity.getCommentInRDBMS());
            table.setTypeID(entity.getTypeID());
            table.setScope(entity.getScope());
            table.setMinVolumes(entity.getMinVolumes());
            table.setExpectedVolumes(entity.getExpectedVolumes());
            table.setMaxVolumes(entity.getMaxVolumes());
            table.setGrowthPercent(entity.getGrowthPercent());
            table.setGrowthType(entity.getGrowthType());
            table.setNormalForm(entity.getNormalForm());
            table.setAdequatelyNormalized(entity.getAdequatelyNormalized());
            table.setAbbreviation(entity.getShortName());
        }
    }

    private XtdMapping getColumnMappingForTable(Attribute attribute, List list, Table table) {
        for (XtdMapping xtdMapping : list) {
            DesignObject designObject = xtdMapping.getObjectMappedTo(attribute);
            if (designObject == null || !(designObject instanceof Column) || ((Column)designObject).getContainer() != table) continue;
            return xtdMapping;
        }
        return null;
    }

    private XtdMapping getIndexMappingForTable(KeyObject keyObject, List list, Table table) {
        for (XtdMapping xtdMapping : list) {
            DesignObject designObject = xtdMapping.getObjectMappedTo(keyObject);
            if (designObject == null || !(designObject instanceof Index) || ((Index)designObject).getContainerWithKeyObject() != table) continue;
            return xtdMapping;
        }
        return null;
    }

    void processAttributesBST(Entity entity, Table table, XtdMapping xtdMapping) {
        if (table != null) {
            RelationalDesign relationalDesign = (RelationalDesign)table.getDesignPart();
            for (Attribute attribute : entity.getAttributes()) {
                String string;
                Column column;
                List list = attribute.getMappingsFor(relationalDesign, table);
                if (list.size() != 0 || (column = (Column)table.getElementByStructAttributeID(string = attribute.getStructAttributeID())) == null) continue;
                this.xmap.createMapping(attribute, column);
                this.copyPropertiesFromAttributeToColumn(attribute, column, 0);
            }
        }
    }

    void processAttributes(Entity entity, Table table, XtdMapping xtdMapping) {
        if (table != null) {
            LogicalDesign.AttrHolder attrHolder;
            List list = ((LogicalDesign)entity.getDesignPart()).getEntitiesWuthOverlappingKeys(false);
            LogicalDesign.EntHolder entHolder = this.getHolderForEnt(entity, list);
            RelationalDesign relationalDesign = (RelationalDesign)table.getDesignPart();
            ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
            ArrayList arrayList2 = new ArrayList();
            for (Attribute attribute : entity.getAttributes()) {
                attrHolder = null;
                if (entHolder != null) {
                    attrHolder = this.getFoldedAttr2Holder(entHolder, attribute);
                }
                arrayList.add(attribute);
            }
            arrayList.addAll(arrayList2);
            for (Attribute attribute : arrayList) {
                Column column;
                Object object;
                Object object2;
                RepositoryObject repositoryObject2;
                List list2;
                attrHolder = null;
                if (entHolder != null) {
                    attrHolder = this.getFoldedAttr2Holder(entHolder, attribute);
                }
                if ((list2 = attribute.getMappingsFor(relationalDesign, table)).size() == 0) {
                    boolean bl;
                    boolean bl2 = bl = attribute.shouldBeEngineered(xtdMapping) || entity.isHierarchicalEntityType();
                    if (!bl && xtdMapping.getInheritanceType() == 1 && entity.isHierarchicalEntityType() && !entity.isHierarchicalRoot()) {
                        bl = true;
                    }
                    if (!bl) continue;
                    if (attrHolder == null || attrHolder != null && !attrHolder.overlap) {
                        this.createColumn(attribute, table, xtdMapping);
                        continue;
                    }
                    repositoryObject2 = attrHolder.attr1.getEngColumn(relationalDesign, table);
                    if (repositoryObject2 == null) continue;
                    this.xmap.createMapping(attribute, (DesignObject)repositoryObject2);
                    object2 = attribute.getDeletedMapping(table);
                    if (object2 == null) continue;
                    this.xmap.removeMapping((XtdMapping)object2);
                    continue;
                }
                for (RepositoryObject repositoryObject2 : list2) {
                    Column column2;
                    if (!repositoryObject2.isFwEngineer() || (object2 = (Column)repositoryObject2.getObjectMappedTo(attribute)) == null || ((ContainedObjectWithDomain)object2).getContainerWithKeyObject() != table) continue;
                    if (attrHolder == null || attrHolder != null && !attrHolder.overlap) {
                        boolean bl = false;
                        if (attrHolder != null && (object = attrHolder.attr1.getEngColumn(relationalDesign, table)) != null && object2 == object) {
                            bl = true;
                            this.xmap.removeMapping((XtdMapping)repositoryObject2);
                            column = this.createColumn(attribute, table, xtdMapping);
                            if (entity.getPK() != null && entity.getPK().contains(attribute) && table.getPK() != null) {
                                table.getPK().add(column);
                                table.getPK().moveToIndex(column, entity.getPK().getIndexOf(attribute));
                            }
                            this.replaceFKColumn(attribute, (Column)object, column, relationalDesign, table);
                            this.xmap.createMapping(attribute, column);
                        }
                        if (bl) continue;
                        this.synchronyzeAttr(attribute, (Column)object2, (XtdMapping)repositoryObject2);
                        continue;
                    }
                    if (attrHolder == null || !attrHolder.overlap || (column2 = attrHolder.attr1.getEngColumn(relationalDesign, table)) == null || object2 == column2) continue;
                    this.xmap.removeMapping((XtdMapping)repositoryObject2);
                    this.xmap.createMapping(attribute, column2);
                    this.replaceFKColumn(attribute, (Column)object2, column2, relationalDesign, table);
                    ((ContainedObject)object2).remove();
                }
                if (!"Table per child".equals(entity.getFwdEngineeringStrategyName()) || (repositoryObject2 = this.getColumnMappingForTable(attribute, list2, table)) != null || !attribute.shouldBeEngineered((XtdMapping)repositoryObject2)) continue;
                object2 = attribute.getName().trim();
                int n = ((String)object2).lastIndexOf(46);
                if (n > -1 && n < ((String)object2).length()) {
                    object2 = ((String)object2).substring(n + 1);
                }
                object = attribute.getDesign().transformNameFromLogicalToRelational(attribute);
                column = table.createColumn((String)object);
                this.xmap.createMapping(attribute, column);
                this.copyPropertiesFromAttributeToColumn(attribute, column, xtdMapping.getInheritanceType());
            }
        }
    }

    private void replaceFKColumn(Attribute attribute, Column column, Column column2, RelationalDesign relationalDesign, Table table) {
        Column column3;
        Index index;
        int n;
        FKIndexAssociation fKIndexAssociation;
        Relation relation;
        if (attribute.isFKAttribute() && (relation = attribute.getRelation()) != null && (fKIndexAssociation = relation.getEngFK(relationalDesign, table)) != null && (n = (index = fKIndexAssociation.getLocalFKIndex()).getIndexOf(column)) > -1 && (column3 = (Column)fKIndexAssociation.getRemoteIndex().getElement(n)) != null) {
            column.removeFKAssociation(fKIndexAssociation.getObjectID());
            column2.addFKAssociation(column3, fKIndexAssociation);
            index.remove(column);
            index.add(column2);
            index.moveToIndex(column2, n);
        }
    }

    private Column createColumn(Attribute attribute, Table table, XtdMapping xtdMapping) {
        String string = attribute.getName().trim();
        int n = string.lastIndexOf(46);
        if (n > -1 && n < string.length()) {
            string = string.substring(n + 1);
        }
        String string2 = attribute.getDesign().transformNameFromLogicalToRelational(attribute);
        Column column = table.createColumn(string2);
        this.xmap.createMapping(attribute, column);
        xtdMapping.getAttributes().remove(attribute.getObjectID());
        this.copyPropertiesFromAttributeToColumn(attribute, column, xtdMapping.getInheritanceType());
        column.setPreviousColumn(false);
        XtdMapping xtdMapping2 = attribute.getDeletedMapping(table);
        if (xtdMapping2 != null) {
            this.xmap.removeMapping(xtdMapping2);
        }
        return column;
    }

    private void synchronyzeAttr(Attribute attribute, Column column, XtdMapping xtdMapping) {
        EngPropertiesComparator engPropertiesComparator = (EngPropertiesComparator)this.comparatorsMap.get(attribute.getObjectID() + column.getObjectID());
        if (engPropertiesComparator != null) {
            engPropertiesComparator.copySelectedProperties();
        } else if (this.isModified(xtdMapping)) {
            DesignObject designObject = xtdMapping.getTargetObject();
            if (attribute == designObject) {
                designObject = xtdMapping.getOwnerObject();
            }
            if (designObject != null) {
                this.copyPropertiesFromAttributeToColumn(attribute, (Column)designObject, xtdMapping.getInheritanceType());
            }
            xtdMapping.setCreationTime(System.currentTimeMillis());
        }
    }

    private void copyPropertiesFromAttributeToColumn(Attribute attribute, Column column, int n) {
        ContainerWithKeyObject containerWithKeyObject;
        column.setTemporaryWriteable(true);
        column.setGeneratorID(attribute.getObjectID());
        column.setDomain(attribute.getDomain());
        column.setUse(attribute.getUse());
        column.setLogicalDatatype(attribute.getLogicalDatatype());
        column.copyParametersFrom(attribute);
        column.setStructuredType(attribute.getStructuredType());
        column.setDistinctType(attribute.getDistinctType());
        column.setReference(attribute.isReference());
        column.setCollectionType(attribute.getCollectionType());
        if (column != null && attribute.getScope() != null) {
            containerWithKeyObject = ((Entity)attribute.getScope()).getEngTable((RelationalDesign)column.getDesignPart());
            if (containerWithKeyObject != null) {
                column.setScopeId(containerWithKeyObject.getObjectID());
            } else {
                column.setScopeId(null);
            }
        } else {
            column.setScopeId(null);
        }
        column.setAllowSubtypeSubstitution(attribute.isAllowSubtypeSubstitution());
        if (1 == n) {
            containerWithKeyObject = (Entity)attribute.getContainerWithKeyObject();
            if (((Entity)containerWithKeyObject).isHierarchicalEntityType() && !((Entity)containerWithKeyObject).isHierarchicalRoot()) {
                column.setNullsAllowed(true);
            } else {
                column.setNullsAllowed(attribute.getNullsAllowed());
            }
        } else {
            column.setNullsAllowed(attribute.getNullsAllowed());
        }
        column.setUseDomainConstraints(attribute.getUseDomainConstraints());
        if (!attribute.getUseDomainConstraints()) {
            EngCOPropertiesComparator.copyCheckConstraint(attribute, column);
            EngCOPropertiesComparator.copyRangeConstraint(attribute, column);
            EngCOPropertiesComparator.copyLOVConstraint(attribute, column);
        }
        if (!this.notForNewObjects) {
            this.typeName = Design.ATTRIBUTE_COLUMN;
            this.properties = this.design.getAttrColPropertyList();
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.CHECK_CONSTRAINT_NAME)) {
                column.setConstraintName(attribute.getConstraintName());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.DEFAULT_VALUE)) {
                column.setDefaultValue(attribute.getDefaultValue());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.USES_DEFUALT_VALUE)) {
                column.setUsesDefaultValue(attribute.getUsesDefaultValue());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT_IN_RDBMS)) {
                column.setCommentInRDBMS(attribute.getCommentInRDBMS());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT)) {
                column.setComment(attribute.getComment());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.NOTES)) {
                column.setNotes(attribute.getNotes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.SOURCE_TYPE)) {
                column.setSourceType(attribute.getSourceType());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.FORMULA_DESC)) {
                column.setFormulaDesc(attribute.getFormulaDesc());
            }
        } else {
            column.setConstraintName(attribute.getConstraintName());
            column.setDefaultValue(attribute.getDefaultValue());
            column.setUsesDefaultValue(attribute.getUsesDefaultValue());
            column.setCommentInRDBMS(attribute.getCommentInRDBMS());
            column.setComment(attribute.getComment());
            column.setNotes(attribute.getNotes());
            column.setSourceType(attribute.getSourceType());
            column.setFormulaDesc(attribute.getFormulaDesc());
            if (column.getFormulaDesc().length() > 0) {
                column.setComputed(true);
            }
        }
        column.setTemporaryWriteable(false);
    }

    public boolean isInherited(Attribute attribute, Column column) {
        DesignObject designObject = column.getContainer().getGenerator();
        if (designObject != null && designObject instanceof Entity) {
            Entity entity = (Entity)designObject;
            Entity entity2 = (Entity)attribute.getContainer();
            boolean bl = !entity.equals(entity2);
            return bl;
        }
        return false;
    }

    void processKeys(Entity entity, Table table, XtdMapping xtdMapping) {
        if (table != null) {
            KeyObject[] keyObjectArray = entity.getKeys();
            for (int i = 0; i < keyObjectArray.length; ++i) {
                Object object;
                Object object2;
                RepositoryObject repositoryObject2;
                CandidateKey candidateKey = (CandidateKey)keyObjectArray[i];
                List list = candidateKey.getMappingsFor(table);
                if (list.size() == 0) {
                    boolean bl;
                    boolean bl2 = bl = candidateKey.shouldBeEngineered(xtdMapping) || entity.isHierarchicalEntityType();
                    if (!bl) continue;
                    repositoryObject2 = null;
                    if (candidateKey.isOidKey() && (repositoryObject2 = (Index)table.getOidKey()) != null) {
                        ((SubsetCO)repositoryObject2).clearElements();
                    }
                    if (repositoryObject2 == null) {
                        repositoryObject2 = table.createIndex();
                    }
                    object2 = this.getDesign().transformNameFromLogicalToRelational(candidateKey);
                    ((DesignObject)repositoryObject2).setName((String)object2);
                    this.xmap.createMapping(candidateKey, (DesignObject)repositoryObject2);
                    xtdMapping.getKeys().remove(candidateKey.getObjectID());
                    this.copyPropertiesFromKeyToIndex(candidateKey, (Index)repositoryObject2);
                    object = candidateKey.getDeletedMapping(table);
                    if (object == null) continue;
                    this.xmap.removeMapping((XtdMapping)object);
                    continue;
                }
                for (RepositoryObject repositoryObject2 : list) {
                    if (!((XtdMapping)repositoryObject2).isFwEngineer() || (object2 = (Index)((XtdMapping)repositoryObject2).getObjectMappedTo(candidateKey)) == null || ((KeyObject)object2).getContainerWithKeyObject() != table || (object = (EngPropertiesComparator)this.comparatorsMap.get(candidateKey.getObjectID() + ((ModelIDObject)object2).getObjectID())) == null) continue;
                    ((EngPropertiesComparator)object).copySelectedProperties();
                }
                if (!"Table per child".equals(entity.getFwdEngineeringStrategyName()) || (repositoryObject2 = this.getIndexMappingForTable(candidateKey, list, table)) != null || !candidateKey.shouldBeEngineered((XtdMapping)repositoryObject2)) continue;
                object2 = table.createIndex();
                ((DesignObject)object2).setName(this.transformFromLogical(candidateKey.getName()));
                this.xmap.createMapping(candidateKey, (DesignObject)object2);
                this.copyPropertiesFromKeyToIndex(candidateKey, (Index)object2);
            }
        }
    }

    private void copyPropertiesFromKeyToIndex(KeyObject keyObject, Index index) {
        index.setGeneratorID(keyObject.getObjectID());
        if (!this.notForNewObjects) {
            this.typeName = Design.KEY_INDEX;
            this.properties = this.design.getKeyIdxPropertyList();
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT_IN_RDBMS)) {
                index.setCommentInRDBMS(keyObject.getCommentInRDBMS());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT)) {
                index.setComment(keyObject.getComment());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.NOTES)) {
                index.setNotes(keyObject.getNotes());
            }
        } else {
            index.setCommentInRDBMS(keyObject.getCommentInRDBMS());
            index.setComment(keyObject.getComment());
            index.setNotes(keyObject.getNotes());
        }
        ContainedObject[] containedObjectArray = keyObject.getElements();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            ContainedObject containedObject = containedObjectArray[i];
            List list = this.xmap.getMappingsForDesignPart(containedObject, this.targetDesPartID);
            if (list.size() <= 0) continue;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Column column = (Column)((XtdMapping)iterator.next()).getObjectMappedTo(containedObject);
                if (column == null || column.getContainer() != index.getContainerObject()) continue;
                index.add(column);
            }
        }
        Entity entity = (Entity)keyObject.getContainerWithKeyObject();
        if (keyObject.isPK() && (!entity.isHierarchicalEntityType() || entity.isHierarchicalRoot() || "Table for each entity".equals(entity.getFwdEngineeringStrategyName()))) {
            index.makePK();
        } else {
            index.setIndexState("Unique Constraint");
        }
    }

    public static void synchronizeColumnsFromKeyToIndex(KeyObject keyObject, Index index) {
        int n;
        ExtendedMap extendedMap = keyObject.getDesign().getExtendedMap();
        String string = index.getDesignPart().getObjectID();
        ContainedObject[] containedObjectArray = keyObject.getElements();
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            ContainedObject containedObject = containedObjectArray[i];
            List list = extendedMap.getMappingsForDesignPart(containedObject, string);
            if (list.size() <= 0) continue;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Column column = (Column)((XtdMapping)iterator.next()).getObjectMappedTo(containedObject);
                if (column == null || column.getContainer() != index.getContainerObject()) continue;
                if (!index.contains(column)) {
                    index.add(column);
                }
                arrayList.add(column);
            }
        }
        ContainedObject[] containedObjectArray2 = index.getElements();
        for (n = 0; n < containedObjectArray2.length; ++n) {
            if (arrayList.contains(containedObjectArray2[n])) continue;
            index.remove(containedObjectArray2[n]);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            index.moveToIndex((ContainedObject)arrayList.get(n), n);
        }
    }

    public static boolean haveIdenticalColumns(KeyObject keyObject, Index index) {
        if (keyObject.getElementsCollection().size() != index.getElementsCollection().size()) {
            return false;
        }
        ContainedObject[] containedObjectArray = keyObject.getElements();
        Table table = (Table)index.getContainerWithKeyObject();
        RelationalDesign relationalDesign = (RelationalDesign)index.getDesignPart();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            Attribute attribute = (Attribute)containedObjectArray[i];
            Column column = null;
            try {
                column = attribute.getEngColumn(relationalDesign, table);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (column == null) {
                return false;
            }
            if (i == index.getIndexOf(column)) continue;
            return false;
        }
        return true;
    }

    private void engineerAllSubviews(Design design) {
        Iterator iterator = design.getLogicalDesign().getLogicalDesignSubviews().iterator();
        RelationalDesign relationalDesign = design.getRelationalDesign();
        while (iterator.hasNext()) {
            DPVRelational dPVRelational;
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
            DPVLogicalSubView dPVLogicalSubView = (DPVLogicalSubView)designPartViewPlaceHolder.getDesignPartView();
            if (!designPartViewPlaceHolder.shouldBeEngineered() || (dPVRelational = (DPVRelational)relationalDesign.getSubViewGeneratedByDPV(dPVLogicalSubView.getDPVId())) != null && (dPVRelational == null || !(dPVRelational instanceof DPVRelationalSubView))) continue;
            if (dPVRelational == null) {
                if (dPVLogicalSubView.getGeneratorId() != null && !"".equalsIgnoreCase(dPVLogicalSubView.getGeneratorId())) {
                    dPVRelational = (DPVRelationalSubView)relationalDesign.getSubViewByID(dPVLogicalSubView.getGeneratorId());
                }
                if (dPVRelational == null) {
                    dPVRelational = (DPVRelationalSubView)relationalDesign.createDesignPartSubView();
                    dPVRelational.setName("From_LM_" + dPVLogicalSubView.getName());
                    dPVRelational.setGeneratorId(dPVLogicalSubView.getDPVId());
                    this.copyPropertiesFromSubViewToSubView((DPVLogicalSubView)designPartViewPlaceHolder.getDesignPartView(), dPVRelational);
                    this.xmap.createMapping(dPVLogicalSubView.getPlaceHolder(), dPVRelational.getPlaceHolder());
                }
            }
            for (ContainerView containerView : dPVLogicalSubView.getTVEntities()) {
                if (!containerView.getModel().shouldBeEngineered()) continue;
                this.engineerEntitySynonyms((TVEntity)containerView, dPVRelational, design);
            }
            for (ContainerView containerView : ((DPVLogical)dPVLogicalSubView).getTVEntityViews()) {
                this.engineerEntityViewSynonyms((TVEntityView)containerView, dPVRelational, design);
            }
            dPVRelational.setVisible(dPVLogicalSubView.isVisible());
        }
    }

    private void engineerEntitySynonyms(TVEntity tVEntity, DesignPartView designPartView, Design design) {
        block4: {
            List list;
            Entity entity;
            block3: {
                String string = designPartView.getDesignPart().getObjectID();
                entity = (Entity)tVEntity.getModel();
                list = design.getExtendedMap().getMappingsForDesignPart(entity, string);
                if (list != null) break block3;
                Table table = entity.getEngTable(this.pdes);
                if (table == null) break block4;
                TVTable tVTable = (TVTable)table.getTopView().createViewSynonim(designPartView);
                tVTable.setGeneratorID(tVEntity.getViewID());
                tVTable.addTVFKRelations(designPartView);
                if (!entity.getDesign().isEngineerCoordinates()) break block4;
                designPartView.getApplicationView().setGraphicalPropsFor(tVTable, designPartView.getApplicationView().getGraphicalPropsFor(tVEntity));
                break block4;
            }
            for (XtdMapping xtdMapping : list) {
                Table table = (Table)xtdMapping.getObjectMappedTo(entity);
                if (table == null) continue;
                TVTable tVTable = (TVTable)table.getTopViewByGeneratorID(designPartView, tVEntity.getViewID());
                if (tVTable == null) {
                    tVTable = (TVTable)table.getTopViewByID(designPartView, tVEntity.getGeneratorID());
                }
                if (tVTable == null || tVTable.getDesignPartView() != designPartView) {
                    tVTable = (TVTable)table.getTopView().createViewSynonim(designPartView);
                    tVTable.setGeneratorID(tVEntity.getViewID());
                    tVTable.addTVFKRelations(designPartView);
                }
                if (!entity.getDesign().isEngineerCoordinates()) continue;
                designPartView.getApplicationView().setGraphicalPropsFor(tVTable, designPartView.getApplicationView().getGraphicalPropsFor(tVEntity));
            }
        }
    }

    private void engineerEntitySynonymsToMV(TVEntity tVEntity, DesignPartView designPartView, Design design) {
        block7: {
            List list;
            Entity entity;
            block6: {
                String string = designPartView.getDesignPart().getObjectID();
                entity = (Entity)tVEntity.getModel();
                list = design.getExtendedMap().getMappingsForDesignPart(entity, string);
                if (list != null) break block6;
                Table table = entity.getEngTable(this.pdes);
                if (table == null) break block7;
                TVTable tVTable = (TVTable)table.getTopView().createViewSynonim(designPartView);
                tVTable.setGeneratorID(tVEntity.getViewID());
                tVTable.addTVFKRelations(designPartView);
                if (!entity.getDesign().isEngineerCoordinates()) break block7;
                designPartView.getApplicationView().setGraphicalPropsFor(tVTable, designPartView.getApplicationView().getGraphicalPropsFor(tVEntity));
                break block7;
            }
            for (XtdMapping xtdMapping : list) {
                Table table = (Table)xtdMapping.getObjectMappedTo(entity);
                if (table == null) continue;
                TVTable tVTable = (TVTable)table.getTopViewByGeneratorID(designPartView, tVEntity.getViewID());
                if (tVTable == null) {
                    tVTable = (TVTable)table.getTopView();
                    if (tVTable.getGeneratorID() == null && (tVEntity.getGeneratorID() == null || tVEntity.getGeneratorID() != null && tVEntity.getGeneratorID().equalsIgnoreCase(tVTable.getViewID()))) {
                        tVTable.setGeneratorID(tVEntity.getViewID());
                    } else {
                        tVTable = null;
                    }
                }
                if (tVTable == null) {
                    tVTable = (TVTable)table.getTopViewByID(designPartView, tVEntity.getGeneratorID());
                }
                if (tVTable == null || tVTable.getDesignPartView() != designPartView) {
                    tVTable = (TVTable)table.getTopView().createViewSynonim(designPartView);
                    tVTable.setGeneratorID(tVEntity.getViewID());
                    tVTable.addTVFKRelations(designPartView);
                }
                if (!entity.getDesign().isEngineerCoordinates()) continue;
                designPartView.getApplicationView().setGraphicalPropsFor(tVTable, designPartView.getApplicationView().getGraphicalPropsFor(tVEntity));
            }
        }
    }

    private void engineerSubviewElementsToMainView(Design design, DesignPartView designPartView) {
        DPVLogicalSubView dPVLogicalSubView = (DPVLogicalSubView)designPartView;
        DesignPartView designPartView2 = this.pdes.getMainView();
        for (ContainerView containerView : dPVLogicalSubView.getTVEnities()) {
            if (!this.includeEntity((Entity)containerView.getModel())) continue;
            this.engineerEntitySynonymsToMV((TVEntity)containerView, designPartView2, design);
        }
        for (ContainerView containerView : dPVLogicalSubView.getTVEntityViews()) {
            this.engineerEntityViewSynonymsToMV((TVEntityView)containerView, designPartView2, design);
        }
    }

    private boolean includeEntity(Entity entity) {
        if (entity.isHierarchicalEntityType()) {
            if ("Single Table".equals(entity.getFwdEngineeringStrategyName()) && entity.isHierarchicalRoot()) {
                return true;
            }
            if ("Table per child".equals(entity.getFwdEngineeringStrategyName()) && entity.getHierarchicalChildrenCount() == 0) {
                return true;
            }
            return "Table for each entity".equals(entity.getFwdEngineeringStrategyName());
        }
        return true;
    }

    private void engineerSubviewElementsToSubView(Design design, DesignPartView designPartView) {
        DPVLogicalSubView dPVLogicalSubView = (DPVLogicalSubView)designPartView;
        DesignPartView designPartView2 = this.pdes.getSubViewGeneratedByDPV(dPVLogicalSubView.getDPVId());
        if (designPartView2 == null || designPartView2 != null && designPartView2 instanceof DPVRelationalSubView) {
            if (designPartView2 == null) {
                if (dPVLogicalSubView.getGeneratorId() != null && !"".equalsIgnoreCase(dPVLogicalSubView.getGeneratorId())) {
                    designPartView2 = this.pdes.getSubViewByID(dPVLogicalSubView.getGeneratorId());
                }
                if (designPartView2 == null) {
                    designPartView2 = this.pdes.createDesignPartSubView();
                    designPartView2.setName("From_LM_" + dPVLogicalSubView.getName());
                    designPartView2.setGeneratorId(dPVLogicalSubView.getDPVId());
                    this.copyPropertiesFromSubViewToSubView(dPVLogicalSubView, (DPVRelational)designPartView2);
                    this.xmap.createMapping(dPVLogicalSubView.getPlaceHolder(), designPartView2.getPlaceHolder());
                }
            }
            for (ContainerView containerView : dPVLogicalSubView.getTVEnities()) {
                this.engineerEntitySynonyms((TVEntity)containerView, designPartView2, design);
            }
            for (ContainerView containerView : dPVLogicalSubView.getTVEntityViews()) {
                this.engineerEntityViewSynonyms((TVEntityView)containerView, designPartView2, design);
            }
        }
    }

    private void fixColumnOrder(Design design) {
        List list = design.getLogicalDesign().getEntitiesWuthOverlappingKeys(false);
        DesignObject[] designObjectArray = this.getProcessedObjects(design.getLogicalDesign().getEntitySet());
        RelationalDesign relationalDesign = design.getRelationalDesign();
        for (int i = 0; i < designObjectArray.length; ++i) {
            Entity entity = (Entity)designObjectArray[i];
            if (!entity.shouldBeEngineered() || entity.isHierarchicalEntityType() && (!entity.isHierarchicalEntityType() || !"Table for each entity".equals(entity.getFwdEngineeringStrategyName()))) continue;
            LogicalDesign.EntHolder entHolder = this.getHolderForEnt(entity, list);
            Table table = entity.getEngTable(relationalDesign);
            if (table == null) continue;
            Iterator iterator = entity.getElementsCollection().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                LogicalDesign.AttrHolder attrHolder = null;
                if (entHolder != null) {
                    attrHolder = this.getFoldedAttr2Holder(entHolder, attribute);
                }
                if (attrHolder != null && attrHolder.overlap) continue;
                Column column = attribute.getEngColumn(relationalDesign, table);
                if (column != null) {
                    table.moveToIndex(column, n);
                }
                ++n;
            }
        }
    }

    private List getRoots(DesignObject[] designObjectArray) {
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        for (int i = 0; i < designObjectArray.length; ++i) {
            Entity entity = (Entity)designObjectArray[i];
            if (!entity.isHierarchicalRoot()) continue;
            arrayList.add(entity);
        }
        return arrayList;
    }

    private void addEntity(Entity entity, List list) {
        list.add(entity);
        int n = entity.getHierarchicalChildrenCount();
        for (int i = 0; i < n; ++i) {
            Entity entity2 = entity.getHierarchicalChild(i);
            this.addEntity(entity2, list);
        }
    }

    private void processEntityView(EntityView entityView) {
        block4: {
            List list;
            block3: {
                list = this.xmap.getMappingsForDesignPart(entityView, this.targetDesPartID);
                if (list.size() != 0) break block3;
                if (!entityView.shouldBeEngineered()) break block4;
                String string = this.getDesign().transformNameFromLogicalToRelational(entityView);
                TableView tableView = this.pdes.createTableView(string);
                this.xmap.createMapping(entityView, tableView);
                this.copyPropertiesFromEntityViewToTableView(entityView, tableView);
                if (this.design.isEngineerCoordinates()) {
                    this.setGraphicalPropertiesOnNewObject(entityView, tableView);
                }
                this.newEngineeredEntityViews.add(entityView);
                XtdMapping xtdMapping = entityView.getDeletedMapping(tableView.getDesignPartId());
                if (xtdMapping == null) break block4;
                entityView.updateDeletedMappings(xtdMapping.getDeletedID(), tableView.getObjectID(), tableView.getDesignPartId());
                this.xmap.removeMapping(xtdMapping);
                break block4;
            }
            for (XtdMapping xtdMapping : list) {
                TableView tableView;
                if (!xtdMapping.isFwEngineer() || (tableView = (TableView)xtdMapping.getObjectMappedTo(entityView)) == null) continue;
                EngPropertiesComparator engPropertiesComparator = (EngPropertiesComparator)this.comparatorsMap.get(entityView.getObjectID() + tableView.getObjectID());
                if (engPropertiesComparator != null) {
                    engPropertiesComparator.copySelectedProperties();
                }
                if (!this.design.isEngineerCoordinates()) continue;
                tableView = (TableView)xtdMapping.getObjectMappedTo(entityView);
                this.setGraphicalPropertiesOnNewObject(entityView, tableView);
            }
        }
    }

    private void copyPropertiesFromEntityViewToTableView(EntityView entityView, TableView tableView) {
        DesignObject designObject;
        Object object;
        tableView.setGeneratorID(entityView.getObjectID());
        tableView.setWhere(entityView.getWhere());
        tableView.setGroupBy(entityView.getGroupBy());
        tableView.setHaving(entityView.getHaving());
        tableView.setUserDefined(entityView.getUserDefined());
        tableView.setUserDefinedSQL(entityView.getUserDefinedSQL());
        tableView.setLayoutSQL(entityView.getLayoutSQL());
        tableView.setBasedOnStructuredType(entityView.getBasedOnStructuredType());
        tableView.setParsed(entityView.isParsed());
        tableView.setIncorrectSQL(entityView.isIncorrectSQL());
        tableView.setValidSQL(entityView.isValidSQL());
        if (!this.notForNewObjects) {
            this.typeName = Design.ENTVIEW_TBLVIEW;
            this.properties = this.design.getViewPropertyList();
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT)) {
                tableView.setComment(entityView.getComment());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.NOTES)) {
                tableView.setNotes(entityView.getNotes());
            }
            if (this.checkIfSelected(this.typeName, this.properties, EngPropertiesComparator.COMMENT_IN_RDBMS)) {
                tableView.setCommentInRDBMS(entityView.getCommentInRDBMS());
            }
        } else {
            tableView.setComment(entityView.getComment());
            tableView.setNotes(entityView.getNotes());
            tableView.setCommentInRDBMS(entityView.getCommentInRDBMS());
        }
        for (Object object2 : entityView.getUsedContainers()) {
            Table table;
            String string = ((AbstractView.ContainerHolder)object2).getAlias();
            object = ((AbstractView.ContainerHolder)object2).getContainer().getObjectID();
            designObject = (Entity)this.design.getLogicalDesign().getEntitySet().getObjectByID((String)object);
            if (designObject == null || (table = ((Entity)designObject).getEngTable(this.pdes)) == null) continue;
            tableView.addToContainers(table, string);
        }
        for (String string : entityView.getOrderByMap().keySet()) {
            Object object2;
            object2 = (AttributeView)entityView.getObjectByID(entityView.getOrderByList(), string);
            if (object2 != null) {
                object = new ColumnView(tableView.getDesignPart());
                ((ModelObject)object).setDesign(tableView.getDesign());
                this.copyAttributeToColumn((AttributeView)object2, (ColumnView)object);
                ((AbstractViewElement)object).setView(tableView);
                tableView.addToOrderBy((ContainedObject)object, (String)entityView.getOrderByMap().get(string));
                continue;
            }
            System.out.println("FWDEngineering.copyPropertiesFromEntityViewToTableView: Unable to find AttributeView: " + string);
        }
        if (!entityView.isBST()) {
            for (int i = 0; i < entityView.getElements().length; ++i) {
                object = ((AttributeView)entityView.getElements()[i]).getEntity();
                if (object != null && ((Entity)object).getEngTable(this.pdes) != null) {
                    designObject = new ColumnView(tableView.getDesignPart());
                    designObject.setDesign(tableView.getDesign());
                    this.copyAttributeToColumn((AttributeView)entityView.getElements()[i], (ColumnView)designObject);
                    ((AbstractViewElement)designObject).setView(tableView);
                    ((ContainedObject)designObject).setContainer(tableView);
                    tableView.add((ContainedObject)designObject);
                    continue;
                }
                designObject = new ColumnView(tableView.getDesignPart());
                designObject.setDesign(tableView.getDesign());
                this.copyAttributeToColumn((AttributeView)entityView.getElements()[i], (ColumnView)designObject);
                ((AbstractViewElement)designObject).setView(tableView);
                ((ContainedObject)designObject).setContainer(tableView);
                tableView.add((ContainedObject)designObject);
            }
        }
        for (int i = 0; i < entityView.getGroupByList().size(); ++i) {
            object = (AttributeView)entityView.getGroupByList().get(i);
            if (object == null || (designObject = (ColumnView)tableView.getElementGeneratedBy(((ModelIDObject)object).getObjectID())) == null) continue;
            tableView.addGroupByList((ContainedObject)designObject);
        }
    }

    public void copyAttributeToColumn(AttributeView attributeView, ColumnView columnView) {
        DesignObject designObject;
        columnView.setGeneratorID(attributeView.getObjectID());
        attributeView.copyDefaults(columnView);
        columnView.setTableAlias(attributeView.getTableAlias());
        columnView.setAlias(attributeView.getAlias());
        columnView.setExpression(attributeView.getExpression());
        columnView.setDataType(attributeView.getDataType());
        if (attributeView.getReferencedColumn() != null) {
            designObject = ((Attribute)attributeView.getReferencedColumn()).getEngColumn(this.pdes);
            columnView.setReferencedColumn((ContainedObjectWithDomain)designObject);
        }
        if (attributeView.getEntity() != null) {
            designObject = attributeView.getEntity().getEngTable(this.pdes);
            columnView.setTable((ContainerWithKeyObject)designObject);
        }
        columnView.setScopeId(attributeView.getScopeId());
        columnView.setReference(attributeView.isReference());
        columnView.setStructuredType(attributeView.getStructuredType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEntityTypeSubstitution(Entity entity) {
        List list = this.xmap.getMappingsForDesignPart(entity, this.targetDesPartID);
        if (list.size() > 0) {
            for (XtdMapping xtdMapping : list) {
                ObjectListener objectListener;
                TVTypeSubstitution tVTypeSubstitution;
                DesignPartView designPartView;
                DesignPartView designPartView2;
                Table table;
                if (!xtdMapping.isFwEngineer() || (table = (Table)xtdMapping.getObjectMappedTo(entity)) == null) continue;
                EngPropertiesComparator engPropertiesComparator = (EngPropertiesComparator)this.comparatorsMap.get(entity.getObjectID() + table.getObjectID());
                if (engPropertiesComparator == null) {
                    engPropertiesComparator = (EngPropertiesComparator)this.comparatorsMap.get(entity.getObjectID());
                }
                if (engPropertiesComparator == null) continue;
                EngPropertyHolder engPropertyHolder = engPropertiesComparator.getPropertyHolderByName(EngPropertiesComparator.ENT_TABLE_TYPE_SUBSTITUTION);
                if (engPropertyHolder != null && engPropertyHolder.isSelected()) {
                    designPartView2 = this.getDesign().getLogicalDesign().getMainView();
                    designPartView = this.getDesign().getRelationalDesign().getMainView();
                    if (entity.getTypeSubstitution() != null) {
                        TopView topView;
                        DesignObject designObject;
                        tVTypeSubstitution = (TVTypeSubstitution)entity.getTypeSubstitution().getViewFor(designPartView2);
                        objectListener = (Entity)entity.getTypeSubstitution().getParentContainerObject();
                        Table table2 = null;
                        if (table.getTypeSubstitution() != null) {
                            table2 = (Table)table.getTypeSubstitution().getParentContainerObject();
                            designObject = ((Entity)objectListener).getEngTable((RelationalDesign)table.getDesignPart());
                            if (designObject == null) continue;
                            table.getTypeSubstitution().setParentCV((ContainerView)((MultiShapedDesignObject)designObject).getFirstViewForDPV(designPartView));
                            topView = (TVTypeSubstitution)table.getTypeSubstitution().getViewFor(designPartView);
                            if (!this.design.isEngineerCoordinates()) continue;
                            ApplicationView.loading = true;
                            try {
                                this.copyConnectionPoints(tVTypeSubstitution, (TVConnector)topView);
                                continue;
                            }
                            finally {
                                ApplicationView.loading = false;
                                continue;
                            }
                        }
                        table2 = ((Entity)objectListener).getEngTable((RelationalDesign)table.getDesignPart());
                        if (table2 == null) continue;
                        ApplicationView.loading = false;
                        try {
                            designObject = this.getDesign().getRelationalDesign().createTypeSubstitution();
                            topView = (ContainerView)table.getFirstViewForDPV(designPartView);
                            ContainerView containerView = (ContainerView)table2.getFirstViewForDPV(designPartView);
                            ((TypeSubstitution)designObject).setChildCV((ContainerView)topView);
                            ((TypeSubstitution)designObject).setParentCV(containerView);
                            ((TypeSubstitution)designObject).addToAllDPVs();
                            TVTypeSubstitution tVTypeSubstitution2 = (TVTypeSubstitution)table.getTypeSubstitution().getViewFor(designPartView);
                            if (!this.design.isEngineerCoordinates()) continue;
                            this.copyConnectionPoints(tVTypeSubstitution, tVTypeSubstitution2);
                            continue;
                        }
                        finally {
                            ApplicationView.loading = false;
                            continue;
                        }
                    }
                    if (table == null || table.getTypeSubstitution() == null) continue;
                    table.getTypeSubstitution().remove();
                    continue;
                }
                if (!this.design.isEngineerCoordinates() || entity.getTypeSubstitution() == null || table.getTypeSubstitution() == null) continue;
                designPartView2 = this.getDesign().getLogicalDesign().getMainView();
                designPartView = this.getDesign().getRelationalDesign().getMainView();
                tVTypeSubstitution = (TVTypeSubstitution)entity.getTypeSubstitution().getViewFor(designPartView2);
                objectListener = (TVTypeSubstitution)table.getTypeSubstitution().getViewFor(designPartView);
                if (objectListener == null || tVTypeSubstitution == null) continue;
                this.copyConnectionPoints(tVTypeSubstitution, (TVConnector)objectListener);
            }
        }
    }

    private void processTypeSubstitutions() {
        DesignObject[] designObjectArray = this.getProcessedObjects(this.design.getLogicalDesign().getEntitySet());
        for (int i = 0; i < designObjectArray.length; ++i) {
            Entity entity = (Entity)designObjectArray[i];
            if (entity.isHierarchicalEntityType() || !entity.isBST()) continue;
            this.processEntityTypeSubstitution(entity);
        }
    }

    private void copyConnectionPoints(TVConnector tVConnector, TVConnector tVConnector2) {
        if (tVConnector2 != null && tVConnector != null && !tVConnector2.getDesignPartView().isAutoRoute()) {
            tVConnector2.removeConnection();
            EdgeView edgeView = (EdgeView)tVConnector.getEdge().getCellView();
            if (tVConnector2.getEdge() == null) {
                tVConnector2.getDesignPartView().add(tVConnector2);
            }
            List list = edgeView.getPoints();
            List list2 = tVConnector2.getEdgePoints();
            list2.clear();
            for (int i = 1; i < list.size() - 1; ++i) {
                Point2D point2D = edgeView.getPoint(i);
                list2.add(DiagramConstants.createPoint(point2D.getX(), point2D.getY()));
            }
            if (list.size() == 2 && tVConnector2.getEdge() != null) {
                tVConnector2.getEdge().straightLine();
            }
        }
    }

    private LogicalDesign.EntHolder getHolderForEnt(Entity entity, List list) {
        for (LogicalDesign.EntHolder entHolder : list) {
            if (entHolder.ent != entity) continue;
            return entHolder;
        }
        return null;
    }

    private LogicalDesign.AttrHolder getFoldedAttr2Holder(LogicalDesign.EntHolder entHolder, Attribute attribute) {
        for (LogicalDesign.AttrHolder attrHolder : entHolder.attrHolders) {
            if (!attrHolder.overlap || attrHolder.attr2 != attribute) continue;
            return attrHolder;
        }
        for (LogicalDesign.AttrHolder attrHolder : entHolder.attrHolders) {
            if (attrHolder.attr2 != attribute || !attrHolder.overlapped) continue;
            return attrHolder;
        }
        return null;
    }

    private void engineerEntityViewSynonyms(TVEntityView tVEntityView, DesignPartView designPartView, Design design) {
        block4: {
            List list;
            EntityView entityView;
            block3: {
                String string = designPartView.getDesignPart().getObjectID();
                entityView = (EntityView)tVEntityView.getModel();
                list = this.xmap.getMappingsForDesignPart(entityView, string);
                if (list != null) break block3;
                TableView tableView = entityView.getEngTableView(this.pdes);
                if (tableView == null) break block4;
                TVView tVView = (TVView)tableView.getTopView().createViewSynonim(designPartView);
                this.xmap.createMapping(entityView, tableView);
                tVView.setGeneratorID(tVEntityView.getViewID());
                if (!entityView.getDesign().isEngineerCoordinates()) break block4;
                designPartView.getApplicationView().setGraphicalPropsFor(tVView, designPartView.getApplicationView().getGraphicalPropsFor(tVEntityView));
                break block4;
            }
            for (XtdMapping xtdMapping : list) {
                TableView tableView = (TableView)xtdMapping.getObjectMappedTo(entityView);
                if (tableView == null) continue;
                TVView tVView = (TVView)tableView.getTopViewByGeneratorID(designPartView, tVEntityView.getViewID());
                if (tVView == null) {
                    tVView = (TVView)tableView.getTopViewByID(designPartView, tVEntityView.getGeneratorID());
                }
                if (tVView == null || tVView.getDesignPartView() != designPartView) {
                    tVView = (TVView)tableView.getTopView().createViewSynonim(designPartView);
                    tVView.setGeneratorID(tVEntityView.getViewID());
                }
                if (!entityView.getDesign().isEngineerCoordinates()) continue;
                designPartView.getApplicationView().setGraphicalPropsFor(tVView, designPartView.getApplicationView().getGraphicalPropsFor(tVEntityView));
            }
        }
    }

    private void engineerEntityViewSynonymsToMV(TVEntityView tVEntityView, DesignPartView designPartView, Design design) {
        block7: {
            List list;
            EntityView entityView;
            block6: {
                String string = designPartView.getDesignPart().getObjectID();
                entityView = (EntityView)tVEntityView.getModel();
                list = this.xmap.getMappingsForDesignPart(entityView, string);
                if (list != null) break block6;
                TableView tableView = entityView.getEngTableView(this.pdes);
                if (tableView == null) break block7;
                TVView tVView = (TVView)tableView.getTopView().createViewSynonim(designPartView);
                this.xmap.createMapping(entityView, tableView);
                tVView.setGeneratorID(tVEntityView.getViewID());
                if (!entityView.getDesign().isEngineerCoordinates()) break block7;
                designPartView.getApplicationView().setGraphicalPropsFor(tVView, designPartView.getApplicationView().getGraphicalPropsFor(tVEntityView));
                break block7;
            }
            for (XtdMapping xtdMapping : list) {
                TableView tableView = (TableView)xtdMapping.getObjectMappedTo(entityView);
                if (tableView == null) continue;
                TVView tVView = (TVView)tableView.getTopViewByGeneratorID(designPartView, tVEntityView.getViewID());
                if (tVView == null) {
                    tVView = (TVView)tableView.getTopView();
                    if (tVView.getGeneratorID() == null && (tVEntityView.getGeneratorID() == null || tVEntityView.getGeneratorID() != null && tVEntityView.getGeneratorID().equalsIgnoreCase(tVView.getViewID()))) {
                        tVView.setGeneratorID(tVEntityView.getViewID());
                    } else {
                        tVView = null;
                    }
                }
                if (tVView == null) {
                    tVView = (TVView)tableView.getTopViewByID(designPartView, tVEntityView.getGeneratorID());
                }
                if (tVView == null || tVView.getDesignPartView() != designPartView) {
                    tVView = (TVView)tableView.getTopView().createViewSynonim(designPartView);
                    tVView.setGeneratorID(tVEntityView.getViewID());
                }
                if (!entityView.getDesign().isEngineerCoordinates()) continue;
                designPartView.getApplicationView().setGraphicalPropsFor(tVView, designPartView.getApplicationView().getGraphicalPropsFor(tVEntityView));
            }
        }
    }

    private void copyPropertiesFromSubViewToSubView(DPVLogicalSubView dPVLogicalSubView, DPVRelational dPVRelational) {
        dPVRelational.getPlaceHolder().setComment(dPVLogicalSubView.getPlaceHolder().getComment());
        dPVRelational.getPlaceHolder().setNotes(dPVLogicalSubView.getPlaceHolder().getNotes());
    }

    private boolean checkIfSelected(String string, List list, String string2) {
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            if (!string.equalsIgnoreCase(Design.ENTITY_TABLE)) break block5;
                            for (EngPropertyHolder engPropertyHolder : list) {
                                if (!engPropertyHolder.getName().equalsIgnoreCase(string2) || !engPropertyHolder.isSelected()) continue;
                                return true;
                            }
                            break block6;
                        }
                        if (!string.equalsIgnoreCase(Design.ATTRIBUTE_COLUMN)) break block7;
                        for (EngPropertyHolder engPropertyHolder : list) {
                            if (!engPropertyHolder.getName().equalsIgnoreCase(string2) || !engPropertyHolder.isSelected()) continue;
                            return true;
                        }
                        break block6;
                    }
                    if (!string.equalsIgnoreCase(Design.ENTVIEW_TBLVIEW)) break block8;
                    for (EngPropertyHolder engPropertyHolder : list) {
                        if (!engPropertyHolder.getName().equalsIgnoreCase(string2) || !engPropertyHolder.isSelected()) continue;
                        return true;
                    }
                    break block6;
                }
                if (!string.equalsIgnoreCase(Design.KEY_INDEX)) break block9;
                for (EngPropertyHolder engPropertyHolder : list) {
                    if (!engPropertyHolder.getName().equalsIgnoreCase(string2) || !engPropertyHolder.isSelected()) continue;
                    return true;
                }
                break block6;
            }
            if (!string.equalsIgnoreCase(Design.RELATION_FK)) break block6;
            for (EngPropertyHolder engPropertyHolder : list) {
                if (!engPropertyHolder.getName().equalsIgnoreCase(string2) || !engPropertyHolder.isSelected()) continue;
                return true;
            }
        }
        return false;
    }

    private void processArcs() {
        LogicalDesign logicalDesign = this.design.getLogicalDesign();
        Iterator iterator = logicalDesign.getArcSet().iterator();
        while (iterator.hasNext()) {
            Arc arc = (Arc)iterator.next();
            List list = this.xmap.getMappingsForDesignPart(arc, this.pdes.getObjectID());
            if (list.size() == 0) {
                this.createNewArc(arc);
                continue;
            }
            this.synchronizeArc(arc, list);
        }
    }

    private void createNewArc(Arc arc) {
        Table table;
        Entity entity = arc.getEntity();
        boolean bl = false;
        if (entity != null && (table = entity.getEngTable(this.pdes)) != null) {
            HashMap<String, FKIndexAssociation> hashMap = new HashMap<String, FKIndexAssociation>();
            ArrayList<FKIndexAssociation> arrayList = new ArrayList<FKIndexAssociation>();
            for (DesignObject designObject : arc.getRelations()) {
                FKIndexAssociation fKIndexAssociation = ((Relation)designObject).getEngFK(this.pdes, table);
                if (fKIndexAssociation == null) continue;
                if (!fKIndexAssociation.canBeOptional()) {
                    return;
                }
                hashMap.put(designObject.getObjectID(), fKIndexAssociation);
            }
            for (DesignObject designObject : arc.getRelations()) {
                int n = ((Relation)designObject).getEndPointFor(entity);
                boolean bl2 = ((Relation)designObject).isOptional(n);
                FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)hashMap.get(designObject.getObjectID());
                if (fKIndexAssociation == null) continue;
                arrayList.add(fKIndexAssociation);
                fKIndexAssociation.setMandatory(false);
                if (bl2) continue;
                bl = true;
            }
            if (arrayList.size() > 1) {
                DesignObject designObject;
                designObject = this.pdes.createArc(arrayList.toArray());
                ((FKArc)designObject).setMandatory(bl);
                this.xmap.createMapping(arc, designObject);
            }
        }
    }

    private void synchronizeArc(Arc arc, List list) {
        Table table;
        Entity entity = arc.getEntity();
        boolean bl = false;
        if (entity != null && (table = entity.getEngTable(this.pdes)) != null) {
            Object object;
            Object object2;
            ArrayList<FKIndexAssociation> arrayList = new ArrayList<FKIndexAssociation>();
            HashMap<String, FKIndexAssociation> hashMap = new HashMap<String, FKIndexAssociation>();
            Iterator iterator = list.iterator();
            FKArc fKArc = null;
            while (iterator.hasNext()) {
                object2 = (XtdMapping)iterator.next();
                object = ((XtdMapping)object2).getObjectMappedTo(arc);
                if (object == null || !(object instanceof FKArc)) continue;
                fKArc = (FKArc)object;
                for (Relation relation : arc.getRelations()) {
                    FKIndexAssociation fKIndexAssociation = relation.getEngFK(this.pdes, table);
                    if (fKIndexAssociation == null) continue;
                    if (!fKIndexAssociation.canBeOptional()) {
                        return;
                    }
                    hashMap.put(relation.getObjectID(), fKIndexAssociation);
                }
                for (Relation relation : arc.getRelations()) {
                    int n = relation.getEndPointFor(entity);
                    boolean bl2 = relation.isOptional(n);
                    FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)hashMap.get(relation.getObjectID());
                    if (fKIndexAssociation == null) continue;
                    arrayList.add(fKIndexAssociation);
                    fKIndexAssociation.setMandatory(false);
                    if (bl2) continue;
                    bl = true;
                }
            }
            if (fKArc != null) {
                if (arrayList.size() > 1) {
                    fKArc.setMandatory(bl);
                    object2 = new ArrayList(fKArc.getFkeys());
                    for (FKIndexAssociation fKIndexAssociation : arrayList) {
                        fKArc.addFkey(fKIndexAssociation);
                    }
                    object = object2.iterator();
                    while (object.hasNext()) {
                        FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)object.next();
                        if (arrayList.contains(fKIndexAssociation)) continue;
                        fKArc.removeFkey(fKIndexAssociation);
                    }
                } else {
                    fKArc.remove();
                }
            }
        }
    }

    private void fixColumnOrderHierLeaf(Design design) {
        DesignObject[] designObjectArray = this.getProcessedObjects(design.getLogicalDesign().getEntitySet());
        RelationalDesign relationalDesign = design.getRelationalDesign();
        for (int i = 0; i < designObjectArray.length; ++i) {
            Table table;
            Entity entity = (Entity)designObjectArray[i];
            if (!entity.shouldBeEngineered() || !entity.isHierarchicalEntityType() || !"Table per child".equals(entity.getFwdEngineeringStrategyName()) || entity.getHierarchicalChildrenCount() != 0 || (table = entity.getEngTable(relationalDesign)) == null) continue;
            this.orderLeaf(entity, table);
        }
    }

    private void orderLeaf(Entity entity, Table table) {
        if (table != null) {
            DesignObject designObject;
            Iterator iterator = entity.getElementsCollection().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                designObject = (Attribute)iterator.next();
                Column column = ((Attribute)designObject).getEngColumn(this.pdes, table);
                if (column != null) {
                    table.moveToIndex(column, n);
                }
                ++n;
            }
            designObject = entity.getHierarchicalParent();
            if (designObject != null) {
                this.orderLeaf((Entity)designObject, table);
            }
        }
    }

    private void fixColumnOrderHierSingle(Design design) {
        DesignObject[] designObjectArray = this.getProcessedObjects(design.getLogicalDesign().getEntitySet());
        RelationalDesign relationalDesign = design.getRelationalDesign();
        for (int i = 0; i < designObjectArray.length; ++i) {
            Table table;
            Entity entity = (Entity)designObjectArray[i];
            if (!entity.shouldBeEngineered() || !entity.isHierarchicalEntityType() || !"Single Table".equals(entity.getFwdEngineeringStrategyName()) || !entity.isHierarchicalRoot() || (table = entity.getEngTable(relationalDesign)) == null) continue;
            this.orderSingle(entity, table, 0);
        }
    }

    private int orderSingle(Entity entity, Table table, int n) {
        int n2 = n;
        if (table != null) {
            Iterator iterator = entity.getElementsCollection().iterator();
            int n3 = n;
            while (iterator.hasNext()) {
                Attribute attribute = (Attribute)iterator.next();
                Column column = attribute.getEngColumn(this.pdes, table);
                if (column != null) {
                    table.moveToIndex(column, n3);
                }
                ++n3;
            }
            n2 = n3;
            int n4 = entity.getHierarchicalChildrenCount();
            for (int i = 0; i < n4; ++i) {
                Entity entity2 = entity.getHierarchicalChild(i);
                n2 += this.orderSingle(entity2, table, n2);
            }
        }
        return n2 - n;
    }

    private void processSQLNames() {
        Iterator iterator = this.design.getLogicalDesign().getEntityViewSet().iterator();
        while (iterator.hasNext()) {
            EntityView entityView = (EntityView)iterator.next();
            this.processSQLNamesForView(entityView);
        }
    }

    private void processSQLNamesForView(EntityView entityView) {
        List list = this.xmap.getMappingsForDesignPart(entityView, this.targetDesPartID);
        for (XtdMapping xtdMapping : list) {
            TableView tableView;
            if (!xtdMapping.isFwEngineer() || (tableView = (TableView)xtdMapping.getObjectMappedTo(entityView)) == null) continue;
            tableView.getSQLNames().clear();
            tableView.setValidSQL(false);
            for (SQLNameHelper sQLNameHelper : entityView.getSQLNames()) {
                Object object;
                DesignObject designObject = this.getDesign().getDesignObject(sQLNameHelper.getID());
                if (designObject != null) {
                    Object object2;
                    DesignObject designObject2;
                    if (designObject instanceof Entity) {
                        object = (Entity)designObject;
                        designObject2 = ((Entity)object).getEngTable(this.pdes);
                        if (designObject2 != null) {
                            object2 = new SQLNameHelper(true, false);
                            ((SQLNameHelper)object2).setID(designObject2.getObjectID());
                            ((SQLNameHelper)object2).setTableName(designObject2.getName());
                            tableView.getSQLNames().add(object2);
                            designObject2.addObjectListener(tableView);
                            continue;
                        }
                        tableView.setIncorrectSQL(true);
                        continue;
                    }
                    if (designObject instanceof EntityView) {
                        object = (EntityView)designObject;
                        designObject2 = ((EntityView)object).getEngTableView(this.pdes);
                        if (designObject2 != null) {
                            object2 = new SQLNameHelper(true, true);
                            ((SQLNameHelper)object2).setID(designObject2.getObjectID());
                            ((SQLNameHelper)object2).setTableName(designObject2.getName());
                            tableView.getSQLNames().add(object2);
                            designObject2.addObjectListener(tableView);
                            continue;
                        }
                        tableView.setIncorrectSQL(true);
                        continue;
                    }
                    if (designObject instanceof Attribute) {
                        object = (Attribute)designObject;
                        designObject2 = ((Attribute)object).getEngColumn(this.pdes);
                        if (designObject2 != null) {
                            object2 = new SQLNameHelper(false, false);
                            ((SQLNameHelper)object2).setID(designObject2.getObjectID());
                            ((SQLNameHelper)object2).setTableName(((ContainedObject)designObject2).getContainer().getName());
                            ((SQLNameHelper)object2).setColumnName(((ContainedObject)designObject2).getName());
                            tableView.getSQLNames().add(object2);
                            designObject2.addObjectListener(tableView);
                            continue;
                        }
                        tableView.setIncorrectSQL(true);
                        continue;
                    }
                    if (!(designObject instanceof AttributeView)) continue;
                    object = (AttributeView)designObject;
                    designObject2 = (EntityView)((ContainedObject)object).getContainer();
                    object2 = ((ContainerObject)designObject2).getElementByName(((ContainedObject)object).getName());
                    if (object2 != null) {
                        SQLNameHelper sQLNameHelper2 = new SQLNameHelper(false, false);
                        sQLNameHelper2.setID(((ModelIDObject)object).getObjectID());
                        sQLNameHelper2.setTableName(((ContainedObject)object2).getContainer().getName());
                        sQLNameHelper2.setColumnName(((ContainedObject)object2).getName());
                        tableView.getSQLNames().add(sQLNameHelper2);
                        ((DesignObject)object2).addObjectListener(tableView);
                        continue;
                    }
                    tableView.setIncorrectSQL(true);
                    continue;
                }
                object = sQLNameHelper.clone();
                tableView.getSQLNames().add(object);
            }
        }
    }
}

