/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.List;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.engineering.FWDEngineering;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;

public class FK_RelationComparator
extends EngPropertiesComparator {
    private Relation rel;
    private FKIndexAssociation fk;
    private boolean mandatoryDefined = false;

    public FK_RelationComparator(FKIndexAssociation fKIndexAssociation, Relation relation) {
        super(fKIndexAssociation, relation);
        this.rel = relation;
        this.fk = fKIndexAssociation;
        this.initPropertiesList();
    }

    public FK_RelationComparator(FKIndexAssociation fKIndexAssociation, Relation relation, List list) {
        this(fKIndexAssociation, relation);
        this.applyCompareFilter(list, fKIndexAssociation.getDesign().getShowSelPropsOnly());
    }

    @Override
    public void copySelectedProperties() {
        if (!this.isReadOnly()) {
            this.copyPropertiesFromLeftToRight();
            if (this.isMandatoryDefined() && this.rel != null && this.fk != null) {
                for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                    if (!engPropertyHolder.isSelected()) continue;
                    if (engPropertyHolder.getName().equals(MANDATORY)) {
                        String string = engPropertyHolder.getLeftValue();
                        try {
                            int[] nArray = this.rel.getPKProviderEndPoint();
                            if (nArray.length != 1) continue;
                            int n = nArray[0];
                            int n2 = this.rel.getOtherEndPoint(n);
                            boolean bl = Boolean.valueOf(string);
                            this.rel.setOptional(n2, !bl);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (!engPropertyHolder.getName().equals(DELETE_RULE)) continue;
                    this.rel.setDeleteRule(this.fk.getDeleteRule());
                }
            }
        }
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        this.initMandatory();
        this.initDeleteRule();
        this.initCommentsAndNotes();
    }

    private void initMandatory() {
        Object object;
        String string = "";
        if (this.fk != null) {
            string = String.valueOf(this.fk.isMandatory());
        }
        String string2 = "";
        if (this.rel != null && ((int[])(object = this.rel.getPKProviderEndPoint())).length == 1) {
            int n = object[0];
            int n2 = this.rel.getOtherEndPoint(n);
            string2 = String.valueOf(!this.rel.isOptional(n2));
            this.mandatoryDefined = true;
        }
        if (this.mandatoryDefined) {
            object = new PropertyHolder(MANDATORY);
            ((EngPropertyHolder)object).setLeftValue(string);
            ((EngPropertyHolder)object).setRightValue(string2);
            if (!string.equalsIgnoreCase(string2)) {
                ((EngPropertyHolder)object).setModified(true);
                ((EngPropertyHolder)object).setSelected(true);
                ((EngPropertyHolder)object).setEditable(true);
            }
            this.propertiesList.add(object);
        }
    }

    public boolean isMandatoryDefined() {
        return this.mandatoryDefined;
    }

    private void initDeleteRule() {
        Object object;
        boolean bl = true;
        String string = "";
        if (this.fk != null) {
            string = this.fk.getDeleteRule();
            bl = !this.fk.isMandatory();
        }
        String string2 = "";
        if (this.rel != null) {
            string2 = this.rel.getDeleteRule();
            if (this.fk != null && this.fk.getRemoteTable() != null && (object = this.fk.getRemoteTable().getEngEntity()) != null) {
                int n = this.rel.getEndPointFor((Entity)object);
                string2 = FWDEngineering.getDeleteRule(this.rel, this.fk, n);
            }
        }
        object = new PropertyHolder(DELETE_RULE);
        ((EngPropertyHolder)object).setLeftValue(string);
        ((EngPropertyHolder)object).setRightValue(string2);
        if (!string.equalsIgnoreCase(string2)) {
            ((EngPropertyHolder)object).setModified(bl);
            ((EngPropertyHolder)object).setSelected(bl);
            ((EngPropertyHolder)object).setEditable(bl);
        }
        this.propertiesList.add(object);
    }
}

