/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.GeneralPropertiesComparator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.engineering.AttributeColumnComparator;
import oracle.dbtools.crest.model.design.engineering.DesignObjectComparator;
import oracle.dbtools.crest.model.design.engineering.EngEmptyPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngFilteredSelection;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngineeringObjectSelection;
import oracle.dbtools.crest.model.design.engineering.EntViewTableViewComparator;
import oracle.dbtools.crest.model.design.engineering.EntitySubViewTableSubViewComparator;
import oracle.dbtools.crest.model.design.engineering.EntityTableComparator;
import oracle.dbtools.crest.model.design.engineering.KeyIndexComparator;
import oracle.dbtools.crest.model.design.engineering.RelationFKComparator;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMapBase;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.logical.DPVLogicalSubView;
import oracle.dbtools.crest.swingui.relational.DPVRelationalSubView;

public class FE_LogicalToRelational
extends EngineeringObjectSelection {
    private static String NEW_FK = Messages.getString("FE_LogicalToRelational.NewFK");
    private RelationalDesign phdes;
    private LogicalDesign ldes;
    private EngineeringObjectSelection relationalRoot;
    private Map comparatorsMap = new TreeMap();
    private List deletedMappings = new ArrayList();
    private ExtendedMap xmap;
    private String targetDesPartID;
    private List entitylist = new ArrayList();
    private List relations = new ArrayList();
    private List entViewList = new ArrayList();
    DesignPartView dpv;
    private List roots;
    private Map multiMapped = new TreeMap();
    private boolean entireLogical = true;
    private static String NO_GENERATION = "no generation";

    public FE_LogicalToRelational(LogicalDesign logicalDesign, RelationalDesign relationalDesign, DesignPartView designPartView) {
        super(logicalDesign.getName());
        this.setDesign(logicalDesign.getDesign());
        this.phdes = relationalDesign;
        this.ldes = logicalDesign;
        this.dpv = designPartView;
        this.targetDesPartID = relationalDesign.getObjectID();
        this.xmap = logicalDesign.getDesign().getExtendedMap();
        this.setName(logicalDesign.getName());
        this.relationalRoot = new EngineeringObjectSelection(relationalDesign.getName());
        this.relationalRoot.setName(relationalDesign.getName());
        this.setCorrespondentNode(this.relationalRoot);
        this.relationalRoot.setCorrespondentNode(this);
        this.setEmptyComparator(this);
        this.setEmptyComparator(this.relationalRoot);
        if (designPartView == logicalDesign.getMainView()) {
            logicalDesign.getEntitySet().addAllElementsTo(this.entitylist);
            logicalDesign.getRelationSet().addAllElementsTo(this.relations);
            logicalDesign.getEntityViewSet().addAllElementsTo(this.entViewList);
            this.entireLogical = true;
        } else {
            DesignObject designObject;
            this.entireLogical = false;
            Iterator iterator = logicalDesign.getEntitySet().iterator();
            while (iterator.hasNext()) {
                designObject = (Entity)iterator.next();
                if (((MultiShapedDesignObject)designObject).getFirstViewForDPV(designPartView) == null) continue;
                this.entitylist.add(designObject);
            }
            iterator = logicalDesign.getRelationSet().iterator();
            while (iterator.hasNext()) {
                designObject = (Relation)iterator.next();
                if (((Relation)designObject).getFirstViewForDPV(designPartView) == null) continue;
                this.relations.add(designObject);
            }
            iterator = logicalDesign.getEntityViewSet().iterator();
            while (iterator.hasNext()) {
                designObject = (EntityView)iterator.next();
                if (((MultiShapedDesignObject)designObject).getFirstViewForDPV(designPartView) == null) continue;
                this.entViewList.add(designObject);
            }
        }
        this.addFromLogicalModel();
    }

    private void setEmptyComparator(EngineeringObjectSelection engineeringObjectSelection) {
        engineeringObjectSelection.setPropertiesComparator(new EngEmptyPropertiesComparator(null, null));
    }

    private void addEntity(Entity entity, EngineeringObjectSelection engineeringObjectSelection, EngineeringObjectSelection engineeringObjectSelection2) {
        List list = this.ldes.getDesign().getExtendedMap().getMappingsForDesignPart(entity, this.phdes.getObjectID());
        int n = 0;
        do {
            Object object;
            EngineeringObjectSelection engineeringObjectSelection3;
            Table table;
            EngineeringObjectSelection engineeringObjectSelection4;
            XtdMapping xtdMapping = null;
            DesignObject designObject = null;
            if (n < list.size() && !((designObject = (xtdMapping = (XtdMapping)list.get(n)).getObjectMappedTo(entity)) instanceof Table)) {
                ++n;
                continue;
            }
            ++n;
            if (list.size() == 0) {
                if (!entity.shouldBeEngineered() && entity.getDesign().getExcludeFromTree()) continue;
                engineeringObjectSelection4 = new EngineeringObjectSelection((ModelIDObject)entity, xtdMapping);
                engineeringObjectSelection4.setSelected(entity.getShouldEngineer());
                table = (Table)designObject;
                engineeringObjectSelection3 = null;
                object = this.getDesign().transformNameFromLogicalToRelational(entity);
                String string = object;
                engineeringObjectSelection3 = new EngineeringObjectSelection(string);
                engineeringObjectSelection3.setElementDescriptor(Table.class);
                XtdMapping xtdMapping2 = entity.getDeletedMapping(this.phdes.getObjectID());
                if (xtdMapping2 == null || !this.getDesign().isApplyNameStandardization()) {
                    // empty if block
                }
                EntityTableComparator entityTableComparator = new EntityTableComparator(entity, table, entity.getDesign().getEntTablePropertyList());
                engineeringObjectSelection3.setPropertiesComparator(entityTableComparator);
                engineeringObjectSelection4.setPropertiesComparator(entityTableComparator);
                this.comparatorsMap.put(entityTableComparator.getID(), entityTableComparator);
                engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_NEW);
                engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_NEW);
                engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
                engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
                boolean bl = true;
                this.setEditableStatus(entity, engineeringObjectSelection4, table, engineeringObjectSelection3, xtdMapping, bl);
                if (entity.isHierarchicalEntityType() && !bl) {
                    engineeringObjectSelection4.setEditable(false);
                }
                engineeringObjectSelection2.addChild(engineeringObjectSelection3);
                engineeringObjectSelection.addChild(engineeringObjectSelection4);
                continue;
            }
            if (xtdMapping == null || !xtdMapping.isFwEngineer() && entity.getDesign().getExcludeFromTree()) continue;
            engineeringObjectSelection4 = new EngineeringObjectSelection((ModelIDObject)entity, xtdMapping);
            engineeringObjectSelection4.setSelected(entity.getShouldEngineer());
            table = (Table)designObject;
            engineeringObjectSelection3 = new EngineeringObjectSelection(table);
            object = new EntityTableComparator(entity, table, entity.getDesign().getEntTablePropertyList());
            engineeringObjectSelection3.setPropertiesComparator((GeneralPropertiesComparator)object);
            engineeringObjectSelection4.setPropertiesComparator((GeneralPropertiesComparator)object);
            engineeringObjectSelection3.setSelected(entity.getShouldEngineer());
            this.comparatorsMap.put(((EngPropertiesComparator)object).getID(), object);
            engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
            engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
            boolean bl = !entity.isHierarchicalEntityType() || entity.isHierarchicalEntityType() && n >= list.size();
            this.setEditableStatus(entity, engineeringObjectSelection4, table, engineeringObjectSelection3, xtdMapping, bl);
            if (entity.isHierarchicalEntityType() && !bl) {
                engineeringObjectSelection4.setEditable(false);
            }
            engineeringObjectSelection2.addChild(engineeringObjectSelection3);
            engineeringObjectSelection.addChild(engineeringObjectSelection4);
        } while (n < list.size());
    }

    private void addEntityMulti(Entity entity, EngineeringObjectSelection engineeringObjectSelection, EngineeringObjectSelection engineeringObjectSelection2) {
        List list = this.ldes.getDesign().getExtendedMap().getMappingsForDesignPart(entity, this.phdes.getObjectID());
        for (XtdMapping xtdMapping : list) {
            Object object;
            DesignObject designObject = xtdMapping.getObjectMappedTo(entity);
            if (!(designObject instanceof Table)) continue;
            EngineeringObjectSelection engineeringObjectSelection3 = new EngineeringObjectSelection((ModelIDObject)entity, xtdMapping);
            Table table = (Table)designObject;
            EngineeringObjectSelection engineeringObjectSelection4 = null;
            if (table != null) {
                engineeringObjectSelection4 = new EngineeringObjectSelection((ModelIDObject)table, xtdMapping);
                object = new EntityTableComparator(entity, table, entity.getDesign().getEntTablePropertyList());
                engineeringObjectSelection4.setPropertiesComparator((GeneralPropertiesComparator)object);
                engineeringObjectSelection3.setPropertiesComparator((GeneralPropertiesComparator)object);
                engineeringObjectSelection4.setSelected(((EngPropertiesComparator)object).isModified());
                this.comparatorsMap.put(((EngPropertiesComparator)object).getID(), object);
            } else {
                object = this.getDesign().transformNameFromLogicalToRelational(entity);
                String string = object;
                engineeringObjectSelection4 = new EngineeringObjectSelection(string);
                engineeringObjectSelection4.setElementDescriptor(Table.class);
                XtdMapping xtdMapping2 = entity.getDeletedMapping(this.phdes.getObjectID());
                if (xtdMapping2 == null || !this.getDesign().isApplyNameStandardization()) {
                    // empty if block
                }
                EntityTableComparator entityTableComparator = new EntityTableComparator(entity, table, entity.getDesign().getEntTablePropertyList());
                engineeringObjectSelection4.setPropertiesComparator(entityTableComparator);
                engineeringObjectSelection3.setPropertiesComparator(entityTableComparator);
                this.comparatorsMap.put(entityTableComparator.getID(), entityTableComparator);
                engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_NEW);
                engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_NEW);
            }
            engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
            engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
            this.setEditableStatus(entity, engineeringObjectSelection3, table, engineeringObjectSelection4, xtdMapping, true);
            engineeringObjectSelection2.addChild(engineeringObjectSelection4);
            engineeringObjectSelection.addChild(engineeringObjectSelection3);
        }
    }

    private void addEntityView(EntityView entityView, EngineeringObjectSelection engineeringObjectSelection, EngineeringObjectSelection engineeringObjectSelection2) {
        EngineeringObjectSelection engineeringObjectSelection3 = new EngineeringObjectSelection(entityView);
        engineeringObjectSelection3.setSelected(entityView.getShouldEngineer());
        TableView tableView = entityView.getEngTableView(this.phdes);
        EngineeringObjectSelection engineeringObjectSelection4 = null;
        if (tableView != null && (entityView.shouldBeEngineered() || !entityView.getDesign().getExcludeFromTree())) {
            engineeringObjectSelection4 = new EngineeringObjectSelection(tableView);
            EntViewTableViewComparator entViewTableViewComparator = new EntViewTableViewComparator(entityView, tableView, entityView.getDesign().getViewPropertyList());
            engineeringObjectSelection4.setPropertiesComparator(entViewTableViewComparator);
            engineeringObjectSelection3.setPropertiesComparator(entViewTableViewComparator);
            engineeringObjectSelection4.setSelected(entViewTableViewComparator.isModified());
            this.comparatorsMap.put(entViewTableViewComparator.getID(), entViewTableViewComparator);
            engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
            engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
            engineeringObjectSelection2.addChild(engineeringObjectSelection4);
            engineeringObjectSelection.addChild(engineeringObjectSelection3);
        } else if (tableView == null && (entityView.shouldBeEngineered() || !entityView.getDesign().getExcludeFromTree())) {
            String string = this.getDesign().transformNameFromLogicalToRelational(entityView);
            engineeringObjectSelection4 = new EngineeringObjectSelection(string);
            engineeringObjectSelection4.setElementDescriptor(TableView.class);
            XtdMapping xtdMapping = entityView.getDeletedMapping(this.phdes.getObjectID());
            if (xtdMapping != null) {
                // empty if block
            }
            EntViewTableViewComparator entViewTableViewComparator = new EntViewTableViewComparator(entityView, tableView, entityView.getDesign().getViewPropertyList());
            engineeringObjectSelection4.setPropertiesComparator(entViewTableViewComparator);
            engineeringObjectSelection3.setPropertiesComparator(entViewTableViewComparator);
            this.comparatorsMap.put(entViewTableViewComparator.getID(), entViewTableViewComparator);
            engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_NEW);
            engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_NEW);
            engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
            engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
            engineeringObjectSelection2.addChild(engineeringObjectSelection4);
            engineeringObjectSelection.addChild(engineeringObjectSelection3);
        }
    }

    private void setEditableStatus(Entity entity, EngineeringObjectSelection engineeringObjectSelection, Table table, EngineeringObjectSelection engineeringObjectSelection2, XtdMapping xtdMapping, boolean bl) {
        if (entity.isHierarchicalEntityType()) {
            if ("Single Table".equals(entity.getFwdEngineeringStrategyName())) {
                if (!entity.isHierarchicalRoot()) {
                    engineeringObjectSelection.setEditable(false);
                    if (table != null) {
                        if (1 != xtdMapping.getInheritanceType()) {
                            engineeringObjectSelection2.setStatus(ModelIdObjectSelection.STATE_DELETED);
                            engineeringObjectSelection.setStatus(ModelIdObjectSelection.STATE_DELETED);
                        }
                    } else {
                        engineeringObjectSelection2.setStatus(ModelIdObjectSelection.STATE_UNCHANGED);
                        Entity entity2 = entity.getHierarchicalRoot();
                        if (entity2 != null) {
                            engineeringObjectSelection2.setName(MessageFormat.format(Messages.getString("FE_LogicalToRelational.GenerateInto"), entity2.getName()));
                        } else {
                            engineeringObjectSelection2.setName(NO_GENERATION);
                        }
                        engineeringObjectSelection.setStatus(ModelIdObjectSelection.STATE_UNCHANGED);
                    }
                    if (bl) {
                        this.addEntityDetails(entity, engineeringObjectSelection, table, engineeringObjectSelection2, true, xtdMapping);
                    }
                } else {
                    if (table != null && 2 == xtdMapping.getInheritanceType()) {
                        engineeringObjectSelection2.setStatus(ModelIdObjectSelection.STATE_DELETED);
                        engineeringObjectSelection.setStatus(ModelIdObjectSelection.STATE_DELETED);
                    }
                    if (bl) {
                        this.addEntityDetails(entity, engineeringObjectSelection, table, engineeringObjectSelection2, false, xtdMapping);
                    }
                }
            } else if ("Table per child".equals(entity.getFwdEngineeringStrategyName())) {
                if (entity.getHierarchicalChildrenCount() > 0) {
                    engineeringObjectSelection.setEditable(false);
                    if (table != null) {
                        if (1 == xtdMapping.getInheritanceType()) {
                            engineeringObjectSelection2.setStatus(ModelIdObjectSelection.STATE_DELETED);
                            engineeringObjectSelection.setStatus(ModelIdObjectSelection.STATE_DELETED);
                        }
                    } else {
                        engineeringObjectSelection2.setStatus(ModelIdObjectSelection.STATE_UNCHANGED);
                        engineeringObjectSelection2.setName(NO_GENERATION);
                        engineeringObjectSelection.setStatus(ModelIdObjectSelection.STATE_UNCHANGED);
                    }
                    if (bl) {
                        this.addEntityDetails(entity, engineeringObjectSelection, table, engineeringObjectSelection2, false, xtdMapping);
                    }
                } else if (bl) {
                    this.addEntityDetails(entity, engineeringObjectSelection, table, engineeringObjectSelection2, false, xtdMapping);
                }
            } else if ("Table for each entity".equals(entity.getFwdEngineeringStrategyName())) {
                if (!entity.isHierarchicalRoot()) {
                    engineeringObjectSelection.setEditable(false);
                    if (table != null && 1 == xtdMapping.getInheritanceType()) {
                        engineeringObjectSelection2.setStatus(ModelIdObjectSelection.STATE_NEW);
                        engineeringObjectSelection.setStatus(ModelIdObjectSelection.STATE_NEW);
                        engineeringObjectSelection2.setName(entity.getName());
                    }
                }
                if (bl) {
                    this.addEntityDetails(entity, engineeringObjectSelection, table, engineeringObjectSelection2, false, xtdMapping);
                }
            }
            if (entity.isHierarchicalRoot()) {
                engineeringObjectSelection.setEditable(true);
            }
        } else if (bl) {
            this.addEntityDetails(entity, engineeringObjectSelection, table, engineeringObjectSelection2, false, xtdMapping);
        }
    }

    private void addDeletedAttributes(Entity entity, EngineeringObjectSelection engineeringObjectSelection, Table table, EngineeringObjectSelection engineeringObjectSelection2) {
        for (Column column : table.getElementsCollection()) {
            XtdMapping xtdMapping = column.getDeletedMapping(entity);
            if (xtdMapping == null || xtdMapping.getDeletedID() == null) continue;
            String string = xtdMapping.getNameFor(xtdMapping.getDeletedID());
            EngineeringObjectSelection engineeringObjectSelection3 = new EngineeringObjectSelection(string);
            this.deletedMappings.add(engineeringObjectSelection3);
            engineeringObjectSelection3.setSelected(false);
            EngineeringObjectSelection engineeringObjectSelection4 = new EngineeringObjectSelection(column);
            engineeringObjectSelection3.setElementDescriptor(Attribute.class);
            this.setEmptyComparator(engineeringObjectSelection3);
            this.setEmptyComparator(engineeringObjectSelection4);
            engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_DELETED);
            engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_DELETED);
            engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
            engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
            engineeringObjectSelection2.addChild(engineeringObjectSelection4);
            engineeringObjectSelection.addChild(engineeringObjectSelection3);
        }
    }

    private void addDeletedKeys(Entity entity, EngineeringObjectSelection engineeringObjectSelection, Table table, EngineeringObjectSelection engineeringObjectSelection2) {
        Iterator iterator = table.getKeySet().iterator();
        while (iterator.hasNext()) {
            Index index = (Index)iterator.next();
            XtdMapping xtdMapping = index.getDeletedMapping(entity);
            if (xtdMapping == null || xtdMapping.getDeletedID() == null) continue;
            String string = xtdMapping.getNameFor(xtdMapping.getDeletedID());
            EngineeringObjectSelection engineeringObjectSelection3 = new EngineeringObjectSelection(string);
            this.deletedMappings.add(engineeringObjectSelection3);
            engineeringObjectSelection3.setSelected(false);
            EngineeringObjectSelection engineeringObjectSelection4 = new EngineeringObjectSelection(index);
            engineeringObjectSelection3.setElementDescriptor(Attribute.class);
            this.setEmptyComparator(engineeringObjectSelection3);
            this.setEmptyComparator(engineeringObjectSelection4);
            engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_DELETED);
            engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_DELETED);
            engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
            engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
            engineeringObjectSelection2.addChild(engineeringObjectSelection4);
            engineeringObjectSelection.addChild(engineeringObjectSelection3);
        }
    }

    private void addDeletedEntities(EngineeringObjectSelection engineeringObjectSelection, EngineeringObjectSelection engineeringObjectSelection2) {
        Iterator iterator = this.phdes.getTableSet().iterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            XtdMapping xtdMapping = table.getDeletedMapping();
            if (xtdMapping == null || xtdMapping.getDeletedID() == null) continue;
            String string = xtdMapping.getNameFor(xtdMapping.getDeletedID());
            EngineeringObjectSelection engineeringObjectSelection3 = new EngineeringObjectSelection(string);
            this.deletedMappings.add(engineeringObjectSelection3);
            engineeringObjectSelection3.setSelected(false);
            EngineeringObjectSelection engineeringObjectSelection4 = new EngineeringObjectSelection(table);
            engineeringObjectSelection3.setElementDescriptor(Entity.class);
            this.setEmptyComparator(engineeringObjectSelection3);
            this.setEmptyComparator(engineeringObjectSelection4);
            engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_DELETED);
            engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_DELETED);
            engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
            engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
            engineeringObjectSelection2.addChild(engineeringObjectSelection4);
            engineeringObjectSelection.addChild(engineeringObjectSelection3);
        }
    }

    private void addDeletedRelations(EngFilteredSelection engFilteredSelection, EngFilteredSelection engFilteredSelection2) {
        ArrayList arrayList = new ArrayList();
        this.phdes.getFKIndexAssociationSet().addAllElementsTo(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            XtdMapping xtdMapping = null;
            DesignObject designObject = (DesignObject)iterator.next();
            if (designObject instanceof FKIndexAssociation) {
                xtdMapping = ((FKIndexAssociation)designObject).getDeletedMapping();
                if (xtdMapping != null && ((FKIndexAssociation)designObject).getEngRelation() != null) {
                    xtdMapping = null;
                }
            } else if (designObject instanceof Table && (xtdMapping = ((Table)designObject).getDeletedMapping()) != null && ((Table)designObject).getEngRelation() != null) {
                xtdMapping = null;
            }
            if (xtdMapping == null || xtdMapping.getDeletedID() == null) continue;
            String string = xtdMapping.getNameFor(xtdMapping.getDeletedID());
            EngineeringObjectSelection engineeringObjectSelection = new EngineeringObjectSelection(string);
            this.deletedMappings.add(engineeringObjectSelection);
            engineeringObjectSelection.setSelected(false);
            EngineeringObjectSelection engineeringObjectSelection2 = new EngineeringObjectSelection(designObject);
            engineeringObjectSelection.setElementDescriptor(Attribute.class);
            this.setEmptyComparator(engineeringObjectSelection);
            this.setEmptyComparator(engineeringObjectSelection2);
            engineeringObjectSelection.setStatus(ModelIdObjectSelection.STATE_DELETED);
            engineeringObjectSelection2.setStatus(ModelIdObjectSelection.STATE_DELETED);
            engineeringObjectSelection2.setCorrespondentNode(engineeringObjectSelection);
            engineeringObjectSelection.setCorrespondentNode(engineeringObjectSelection2);
            engFilteredSelection2.addChild(engineeringObjectSelection2);
            engFilteredSelection.addChild(engineeringObjectSelection);
        }
    }

    private void addDeletedEntityViews(EngineeringObjectSelection engineeringObjectSelection, EngineeringObjectSelection engineeringObjectSelection2) {
        Iterator iterator = this.phdes.getTableViewSet().iterator();
        while (iterator.hasNext()) {
            TableView tableView = (TableView)iterator.next();
            XtdMapping xtdMapping = tableView.getDeletedMapping();
            if (xtdMapping == null || xtdMapping.getDeletedID() == null) continue;
            String string = xtdMapping.getNameFor(xtdMapping.getDeletedID());
            EngineeringObjectSelection engineeringObjectSelection3 = new EngineeringObjectSelection(string);
            this.deletedMappings.add(engineeringObjectSelection3);
            engineeringObjectSelection3.setSelected(false);
            EngineeringObjectSelection engineeringObjectSelection4 = new EngineeringObjectSelection(tableView);
            engineeringObjectSelection3.setElementDescriptor(Attribute.class);
            this.setEmptyComparator(engineeringObjectSelection3);
            this.setEmptyComparator(engineeringObjectSelection4);
            engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_DELETED);
            engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_DELETED);
            engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
            engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
            engineeringObjectSelection2.addChild(engineeringObjectSelection4);
            engineeringObjectSelection.addChild(engineeringObjectSelection3);
        }
    }

    private List getNoneHierarchiesEntities() {
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        for (Entity entity : this.entitylist) {
            if (this.multiMapped.get(entity.getObjectID()) != null || entity.isHierarchicalEntityType()) continue;
            arrayList.add(entity);
        }
        return arrayList;
    }

    private List getRoots() {
        Entity[] entityArray2;
        ArrayList<Entity[]> arrayList = new ArrayList<Entity[]>();
        for (Entity[] entityArray2 : this.entitylist) {
            Entity entity;
            if (this.multiMapped.get(entityArray2.getObjectID()) != null) continue;
            if (entityArray2.isHierarchicalRoot()) {
                arrayList.add(entityArray2);
                continue;
            }
            if (!entityArray2.isHierarchicalEntityType() || (entity = this.getHighestVisibleParent((Entity)entityArray2, this.dpv)) == null || arrayList.contains(entityArray2)) continue;
            arrayList.add(entityArray2);
        }
        entityArray2 = arrayList.toArray(new Entity[0]);
        for (int i = 0; i < entityArray2.length; ++i) {
            for (int j = 0; j < entityArray2.length; ++j) {
                if (i == j || !entityArray2[i].isHierarchicalAncestorOf(entityArray2[j])) continue;
                arrayList.remove(entityArray2[j]);
            }
        }
        return arrayList;
    }

    private Entity getHighestVisibleParent(Entity entity, DesignPartView designPartView) {
        Entity entity2;
        Entity entity3 = entity.getHierarchicalParent();
        if (entity3 != null && (entity2 = this.getHighestVisibleParent(entity3, designPartView)) != null) {
            return entity2;
        }
        if (entity.getFirstViewForDPV(designPartView) != null) {
            return entity;
        }
        return null;
    }

    private void addFromLogicalModel() {
        Object object;
        ModelObject modelObject;
        ModelObject modelObject22;
        EngFilteredSelection engFilteredSelection;
        Iterator iterator;
        List list = this.getEntitiesWitnMultiMappings();
        if (list.size() > 0) {
            iterator = new EngFilteredSelection(Messages.getString("FE_LogicalToRelational.Tables"));
            ((ModelObject)((Object)iterator)).setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
            engFilteredSelection = new EngFilteredSelection(Messages.getString("FE_LogicalToRelational.EntitiesWithMultipleMappings"));
            engFilteredSelection.setIcon(GUIConfiguration.getInstance().getIcon("ENTITY_FOLDER_ICON"));
            this.setEmptyComparator(engFilteredSelection);
            this.setEmptyComparator((EngineeringObjectSelection)((Object)iterator));
            ((EngineeringObjectSelection)((Object)iterator)).setCorrespondentNode(engFilteredSelection);
            engFilteredSelection.setCorrespondentNode((EngineeringObjectSelection)((Object)iterator));
            for (ModelObject modelObject22 : list) {
                this.addEntityMulti((Entity)modelObject22, engFilteredSelection, (EngineeringObjectSelection)((Object)iterator));
            }
            this.relationalRoot.addChild((ModelIdObjectSelection)((Object)iterator));
            this.addChild(engFilteredSelection);
        }
        iterator = this.getNoneHierarchiesEntities().iterator();
        engFilteredSelection = new EngFilteredSelection(Messages.getString("FE_LogicalToRelational.Tables"));
        engFilteredSelection.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
        EngFilteredSelection engFilteredSelection2 = new EngFilteredSelection(Messages.getString("FE_LogicalToRelational.Views"));
        engFilteredSelection2.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON"));
        modelObject22 = new EngFilteredSelection(Messages.getString("FE_LogicalToRelational.Subviews"));
        modelObject22.setIcon(GUIConfiguration.getInstance().getIcon("SUBVIEW_ICON"));
        EngFilteredSelection engFilteredSelection3 = new EngFilteredSelection(Messages.getString("FE_LogicalToRelational.Entities"));
        engFilteredSelection3.setIcon(GUIConfiguration.getInstance().getIcon("ENTITY_FOLDER_ICON"));
        EngFilteredSelection engFilteredSelection4 = new EngFilteredSelection(Messages.getString("FE_LogicalToRelational.Views"));
        engFilteredSelection4.setIcon(GUIConfiguration.getInstance().getIcon("VIEW_FOLDER_ICON"));
        EngFilteredSelection engFilteredSelection5 = null;
        if (this.entireLogical) {
            engFilteredSelection5 = new EngFilteredSelection(Messages.getString("FE_LogicalToRelational.Subviews"));
            engFilteredSelection5.setIcon(GUIConfiguration.getInstance().getIcon("SUBVIEW_ICON"));
            ((EngineeringObjectSelection)modelObject22).setCorrespondentNode(engFilteredSelection5);
            engFilteredSelection5.setCorrespondentNode((EngineeringObjectSelection)modelObject22);
            this.setEmptyComparator(engFilteredSelection5);
        }
        engFilteredSelection.setCorrespondentNode(engFilteredSelection3);
        engFilteredSelection3.setCorrespondentNode(engFilteredSelection);
        engFilteredSelection2.setCorrespondentNode(engFilteredSelection4);
        engFilteredSelection4.setCorrespondentNode(engFilteredSelection2);
        this.setEmptyComparator(engFilteredSelection3);
        this.setEmptyComparator(engFilteredSelection4);
        engFilteredSelection.setSelected(false);
        engFilteredSelection2.setSelected(false);
        ((EngineeringObjectSelection)modelObject22).setSelected(false);
        this.setEmptyComparator(engFilteredSelection);
        this.setEmptyComparator(engFilteredSelection2);
        this.setEmptyComparator((EngineeringObjectSelection)modelObject22);
        while (iterator.hasNext()) {
            modelObject = (Entity)iterator.next();
            this.addEntity((Entity)modelObject, engFilteredSelection3, engFilteredSelection);
        }
        iterator = this.ldes.getEntityViewSet().iterator();
        while (iterator.hasNext()) {
            modelObject = (EntityView)iterator.next();
            this.addEntityView((EntityView)modelObject, engFilteredSelection4, engFilteredSelection2);
        }
        if (this.entireLogical) {
            iterator = this.ldes.getLogicalDesignSubviews().iterator();
            while (iterator.hasNext()) {
                modelObject = (DesignPartViewPlaceHolder)iterator.next();
                object = (DPVLogicalSubView)((DesignPartViewPlaceHolder)modelObject).getDesignPartView();
                this.addEntitySubView((DPVLogicalSubView)object, engFilteredSelection5, (EngineeringObjectSelection)modelObject22);
            }
        }
        this.addDeletedEntities(engFilteredSelection3, engFilteredSelection);
        this.relationalRoot.addChild(engFilteredSelection);
        this.addChild(engFilteredSelection3);
        this.roots = this.getRoots();
        iterator = this.roots.iterator();
        modelObject = new EngFilteredSelection(Messages.getString("FE_LogicalToRelational.TablesMappedToHierarchies"));
        modelObject.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
        object = new EngFilteredSelection(Messages.getString("FE_LogicalToRelational.EntityHierarchies"));
        ((ModelObject)object).setIcon(GUIConfiguration.getInstance().getIcon("ENTITY_FOLDER_ICON"));
        ((EngineeringObjectSelection)modelObject).setCorrespondentNode((EngineeringObjectSelection)object);
        ((EngineeringObjectSelection)object).setCorrespondentNode((EngineeringObjectSelection)modelObject);
        this.setEmptyComparator((EngineeringObjectSelection)object);
        ((EngineeringObjectSelection)modelObject).setSelected(false);
        this.setEmptyComparator((EngineeringObjectSelection)modelObject);
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            this.addEntity(entity, (EngineeringObjectSelection)object, (EngineeringObjectSelection)modelObject);
        }
        this.relationalRoot.addChild((ModelIdObjectSelection)modelObject);
        this.addChild((ModelIdObjectSelection)object);
        this.addRelationsToTables();
        this.relationalRoot.addChild(engFilteredSelection2);
        this.addDeletedEntityViews(engFilteredSelection4, engFilteredSelection2);
        this.addChild(engFilteredSelection4);
        if (this.entireLogical) {
            this.relationalRoot.addChild((ModelIdObjectSelection)modelObject22);
            this.addDeletedEntitySubViews(engFilteredSelection5, (EngineeringObjectSelection)modelObject22);
            this.addChild(engFilteredSelection5);
        }
    }

    private boolean hasChildsInDPV(Entity entity) {
        for (Entity entity2 : this.entitylist) {
            if (!entity.isHierarchicalAncestorOf(entity2)) continue;
            return true;
        }
        return false;
    }

    private void addRelationsToTables() {
        EngFilteredSelection engFilteredSelection = new EngFilteredSelection(Messages.getString("FE_LogicalToRelational.ObjectsMappedToRelations"));
        engFilteredSelection.setIcon(GUIConfiguration.getInstance().getIcon("M_TO_N_RELATION_ICON"));
        EngFilteredSelection engFilteredSelection2 = new EngFilteredSelection(Messages.getString("FE_LogicalToRelational.Relations"));
        engFilteredSelection2.setIcon(GUIConfiguration.getInstance().getIcon("M_TO_N_RELATION_ICON"));
        engFilteredSelection.setCorrespondentNode(engFilteredSelection2);
        engFilteredSelection2.setCorrespondentNode(engFilteredSelection);
        this.setEmptyComparator(engFilteredSelection2);
        engFilteredSelection.setSelected(false);
        this.setEmptyComparator(engFilteredSelection);
        for (Relation relation : this.relations) {
            this.addRelation(relation, engFilteredSelection2, engFilteredSelection);
        }
        this.addDeletedRelations(engFilteredSelection2, engFilteredSelection);
        this.relationalRoot.addChild(engFilteredSelection);
        this.addChild(engFilteredSelection2);
    }

    private void addAttribute(Attribute attribute, Table table, EngineeringObjectSelection engineeringObjectSelection, EngineeringObjectSelection engineeringObjectSelection2, XtdMapping xtdMapping) {
        List list = attribute.getMappingsFor(this.phdes, table);
        int n = 0;
        do {
            Object object;
            Object object2;
            Object object3;
            XtdMapping xtdMapping2 = null;
            DesignObject designObject = null;
            if (n < list.size() && !((designObject = (xtdMapping2 = (XtdMapping)list.get(n)).getObjectMappedTo(attribute)) instanceof Column)) {
                ++n;
                continue;
            }
            ++n;
            EngineeringObjectSelection engineeringObjectSelection3 = new EngineeringObjectSelection(attribute, xtdMapping2, xtdMapping);
            EngineeringObjectSelection engineeringObjectSelection4 = null;
            Column column = null;
            if (table != null && xtdMapping2 != null && (column = (Column)designObject) != null) {
                if (attribute.isFKAttribute() && (object3 = attribute.getDesign().getDesignObject(attribute.getGeneratorID())) != null && object3 instanceof Relation && (object2 = ((Relation)(object = (Relation)object3)).getEngFK(this.phdes, table)) != null && column.getReferencedColumn((FKIndexAssociation)object2) == column) {
                    attribute.setEngineerTo(this.phdes.getObjectID(), false);
                }
                engineeringObjectSelection4 = new EngineeringObjectSelection(column);
                object3 = new AttributeColumnComparator(attribute, column, attribute.getDesign().getAttrColPropertyList());
                engineeringObjectSelection4.setPropertiesComparator((GeneralPropertiesComparator)object3);
                engineeringObjectSelection3.setPropertiesComparator((GeneralPropertiesComparator)object3);
                engineeringObjectSelection4.setSelected(attribute.getShouldEngineer());
                engineeringObjectSelection3.setSelected(attribute.getShouldEngineer());
                this.comparatorsMap.put(((EngPropertiesComparator)object3).getID(), object3);
            }
            if (column == null) {
                object = object3 = this.getDesign().transformNameFromLogicalToRelational(attribute);
                engineeringObjectSelection4 = new EngineeringObjectSelection((String)object);
                engineeringObjectSelection4.setElementDescriptor(Column.class);
                if (table == null || this.getDesign().isApplyNameStandardization() || (object2 = attribute.getDeletedMapping(table)) != null) {
                    // empty if block
                }
                object2 = new AttributeColumnComparator(attribute, column, attribute.getDesign().getAttrColPropertyList());
                engineeringObjectSelection4.setPropertiesComparator((GeneralPropertiesComparator)object2);
                engineeringObjectSelection3.setPropertiesComparator((GeneralPropertiesComparator)object2);
                this.comparatorsMap.put(((EngPropertiesComparator)object2).getID(), object2);
                engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_NEW);
                engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_NEW);
                engineeringObjectSelection3.setSelected(attribute.getShouldEngineer());
            }
            engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
            engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
            engineeringObjectSelection2.addChild(engineeringObjectSelection4);
            engineeringObjectSelection.addChild(engineeringObjectSelection3);
            ++n;
        } while (n < list.size());
    }

    private void addRelation(Relation relation, EngineeringObjectSelection engineeringObjectSelection, EngineeringObjectSelection engineeringObjectSelection2) {
        ArrayList arrayList = new ArrayList();
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        this.processRelation(relation, arrayList);
        EngineeringObjectSelection engineeringObjectSelection3 = new EngineeringObjectSelection(relation);
        engineeringObjectSelection3.setSelected(relation.getShouldEngineer());
        EngineeringObjectSelection engineeringObjectSelection4 = new EngineeringObjectSelection(MessageFormat.format(Messages.getString("FE_LogicalToRelational.MappedTo"), relation.getName()));
        engineeringObjectSelection4.setIcon(GUIConfiguration.getInstance().getIcon("M_TO_N_RELATION_ICON"));
        engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
        engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
        this.setEmptyComparator(engineeringObjectSelection4);
        this.setEmptyComparator(engineeringObjectSelection3);
        boolean bl = false;
        for (RelationMapping relationMapping : arrayList) {
            EngPropertiesComparator engPropertiesComparator;
            Object object;
            EngineeringObjectSelection engineeringObjectSelection5;
            EngineeringObjectSelection engineeringObjectSelection6;
            Object object2;
            int n;
            for (n = 0; n < relationMapping.existing.size(); ++n) {
                if (!relation.getShouldEngineer() && relation.getDesign().getExcludeFromTree()) continue;
                object2 = (DesignObject)relationMapping.existing.get(n);
                engineeringObjectSelection6 = new EngineeringObjectSelection(relation);
                engineeringObjectSelection5 = new EngineeringObjectSelection((ModelIDObject)object2);
                object = this.getDesign().transformNameFromLogicalToRelational(relation);
                engineeringObjectSelection5.setName((String)object);
                engineeringObjectSelection5.setCorrespondentNode(engineeringObjectSelection6);
                engineeringObjectSelection6.setCorrespondentNode(engineeringObjectSelection5);
                engPropertiesComparator = object2 instanceof FKIndexAssociation ? new RelationFKComparator(relation, (FKIndexAssociation)object2, relation.getDesign().getRelFKPropertyList()) : new DesignObjectComparator(relation, (DesignObject)object2, relation.getDesign().getRelFKPropertyList());
                engineeringObjectSelection5.setPropertiesComparator(engPropertiesComparator);
                engineeringObjectSelection6.setPropertiesComparator(engPropertiesComparator);
                this.comparatorsMap.put(engPropertiesComparator.getID(), engPropertiesComparator);
                if (relationMapping.sourceEntity != null && relationMapping.targetEntity != null) {
                    engineeringObjectSelection6.setName(relationMapping.sourceEntity.getName() + " : " + relationMapping.targetEntity.getName());
                }
                engineeringObjectSelection6.setEditable(false);
                engineeringObjectSelection3.addChild(engineeringObjectSelection6);
                engineeringObjectSelection4.addChild(engineeringObjectSelection5);
                if (bl) continue;
                engineeringObjectSelection.addChild(engineeringObjectSelection3);
                engineeringObjectSelection2.addChild(engineeringObjectSelection4);
                bl = true;
            }
            for (n = 0; n < relationMapping.deleted.size(); ++n) {
                object2 = (DesignObject)relationMapping.deleted.get(n);
                engineeringObjectSelection6 = treeMap.get(((ModelIDObject)object2).getObjectID());
                if (engineeringObjectSelection6 != null) continue;
                engineeringObjectSelection5 = new EngineeringObjectSelection(relation);
                object = new EngineeringObjectSelection((ModelIDObject)object2);
                ((EngineeringObjectSelection)object).setCorrespondentNode(engineeringObjectSelection5);
                engineeringObjectSelection5.setCorrespondentNode((EngineeringObjectSelection)object);
                engPropertiesComparator = new DesignObjectComparator(relation, (DesignObject)object2, relation.getDesign().getRelFKPropertyList());
                ((EngineeringObjectSelection)object).setPropertiesComparator(engPropertiesComparator);
                engineeringObjectSelection5.setPropertiesComparator(engPropertiesComparator);
                this.comparatorsMap.put(engPropertiesComparator.getID(), engPropertiesComparator);
                if (relationMapping.sourceEntity != null && relationMapping.targetEntity != null) {
                    engineeringObjectSelection5.setName(relationMapping.sourceEntity.getName() + " : " + relationMapping.targetEntity.getName());
                }
                engineeringObjectSelection5.setStatus(STATE_DELETED);
                ((EngineeringObjectSelection)object).setStatus(STATE_DELETED);
                engineeringObjectSelection5.setEditable(false);
                engineeringObjectSelection3.addChild(engineeringObjectSelection5);
                engineeringObjectSelection4.addChild((ModelIdObjectSelection)object);
                this.deletedMappings.add(engineeringObjectSelection5);
                engineeringObjectSelection5.setSelected(true);
                treeMap.put(((ModelIDObject)object2).getObjectID(), object2);
                if (bl) continue;
                engineeringObjectSelection.addChild(engineeringObjectSelection3);
                engineeringObjectSelection2.addChild(engineeringObjectSelection4);
                bl = true;
            }
            for (n = 0; n < relationMapping.newStrings.size(); ++n) {
                object2 = (String)relationMapping.newStrings.get(n);
                if (!relation.getShouldEngineer() && relation.getDesign().getExcludeFromTree()) continue;
                engineeringObjectSelection6 = new EngineeringObjectSelection(relation);
                engineeringObjectSelection5 = new EngineeringObjectSelection((String)object2);
                object = this.getDesign().transformNameFromLogicalToRelational(relation);
                engineeringObjectSelection5.setName((String)object);
                engineeringObjectSelection5.setCorrespondentNode(engineeringObjectSelection6);
                engineeringObjectSelection6.setCorrespondentNode(engineeringObjectSelection5);
                this.setEmptyComparator(engineeringObjectSelection5);
                this.setEmptyComparator(engineeringObjectSelection6);
                if (relationMapping.sourceEntity != null && relationMapping.targetEntity != null) {
                    engineeringObjectSelection6.setName(relationMapping.sourceEntity.getName() + " : " + relationMapping.targetEntity.getName());
                }
                engineeringObjectSelection6.setStatus(STATE_NEW);
                engineeringObjectSelection5.setStatus(STATE_NEW);
                engineeringObjectSelection6.setEditable(false);
                engineeringObjectSelection3.addChild(engineeringObjectSelection6);
                engineeringObjectSelection4.addChild(engineeringObjectSelection5);
                if (bl) continue;
                engineeringObjectSelection.addChild(engineeringObjectSelection3);
                engineeringObjectSelection2.addChild(engineeringObjectSelection4);
                bl = true;
            }
        }
    }

    private void addEntityDetails(Entity entity, EngineeringObjectSelection engineeringObjectSelection, Table table, EngineeringObjectSelection engineeringObjectSelection2, boolean bl, XtdMapping xtdMapping) {
        ModelObject modelObject;
        EngineeringObjectSelection engineeringObjectSelection3;
        EngineeringObjectSelection engineeringObjectSelection4;
        if (!bl) {
            ModelObject modelObject22;
            engineeringObjectSelection4 = new EngineeringObjectSelection(Messages.getString("FE_LogicalToRelational.Columns"));
            engineeringObjectSelection4.setIcon(GUIConfiguration.getInstance().getIcon("COLUMN_FOLDER_ICON"));
            engineeringObjectSelection3 = new EngineeringObjectSelection(Messages.getString("FE_LogicalToRelational.Attributes"));
            engineeringObjectSelection3.setIcon(GUIConfiguration.getInstance().getIcon("ATTRIBUTE_FOLDER_ICON"));
            engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
            engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
            this.setEmptyComparator(engineeringObjectSelection4);
            this.setEmptyComparator(engineeringObjectSelection3);
            engineeringObjectSelection4.setSelected(false);
            for (ModelObject modelObject22 : entity.getElementsCollection()) {
                this.addAttribute((Attribute)modelObject22, table, engineeringObjectSelection3, engineeringObjectSelection4, xtdMapping);
            }
            if (table != null) {
                this.addDeletedAttributes(entity, engineeringObjectSelection3, table, engineeringObjectSelection4);
            }
            engineeringObjectSelection2.addChild(engineeringObjectSelection4);
            engineeringObjectSelection.addChild(engineeringObjectSelection3);
            modelObject22 = new EngineeringObjectSelection(Messages.getString("FE_LogicalToRelational.PKAndUKConstraints"));
            modelObject22.setIcon(GUIConfiguration.getInstance().getIcon("PK_ICON"));
            modelObject = new EngineeringObjectSelection(Messages.getString("FE_LogicalToRelational.CandidateKeys"));
            modelObject.setIcon(GUIConfiguration.getInstance().getIcon("INDEX_FOLDER_ICON"));
            ((EngineeringObjectSelection)modelObject22).setCorrespondentNode((EngineeringObjectSelection)modelObject);
            ((EngineeringObjectSelection)modelObject).setCorrespondentNode((EngineeringObjectSelection)modelObject22);
            this.setEmptyComparator((EngineeringObjectSelection)modelObject22);
            this.setEmptyComparator((EngineeringObjectSelection)modelObject);
            Iterator iterator = entity.getKeySet().iterator();
            while (iterator.hasNext()) {
                CandidateKey candidateKey = (CandidateKey)iterator.next();
                this.addKey(candidateKey, table, (EngineeringObjectSelection)modelObject, (EngineeringObjectSelection)modelObject22, xtdMapping);
            }
            if (table != null) {
                this.addDeletedKeys(entity, (EngineeringObjectSelection)modelObject, table, (EngineeringObjectSelection)modelObject22);
            }
            engineeringObjectSelection2.addChild((ModelIdObjectSelection)modelObject22);
            engineeringObjectSelection.addChild((ModelIdObjectSelection)modelObject);
        }
        if (entity.isHierarchicalEntityType()) {
            engineeringObjectSelection4 = new EngineeringObjectSelection(Messages.getString("FE_LogicalToRelational.TablesMappedToSubtypes"));
            engineeringObjectSelection4.setIcon(GUIConfiguration.getInstance().getIcon("TABLE_FOLDER_ICON"));
            engineeringObjectSelection3 = new EngineeringObjectSelection(Messages.getString("FE_LogicalToRelational.Subtypes"));
            engineeringObjectSelection3.setIcon(GUIConfiguration.getInstance().getIcon("ENTITY_FOLDER_ICON"));
            engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
            engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
            this.setEmptyComparator(engineeringObjectSelection3);
            engineeringObjectSelection3.setEditable(false);
            this.setEmptyComparator(engineeringObjectSelection4);
            int n = entity.getHierarchicalChildrenCount();
            for (int i = 0; i < n; ++i) {
                modelObject = entity.getHierarchicalChild(i);
                if (!this.entitylist.contains(modelObject) && !this.hasChildsInDPV((Entity)modelObject)) continue;
                this.addEntity((Entity)modelObject, engineeringObjectSelection3, engineeringObjectSelection4);
            }
            engineeringObjectSelection2.addChild(engineeringObjectSelection4);
            engineeringObjectSelection.addChild(engineeringObjectSelection3);
        }
    }

    private void addKey(CandidateKey candidateKey, Table table, EngineeringObjectSelection engineeringObjectSelection, EngineeringObjectSelection engineeringObjectSelection2, XtdMapping xtdMapping) {
        String string;
        XtdMapping xtdMapping2 = candidateKey.getMappingFor(table);
        EngineeringObjectSelection engineeringObjectSelection3 = new EngineeringObjectSelection(candidateKey, xtdMapping2, xtdMapping);
        EngineeringObjectSelection engineeringObjectSelection4 = null;
        Index index = null;
        if (table != null && xtdMapping2 != null && (index = (Index)xtdMapping2.getObjectMappedTo(candidateKey)) != null) {
            string = index.getName();
            boolean bl = false;
            engineeringObjectSelection4 = new EngineeringObjectSelection(string);
            KeyIndexComparator keyIndexComparator = new KeyIndexComparator(candidateKey, index, candidateKey.getDesign().getKeyIdxPropertyList());
            engineeringObjectSelection4.setPropertiesComparator(keyIndexComparator);
            engineeringObjectSelection3.setPropertiesComparator(keyIndexComparator);
            if (bl) {
                engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_UNCHANGED);
                engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_UNCHANGED);
                engineeringObjectSelection3.setSelected(false);
                engineeringObjectSelection3.setEditable(false);
                keyIndexComparator.setReadOnly(true);
            } else {
                engineeringObjectSelection4.setSelected(keyIndexComparator.isModified());
            }
            this.comparatorsMap.put(keyIndexComparator.getID(), keyIndexComparator);
        }
        if (index == null) {
            XtdMapping xtdMapping3;
            string = this.getDesign().transformNameFromLogicalToRelational(candidateKey);
            engineeringObjectSelection4 = new EngineeringObjectSelection(string);
            engineeringObjectSelection4.setElementDescriptor(CandidateKey.class);
            if (table == null || (xtdMapping3 = candidateKey.getDeletedMapping(table)) != null) {
                // empty if block
            }
            KeyIndexComparator keyIndexComparator = new KeyIndexComparator(candidateKey, index, candidateKey.getDesign().getKeyIdxPropertyList());
            engineeringObjectSelection4.setPropertiesComparator(keyIndexComparator);
            engineeringObjectSelection3.setPropertiesComparator(keyIndexComparator);
            this.comparatorsMap.put(keyIndexComparator.getID(), keyIndexComparator);
            engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_NEW);
            engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_NEW);
            engineeringObjectSelection3.setSelected(candidateKey.getShouldEngineer());
        }
        engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
        engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
        engineeringObjectSelection.addChild(engineeringObjectSelection3);
        engineeringObjectSelection2.addChild(engineeringObjectSelection4);
    }

    public EngineeringObjectSelection getRelationalRoot() {
        return this.relationalRoot;
    }

    public EngineeringObjectSelection getLogicalRoot() {
        return this;
    }

    public Map getComparatorsMap() {
        return this.comparatorsMap;
    }

    public List getDeletedMappings() {
        return this.deletedMappings;
    }

    void processRelation(Relation relation, List list) {
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        ArrayList<Entity> arrayList2 = new ArrayList<Entity>();
        Entity entity = relation.getSourceEntity();
        Entity entity2 = relation.getTargetEntity();
        if (entity.isHierarchicalEntityType()) {
            if ("Table per child".equals(entity.getFwdEngineeringStrategyName())) {
                arrayList.addAll(entity.getHierarchicalLeaves());
            } else if ("Single Table".equals(entity.getFwdEngineeringStrategyName())) {
                arrayList.add(entity.getHierarchicalRoot());
            } else if ("Table for each entity".equals(entity.getFwdEngineeringStrategyName())) {
                arrayList.add(entity);
            }
        } else {
            arrayList.add(entity);
        }
        if (entity2.isHierarchicalEntityType()) {
            if ("Table per child".equals(entity2.getFwdEngineeringStrategyName())) {
                arrayList2.addAll(entity2.getHierarchicalLeaves());
            } else if ("Single Table".equals(entity2.getFwdEngineeringStrategyName())) {
                arrayList2.add(entity2.getHierarchicalRoot());
            } else if ("Table for each entity".equals(entity2.getFwdEngineeringStrategyName())) {
                arrayList2.add(entity2);
            }
        } else {
            arrayList2.add(entity2);
        }
        List list2 = this.xmap.getMappingsForDesignPart(relation, this.targetDesPartID);
        for (int i = 0; i < arrayList.size(); ++i) {
            Entity entity3 = (Entity)arrayList.get(i);
            for (int j = 0; j < arrayList2.size(); ++j) {
                Entity entity4 = (Entity)arrayList2.get(j);
                RelationMapping relationMapping = new RelationMapping(entity3, entity4);
                this.processRelation(relation, entity3, entity4, relationMapping);
                this.addPreviousThatWillBeDeleted(relation, list2, arrayList, arrayList2, relationMapping);
                list.add(relationMapping);
            }
        }
    }

    private void addPreviousThatWillBeDeleted(Relation relation, List list, List list2, List list3, RelationMapping relationMapping) {
        for (XtdMapping xtdMapping : list) {
            DesignObject designObject = xtdMapping.getObjectMappedTo(relation);
            if (designObject == null || 0 == xtdMapping.getInheritanceType() || this.containsDesObject(list2, xtdMapping.getRealSourceEntityID()) && this.containsDesObject(list3, xtdMapping.getRealTargetEntityID()) || !this.shouldDelete(designObject)) continue;
            relationMapping.deleted.add(designObject);
        }
    }

    private boolean containsDesObject(List list, String string) {
        for (DesignObject designObject : list) {
            if (!designObject.getObjectID().equals(string)) continue;
            return true;
        }
        return false;
    }

    private void processRelation(Relation relation, Entity entity, Entity entity2, RelationMapping relationMapping) {
        block41: {
            block39: {
                Table table;
                DesignObject designObject;
                RepositoryObject repositoryObject;
                Object object;
                Object object2;
                int[] nArray;
                Table table2;
                Table table3;
                List list;
                Entity entity3;
                Entity entity4;
                block40: {
                    List list2 = this.xmap.getMappingsForDesignPart(relation, this.targetDesPartID);
                    entity4 = relation.getSourceEntity();
                    entity3 = relation.getTargetEntity();
                    list = this.getRelationMappingsFor(list2, entity, entity2);
                    table3 = entity.getEngTable(this.phdes);
                    table2 = entity2.getEngTable(this.phdes);
                    relationMapping.pkNumber = relation.getPKProviderEndPoint().length;
                    if (table3 == null || table2 == null) break block39;
                    nArray = relation.getPKProviderEndPoint();
                    if (!relation.isManyToMany()) break block40;
                    relationMapping.many = true;
                    if (list.size() > 1) {
                        for (XtdMapping xtdMapping : list) {
                            DesignObject designObject2 = xtdMapping.getObjectMappedTo(relation);
                            if (designObject2 == null) continue;
                            relationMapping.status = ModelIdObjectSelection.STATE_DELETED;
                            relationMapping.deleted.add(designObject2);
                        }
                        list.clear();
                    } else if (list.size() == 1) {
                        XtdMapping xtdMapping = (XtdMapping)list.get(0);
                        DesignObject designObject3 = xtdMapping.getObjectMappedTo(relation);
                        if (designObject3 != null && !(designObject3 instanceof Table)) {
                            if (this.shouldDelete(designObject3)) {
                                relationMapping.status = ModelIdObjectSelection.STATE_DELETED;
                                relationMapping.deleted.add(designObject3);
                            }
                            list.clear();
                        } else if (designObject3 != null && designObject3 instanceof Table) {
                            relationMapping.existing.add(designObject3);
                        }
                    }
                    if (list.size() != 0) break block41;
                    relationMapping.status = ModelIdObjectSelection.STATE_NEW;
                    relationMapping.newStrings.add(NEW_TABLE);
                    break block41;
                }
                if (list.size() == 1 && (object2 = ((XtdMapping)(object = (XtdMapping)list.get(0))).getObjectMappedTo(relation)) != null && object2 instanceof Table) {
                    relationMapping.status = ModelIdObjectSelection.STATE_DELETED;
                    relationMapping.many = true;
                    relationMapping.deleted.add(object2);
                }
                if (list.size() > 0 && nArray.length == 0) {
                    object = new ArrayList(list);
                    object2 = object.iterator();
                    while (object2.hasNext()) {
                        XtdMapping xtdMapping = (XtdMapping)object2.next();
                        repositoryObject = xtdMapping.getObjectMappedTo(relation);
                        if (repositoryObject == null || !this.shouldDelete((DesignObject)repositoryObject)) continue;
                        relationMapping.status = ModelIdObjectSelection.STATE_DELETED;
                        relationMapping.deleted.add(repositoryObject);
                        list.remove(repositoryObject);
                    }
                } else if (list.size() == 2 && nArray.length == 1) {
                    object = relation.getEntity(nArray[0]);
                    object2 = null;
                    if (object == entity4) {
                        object2 = table3;
                    } else if (object == entity3) {
                        object2 = table2;
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        repositoryObject = (XtdMapping)list.get(i);
                        DesignObject designObject4 = ((XtdMapping)repositoryObject).getObjectMappedTo(relation);
                        if (designObject4 == null || !(designObject4 instanceof FKIndexAssociation)) continue;
                        designObject = (FKIndexAssociation)designObject4;
                        table = ((FKIndexAssociation)designObject).getRemoteTable();
                        if (table != object2) {
                            if (!this.shouldDelete(designObject)) continue;
                            relationMapping.status = ModelIdObjectSelection.STATE_DELETED;
                            relationMapping.deleted.add(designObject4);
                            continue;
                        }
                        relationMapping.existing.add(designObject4);
                    }
                } else if (list.size() == 1 && nArray.length == 2) {
                    object = (XtdMapping)list.get(0);
                    object2 = ((XtdMapping)object).getObjectMappedTo(relation);
                    if (object2 != null && object2 instanceof FKIndexAssociation) {
                        FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)object2;
                        repositoryObject = fKIndexAssociation.getRemoteTable();
                        for (int i = 0; i < nArray.length; ++i) {
                            designObject = relation.getEntity(nArray[i]);
                            table = null;
                            if (designObject == entity4) {
                                table = table3;
                            } else if (designObject == entity3) {
                                table = table2;
                            }
                            if (repositoryObject != table) {
                                relationMapping.newStrings.add(NEW_FK);
                                continue;
                            }
                            relationMapping.existing.add(object2);
                        }
                    }
                } else if (list.size() == 1 && nArray.length == 1) {
                    object = relation.getEntity(nArray[0]);
                    object2 = null;
                    if (object == entity4) {
                        object2 = table3;
                    } else if (object == entity3) {
                        object2 = table2;
                    }
                    XtdMapping xtdMapping = (XtdMapping)list.get(0);
                    repositoryObject = xtdMapping.getObjectMappedTo(relation);
                    if (repositoryObject != null && repositoryObject instanceof FKIndexAssociation) {
                        FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)repositoryObject;
                        designObject = fKIndexAssociation.getRemoteTable();
                        if (designObject != object2) {
                            if (this.shouldDelete(fKIndexAssociation)) {
                                relationMapping.deleted.add(repositoryObject);
                            }
                        } else {
                            relationMapping.existing.add(repositoryObject);
                        }
                    }
                }
                list = this.xmap.getMappingsForDesignPart(relation, this.targetDesPartID);
                if ((list = this.getRelationMappingsFor(list, entity, entity2)).size() != 0) break block41;
                for (int i = 0; i < nArray.length; ++i) {
                    relationMapping.newStrings.add(NEW_FK);
                }
                break block41;
            }
            if (relation.isManyToMany()) {
                relationMapping.newStrings.add(NEW_TABLE);
            } else {
                int[] nArray = relation.getPKProviderEndPoint();
                for (int i = 0; i < nArray.length; ++i) {
                    relationMapping.newStrings.add(NEW_FK);
                }
            }
        }
    }

    boolean shouldDelete(DesignObject designObject) {
        return true;
    }

    private List getRelationMappingsFor(List list, Entity entity, Entity entity2) {
        ArrayList<XtdMapping> arrayList = new ArrayList<XtdMapping>();
        for (XtdMapping xtdMapping : list) {
            if (!entity.getObjectID().equals(xtdMapping.getRealSourceEntityID()) || !entity2.getObjectID().equals(xtdMapping.getRealTargetEntityID())) continue;
            arrayList.add(xtdMapping);
        }
        if (arrayList.size() == 0) {
            for (XtdMapping xtdMapping : list) {
                if (xtdMapping.getRealSourceEntityID() != null || xtdMapping.getRealTargetEntityID() != null) continue;
                arrayList.add(xtdMapping);
            }
        } else {
            return arrayList;
        }
        if (arrayList.size() != list.size()) {
            arrayList.clear();
        }
        return arrayList;
    }

    private void addEntitySubView(DPVLogicalSubView dPVLogicalSubView, EngineeringObjectSelection engineeringObjectSelection, EngineeringObjectSelection engineeringObjectSelection2) {
        EngineeringObjectSelection engineeringObjectSelection3 = new EngineeringObjectSelection(dPVLogicalSubView.getPlaceHolder());
        engineeringObjectSelection3.setSelected(dPVLogicalSubView.getPlaceHolder().getShouldEngineer());
        DPVRelationalSubView dPVRelationalSubView = ((DesignPartViewPlaceHolder)dPVLogicalSubView.getPlaceHolder()).getEngTabSubView(this.phdes);
        EngineeringObjectSelection engineeringObjectSelection4 = null;
        if (dPVRelationalSubView != null) {
            if (dPVLogicalSubView.getPlaceHolder().shouldBeEngineered() || !dPVLogicalSubView.getDesign().getExcludeFromTree()) {
                engineeringObjectSelection4 = new EngineeringObjectSelection(dPVRelationalSubView.getPlaceHolder());
                EntitySubViewTableSubViewComparator entitySubViewTableSubViewComparator = new EntitySubViewTableSubViewComparator((DesignPartViewPlaceHolder)dPVLogicalSubView.getPlaceHolder(), (DesignPartViewPlaceHolder)dPVRelationalSubView.getPlaceHolder());
                engineeringObjectSelection4.setPropertiesComparator(entitySubViewTableSubViewComparator);
                engineeringObjectSelection3.setPropertiesComparator(entitySubViewTableSubViewComparator);
                engineeringObjectSelection4.setSelected(entitySubViewTableSubViewComparator.isModified());
                this.comparatorsMap.put(entitySubViewTableSubViewComparator.getID(), entitySubViewTableSubViewComparator);
                engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
                engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
                engineeringObjectSelection2.addChild(engineeringObjectSelection4);
                engineeringObjectSelection.addChild(engineeringObjectSelection3);
            }
        } else if (dPVLogicalSubView.getPlaceHolder().shouldBeEngineered() || !dPVLogicalSubView.getDesign().getExcludeFromTree()) {
            String string = "From_LM_" + dPVLogicalSubView.getPlaceHolder();
            engineeringObjectSelection4 = new EngineeringObjectSelection(string);
            engineeringObjectSelection4.setElementDescriptor(DesignPartViewPlaceHolder.class);
            XtdMapping xtdMapping = ((DesignPartViewPlaceHolder)dPVLogicalSubView.getPlaceHolder()).getDeletedMapping(this.phdes.getObjectID());
            if (xtdMapping == null || !this.getDesign().isApplyNameStandardization()) {
                // empty if block
            }
            EntitySubViewTableSubViewComparator entitySubViewTableSubViewComparator = new EntitySubViewTableSubViewComparator((DesignPartViewPlaceHolder)dPVLogicalSubView.getPlaceHolder(), null);
            engineeringObjectSelection4.setPropertiesComparator(entitySubViewTableSubViewComparator);
            engineeringObjectSelection3.setPropertiesComparator(entitySubViewTableSubViewComparator);
            this.comparatorsMap.put(entitySubViewTableSubViewComparator.getID(), entitySubViewTableSubViewComparator);
            engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_NEW);
            engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_NEW);
            engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
            engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
            engineeringObjectSelection2.addChild(engineeringObjectSelection4);
            engineeringObjectSelection.addChild(engineeringObjectSelection3);
        }
    }

    private void addDeletedEntitySubViews(EngineeringObjectSelection engineeringObjectSelection, EngineeringObjectSelection engineeringObjectSelection2) {
        Iterator iterator = this.phdes.getPhysicalDesignSubviews().iterator();
        String string = this.ldes.getObjectID();
        while (iterator.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
            XtdMapping xtdMapping = designPartViewPlaceHolder.getDeletedMapping(string);
            if (xtdMapping == null || xtdMapping.getDeletedID() == null) continue;
            String string2 = xtdMapping.getNameFor(xtdMapping.getDeletedID());
            EngineeringObjectSelection engineeringObjectSelection3 = new EngineeringObjectSelection(string2);
            this.deletedMappings.add(engineeringObjectSelection3);
            engineeringObjectSelection3.setSelected(false);
            EngineeringObjectSelection engineeringObjectSelection4 = new EngineeringObjectSelection(designPartViewPlaceHolder);
            engineeringObjectSelection3.setElementDescriptor(DPVLogicalSubView.class);
            this.setEmptyComparator(engineeringObjectSelection3);
            this.setEmptyComparator(engineeringObjectSelection4);
            engineeringObjectSelection3.setStatus(ModelIdObjectSelection.STATE_DELETED);
            engineeringObjectSelection4.setStatus(ModelIdObjectSelection.STATE_DELETED);
            engineeringObjectSelection4.setCorrespondentNode(engineeringObjectSelection3);
            engineeringObjectSelection3.setCorrespondentNode(engineeringObjectSelection4);
            engineeringObjectSelection2.addChild(engineeringObjectSelection4);
            engineeringObjectSelection.addChild(engineeringObjectSelection3);
        }
    }

    private List getEntitiesWitnMultiMappings() {
        RepositoryObject repositoryObject22;
        ArrayList<RepositoryObject> arrayList = new ArrayList<RepositoryObject>();
        for (RepositoryObject repositoryObject22 : this.entitylist) {
            if (((Entity)repositoryObject22).isHierarchicalEntityType()) continue;
            arrayList.add(repositoryObject22);
        }
        repositoryObject22 = this.ldes.getDesign().getExtendedMap();
        String string = this.phdes.getObjectID();
        ArrayList<Entity> arrayList2 = new ArrayList<Entity>();
        for (Entity entity : arrayList) {
            List list = ((ExtendedMapBase)repositoryObject22).getMappingsForDesignPart(entity, string);
            if (list.size() <= 1) continue;
            arrayList2.add(entity);
            this.multiMapped.put(entity.getObjectID(), entity);
        }
        return arrayList2;
    }

    class RelationMapping {
        Entity sourceEntity;
        Entity targetEntity;
        int pkNumber = 1;
        int status = ModelIdObjectSelection.STATE_UNCHANGED;
        List deleted = new ArrayList();
        List newStrings = new ArrayList();
        List existing = new ArrayList();
        boolean many = false;

        RelationMapping(Entity entity, Entity entity2) {
            this.sourceEntity = entity;
            this.targetEntity = entity2;
        }
    }
}

