/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.text.MessageFormat;
import java.util.List;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;

public class EntityTableComparator
extends EngPropertiesComparator {
    private final Entity entity;
    private final Table table;

    public EntityTableComparator(Entity entity, Table table) {
        super(entity, table);
        this.entity = entity;
        this.table = table;
        this.initPropertiesList();
    }

    public EntityTableComparator(Entity entity, Table table, List list) {
        this(entity, table);
        this.applyCompareFilter(list, entity.getDesign().getShowSelPropsOnly());
    }

    @Override
    public void copySelectedProperties() {
        if (!this.isReadOnly()) {
            this.copyPropertiesFromLeftToRight();
            this.copyPropertiesFromEntityToTable();
        }
    }

    @Override
    protected void initNameProperty() {
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(NAME);
        engPropertyHolder.setLeftValue(this.entity != null ? this.entity.getName() : "");
        engPropertyHolder.setRightValue(this.table != null ? this.table.getName() : "");
        if (this.entity != null && this.table != null && !this.entity.getName().equals(this.table.getName())) {
            boolean bl = false;
            if (this.getDesign().isApplyNameStandardization()) {
                String string = this.getDesign().transformNameFromLogicalToRelational(this.entity);
                if (!string.equals(this.table.getName())) {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl) {
                if (this.entity.getFwdEngineeringStrategyName().equals("Single Table") && !this.entity.isHierarchicalRoot()) {
                    bl = false;
                }
                if (this.entity.getFwdEngineeringStrategyName().equals("Table per child") && this.entity.getHierarchicalChildrenCount() > 0) {
                    bl = false;
                }
                if (bl) {
                    engPropertyHolder.setModified(true);
                    engPropertyHolder.setSelected(true);
                }
            }
        }
        this.propertiesList.add(engPropertyHolder);
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        if (this.getDesign().isApplyNameStandardization() && !this.getDesign().isLoading()) {
            this.initNameTranslationProperty();
        }
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(SHORT_NAME_ABBR);
        engPropertyHolder.setLeftValue(this.entity != null ? this.entity.getShortName() : "");
        engPropertyHolder.setRightValue(this.table != null ? this.table.getAbbreviation() : "");
        if (this.entity != null && this.table != null && !this.entity.getShortName().equals(this.table.getAbbreviation())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        this.initCommentsAndNotes();
        engPropertyHolder = new EngPropertyHolder(TEMP_TABLE_SCOPE);
        engPropertyHolder.setLeftValue(this.entity != null ? this.entity.getScope() : "");
        engPropertyHolder.setRightValue(this.table != null ? this.table.getScope() : "");
        if (this.entity != null && this.table != null && !this.entity.getScope().equals(this.table.getScope())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(TABLE_TYPE);
        engPropertyHolder.setLeftValue(this.entity != null ? this.entity.getDesign().getDLSettings().getClassificationTypeNameByID(this.entity.getTypeID()) : "");
        engPropertyHolder.setRightValue(this.table != null ? this.table.getDesign().getDLSettings().getClassificationTypeNameByID(this.table.getTypeID()) : "");
        if (this.entity != null && this.table != null && !this.entity.getTypeID().equals(this.table.getTypeID())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(STRUCTURED_TYPE);
        if (this.entity != null && this.entity.getBasedOnStructuredType() != null) {
            engPropertyHolder.setLeftValue(this.entity.getBasedOnStructuredType().getName());
        } else {
            engPropertyHolder.setLeftValue("");
        }
        if (this.table != null && this.table.getBasedOnStructuredType() != null) {
            engPropertyHolder.setRightValue(this.table.getBasedOnStructuredType().getName());
        } else {
            engPropertyHolder.setRightValue("");
        }
        if (this.entity != null && this.table != null && this.entity.getBasedOnStructuredType() != this.table.getBasedOnStructuredType()) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(ENT_TABLE_TYPE_SUBSTITUTION);
        engPropertyHolder.setRightValue(this.table != null && this.table.getTypeSubstitution() != null ? String.valueOf(this.table.getTypeSubstitution().getParentContainerObject().getName()) : "");
        engPropertyHolder.setLeftValue(this.entity != null && this.entity.getTypeSubstitution() != null ? String.valueOf(this.entity.getTypeSubstitution().getParentContainerObject().getName()) : "");
        if (this.table != null && this.entity != null) {
            if (this.entity.getTypeSubstitution() != null) {
                Entity entity = (Entity)this.entity.getTypeSubstitution().getParentContainerObject();
                Table table = null;
                if (this.table.getTypeSubstitution() != null) {
                    table = (Table)this.table.getTypeSubstitution().getParentContainerObject();
                }
                if (entity.getEngTable((RelationalDesign)this.table.getDesignPart()) != table) {
                    engPropertyHolder.setModified(true);
                    engPropertyHolder.setSelected(true);
                }
            } else if (this.table.getTypeSubstitution() != null) {
                engPropertyHolder.setModified(true);
                engPropertyHolder.setSelected(true);
            }
        } else if (this.entity != null && this.entity.getTypeSubstitution() != null) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(MIN_VOLUMES);
        engPropertyHolder.setLeftValue(this.entity != null ? this.entity.getMinVolumes() : "");
        engPropertyHolder.setRightValue(this.table != null ? this.table.getMinVolumes() : "");
        if (this.entity != null && this.table != null && !this.entity.getMinVolumes().equals(this.table.getMinVolumes())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(EXPECTED_VOLUMES);
        engPropertyHolder.setLeftValue(this.entity != null ? this.entity.getExpectedVolumes() : "");
        engPropertyHolder.setRightValue(this.table != null ? this.table.getExpectedVolumes() : "");
        if (this.entity != null && this.table != null && !this.entity.getExpectedVolumes().equals(this.table.getExpectedVolumes())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(MAX_VOLUMES);
        engPropertyHolder.setLeftValue(this.entity != null ? this.entity.getMaxVolumes() : "");
        engPropertyHolder.setRightValue(this.table != null ? this.table.getMaxVolumes() : "");
        if (this.entity != null && this.table != null && !this.entity.getMaxVolumes().equals(this.table.getMaxVolumes())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(GROWTH_PERCENT);
        engPropertyHolder.setLeftValue(this.entity != null ? this.entity.getGrowthPercent() : "");
        engPropertyHolder.setRightValue(this.table != null ? this.table.getGrowthPercent() : "");
        if (this.entity != null && this.table != null && !this.entity.getGrowthPercent().equals(this.table.getGrowthPercent())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(GROWTH_TYPE);
        engPropertyHolder.setLeftValue(this.entity != null ? this.entity.getGrowthType() : "");
        engPropertyHolder.setRightValue(this.table != null ? this.table.getGrowthType() : "");
        if (this.entity != null && this.table != null && !this.entity.getGrowthType().equals(this.table.getGrowthType())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(NORMAL_FORM);
        engPropertyHolder.setLeftValue(this.entity != null ? this.entity.getNormalForm() : "");
        engPropertyHolder.setRightValue(this.table != null ? this.table.getNormalForm() : "");
        if (this.entity != null && this.table != null && !this.entity.getNormalForm().equals(this.table.getNormalForm())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(ADEQUATELY_NORMALIZED);
        engPropertyHolder.setLeftValue(this.entity != null ? this.entity.getAdequatelyNormalized() : "");
        engPropertyHolder.setRightValue(this.table != null ? this.table.getAdequatelyNormalized() : "");
        if (this.entity != null && this.table != null && !this.entity.getAdequatelyNormalized().equals(this.table.getAdequatelyNormalized())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
    }

    private void copyPropertiesFromEntityToTable() {
        if (this.entity != null && this.table != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(TEMP_TABLE_SCOPE)) {
                    this.table.setScope(this.entity.getScope());
                    continue;
                }
                if (engPropertyHolder.getName().equals(TABLE_TYPE)) {
                    this.table.setTypeID(this.entity.getTypeID());
                    continue;
                }
                if (engPropertyHolder.getName().equals(SHORT_NAME_ABBR)) {
                    this.table.setAbbreviation(this.entity.getShortName());
                    continue;
                }
                if (engPropertyHolder.getName().equals(STRUCTURED_TYPE)) {
                    this.table.setBasedOnStructuredType(this.entity.getBasedOnStructuredType());
                    continue;
                }
                if (engPropertyHolder.getName().equals(MIN_VOLUMES)) {
                    this.table.setMinVolumes(this.entity.getMinVolumes());
                    continue;
                }
                if (engPropertyHolder.getName().equals(EXPECTED_VOLUMES)) {
                    this.table.setExpectedVolumes(this.entity.getExpectedVolumes());
                    continue;
                }
                if (engPropertyHolder.getName().equals(MAX_VOLUMES)) {
                    this.table.setMaxVolumes(this.entity.getMaxVolumes());
                    continue;
                }
                if (engPropertyHolder.getName().equals(GROWTH_PERCENT)) {
                    this.table.setGrowthPercent(this.entity.getGrowthPercent());
                    continue;
                }
                if (engPropertyHolder.getName().equals(GROWTH_TYPE)) {
                    this.table.setGrowthType(this.entity.getGrowthType());
                    continue;
                }
                if (engPropertyHolder.getName().equals(NORMAL_FORM)) {
                    this.table.setNormalForm(this.entity.getNormalForm());
                    continue;
                }
                if (!engPropertyHolder.getName().equals(ADEQUATELY_NORMALIZED)) continue;
                this.table.setAdequatelyNormalized(this.entity.getAdequatelyNormalized());
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.entity != null ? MessageFormat.format(Messages.getString("EntityTableComparator.Entity"), this.entity.getName()) : "";
    }

    @Override
    public String getRightName() {
        return this.table != null ? MessageFormat.format(Messages.getString("EntityTableComparator.Table"), this.table.getName()) : "";
    }
}

