/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.List;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.relational.TableView;

public class EntViewTableViewComparator
extends EngPropertiesComparator {
    private EntityView entityView;
    private TableView tableView;

    public EntViewTableViewComparator(EntityView entityView, TableView tableView) {
        super(entityView, tableView);
        this.entityView = entityView;
        this.tableView = tableView;
        this.initPropertiesList();
    }

    public EntViewTableViewComparator(EntityView entityView, TableView tableView, List list) {
        this(entityView, tableView);
        this.applyCompareFilter(list, entityView.getDesign().getShowSelPropsOnly());
    }

    @Override
    public void copySelectedProperties() {
        if (!this.isReadOnly()) {
            this.copyPropertiesFromLeftToRight();
            this.copyPropertiesFromEntityViewToTableView();
        }
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentsAndNotes();
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(STRUCTURED_TYPE);
        if (this.entityView != null && this.entityView.getBasedOnStructuredType() != null) {
            engPropertyHolder.setLeftValue(this.entityView.getBasedOnStructuredType().getName());
        } else {
            engPropertyHolder.setLeftValue("");
        }
        if (this.tableView != null && this.tableView.getBasedOnStructuredType() != null) {
            engPropertyHolder.setRightValue(this.tableView.getBasedOnStructuredType().getName());
        } else {
            engPropertyHolder.setRightValue("");
        }
        if (this.entityView != null && this.tableView != null && this.entityView.getBasedOnStructuredType() != this.tableView.getBasedOnStructuredType()) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(WHERE_PROPERTY);
        engPropertyHolder.setLeftValue(this.entityView != null ? this.entityView.getWhere() : "");
        engPropertyHolder.setRightValue(this.tableView != null ? this.tableView.getWhere() : "");
        if (this.entityView != null && this.tableView != null && !this.entityView.getWhere().equals(this.tableView.getWhere())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(HAVING_PROPERTY);
        engPropertyHolder.setLeftValue(this.entityView != null ? this.entityView.getHaving() : "");
        engPropertyHolder.setRightValue(this.tableView != null ? this.tableView.getHaving() : "");
        if (this.entityView != null && this.tableView != null && !this.entityView.getHaving().equals(this.tableView.getHaving())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
        engPropertyHolder = new EngPropertyHolder(USER_DEFINED_DQL);
        engPropertyHolder.setLeftValue(this.entityView != null ? this.entityView.getUserDefinedSQL() : "");
        engPropertyHolder.setRightValue(this.tableView != null ? this.tableView.getUserDefinedSQL() : "");
        if (this.entityView != null && this.tableView != null && this.entityView.getUserDefined() && this.tableView.getUserDefined() && !this.entityView.getUserDefinedSQL().equals(this.tableView.getUserDefinedSQL())) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
    }

    private void copyPropertiesFromEntityViewToTableView() {
        if (this.entityView != null && this.tableView != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(STRUCTURED_TYPE)) {
                    this.tableView.setBasedOnStructuredType(this.entityView.getBasedOnStructuredType());
                    continue;
                }
                if (engPropertyHolder.getName().equals(WHERE_PROPERTY)) {
                    this.tableView.setWhere(this.entityView.getWhere());
                    continue;
                }
                if (engPropertyHolder.getName().equals(HAVING_PROPERTY)) {
                    this.tableView.setHaving(this.entityView.getHaving());
                    continue;
                }
                if (!engPropertyHolder.getName().equals(USER_DEFINED_DQL)) continue;
                this.tableView.setUserDefinedSQL(this.entityView.getUserDefinedSQL());
                this.tableView.setLayoutSQL(this.entityView.getLayoutSQL());
                this.tableView.setParsed(this.entityView.isParsed());
                this.tableView.setIncorrectSQL(this.entityView.isIncorrectSQL());
                this.tableView.setValidSQL(this.entityView.isValidSQL());
            }
        }
    }

    @Override
    protected boolean shouldApplyNametranslation() {
        return false;
    }
}

