/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.List;
import oracle.dbtools.crest.model.design.engineering.EngCOPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;

public class AttributeColumnComparator
extends EngCOPropertiesComparator {
    private Attribute attribute;
    private Column column;

    public AttributeColumnComparator(Attribute attribute, Column column) {
        super(attribute, column);
        this.attribute = attribute;
        this.column = column;
        this.initPropertiesList();
    }

    public AttributeColumnComparator(Attribute attribute, Column column, List list) {
        this(attribute, column);
        this.applyCompareFilter(list, attribute.getDesign().getShowSelPropsOnly());
    }

    @Override
    public void copySelectedProperties() {
        if (!this.isReadOnly()) {
            this.copyPropertiesFromLeftToRight();
            this.copyScopeFromAttributeToColumn();
        }
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public Column getColumn() {
        return this.column;
    }

    @Override
    protected void initPropertiesList() {
        super.initPropertiesList();
        EngPropertyHolder engPropertyHolder = new EngPropertyHolder(SCOPE);
        Table table = null;
        if (this.column != null && this.attribute != null && this.attribute.getScope() != null) {
            engPropertyHolder.setLeftValue(this.attribute.getScope().getName());
            table = ((Entity)this.attribute.getScope()).getEngTable((RelationalDesign)this.column.getDesignPart());
        } else {
            engPropertyHolder.setLeftValue("");
        }
        if (this.column != null && this.column.getScope() != null) {
            engPropertyHolder.setRightValue(this.column.getScope().getName());
        } else {
            engPropertyHolder.setRightValue("");
        }
        if (this.attribute != null && this.column != null && table != this.column.getScope()) {
            engPropertyHolder.setModified(true);
            engPropertyHolder.setSelected(true);
        }
        this.propertiesList.add(engPropertyHolder);
    }

    private void copyScopeFromAttributeToColumn() {
        if (this.attribute != null && this.column != null) {
            this.column.setTemporaryWriteable(true);
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected() || !engPropertyHolder.getName().equals(SCOPE)) continue;
                if (this.attribute.getScope() != null) {
                    Table table = ((Entity)this.attribute.getScope()).getEngTable((RelationalDesign)this.column.getDesignPart());
                    if (table != null) {
                        this.column.setScopeId(table.getObjectID());
                        continue;
                    }
                    this.column.setScopeId(null);
                    continue;
                }
                this.column.setScopeId(null);
            }
            this.column.setTemporaryWriteable(false);
        }
    }

    @Override
    public String getLeftName() {
        return this.attribute != null ? this.attribute.getContainerWithKeyObject().getName() + "." + this.attribute.getName() : "";
    }

    @Override
    public String getRightName() {
        return this.column != null ? this.column.getContainerWithKeyObject().getName() + "." + this.column.getName() : "";
    }
}

