/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.engineering;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMapBase;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;

public abstract class AbstractEngineering {
    public static boolean useSameOptionForAll = false;
    public static boolean keepExistingValues = true;
    private static Map stringMapF = new TreeMap();
    private static Map stringMapR = new TreeMap();
    protected Design design;
    protected ExtendedMapBase xmap;
    protected DesignPartView processedDPV;
    protected String targetDesPartID;
    protected Map comparatorsMap;

    public AbstractEngineering(Design design) {
        this.design = design;
        this.xmap = design.getExtendedMap();
    }

    public abstract void execute(Map var1);

    public DesignObject[] getProcessedObjects(DesignObjectSet designObjectSet) {
        if (this.processedDPV == null || this.processedDPV == this.processedDPV.getDesignPart().getMainView()) {
            return (DesignObject[])designObjectSet.toArray();
        }
        ArrayList<DesignObject> arrayList = new ArrayList<DesignObject>();
        Iterator iterator = designObjectSet.iterator();
        while (iterator.hasNext()) {
            DesignObject designObject = (DesignObject)iterator.next();
            if (!designObject.hasRepresentationInDPV(this.processedDPV)) continue;
            arrayList.add(designObject);
        }
        return arrayList.toArray(designObjectSet.getProtoArray());
    }

    public void setGraphicalPropertiesOnNewObject(ContainerObject containerObject, ContainerObject containerObject2) {
        ApplicationView applicationView = containerObject.getAppView();
        if (applicationView != null) {
            applicationView.setGraphicalPropsFor(containerObject2, applicationView.getGraphicalPropsFor(containerObject));
        }
    }

    public String transformFromLogical(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(this.tranformName(string.trim()), "_", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (stringMapF.containsKey(string2)) {
                stringBuffer.append(stringMapF.get(string2));
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public String transformFromRelational(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(this.tranformName(string.trim()), "_", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (stringMapR.containsKey(string2)) {
                stringBuffer.append(stringMapR.get(string2));
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String transformFromLogicalDefault(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(AbstractEngineering.tranformName(string.trim().replaceAll(" ", "_"), true, true), "_", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (stringMapF.containsKey(string2)) {
                stringBuffer.append(stringMapF.get(string2));
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String transformFromLogicalDefault(String string, boolean bl, char c, char c2) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = c != '\u0000' && c2 != '\u0000' ? new StringTokenizer(AbstractEngineering.tranformName(string.trim().replaceAll(String.valueOf(c), String.valueOf(c2)), bl, true), "_", true) : new StringTokenizer(AbstractEngineering.tranformName(string.trim().replaceAll(" ", "_"), bl, true), "_", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (stringMapF.containsKey(string2)) {
                stringBuffer.append(stringMapF.get(string2));
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String transformSeparatorFromLogical(String string, char c, char c2) {
        if (c != '\u0000' && c2 != '\u0000') {
            String string2 = string.trim().replaceAll(String.valueOf(c), String.valueOf(c2));
            if (c2 != ' ') {
                return string2.trim().replaceAll(" ", "_");
            }
            return string2;
        }
        return string.trim().replaceAll(" ", "_");
    }

    public static String transformSeparatorFromRelational(String string, char c, char c2) {
        if (c != '\u0000' && c2 != '\u0000') {
            String string2 = string.trim().replaceAll(String.valueOf(c), String.valueOf(c2));
            if (c2 != '_') {
                return string2.trim().replaceAll("_", " ");
            }
            return string2;
        }
        return AbstractEngineering.tranformName(string.trim().replaceAll("_", " "), false, true);
    }

    public static String transformFromRelationalDefault(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(AbstractEngineering.tranformName(string.trim(), false, false), "_", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (stringMapR.containsKey(string2)) {
                stringBuffer.append(stringMapR.get(string2));
                continue;
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private String tranformName(String string) {
        if (this.design.isCapitalNames()) {
            string = string.toUpperCase();
        }
        if (this.design.isReplaceSpaces()) {
            string = string.trim().replaceAll(" ", "_");
        }
        return string;
    }

    private static String tranformName(String string, boolean bl, boolean bl2) {
        if (bl) {
            string = string.toUpperCase();
        }
        if (bl2) {
            string = string.trim().replaceAll(" ", "_");
        }
        return string;
    }

    public boolean isModified(XtdMapping xtdMapping, DesignObject designObject) {
        return xtdMapping.getOwnerObject().getChange().getTime() > xtdMapping.getCreationTime();
    }

    public boolean isModified(XtdMapping xtdMapping) {
        long l = 2000L;
        DesignObject designObject = xtdMapping.getOwnerObject();
        DesignObject designObject2 = xtdMapping.getTargetObject();
        return designObject2 != null && designObject2.getChange().getTime() > xtdMapping.getCreationTime() + l || designObject != null && designObject.getChange().getTime() > xtdMapping.getCreationTime() + l;
    }

    public Map getComparatorsMap() {
        return this.comparatorsMap;
    }

    public Design getDesign() {
        return this.design;
    }

    static {
        stringMapF.put("ENTITY", "TABLE");
        stringMapF.put("ATTRIBUTE", "COLUMN");
        stringMapF.put("KEY", "INDEX");
        stringMapF.put("Entity", "Table");
        stringMapF.put("Attribute", "Column");
        stringMapF.put("Key", "Index");
        stringMapF.put("entity", "table");
        stringMapF.put("attribute", "column");
        stringMapF.put("key", "index");
        stringMapR.put("TABLE", "ENTITY");
        stringMapR.put("COLUMN", "ATTRIBUTE");
        stringMapR.put("INDEX", "KEY");
        stringMapR.put("Table", "Entity");
        stringMapR.put("Column", "Attribute");
        stringMapR.put("Index", "Key");
        stringMapR.put("table", "entity");
        stringMapR.put("column", "column");
        stringMapR.put("index", "key");
    }
}

