/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.util.TreeMap;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.Task;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.model.design.datatypes.DataTypeObject;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.datatypes.TypeElementPropertiesDialogEx;

public class TypeElement
extends DesignObject
implements DataTypeObject {
    public static final String TYPE_NAME = "TypeElement";
    private StructuredType structuredType;
    private boolean isReference;
    private DesignObject type;
    private String typeID = "";
    private String size;
    private int precision;
    private int scale;
    private DTReference referenceRelation;
    protected ObjectChangeEvent sharedEvent = new ObjectChangeEvent("ChangeEvent");
    public static final String PARAM_SCALE = "scale";
    public static final String PARAM_PRECISION = "precision";
    public static final String PARAM_SIZE = "size";
    public static final int TYPE_NONE_COMPLEX = 0;
    public static final int TYPE_REFERENCE = 1;
    public static final int TYPE_STRUCT_COMPOSITION = 2;
    public static final int TYPE_COLLECTION_OF_REFS = 3;
    public static final int TYPE_COLLECTION_OF_EMBEDDED_STR = 4;
    public static final int TYPE_COLLECTION_OF_COLLECTION_TYPE = 5;
    public static final int TYPE_COLLECTION_OF_BASIC_TYPE = 6;
    private int datatypeDescriptor = 4;
    private boolean mandatory = false;
    private String referenceRelationID = null;
    private Domain domain;
    private String units;

    public TypeElement(DesignPart designPart, StructuredType structuredType) {
        super(designPart);
        if (designPart.getDesign().getAppView() != null && !ApplicationView.importing && !designPart.getDesign().isMerging()) {
            this.setMandatory(!designPart.getDesign().getAppView().getSettings().getNullsAllowed());
        }
        this.structuredType = structuredType;
    }

    public void setStructuredType(StructuredType structuredType) {
        this.structuredType = structuredType;
    }

    public StructuredType getStructuredType() {
        return this.structuredType;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public boolean isReference() {
        return this.isReference;
    }

    @Override
    public void setReference(boolean bl) {
        if (this.isReference != bl) {
            this.isReference = bl;
            this.fireChange(this.sharedEvent);
        }
    }

    @Override
    public void remove() {
        this.updateReference(null);
        if (this.structuredType != null) {
            this.structuredType.remove(this);
        }
        if (this.referenceRelation != null) {
            this.referenceRelation.setTypeElement(null);
            this.referenceRelation.remove();
            this.referenceRelation = null;
        }
        super.remove();
    }

    @Override
    public DesignObject getType() {
        if (!"".equalsIgnoreCase(this.typeID)) {
            this.type = this.getDesign().getDesignObject(this.typeID);
            if (this.type != null) {
                this.typeID = "";
                if (this.type instanceof Domain) {
                    this.domain = (Domain)this.type;
                }
            }
        } else if (this.type == null) {
            this.type = this.getDesign().getDomainSet().getDefaultDomain();
            this.domain = (Domain)this.type;
            this.setDataTypeDescriptor();
        }
        return this.type;
    }

    @Override
    public void setType(DesignObject designObject) {
        if (this.type != designObject) {
            this.type = designObject;
            this.fireChange(this.sharedEvent);
        }
    }

    private void setDataTypeDescriptor() {
        this.getType();
        if (this.type == null) {
            this.datatypeDescriptor = 0;
        } else if (this.type instanceof StructuredType && this.isReference) {
            this.datatypeDescriptor = 1;
        } else if (this.type instanceof StructuredType && !this.isReference) {
            this.datatypeDescriptor = 2;
        } else if (this.type instanceof CollectionType) {
            TypeElement typeElement = ((CollectionType)this.type).getElementType();
            this.datatypeDescriptor = typeElement.getDatatypeDescriptor() == 1 ? 3 : (typeElement.getDatatypeDescriptor() == 2 ? 4 : (typeElement.getType() instanceof CollectionType ? 5 : 6));
        }
    }

    public void updateReference() {
        if (this.type instanceof StructuredType) {
            StructuredType structuredType = (StructuredType)this.type;
            if (!this.getDesign().isLoading()) {
                this.updateReference(structuredType);
            }
        } else if (this.type instanceof CollectionType) {
            DesignObject designObject = ((CollectionType)this.type).getElementType().getType();
            if (designObject instanceof StructuredType) {
                StructuredType structuredType = (StructuredType)designObject;
                if (!this.getDesign().isLoading()) {
                    this.updateReference(structuredType);
                }
            }
        } else {
            this.updateReference(null);
        }
        this.fireChange(ObjectChangeEvent.HIERARCHICAL_PARENT_CHANGED);
    }

    @Override
    public String getDataType() {
        return this.formatDataType();
    }

    public String getDataType(String string) {
        String string2 = "";
        int n = 0;
        int n2 = 0;
        String string3 = "NONE";
        if (this.getType() != null) {
            Object object;
            if (this.getType() instanceof Domain) {
                object = (Domain)this.getType();
                LogicalDatatype logicalDatatype = ((Domain)object).getLogicalDatatype();
                TreeMap<String, String> treeMap = new TreeMap<String, String>();
                treeMap.put(PARAM_SIZE, "" + ((Domain)object).getSize());
                treeMap.put(PARAM_PRECISION, "" + ((Domain)object).getPrecision());
                treeMap.put(PARAM_SCALE, "" + ((Domain)object).getScale());
                string3 = logicalDatatype.createDataType(string, treeMap).toString();
            } else {
                if (this.getType() instanceof LogicalDatatype) {
                    string2 = this.size;
                    n = this.precision;
                    n2 = this.scale;
                    TreeMap<String, String> treeMap = new TreeMap<String, String>();
                    treeMap.put(PARAM_SIZE, "" + string2);
                    if (this.getUnits() != null && this.getUnits().length() > 0) {
                        treeMap.put(PARAM_SIZE, "" + string2 + " " + this.getUnits());
                    } else {
                        treeMap.put(PARAM_SIZE, "" + string2);
                    }
                    treeMap.put(PARAM_PRECISION, "" + this.precision);
                    treeMap.put(PARAM_SCALE, "" + this.scale);
                    string3 = ((LogicalDatatype)this.getType()).createDataType(string, treeMap).toString();
                    return string3;
                }
                if (this.getType() instanceof DistinctType) {
                    object = (DistinctType)this.getType();
                    if (((DistinctType)object).getLogicalDataType() != null) {
                        string2 = ((DistinctType)object).getSize();
                        n = ((DistinctType)object).getPrecision();
                        n2 = ((DistinctType)object).getScale();
                        TreeMap<String, String> treeMap = new TreeMap<String, String>();
                        treeMap.put(PARAM_SIZE, "" + string2);
                        treeMap.put(PARAM_PRECISION, "" + n);
                        treeMap.put(PARAM_SCALE, "" + n2);
                        string3 = ((DistinctType)object).getLogicalDataType().createDataType(string, treeMap).toString();
                        return string3;
                    }
                } else if (this.getType() instanceof StructuredType) {
                    string3 = this.isReference ? "REF " + this.getType().getName() : this.getType().getName();
                } else if (this.getType() instanceof CollectionType) {
                    string3 = this.getType().getName();
                }
            }
            object = new StringBuffer(string3);
            boolean bl = false;
            boolean bl2 = false;
            if (string2 != null && !string2.equals("") || n > 0 || n2 > 0) {
                bl = true;
            }
            if (bl) {
                ((StringBuffer)object).append('(');
            }
            if (string2 != null && !string2.equals("")) {
                ((StringBuffer)object).append(string2);
                bl2 = true;
            }
            if (n > 0) {
                if (bl2) {
                    ((StringBuffer)object).append(", ");
                }
                ((StringBuffer)object).append(n);
                bl2 = true;
            }
            if (n2 > 0) {
                if (bl2) {
                    ((StringBuffer)object).append(", ");
                }
                ((StringBuffer)object).append(n2);
            }
            if (bl) {
                ((StringBuffer)object).append(')');
            }
            return ((StringBuffer)object).toString();
        }
        return "NONE";
    }

    private String formatDataType() {
        String string = "";
        int n = 0;
        int n2 = 0;
        String string2 = "NONE";
        if (this.getType() != null) {
            Object object;
            if (this.getType() instanceof Domain) {
                string2 = ((Domain)this.getType()).getName();
            } else if (this.getType() instanceof LogicalDatatype) {
                string = this.size;
                n = this.precision;
                n2 = this.scale;
                string2 = ((LogicalDatatype)this.getType()).getName();
            } else if (this.getType() instanceof DistinctType) {
                object = (DistinctType)this.getType();
                if (((DistinctType)object).getLogicalDataType() != null) {
                    string = ((DistinctType)object).getSize();
                    n = ((DistinctType)object).getPrecision();
                    n2 = ((DistinctType)object).getScale();
                    string2 = ((DistinctType)object).getLogicalDataType().getName();
                }
            } else if (this.getType() instanceof StructuredType) {
                string2 = this.isReference ? "REF " + this.getType().getName() : this.getType().getName();
            } else if (this.getType() instanceof CollectionType) {
                string2 = ((CollectionType)this.getType()).getName();
            }
            object = new StringBuffer(string2);
            boolean bl = false;
            boolean bl2 = false;
            if (string != null && !string.equals("") || n > 0 || n2 > 0) {
                bl = true;
            }
            if (bl) {
                ((StringBuffer)object).append(" (");
            }
            if (string != null && !string.equals("")) {
                ((StringBuffer)object).append(string);
                if (this.getUnits() != null && this.getUnits().length() > 0) {
                    ((StringBuffer)object).append(" " + this.getUnits());
                }
                bl2 = true;
            }
            if (n > 0) {
                if (bl2) {
                    ((StringBuffer)object).append(", ");
                }
                ((StringBuffer)object).append(n);
                bl2 = true;
            }
            if (n2 > 0) {
                if (bl2) {
                    ((StringBuffer)object).append(", ");
                }
                ((StringBuffer)object).append(n2);
            }
            if (bl) {
                ((StringBuffer)object).append(')');
            }
            return ((StringBuffer)object).toString();
        }
        return "NONE";
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            TypeElementPropertiesDialogEx typeElementPropertiesDialogEx = new TypeElementPropertiesDialogEx(this.getDesign().getAppView(), this, false);
            typeElementPropertiesDialogEx.initProperties(this);
            typeElementPropertiesDialogEx.show();
        }
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public void setPrecision(int n) {
        this.precision = n;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public void setScale(int n) {
        this.scale = n;
    }

    @Override
    public String getSize() {
        return this.size;
    }

    @Override
    public void setSize(String string) {
        this.size = string;
    }

    @Override
    public void copy(DesignObject designObject) {
        super.copy(designObject);
        TypeElement typeElement = (TypeElement)designObject;
        typeElement.setMandatory(this.isMandatory());
        this.copyDataType(typeElement);
    }

    public void copyDataType(TypeElement typeElement) {
        typeElement.setType(this.getType());
        typeElement.setSize(this.getSize());
        typeElement.setPrecision(this.getPrecision());
        typeElement.setScale(this.getScale());
        typeElement.setUnits(this.getUnits());
        typeElement.setReference(this.isReference());
    }

    protected void updateReference(StructuredType structuredType) {
        if (structuredType == null) {
            if (this.referenceRelation != null) {
                this.referenceRelation.setTypeElement(null);
                this.referenceRelation.remove();
                this.referenceRelation = null;
            }
        } else {
            if (this.referenceRelation != null) {
                CollectionType collectionType;
                if (this.referenceRelation.getSourceDTObject() == this.type) {
                    this.referenceRelation.updatePresentation();
                    return;
                }
                if (this.type instanceof CollectionType && (collectionType = (CollectionType)this.type).getDataType() == this.referenceRelation.getSourceDTObject()) {
                    this.referenceRelation.updatePresentation();
                    return;
                }
                this.referenceRelation.setTypeElement(null);
                this.referenceRelation.remove();
            }
            this.referenceRelation = this.getDesign().getDataTypesDesign().createDTReference();
            if (this.referenceRelationID != null && !"".equals(this.referenceRelationID)) {
                this.referenceRelation.setObjectID(this.referenceRelationID);
            }
            this.referenceRelation.setTypeElement(this);
            this.referenceRelation.setSourceDTObject(structuredType);
            this.referenceRelation.setTargetDTObject(this.structuredType);
            this.referenceRelation.updatePresentation();
        }
    }

    public DTReference getReferenceRelation() {
        return this.referenceRelation;
    }

    public void setReferenceRelation(DTReference dTReference) {
        this.referenceRelation = dTReference;
    }

    @Override
    public String getLongName() {
        return this.structuredType.getName().concat(".").concat(this.getName());
    }

    public void setTypeID(String string) {
        this.typeID = string;
    }

    public String getTypeID() {
        if (this.type != null) {
            return this.type.getObjectID();
        }
        return this.typeID;
    }

    public int getDatatypeDescriptor() {
        this.setDataTypeDescriptor();
        return this.datatypeDescriptor;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean bl) {
        this.mandatory = bl;
    }

    @Override
    public boolean isReadOnly() {
        if (this.getStructuredType() != null && this.getStructuredType().isReadOnly()) {
            return true;
        }
        return super.isReadOnly();
    }

    public String getReferenceRelationID() {
        if (this.referenceRelation != null) {
            return this.referenceRelation.getObjectID();
        }
        return this.referenceRelationID;
    }

    public void setReferenceRelationID(String string) {
        this.referenceRelationID = string;
        if (this.referenceRelationID != null && this.referenceRelation == null) {
            this.createReferenceRelation();
        }
        if (this.referenceRelationID != null && this.referenceRelation == null) {
            this.getDesignPart().addTask(new CreateReferenceRelationTask(this));
        }
    }

    public void updateReferenceNew() {
        if (this.type instanceof StructuredType) {
            StructuredType structuredType = (StructuredType)this.type;
            this.updateReference(structuredType);
        } else if (this.type instanceof CollectionType) {
            DesignObject designObject = ((CollectionType)this.type).getElementType().getType();
            if (designObject instanceof StructuredType) {
                StructuredType structuredType = (StructuredType)designObject;
                this.updateReference(structuredType);
            }
        } else {
            this.updateReference(null);
        }
        this.fireChange(ObjectChangeEvent.HIERARCHICAL_PARENT_CHANGED);
    }

    private void createReferenceRelation() {
        if (this.getType() != null) {
            this.updateReferenceNew();
        }
    }

    public Domain getDomain() {
        return this.domain;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String string) {
        this.units = string;
    }

    public class CreateReferenceRelationTask
    implements Task {
        private static final String TASK_NAME = "create ReferenceRelation task";
        TypeElement te;

        CreateReferenceRelationTask(TypeElement typeElement2) {
            this.te = typeElement2;
        }

        @Override
        public boolean execute() {
            this.te.createReferenceRelation();
            return this.te.referenceRelation != null;
        }

        public String toString() {
            return TASK_NAME;
        }
    }
}

