/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.IDGenerator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.MethodParamSet;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.swingui.editor.datatypes.MethodPropertiesDialogEx;
import oracle.dbtools.crest.util.logging.Logger;

public class Method
extends DesignObject
implements ObjectListener {
    public static final String TYPE_NAME = "Method";
    private StructuredType structuredType;
    private boolean isConstructor = false;
    private boolean isOverriding = false;
    private Method overridedMethod;
    private List params = new ArrayList();
    private MethodParam returnValue;
    private String body = "";
    private IDGenerator localIDGenerator;
    private Map localIDs = new TreeMap();
    protected ObjectChangeEvent sharedEvent = new ObjectChangeEvent("ChangeEvent");
    private int number;
    private static final Logger LOGGER = new Logger(Method.class);

    public Method(DesignPart designPart, StructuredType structuredType) {
        super(designPart);
        this.structuredType = structuredType;
    }

    protected void assignLocalID(ModelIDObject modelIDObject) {
        String string = modelIDObject.getObjectID();
        if (string == null) {
            while (this.localIDs.containsKey(string = this.getLocalIDGenerator().createNewID())) {
            }
            this.localIDs.put(string, modelIDObject);
            modelIDObject.setObjectID(string);
        } else {
            this.localIDs.put(string, modelIDObject);
        }
    }

    public IDGenerator getLocalIDGenerator() {
        if (this.localIDGenerator == null) {
            this.localIDGenerator = new IDGenerator();
            this.localIDGenerator.initializeWith(10000L, 3000000L);
        }
        return this.localIDGenerator;
    }

    public StructuredType getStructuredType() {
        return this.structuredType;
    }

    public void setStructuredType(StructuredType structuredType) {
        this.structuredType = structuredType;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public void remove() {
        this.structuredType.removeMethod(this);
        super.remove();
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            MethodPropertiesDialogEx methodPropertiesDialogEx = new MethodPropertiesDialogEx(this.getDesign().getAppView(), this);
            methodPropertiesDialogEx.initProperties(this);
            methodPropertiesDialogEx.show();
        }
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String string) {
        this.body = string;
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public void setConstructor(boolean bl) {
        this.isConstructor = bl;
    }

    public boolean isOverriding() {
        return this.isOverriding;
    }

    public void setOverriding(boolean bl) {
        this.isOverriding = bl;
    }

    public Method getOverridedMethod() {
        return this.overridedMethod;
    }

    public void setOverridedMethod(Method method) {
        this.overridedMethod = method;
    }

    public List getParameters() {
        return this.params;
    }

    public void setParameters(List list) {
        this.params = list;
    }

    public MethodParam createParameter() {
        return this.createParameter(null);
    }

    public MethodParam createParameter(String string) {
        MethodParam methodParam = new MethodParam(this.getDesignPart());
        if (string != null) {
            methodParam.setName(string);
        }
        methodParam.setDesign(this.getDesign());
        this.addParameter(methodParam);
        return methodParam;
    }

    public void addParameter(int n, MethodParam methodParam) {
        if (methodParam == null || this.isReadOnly()) {
            return;
        }
        if (this.contains(methodParam)) {
            this.params.remove(methodParam);
            this.params.add(n, methodParam);
            return;
        }
        if (!this.getParamClass().isAssignableFrom(methodParam.getClass())) {
            LOGGER.error("Class: " + methodParam.getClass());
            LOGGER.error("Expected: " + this.getParamClass());
            throw new RuntimeException("Wrong class added to method.");
        }
        this.assignLocalID(methodParam);
        methodParam.setParent(this);
        methodParam.setMethod(this);
        this.params.add(n, methodParam);
        this.getParamSet().add(methodParam);
        methodParam.getName();
        this.sharedEvent.setAffected(methodParam);
        this.fireChange(this.sharedEvent);
    }

    public void addParameter(MethodParam methodParam) {
        if (methodParam == null || this.isReadOnly()) {
            return;
        }
        if (this.contains(methodParam)) {
            return;
        }
        if (!this.getParamClass().isAssignableFrom(methodParam.getClass())) {
            LOGGER.error("Class: " + methodParam.getClass());
            LOGGER.error("Expected: " + this.getParamClass());
            throw new RuntimeException("Wrong class added to method.");
        }
        this.assignLocalID(methodParam);
        methodParam.setParent(this);
        methodParam.setMethod(this);
        this.params.add(methodParam);
        this.getParamSet().add(methodParam);
        methodParam.getName();
        this.sharedEvent.setAffected(methodParam);
        this.fireChange(this.sharedEvent);
    }

    public MethodParamSet getParamSet() {
        return ((DataTypesDesign)this.getDesignPart()).getMethodParamSet();
    }

    public boolean contains(MethodParam methodParam) {
        return this.params.contains(methodParam);
    }

    public Class getParamClass() {
        return MethodParam.class;
    }

    public void removeParameter(MethodParam methodParam) {
        if (methodParam != null && this.isWriteable()) {
            this.getParamSet().remove(methodParam);
            this.params.remove(methodParam);
            this.localIDs.remove(methodParam.getObjectID());
            methodParam.removeObjectListener(this);
            methodParam.setParent(null);
            this.sharedEvent.setAffected(methodParam);
            this.fireChange(this.sharedEvent);
        }
    }

    public MethodParam getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(MethodParam methodParam) {
        if (methodParam != null && (methodParam.getObjectID() == null || methodParam.getObjectID().equals("null"))) {
            this.assignLocalID(methodParam);
        }
        this.returnValue = methodParam;
    }

    public MethodParam createReturnValue() {
        MethodParam methodParam = new MethodParam(this.getDesignPart());
        methodParam.setDesign(this.getDesign());
        this.setReturnValue(methodParam);
        return methodParam;
    }

    public void clearReturnValue() {
        this.returnValue = null;
    }

    @Override
    public void changed(DesignObject designObject, ObjectChangeEvent objectChangeEvent) {
        if (objectChangeEvent == ObjectChangeEvent.OBJECT_REMOVED) {
            if (objectChangeEvent.getAffected() instanceof MethodParam) {
                this.removeParameter((MethodParam)objectChangeEvent.getAffected());
            }
        } else {
            this.fireChange(objectChangeEvent);
        }
    }

    public void clearParams() {
        if (this.params.size() > 0) {
            Object[] objectArray = this.params.toArray();
            for (int i = objectArray.length - 1; i >= 0; --i) {
                MethodParam methodParam = (MethodParam)objectArray[i];
                this.removeParameter(methodParam);
            }
        }
    }

    @Override
    public String getLongName() {
        return this.structuredType.getName().concat(".").concat(this.getName());
    }

    @Override
    public boolean setName(String string) {
        if (this.isWriteable()) {
            if (string != null && string.equals(this.name)) {
                return true;
            }
            this.name = string;
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
            return true;
        }
        return false;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int n) {
        this.number = n;
    }
}

