/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.io.File;
import java.io.IOException;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.swingui.editor.datatypes.DistinctTypePropertiesDialogEx;

public class DistinctType
extends AbstractDTObject
implements Datatype {
    private LogicalDatatype logicalDataType;
    private String size;
    private int scale;
    private int precision;
    public static final String TYPE_NAME = "DistinctType";

    public DistinctType(DesignPart designPart) {
        super(designPart);
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public String getSize() {
        return this.size;
    }

    public void setSize(String string) {
        this.size = string;
    }

    public LogicalDatatype getLogicalDataType() {
        if (this.logicalDataType == null) {
            this.logicalDataType = this.getDesign().getLogicalDatatypeSet().getDefaultType();
        }
        return this.logicalDataType;
    }

    public void setLogicalDataType(LogicalDatatype logicalDatatype) {
        this.logicalDataType = logicalDatatype;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int n) {
        this.precision = n;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    @Override
    public int getByteSize() {
        return 0;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            DistinctTypePropertiesDialogEx distinctTypePropertiesDialogEx = new DistinctTypePropertiesDialogEx(this.getDesign().getAppView(), this);
            distinctTypePropertiesDialogEx.initProperties(this);
            distinctTypePropertiesDialogEx.show();
        }
    }

    public String getDataTypeString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getLogicalDataType().getName());
        if (this.size != null && !"".equalsIgnoreCase(this.size)) {
            stringBuffer.append(" (");
            stringBuffer.append(this.size);
            stringBuffer.append(")");
        } else if (this.precision > 0) {
            stringBuffer.append(" (");
            stringBuffer.append(this.precision);
            if (this.scale > 0) {
                stringBuffer.append(", ");
                stringBuffer.append(this.scale);
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "distincttype/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public Object translateIdToObject(String string, String string2) {
        DesignObject designObject = null;
        designObject = this.getDesign().getDesignObject(string2);
        if (designObject != null) {
            return designObject;
        }
        if ("logicalDataType".equalsIgnoreCase(string)) {
            designObject = this.getDesign().getLogicalDatatypeSet().getObjectByID(string2);
        }
        if (designObject != null) {
            return designObject;
        }
        return super.translateIdToObject(string, string2);
    }

    @Override
    public boolean hasProxyToDelete() {
        return true;
    }
}

