/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.TopViewCollection;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.DTRelation;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.datatypes.TVDTRelation;

public class AbstractDTObject
extends DesignObject {
    Collection allViews = new ArrayList();
    private List relationConnections = new ArrayList();
    private boolean predefined = false;
    private boolean isNullInstance = false;

    public AbstractDTObject(DesignPart designPart) {
        super(designPart);
        this.addObjectListener((DataTypesDesign)this.getDesignPart());
    }

    void add(DTRelation.Connection connection) {
        this.relationConnections.add(connection);
        ObjectChangeEvent.CONNECTION_ADDED.setAffected(connection);
        this.fireChange(ObjectChangeEvent.CONNECTION_ADDED);
    }

    void remove(DTRelation.Connection connection) {
        this.relationConnections.remove(connection);
        ObjectChangeEvent.CONNECTION_REMOVED.setAffected(connection);
        this.fireChange(ObjectChangeEvent.CONNECTION_REMOVED);
    }

    public DTRelation.Connection[] getAllLinks() {
        return (DTRelation.Connection[])this.relationConnections.toArray(DTRelation.CONNECTION_PROTO_ARRAY);
    }

    public void removeLinks() {
        for (int i = this.relationConnections.size() - 1; i >= 0; --i) {
            TVDTRelation tVDTRelation;
            DTRelation.Connection connection;
            DTRelation dTRelation;
            if (this.relationConnections.size() <= 0 || (dTRelation = (connection = (DTRelation.Connection)this.relationConnections.get(i)).getDTRelation()) == null) continue;
            if (dTRelation.getSource() != null) {
                dTRelation.getSource().remove(connection);
            }
            if (dTRelation.getTargetDTObject() != null) {
                dTRelation.getTargetDTObject().remove(connection);
            }
            if ((tVDTRelation = (TVDTRelation)dTRelation.getTopView()) == null) continue;
            tVDTRelation.remove();
        }
    }

    @Override
    public void remove() {
        this.removeLinks();
        this.removeAllViews();
        super.remove();
    }

    @Override
    public void setTopView(TopView topView) {
        this.addTopView(topView);
    }

    public void addTopView(TopView topView) {
        DesignPartView designPartView = topView.getDesignPartView();
        TopViewCollection topViewCollection = this.getViewsForDPV(designPartView);
        if (!topViewCollection.contains(topView)) {
            topViewCollection.add(topView);
            this.addObjectListener(topView);
        }
    }

    @Override
    public TopView getTopView() {
        Iterator iterator;
        TopViewCollection topViewCollection;
        if (!this.allViews.isEmpty() && !(topViewCollection = (TopViewCollection)(iterator = this.allViews.iterator()).next()).isEmpty()) {
            Iterator iterator2 = topViewCollection.iterator();
            return (TopView)iterator2.next();
        }
        return null;
    }

    @Override
    public TopView getTopViewByID(DesignPartView designPartView, String string, int n) {
        if (string != null) {
            Collection collection = this.getAllViews(designPartView);
            for (TopView topView : collection) {
                if (!string.equalsIgnoreCase(topView.getViewID())) continue;
                return topView;
            }
            int n2 = 0;
            for (TopView topView : collection) {
                if (n == n2) {
                    topView.setViewNumber(n);
                    return topView;
                }
                ++n2;
            }
        }
        return null;
    }

    public Collection getAllViews(DesignPartView designPartView) {
        ArrayList arrayList = new ArrayList();
        TopViewCollection topViewCollection = this.getViewsForDPV(designPartView);
        if (topViewCollection.size() > 0) {
            Iterator iterator = topViewCollection.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        return arrayList;
    }

    public Collection getAffectedDPVs() {
        HashSet<DesignPartView> hashSet = new HashSet<DesignPartView>();
        for (TopViewCollection topViewCollection : this.allViews) {
            if (topViewCollection.dpv == null || topViewCollection.size() <= 0) continue;
            hashSet.add(topViewCollection.dpv);
        }
        return hashSet;
    }

    public TopView getTopViewByID(String string) {
        TopViewCollection topViewCollection2 = null;
        for (TopViewCollection topViewCollection2 : this.allViews) {
            for (TopView topView : topViewCollection2) {
                if (!string.equalsIgnoreCase(topView.getViewID())) continue;
                return topView;
            }
        }
        return this.getTopView();
    }

    public void removeAllViews() {
        TopViewCollection[] topViewCollectionArray = this.allViews.toArray(new TopViewCollection[0]);
        for (int i = 0; i < topViewCollectionArray.length; ++i) {
            DesignPartView designPartView = topViewCollectionArray[i].getDPV();
            designPartView.getWorkSpace().removeDTObject(this);
            TopView[] topViewArray = topViewCollectionArray[i].toArray(new TopView[0]);
            for (int j = 0; j < topViewArray.length; ++j) {
                designPartView.unregisterFromTreemodel(topViewArray[j]);
                this.removeTopView(topViewArray[j]);
            }
        }
    }

    @Override
    public TopViewCollection getViewsForDPV(DesignPartView designPartView) {
        TopViewCollection topViewCollection2;
        for (TopViewCollection topViewCollection2 : this.allViews) {
            if (topViewCollection2.getDPV() != designPartView) continue;
            return topViewCollection2;
        }
        topViewCollection2 = new TopViewCollection();
        topViewCollection2.setDPV(designPartView);
        this.allViews.add(topViewCollection2);
        return topViewCollection2;
    }

    @Override
    public void resetViewNumbers() {
        for (TopViewCollection topViewCollection : this.allViews) {
            for (TopView topView : topViewCollection) {
                topView.setViewNumber(this.getViewNumber(topView));
            }
        }
    }

    public TopView getAnotherView(TopView topView) {
        DesignPartView designPartView = topView.getDesignPartView();
        TopViewCollection topViewCollection = this.getViewsForDPV(designPartView);
        for (TopView topView2 : topViewCollection) {
            if (topView2 == topView) continue;
            return topView2;
        }
        return null;
    }

    @Override
    public int getTopViewsCount() {
        int n = 0;
        for (TopViewCollection topViewCollection : this.allViews) {
            n += topViewCollection.size();
        }
        return n;
    }

    @Override
    public int getViewsCountForDPV(DesignPartView designPartView) {
        for (TopViewCollection topViewCollection : this.allViews) {
            if (topViewCollection.getDPV() != designPartView) continue;
            return topViewCollection.size();
        }
        return 0;
    }

    @Override
    public TopView getFirstViewForDPV(DesignPartView designPartView) {
        for (TopViewCollection topViewCollection : this.allViews) {
            if (topViewCollection.getDPV() != designPartView) continue;
            if (topViewCollection.size() > 0) {
                return (TopView)topViewCollection.get(0);
            }
            return null;
        }
        return null;
    }

    @Override
    public void removeViewSynonim(TopView topView) {
        this.removeTopView(topView);
    }

    public void removeTopView(TopView topView) {
        DesignPartView designPartView = topView.getDesignPartView();
        TopViewCollection topViewCollection = this.getViewsForDPV(designPartView);
        if (designPartView == this.getDesignPart().getMainView()) {
            if (topViewCollection.size() > 1) {
                topViewCollection.remove(topView);
            }
        } else {
            topViewCollection.remove(topView);
        }
        if (topViewCollection.size() == 0) {
            this.allViews.remove(topViewCollection);
        }
        this.removeObjectListener(topView);
    }

    @Override
    public String getObjectTypeName() {
        return null;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return false;
    }

    @Override
    public String getIDPrefix() {
        return null;
    }

    public boolean isPredefined() {
        return this.predefined;
    }

    public void setPredefined(boolean bl) {
        if (this.predefined != bl) {
            this.predefined = bl;
            this.fireChange(ObjectChangeEvent.PREDEFINED_STATUS_CHANGED);
        }
    }

    public boolean isNullInstance() {
        return this.isNullInstance;
    }

    public void setIsNullInstance(boolean bl) {
        this.isNullInstance = bl;
    }

    public List getAllTopViews() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        for (TopViewCollection topViewCollection : this.allViews) {
            for (TopView topView : topViewCollection) {
                arrayList.add(topView);
            }
        }
        return arrayList;
    }

    public List getAllViewsWithCellViews() {
        ArrayList<TopView> arrayList = new ArrayList<TopView>();
        for (TopViewCollection topViewCollection : this.allViews) {
            for (TopView topView : topViewCollection) {
                if (topView.getCellView() == null) continue;
                arrayList.add(topView);
            }
        }
        return arrayList;
    }
}

