/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.constraint;

import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.Constraint;
import oracle.dbtools.crest.model.design.constraint.AbstractConstraint;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.util.logging.Logger;

public class ConstraintSet
extends ModelObjectSet {
    private static final Object[] PROTO_ARRAY = new Constraint[0];
    private static final ConstraintTypeDescriptor[] CONSTRAINT_TYPES = new ConstraintTypeDescriptor[]{new ConstraintTypeDescriptor("Value List", 0), new ConstraintTypeDescriptor("Check Constraint", 1)};
    private static final Logger LOGGER = new Logger(ConstraintSet.class);

    @Override
    public Object[] getProtoTypeArray() {
        return PROTO_ARRAY;
    }

    @Override
    public String getDefaultNamePrefix() {
        return "Constraint";
    }

    public static Object[] getConstraintTypes() {
        return CONSTRAINT_TYPES;
    }

    public ModelIDObject createElement(String string) {
        LOGGER.error("ConstraintSet can not use createElement(String) because it needs a ConstraintTypeDescriptor to determine what to instantiate.");
        return null;
    }

    public Constraint createConstraint(Object object) {
        if (object instanceof ConstraintTypeDescriptor) {
            ConstraintTypeDescriptor constraintTypeDescriptor = (ConstraintTypeDescriptor)object;
            AbstractConstraint abstractConstraint = null;
            switch (constraintTypeDescriptor.getId()) {
                case 0: {
                    ConstraintEnumeration constraintEnumeration = new ConstraintEnumeration();
                    abstractConstraint = constraintEnumeration;
                    break;
                }
                case 1: {
                    abstractConstraint = new CheckConstraint();
                    break;
                }
                default: {
                    return null;
                }
            }
            abstractConstraint.setDesign(this.getDesign());
            this.add(abstractConstraint);
            return abstractConstraint;
        }
        return null;
    }

    public Constraint createConstraint(String string) {
        int n = -1;
        if ("check constraint".equals(string)) {
            n = 1;
        } else if ("enumerated String".equals(string)) {
            n = 0;
        } else {
            return null;
        }
        return this.createConstraint(ConstraintSet.getConstraintTypes()[n]);
    }

    private static class ConstraintTypeDescriptor {
        private String description;
        private int id;

        private ConstraintTypeDescriptor(String string, int n) {
            this.description = string;
            this.id = n;
        }

        int getId() {
            return this.id;
        }

        public String toString() {
            return this.description;
        }
    }
}

