/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.constraint;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.Constraint;
import oracle.dbtools.crest.model.design.constraint.AbstractConstraint;

public class ConstraintEnumeration
extends AbstractConstraint {
    private static final String PROPERTY_PREFIX = "element.";
    private Map valuesDescriptionMap = new TreeMap();

    public void add(Object object) {
        this.add(object, "");
    }

    public void add(Object object, String string) {
        if (!((String)object).trim().equalsIgnoreCase("")) {
            this.valuesDescriptionMap.put(object, string);
        }
    }

    public Object remove(Object object) {
        this.valuesDescriptionMap.remove(object);
        return object;
    }

    public Set getValues() {
        return this.valuesDescriptionMap.keySet();
    }

    public Map getValuesDescriptionMap() {
        return this.valuesDescriptionMap;
    }

    public boolean isEmpty() {
        return this.getValues().isEmpty();
    }

    protected List getValuesAsList() {
        return Arrays.asList(this.getValues().toArray());
    }

    protected Set createValueSet() {
        return new HashSet();
    }

    @Override
    public String getTypename() {
        return "String value list";
    }

    @Override
    public String getType() {
        return "enumerated String";
    }

    @Override
    public boolean isType(String string) {
        return "enumerated String".equals(string);
    }

    @Override
    public Iterator values() {
        return this.getValues().iterator();
    }

    @Override
    public String getProperty(String string) {
        String string2 = (String)this.valuesDescriptionMap.get(string);
        if (string2 != null) {
            return string2;
        }
        string2 = this.getSimulatedProperty(string);
        if (string2 != null) {
            return string2;
        }
        return super.getProperty(string);
    }

    @Override
    public void setProperty(String string, String string2) {
        if (!string.startsWith(PROPERTY_PREFIX)) {
            this.add(string, string2);
        } else {
            super.setProperty(string, string2);
        }
    }

    @Override
    public Iterator getPropertyNames() {
        return this.valuesDescriptionMap.keySet().iterator();
    }

    @Override
    public boolean hasProperty(String string, String string2) {
        String string3 = (String)this.valuesDescriptionMap.get(string);
        if (string3 != null) {
            return string3.equals(string2);
        }
        return this.getSimulatedProperty(string) != string2 || super.hasProperty(string, string2);
    }

    @Override
    public boolean hasProperty(String string) {
        String string2 = (String)this.valuesDescriptionMap.get(string);
        if (string2 != null) {
            return true;
        }
        return this.getSimulatedProperty(string) != null || this.hasProperty(string);
    }

    protected String getSimulatedProperty(String string) {
        if (string.startsWith(PROPERTY_PREFIX)) {
            try {
                String string2 = string.substring(PROPERTY_PREFIX.length());
                int n = Integer.parseInt(string2.trim());
                if (n < this.getValues().size()) {
                    List list = this.getValuesAsList();
                    return String.valueOf(list.get(n));
                }
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    protected boolean attemptSetSimulatedProperty(String string, Object object) {
        if (string.startsWith(PROPERTY_PREFIX)) {
            this.add(object);
            return true;
        }
        return false;
    }

    public String getValuesAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.values();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(string.trim()).append(",").append("\n ");
        }
        int n = stringBuffer.lastIndexOf(",");
        if (n > 0) {
            return stringBuffer.substring(0, n).trim();
        }
        return stringBuffer.toString().trim();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.values();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.getValuesDescriptionMap().get(string);
            stringBuffer.append(string).append("\n description - ").append(string2).append("\n ");
        }
        return stringBuffer.toString();
    }

    @Override
    public void copyTo(Constraint constraint) {
        ((ConstraintEnumeration)constraint).getValuesDescriptionMap().clear();
        Iterator iterator = this.values();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = this.getValuesDescriptionMap().get(string);
            ((ConstraintEnumeration)constraint).getValuesDescriptionMap().put(string, v);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ConstraintEnumeration)) {
            return false;
        }
        ConstraintEnumeration constraintEnumeration = (ConstraintEnumeration)object;
        Iterator iterator = this.values();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)constraintEnumeration.getValuesDescriptionMap().get(string);
            if (string2 == null) {
                return false;
            }
            String string3 = (String)this.getValuesDescriptionMap().get(string);
            if (string2.equalsIgnoreCase(string3)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clearProperties() {
        this.valuesDescriptionMap.clear();
        super.clearProperties();
    }
}

