/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateTableOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v11g.CSSBIndexOraclev11g;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.FKProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionListOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ColumnProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.PartitionListOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ColumnProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ListPartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionListOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.PartitionOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBCreateTableOraclev11g
extends CSSBCreateTableOraclev10g {
    private CSSBIndexOraclev11g cssbIndex = null;

    @Override
    protected void appendDatatype(StringBuffer stringBuffer, String string, ColumnProxyOraclev10g columnProxyOraclev10g, boolean bl) {
        if (string.equalsIgnoreCase("unknown") && columnProxyOraclev10g.isVirtual()) {
            return;
        }
        super.appendDatatype(stringBuffer, string, columnProxyOraclev10g, bl);
    }

    @Override
    protected void appendColumnOptions(StringBuffer stringBuffer, TableProxyOraclev10g tableProxyOraclev10g, Column column, ColumnProxyOraclev10g columnProxyOraclev10g, boolean bl) {
        if (columnProxyOraclev10g.isVirtual()) {
            this.appendVirtualColumnDefinition(stringBuffer, tableProxyOraclev10g, (ColumnProxyOraclev11g)columnProxyOraclev10g, bl);
        } else {
            this.appendWithDefaultDefinition(stringBuffer, columnProxyOraclev10g);
        }
        if (!column.getNullsAllowed()) {
            this.appendNotNullDefinition(stringBuffer, columnProxyOraclev10g, bl);
        }
    }

    private void appendVirtualColumnDefinition(StringBuffer stringBuffer, TableProxyOraclev10g tableProxyOraclev10g, ColumnProxyOraclev11g columnProxyOraclev11g, boolean bl) {
        CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "AS");
        CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
        CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, columnProxyOraclev11g.getColumnExpression());
        CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
        CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "VIRTUAL");
        if (tableProxyOraclev10g.getOrganization().equalsIgnoreCase("INDEX")) {
            this.appendError(stringBuffer, "--  ERROR: Virtual columns not supported for Organization INDEX", bl);
        }
        if (tableProxyOraclev10g.getCluster() != null) {
            this.appendError(stringBuffer, "--  ERROR: Virtual columns not supported for Cluster Tables", bl);
        }
        if ("YES".equalsIgnoreCase(tableProxyOraclev10g.getTemporary())) {
            this.appendError(stringBuffer, "--  ERROR: Virtual columns not supported for Temporary Tables", bl);
        }
    }

    @Override
    protected void appendRefPartitionFK(StringBuffer stringBuffer, TableProxyOracle tableProxyOracle, boolean bl) {
        FKProxyOracle fKProxyOracle;
        PartitionListOracle partitionListOracle = tableProxyOracle.getPartitionList();
        if (partitionListOracle != null && partitionListOracle.getPartitionType().equals("REFERENCE") && (fKProxyOracle = ((PartitionListOraclev11g)partitionListOracle).getRefConstraint()) != null) {
            this.appendComma(stringBuffer);
            CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "CONSTRAINT");
            String string = fKProxyOracle.getName();
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "FOREIGN KEY");
            CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
            CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 0);
            String string2 = fKProxyOracle.getColumns(this.storageDesign);
            if (string2.length() > 0) {
                CSSBCreateTableOraclev11g.appendString(stringBuffer, string2);
            }
            CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
            this.appendReferences(stringBuffer, fKProxyOracle);
            this.appendOnDelete(stringBuffer, fKProxyOracle, bl);
            this.appendConstraintState(stringBuffer, fKProxyOracle);
        }
    }

    private void appendReferences(StringBuffer stringBuffer, FKProxyOracle fKProxyOracle) {
        CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, true, 1);
        CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "REFERENCES");
        CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(fKProxyOracle.getReferenceTable()));
        if (!fKProxyOracle.getFKTable().isBST()) {
            CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, true, 1);
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
            CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, true, 0);
            CSSBCreateTableOraclev11g.appendString(stringBuffer, fKProxyOracle.getReferenceColumns(this.storageDesign));
            CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, true, 1);
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendOnDelete(StringBuffer stringBuffer, FKProxyOracle fKProxyOracle, boolean bl) {
        FKIndexAssociation fKIndexAssociation = ((Index)fKProxyOracle.getObject()).getFKAssociation();
        String string = fKIndexAssociation.getDeleteRule();
        if (string.equalsIgnoreCase("SET DEFAULT")) {
            string = fKIndexAssociation.isMandatory() ? "RESTRICT" : "SET NULL";
        }
        if (!string.equalsIgnoreCase("RESTRICT") && !string.equalsIgnoreCase("NO ACTION")) {
            CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, true, 1);
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "ON");
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "DELETE");
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, string);
        }
    }

    private void appendConstraintState(StringBuffer stringBuffer, FKProxyOracle fKProxyOracle) {
        if (this.storageDesign.isOpen()) {
            CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, true, 1);
            if ("NO".equalsIgnoreCase(fKProxyOracle.getDeferrable())) {
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "NOT");
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "DEFERRABLE");
            } else {
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "DEFERRABLE");
                if ("DEFERRED".equalsIgnoreCase(fKProxyOracle.getInitially())) {
                    CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "INITIALLY");
                    CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "DEFERRED");
                }
            }
            if (!"YES".equalsIgnoreCase(fKProxyOracle.getEnable())) {
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "DISABLE");
                if ("YES".equalsIgnoreCase(fKProxyOracle.getValidate())) {
                    CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "VALIDATE");
                }
            }
            if (!"YES".equalsIgnoreCase(fKProxyOracle.getValidate())) {
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "NOVALIDATE");
            }
            if (fKProxyOracle.getExceptionsTable() != null) {
                stringBuffer.append(NEWLINE);
                stringBuffer.append("EXCEPTIONS INTO ").append(this.storageDesign.getFormatedName(fKProxyOracle.getExceptionsTable().getLongName()));
            }
        }
    }

    @Override
    public void appendPartitionList(StringBuffer stringBuffer, TableProxyOraclev10g tableProxyOraclev10g, boolean bl) {
        PartitionListOraclev11g partitionListOraclev11g = (PartitionListOraclev11g)tableProxyOraclev10g.getPartitionList();
        if (partitionListOraclev11g != null) {
            if (this.storageDesign == null) {
                this.storageDesign = (StorageDesignOraclev11g)tableProxyOraclev10g.getStorageDesign();
            }
            String string = partitionListOraclev11g.getPartitionType();
            String string2 = partitionListOraclev11g.getSubpartitionType();
            CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
            if ("RANGE".equalsIgnoreCase(string)) {
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "PARTITION");
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "BY");
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "RANGE");
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev11g.getColumnList()));
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                String string3 = partitionListOraclev11g.getIntervalExpression().trim();
                if (string3.length() > 0) {
                    CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 2);
                    CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "INTERVAL");
                    CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                    CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, string3);
                    CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                    if (partitionListOraclev11g.getIntervalTablespaces().length() > 0) {
                        CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 2);
                        CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "STORE IN");
                        CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                        CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev11g.getAllIntervalTablespaces()));
                        CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                    }
                }
                this.appendSubPartitionDefinition(stringBuffer, tableProxyOraclev10g, partitionListOraclev11g, bl);
                boolean bl2 = !string2.equalsIgnoreCase("");
                this.appendPartitions(stringBuffer, partitionListOraclev11g, true, bl2, bl);
            } else if ("HASH BY QUANTITY".equalsIgnoreCase(string)) {
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "PARTITION");
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "BY");
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "HASH");
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev11g.getColumnList()));
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "PARTITIONS");
                this.appendStringWithSpace(stringBuffer, partitionListOraclev11g.getHashPQuantity());
                if (!"".equals(partitionListOraclev11g.getHashPTableSpaces())) {
                    CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
                    CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "STORE IN");
                    CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                    CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev11g.getAllHashPTableSpaces()));
                    CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                }
                if (!"".equals(partitionListOraclev11g.getIOTOverflowHashPTS())) {
                    CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
                    CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "OVERFLOW");
                    CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "STORE IN");
                    CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                    CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev11g.getAllIOTOverflowHashPTS()));
                    CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                }
            } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(string)) {
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "PARTITION");
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "BY");
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "HASH");
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev11g.getColumnList()));
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                this.appendHashPartitions(stringBuffer, tableProxyOraclev10g, bl);
            } else if ("LIST".equalsIgnoreCase(string)) {
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "PARTITION");
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "BY");
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "LIST");
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev11g.getColumnList()));
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                this.appendSubPartitionDefinition(stringBuffer, tableProxyOraclev10g, partitionListOraclev11g, bl);
                this.appendListPartitions(stringBuffer, tableProxyOraclev10g, partitionListOraclev11g, bl);
            } else if ("REFERENCE".equalsIgnoreCase(string)) {
                FKProxyOracle fKProxyOracle = partitionListOraclev11g.getRefConstraint();
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "PARTITION");
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "BY");
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "REFERENCE");
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                if (fKProxyOracle != null) {
                    CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(fKProxyOracle.getName()));
                }
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                this.appendPartitions(stringBuffer, partitionListOraclev11g, false, false, bl);
            } else if ("SYSTEM".equalsIgnoreCase(string)) {
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "PARTITION");
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "BY");
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "SYSTEM");
                int n = partitionListOraclev11g.getSystemPartitions();
                if (n > 1) {
                    CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 2);
                    CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "PARTITIONS");
                    this.appendStringWithSpace(stringBuffer, n);
                } else {
                    this.appendPartitions(stringBuffer, partitionListOraclev11g, false, false, bl);
                }
            }
        }
    }

    private void appendSubPartitionDefinition(StringBuffer stringBuffer, TableProxyOraclev10g tableProxyOraclev10g, PartitionListOraclev11g partitionListOraclev11g, boolean bl) {
        String string = partitionListOraclev11g.getSubpartitionType();
        if (string.equalsIgnoreCase("HASH")) {
            CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "BY");
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "HASH");
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev11g.getSubPartitionsColumnList()));
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
            if (partitionListOraclev11g.getUseSubpartStorageTemplate().equalsIgnoreCase("NO")) {
                if (partitionListOraclev11g.getSubPartitionsQuantity() > 1 || !"".equals(partitionListOraclev11g.getSubPartitionsTableSpaces())) {
                    CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
                    CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "SUBPARTITIONS");
                    this.appendStringWithSpace(stringBuffer, partitionListOraclev11g.getSubPartitionsQuantity());
                    if (!"".equals(partitionListOraclev11g.getSubPartitionsTableSpaces())) {
                        CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
                        CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "STORE IN");
                        CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                        CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev11g.getAllSubPartitionsTableSpaces()));
                        CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                    }
                }
            } else {
                this.appendHashSubPartitionTemplates(stringBuffer, tableProxyOraclev10g, bl);
            }
        } else if (string.equalsIgnoreCase("LIST")) {
            CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "BY");
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "LIST");
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev11g.getSubPartitionsColumnList()));
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
            this.appendListSubPartitionTemplates(stringBuffer, tableProxyOraclev10g, bl);
        } else if (string.equalsIgnoreCase("RANGE")) {
            CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "BY");
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "RANGE");
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev11g.getSubPartitionsColumnList()));
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
            this.appendRangeSubPartitionTemplates(stringBuffer, tableProxyOraclev10g, bl);
        }
    }

    private void appendRangeSubPartitionTemplates(StringBuffer stringBuffer, TableProxyOraclev10g tableProxyOraclev10g, boolean bl) {
        StorageObjectCollection storageObjectCollection = tableProxyOraclev10g.getListStorageTemplates();
        if (storageObjectCollection.size() > 0) {
            CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "TEMPLATE");
            CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
            for (int i = 0; i < storageObjectCollection.size(); ++i) {
                PartitionOraclev11g partitionOraclev11g = (PartitionOraclev11g)storageObjectCollection.getElement(i);
                if (i > 0) {
                    CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, ',');
                }
                CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 2);
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(partitionOraclev11g.getName()));
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "VALUES LESS THAN");
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, partitionOraclev11g.getValueList());
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                this.appendPartStorage(stringBuffer, partitionOraclev11g, bl);
            }
            CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    @Override
    protected void appendSubPartitions(StringBuffer stringBuffer, AbstractStorageObjectOracle abstractStorageObjectOracle, PartitionListOraclev10g partitionListOraclev10g, boolean bl) {
        if (partitionListOraclev10g.getSubpartitionType().equalsIgnoreCase("HASH")) {
            StorageObjectCollection storageObjectCollection = null;
            int n = 0;
            String string = "";
            if (abstractStorageObjectOracle instanceof PartitionOraclev11g) {
                PartitionOraclev11g partitionOraclev11g = (PartitionOraclev11g)abstractStorageObjectOracle;
                storageObjectCollection = partitionOraclev11g.getPartitions();
                n = partitionOraclev11g.getSubPartitionsQuantity();
                string = partitionOraclev11g.getAllSubPartitionsTableSpaces();
            } else if (abstractStorageObjectOracle instanceof ListPartitionOraclev11g) {
                ListPartitionOraclev11g listPartitionOraclev11g = (ListPartitionOraclev11g)abstractStorageObjectOracle;
                storageObjectCollection = listPartitionOraclev11g.getHashSubpartitions();
                n = listPartitionOraclev11g.getSubPartitionsQuantity();
                string = listPartitionOraclev11g.getAllSubPartitionsTableSpaces();
            }
            if (!this.appendHashSubPartitions(stringBuffer, storageObjectCollection, partitionListOraclev10g, bl) && n > 0) {
                CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "SUBPARTITIONS");
                this.appendStringWithSpace(stringBuffer, n);
                if (!"".equalsIgnoreCase(string)) {
                    CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
                    CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "STORE IN");
                    CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                    CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(string));
                    CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                }
            }
        } else if (partitionListOraclev10g.getSubpartitionType().equalsIgnoreCase("LIST")) {
            if (abstractStorageObjectOracle instanceof PartitionOraclev11g) {
                this.appendListSubPartitions(stringBuffer, ((PartitionOraclev11g)abstractStorageObjectOracle).getListPartitions(), bl);
            } else if (abstractStorageObjectOracle instanceof ListPartitionOraclev11g) {
                this.appendListSubPartitions(stringBuffer, ((ListPartitionOraclev11g)abstractStorageObjectOracle).getListSubpartitions(), bl);
            }
        } else if (partitionListOraclev10g.getSubpartitionType().equalsIgnoreCase("RANGE")) {
            if (abstractStorageObjectOracle instanceof PartitionOraclev11g) {
                this.appendRangeSubPartitions(stringBuffer, ((PartitionOraclev11g)abstractStorageObjectOracle).getRangeSubpartitions(), bl);
            } else if (abstractStorageObjectOracle instanceof ListPartitionOraclev11g) {
                this.appendRangeSubPartitions(stringBuffer, ((ListPartitionOraclev11g)abstractStorageObjectOracle).getRangeSubpartitions(), bl);
            }
        }
    }

    private void appendRangeSubPartitions(StringBuffer stringBuffer, StorageObjectCollection storageObjectCollection, boolean bl) {
        if (storageObjectCollection.size() > 0) {
            Object[] objectArray = storageObjectCollection.toArray();
            Arrays.sort(objectArray, new PositionComparator());
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                arrayList.add(objectArray[i]);
            }
            Iterator iterator = arrayList.iterator();
            boolean bl2 = true;
            CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
            while (iterator.hasNext()) {
                PartitionOraclev11g partitionOraclev11g = (PartitionOraclev11g)iterator.next();
                if (!bl2) {
                    CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, ',');
                } else {
                    bl2 = false;
                }
                CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 2);
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(partitionOraclev11g.getName()));
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, "VALUES LESS THAN");
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, partitionOraclev11g.getValueList());
                CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
                this.appendPartStorage(stringBuffer, partitionOraclev11g, bl);
            }
            CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendError(StringBuffer stringBuffer, String string, boolean bl) {
        CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 0);
        CSSBCreateTableOraclev11g.appendStringWithSpace(stringBuffer, string);
        CSSBCreateTableOraclev11g.appendNewLine(stringBuffer, bl, 5);
        CDDLFileMaker.incrementErrors();
    }

    @Override
    protected CSSBIndexOraclev11g getCSSBIndex() {
        if (this.cssbIndex == null) {
            this.cssbIndex = new CSSBIndexOraclev11g();
            this.cssbIndex.setStorageDesign((StorageDesignOraclev11g)this.storageDesign);
        }
        return this.cssbIndex;
    }

    static class PositionComparator
    implements Comparator {
        PositionComparator() {
        }

        public int compare(Object object, Object object2) {
            if (((PartitionOracle)object).getPosition() > ((PartitionOracle)object2).getPosition()) {
                return 1;
            }
            if (((PartitionOracle)object).getPosition() < ((PartitionOracle)object2).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

