/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.FKProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBFKIndexOraclev10g
extends AbstractCSSBOracle {
    private Map fkMap;
    private StorageDesignOraclev10g storageDesign;
    private boolean isRenamedTable = true;
    private List pkColumns;
    private List fkColumns;

    public CSSBFKIndexOraclev10g(Map map) {
        this.fkMap = map;
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        CompareObjectSelection compareObjectSelection = (CompareObjectSelection)object;
        CompareObjectSelection compareObjectSelection2 = compareObjectSelection.getCorrespondentNode();
        FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)compareObjectSelection2.getObject();
        Table table = null;
        if (fKIndexAssociation != null && this.fkMap.get(fKIndexAssociation.getObjectID()) != null) {
            this.isRenamedTable = true;
            table = fKIndexAssociation.getTable();
            if (!compareObjectSelection.isSelected() || !compareObjectSelection2.canBeDrop()) {
                this.appendRenameFK(stringBuffer, bl, fKIndexAssociation, table, compareObjectSelection2);
            }
        } else if (compareObjectSelection.getObject() != null) {
            this.isRenamedTable = false;
            fKIndexAssociation = (FKIndexAssociation)compareObjectSelection.getObject();
            table = fKIndexAssociation.getTable();
            if (this.fkMap.get(fKIndexAssociation.getRemoteIndex().getObjectID()) != null) {
                this.appendFK(stringBuffer, bl, fKIndexAssociation, table, compareObjectSelection);
            } else if (fKIndexAssociation.shouldBeMerge() && table.shouldBeMerge() && compareObjectSelection.isModified()) {
                Design design = table.getDesign();
                RDBMSSite rDBMSSite = table.getSelectedRDBMSSite();
                this.storageDesign = (StorageDesignOraclev10g)design.getStorageDesign(rDBMSSite, table);
                if (!compareObjectSelection.canBeCreate()) {
                    boolean bl2 = false;
                    String string = null;
                    String string2 = null;
                    for (EngPropertyHolder engPropertyHolder : compareObjectSelection.getPropertiesComparator().getPropertiesList()) {
                        if (!engPropertyHolder.isSelected()) continue;
                        String string3 = engPropertyHolder.getName();
                        if (string3.equals(PropertiesComparator.NAME)) {
                            string = engPropertyHolder.getLeftValue();
                            string2 = engPropertyHolder.getRightValue();
                            continue;
                        }
                        if (string3.equals(PropertiesComparator.COLUMN_ASSOCIATION)) {
                            CompareObjectSelection compareObjectSelection3 = this.getPKObjectSelection(compareObjectSelection, fKIndexAssociation.getKeyObject());
                            if (compareObjectSelection3 != null && compareObjectSelection3.isModified() && !compareObjectSelection3.isSelected()) continue;
                            bl2 = true;
                            continue;
                        }
                        if (!string3.equals(PropertiesComparator.PRIMARY_KEY) && !string3.equals(PropertiesComparator.DELETE_RULE) && !string3.equals(PropertiesComparator.TRANSFERABLE) && !string3.equals(PropertiesComparator.IN_ARC)) continue;
                        bl2 = true;
                    }
                    if (bl2) {
                        this.appendDropFK(stringBuffer, fKIndexAssociation, compareObjectSelection, bl);
                    } else {
                        if (string != null) {
                            this.renameConstraint(stringBuffer, string2, string, compareObjectSelection, bl);
                        }
                        return;
                    }
                }
                this.appendFK(stringBuffer, bl, fKIndexAssociation, table, compareObjectSelection);
            }
        } else if (fKIndexAssociation != null && compareObjectSelection.isSelected() && this.fkMap.get(fKIndexAssociation.getRemoteIndex().getObjectID()) == null) {
            this.appendDropFK(stringBuffer, fKIndexAssociation, compareObjectSelection, bl);
        }
    }

    private void renameConstraint(StringBuffer stringBuffer, String string, String string2, CompareObjectSelection compareObjectSelection, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "ALTER");
        CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "TABLE");
        CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, this.getTableName(compareObjectSelection));
        String string3 = this.storageDesign.getFormatedName(string);
        String string4 = stringBuffer2.toString() + "RENAME" + ' ' + "CONSTRAINT" + ' ' + string3;
        CSSBFKIndexOraclev10g.appendNewLine(stringBuffer2, bl, 1);
        CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "RENAME");
        CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
        CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, string3);
        CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "TO");
        CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(string2));
        this.appendToBuffer(stringBuffer, stringBuffer2, string4);
        this.appendLineFinisher(stringBuffer2, bl);
        CSSBFKIndexOraclev10g.appendNewLine(stringBuffer2, bl, 0);
        this.appendToBuffer(stringBuffer, stringBuffer2, string4);
        CDDLFileMaker.incrementAlterTable();
    }

    private void appendDropFK(StringBuffer stringBuffer, FKIndexAssociation fKIndexAssociation, CompareObjectSelection compareObjectSelection, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        Table table = fKIndexAssociation.getTable();
        FKIndexAssociation fKIndexAssociation2 = (FKIndexAssociation)compareObjectSelection.getCorrespondentNode().getObject();
        this.appendBeforeAlterScript(stringBuffer, bl, table);
        Design design = table.getDesign();
        RDBMSSite rDBMSSite = table.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOraclev10g)design.getStorageDesign(rDBMSSite, table);
        CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "ALTER");
        CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "TABLE");
        CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, this.getTableName(compareObjectSelection));
        CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "DROP");
        CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
        CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(fKIndexAssociation2.getName()));
        String string = stringBuffer2.toString();
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        CSSBFKIndexOraclev10g.appendNewLine(stringBuffer2, bl, 0);
        this.appendLineFinisher(stringBuffer2, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        CDDLFileMaker.incrementAlterTable();
        this.appendAfterAlterScript(stringBuffer, bl, table);
    }

    private void appendFK(StringBuffer stringBuffer, boolean bl, FKIndexAssociation fKIndexAssociation, Table table, CompareObjectSelection compareObjectSelection) {
        this.pkColumns = null;
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        FKProxyOraclev10g fKProxyOraclev10g = (FKProxyOraclev10g)this.storageDesign.getFKProxySet().getProxy(fKIndexAssociation.getLocalFKIndex().getObjectID());
        if (fKProxyOraclev10g != null) {
            this.appendComment(stringBuffer, fKProxyOraclev10g);
            CSSBFKIndexOraclev10g.appendNewLine(stringBuffer, bl, 0);
            this.appendBeforeAlterScript(stringBuffer, bl, table);
            CompareObjectSelection compareObjectSelection2 = (CompareObjectSelection)((CompareObjectSelection)compareObjectSelection.getParent()).getParent();
            CompareObjectSelection compareObjectSelection3 = this.getPKObjectSelection(compareObjectSelection, fKIndexAssociation.getKeyObject());
            if (compareObjectSelection3 == null) {
                this.initFKandRefColumns(fKIndexAssociation, compareObjectSelection2);
            } else if (compareObjectSelection3.isSelected() || !compareObjectSelection3.isModified()) {
                this.initFKandRefColumns(compareObjectSelection3, fKIndexAssociation, compareObjectSelection2);
            }
            if (this.pkColumns != null && !this.pkColumns.isEmpty()) {
                CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "ALTER");
                CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "TABLE");
                CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, this.getTableName(compareObjectSelection));
                string = stringBuffer2.toString() + "ADD" + ' ' + "CONSTRAINT" + ' ' + this.storageDesign.getFormatedName(fKProxyOraclev10g.getName());
                CSSBFKIndexOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "ADD");
                CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
                CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(fKProxyOraclev10g.getName()));
                CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "FOREIGN KEY");
                CSSBFKIndexOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, '(');
                CSSBFKIndexOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                this.appendColumnsSelection(stringBuffer2, this.fkColumns);
                CSSBFKIndexOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, ')');
                this.appendReferences(stringBuffer2, fKProxyOraclev10g, bl);
                this.appendOnDelete(stringBuffer2, compareObjectSelection, bl);
                if (this.isRenamedTable) {
                    CSSBFKIndexOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                    CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "DEFERRABLE");
                    CSSBFKIndexOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                    CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "INITIALLY");
                    CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "DEFERRED");
                    CSSBFKIndexOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                    CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "NOVALIDATE");
                } else {
                    this.appendConstraintState(stringBuffer2, fKProxyOraclev10g, bl);
                }
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                CSSBFKIndexOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                this.appendLineFinisher(stringBuffer2, bl);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                CDDLFileMaker.incrementAlterTable();
                if (fKProxyOraclev10g.getRely().equals("YES") && fKProxyOraclev10g.getValidate().equals("NO")) {
                    CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "ALTER");
                    CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "TABLE");
                    CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, this.getTableName(compareObjectSelection));
                    CSSBFKIndexOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                    CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "MODIFY");
                    CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
                    CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(fKProxyOraclev10g.getName()));
                    string = stringBuffer2.toString();
                    CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "RELY");
                    this.appendToBuffer(stringBuffer, stringBuffer2, string);
                    CSSBFKIndexOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                    this.appendLineFinisher(stringBuffer2, bl);
                    CSSBFKIndexOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                    this.appendToBuffer(stringBuffer, stringBuffer2, string);
                    CDDLFileMaker.incrementAlterTable();
                }
                this.appendAfterAlterScript(stringBuffer, bl, table);
            }
        }
    }

    private void appendReferences(StringBuffer stringBuffer, FKProxyOraclev10g fKProxyOraclev10g, boolean bl) {
        CSSBFKIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
        CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer, "REFERENCES");
        CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(fKProxyOraclev10g.getReferenceTable()));
        if (!fKProxyOraclev10g.getFKTable().isBST()) {
            CSSBFKIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer, '(');
            CSSBFKIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            this.appendColumns(stringBuffer, this.pkColumns);
            CSSBFKIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendOnDelete(StringBuffer stringBuffer, CompareObjectSelection compareObjectSelection, boolean bl) {
        String string = compareObjectSelection.getChoosedPropertyValue(PropertiesComparator.DELETE_RULE);
        if (string.equalsIgnoreCase("SET DEFAULT")) {
            String string2 = compareObjectSelection.getChoosedPropertyValue(PropertiesComparator.MANDATORY);
            boolean bl2 = Boolean.parseBoolean(string2);
            string = bl2 ? "RESTRICT" : "SET NULL";
        }
        if (!string.equalsIgnoreCase("RESTRICT") && !string.equalsIgnoreCase("NO ACTION")) {
            CSSBFKIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer, "ON");
            CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer, "DELETE");
            CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer, string);
        }
    }

    private void appendConstraintState(StringBuffer stringBuffer, FKProxyOraclev10g fKProxyOraclev10g, boolean bl) {
        CSSBFKIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
        if ("NO".equalsIgnoreCase(fKProxyOraclev10g.getDeferrable())) {
            CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer, "NOT");
            CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer, "DEFERRABLE");
        } else {
            CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(fKProxyOraclev10g.getInitially())) {
                CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer, "INITIALLY");
                CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer, "DEFERRED");
            }
        }
        if (!"YES".equalsIgnoreCase(fKProxyOraclev10g.getEnable())) {
            CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer, "DISABLE");
            if ("YES".equalsIgnoreCase(fKProxyOraclev10g.getValidate())) {
                CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer, "VALIDATE");
            }
        }
        if (!"YES".equalsIgnoreCase(fKProxyOraclev10g.getValidate())) {
            CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer, "NOVALIDATE");
        }
        if (fKProxyOraclev10g.getExceptionsTable() != null) {
            CSSBFKIndexOraclev10g.appendNewLine(stringBuffer, bl, 1);
            stringBuffer.append("EXCEPTIONS INTO ").append(this.storageDesign.getFormatedName(fKProxyOraclev10g.getExceptionsTable().getLongName()));
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof FKIndexAssociation || ((CompareObjectSelection)object).getCorrespondentNode().getObject() instanceof FKIndexAssociation;
    }

    private CompareObjectSelection getPKObjectSelection(CompareObjectSelection compareObjectSelection, KeyObject keyObject) {
        Table table = (Table)keyObject.getContainerWithKeyObject();
        CompareObjectSelection compareObjectSelection2 = (CompareObjectSelection)compareObjectSelection.getParent();
        CompareObjectSelection compareObjectSelection3 = (CompareObjectSelection)((CompareObjectSelection)compareObjectSelection2.getParent()).getParent();
        CompareObjectSelection compareObjectSelection4 = compareObjectSelection3.getChild(table);
        if (compareObjectSelection4 == null) {
            return null;
        }
        CompareObjectSelection compareObjectSelection5 = (CompareObjectSelection)compareObjectSelection4.getChild(2);
        if (compareObjectSelection5 == null) {
            return null;
        }
        CompareObjectSelection compareObjectSelection6 = compareObjectSelection5.getChild(keyObject);
        return compareObjectSelection6;
    }

    private void initFKandRefColumns(CompareObjectSelection compareObjectSelection, FKIndexAssociation fKIndexAssociation, CompareObjectSelection compareObjectSelection2) {
        this.pkColumns = this.getColumnsForRestore(compareObjectSelection);
        this.fkColumns = new ArrayList();
        Table table = (Table)fKIndexAssociation.getContainerWithKeyObject();
        for (Column column : this.pkColumns) {
            Column column2 = table.getFKColumn(fKIndexAssociation, column);
            if (column2 != null) {
                CompareObjectSelection compareObjectSelection3 = compareObjectSelection2.getChildNested(column2, 2);
                if (compareObjectSelection3 == null) continue;
                this.fkColumns.add(compareObjectSelection3);
                continue;
            }
            System.out.println(fKIndexAssociation.toString());
        }
    }

    private void initFKandRefColumns(CompareObjectSelection compareObjectSelection, FKIndexAssociation fKIndexAssociation) {
        this.pkColumns = this.getColumnsForRestore(compareObjectSelection);
        this.fkColumns = new ArrayList();
        Table table = (Table)fKIndexAssociation.getContainerWithKeyObject();
        for (Column column : this.pkColumns) {
            Column column2 = table.getFKColumn(fKIndexAssociation, column);
            if (column2 != null) {
                this.fkColumns.add(column2);
                continue;
            }
            System.out.println(fKIndexAssociation.toString());
        }
    }

    private void initFKandRefColumns(FKIndexAssociation fKIndexAssociation, CompareObjectSelection compareObjectSelection) {
        this.pkColumns = new ArrayList();
        this.fkColumns = new ArrayList();
        if (fKIndexAssociation.getRemoteIndex() != null) {
            this.pkColumns.addAll(fKIndexAssociation.getRemoteIndex().getElementsCollection());
            Table table = (Table)fKIndexAssociation.getContainerWithKeyObject();
            for (Column column : this.pkColumns) {
                Column column2 = table.getFKColumn(fKIndexAssociation, column);
                if (column2 != null) {
                    CompareObjectSelection compareObjectSelection2 = compareObjectSelection.getChildNested(column2, 2);
                    if (compareObjectSelection2 == null) continue;
                    this.fkColumns.add(compareObjectSelection2);
                    continue;
                }
                System.out.println(fKIndexAssociation.toString());
            }
        }
    }

    private List getColumnsForRestore(CompareObjectSelection compareObjectSelection) {
        CompareObjectSelection compareObjectSelection2;
        CompareObjectSelection compareObjectSelection3;
        ArrayList<Column> arrayList = new ArrayList<Column>();
        KeyObject keyObject = (KeyObject)compareObjectSelection.getObject();
        if (keyObject != null && (compareObjectSelection3 = (CompareObjectSelection)(compareObjectSelection2 = (CompareObjectSelection)compareObjectSelection.getParent()).getParent()) != null) {
            List list = compareObjectSelection3.getChildObjects(0);
            for (Column column : keyObject.getElementsCollection()) {
                for (CompareObjectSelection compareObjectSelection4 : list) {
                    if (column != compareObjectSelection4.getObject() || compareObjectSelection4.canBeCreate() && !compareObjectSelection4.isSelected() || compareObjectSelection4.canBeDrop() && compareObjectSelection4.getCorrespondentNode().isSelected()) continue;
                    arrayList.add(column);
                }
            }
        }
        return arrayList;
    }

    private void appendColumns(StringBuffer stringBuffer, List list) {
        Iterator iterator = list.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            if (!bl) {
                CSSBFKIndexOraclev10g.appendString(stringBuffer, ',');
                CSSBFKIndexOraclev10g.appendNewLine(stringBuffer, true, 1);
            }
            CSSBFKIndexOraclev10g.appendString(stringBuffer, ' ');
            if (column != null) {
                CSSBFKIndexOraclev10g.appendString(stringBuffer, this.storageDesign.getFormatedName(column.getName()));
            }
            bl = false;
        }
    }

    private void appendColumnsSelection(StringBuffer stringBuffer, List list) {
        Iterator iterator = this.fkColumns.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            CompareObjectSelection compareObjectSelection = (CompareObjectSelection)iterator.next();
            String string = compareObjectSelection.getChoosedPropertyValue(PropertyNames.NAME, compareObjectSelection.isSelected());
            if (!bl) {
                CSSBFKIndexOraclev10g.appendString(stringBuffer, ',');
                CSSBFKIndexOraclev10g.appendNewLine(stringBuffer, true, 1);
            }
            CSSBFKIndexOraclev10g.appendString(stringBuffer, ' ');
            if (compareObjectSelection != null) {
                CSSBFKIndexOraclev10g.appendString(stringBuffer, this.storageDesign.getFormatedName(string));
            }
            bl = false;
        }
    }

    private void appendRenameFK(StringBuffer stringBuffer, boolean bl, FKIndexAssociation fKIndexAssociation, Table table, CompareObjectSelection compareObjectSelection) {
        this.pkColumns = null;
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        Design design = table.getDesign();
        RDBMSSite rDBMSSite = table.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOraclev10g)design.getStorageDesign(rDBMSSite, table);
        FKProxyOraclev10g fKProxyOraclev10g = (FKProxyOraclev10g)this.storageDesign.getFKProxySet().getProxy(fKIndexAssociation.getLocalFKIndex().getObjectID());
        if (fKProxyOraclev10g != null) {
            ModelObject modelObject;
            this.appendComment(stringBuffer, fKProxyOraclev10g);
            CSSBFKIndexOraclev10g.appendNewLine(stringBuffer, bl, 0);
            this.appendBeforeAlterScript(stringBuffer, bl, table);
            CompareObjectSelection compareObjectSelection2 = this.getPKObjectSelection(compareObjectSelection, fKIndexAssociation.getKeyObject());
            if (compareObjectSelection2 != null) {
                modelObject = compareObjectSelection2.getCorrespondentNode();
                ModelIDObject modelIDObject = compareObjectSelection.getCorrespondentNode().getObject();
                if ((((ModelIdObjectSelection)modelObject).isSelected() || !((CompareObjectSelection)modelObject).isModified()) && modelIDObject != null) {
                    this.initFKandRefColumns((CompareObjectSelection)modelObject, (FKIndexAssociation)compareObjectSelection.getCorrespondentNode().getObject());
                }
            }
            if (this.pkColumns != null && this.pkColumns.size() > 0) {
                CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "ALTER");
                CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "TABLE");
                CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, this.getTableName(compareObjectSelection));
                string = stringBuffer2.toString() + "ADD" + ' ' + "CONSTRAINT" + ' ' + this.storageDesign.getFormatedName(fKProxyOraclev10g.getName());
                CSSBFKIndexOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "ADD");
                CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
                CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(fKProxyOraclev10g.getName()));
                CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "FOREIGN KEY");
                CSSBFKIndexOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, '(');
                CSSBFKIndexOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                this.appendColumns(stringBuffer2, this.fkColumns);
                CSSBFKIndexOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, ')');
                this.appendReferences(stringBuffer2, fKProxyOraclev10g, bl);
                this.appendOnDelete(stringBuffer2, compareObjectSelection, bl);
                modelObject = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(fKProxyOraclev10g.getFKTable().getObjectID());
                if (this.isRenamedTable && (((TableProxy)modelObject).getBackupOption().equals(TableProxy.NONE) || ((TableProxy)modelObject).getRestoreOption().equals(TableProxy.NONE))) {
                    CSSBFKIndexOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                    CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "DEFERRABLE");
                    CSSBFKIndexOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                    CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "INITIALLY");
                    CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "DEFERRED");
                    CSSBFKIndexOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                    CSSBFKIndexOraclev10g.appendStringWithSpace(stringBuffer2, "NOVALIDATE");
                } else {
                    this.appendConstraintState(stringBuffer2, fKProxyOraclev10g, bl);
                }
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                CSSBFKIndexOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                this.appendLineFinisher(stringBuffer2, bl);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                CDDLFileMaker.incrementAlterTable();
                this.appendAfterAlterScript(stringBuffer, bl, table);
            }
        }
    }

    private String getTableName(CompareObjectSelection compareObjectSelection) {
        CompareObjectSelection compareObjectSelection2 = compareObjectSelection.getTableNode();
        if (compareObjectSelection2 != null) {
            return this.storageDesign.getFormatedName(compareObjectSelection2.getChoosedPropertyValue(PropertiesComparator.SCHEMA) + '.' + compareObjectSelection2.getChoosedPropertyValue(PropertiesComparator.NAME));
        }
        return "";
    }
}

