/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g;

import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.ddl.DDLAdvancedGenerator;
import oracle.dbtools.crest.exports.ddl.oracle.SSBAutoIncrementColumnOracle;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.AbstractCSSBOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateRenameTableOraclev10g;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateTableOraclev10g;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ColumnProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ColumnProxyOraclev11g;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class CSSBAlterColumnOraclev10g
extends AbstractCSSBOraclev10g {
    private Column sourceColumn;
    private Table sourceTable;
    private SSBAutoIncrementColumnOracle ssbAutoIncCol = null;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        CompareObjectSelection compareObjectSelection = (CompareObjectSelection)object;
        CompareObjectSelection compareObjectSelection2 = compareObjectSelection.getCorrespondentNode();
        this.sourceColumn = (Column)compareObjectSelection.getObject();
        this.sourceTable = (Table)this.sourceColumn.getContainer();
        if (this.sourceTable != null) {
            Design design = this.sourceTable.getDesign();
            RDBMSSite rDBMSSite = this.sourceTable.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev10g)design.getStorageDesign(rDBMSSite, this.sourceTable);
            if (compareObjectSelection.canBeCreate()) {
                this.appendAddColumn(stringBuffer, compareObjectSelection, this.sourceColumn, this.sourceTable, bl);
            } else {
                this.appendModifyColumn(stringBuffer, compareObjectSelection, compareObjectSelection2, bl);
            }
        }
    }

    private void appendModifyColumn(StringBuffer stringBuffer, CompareObjectSelection compareObjectSelection, CompareObjectSelection compareObjectSelection2, boolean bl) {
        TableProxyOraclev10g tableProxyOraclev10g = (TableProxyOraclev10g)this.storageDesign.getTableProxySet().getProxy(this.sourceTable.getObjectID());
        Map map = this.getPropertiesMap(compareObjectSelection);
        if (tableProxyOraclev10g != null && !map.isEmpty()) {
            boolean bl2;
            String string = this.getTableName(compareObjectSelection2);
            StringBuffer stringBuffer2 = new StringBuffer();
            ColumnProxyOraclev10g columnProxyOraclev10g = (ColumnProxyOraclev10g)tableProxyOraclev10g.getColumnProxy(this.sourceColumn.getObjectID());
            Column column = columnProxyOraclev10g.getColumn();
            Column column2 = (Column)compareObjectSelection2.getObject();
            if (map.containsKey(PropertiesComparator.NAME)) {
                this.appendBeforeAlterScript(stringBuffer, bl, (ContainerObject)tableProxyOraclev10g.getObject());
                this.appendRenameColumn(stringBuffer, (String)map.get(PropertiesComparator.NAME), compareObjectSelection2, bl);
            }
            if (map.containsKey(PropertiesComparator.COMMENT_IN_RDBMS) && columnProxyOraclev10g.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendCommentOnColumn(stringBuffer, tableProxyOraclev10g, columnProxyOraclev10g, bl);
            }
            boolean bl3 = bl2 = columnProxyOraclev10g.isVirtual() && (map.containsKey(PropertiesComparator.FORMULA_DESC) || map.containsKey(PropertiesComparator.COMPUTED));
            if (bl2 || map.containsKey(PropertiesComparator.DATA_TYPE) || map.containsKey(PropertiesComparator.MANDATORY) || map.containsKey(PropertiesComparator.NNC_NAME) || map.containsKey(PropertiesComparator.DEFAULT_VALUE)) {
                String string2;
                this.appendBeforeAlterScript(stringBuffer, bl, (ContainerObject)tableProxyOraclev10g.getObject());
                if (map.get(PropertiesComparator.NNC_NAME) != null && !map.containsKey(PropertiesComparator.MANDATORY) && column.isMandatory() && column2.isMandatory()) {
                    String string3 = column2.getNotNullConstraintName();
                    if (string3 != null && !"".equals(string3)) {
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, "ALTER");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, "TABLE");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, string);
                        string2 = stringBuffer2.toString() + "DROP" + ' ' + "CONSTRAINT" + ' ' + this.storageDesign.getFormatedName(string3);
                        CSSBAlterColumnOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, "DROP");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(string3));
                        this.appendToBuffer(stringBuffer, stringBuffer2, string2);
                        CSSBAlterColumnOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                        this.appendLineFinisher(stringBuffer2, bl);
                        CSSBAlterColumnOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                        this.appendToBuffer(stringBuffer, stringBuffer2, string2);
                        CDDLFileMaker.incrementAlterTable();
                    } else if (!column2.isPKElement()) {
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, "ALTER");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, "TABLE");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, string);
                        string2 = stringBuffer2.toString() + "MODIFY" + ' ' + this.storageDesign.getFormatedName(columnProxyOraclev10g.getName());
                        CSSBAlterColumnOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, "MODIFY");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, '(');
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(columnProxyOraclev10g.getName()));
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, "NULL");
                        CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, ')');
                        this.appendToBuffer(stringBuffer, stringBuffer2, string2);
                        CSSBAlterColumnOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                        this.appendLineFinisher(stringBuffer2, bl);
                        CSSBAlterColumnOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                        this.appendToBuffer(stringBuffer, stringBuffer2, string2);
                        CDDLFileMaker.incrementAlterTable();
                    }
                }
                CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, "ALTER");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, "TABLE");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, string);
                string2 = stringBuffer2.toString() + "MODIFY" + ' ' + this.storageDesign.getFormatedName(columnProxyOraclev10g.getName());
                CSSBAlterColumnOraclev10g.appendNewLine(stringBuffer2, bl, 1);
                CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, "MODIFY");
                CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, '(');
                CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(columnProxyOraclev10g.getName()));
                if (bl2) {
                    this.appendVirtualColumnDefinition(stringBuffer2, tableProxyOraclev10g, (ColumnProxyOraclev11g)columnProxyOraclev10g, bl);
                } else {
                    if (map.get(PropertiesComparator.DATA_TYPE) != null) {
                        this.appendStringWithSpace(stringBuffer2, map.get(PropertiesComparator.DATA_TYPE));
                    }
                    if (map.get(PropertiesComparator.DEFAULT_VALUE) != null) {
                        this.appendWithDefaultDefinition(stringBuffer2, columnProxyOraclev10g);
                    }
                }
                if (map.get(PropertiesComparator.MANDATORY) != null) {
                    if (!column.getNullsAllowed()) {
                        this.appendNotNullDefinition(stringBuffer2, columnProxyOraclev10g, bl);
                    } else {
                        this.appendStringWithSpace(stringBuffer2, map.get(PropertiesComparator.MANDATORY));
                    }
                } else if (map.get(PropertiesComparator.NNC_NAME) != null) {
                    if (column.isMandatory()) {
                        this.appendNotNullDefinition(stringBuffer2, columnProxyOraclev10g, bl);
                    } else {
                        this.appendStringWithSpace(stringBuffer2, map.get(PropertiesComparator.MANDATORY));
                    }
                }
                CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, ')');
                this.appendToBuffer(stringBuffer, stringBuffer2, string2);
                CSSBAlterColumnOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                this.appendLineFinisher(stringBuffer2, bl);
                CSSBAlterColumnOraclev10g.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string2);
                CDDLFileMaker.incrementAlterTable();
            }
            this.appendColumnConstraint(stringBuffer, this.sourceColumn, column2, string, columnProxyOraclev10g, compareObjectSelection, bl);
        }
    }

    private void appendCommentOnColumn(StringBuffer stringBuffer, TableProxyOracle tableProxyOracle, ColumnProxyOracle columnProxyOracle, boolean bl) {
        String string = columnProxyOracle.isCommentInRDBMSChanged() ? columnProxyOracle.getCommentInRDBMS() : columnProxyOracle.getColumn().getCommentInRDBMS();
        if (string.trim().length() > 0) {
            CSSBAlterColumnOraclev10g.appendNewLine(stringBuffer, bl, 0);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer, "COMMENT ON");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer, "COLUMN");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyOracle.getLongName()) + '.' + this.storageDesign.getFormatedName(columnProxyOracle.getName()));
            CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer, "IS");
            CSSBAlterColumnOraclev10g.appendString(stringBuffer, '\'');
            CSSBAlterColumnOraclev10g.appendString(stringBuffer, this.replaceSingleQuote(string));
            CSSBAlterColumnOraclev10g.appendString(stringBuffer, '\'');
            CSSBAlterColumnOraclev10g.appendNewLine(stringBuffer, bl, 0);
            this.appendLineFinisher(stringBuffer, bl);
            CSSBAlterColumnOraclev10g.appendNewLine(stringBuffer, bl, 0);
        }
    }

    private void appendColumnConstraint(StringBuffer stringBuffer, Column column, Column column2, String string, ColumnProxyOracle columnProxyOracle, CompareObjectSelection compareObjectSelection, boolean bl) {
        boolean bl2 = CSSBCreateRenameTableOraclev10g.isApplyColumnConstraint(compareObjectSelection);
        if (bl2) {
            CharSequence charSequence;
            if (!"".equals(column2.getConstraintName())) {
                charSequence = this.storageDesign.getFormatedName(column2.getConstraintName());
                StringBuffer stringBuffer2 = new StringBuffer();
                CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, "ALTER TABLE " + string + " DROP CONSTRAINT " + (String)charSequence);
                this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
                this.appendLineFinisher(stringBuffer2, bl);
                this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
                CSSBAlterColumnOraclev10g.appendNewLine(stringBuffer, bl, 0);
                CDDLFileMaker.incrementAlterTable();
            }
            charSequence = new StringBuffer();
            CSSBAlterColumnOraclev10g.appendStringWithSpace((StringBuffer)charSequence, "ALTER");
            CSSBAlterColumnOraclev10g.appendStringWithSpace((StringBuffer)charSequence, "TABLE");
            CSSBAlterColumnOraclev10g.appendStringWithSpace((StringBuffer)charSequence, string);
            CSSBAlterColumnOraclev10g.appendNewLine((StringBuffer)charSequence, bl, 1);
            CSSBAlterColumnOraclev10g.appendStringWithSpace((StringBuffer)charSequence, "ADD ");
            CSSBCreateRenameTableOraclev10g.appendColumnConstraints((StringBuffer)charSequence, column, columnProxyOracle, bl, compareObjectSelection);
            this.appendToBuffer(stringBuffer, (StringBuffer)charSequence, ((StringBuffer)charSequence).toString());
            this.appendLineFinisher((StringBuffer)charSequence, bl);
            this.appendToBuffer(stringBuffer, (StringBuffer)charSequence, ((StringBuffer)charSequence).toString());
            CSSBAlterColumnOraclev10g.appendNewLine(stringBuffer, bl, 0);
            CDDLFileMaker.incrementAlterTable();
        }
    }

    private Map getPropertiesMap(CompareObjectSelection compareObjectSelection) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (EngPropertyHolder engPropertyHolder : compareObjectSelection.getPropertiesComparator().getPropertiesList()) {
            if (!engPropertyHolder.isSelected()) continue;
            if (engPropertyHolder.getName().equals(PropertiesComparator.NAME)) {
                treeMap.put(PropertiesComparator.NAME, engPropertyHolder.getLeftValue());
                continue;
            }
            if (engPropertyHolder.getName().equals(PropertiesComparator.DATA_TYPE)) {
                treeMap.put(PropertiesComparator.DATA_TYPE, engPropertyHolder.getLeftValue());
                continue;
            }
            if (engPropertyHolder.getName().equals(PropertiesComparator.MANDATORY)) {
                if (!Boolean.parseBoolean(engPropertyHolder.getLeftValue())) {
                    treeMap.put(PropertiesComparator.MANDATORY, "NULL");
                    continue;
                }
                treeMap.put(PropertiesComparator.MANDATORY, "NOT NULL");
                continue;
            }
            if (engPropertyHolder.getName().equals(PropertiesComparator.NNC_NAME)) {
                treeMap.put(PropertiesComparator.NNC_NAME, engPropertyHolder.getLeftValue());
                continue;
            }
            if (engPropertyHolder.getName().equals(PropertiesComparator.DEFAULT_VALUE)) {
                String string = engPropertyHolder.getLeftValue();
                if ("".equals(string.trim())) {
                    treeMap.put(PropertiesComparator.DEFAULT_VALUE, "NULL");
                    continue;
                }
                treeMap.put(PropertiesComparator.DEFAULT_VALUE, string);
                continue;
            }
            if (engPropertyHolder.getName().equals(PropertiesComparator.COMMENT_IN_RDBMS)) {
                treeMap.put(PropertiesComparator.COMMENT_IN_RDBMS, engPropertyHolder.getLeftValue());
                continue;
            }
            if (engPropertyHolder.getName().equals(EngPropertiesComparator.CHECK_CONSTRAINT_NAME)) {
                treeMap.put(EngPropertiesComparator.CHECK_CONSTRAINT_NAME, engPropertyHolder.getLeftValue());
                continue;
            }
            if (engPropertyHolder.getName().equals(EngPropertiesComparator.CHECK_CONSTRAINT)) {
                treeMap.put(EngPropertiesComparator.CHECK_CONSTRAINT, engPropertyHolder.getLeftValue());
                continue;
            }
            if (engPropertyHolder.getName().equals(EngPropertiesComparator.RANGE_CONSTRAINT)) {
                treeMap.put(EngPropertiesComparator.RANGE_CONSTRAINT, engPropertyHolder.getLeftValue());
                continue;
            }
            if (engPropertyHolder.getName().equals(EngPropertiesComparator.LOV_CONSTRAINT)) {
                treeMap.put(EngPropertiesComparator.LOV_CONSTRAINT, engPropertyHolder.getLeftValue());
                continue;
            }
            if (engPropertyHolder.getName().equals(PropertiesComparator.COMPUTED)) {
                treeMap.put(PropertiesComparator.COMPUTED, engPropertyHolder.getLeftValue());
                continue;
            }
            if (!engPropertyHolder.getName().equals(PropertiesComparator.FORMULA_DESC)) continue;
            treeMap.put(PropertiesComparator.FORMULA_DESC, engPropertyHolder.getLeftValue());
        }
        return treeMap;
    }

    private void appendRenameColumn(StringBuffer stringBuffer, String string, CompareObjectSelection compareObjectSelection, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, "ALTER");
        CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, "TABLE");
        CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, this.getTableName(compareObjectSelection));
        CSSBAlterColumnOraclev10g.appendNewLine(stringBuffer2, bl, 1);
        CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, "RENAME");
        CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, "COLUMN");
        CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(compareObjectSelection.getObject().getName()));
        CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, "TO");
        CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(string));
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
        this.appendLineFinisher(stringBuffer2, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
        CSSBAlterColumnOraclev10g.appendNewLine(stringBuffer, bl, 0);
        CDDLFileMaker.incrementAlterTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendAddColumn(StringBuffer stringBuffer, CompareObjectSelection compareObjectSelection, Column column, Table table, boolean bl) {
        TableProxyOraclev10g tableProxyOraclev10g = (TableProxyOraclev10g)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        if (tableProxyOraclev10g != null) {
            Object object;
            ColumnProxyOraclev10g columnProxyOraclev10g = (ColumnProxyOraclev10g)tableProxyOraclev10g.getColumnProxy(column.getObjectID());
            StringBuffer stringBuffer2 = new StringBuffer();
            this.appendBeforeAlterScript(stringBuffer, bl, table);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, "ALTER");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, "TABLE");
            CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, this.getTableName(compareObjectSelection));
            CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, "ADD");
            String string = stringBuffer2.toString() + this.storageDesign.getFormatedName(column.getName());
            CSSBAlterColumnOraclev10g.appendNewLine(stringBuffer2, bl, 1);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, '(');
            CSSBAlterColumnOraclev10g.appendNewLine(stringBuffer2, bl, 1);
            CSSBAlterColumnOraclev10g.appendSpace(stringBuffer2);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(columnProxyOraclev10g.getName()));
            String string2 = "";
            Datatype datatype = column.getDataType();
            if ((datatype instanceof StructuredType || datatype instanceof CollectionType) && (object = this.storageDesign.getProxy(datatype)) != null) {
                string2 = this.storageDesign.getFormatedName(((RelationalObjectProxy)object).getLongName());
                if (column.isReference() && datatype instanceof StructuredType) {
                    string2 = "REF " + string2;
                }
            }
            if (string2.equals("")) {
                string2 = column.getDatatypeString("Oracle Database 10g");
            }
            this.appendDatatype(stringBuffer2, string2, columnProxyOraclev10g, bl);
            if (tableProxyOraclev10g != null) {
                this.appendColumnOptions(stringBuffer2, tableProxyOraclev10g, column, columnProxyOraclev10g, bl);
                this.appendInlineRefConstraint(stringBuffer2, column, columnProxyOraclev10g, bl);
                CSSBCreateTableOraclev10g.appendColumnConstraints(stringBuffer2, column, columnProxyOraclev10g, true, bl);
            }
            CSSBAlterColumnOraclev10g.appendNewLine(stringBuffer2, bl, 1);
            CSSBAlterColumnOraclev10g.appendStringWithSpace(stringBuffer2, ')');
            if (datatype.toString().equals("XMLTYPE")) {
                this.appendXMLTypeColumnProps(stringBuffer2, columnProxyOraclev10g, bl);
            } else if (datatype instanceof CollectionType) {
                object = (CollectionType)datatype;
                if (((CollectionType)object).isArrayType()) {
                    this.appendVarrayColumnProp(stringBuffer2, columnProxyOraclev10g, bl);
                } else {
                    this.appendNestedTableColumnProp(stringBuffer2, columnProxyOraclev10g, bl);
                }
            } else if (datatype instanceof StructuredType) {
                this.appendSubstitutableColumnClause(stringBuffer2, columnProxyOraclev10g, bl, true);
            }
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            CSSBAlterColumnOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisher(stringBuffer2, bl);
            CSSBAlterColumnOraclev10g.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            CDDLFileMaker.incrementAlterTable();
            this.appendAfterAlterScript(stringBuffer, bl, table);
            if (columnProxyOraclev10g.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendCommentOnColumn(stringBuffer, tableProxyOraclev10g, columnProxyOraclev10g, bl);
            }
            if (column.isAutoIncrementColumn()) {
                object = DDLFileMaker.getddlAdvancedGenenerator();
                try {
                    DDLFileMaker.setddlAdvancedGenenerator(CDDLFileMaker.getddlAdvancedGenenerator());
                    if (this.ssbAutoIncCol == null) {
                        this.ssbAutoIncCol = new SSBAutoIncrementColumnOracle(this.storageDesign);
                    }
                    this.ssbAutoIncCol.appendAutoIncrementSequenceAndTrigger(stringBuffer, column, bl);
                }
                finally {
                    DDLFileMaker.setddlAdvancedGenenerator((DDLAdvancedGenerator)object);
                }
            }
        }
    }

    protected void appendVirtualColumnDefinition(StringBuffer stringBuffer, TableProxyOraclev10g tableProxyOraclev10g, ColumnProxyOraclev11g columnProxyOraclev11g, boolean bl) {
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof Column;
    }

    public String getTableName(CompareObjectSelection compareObjectSelection) {
        CompareObjectSelection compareObjectSelection2 = compareObjectSelection.getTableNode();
        if (compareObjectSelection2 != null) {
            String string = compareObjectSelection2.getChoosedPropertyValue(PropertiesComparator.SCHEMA);
            String string2 = "".equals(string) ? this.storageDesign.getFormatedName(compareObjectSelection2.getChoosedPropertyValue(PropertiesComparator.NAME)) : this.storageDesign.getFormatedName(string) + "." + this.storageDesign.getFormatedName(compareObjectSelection2.getChoosedPropertyValue(PropertiesComparator.NAME));
            return string2;
        }
        return "";
    }
}

