/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.util.Iterator;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.RoleOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PermissionsOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SequenceOraclev9i;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBSequence
extends AbstractCSSBOracle {
    private StorageDesign storageDesign;

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        SequenceOraclev9i sequenceOraclev9i = (SequenceOraclev9i)((CompareObjectSelection)object).getObject();
        this.storageDesign = sequenceOraclev9i.getStorageDesign();
        this.appendComment(stringBuffer, sequenceOraclev9i);
        stringBuffer2.append("CREATE SEQUENCE ").append(this.storageDesign.getFormatedName(sequenceOraclev9i.getLongName()));
        string = stringBuffer2.toString();
        this.appendStartWith(stringBuffer2, sequenceOraclev9i);
        this.appendIncrementBy(stringBuffer2, sequenceOraclev9i);
        this.appendMaxValue(stringBuffer2, sequenceOraclev9i);
        this.appendMinValue(stringBuffer2, sequenceOraclev9i);
        this.appendCycle(stringBuffer2, sequenceOraclev9i);
        this.appendCache(stringBuffer2, sequenceOraclev9i);
        this.appendOrder(stringBuffer2, sequenceOraclev9i);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        if (bl) {
            stringBuffer2.append(NEWLINE);
        }
        stringBuffer2.append(';');
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        CDDLFileMaker.incrementCreateSequence();
        stringBuffer.append(NEWLINE);
        this.appendPermissions(stringBuffer, sequenceOraclev9i, bl);
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof SequenceOraclev9i;
    }

    private void appendStartWith(StringBuffer stringBuffer, SequenceOraclev9i sequenceOraclev9i) {
        if (this.isNotEmpty(sequenceOraclev9i.getStartWith())) {
            stringBuffer.append(NEWLINE).append("    ");
            stringBuffer.append("START WITH ").append(sequenceOraclev9i.getStartWith());
        }
    }

    private void appendIncrementBy(StringBuffer stringBuffer, SequenceOraclev9i sequenceOraclev9i) {
        if (this.isNotEmpty(sequenceOraclev9i.getIncrementBy())) {
            stringBuffer.append(NEWLINE).append("    ");
            stringBuffer.append("INCREMENT BY ").append(sequenceOraclev9i.getIncrementBy());
        }
    }

    private void appendMaxValue(StringBuffer stringBuffer, SequenceOraclev9i sequenceOraclev9i) {
        if (this.isNotEmpty(sequenceOraclev9i.getMaxValue())) {
            stringBuffer.append(NEWLINE).append("    ");
            stringBuffer.append("MAXVALUE ").append(sequenceOraclev9i.getMaxValue());
        }
    }

    private void appendMinValue(StringBuffer stringBuffer, SequenceOraclev9i sequenceOraclev9i) {
        if (this.isNotEmpty(sequenceOraclev9i.getMinValue())) {
            stringBuffer.append(NEWLINE).append("    ");
            stringBuffer.append("MINVALUE ").append(sequenceOraclev9i.getMinValue());
        }
    }

    private void appendCycle(StringBuffer stringBuffer, SequenceOraclev9i sequenceOraclev9i) {
        if ("YES".equalsIgnoreCase(sequenceOraclev9i.getCycle())) {
            stringBuffer.append(NEWLINE).append("    ");
            stringBuffer.append("CYCLE");
        }
    }

    private void appendCache(StringBuffer stringBuffer, SequenceOraclev9i sequenceOraclev9i) {
        if (this.isNotEmpty(sequenceOraclev9i.getCache())) {
            stringBuffer.append(NEWLINE).append("    ");
            stringBuffer.append("CACHE ").append(sequenceOraclev9i.getCache());
        }
    }

    private void appendOrder(StringBuffer stringBuffer, SequenceOraclev9i sequenceOraclev9i) {
        if ("YES".equalsIgnoreCase(sequenceOraclev9i.getOrder())) {
            stringBuffer.append(NEWLINE).append("    ");
            stringBuffer.append("ORDER");
        }
    }

    private void appendPermissions(StringBuffer stringBuffer, SequenceOraclev9i sequenceOraclev9i, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        PermissionsSetOracle permissionsSetOracle = ((StorageDesignOracle)sequenceOraclev9i.getStorageDesign()).getPermissionsSet();
        Iterator iterator = permissionsSetOracle.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            AbstractStorageObjectOracle abstractStorageObjectOracle;
            PermissionsOraclev9i permissionsOraclev9i = (PermissionsOraclev9i)iterator.next();
            if (permissionsOraclev9i.getSequence() != null && permissionsOraclev9i.getSequence().equals(sequenceOraclev9i) && !permissionsOraclev9i.getPrivileges().equalsIgnoreCase("")) {
                if (sequenceOraclev9i.getUser() != null) {
                    abstractStorageObjectOracle = null;
                    abstractStorageObjectOracle = permissionsOraclev9i.getUser() != null ? permissionsOraclev9i.getUser() : permissionsOraclev9i.getRole();
                    this.appendExecutePackage(stringBuffer, permissionsOraclev9i.getPrivileges(), permissionsOraclev9i.getSequence(), abstractStorageObjectOracle, bl2, false);
                    bl2 = false;
                } else {
                    CSSBSequence.appendNewLine(stringBuffer, bl, 0);
                    CSSBSequence.appendNewLine(stringBuffer, bl, 0);
                    this.appendComment(stringBuffer, permissionsOraclev9i);
                    CSSBSequence.appendStringWithSpace(stringBuffer2, "GRANT");
                    CSSBSequence.appendStringWithSpace(stringBuffer2, permissionsOraclev9i.getPrivileges());
                    string = stringBuffer2.toString();
                    this.appendObject(stringBuffer2, permissionsOraclev9i, bl);
                    this.appendTo(stringBuffer2, permissionsOraclev9i);
                    this.appendToBuffer(stringBuffer, stringBuffer2, string);
                    CSSBSequence.appendNewLine(stringBuffer2, bl, 0);
                    stringBuffer2.append(';');
                    CSSBSequence.appendNewLine(stringBuffer2, bl, 0);
                    this.appendToBuffer(stringBuffer, stringBuffer2, string);
                }
            }
            if (permissionsOraclev9i.getSequence() == null || !permissionsOraclev9i.getSequence().equals(sequenceOraclev9i) || permissionsOraclev9i.getPrivilegesWithGrantOption().equalsIgnoreCase("")) continue;
            if (sequenceOraclev9i.getUser() != null) {
                abstractStorageObjectOracle = null;
                abstractStorageObjectOracle = permissionsOraclev9i.getUser() != null ? permissionsOraclev9i.getUser() : permissionsOraclev9i.getRole();
                this.appendExecutePackage(stringBuffer, permissionsOraclev9i.getPrivilegesWithGrantOption(), permissionsOraclev9i.getSequence(), abstractStorageObjectOracle, bl2, true);
                bl2 = false;
                continue;
            }
            CSSBSequence.appendNewLine(stringBuffer, bl, 0);
            CSSBSequence.appendNewLine(stringBuffer, bl, 0);
            this.appendComment(stringBuffer, permissionsOraclev9i);
            CSSBSequence.appendStringWithSpace(stringBuffer2, "GRANT");
            CSSBSequence.appendStringWithSpace(stringBuffer2, permissionsOraclev9i.getPrivilegesWithGrantOption());
            string = stringBuffer2.toString();
            this.appendObject(stringBuffer2, permissionsOraclev9i, bl);
            this.appendTo(stringBuffer2, permissionsOraclev9i);
            this.appendGrantOption(stringBuffer2, permissionsOraclev9i);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            CSSBSequence.appendNewLine(stringBuffer2, bl, 0);
            stringBuffer2.append(';');
            CSSBSequence.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
        }
        if (!bl2) {
            this.appendDropPackage(stringBuffer, this.storageDesign.getFormatedName(sequenceOraclev9i.getUser().getName()));
        }
    }

    private void appendObject(StringBuffer stringBuffer, PermissionsOracle permissionsOracle, boolean bl) {
        CSSBSequence.appendNewLine(stringBuffer, bl, 1);
        CSSBSequence.appendStringWithSpace(stringBuffer, "ON");
        if (permissionsOracle.getSequence() != null) {
            CSSBSequence.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOracle.getSequence().getLongName()));
        }
    }

    private void appendTo(StringBuffer stringBuffer, PermissionsOraclev9i permissionsOraclev9i) {
        stringBuffer.append(" TO ");
        if ("YES".equalsIgnoreCase(permissionsOraclev9i.getPublic())) {
            CSSBSequence.appendStringWithSpace(stringBuffer, "PUBLIC");
        } else if (permissionsOraclev9i.getUser() != null) {
            CSSBSequence.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev9i.getUser().getName()));
        } else if (permissionsOraclev9i.getRole() != null) {
            CSSBSequence.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev9i.getRole().getName()));
        }
    }

    private void appendGrantOption(StringBuffer stringBuffer, PermissionsOraclev9i permissionsOraclev9i) {
        if (permissionsOraclev9i.getRole() == null) {
            CSSBSequence.appendStringWithSpace(stringBuffer, "WITH GRANT OPTION");
        }
    }

    private void createPackage(StringBuffer stringBuffer, String string) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string2 = "";
        stringBuffer.append(NEWLINE);
        stringBuffer.append(NEWLINE);
        stringBuffer2.append("CREATE OR REPLACE PACKAGE ").append(string).append(".perm_manager IS");
        string2 = stringBuffer2.toString();
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("v_option VARCHAR(20) DEFAULT NULL;");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("v_statement VARCHAR(2000) DEFAULT NULL;");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("procedure perm_grant(p_privilege IN VARCHAR2,");
        stringBuffer2.append(NEWLINE).append("    ").append("    ");
        stringBuffer2.append("p_object IN VARCHAR2,");
        stringBuffer2.append(NEWLINE).append("    ").append("    ");
        stringBuffer2.append("p_grantee IN VARCHAR2,");
        stringBuffer2.append(NEWLINE).append("    ").append("    ");
        stringBuffer2.append("p_option IN BOOLEAN DEFAULT FALSE);");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("END perm_manager;");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("/");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("CREATE OR REPLACE PACKAGE BODY ").append(string).append(".perm_manager IS");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("procedure perm_grant(p_privilege IN VARCHAR2,");
        stringBuffer2.append(NEWLINE).append("    ").append("    ");
        stringBuffer2.append("p_object IN VARCHAR2,");
        stringBuffer2.append(NEWLINE).append("    ").append("    ");
        stringBuffer2.append("p_grantee IN VARCHAR2,");
        stringBuffer2.append(NEWLINE).append("    ").append("    ");
        stringBuffer2.append("p_option IN BOOLEAN DEFAULT FALSE) IS");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("BEGIN");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("    ").append("IF (NOT p_option)");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("    ").append(" THEN v_option := '';");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("    ").append("ELSE v_option := 'WITH GRANT OPTION';");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("    ").append("END IF;");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("    ").append("v_statement := 'GRANT '||p_privilege||");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("    ").append("    ").append("' ON ' ||p_object||");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("    ").append("    ").append("' TO ' ||p_grantee||");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("    ").append("    ").append("' ' ||v_option;");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("    ").append("EXECUTE IMMEDIATE v_statement;");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("END perm_grant;");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("END perm_manager;");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("/");
        this.appendToBuffer(stringBuffer, stringBuffer2, string2);
    }

    private void appendExecutePackage(StringBuffer stringBuffer, String string, SequenceOracle sequenceOracle, StorageObject storageObject, boolean bl, boolean bl2) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string2 = this.storageDesign.getFormatedName(sequenceOracle.getUser().getName());
        if (bl) {
            this.createPackage(stringBuffer, string2);
        }
        stringBuffer.append(NEWLINE);
        stringBuffer.append(NEWLINE);
        CSSBSequence.appendStringWithSpace(stringBuffer2, "BEGIN");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("    ").append(string2).append(".perm_manager.perm_grant('").append(string).append("', '");
        if (sequenceOracle != null) {
            stringBuffer2.append(this.storageDesign.getFormatedName(sequenceOracle.getLongName()));
        }
        stringBuffer2.append("', '");
        if (storageObject != null) {
            stringBuffer2.append(storageObject);
        }
        stringBuffer2.append("', ");
        if (bl2) {
            if (storageObject instanceof RoleOracle && storageObject == null) {
                stringBuffer2.append("true");
            } else {
                stringBuffer2.append("false");
            }
        } else {
            stringBuffer2.append("false");
        }
        stringBuffer2.append(");");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("END;");
        stringBuffer2.append(NEWLINE);
        stringBuffer2.append("/");
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
    }

    private void appendDropPackage(StringBuffer stringBuffer, String string) {
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer.append(NEWLINE);
        stringBuffer.append(NEWLINE);
        stringBuffer2.append("DROP PACKAGE ").append(string).append(".perm_manager;");
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
    }
}

