/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.TableSelection;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBCreateRenameTable;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBRenameTableOraclev10g;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.BitmapJoinIndexOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.FKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueOraclev9i;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBRenameTable
extends AbstractCSSBOracle {
    private StorageDesignOracle storageDesign;
    private Map fkList = new TreeMap();
    private CSSBCreateRenameTable createTable = new CSSBCreateRenameTable();

    public CSSBRenameTable(Map map) {
        this.fkList = map;
    }

    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        Object object2;
        if (object == null) {
            return;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        Table table = null;
        TableSelection tableSelection = (TableSelection)object;
        TableSelection tableSelection2 = (TableSelection)((CompareObjectSelection)object).getCorrespondentNode();
        TableProxyOracle tableProxyOracle = null;
        Table table2 = null;
        if (((CompareObjectSelection)object).getObject() instanceof Table) {
            table = (Table)((CompareObjectSelection)object).getCorrespondentNode().getObject();
            object2 = table.getDesign();
            RDBMSSite rDBMSSite = table.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOracle)((Design)object2).getStorageDesign(rDBMSSite, table);
            tableProxyOracle = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
            table2 = (Table)((CompareObjectSelection)object).getObject();
        } else if (((CompareObjectSelection)object).getObject() instanceof TableProxyOracle) {
            tableProxyOracle = (TableProxyOracle)((CompareObjectSelection)object).getCorrespondentNode().getObject();
            table = (Table)tableProxyOracle.getObject();
            object2 = table.getDesign();
            this.storageDesign = (StorageDesignOracle)((Design)object2).getStorageDesign(table.getSelectedRDBMSSite(), table);
            table2 = (Table)((TableProxyOracle)((CompareObjectSelection)object).getObject()).getObject();
        }
        if (((CompareObjectSelection)object).canBeRenameOnly()) {
            this.appendRenameTableOnly(table, table2, stringBuffer, bl);
            return;
        }
        if (tableSelection2.getScriptExecuteOption().equals(TableSelection.STOP_BEFORE_BACKUP) && (TableSelection.BACKUP_RENAME.equals(object2 = tableSelection2.getBackupOption()) || TableSelection.BACKUP_UNLOAD.equals(object2) || TableSelection.BACKUP_UNLOAD_PARTITION.equals(object2))) {
            this.appendScriptExecution(stringBuffer, this.storageDesign.getFormatedName(tableSelection2.getName()));
        }
        CSSBRenameTable.appendNewLine(stringBuffer2, bl, 0);
        this.appendDropFK(tableProxyOracle, (CompareObjectSelection)object, stringBuffer, bl);
        this.appendDropPK(tableProxyOracle, stringBuffer, bl);
        this.appendDropUK(tableProxyOracle, stringBuffer, bl);
        this.appendDropConstraint(tableProxyOracle, stringBuffer, bl);
        this.appendDropCoilumnConstraints(tableProxyOracle, stringBuffer, bl);
        this.appendDropIndex(tableProxyOracle, stringBuffer, bl);
        this.appendDropTriggers(tableProxyOracle, stringBuffer, bl);
        this.appendDropBitmapJoinIndexes((TableProxyOraclev9i)tableProxyOracle, stringBuffer, bl);
        if (TableSelection.BACKUP_RENAME.equals(tableSelection2.getBackupOption())) {
            this.appendRenameTable(tableProxyOracle, stringBuffer, bl);
            if (tableSelection2.getScriptExecuteOption().equals(TableSelection.STOP_AFTER_BACKUP)) {
                this.appendScriptExecution(stringBuffer, this.storageDesign.getFormatedName(tableSelection2.getName()));
            }
        } else if (TableSelection.BACKUP_UNLOAD.equals(tableSelection2.getBackupOption())) {
            object2 = tableSelection2.getUnloadDirectory();
            if ("".equals(object2)) {
                object2 = table.getDesign().getUnloadDirectory();
            }
            this.addUnloadExecution(stringBuffer, tableSelection, tableProxyOracle, (String)object2);
            if (tableSelection2.getScriptExecuteOption().equals(TableSelection.STOP_AFTER_BACKUP)) {
                this.appendScriptExecution(stringBuffer, this.storageDesign.getFormatedName(tableSelection2.getName()));
            }
            this.appendDropTable(stringBuffer, tableProxyOracle, bl);
        } else if (TableSelection.BACKUP_UNLOAD_PARTITION.equals(tableSelection2.getBackupOption())) {
            object2 = tableSelection2.getUnloadDirectory();
            if ("".equals(object2)) {
                object2 = table.getDesign().getUnloadDirectory();
            }
            this.addUnloadPerPartitionExecution(stringBuffer, tableSelection, tableProxyOracle, (String)object2);
            if (tableSelection2.getScriptExecuteOption().equals(TableSelection.STOP_AFTER_BACKUP)) {
                this.appendScriptExecution(stringBuffer, this.storageDesign.getFormatedName(tableSelection2.getName()));
            }
            this.appendDropTable(stringBuffer, tableProxyOracle, bl);
        } else if (TableSelection.NONE.equals(tableSelection2.getBackupOption())) {
            this.appendDropTable(stringBuffer, tableProxyOracle, bl);
        }
        this.appendCreateTable(object, stringBuffer, bl);
    }

    private void appendDropTable(StringBuffer stringBuffer, TableProxyOracle tableProxyOracle, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        CSSBRenameTable.appendNewLine(stringBuffer, bl, 0);
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, "DROP");
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, "TABLE");
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(tableProxyOracle.getLongName()));
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
        CSSBRenameTable.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer2, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
        CDDLFileMaker.incrementDropTable();
    }

    private void appendCreateTable(Object object, StringBuffer stringBuffer, boolean bl) {
        this.createTable.setRenamed(true);
        this.createTable.doAppend(stringBuffer, object, bl);
    }

    private void appendRenameTable(TableProxyOracle tableProxyOracle, StringBuffer stringBuffer, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        this.appendBeforeAlterScript(stringBuffer, bl, (ContainerObject)tableProxyOracle.getObject());
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, "ALTER");
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, "TABLE");
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(tableProxyOracle.getLongName()));
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, "RENAME");
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, "TO");
        String string = "bcp_" + tableProxyOracle.getName();
        if (string.length() > 30) {
            string = string.substring(0, 30);
        }
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(string));
        String string2 = stringBuffer2.toString();
        this.appendToBuffer(stringBuffer, stringBuffer2, string2);
        CSSBRenameTable.appendNewLine(stringBuffer2, bl, 0);
        this.appendLineFinisher(stringBuffer2, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string2);
        this.appendAfterAlterScript(stringBuffer, bl, (ContainerObject)tableProxyOracle.getObject());
        CDDLFileMaker.incrementAlterTable();
    }

    private void appendRenameTableOnly(Table table, Table table2, StringBuffer stringBuffer, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        this.appendBeforeAlterScript(stringBuffer, bl, table);
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, "ALTER");
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, "TABLE");
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(table.getLongName()));
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, "RENAME");
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, "TO");
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(table2.getName()));
        String string = stringBuffer2.toString();
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        CSSBRenameTable.appendNewLine(stringBuffer2, bl, 0);
        this.appendLineFinisher(stringBuffer2, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        this.appendAfterAlterScript(stringBuffer, bl, table);
        CDDLFileMaker.incrementAlterTable();
    }

    private void appendDropConstraint(TableProxyOracle tableProxyOracle, StringBuffer stringBuffer, boolean bl) {
        Table table = (Table)tableProxyOracle.getObject();
        for (TableLevelConstraint tableLevelConstraint : table.getCheckConstraints()) {
            this.appendDropObject(tableProxyOracle, this.storageDesign.getFormatedName(tableLevelConstraint.getName()), stringBuffer, bl);
        }
    }

    private void appendDropIndex(TableProxyOracle tableProxyOracle, StringBuffer stringBuffer, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        Iterator iterator = tableProxyOracle.getIndexes().iterator();
        while (iterator.hasNext()) {
            IndexProxyOraclev9i indexProxyOraclev9i = (IndexProxyOraclev9i)iterator.next();
            CSSBRenameTable.appendStringWithSpace(stringBuffer2, "DROP");
            CSSBRenameTable.appendStringWithSpace(stringBuffer2, "INDEX");
            CSSBRenameTable.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(indexProxyOraclev9i.getUserNameAndName()));
            String string = stringBuffer2.toString();
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            CSSBRenameTable.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisher(stringBuffer2, bl);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
        }
    }

    private void appendDropUK(TableProxyOracle tableProxyOracle, StringBuffer stringBuffer, boolean bl) {
        Iterator iterator = tableProxyOracle.getUniqueKeys().iterator();
        while (iterator.hasNext()) {
            UniqueOraclev9i uniqueOraclev9i = (UniqueOraclev9i)iterator.next();
            this.appendDropObject(tableProxyOracle, this.storageDesign.getFormatedName(uniqueOraclev9i.getName()), stringBuffer, bl);
        }
    }

    private void appendDropPK(TableProxyOracle tableProxyOracle, StringBuffer stringBuffer, boolean bl) {
        if (!tableProxyOracle.getPKName().equals("")) {
            this.appendDropObject(tableProxyOracle, this.storageDesign.getFormatedName(tableProxyOracle.getPKName()), stringBuffer, bl);
        }
    }

    private void appendDropObject(TableProxyOracle tableProxyOracle, String string, StringBuffer stringBuffer, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        CSSBRenameTable.appendNewLine(stringBuffer, bl, 0);
        this.appendBeforeAlterScript(stringBuffer, bl, (ContainerObject)tableProxyOracle.getObject());
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, "ALTER");
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, "TABLE");
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(tableProxyOracle.getLongName()));
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, "DROP");
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, string);
        String string2 = stringBuffer2.toString();
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, "CASCADE");
        this.appendToBuffer(stringBuffer, stringBuffer2, string2);
        this.appendLineFinisher(stringBuffer2, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string2);
        this.appendAfterAlterScript(stringBuffer, bl, (ContainerObject)tableProxyOracle.getObject());
        CDDLFileMaker.incrementAlterTable();
    }

    private void appendDropFK(TableProxyOracle tableProxyOracle, CompareObjectSelection compareObjectSelection, StringBuffer stringBuffer, boolean bl) {
        Iterator iterator = this.storageDesign.getFKProxySet().iterator();
        while (iterator.hasNext()) {
            FKProxyOraclev9i fKProxyOraclev9i = (FKProxyOraclev9i)iterator.next();
            if (fKProxyOraclev9i.getFKTable() != tableProxyOracle.getObject()) continue;
            this.appendDropObject((TableProxyOracle)fKProxyOraclev9i.getTableProxy(), this.storageDesign.getFormatedName(fKProxyOraclev9i.getName()), stringBuffer, bl);
            FKIndexAssociation fKIndexAssociation = fKProxyOraclev9i.getIndex().getFKAssociation();
            this.fkList.put(fKIndexAssociation.getObjectID(), tableProxyOracle);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getCorrespondentNode().getObject() instanceof Table && (((CompareObjectSelection)object).canBeRename() || ((CompareObjectSelection)object).canBeRenameOnly());
    }

    public void addUnloadExecution(StringBuffer stringBuffer, TableSelection tableSelection, TableProxy tableProxy, String string) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string2 = tableProxy.getName();
        this.appendUnloadHeader(stringBuffer, stringBuffer2, this.storageDesign.getFormatedName(string2), "");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("query:=   '");
        stringBuffer.append(this.newline()).append(this.newTab());
        stringBuffer.append("  select ");
        this.addColumns(stringBuffer, tableProxy, tableSelection);
        stringBuffer.append(this.newline()).append(this.newTab());
        File file = new File(string, string2 + ".txt");
        stringBuffer.append("  from ").append(this.storageDesign.getFormatedName(tableProxy.getLongName()));
        stringBuffer.append(this.newline());
        stringBuffer.append("  ';");
        stringBuffer.append(this.newline());
        stringBuffer.append("    cwd_query_to_file( query ,'" + file.getAbsolutePath() + "'," + CDDLFileMaker.getReplaceOption() + ");");
        stringBuffer.append(this.newline());
        if (CDDLFileMaker.getddlAdvancedGenenerator() != null) {
            stringBuffer.append("   end if;");
            stringBuffer.append(this.newline());
        }
        stringBuffer.append("  end;");
        stringBuffer.append(this.newline());
        stringBuffer.append("/");
        stringBuffer.append(this.newline());
        stringBuffer.append(this.newline());
    }

    private void addColumns(StringBuffer stringBuffer, TableProxy tableProxy, TableSelection tableSelection) {
        List list = tableSelection.getChildObjects(0);
        String string = "col";
        int n = 1;
        Design design = tableProxy.getDesign();
        if (list.size() > 0) {
            boolean bl = true;
            for (CompareObjectSelection compareObjectSelection : list) {
                CompareObjectSelection compareObjectSelection2;
                if (compareObjectSelection.canBeCreate() || compareObjectSelection.canBeDrop() && compareObjectSelection.isSelected() || this.isVirtualColumn(compareObjectSelection2 = compareObjectSelection.getCorrespondentNode())) continue;
                String string2 = this.storageDesign.getFormatedName(compareObjectSelection2.getChoosedPropertyValue(PropertiesComparator.NAME));
                String string3 = compareObjectSelection2.getChoosedPropertyValue(PropertiesComparator.DATA_TYPE);
                Column column = (Column)compareObjectSelection2.getObject();
                if (column != null) {
                    string3 = column.getDatatypeString(tableProxy.getStorageDesign().getRDBMSType().getName());
                }
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab());
                if (string3.startsWith("NUMBER") || string3.startsWith("DATE") || string3.startsWith("TIMESTAMP")) {
                    stringBuffer.append("to_char(" + CSSBRenameTableOraclev10g.getColumnPresentation(string2, string3, design) + ") ").append(string + n);
                } else {
                    stringBuffer.append(string2 + " ").append(string + n);
                }
                ++n;
            }
        }
    }

    public String newline() {
        return SQLStatementBuilder.NEWLINE;
    }

    public String newTab() {
        return "    ";
    }

    public void addUnloadPerPartitionExecution(StringBuffer stringBuffer, TableSelection tableSelection, TableProxy tableProxy, String string) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string2 = tableProxy.getName();
        Iterator iterator = ((TableProxyOracle)tableProxy).getPartitions().iterator();
        while (iterator.hasNext()) {
            PartitionOracle partitionOracle = (PartitionOracle)iterator.next();
            this.appendUnloadHeader(stringBuffer, stringBuffer2, this.storageDesign.getFormatedName(string2), this.storageDesign.getFormatedName(partitionOracle.getName()));
            stringBuffer.append(this.newline()).append(this.newTab());
            stringBuffer.append("query:=   '");
            stringBuffer.append(this.newline()).append(this.newTab());
            stringBuffer.append("  select ");
            this.addColumns(stringBuffer, tableProxy, tableSelection);
            stringBuffer.append(this.newline()).append(this.newTab());
            File file = new File(string, string2 + "_" + partitionOracle.getName() + ".txt");
            stringBuffer.append("    from ").append(this.storageDesign.getFormatedName(tableProxy.getLongName())).append(' ');
            stringBuffer.append("PARTITION").append('(').append(this.storageDesign.getFormatedName(partitionOracle.getName())).append(')');
            stringBuffer.append(this.newline());
            stringBuffer.append("  ';");
            stringBuffer.append(this.newline());
            stringBuffer.append("    cwd_query_to_file( query ,'" + file.getAbsolutePath() + "'," + CDDLFileMaker.getReplaceOption() + ");");
            stringBuffer.append(this.newline());
            if (CDDLFileMaker.getddlAdvancedGenenerator() != null) {
                stringBuffer.append("   end if;");
                stringBuffer.append(this.newline());
            }
            stringBuffer.append("  end;");
            stringBuffer.append(this.newline());
            stringBuffer.append("/");
            stringBuffer.append(this.newline());
            stringBuffer.append(this.newline());
        }
    }

    private void appendDropCoilumnConstraints(TableProxyOracle tableProxyOracle, StringBuffer stringBuffer, boolean bl) {
        ColumnProxy[] columnProxyArray = tableProxyOracle.getColumnProxies();
        for (int i = 0; i < columnProxyArray.length; ++i) {
            ColumnProxyOracle columnProxyOracle = (ColumnProxyOracle)columnProxyArray[i];
            Column column = columnProxyOracle.getColumn();
            String string = column.getConstraintName();
            if (string != null && !"".equals(string)) {
                this.appendDropConstraintsNoCascade(tableProxyOracle, string, stringBuffer, bl);
            }
            if (column.getNullsAllowed() || tableProxyOracle.getDesign().getAppView().getSettings().notNullShortFormGeneration()) continue;
            String string2 = string = columnProxyOracle.isNotNullConstraintNameChanged() ? columnProxyOracle.getNncName() : columnProxyOracle.getColumn().getNotNullConstraintName();
            if (string == null || "".equals(string)) continue;
            this.appendDropConstraintsNoCascade(tableProxyOracle, string, stringBuffer, bl);
        }
    }

    private void appendDropConstraintsNoCascade(TableProxyOracle tableProxyOracle, String string, StringBuffer stringBuffer, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        CSSBRenameTable.appendNewLine(stringBuffer2, bl, 0);
        this.appendBeforeAlterScript(stringBuffer, bl, (ContainerObject)tableProxyOracle.getObject());
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, "ALTER");
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, "TABLE");
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(tableProxyOracle.getLongName()));
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, "DROP");
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
        CSSBRenameTable.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(string));
        String string2 = stringBuffer2.toString();
        this.appendToBuffer(stringBuffer, stringBuffer2, string2);
        this.appendLineFinisher(stringBuffer2, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string2);
        this.appendAfterAlterScript(stringBuffer, bl, (ContainerObject)tableProxyOracle.getObject());
        CDDLFileMaker.incrementAlterTable();
    }

    private void appendDropTriggers(TableProxyOracle tableProxyOracle, StringBuffer stringBuffer, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        Iterator iterator = tableProxyOracle.getTriggers().iterator();
        while (iterator.hasNext()) {
            TriggerOracle triggerOracle = (TriggerOracle)iterator.next();
            CSSBRenameTable.appendStringWithSpace(stringBuffer2, "DROP");
            CSSBRenameTable.appendStringWithSpace(stringBuffer2, "TRIGGER");
            CSSBRenameTable.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(triggerOracle.getLongName()));
            String string = stringBuffer2.toString();
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            CSSBRenameTable.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisher(stringBuffer2, bl);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
        }
    }

    private void appendDropBitmapJoinIndexes(TableProxyOraclev9i tableProxyOraclev9i, StringBuffer stringBuffer, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        Iterator iterator = tableProxyOraclev9i.getBjIndexes().iterator();
        while (iterator.hasNext()) {
            BitmapJoinIndexOracle bitmapJoinIndexOracle = (BitmapJoinIndexOracle)iterator.next();
            CSSBRenameTable.appendStringWithSpace(stringBuffer2, "DROP");
            CSSBRenameTable.appendStringWithSpace(stringBuffer2, "INDEX");
            CSSBRenameTable.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(bitmapJoinIndexOracle.getLongName()));
            String string = stringBuffer2.toString();
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
            CSSBRenameTable.appendNewLine(stringBuffer2, bl, 0);
            this.appendLineFinisher(stringBuffer2, bl);
            this.appendToBuffer(stringBuffer, stringBuffer2, string);
        }
    }

    protected boolean isVirtualColumn(CompareObjectSelection compareObjectSelection) {
        return false;
    }
}

