/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBDropIndex
extends AbstractCSSBOracle {
    private Map fkMap;

    public CSSBDropIndex(Map map) {
        this.fkMap = map;
    }

    @Override
    public void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        if (object == null) {
            return;
        }
        KeyObject keyObject = (KeyObject)((CompareObjectSelection)object).getCorrespondentNode().getObject();
        if (keyObject != null && !this.fkMap.containsKey(keyObject.getObjectID())) {
            StringBuffer stringBuffer2 = new StringBuffer();
            String string = "";
            Table table = (Table)keyObject.getContainerObject();
            Design design = table.getDesign();
            RDBMSSite rDBMSSite = table.getSelectedRDBMSSite();
            StorageDesignOracle storageDesignOracle = (StorageDesignOracle)design.getStorageDesign(rDBMSSite, table);
            if (keyObject.isPK() || keyObject.isUnique()) {
                CSSBDropIndex.appendStringWithSpace(stringBuffer2, "ALTER");
                CSSBDropIndex.appendStringWithSpace(stringBuffer2, "TABLE");
                CSSBDropIndex.appendStringWithSpace(stringBuffer2, this.getTableName((CompareObjectSelection)object, storageDesignOracle));
                CSSBDropIndex.appendStringWithSpace(stringBuffer2, "DROP");
                CSSBDropIndex.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
                CSSBDropIndex.appendStringWithSpace(stringBuffer2, storageDesignOracle.getFormatedName(keyObject.getName()));
                string = stringBuffer2.toString();
                CSSBDropIndex.appendStringWithSpace(stringBuffer2, "CASCADE");
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                CSSBDropIndex.appendNewLine(stringBuffer2, bl, 0);
                this.appendLineFinisher(stringBuffer2, bl);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                CDDLFileMaker.incrementAlterTable();
            } else {
                this.appendDrop(stringBuffer2);
                CSSBDropIndex.appendStringWithSpace(stringBuffer2, "INDEX");
                IndexProxyOracle indexProxyOracle = (IndexProxyOracle)storageDesignOracle.getIndexProxySet().getProxy(keyObject.getObjectID());
                CSSBDropIndex.appendStringWithSpace(stringBuffer2, storageDesignOracle.getFormatedName(indexProxyOracle.getUserNameAndName()));
                string = stringBuffer2.toString();
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                CSSBDropIndex.appendNewLine(stringBuffer2, bl, 0);
                this.appendLineFinisher(stringBuffer2, bl);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                CDDLFileMaker.incrementDropIndex();
            }
            this.fkMap.put(keyObject.getObjectID(), keyObject);
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getCorrespondentNode().getObject() instanceof Index;
    }

    private String getTableName(CompareObjectSelection compareObjectSelection, StorageDesignOracle storageDesignOracle) {
        CompareObjectSelection compareObjectSelection2 = compareObjectSelection.getTableNode();
        if (compareObjectSelection2 != null) {
            return storageDesignOracle.getFormatedName(compareObjectSelection2.getChoosedPropertyValue(PropertiesComparator.SCHEMA) + '.' + compareObjectSelection2.getChoosedPropertyValue(PropertiesComparator.NAME));
        }
        return "";
    }
}

