/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.DDLAdvancedGenerator;
import oracle.dbtools.crest.exports.ddl.oracle.SSBAutoIncrementColumnOracle;
import oracle.dbtools.crest.exports.ddl.oracle.v9i.SSBCreateBitmapJoinIndexOraclev9i;
import oracle.dbtools.crest.exports.ddl.oracle.v9i.SSBTriggerOraclev9i;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.TableComparator;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.AbstractCSSBOraclev9i;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBIndex;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateTableOraclev10g;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ClusterOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ColumnProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionLobItemOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionLobItemSetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionSetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionsListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListStorageTemplatePartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.LobStorageOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxySetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PermissionsOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueOraclev9i;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class CSSBCreateTable
extends AbstractCSSBOraclev9i {
    private CSSBIndex cssbIndex = new CSSBIndex();
    private PKProxyOraclev9i pk = null;
    private boolean isRenamed = false;
    private CompareObjectSelection tableObj;
    private SSBCreateBitmapJoinIndexOraclev9i ssbBJIndex = null;
    private SSBAutoIncrementColumnOracle ssbAutoIncCol = null;
    private SSBTriggerOraclev9i ssbTriggers = null;

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).canBeCreate() && ((CompareObjectSelection)object).getObject() instanceof Table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        block25: {
            Table table;
            block23: {
                block24: {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    String string = "";
                    table = null;
                    TableProxyOraclev9i tableProxyOraclev9i = null;
                    this.tableObj = (CompareObjectSelection)object;
                    if (object == null) {
                        return;
                    }
                    if (!(this.tableObj.getObject() instanceof Table)) {
                        return;
                    }
                    table = (Table)this.tableObj.getObject();
                    Iterator iterator = table.getDesign();
                    Object object2 = table.getSelectedRDBMSSite();
                    this.storageDesign = (StorageDesignOracle)((Design)((Object)iterator)).getStorageDesign((RDBMSSite)object2, table);
                    tableProxyOraclev9i = (TableProxyOraclev9i)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
                    if (table.getTypeSubstitution() != null) break block23;
                    if (tableProxyOraclev9i != null && tableProxyOraclev9i.isCommentChanged()) {
                        this.appendComment(stringBuffer, tableProxyOraclev9i);
                    } else {
                        this.appendComment(stringBuffer, table);
                    }
                    if (tableProxyOraclev9i != null && tableProxyOraclev9i.getName().length() > tableProxyOraclev9i.getMaxNameLength()) {
                        CSSBCreateTable.appendNewLine(stringBuffer, bl, 0);
                        CSSBCreateTable.appendStringWithSpace(stringBuffer, "--  ERROR: Table name length exceeds maximum allowed length(" + tableProxyOraclev9i.getMaxNameLength() + ")");
                        CSSBCreateTable.appendNewLine(stringBuffer, bl, 0);
                        CDDLFileMaker.incrementErrors();
                    }
                    if (tableProxyOraclev9i != null && tableProxyOraclev9i.getSnapshot() == null) {
                        this.appendBeforeCreateScript(stringBuffer, bl, table);
                        CSSBCreateTable.appendStringWithSpace(stringBuffer2, "CREATE");
                        if (tableProxyOraclev9i == null) {
                            CSSBCreateTable.appendStringWithSpace(stringBuffer2, "TABLE");
                            CSSBCreateTable.appendStringWithSpace(stringBuffer2, this.getTableName(this.tableObj));
                            string = stringBuffer2.toString();
                            this.appendElementList(stringBuffer2, table, null, bl);
                            this.appendOid(stringBuffer2, table, null, bl);
                        } else if ("YES".equalsIgnoreCase(tableProxyOraclev9i.getTemporary())) {
                            CSSBCreateTable.appendStringWithSpace(stringBuffer2, "GLOBAL");
                            CSSBCreateTable.appendStringWithSpace(stringBuffer2, "TEMPORARY");
                            CSSBCreateTable.appendStringWithSpace(stringBuffer2, "TABLE");
                            CSSBCreateTable.appendStringWithSpace(stringBuffer2, this.getTableName(this.tableObj));
                            string = stringBuffer2.toString();
                            this.appendElementList(stringBuffer2, table, tableProxyOraclev9i, bl);
                            CSSBCreateTable.appendNewLine(stringBuffer2, bl, 1);
                            CSSBCreateTable.appendStringWithSpace(stringBuffer2, "ON");
                            CSSBCreateTable.appendStringWithSpace(stringBuffer2, "COMMIT");
                            if ("YES".equalsIgnoreCase(tableProxyOraclev9i.getTempPreserveRows())) {
                                CSSBCreateTable.appendStringWithSpace(stringBuffer2, "PRESERVE ROWS");
                            } else {
                                CSSBCreateTable.appendStringWithSpace(stringBuffer2, "DELETE ROWS");
                            }
                            this.appendOid(stringBuffer2, table, null, bl);
                            if ("YES".equalsIgnoreCase(tableProxyOraclev9i.getCache())) {
                                CSSBCreateTable.appendNewLine(stringBuffer2, bl, 1);
                                CSSBCreateTable.appendStringWithSpace(stringBuffer2, "CACHE");
                            }
                        } else {
                            CSSBCreateTable.appendStringWithSpace(stringBuffer2, "TABLE");
                            CSSBCreateTable.appendStringWithSpace(stringBuffer2, this.getTableName(this.tableObj));
                            string = stringBuffer2.toString();
                            this.appendElementList(stringBuffer2, table, tableProxyOraclev9i, bl);
                            this.appendOid(stringBuffer2, table, tableProxyOraclev9i, bl);
                            this.appendCluster(stringBuffer2, tableProxyOraclev9i, bl);
                            this.appendColumnProperties(stringBuffer2, table, tableProxyOraclev9i, bl);
                            this.appendPartitionList(stringBuffer2, tableProxyOraclev9i, bl);
                            if ("YES".equalsIgnoreCase(tableProxyOraclev9i.getCache())) {
                                CSSBCreateTable.appendNewLine(stringBuffer2, bl, 1);
                                CSSBCreateTable.appendStringWithSpace(stringBuffer2, "CACHE");
                            }
                            if ("YES".equalsIgnoreCase(tableProxyOraclev9i.getMonitoring())) {
                                CSSBCreateTable.appendNewLine(stringBuffer2, bl, 1);
                                CSSBCreateTable.appendStringWithSpace(stringBuffer2, "MONITORING");
                            }
                            if ("YES".equalsIgnoreCase(tableProxyOraclev9i.getParallel())) {
                                CSSBCreateTable.appendNewLine(stringBuffer2, bl, 1);
                                CSSBCreateTable.appendStringWithSpace(stringBuffer2, "PARALLEL");
                                if (!"".equals(tableProxyOraclev9i.getDegree())) {
                                    CSSBCreateTable.appendStringWithSpace(stringBuffer2, tableProxyOraclev9i.getDegree());
                                }
                            }
                            if ("YES".equalsIgnoreCase(tableProxyOraclev9i.getRowDependency())) {
                                CSSBCreateTable.appendNewLine(stringBuffer2, bl, 1);
                                CSSBCreateTable.appendStringWithSpace(stringBuffer2, "ROWDEPENDENCIES");
                            }
                        }
                        this.appendToBuffer(stringBuffer, stringBuffer2, string);
                        CSSBCreateTable.appendNewLine(stringBuffer2, bl, 0);
                        this.appendLineFinisher(stringBuffer2, bl);
                        CSSBCreateTable.appendNewLine(stringBuffer2, bl, 0);
                        this.appendToBuffer(stringBuffer, stringBuffer2, string);
                        CDDLFileMaker.incrementCreateTable();
                        this.appendAfterCreateScript(stringBuffer, bl, table);
                    }
                    this.appendTableLevelCheckConstraints(stringBuffer, tableProxyOraclev9i, bl);
                    if (table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                        this.appendTableCommentOn(stringBuffer, table, tableProxyOraclev9i, bl);
                    }
                    if (tableProxyOraclev9i == null) break block24;
                    this.appendIndexes(stringBuffer, tableProxyOraclev9i, this.tableObj, bl);
                    iterator = DDLFileMaker.getddlAdvancedGenenerator();
                    try {
                        DDLFileMaker.setddlAdvancedGenenerator(CDDLFileMaker.getddlAdvancedGenenerator());
                        this.appendBitmapJoinIndexes(stringBuffer, tableProxyOraclev9i, bl);
                        this.appendAutoIncTriggers(stringBuffer, tableProxyOraclev9i, bl);
                        this.appendTriggers(stringBuffer, tableProxyOraclev9i, bl);
                    }
                    catch (Throwable throwable) {
                        DDLFileMaker.setddlAdvancedGenenerator((DDLAdvancedGenerator)((Object)iterator));
                        throw throwable;
                    }
                    DDLFileMaker.setddlAdvancedGenenerator(iterator);
                    this.appendPermissions(stringBuffer, tableProxyOraclev9i, bl);
                }
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 0);
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 0);
                if (table.isSpatialTable()) {
                    for (Object object2 : table.getSpatialDefinitions()) {
                        if (((SpatialColumnDefObject)object2).getSpatialColumn() == null && !((SpatialColumnDefObject)object2).isFunction()) continue;
                        this.appendRegisterSpatialTable(stringBuffer, table, (SpatialColumnDefObject)object2, bl);
                    }
                }
                break block25;
            }
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "-- table " + table.getName() + ": is a part of type substitution hierarchy");
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 0);
        }
    }

    private void appendColumnProperties(StringBuffer stringBuffer, Table table, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        Column[] columnArray = (Column[])table.getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            Column column = columnArray[i];
            if (!column.shouldBeMerge() && !this.isRenamed()) continue;
            ColumnProxyOraclev9i columnProxyOraclev9i = (ColumnProxyOraclev9i)tableProxyOraclev9i.getColumnProxy(column.getObjectID());
            Datatype datatype = columnProxyOraclev9i.getDataType();
            if (datatype.toString().equals("XMLTYPE")) {
                this.appendXMLTypeColumnProps(stringBuffer, columnProxyOraclev9i, bl);
                continue;
            }
            if (datatype instanceof CollectionType) {
                CollectionType collectionType = (CollectionType)datatype;
                if (collectionType.isArrayType()) {
                    this.appendVarrayColumnProp(stringBuffer, columnProxyOraclev9i, bl);
                    continue;
                }
                this.appendNestedTableColumnProp(stringBuffer, columnProxyOraclev9i, bl);
                continue;
            }
            if (!(datatype instanceof StructuredType)) continue;
            this.appendSubstitutableColumnClause(stringBuffer, columnProxyOraclev9i, bl, true);
        }
    }

    private void appendOid(StringBuffer stringBuffer, Table table, TableProxyOracle tableProxyOracle, boolean bl) {
        if (table.isRoot()) {
            if (table.isOidIsPK() && table.getOidPKColumns().size() > 0) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "OBJECT");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "IDENTIFIER");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "IS");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "PRIMARY KEY");
            }
            if (!(tableProxyOracle == null || tableProxyOracle.getOidIndexSegment() == null && "".equalsIgnoreCase(tableProxyOracle.getOidIndexName()))) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "OIDINDEX");
                if (!"".equalsIgnoreCase(tableProxyOracle.getOidIndexName())) {
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyOracle.getOidIndexName()));
                }
                if (tableProxyOracle.getOidIndexSegment() != null) {
                    CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                    this.appendSegment(stringBuffer, (SegmentOraclev9i)tableProxyOracle.getOidIndexSegment(), false, bl, null, "");
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
                }
            }
        }
    }

    private void appendElementList(StringBuffer stringBuffer, Table table, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        Column[] columnArray = (Column[])table.getElements();
        Column column = null;
        RelationalObjectProxy relationalObjectProxy = null;
        CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
        if (table.getBasedOnStructuredType() != null) {
            Object object;
            StructuredType structuredType = table.getBasedOnStructuredType();
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "OF");
            String string = structuredType.getName();
            if (tableProxyOraclev9i != null && (object = (StructuredTypeProxyOracle)tableProxyOraclev9i.getStorageDesign().getProxy(structuredType)) != null) {
                if (((StructuredTypeProxyOracle)object).getOwner() != null) {
                    CSSBCreateTable.appendString(stringBuffer, this.storageDesign.getFormatedName(((StructuredTypeProxyOracle)object).getOwner().getName()));
                    CSSBCreateTable.appendString(stringBuffer, '.');
                }
                string = ((RelationalObjectProxy)object).getName();
            }
            CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
            if (string.equalsIgnoreCase("XMLTYPE")) {
                this.appendObjectTypeColProperties(stringBuffer, table, tableProxyOraclev9i, bl);
                if (tableProxyOraclev9i != null) {
                    CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "XMLTYPE");
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "STORE AS");
                    if (tableProxyOraclev9i.getStoreAs().equalsIgnoreCase("OBJECT RELATIONAL")) {
                        CSSBCreateTable.appendStringWithSpace(stringBuffer, "OBJECT RELATIONAL");
                    } else {
                        CSSBCreateTable.appendStringWithSpace(stringBuffer, "CLOB");
                        object = tableProxyOraclev9i.getLobSegmentName();
                        if (object != null && ((String)object).length() > 0) {
                            CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName((String)object));
                        }
                        CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                        CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                        CSSBCreateTable.appendNewLine(stringBuffer, bl, 2);
                        if (tableProxyOraclev9i.getXmlTypeTableSpace() != null) {
                            CSSBCreateTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
                            CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyOraclev9i.getXmlTypeTableSpace().getName()));
                            CSSBCreateTable.appendNewLine(stringBuffer, bl, 2);
                        }
                        if (tableProxyOraclev9i.getChunk() > 0) {
                            CSSBCreateTable.appendStringWithSpace(stringBuffer, "CHUNK");
                            this.appendStringWithSpace(stringBuffer, tableProxyOraclev9i.getChunk());
                            CSSBCreateTable.appendNewLine(stringBuffer, bl, 2);
                        }
                        if (tableProxyOraclev9i.getOldVersions().equalsIgnoreCase("RETENTION")) {
                            CSSBCreateTable.appendStringWithSpace(stringBuffer, "RETENTION");
                        } else {
                            CSSBCreateTable.appendStringWithSpace(stringBuffer, "PCTVERSION");
                            this.appendStringWithSpace(stringBuffer, tableProxyOraclev9i.getPCTVersion());
                        }
                        if (tableProxyOraclev9i.getFreepools() > 0) {
                            CSSBCreateTable.appendNewLine(stringBuffer, bl, 2);
                            CSSBCreateTable.appendStringWithSpace(stringBuffer, "FREEPOOLS");
                            this.appendStringWithSpace(stringBuffer, tableProxyOraclev9i.getFreepools());
                        }
                        CSSBCreateTable.appendNewLine(stringBuffer, bl, 2);
                        if ("ENABLE".equalsIgnoreCase(tableProxyOraclev9i.getStorageInRow())) {
                            CSSBCreateTable.appendStringWithSpace(stringBuffer, "ENABLE");
                        } else {
                            CSSBCreateTable.appendStringWithSpace(stringBuffer, "DISABLE");
                        }
                        stringBuffer.append("STORAGE IN ROW");
                        CSSBCreateTable.appendNewLine(stringBuffer, bl, 2);
                        CSSBCreateTable.appendStringWithSpace(stringBuffer, tableProxyOraclev9i.getXmlTypeCache());
                        if (!"CACHE".equalsIgnoreCase(tableProxyOraclev9i.getXmlTypeCache())) {
                            if ("YES".equalsIgnoreCase(tableProxyOraclev9i.getXmlTypeLogging())) {
                                CSSBCreateTable.appendStringWithSpace(stringBuffer, "LOGGING");
                            } else if ("NO".equalsIgnoreCase(tableProxyOraclev9i.getXmlTypeLogging())) {
                                CSSBCreateTable.appendStringWithSpace(stringBuffer, "NOLOGGING");
                            }
                        }
                        CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                        CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
                    }
                    this.appendXMLSchemaSpec(stringBuffer, tableProxyOraclev9i.getXmlSchemaUrl(), tableProxyOraclev9i.getXmlSchemaElement(), bl);
                }
            } else {
                if (!table.isSubstitutable()) {
                    CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "NOT");
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "SUBSTITUTABLE");
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "AT");
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "ALL");
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "LEVELS");
                }
                this.appendObjectTypeColProperties(stringBuffer, table, tableProxyOraclev9i, bl);
            }
        } else if (columnArray.length < 1 || this.hasNoMergeColumns(table.getElements())) {
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "-- No Columns");
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
        } else {
            boolean bl2 = true;
            for (int i = 0; i < columnArray.length; ++i) {
                RelationalObjectProxy relationalObjectProxy2;
                column = columnArray[i];
                if (!column.shouldBeMerge() && !this.isRenamed() || column.isOid()) continue;
                if (bl2) {
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                    bl2 = false;
                } else {
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, ',');
                }
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                if (tableProxyOraclev9i != null) {
                    relationalObjectProxy = (ColumnProxyOraclev9i)tableProxyOraclev9i.getColumnProxy(column.getObjectID());
                }
                if (relationalObjectProxy.getName().length() > ((ColumnProxyOracle)relationalObjectProxy).getMaxNameLength()) {
                    CSSBCreateTable.appendNewLine(stringBuffer, bl, 0);
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "--  ERROR: Column name length exceeds maximum allowed length(" + ((ColumnProxyOracle)relationalObjectProxy).getMaxNameLength() + ")");
                    CSSBCreateTable.appendNewLine(stringBuffer, bl, 0);
                    CDDLFileMaker.incrementErrors();
                }
                if (relationalObjectProxy.isCommentChanged() && !"".equalsIgnoreCase(relationalObjectProxy.getComment())) {
                    this.appendComment(stringBuffer, relationalObjectProxy);
                } else if (!"".equalsIgnoreCase(relationalObjectProxy.getObject().getComment())) {
                    this.appendComment(stringBuffer, relationalObjectProxy.getObject());
                }
                CSSBCreateTable.appendString(stringBuffer, ' ');
                CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(relationalObjectProxy.getName()));
                String string = "";
                Datatype datatype = column.getDataType();
                if ((datatype instanceof StructuredType || datatype instanceof CollectionType) && (relationalObjectProxy2 = this.storageDesign.getProxy(datatype)) != null) {
                    string = this.storageDesign.getFormatedName(relationalObjectProxy2.getLongName());
                    if (column.isReference() && datatype instanceof StructuredType) {
                        string = "REF " + string;
                    }
                }
                if (string.equals("")) {
                    string = column.getDatatypeString("Oracle9i");
                }
                CSSBCreateTable.appendStringWithSpace(stringBuffer, string);
                if (string.equalsIgnoreCase("unknown")) {
                    CSSBCreateTable.appendNewLine(stringBuffer, bl, 0);
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "--  ERROR: Datatype UNKNOWN is not allowed");
                    CSSBCreateTable.appendNewLine(stringBuffer, bl, 5);
                    CDDLFileMaker.incrementErrors();
                }
                if (tableProxyOraclev9i == null) continue;
                this.appendColumnOptions(stringBuffer, column, (ColumnProxyOraclev9i)relationalObjectProxy, bl);
                this.appendInlineRefConstraint(stringBuffer, column, (ColumnProxyOraclev9i)relationalObjectProxy, bl);
                CSSBCreateTableOraclev10g.appendColumnConstraints(stringBuffer, column, (ColumnProxyOracle)relationalObjectProxy, bl);
            }
            if ("INDEX".equalsIgnoreCase(tableProxyOraclev9i.getOrganization())) {
                this.appendPKDefinitionConstraint(stringBuffer, tableProxyOraclev9i, bl);
            }
            this.appendTableConstraintsDefinition(stringBuffer, tableProxyOraclev9i, bl, false);
            this.appendSupplementalLoggings(stringBuffer, tableProxyOraclev9i, bl);
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private boolean hasNoMergeColumns(ContainedObject[] containedObjectArray) {
        if (this.isRenamed()) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < containedObjectArray.length; ++i) {
            Column column = (Column)containedObjectArray[i];
            if (column.shouldBeMerge()) continue;
            ++n;
        }
        return containedObjectArray.length == n;
    }

    private PKProxyOraclev9i getPKProxy(TableProxyOraclev9i tableProxyOraclev9i) {
        PKProxySetOraclev9i pKProxySetOraclev9i = (PKProxySetOraclev9i)((StorageDesignOraclev9i)tableProxyOraclev9i.getStorageDesign()).getPKProxySet();
        if (pKProxySetOraclev9i != null) {
            Iterator iterator = pKProxySetOraclev9i.iterator();
            while (iterator.hasNext()) {
                PKProxyOraclev9i pKProxyOraclev9i = (PKProxyOraclev9i)iterator.next();
                if (!pKProxyOraclev9i.getTable().equals(tableProxyOraclev9i.getObject())) continue;
                return pKProxyOraclev9i;
            }
        }
        return null;
    }

    private void appendPKDefinitionConstraint(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        if (tableProxyOraclev9i != null) {
            this.pk = this.getPKProxy(tableProxyOraclev9i);
            if (this.pk != null) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, ',');
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateTable.appendString(stringBuffer, ' ');
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "CONSTRAINT");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(this.pk.getName()));
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "PRIMARY KEY");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                StringBuffer stringBuffer2 = this.getColumnsForRestore(this.tableObj, (Index)this.pk.getObject(), bl, false);
                this.appendStringWithSpace(stringBuffer, stringBuffer2);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
                if (!"YES".equalsIgnoreCase(this.pk.getEnable())) {
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "DISABLE");
                }
                if (!"YES".equalsIgnoreCase(this.pk.getValidate())) {
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "NOVALIDATE");
                }
                if (!"NO".equalsIgnoreCase(this.pk.getUsingIndex())) {
                    this.appendUsingIndex(stringBuffer, this.pk, bl);
                }
            }
        }
    }

    private void appendSupplementalLoggings(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        if (tableProxyOraclev9i != null && !"".equalsIgnoreCase(tableProxyOraclev9i.getSuplementalLogGroupName())) {
            this.appendComma(stringBuffer);
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "SUPPLEMENTAL");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "LOG");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "GROUP");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyOraclev9i.getSuplementalLogGroupName()));
            CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
            CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(tableProxyOraclev9i.getAllSuplementalLogColumns()));
            CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
            if (tableProxyOraclev9i.getSuplementalLogConditions().equalsIgnoreCase("ALWAYS")) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "ALWAYS");
            }
        }
    }

    private void appendUsingIndex(StringBuffer stringBuffer, PKProxyOraclev9i pKProxyOraclev9i, boolean bl) {
        CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
        CSSBCreateTable.appendStringWithSpace(stringBuffer, "USING INDEX");
        if ("BY INDEX NAME".equalsIgnoreCase(pKProxyOraclev9i.getUsingIndex()) && pKProxyOraclev9i.getExistingIndex() != null) {
            CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(pKProxyOraclev9i.getExistingIndex().getUserNameAndName()));
        } else {
            if ("LOCAL PARTITIONED".equalsIgnoreCase(pKProxyOraclev9i.getUsingIndex())) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "LOCAL");
            } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(pKProxyOraclev9i.getUsingIndex())) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateTable.appendStringWithSpace(stringBuffer, pKProxyOraclev9i.getCreateIndexStatement());
                CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
            } else if ("GLOBAL PARTITIONED".equalsIgnoreCase(pKProxyOraclev9i.getUsingIndex())) {
                this.appendGlobalIndex(stringBuffer, pKProxyOraclev9i, bl);
            }
            if (pKProxyOraclev9i.getIndexSegment() != null) {
                this.appendSegment(stringBuffer, (SegmentOraclev9i)pKProxyOraclev9i.getIndexSegment(), false, bl, pKProxyOraclev9i.getTableSpace(), pKProxyOraclev9i.getLogging());
            } else {
                if (pKProxyOraclev9i.getTableSpace() != null) {
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(pKProxyOraclev9i.getTableSpace().getName()));
                    CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                }
                if (this.storageDesign.isOpen()) {
                    if ("YES".equalsIgnoreCase(pKProxyOraclev9i.getLogging())) {
                        CSSBCreateTable.appendStringWithSpace(stringBuffer, "LOGGING");
                        CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                    } else if ("NO".equalsIgnoreCase(pKProxyOraclev9i.getLogging())) {
                        CSSBCreateTable.appendStringWithSpace(stringBuffer, "NOLOGGING");
                        CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                    }
                }
            }
            if (pKProxyOraclev9i.getIndexSort().equalsIgnoreCase("NO")) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "NOSORT");
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            } else if (pKProxyOraclev9i.getIndexSort().equalsIgnoreCase("REVERSE")) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "REVERSE");
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            }
            if (pKProxyOraclev9i.getComputeStatistics().equalsIgnoreCase("YES")) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "COMPUTE STATISTICS");
            }
        }
    }

    private void appendUniqueUsingIndex(StringBuffer stringBuffer, UniqueOraclev9i uniqueOraclev9i, boolean bl) {
        CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
        CSSBCreateTable.appendStringWithSpace(stringBuffer, "USING INDEX");
        if ("BY INDEX NAME".equalsIgnoreCase(uniqueOraclev9i.getUsingIndex()) && uniqueOraclev9i.getExistingIndex() != null) {
            CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(uniqueOraclev9i.getExistingIndex().getUserNameAndName()));
        } else {
            if ("LOCAL PARTITIONED".equalsIgnoreCase(uniqueOraclev9i.getUsingIndex())) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "LOCAL");
            } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(uniqueOraclev9i.getUsingIndex())) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateTable.appendStringWithSpace(stringBuffer, uniqueOraclev9i.getCreateIndexStatement());
                CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
            } else if (uniqueOraclev9i.getUsingIndex().equalsIgnoreCase("GLOBAL PARTITIONED")) {
                this.appendUniqueGlobalIndex(stringBuffer, uniqueOraclev9i, bl);
            }
            if (uniqueOraclev9i.getIndexSegment() != null) {
                this.appendSegment(stringBuffer, (SegmentOraclev9i)uniqueOraclev9i.getIndexSegment(), false, bl, uniqueOraclev9i.getTableSpace(), uniqueOraclev9i.getLogging());
            } else {
                if (uniqueOraclev9i.getTableSpace() != null) {
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(uniqueOraclev9i.getTableSpace().getName()));
                    CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                }
                if ("YES".equalsIgnoreCase(uniqueOraclev9i.getLogging())) {
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "LOGGING");
                    CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                } else if ("NO".equalsIgnoreCase(uniqueOraclev9i.getLogging())) {
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "NOLOGGING");
                    CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                }
            }
            if (uniqueOraclev9i.getIndexSort().equalsIgnoreCase("NO")) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "NOSORT");
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            } else if (uniqueOraclev9i.getIndexSort().equalsIgnoreCase("REVERSE")) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "REVERSE");
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            }
            if (uniqueOraclev9i.getComputeStatistics().equalsIgnoreCase("YES")) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "COMPUTE STATISTICS");
            }
        }
    }

    private void appendUniqueGlobalIndex(StringBuffer stringBuffer, UniqueOraclev9i uniqueOraclev9i, boolean bl) {
        if (uniqueOraclev9i.getUsingIndexGlobalPL() != null) {
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "GLOBAL");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "PARTITION");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "BY");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "RANGE");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
            CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(uniqueOraclev9i.getUsingIndexGlobalPL().getAllGlobalPartColumns()));
            CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
            this.appendGlobalPartitions(stringBuffer, (IndexGlobalPartitionsListOraclev9i)uniqueOraclev9i.getUsingIndexGlobalPL(), bl);
        }
    }

    private void appendGlobalIndex(StringBuffer stringBuffer, PKProxyOraclev9i pKProxyOraclev9i, boolean bl) {
        if (pKProxyOraclev9i.getIndexGlobalPL() != null) {
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "GLOBAL");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "PARTITION");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "BY");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "RANGE");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
            CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(pKProxyOraclev9i.getIndexGlobalPL().getAllGlobalPartColumns()));
            CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
            this.appendGlobalPartitions(stringBuffer, (IndexGlobalPartitionsListOraclev9i)pKProxyOraclev9i.getIndexGlobalPL(), bl);
        }
    }

    private void appendGlobalPartitions(StringBuffer stringBuffer, IndexGlobalPartitionsListOraclev9i indexGlobalPartitionsListOraclev9i, boolean bl) {
        IndexGlobalPartitionSetOraclev9i indexGlobalPartitionSetOraclev9i = (IndexGlobalPartitionSetOraclev9i)((StorageDesignOraclev9i)indexGlobalPartitionsListOraclev9i.getStorageDesign()).getIndexGlobalPartitionSet();
        Object[] objectArray = indexGlobalPartitionSetOraclev9i.toArray();
        Arrays.sort(objectArray, new GlobalPossitionComparator());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        Iterator iterator = arrayList.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            IndexGlobalPartitionOraclev9i indexGlobalPartitionOraclev9i = (IndexGlobalPartitionOraclev9i)iterator.next();
            if (indexGlobalPartitionOraclev9i.getIndexGlobalPartList() == null || !indexGlobalPartitionOraclev9i.getIndexGlobalPartList().toString().equalsIgnoreCase(indexGlobalPartitionsListOraclev9i.toString())) continue;
            if (bl2) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                bl2 = false;
            } else {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, ',');
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            }
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "PARTITION");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexGlobalPartitionOraclev9i.getName()));
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "VALUES LESS THAN");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
            CSSBCreateTable.appendStringWithSpace(stringBuffer, indexGlobalPartitionOraclev9i.getValueList());
            CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
            if (indexGlobalPartitionOraclev9i.getSegment() != null) {
                this.appendSegment(stringBuffer, (SegmentOraclev9i)indexGlobalPartitionOraclev9i.getSegment(), false, bl, indexGlobalPartitionOraclev9i.getTableSpace(), indexGlobalPartitionOraclev9i.getLogging());
                continue;
            }
            if (indexGlobalPartitionOraclev9i.getTableSpace() != null) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexGlobalPartitionOraclev9i.getTableSpace().getName()));
            }
            if (!this.storageDesign.isOpen()) continue;
            if ("YES".equalsIgnoreCase(indexGlobalPartitionOraclev9i.getLogging())) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 2);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "LOGGING");
                continue;
            }
            if (!"NO".equalsIgnoreCase(indexGlobalPartitionOraclev9i.getLogging())) continue;
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 2);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "NOLOGGING");
        }
        if (!bl2) {
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected void appendTableCommentOn(StringBuffer stringBuffer, Table table, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        block4: {
            StringBuffer stringBuffer2;
            block3: {
                stringBuffer2 = new StringBuffer();
                if (tableProxyOraclev9i == null) break block3;
                this.appendCommentOn(stringBuffer2, tableProxyOraclev9i, bl);
                this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
                ColumnProxy[] columnProxyArray = tableProxyOraclev9i.getColumnProxies();
                ColumnProxy columnProxy = null;
                String string = this.storageDesign.getFormatedName(tableProxyOraclev9i.getLongName());
                for (int i = 0; i < columnProxyArray.length; ++i) {
                    columnProxy = columnProxyArray[i];
                    String string2 = "";
                    string2 = columnProxy.getCommentInRDBMS() != null && columnProxy.isCommentInRDBMSChanged() ? columnProxy.getCommentInRDBMS() : columnProxy.getColumn().getCommentInRDBMS();
                    if (string2.equals("") || !columnProxy.getColumn().shouldBeMerge() && !this.isRenamed()) continue;
                    CSSBCreateTable.appendNewLine(stringBuffer2, bl, 0);
                    CSSBCreateTable.appendStringWithSpace(stringBuffer2, "COMMENT ON");
                    CSSBCreateTable.appendStringWithSpace(stringBuffer2, "COLUMN");
                    String string3 = string + '.' + this.storageDesign.getFormatedName(columnProxy.getName());
                    CSSBCreateTable.appendStringWithSpace(stringBuffer2, string3);
                    CSSBCreateTable.appendStringWithSpace(stringBuffer2, "IS");
                    CSSBCreateTable.appendString(stringBuffer2, '\'');
                    CSSBCreateTable.appendString(stringBuffer2, this.replaceSingleQuote(string2));
                    CSSBCreateTable.appendStringWithSpace(stringBuffer2, '\'');
                    this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
                    CSSBCreateTable.appendNewLine(stringBuffer2, bl, 0);
                    this.appendLineFinisher(stringBuffer2, bl);
                    this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
                }
                break block4;
            }
            if (table == null) break block4;
            if (table.getCommentInRDBMS() != null && !"".equals(table.getCommentInRDBMS())) {
                CSSBCreateTable.appendNewLine(stringBuffer2, bl, 0);
                CSSBCreateTable.appendStringWithSpace(stringBuffer2, "COMMENT ON");
                CSSBCreateTable.appendStringWithSpace(stringBuffer2, "TABLE");
                CSSBCreateTable.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(table.getLongName()));
                CSSBCreateTable.appendStringWithSpace(stringBuffer2, "IS");
                CSSBCreateTable.appendString(stringBuffer2, '\'');
                CSSBCreateTable.appendString(stringBuffer2, this.replaceSingleQuote(table.getCommentInRDBMS()));
                CSSBCreateTable.appendStringWithSpace(stringBuffer2, '\'');
                this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
                CSSBCreateTable.appendNewLine(stringBuffer2, bl, 0);
                this.appendLineFinisher(stringBuffer2, bl);
                this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
            }
            ContainedObject[] containedObjectArray = table.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                Column column = (Column)containedObjectArray[i];
                if (column.getCommentInRDBMS() == null || "".equals(column.getCommentInRDBMS()) || !column.shouldBeMerge() && !this.isRenamed()) continue;
                CSSBCreateTable.appendNewLine(stringBuffer2, bl, 0);
                CSSBCreateTable.appendStringWithSpace(stringBuffer2, "COMMENT ON");
                CSSBCreateTable.appendStringWithSpace(stringBuffer2, "COLUMN");
                CSSBCreateTable.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(column.getLongName()));
                CSSBCreateTable.appendStringWithSpace(stringBuffer2, "IS");
                CSSBCreateTable.appendString(stringBuffer2, '\'');
                CSSBCreateTable.appendString(stringBuffer2, this.replaceSingleQuote(column.getCommentInRDBMS()));
                CSSBCreateTable.appendStringWithSpace(stringBuffer2, '\'');
                this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
                CSSBCreateTable.appendNewLine(stringBuffer2, bl, 0);
                this.appendLineFinisher(stringBuffer2, bl);
                this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
            }
        }
    }

    protected void appendPartitionList(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        PartitionListOraclev9i partitionListOraclev9i = (PartitionListOraclev9i)tableProxyOraclev9i.getPartitionList();
        if (partitionListOraclev9i != null) {
            if (this.storageDesign == null) {
                this.storageDesign = (StorageDesignOracle)tableProxyOraclev9i.getStorageDesign();
            }
            String string = partitionListOraclev9i.getPartitionType();
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            if ("RANGE".equalsIgnoreCase(string)) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "PARTITION");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "BY");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "RANGE");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getColumnList()));
                CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
                this.appendPartitions(stringBuffer, partitionListOraclev9i, false, bl);
            } else if ("COMPOSITE BY HASH".equalsIgnoreCase(string)) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "PARTITION");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "BY");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "RANGE");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getColumnList()));
                CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "BY");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "HASH");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getSubPartitionsColumnList()));
                CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
                if ("NO".equals(partitionListOraclev9i.getUseSubpartStorageTemplate())) {
                    if (partitionListOraclev9i.getSubPartitionsQuantity() > 1 || !"".equals(partitionListOraclev9i.getSubPartitionsTableSpaces())) {
                        CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                        CSSBCreateTable.appendStringWithSpace(stringBuffer, "SUBPARTITIONS");
                        this.appendStringWithSpace(stringBuffer, partitionListOraclev9i.getSubPartitionsQuantity());
                        if (!"".equals(partitionListOraclev9i.getSubPartitionsTableSpaces())) {
                            CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                            CSSBCreateTable.appendStringWithSpace(stringBuffer, "STORE IN");
                            CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                            CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getAllSubPartitionsTableSpaces()));
                            CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
                        }
                    }
                } else {
                    this.appendHashSubPartitionTemplates(stringBuffer, tableProxyOraclev9i, bl);
                }
                this.appendPartitions(stringBuffer, partitionListOraclev9i, true, bl);
            } else if ("COMPOSITE BY LIST".equalsIgnoreCase(string)) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "PARTITION");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "BY");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "RANGE");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getColumnList()));
                CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "BY");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "LIST");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getSubPartitionsColumnList()));
                CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
                this.appendListSubPartitionTemplates(stringBuffer, tableProxyOraclev9i, bl);
                this.appendPartitions(stringBuffer, partitionListOraclev9i, true, bl);
            } else if ("HASH BY QUANTITY".equalsIgnoreCase(string)) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "PARTITION");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "BY");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "HASH");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getColumnList()));
                CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "PARTITIONS");
                this.appendStringWithSpace(stringBuffer, partitionListOraclev9i.getHashPQuantity());
                if (!"".equals(partitionListOraclev9i.getHashPTableSpaces())) {
                    CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "STORE IN");
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getAllHashPTableSpaces()));
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
                }
                if (!"".equals(partitionListOraclev9i.getIOTOverflowHashPTS())) {
                    CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "OVERFLOW");
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "STORE IN");
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getAllIOTOverflowHashPTS()));
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
                }
            } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(string)) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "PARTITION");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "BY");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "HASH");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getColumnList()));
                CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
                this.appendHashPartitions(stringBuffer, tableProxyOraclev9i, bl);
            } else if ("LIST".equalsIgnoreCase(string)) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "PARTITION");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "BY");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "LIST");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getColumnList()));
                CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
                this.appendListPartitions(stringBuffer, tableProxyOraclev9i, bl);
            }
        }
    }

    private void appendListSubPartitionTemplates(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        StorageObjectCollection storageObjectCollection = tableProxyOraclev9i.getListStorageTemplates();
        if (storageObjectCollection.size() > 0) {
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "SUBPARTITION");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "TEMPLATE");
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
            for (int i = 0; i < storageObjectCollection.size(); ++i) {
                ListStorageTemplatePartitionOraclev9i listStorageTemplatePartitionOraclev9i = (ListStorageTemplatePartitionOraclev9i)storageObjectCollection.getElement(i);
                if (i > 0) {
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, ',');
                }
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 2);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listStorageTemplatePartitionOraclev9i.getName()));
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "VALUES");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                if (!"".equalsIgnoreCase(listStorageTemplatePartitionOraclev9i.getValueList())) {
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, listStorageTemplatePartitionOraclev9i.getValueList());
                } else {
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "DEFAULT");
                }
                CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
                this.appendPartStorage(stringBuffer, listStorageTemplatePartitionOraclev9i, bl);
            }
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendHashSubPartitionTemplates(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        if (tableProxyOraclev9i.getListStorageTemplates().size() > 0) {
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "SUBPARTITION");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "TEMPLATE");
            Iterator iterator = tableProxyOraclev9i.getListStorageTemplates().iterator();
            boolean bl2 = true;
            while (iterator.hasNext()) {
                HashPartitionOraclev9i hashPartitionOraclev9i = (HashPartitionOraclev9i)iterator.next();
                if (bl2) {
                    CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                    bl2 = false;
                } else {
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, ',');
                }
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOraclev9i.getName()));
                this.appendPartStorage(stringBuffer, hashPartitionOraclev9i, bl);
            }
            if (!bl2) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private void appendPartStorage(StringBuffer stringBuffer, AbstractStorageObjectOracle abstractStorageObjectOracle, boolean bl) {
        TableSpaceOracle tableSpaceOracle = null;
        TableSpaceOracle tableSpaceOracle2 = null;
        StorageObjectCollection storageObjectCollection = null;
        if (abstractStorageObjectOracle instanceof HashPartitionOraclev9i) {
            tableSpaceOracle = ((HashPartitionOraclev9i)abstractStorageObjectOracle).getTableSpace();
            tableSpaceOracle2 = ((HashPartitionOraclev9i)abstractStorageObjectOracle).getIotOverflowTablespace();
            storageObjectCollection = ((HashPartitionOraclev9i)abstractStorageObjectOracle).getLobs();
        } else if (abstractStorageObjectOracle instanceof ListStorageTemplatePartitionOraclev9i) {
            tableSpaceOracle = ((ListStorageTemplatePartitionOraclev9i)abstractStorageObjectOracle).getTablespace();
            storageObjectCollection = ((ListStorageTemplatePartitionOraclev9i)abstractStorageObjectOracle).getLobs();
        }
        if (tableSpaceOracle != null) {
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 2);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
        }
        if (tableSpaceOracle2 != null) {
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 2);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "OVERFLOW");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle2.getName()));
        }
        if (storageObjectCollection != null) {
            Iterator iterator = storageObjectCollection.iterator();
            while (iterator.hasNext()) {
                AbstractStorageObjectOracle abstractStorageObjectOracle2;
                Object e = iterator.next();
                if (e instanceof LobStorageOraclev9i) {
                    abstractStorageObjectOracle2 = (LobStorageOraclev9i)e;
                    if (((LobStorageOracle)abstractStorageObjectOracle2).getTableSpace() == null && ((LobStorageOracle)abstractStorageObjectOracle2).getLobSegmentName().trim().equals("")) continue;
                    CSSBCreateTable.appendNewLine(stringBuffer, bl, 2);
                    this.appendLobPartitioningStorage(stringBuffer, abstractStorageObjectOracle2.getName(), ((LobStorageOracle)abstractStorageObjectOracle2).getColumn(), ((LobStorageOracle)abstractStorageObjectOracle2).getLobSegmentName(), ((LobStorageOracle)abstractStorageObjectOracle2).getTableSpace(), bl);
                    continue;
                }
                if (!(e instanceof HashPartitionLobItemOraclev9i) || ((HashPartitionLobItemOracle)(abstractStorageObjectOracle2 = (HashPartitionLobItemOraclev9i)e)).getTableSpace() == null) continue;
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 2);
                this.appendLobPartitioningStorage(stringBuffer, abstractStorageObjectOracle2.getName(), ((HashPartitionLobItemOracle)abstractStorageObjectOracle2).getLobColumn(), "", ((HashPartitionLobItemOracle)abstractStorageObjectOracle2).getTableSpace(), bl);
            }
        }
    }

    private void appendListPartitions(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        Iterator iterator = tableProxyOraclev9i.getPartitions().iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            Table table;
            ListPartitionOraclev9i listPartitionOraclev9i = (ListPartitionOraclev9i)iterator.next();
            if (bl2) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                bl2 = false;
            } else {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, ',');
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            }
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "PARTITION");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listPartitionOraclev9i.getName()));
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "VALUES");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
            if (!"".equalsIgnoreCase(listPartitionOraclev9i.getColumns())) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, listPartitionOraclev9i.getColumns());
            } else {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "DEFAULT");
            }
            CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
            if (listPartitionOraclev9i.getSegment() != null) {
                this.appendSegment(stringBuffer, (SegmentOraclev9i)listPartitionOraclev9i.getSegment(), true, bl, listPartitionOraclev9i.getTablespace(), listPartitionOraclev9i.getLogging());
            }
            if (listPartitionOraclev9i.getDataSegmentCompression().equalsIgnoreCase("NO")) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "NOCOMPRESS");
            } else if (listPartitionOraclev9i.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "COMPRESS");
            }
            if (listPartitionOraclev9i.getSegment() == null) {
                if (listPartitionOraclev9i.getTablespace() != null) {
                    CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listPartitionOraclev9i.getTablespace().getName()));
                }
                if (this.storageDesign.isOpen()) {
                    if (listPartitionOraclev9i.getLogging().equalsIgnoreCase("YES")) {
                        CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                        CSSBCreateTable.appendStringWithSpace(stringBuffer, "LOGGING");
                    } else if (listPartitionOraclev9i.getLogging().equalsIgnoreCase("NO")) {
                        CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                        CSSBCreateTable.appendStringWithSpace(stringBuffer, "NOLOGGING");
                    }
                }
            }
            if ((table = (Table)this.tableObj.getObject()).isSpatialTable()) continue;
            Iterator iterator2 = listPartitionOraclev9i.getLobStorages().iterator();
            while (iterator2.hasNext()) {
                LobStorageOracle lobStorageOracle = (LobStorageOracle)iterator2.next();
                this.appendLobStorage(stringBuffer, (LobStorageOraclev9i)lobStorageOracle, bl);
            }
        }
        if (!bl2) {
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendPartitions(StringBuffer stringBuffer, PartitionListOraclev9i partitionListOraclev9i, boolean bl, boolean bl2) {
        PartitionSetOracle partitionSetOracle = ((StorageDesignOraclev9i)partitionListOraclev9i.getStorageDesign()).getPartitionSet();
        Object[] objectArray = partitionSetOracle.toArray();
        Arrays.sort(objectArray, new PossitionComparator());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        Iterator iterator = arrayList.iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            Object object;
            PartitionOracle partitionOracle = (PartitionOracle)iterator.next();
            if (partitionOracle.getPartitionList() == null || partitionOracle.getPartitionList() != partitionListOraclev9i) continue;
            if (bl3) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl2, 1);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateTable.appendNewLine(stringBuffer, bl2, 1);
                bl3 = false;
            } else {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, ',');
                CSSBCreateTable.appendNewLine(stringBuffer, bl2, 1);
            }
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "PARTITION");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(partitionOracle.getName()));
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "VALUES LESS THAN");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
            CSSBCreateTable.appendStringWithSpace(stringBuffer, partitionOracle.getValueList());
            CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
            if (partitionOracle.getSegment() != null) {
                this.appendSegment(stringBuffer, (SegmentOraclev9i)partitionOracle.getSegment(), true, bl2, partitionOracle.getTableSpace(), partitionOracle.getLogging());
            } else if (partitionOracle.getIOTOverflowSegment() != null) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "OVERFLOW");
                this.appendSegment(stringBuffer, (SegmentOraclev9i)partitionOracle.getIOTOverflowSegment(), true, bl2, partitionOracle.getTableSpace(), partitionOracle.getLogging());
            } else {
                if (partitionOracle.getTableSpace() != null) {
                    CSSBCreateTable.appendNewLine(stringBuffer, bl2, 2);
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(partitionOracle.getTableSpace().getName()));
                }
                if (partitionOracle.getLogging().equalsIgnoreCase("NO")) {
                    CSSBCreateTable.appendNewLine(stringBuffer, bl2, 2);
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "NOLOGGING");
                } else if (partitionOracle.getLogging().equalsIgnoreCase("YES")) {
                    CSSBCreateTable.appendNewLine(stringBuffer, bl2, 2);
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "LOGGING");
                }
            }
            Table table = (Table)this.tableObj.getObject();
            if (!table.isSpatialTable()) {
                Iterator iterator2 = partitionOracle.getLobs().iterator();
                while (iterator2.hasNext()) {
                    object = (LobStorageOracle)iterator2.next();
                    this.appendLobStorage(stringBuffer, (LobStorageOraclev9i)object, bl2);
                }
            }
            if (!bl || this.appendHashSubPartitions(stringBuffer, (PartitionOraclev9i)partitionOracle, partitionListOraclev9i, bl2)) continue;
            if (partitionOracle.getSubPartitionsQuantity() > 0) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl2, 1);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "SUBPARTITIONS");
                this.appendStringWithSpace(stringBuffer, partitionOracle.getSubPartitionsQuantity());
                if ("".equalsIgnoreCase(partitionOracle.getSubPartitionsTableSpaces())) continue;
                CSSBCreateTable.appendNewLine(stringBuffer, bl2, 1);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "STORE IN");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionOracle.getAllSubPartitionsTableSpaces()));
                CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
                continue;
            }
            if (partitionOracle.getListPartitions().size() <= 0) continue;
            boolean bl4 = true;
            object = partitionOracle.getListPartitions().iterator();
            CSSBCreateTable.appendNewLine(stringBuffer, bl2, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
            while (object.hasNext()) {
                ListStorageTemplatePartitionOraclev9i listStorageTemplatePartitionOraclev9i = (ListStorageTemplatePartitionOraclev9i)object.next();
                if (!bl4) {
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, ',');
                } else {
                    bl4 = false;
                }
                CSSBCreateTable.appendNewLine(stringBuffer, bl2, 2);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listStorageTemplatePartitionOraclev9i.getName()));
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "VALUES");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateTable.appendStringWithSpace(stringBuffer, listStorageTemplatePartitionOraclev9i.getValueList());
                CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
                this.appendPartStorage(stringBuffer, listStorageTemplatePartitionOraclev9i, bl2);
            }
            CSSBCreateTable.appendNewLine(stringBuffer, bl2, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
        }
        if (!bl3) {
            CSSBCreateTable.appendNewLine(stringBuffer, bl2, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private boolean appendHashSubPartitions(StringBuffer stringBuffer, PartitionOraclev9i partitionOraclev9i, PartitionListOraclev9i partitionListOraclev9i, boolean bl) {
        boolean bl2 = false;
        if (partitionListOraclev9i.getUseSubpartStorageTemplate().equalsIgnoreCase("NO")) {
            HashPartitionSetOracle hashPartitionSetOracle = ((StorageDesignOracle)partitionOraclev9i.getStorageDesign()).getHashPartitionSet();
            Iterator iterator = hashPartitionSetOracle.iterator();
            boolean bl3 = true;
            while (iterator.hasNext()) {
                HashPartitionOraclev9i hashPartitionOraclev9i = (HashPartitionOraclev9i)iterator.next();
                if (hashPartitionOraclev9i.getSubPartitionOf() != partitionOraclev9i) continue;
                if (bl3) {
                    CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                    bl3 = false;
                    bl2 = true;
                } else {
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, ',');
                    CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                }
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOraclev9i.getName()));
                this.appendPartStorage(stringBuffer, hashPartitionOraclev9i, bl);
            }
            if (!bl3) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
            }
        }
        return bl2;
    }

    private boolean appendHashPartitions(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        boolean bl2 = false;
        Iterator iterator = tableProxyOraclev9i.getPartitions().iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            HashPartitionOraclev9i hashPartitionOraclev9i = (HashPartitionOraclev9i)iterator.next();
            if (bl3) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                bl3 = false;
                bl2 = true;
            } else {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, ',');
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            }
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "PARTITION");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOraclev9i.getName()));
            if (hashPartitionOraclev9i.getTableSpace() != null) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOraclev9i.getTableSpace().getName()));
            }
            this.appendHashPLobItems(stringBuffer, hashPartitionOraclev9i, bl);
        }
        if (!bl3) {
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
        }
        return bl2;
    }

    private void appendHashPLobItems(StringBuffer stringBuffer, HashPartitionOraclev9i hashPartitionOraclev9i, boolean bl) {
        HashPartitionLobItemSetOraclev9i hashPartitionLobItemSetOraclev9i = (HashPartitionLobItemSetOraclev9i)((StorageDesignOraclev9i)hashPartitionOraclev9i.getStorageDesign()).getHashPartitionLobItemSet();
        Iterator iterator = hashPartitionLobItemSetOraclev9i.iterator();
        while (iterator.hasNext()) {
            HashPartitionLobItemOraclev9i hashPartitionLobItemOraclev9i = (HashPartitionLobItemOraclev9i)iterator.next();
            if (hashPartitionLobItemOraclev9i.getHashPartition() == null || !hashPartitionLobItemOraclev9i.getHashPartition().toString().equalsIgnoreCase(hashPartitionOraclev9i.toString())) continue;
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 2);
            this.appendLobPartitioningStorage(stringBuffer, hashPartitionLobItemOraclev9i.getName(), hashPartitionLobItemOraclev9i.getLobColumn(), "", hashPartitionLobItemOraclev9i.getTableSpace(), bl);
        }
    }

    private void appendLobPartitioningStorage(StringBuffer stringBuffer, String string, Object object, String string2, TableSpaceOracle tableSpaceOracle, boolean bl) {
        CSSBCreateTable.appendStringWithSpace(stringBuffer, "LOB");
        CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
        String string3 = "";
        if (object != null) {
            string3 = object.toString();
        }
        if (string3.length() > 0) {
            CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string3));
        } else {
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 0);
            stringBuffer.append("--  ERROR: Lob ");
            stringBuffer.append(string);
            stringBuffer.append(" has no Column specified");
            CDDLFileMaker.incrementErrors();
        }
        CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
        CSSBCreateTable.appendStringWithSpace(stringBuffer, "STORE AS");
        if (!string2.equalsIgnoreCase("")) {
            CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string2));
        } else if (tableSpaceOracle == null) {
            CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
        }
        if (tableSpaceOracle != null) {
            CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
            CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendLobStorage(StringBuffer stringBuffer, LobStorageOraclev9i lobStorageOraclev9i, boolean bl) {
        if (lobStorageOraclev9i != null) {
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "LOB");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
            CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(lobStorageOraclev9i.getColumn()));
            CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "STORE AS");
            if (!lobStorageOraclev9i.getLobSegmentName().equalsIgnoreCase("")) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(lobStorageOraclev9i.getLobSegmentName()));
            }
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 2);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 2);
            if (lobStorageOraclev9i.getTableSpace() != null) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(lobStorageOraclev9i.getTableSpace().getName()));
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 2);
            }
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "STORAGE");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 3);
            if (lobStorageOraclev9i.getSCInitialExtent() > 0L) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getSCInitialExtent());
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 3);
            }
            if (lobStorageOraclev9i.getSCNextExtent() > 0L) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getSCNextExtent());
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 3);
            }
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getSCPctIncrease());
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 3);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "MINEXTENTS");
            this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getSCMinExtents());
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 3);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getSCMaxExtents());
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 3);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "FREELISTS");
            this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getSCFreeLists());
            if (lobStorageOraclev9i.getSCFreelistGroups() > 1) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 3);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "FREELIST");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "GROUPS");
                this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getSCFreelistGroups());
            }
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 3);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "BUFFER_POOL");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getSCBufferPool());
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 2);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 2);
            if (lobStorageOraclev9i.getChunk() > 0) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "CHUNK");
                this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getChunk());
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 2);
            }
            if (lobStorageOraclev9i.getOldVersions().equalsIgnoreCase("RETENTION")) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "RETENTION");
            } else {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "PCTVERSION");
                this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getPCTVersion());
            }
            if (lobStorageOraclev9i.getSCFreelistGroups() <= 1 && lobStorageOraclev9i.getFreepools() > 0) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 2);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "FREEPOOLS");
                this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getFreepools());
            }
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 2);
            if ("ENABLE".equalsIgnoreCase(lobStorageOraclev9i.getStorageInRow())) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "ENABLE");
            } else {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "DISABLE");
            }
            stringBuffer.append("STORAGE IN ROW");
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 2);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getCache());
            if (!"CACHE".equalsIgnoreCase(lobStorageOraclev9i.getCache())) {
                if ("YES".equalsIgnoreCase(lobStorageOraclev9i.getLogging())) {
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(lobStorageOraclev9i.getLogging())) {
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "NOLOGGING");
                }
            }
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendSegment(StringBuffer stringBuffer, SegmentOraclev9i segmentOraclev9i, boolean bl, boolean bl2, TableSpaceOracle tableSpaceOracle, String string) {
        if (segmentOraclev9i != null) {
            CSSBCreateTable.appendNewLine(stringBuffer, bl2, 2);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "PCTFREE");
            this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getPCTFree());
            if (bl) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl2, 2);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "PCTUSED");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getPCTUsed());
            }
            if (segmentOraclev9i.getInitrans() > 1) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl2, 2);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "INITRANS");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getInitrans());
            }
            if (segmentOraclev9i.getMaxTrans() > 1) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl2, 2);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "MAXTRANS");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getMaxTrans());
            }
            if (tableSpaceOracle != null) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl2, 2);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
            } else if (segmentOraclev9i.getTableSpace() != null) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl2, 2);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(segmentOraclev9i.getTableSpace().getName()));
            }
            if (!"".equals(string)) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl2, 2);
                if (string.equalsIgnoreCase("NO")) {
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "NOLOGGING");
                } else {
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "LOGGING");
                }
            }
            CSSBCreateTable.appendNewLine(stringBuffer, bl2, 2);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "STORAGE");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
            CSSBCreateTable.appendNewLine(stringBuffer, bl2, 2);
            if (segmentOraclev9i.getSCInitialExtent() > 0L) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCInitialExtent());
                CSSBCreateTable.appendNewLine(stringBuffer, bl2, 2);
            }
            if (segmentOraclev9i.getSCNextExtent() > 0L) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCNextExtent());
                CSSBCreateTable.appendNewLine(stringBuffer, bl2, 2);
            }
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCPctIncrease());
            CSSBCreateTable.appendNewLine(stringBuffer, bl2, 2);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "MINEXTENTS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCMinExtents());
            CSSBCreateTable.appendNewLine(stringBuffer, bl2, 2);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCMaxExtents());
            CSSBCreateTable.appendNewLine(stringBuffer, bl2, 2);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "FREELISTS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCFreeLists());
            CSSBCreateTable.appendNewLine(stringBuffer, bl2, 2);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "FREELIST");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "GROUPS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCFreelistGroups());
            CSSBCreateTable.appendNewLine(stringBuffer, bl2, 2);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "BUFFER_POOL");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCBufferPool());
            CSSBCreateTable.appendNewLine(stringBuffer, bl2, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendTableSpace(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        TableSpaceOracle tableSpaceOracle = tableProxyOraclev9i.getTableSpace();
        if (tableSpaceOracle != null && !"[NONE]".equalsIgnoreCase(tableSpaceOracle.getName())) {
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
        }
    }

    private void appendOrganization(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        if ("INDEX".equalsIgnoreCase(tableProxyOraclev9i.getOrganization())) {
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "ORGANIZATION");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "INDEX");
        }
        if (tableProxyOraclev9i.getSegment() == null) {
            this.appendTableSpace(stringBuffer, tableProxyOraclev9i, bl);
            if ("YES".equalsIgnoreCase(tableProxyOraclev9i.getLogging())) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "LOGGING");
            } else if ("NO".equalsIgnoreCase(tableProxyOraclev9i.getLogging())) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "NOLOGGING");
            }
        } else {
            this.appendSegment(stringBuffer, (SegmentOraclev9i)tableProxyOraclev9i.getSegment(), true, bl, tableProxyOraclev9i.getTableSpace(), tableProxyOraclev9i.getLogging());
        }
        if ("INDEX".equalsIgnoreCase(tableProxyOraclev9i.getOrganization())) {
            SegmentOraclev9i segmentOraclev9i;
            if (tableProxyOraclev9i.getIOTMappingTable().equalsIgnoreCase("YES")) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "MAPPING TABLE");
            }
            if (tableProxyOraclev9i.getIotPctThreshold() > 0) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "PCTTHRESHOLD");
                this.appendStringWithSpace(stringBuffer, tableProxyOraclev9i.getIotPctThreshold());
            }
            if (tableProxyOraclev9i.getIotCompress() > 0) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "COMPRESS");
                this.appendStringWithSpace(stringBuffer, tableProxyOraclev9i.getIotCompress());
            }
            if ((segmentOraclev9i = (SegmentOraclev9i)tableProxyOraclev9i.getIotOverflowSegment()) != null || tableProxyOraclev9i.getIotIncluding() != null) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                if (tableProxyOraclev9i.getIotIncluding() != null) {
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "INCLUDING");
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyOraclev9i.getIotIncluding().getName()));
                    CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                }
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "OVERFLOW");
                if (segmentOraclev9i != null) {
                    TableSpaceOracle tableSpaceOracle = segmentOraclev9i.getTableSpace();
                    if (tableSpaceOracle == null) {
                        tableSpaceOracle = tableProxyOraclev9i.getTableSpace();
                    }
                    this.appendSegment(stringBuffer, segmentOraclev9i, true, bl, tableSpaceOracle, tableProxyOraclev9i.getLogging());
                }
            }
        } else if (tableProxyOraclev9i.getDataSegmentCompression().equalsIgnoreCase("YES")) {
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "COMPRESS");
        }
        if ("YES".equalsIgnoreCase(tableProxyOraclev9i.getPartitioned())) {
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            if ("ENABLE".equalsIgnoreCase(tableProxyOraclev9i.getParttitionedRowMovement())) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "ENABLE");
            } else {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "DISABLE");
            }
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "ROW MOVEMENT");
        }
    }

    private void appendCluster(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        ClusterOraclev9i clusterOraclev9i = (ClusterOraclev9i)tableProxyOraclev9i.getCluster();
        if (clusterOraclev9i != null) {
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "CLUSTER");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(clusterOraclev9i.getLongName()));
            if (!"".equalsIgnoreCase(tableProxyOraclev9i.getClusterColumns())) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(tableProxyOraclev9i.getAllClusterColumns()));
                CSSBCreateTable.appendStringWithSpace(stringBuffer, ')');
            }
        } else {
            this.appendOrganization(stringBuffer, tableProxyOraclev9i, bl);
            Table table = (Table)this.tableObj.getObject();
            if (!table.isSpatialTable()) {
                for (int i = 0; i < tableProxyOraclev9i.getLobStorages().size(); ++i) {
                    this.appendLobStorage(stringBuffer, (LobStorageOraclev9i)tableProxyOraclev9i.getLobStorages().getElement(i), bl);
                }
            }
        }
    }

    private void appendPermissions(StringBuffer stringBuffer, TableProxyOracle tableProxyOracle, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        PermissionsSetOracle permissionsSetOracle = ((StorageDesignOracle)tableProxyOracle.getStorageDesign()).getPermissionsSet();
        Iterator iterator = permissionsSetOracle.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            PermissionsOraclev9i permissionsOraclev9i = (PermissionsOraclev9i)iterator.next();
            if (permissionsOraclev9i.getTable() != null && permissionsOraclev9i.getTable().equals(tableProxyOracle) && !permissionsOraclev9i.getPrivileges().equalsIgnoreCase("")) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 0);
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 0);
                this.appendComment(stringBuffer, permissionsOraclev9i);
                CSSBCreateTable.appendStringWithSpace(stringBuffer2, "GRANT");
                this.appendPrivileges(stringBuffer2, permissionsOraclev9i);
                this.appendObject(stringBuffer2, permissionsOraclev9i, bl);
                this.appendTo(stringBuffer2, permissionsOraclev9i);
                this.appendHierrarchyOption(stringBuffer2, permissionsOraclev9i, bl);
                string = "GRANT ON " + this.getPermissionsON(permissionsOraclev9i) + " TO " + this.getPermissionsTO(permissionsOraclev9i);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                CSSBCreateTable.appendNewLine(stringBuffer2, bl, 0);
                stringBuffer2.append(';');
                CSSBCreateTable.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
            }
            if (permissionsOraclev9i.getTable() != null && permissionsOraclev9i.getTable().equals(tableProxyOracle) && !permissionsOraclev9i.getPrivilegesWithGrantOption().equalsIgnoreCase("")) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 0);
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 0);
                this.appendComment(stringBuffer, permissionsOraclev9i);
                CSSBCreateTable.appendStringWithSpace(stringBuffer2, "GRANT");
                this.appendPrivilegesWithGrantOption(stringBuffer2, permissionsOraclev9i);
                this.appendObject(stringBuffer2, permissionsOraclev9i, bl);
                this.appendTo(stringBuffer2, permissionsOraclev9i);
                this.appendGrantOption(stringBuffer2, permissionsOraclev9i);
                this.appendHierrarchyOption(stringBuffer2, permissionsOraclev9i, bl);
                string = "GRANT ON " + this.getPermissionsON(permissionsOraclev9i) + " TO " + this.getPermissionsTO(permissionsOraclev9i);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                CSSBCreateTable.appendNewLine(stringBuffer2, bl, 0);
                stringBuffer2.append(';');
                CSSBCreateTable.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
            }
            if (permissionsOraclev9i.getColumnsTable() == null || !permissionsOraclev9i.getColumnsTable().equals(tableProxyOracle) || permissionsOraclev9i.getColumns().isEmpty()) continue;
            ArrayList arrayList = permissionsOraclev9i.getColumns();
            for (int i = 0; i < arrayList.size(); ++i) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 0);
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 0);
                this.appendComment(stringBuffer, permissionsOraclev9i);
                CSSBCreateTable.appendStringWithSpace(stringBuffer2, "GRANT");
                CSSBCreateTable.appendStringWithSpace(stringBuffer2, permissionsOraclev9i.getPrivs((String)arrayList.get(i)).trim());
                CSSBCreateTable.appendStringWithSpace(stringBuffer2, '(');
                CSSBCreateTable.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(arrayList.get(i).toString()));
                CSSBCreateTable.appendStringWithSpace(stringBuffer2, ')');
                this.appendObject(stringBuffer2, permissionsOraclev9i, bl);
                this.appendTo(stringBuffer2, permissionsOraclev9i);
                this.appendGrantOption(stringBuffer2, permissionsOraclev9i);
                this.appendHierrarchyOption(stringBuffer2, permissionsOraclev9i, bl);
                string = "GRANT ON " + this.getPermissionsON(permissionsOraclev9i) + " TO " + this.getPermissionsTO(permissionsOraclev9i);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                CSSBCreateTable.appendNewLine(stringBuffer2, bl, 0);
                stringBuffer2.append(';');
                CSSBCreateTable.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
            }
        }
        if (!bl2) {
            this.appendDropPackage(stringBuffer, this.storageDesign.getFormatedName(tableProxyOracle.getUser().getName()), bl);
        }
    }

    private String getPermissionsTO(PermissionsOraclev9i permissionsOraclev9i) {
        if (permissionsOraclev9i.getUser() != null) {
            return permissionsOraclev9i.getUser().getLongName();
        }
        if (permissionsOraclev9i.getRole() != null) {
            return permissionsOraclev9i.getRole().getLongName();
        }
        return "";
    }

    private String getPermissionsON(PermissionsOraclev9i permissionsOraclev9i) {
        if (permissionsOraclev9i.getTable() != null) {
            return permissionsOraclev9i.getTable().getLongName();
        }
        if (permissionsOraclev9i.getView() != null) {
            return permissionsOraclev9i.getView().getLongName();
        }
        if (permissionsOraclev9i.getSequence() != null) {
            return permissionsOraclev9i.getSequence().getLongName();
        }
        if (permissionsOraclev9i.getSnapshot() != null) {
            return permissionsOraclev9i.getSnapshot().getLongName();
        }
        if (permissionsOraclev9i.getProc() != null) {
            return permissionsOraclev9i.getProc().getLongName();
        }
        if (permissionsOraclev9i.getDirectoryOracle() != null) {
            return permissionsOraclev9i.getDirectoryOracle().getLongName();
        }
        if (permissionsOraclev9i.getStructuredTypeOracle() != null) {
            return permissionsOraclev9i.getStructuredTypeOracle().getLongName();
        }
        if (permissionsOraclev9i.getCollectionTypeOracle() != null) {
            return permissionsOraclev9i.getCollectionTypeOracle().getLongName();
        }
        if (permissionsOraclev9i.getExternalTableOracle() != null) {
            return permissionsOraclev9i.getExternalTableOracle().getLongName();
        }
        return "";
    }

    private void appendPrivileges(StringBuffer stringBuffer, PermissionsOraclev9i permissionsOraclev9i) {
        stringBuffer.append(permissionsOraclev9i.getPrivileges());
    }

    private void appendPrivilegesWithGrantOption(StringBuffer stringBuffer, PermissionsOraclev9i permissionsOraclev9i) {
        stringBuffer.append(permissionsOraclev9i.getPrivilegesWithGrantOption());
    }

    private void appendObject(StringBuffer stringBuffer, PermissionsOraclev9i permissionsOraclev9i, boolean bl) {
        if (permissionsOraclev9i.getTable() != null) {
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "ON");
            CSSBCreateTable.appendStringWithSpace(stringBuffer, this.getTableName(this.tableObj));
        }
    }

    private void appendTo(StringBuffer stringBuffer, PermissionsOraclev9i permissionsOraclev9i) {
        CSSBCreateTable.appendStringWithSpace(stringBuffer, "TO");
        if ("YES".equalsIgnoreCase(permissionsOraclev9i.getPublic())) {
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "PUBLIC");
        } else {
            if (permissionsOraclev9i.getUser() != null) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev9i.getUser().getName()));
            }
            if (permissionsOraclev9i.getRole() != null) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev9i.getRole().getName()));
            }
        }
    }

    private void appendGrantOption(StringBuffer stringBuffer, PermissionsOraclev9i permissionsOraclev9i) {
        if (permissionsOraclev9i.getRole() == null) {
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "WITH GRANT OPTION");
        }
    }

    private void appendHierrarchyOption(StringBuffer stringBuffer, PermissionsOraclev9i permissionsOraclev9i, boolean bl) {
        if ("YES".equalsIgnoreCase(permissionsOraclev9i.getHierarchyOption())) {
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "WITH HIERARCHY OPTION");
        }
    }

    private void appendDropPackage(StringBuffer stringBuffer, String string, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
        CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
        stringBuffer2.append("DROP PACKAGE ").append(string).append(".perm_manager;");
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
    }

    private void appendIndexes(StringBuffer stringBuffer, TableProxyOracle tableProxyOracle, CompareObjectSelection compareObjectSelection, boolean bl) {
        this.appendIndexes(stringBuffer, compareObjectSelection, bl);
        this.appendPKAndUK(stringBuffer, compareObjectSelection, bl);
    }

    public boolean isRenamed() {
        return this.isRenamed;
    }

    public void setRenamed(boolean bl) {
        this.isRenamed = bl;
    }

    private void appendIndexes(StringBuffer stringBuffer, CompareObjectSelection compareObjectSelection, boolean bl) {
        List list = compareObjectSelection.getChildObjects(1);
        for (CompareObjectSelection compareObjectSelection2 : list) {
            Index index;
            if (compareObjectSelection2.canBeCreate() && !compareObjectSelection2.isSelected() || (index = (Index)compareObjectSelection2.getObject()) == null) continue;
            StringBuffer stringBuffer2 = this.getColumnsForRestore(compareObjectSelection, index, bl, true);
            this.cssbIndex.setRenamed(this.isRenamed());
            this.cssbIndex.setRestoredColumns(stringBuffer2);
            this.cssbIndex.setRestoredExpression(index.getIndexExpression());
            this.cssbIndex.setTableName(this.getTableName(compareObjectSelection));
            this.cssbIndex.doAppend(stringBuffer, index, bl);
        }
    }

    private void appendPKAndUK(StringBuffer stringBuffer, CompareObjectSelection compareObjectSelection, boolean bl) {
        TableComparator tableComparator = (TableComparator)compareObjectSelection.getPropertiesComparator();
        TableProxyOraclev9i tableProxyOraclev9i = (TableProxyOraclev9i)tableComparator.getSourceTableProxy();
        List list = compareObjectSelection.getChildObjects(2);
        for (CompareObjectSelection compareObjectSelection2 : list) {
            StringBuffer stringBuffer2;
            if (compareObjectSelection2.canBeCreate() && !compareObjectSelection2.isSelected() || ((Index)compareObjectSelection2.getObject()).isOidKey()) continue;
            if (((Index)compareObjectSelection2.getObject()).isPK() && compareObjectSelection2.isSelected()) {
                stringBuffer2 = this.getColumnsForRestore(compareObjectSelection, (Index)compareObjectSelection2.getObject(), bl, false);
                if (this.isNotEmpty(stringBuffer2.toString())) {
                    this.appendPKDefinition(stringBuffer, tableProxyOraclev9i, (Index)compareObjectSelection2.getObject(), stringBuffer2, bl);
                } else {
                    this.appendError(stringBuffer, bl, "Index " + compareObjectSelection2.getObject().toString() + " without columns");
                }
            }
            if (!((Index)compareObjectSelection2.getObject()).isUnique() || !compareObjectSelection2.isSelected()) continue;
            stringBuffer2 = this.getColumnsForRestore(compareObjectSelection, (Index)compareObjectSelection2.getObject(), bl, false);
            if (this.isNotEmpty(stringBuffer2.toString())) {
                UniqueOraclev9i uniqueOraclev9i = (UniqueOraclev9i)tableProxyOraclev9i.getUniqueKeys().getObjectByID(compareObjectSelection2.getObject().getObjectID());
                this.appendUniqueDefinition(stringBuffer, tableProxyOraclev9i, uniqueOraclev9i, bl, stringBuffer2);
                continue;
            }
            this.appendError(stringBuffer, bl, "Index " + compareObjectSelection2.getObject().toString() + " without columns");
        }
    }

    private void appendError(StringBuffer stringBuffer, boolean bl, String string) {
        CSSBCreateTable.appendNewLine(stringBuffer, bl, 0);
        CSSBCreateTable.appendStringWithSpace(stringBuffer, "--  ERROR: ");
        CSSBCreateTable.appendString(stringBuffer, string);
        CSSBCreateTable.appendNewLine(stringBuffer, bl, 0);
        CDDLFileMaker.incrementErrors();
    }

    private void appendTableLevelCheckConstraints(StringBuffer stringBuffer, TableProxyOracle tableProxyOracle, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        Iterator iterator = tableProxyOracle.getTableCheckConstraints().iterator();
        while (iterator.hasNext()) {
            TableCheckConstraintOracle tableCheckConstraintOracle = (TableCheckConstraintOracle)iterator.next();
            TableLevelConstraint tableLevelConstraint = tableCheckConstraintOracle.getTableConstraint();
            if (!tableLevelConstraint.shouldBeMerge()) continue;
            String string = tableCheckConstraintOracle.getTableConstraint().getRule();
            String string2 = tableCheckConstraintOracle.getName();
            if (string2.toUpperCase().startsWith("SYS_")) {
                string2 = "";
            }
            if ("".equals(string2) || "".equals(string)) continue;
            CSSBCreateTable.appendNewLine(stringBuffer2, bl, 0);
            CSSBCreateTable.appendNewLine(stringBuffer2, bl, 0);
            if (string2.length() > tableProxyOracle.getMaxNameLength()) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 0);
                CSSBCreateTable.appendStringWithSpace(stringBuffer, "--  ERROR: Table constraint name length exceeds maximum allowed length(" + tableProxyOracle.getMaxNameLength() + ")");
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 0);
                CDDLFileMaker.incrementErrors();
            }
            String string3 = this.storageDesign.getFormatedName(string2);
            String string4 = this.storageDesign.getFormatedName(tableProxyOracle.getLongName());
            CSSBCreateTable.appendStringWithSpace(stringBuffer2, "ALTER");
            CSSBCreateTable.appendStringWithSpace(stringBuffer2, "TABLE");
            CSSBCreateTable.appendStringWithSpace(stringBuffer2, string4);
            CSSBCreateTable.appendNewLine(stringBuffer2, bl, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer2, "ADD");
            CSSBCreateTable.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
            CSSBCreateTable.appendStringWithSpace(stringBuffer2, string3);
            CSSBCreateTable.appendNewLine(stringBuffer2, bl, 1);
            CSSBCreateTable.appendStringWithSpace(stringBuffer2, "CHECK");
            CSSBCreateTable.appendString(stringBuffer2, '(');
            CSSBCreateTable.appendString(stringBuffer2, tableCheckConstraintOracle.getTableConstraint().getRule());
            CSSBCreateTable.appendString(stringBuffer2, ')');
            this.appendTableConstraintState(stringBuffer2, tableCheckConstraintOracle, bl);
            String string5 = "Alter Table " + string4 + " Add Constraint " + string3;
            this.appendToBuffer(stringBuffer, stringBuffer2, string5);
            CSSBCreateTable.appendNewLine(stringBuffer2, bl, 0);
            stringBuffer2.append(';');
            CSSBCreateTable.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, "");
            CDDLFileMaker.incrementAlterTable();
        }
    }

    private StringBuffer getColumnsForRestore(CompareObjectSelection compareObjectSelection, Index index, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl3 = false;
        List list = compareObjectSelection.getChildObjects(0);
        block0: for (Column column : index.getElementsCollection()) {
            for (CompareObjectSelection compareObjectSelection2 : list) {
                ModelIDObject modelIDObject = compareObjectSelection2.getObject();
                if (modelIDObject == null || !modelIDObject.equals(column)) continue;
                if (compareObjectSelection2.canBeCreate() && !compareObjectSelection2.isSelected() || compareObjectSelection2.canBeDrop() && compareObjectSelection2.getCorrespondentNode().isSelected()) continue block0;
                if (bl3) {
                    stringBuffer.append(',');
                    CSSBCreateTable.appendNewLine(stringBuffer, bl, 1);
                    stringBuffer.append(' ');
                }
                String string = compareObjectSelection2.isSelected() ? compareObjectSelection2.getChoosedPropertyValue(PropertiesComparator.NAME) : compareObjectSelection2.getCorrespondentNode().getObject().getName();
                CSSBCreateTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
                if (bl2) {
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, index.getColumnSortOrder(compareObjectSelection2.getObject()));
                }
                bl3 = true;
                continue block0;
            }
        }
        return stringBuffer;
    }

    private void appendPKDefinition(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, Index index, StringBuffer stringBuffer2, boolean bl) {
        StringBuffer stringBuffer3 = new StringBuffer();
        String string = "";
        if (tableProxyOraclev9i != null) {
            Index index2;
            this.pk = this.getPKProxy(tableProxyOraclev9i);
            if (this.pk != null && this.pk.getObject() == index && ((index2 = this.pk.getIndex()).shouldBeMerge() || this.isRenamed()) && !this.hasNoMergeColumns(index2.getElements()) && !"".equalsIgnoreCase(this.pk.getColumns())) {
                CSSBCreateTable.appendNewLine(stringBuffer, bl, 0);
                if (this.pk.isCommentChanged() && !"".equalsIgnoreCase(this.pk.getComment())) {
                    this.appendComment(stringBuffer, this.pk);
                } else if (!"".equalsIgnoreCase(this.pk.getObject().getComment())) {
                    this.appendComment(stringBuffer, this.pk.getObject());
                }
                String string2 = this.pk.getName();
                if (string2.length() > tableProxyOraclev9i.getMaxNameLength()) {
                    CSSBCreateTable.appendNewLine(stringBuffer, bl, 0);
                    CSSBCreateTable.appendStringWithSpace(stringBuffer, "--  ERROR: PK name length exceeds maximum allowed length(" + tableProxyOraclev9i.getMaxNameLength() + ")");
                    CSSBCreateTable.appendNewLine(stringBuffer, bl, 0);
                    CDDLFileMaker.incrementErrors();
                }
                CSSBCreateTable.appendStringWithSpace(stringBuffer3, "ALTER");
                CSSBCreateTable.appendStringWithSpace(stringBuffer3, "TABLE");
                CSSBCreateTable.appendStringWithSpace(stringBuffer3, this.getTableName(this.tableObj));
                CSSBCreateTable.appendNewLine(stringBuffer3, bl, 1);
                CSSBCreateTable.appendStringWithSpace(stringBuffer3, "ADD");
                CSSBCreateTable.appendStringWithSpace(stringBuffer3, "CONSTRAINT");
                CSSBCreateTable.appendStringWithSpace(stringBuffer3, this.storageDesign.getFormatedName(string2));
                string = stringBuffer3.toString();
                CSSBCreateTable.appendStringWithSpace(stringBuffer3, "PRIMARY KEY");
                CSSBCreateTable.appendStringWithSpace(stringBuffer3, '(');
                if (!"".equals(index2.getIndexExpression())) {
                    CSSBCreateTable.appendStringWithSpace(stringBuffer3, index2.getIndexExpression());
                } else {
                    this.appendStringWithSpace(stringBuffer3, stringBuffer2);
                }
                CSSBCreateTable.appendStringWithSpace(stringBuffer3, ')');
                if (!"NO".equalsIgnoreCase(this.pk.getDeferrable())) {
                    CSSBCreateTable.appendStringWithSpace(stringBuffer3, "DEFERRABLE");
                    if ("DEFERRED".equalsIgnoreCase(this.pk.getInitially())) {
                        CSSBCreateTable.appendStringWithSpace(stringBuffer3, "INITIALLY");
                        CSSBCreateTable.appendStringWithSpace(stringBuffer3, "DEFERRED");
                    }
                }
                if (!"YES".equalsIgnoreCase(this.pk.getEnable())) {
                    CSSBCreateTable.appendStringWithSpace(stringBuffer3, "DISABLE");
                    if ("YES".equalsIgnoreCase(this.pk.getValidate())) {
                        CSSBCreateTable.appendStringWithSpace(stringBuffer3, "VALIDATE");
                    }
                }
                if (!"YES".equalsIgnoreCase(this.pk.getValidate())) {
                    CSSBCreateTable.appendStringWithSpace(stringBuffer3, "NOVALIDATE");
                }
                if (!"NO".equalsIgnoreCase(this.pk.getUsingIndex())) {
                    this.appendUsingIndex(stringBuffer3, this.pk, bl);
                }
                this.appendToBuffer(stringBuffer, stringBuffer3, string);
                this.appendLineFinisher(stringBuffer3, bl);
                this.appendToBuffer(stringBuffer, stringBuffer3, string);
                CDDLFileMaker.incrementAlterTable();
            }
        }
    }

    private void appendUniqueDefinition(StringBuffer stringBuffer, TableProxyOracle tableProxyOracle, UniqueOraclev9i uniqueOraclev9i, boolean bl, StringBuffer stringBuffer2) {
        StringBuffer stringBuffer3 = new StringBuffer();
        String string = "";
        CSSBCreateTable.appendNewLine(stringBuffer, bl, 0);
        if (uniqueOraclev9i.isCommentChanged() && !"".equalsIgnoreCase(uniqueOraclev9i.getComment())) {
            this.appendComment(stringBuffer, uniqueOraclev9i);
        } else if (!"".equalsIgnoreCase(uniqueOraclev9i.getObject().getComment())) {
            this.appendComment(stringBuffer, uniqueOraclev9i.getObject());
        }
        String string2 = uniqueOraclev9i.getName();
        if (string2.length() > tableProxyOracle.getMaxNameLength()) {
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 0);
            CSSBCreateTable.appendStringWithSpace(stringBuffer, "--  ERROR: UK name length exceeds maximum allowed length(" + tableProxyOracle.getMaxNameLength() + ")");
            CSSBCreateTable.appendNewLine(stringBuffer, bl, 0);
            CDDLFileMaker.incrementErrors();
        }
        CSSBCreateTable.appendStringWithSpace(stringBuffer3, "ALTER");
        CSSBCreateTable.appendStringWithSpace(stringBuffer3, "TABLE");
        CSSBCreateTable.appendStringWithSpace(stringBuffer3, this.getTableName(this.tableObj));
        CSSBCreateTable.appendNewLine(stringBuffer3, bl, 1);
        CSSBCreateTable.appendStringWithSpace(stringBuffer3, "ADD");
        CSSBCreateTable.appendStringWithSpace(stringBuffer3, "CONSTRAINT");
        CSSBCreateTable.appendStringWithSpace(stringBuffer3, this.storageDesign.getFormatedName(string2));
        CSSBCreateTable.appendStringWithSpace(stringBuffer3, "UNIQUE");
        string = stringBuffer3.toString();
        CSSBCreateTable.appendStringWithSpace(stringBuffer3, '(');
        this.appendString(stringBuffer3, stringBuffer2);
        CSSBCreateTable.appendStringWithSpace(stringBuffer3, ')');
        if (!"NO".equalsIgnoreCase(uniqueOraclev9i.getDeferrable())) {
            CSSBCreateTable.appendStringWithSpace(stringBuffer3, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(uniqueOraclev9i.getInitially())) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer3, "INITIALLY");
                CSSBCreateTable.appendStringWithSpace(stringBuffer3, "DEFERRED");
            }
        }
        if (!"YES".equalsIgnoreCase(uniqueOraclev9i.getEnable())) {
            CSSBCreateTable.appendStringWithSpace(stringBuffer3, "DISABLE");
            if ("YES".equalsIgnoreCase(uniqueOraclev9i.getValidate())) {
                CSSBCreateTable.appendStringWithSpace(stringBuffer3, "VALIDATE");
            }
        }
        if (!"YES".equalsIgnoreCase(uniqueOraclev9i.getValidate())) {
            CSSBCreateTable.appendStringWithSpace(stringBuffer3, "NOVALIDATE");
        }
        if (!"NO".equalsIgnoreCase(uniqueOraclev9i.getUsingIndex())) {
            this.appendUniqueUsingIndex(stringBuffer3, uniqueOraclev9i, bl);
        }
        this.appendToBuffer(stringBuffer, stringBuffer3, string);
        this.appendLineFinisher(stringBuffer3, bl);
        this.appendToBuffer(stringBuffer, stringBuffer3, string);
        CDDLFileMaker.incrementAlterTable();
    }

    public String getTableName(CompareObjectSelection compareObjectSelection) {
        String string = compareObjectSelection.getMergedProperty(PropertiesComparator.SCHEMA);
        String string2 = this.storageDesign.getFormatedName(compareObjectSelection.getMergedProperty(PropertiesComparator.NAME));
        if (!"".equals(string)) {
            string2 = this.storageDesign.getFormatedName(string) + '.' + string2;
        }
        return string2;
    }

    private void appendBitmapJoinIndexes(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        Iterator iterator = tableProxyOraclev9i.getBjIndexes().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.ssbBJIndex == null) {
                this.ssbBJIndex = new SSBCreateBitmapJoinIndexOraclev9i();
            }
            if (!this.ssbBJIndex.canHandle(e)) continue;
            this.ssbBJIndex.doAppendBJIndex(stringBuffer, e, bl);
        }
    }

    private void appendAutoIncTriggers(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        Table table = (Table)tableProxyOraclev9i.getObject();
        for (Column column : table.getElementsCollection()) {
            if (!column.isAutoIncrementColumn()) continue;
            if (this.ssbAutoIncCol == null) {
                this.ssbAutoIncCol = new SSBAutoIncrementColumnOracle(this.storageDesign);
            }
            this.ssbAutoIncCol.appendAutoIncrementSequenceAndTrigger(stringBuffer, column, bl);
        }
    }

    private void appendTriggers(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        Iterator iterator = tableProxyOraclev9i.getTriggers().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.ssbTriggers == null) {
                this.ssbTriggers = new SSBTriggerOraclev9i();
            }
            if (!this.ssbTriggers.canHandle(e)) continue;
            this.ssbTriggers.doAppendTrigger(stringBuffer, e, bl);
        }
    }

    static class PossitionComparator
    implements Comparator {
        PossitionComparator() {
        }

        public int compare(Object object, Object object2) {
            if (((PartitionOraclev9i)object).getPosition() > ((PartitionOraclev9i)object2).getPosition()) {
                return 1;
            }
            if (((PartitionOraclev9i)object).getPosition() < ((PartitionOraclev9i)object2).getPosition()) {
                return -1;
            }
            return 0;
        }
    }

    static class GlobalPossitionComparator
    implements Comparator {
        GlobalPossitionComparator() {
        }

        public int compare(Object object, Object object2) {
            if (((IndexGlobalPartitionOraclev9i)object).getPosition() > ((IndexGlobalPartitionOraclev9i)object2).getPosition()) {
                return 1;
            }
            if (((IndexGlobalPartitionOraclev9i)object).getPosition() < ((IndexGlobalPartitionOraclev9i)object2).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

