/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.DDLAdvancedGenerator;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.exports.ddl.oracle.SSBAutoIncrementColumnOracle;
import oracle.dbtools.crest.exports.ddl.oracle.v9i.SSBCreateBitmapJoinIndexOraclev9i;
import oracle.dbtools.crest.exports.ddl.oracle.v9i.SSBTriggerOraclev9i;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.ColumnComparator;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.TableComparator;
import oracle.dbtools.crest.model.design.compare.TableSelection;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.AbstractCSSBOraclev9i;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBIndex;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateRenameTableOraclev10g;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionLobItemOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ClusterOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ColumnProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionLobItemOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionLobItemSetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionSetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionsListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListStorageTemplatePartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.LobStorageOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxySetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PermissionsOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueOraclev9i;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;

public class CSSBCreateRenameTable
extends AbstractCSSBOraclev9i {
    private CSSBIndex cssbIndex = new CSSBIndex();
    private PKProxyOraclev9i pk = null;
    private boolean isRenamed = false;
    private TableSelection tableObj;
    private TableSelection targetObject;
    private SSBCreateBitmapJoinIndexOraclev9i ssbBJIndex = null;
    private SSBAutoIncrementColumnOracle ssbAutoIncCol = null;
    private SSBTriggerOraclev9i ssbTriggers = null;
    private String directoryName;

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).canBeCreate() && ((CompareObjectSelection)object).getObject() instanceof Table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doAppend(StringBuffer stringBuffer, Object object, boolean bl) {
        block39: {
            Table table;
            block37: {
                StringBuffer stringBuffer2;
                block38: {
                    stringBuffer2 = new StringBuffer();
                    String string = "";
                    table = null;
                    TableProxyOraclev9i tableProxyOraclev9i = null;
                    this.tableObj = (TableSelection)object;
                    if (object == null) {
                        return;
                    }
                    if (!(this.tableObj.getObject() instanceof Table)) {
                        return;
                    }
                    table = (Table)this.tableObj.getObject();
                    Object object2 = table.getDesign();
                    Object object3 = table.getSelectedRDBMSSite();
                    this.storageDesign = (StorageDesignOracle)((Design)object2).getStorageDesign((RDBMSSite)object3, table);
                    tableProxyOraclev9i = (TableProxyOraclev9i)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
                    this.targetObject = (TableSelection)this.tableObj.getCorrespondentNode();
                    if (table.getTypeSubstitution() != null) break block37;
                    if (tableProxyOraclev9i != null && tableProxyOraclev9i.isCommentChanged()) {
                        this.appendComment(stringBuffer, tableProxyOraclev9i);
                    } else {
                        this.appendComment(stringBuffer, table);
                    }
                    if (tableProxyOraclev9i != null && tableProxyOraclev9i.getName().length() > tableProxyOraclev9i.getMaxNameLength()) {
                        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "--  ERROR: Table name length exceeds maximum allowed length(" + tableProxyOraclev9i.getMaxNameLength() + ")");
                        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
                        CDDLFileMaker.incrementErrors();
                    }
                    this.appendBeforeCreateScript(stringBuffer, bl, table);
                    object2 = this.tableObj.getObjectsForRestore(0);
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "CREATE");
                    if (tableProxyOraclev9i == null) {
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "TABLE");
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, this.getTableName(this.tableObj));
                        string = stringBuffer2.toString();
                        this.appendElementList(stringBuffer2, this.tableObj, bl, (List)object2);
                        this.appendOid(stringBuffer2, table, null, bl);
                    } else if ("YES".equalsIgnoreCase(tableProxyOraclev9i.getTemporary())) {
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "GLOBAL");
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "TEMPORARY");
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "TABLE");
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, this.getTableName(this.tableObj));
                        string = stringBuffer2.toString();
                        this.appendElementList(stringBuffer2, this.tableObj, bl, (List)object2);
                        CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 1);
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "ON");
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "COMMIT");
                        if ("YES".equalsIgnoreCase(tableProxyOraclev9i.getTempPreserveRows())) {
                            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "PRESERVE ROWS");
                        } else {
                            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "DELETE ROWS");
                        }
                        this.appendOid(stringBuffer2, table, null, bl);
                        if ("YES".equalsIgnoreCase(tableProxyOraclev9i.getCache())) {
                            CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 1);
                            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "CACHE");
                        }
                    } else {
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "TABLE");
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, this.getTableName(this.tableObj));
                        string = stringBuffer2.toString();
                        this.appendElementList(stringBuffer2, this.tableObj, bl, (List)object2);
                        this.appendOid(stringBuffer2, table, tableProxyOraclev9i, bl);
                        this.appendCluster(stringBuffer2, tableProxyOraclev9i, bl);
                        this.appendColumnProperties(stringBuffer2, table, tableProxyOraclev9i, bl);
                        this.appendPartitionList(stringBuffer2, tableProxyOraclev9i, bl);
                        if ("YES".equalsIgnoreCase(tableProxyOraclev9i.getCache())) {
                            CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 1);
                            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "CACHE");
                        }
                        if ("YES".equalsIgnoreCase(tableProxyOraclev9i.getMonitoring())) {
                            CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 1);
                            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "MONITORING");
                        }
                        if ("YES".equalsIgnoreCase(tableProxyOraclev9i.getParallel())) {
                            CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 1);
                            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "PARALLEL");
                            if (!"".equals(tableProxyOraclev9i.getDegree())) {
                                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, tableProxyOraclev9i.getDegree());
                            }
                        }
                        if ("YES".equalsIgnoreCase(tableProxyOraclev9i.getRowDependency())) {
                            CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 1);
                            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "ROWDEPENDENCIES");
                        }
                    }
                    this.appendToBuffer(stringBuffer, stringBuffer2, string);
                    CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 0);
                    this.appendLineFinisher(stringBuffer2, bl);
                    CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 0);
                    this.appendToBuffer(stringBuffer, stringBuffer2, string);
                    CDDLFileMaker.incrementCreateTable();
                    this.appendAfterCreateScript(stringBuffer, bl, table);
                    this.appendTableLevelCheckConstraints(stringBuffer, this.tableObj, bl);
                    if (table.getDesign().getAppView().getSettings().isGenerateCommentsInRDBMS()) {
                        this.appendTableCommentOn(stringBuffer, table, tableProxyOraclev9i, bl);
                    }
                    if (tableProxyOraclev9i != null) {
                        object3 = DDLFileMaker.getddlAdvancedGenenerator();
                        try {
                            DDLFileMaker.setddlAdvancedGenenerator(CDDLFileMaker.getddlAdvancedGenenerator());
                            this.appendAutoIncTriggers(stringBuffer, tableProxyOraclev9i, bl);
                        }
                        finally {
                            DDLFileMaker.setddlAdvancedGenenerator((DDLAdvancedGenerator)object3);
                        }
                    }
                    if (this.targetObject.getScriptExecuteOption().equals(TableSelection.STOP_AFTER_RECREATE)) {
                        this.appendScriptExecution(stringBuffer, this.storageDesign.getFormatedName(this.targetObject.getName()));
                    }
                    if (this.isRenamed() && !TableSelection.NONE.equals(this.targetObject.getBackupOption()) && !TableSelection.NONE.equals(this.targetObject.getRestoreOption())) {
                        if (TableSelection.BACKUP_RENAME.equals(this.targetObject.getBackupOption())) {
                            this.insertIntoTable(stringBuffer, tableProxyOraclev9i, this.tableObj, "", bl);
                        } else if (TableSelection.BACKUP_UNLOAD.equals(this.targetObject.getBackupOption())) {
                            object3 = "EXT_" + tableProxyOraclev9i.getName();
                            if (((String)object3).length() > 30) {
                                object3 = ((String)object3).substring(0, 30);
                            }
                            object3 = this.storageDesign.getFormatedName((String)object3);
                            this.createExtDirectory(stringBuffer, this.tableObj, bl);
                            this.createExtTable(stringBuffer, (String)object3, this.tableObj, this.targetObject.getName(), bl);
                            this.insertIntoTable(stringBuffer, tableProxyOraclev9i, this.tableObj, (String)object3, bl);
                            this.dropExtTable(stringBuffer, (String)object3, bl);
                            this.dropExtDir(stringBuffer, bl);
                        } else if (TableSelection.BACKUP_UNLOAD_PARTITION.equals(this.targetObject.getBackupOption())) {
                            object3 = "EXT_" + tableProxyOraclev9i.getName();
                            if (((String)object3).length() > 30) {
                                object3 = ((String)object3).substring(0, 30);
                            }
                            object3 = this.storageDesign.getFormatedName((String)object3);
                            this.createExtDirectory(stringBuffer, this.tableObj, bl);
                            Object object4 = (TableComparator)this.targetObject.getPropertiesComparator();
                            TableProxyOracle tableProxyOracle = (TableProxyOracle)((TableComparator)object4).getTargetTableProxy();
                            Iterator iterator = tableProxyOracle.getPartitions().iterator();
                            while (iterator.hasNext()) {
                                PartitionOracle partitionOracle = (PartitionOracle)iterator.next();
                                String string2 = this.storageDesign.getFormatedName(this.targetObject.getName() + "_" + partitionOracle.getName());
                                this.createExtTable(stringBuffer, (String)object3, this.tableObj, string2, bl);
                                this.insertIntoTable(stringBuffer, tableProxyOraclev9i, this.tableObj, (String)object3, bl);
                                this.dropExtTable(stringBuffer, (String)object3, bl);
                            }
                            this.dropExtDir(stringBuffer, bl);
                        }
                    }
                    if (tableProxyOraclev9i == null) break block38;
                    this.appendIndexes(stringBuffer, tableProxyOraclev9i, this.tableObj, bl);
                    object3 = DDLFileMaker.getddlAdvancedGenenerator();
                    try {
                        DDLFileMaker.setddlAdvancedGenenerator(CDDLFileMaker.getddlAdvancedGenenerator());
                        this.appendBitmapJoinIndexes(stringBuffer, tableProxyOraclev9i, bl);
                        this.appendTriggers(stringBuffer, tableProxyOraclev9i, bl);
                    }
                    catch (Throwable throwable) {
                        DDLFileMaker.setddlAdvancedGenenerator((DDLAdvancedGenerator)object3);
                        throw throwable;
                    }
                    DDLFileMaker.setddlAdvancedGenenerator(object3);
                    this.appendPermissions(stringBuffer, tableProxyOraclev9i, bl);
                }
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
                if (table.isSpatialTable()) {
                    for (Object object4 : table.getSpatialDefinitions()) {
                        if (((SpatialColumnDefObject)object4).getSpatialColumn() == null && !((SpatialColumnDefObject)object4).isFunction()) continue;
                        this.appendRegisterSpatialTable(stringBuffer2, table, (SpatialColumnDefObject)object4, bl);
                    }
                }
                break block39;
            }
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "-- table " + table.getName() + ": is a part of type substitution hierarchy");
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void insertIntoTable(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, CompareObjectSelection compareObjectSelection, String string, boolean bl) {
        TableComparator tableComparator = (TableComparator)compareObjectSelection.getPropertiesComparator();
        TableProxyOracle tableProxyOracle = (TableProxyOracle)tableComparator.getTargetTableProxy();
        StringBuffer stringBuffer2 = new StringBuffer();
        String string2 = "";
        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "INSERT");
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "INTO");
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, this.getTableName(compareObjectSelection));
        string2 = stringBuffer2.toString();
        CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 1);
        CSSBCreateRenameTable.appendString(stringBuffer2, '(');
        ArrayList<CompareObjectSelection> arrayList = new ArrayList<CompareObjectSelection>();
        boolean bl2 = true;
        CompareObjectSelection compareObjectSelection2 = (CompareObjectSelection)compareObjectSelection.getChild(0);
        if (!compareObjectSelection2.isLeaf()) {
            for (int i = 0; i < compareObjectSelection2.getNumberOfChildren(); ++i) {
                CompareObjectSelection object2 = (CompareObjectSelection)compareObjectSelection2.getChild(i);
                if (object2.canBeCreate() || object2.canBeDrop() && object2.isSelected()) continue;
                if (bl2) {
                    bl2 = false;
                } else {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, ',');
                }
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(this.getColumnName(object2)));
                arrayList.add(object2);
            }
        }
        CSSBCreateRenameTable.appendString(stringBuffer2, ')');
        CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 0);
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "SELECT");
        CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 1);
        bl2 = true;
        for (CompareObjectSelection compareObjectSelection3 : arrayList) {
            ColumnComparator columnComparator;
            Column column;
            ColumnProxy columnProxy;
            String string3 = compareObjectSelection3.getDataTypeConversion();
            if ("".equals(string3) && compareObjectSelection3.getCorrespondentNode() != null) {
                string3 = compareObjectSelection3.getCorrespondentNode().getDataTypeConversion();
            }
            String string4 = (columnProxy = tableProxyOracle.getColumnProxy((column = (columnComparator = (ColumnComparator)compareObjectSelection3.getPropertiesComparator()).getTargetColumn()).getObjectID())) != null ? columnProxy.getName() : column.getName();
            if (this.isNotEmpty(string3) && Token.hasString(string3.toUpperCase(), string4.toUpperCase())) {
                string4 = string3;
            } else {
                String string5;
                string4 = this.storageDesign.getFormatedName(string4);
                if (!TableSelection.BACKUP_RENAME.equals(this.targetObject.getBackupOption()) && (string5 = compareObjectSelection3.getChoosedPropertyValue(PropertiesComparator.DATA_TYPE)).equalsIgnoreCase("BFILE")) {
                    string4 = "nvl2(" + string4 + ", bfilename(substr(" + string4 + ", 1, instr(" + string4 + ", ',') -1), " + "substr(" + string4 + ", instr(" + string4 + ", ',') +2)), '')";
                }
            }
            if (bl2) {
                bl2 = false;
            } else {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, ',');
            }
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, string4);
        }
        CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 0);
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "FROM");
        CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 1);
        if ("".equals(string)) {
            void var14_20;
            String string6 = "bcp_" + tableProxyOracle.getName();
            if (string6.length() > 30) {
                String string7 = string6.substring(0, 30);
            }
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName((String)var14_20));
        } else {
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, string);
        }
        this.appendToBuffer(stringBuffer, stringBuffer2, string2);
        CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 0);
        this.appendLineFinisher(stringBuffer2, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string2);
    }

    private void appendColumnProperties(StringBuffer stringBuffer, Table table, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        Column[] columnArray = (Column[])table.getElements();
        for (int i = 0; i < columnArray.length; ++i) {
            Column column = columnArray[i];
            ColumnProxyOraclev9i columnProxyOraclev9i = (ColumnProxyOraclev9i)tableProxyOraclev9i.getColumnProxy(column.getObjectID());
            Datatype datatype = columnProxyOraclev9i.getDataType();
            if (datatype.toString().equals("XMLTYPE")) {
                this.appendXMLTypeColumnProps(stringBuffer, columnProxyOraclev9i, bl);
                continue;
            }
            if (datatype instanceof CollectionType) {
                CollectionType collectionType = (CollectionType)datatype;
                if (collectionType.isArrayType()) {
                    this.appendVarrayColumnProp(stringBuffer, columnProxyOraclev9i, bl);
                    continue;
                }
                this.appendNestedTableColumnProp(stringBuffer, columnProxyOraclev9i, bl);
                continue;
            }
            if (!(datatype instanceof StructuredType)) continue;
            this.appendSubstitutableColumnClause(stringBuffer, columnProxyOraclev9i, bl, true);
        }
    }

    private void appendOid(StringBuffer stringBuffer, Table table, TableProxyOracle tableProxyOracle, boolean bl) {
        if (table.isRoot()) {
            if (table.isOidIsPK() && table.getOidPKColumns().size() > 0) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "OBJECT");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "IDENTIFIER");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "IS");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "PRIMARY KEY");
            }
            if (!(tableProxyOracle == null || tableProxyOracle.getOidIndexSegment() == null && "".equalsIgnoreCase(tableProxyOracle.getOidIndexName()))) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "OIDINDEX");
                if (!"".equalsIgnoreCase(tableProxyOracle.getOidIndexName())) {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyOracle.getOidIndexName()));
                }
                if (tableProxyOracle.getOidIndexSegment() != null) {
                    CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                    this.appendSegment(stringBuffer, (SegmentOraclev9i)tableProxyOracle.getOidIndexSegment(), false, bl, null, "");
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
                }
            }
        }
    }

    private void appendElementList(StringBuffer stringBuffer, CompareObjectSelection compareObjectSelection, boolean bl, List list) {
        TableComparator tableComparator = (TableComparator)compareObjectSelection.getPropertiesComparator();
        Table table = tableComparator.getSourceTable();
        TableProxyOraclev9i tableProxyOraclev9i = (TableProxyOraclev9i)tableComparator.getSourceTableProxy();
        TableProxyOraclev9i tableProxyOraclev9i2 = (TableProxyOraclev9i)tableComparator.getTargetTableProxy();
        List list2 = compareObjectSelection.getChildObjects(0);
        Column column = null;
        ColumnProxyOraclev9i columnProxyOraclev9i = null;
        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
        if (table.getBasedOnStructuredType() != null) {
            Object object;
            StructuredType structuredType = table.getBasedOnStructuredType();
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "OF");
            String string = structuredType.getName();
            if (tableProxyOraclev9i != null && (object = (StructuredTypeProxyOracle)tableProxyOraclev9i.getStorageDesign().getProxy(structuredType)) != null) {
                if (((StructuredTypeProxyOracle)object).getOwner() != null) {
                    CSSBCreateRenameTable.appendString(stringBuffer, this.storageDesign.getFormatedName(((StructuredTypeProxyOracle)object).getOwner().getName()));
                    CSSBCreateRenameTable.appendString(stringBuffer, '.');
                }
                string = ((RelationalObjectProxy)object).getName();
            }
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
            if (string.equalsIgnoreCase("XMLTYPE")) {
                this.appendObjectTypeColProperties(stringBuffer, table, tableProxyOraclev9i, bl);
                if (tableProxyOraclev9i != null) {
                    CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "XMLTYPE");
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "STORE AS");
                    if (tableProxyOraclev9i.getStoreAs().equalsIgnoreCase("OBJECT RELATIONAL")) {
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "OBJECT RELATIONAL");
                    } else {
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "CLOB");
                        object = tableProxyOraclev9i.getLobSegmentName();
                        if (object != null && ((String)object).length() > 0) {
                            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName((String)object));
                        }
                        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 2);
                        if (tableProxyOraclev9i.getXmlTypeTableSpace() != null) {
                            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
                            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyOraclev9i.getXmlTypeTableSpace().getName()));
                            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 2);
                        }
                        if (tableProxyOraclev9i.getChunk() > 0) {
                            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "CHUNK");
                            this.appendStringWithSpace(stringBuffer, tableProxyOraclev9i.getChunk());
                            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 2);
                        }
                        if (tableProxyOraclev9i.getOldVersions().equalsIgnoreCase("RETENTION")) {
                            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "RETENTION");
                        } else {
                            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "PCTVERSION");
                            this.appendStringWithSpace(stringBuffer, tableProxyOraclev9i.getPCTVersion());
                        }
                        if (tableProxyOraclev9i.getFreepools() > 0) {
                            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 2);
                            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "FREEPOOLS");
                            this.appendStringWithSpace(stringBuffer, tableProxyOraclev9i.getFreepools());
                        }
                        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 2);
                        if ("ENABLE".equalsIgnoreCase(tableProxyOraclev9i.getStorageInRow())) {
                            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "ENABLE");
                        } else {
                            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "DISABLE");
                        }
                        stringBuffer.append("STORAGE IN ROW");
                        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 2);
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, tableProxyOraclev9i.getXmlTypeCache());
                        if (!"CACHE".equalsIgnoreCase(tableProxyOraclev9i.getXmlTypeCache())) {
                            if ("YES".equalsIgnoreCase(tableProxyOraclev9i.getXmlTypeLogging())) {
                                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "LOGGING");
                            } else if ("NO".equalsIgnoreCase(tableProxyOraclev9i.getXmlTypeLogging())) {
                                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "NOLOGGING");
                            }
                        }
                        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
                    }
                    this.appendXMLSchemaSpec(stringBuffer, tableProxyOraclev9i.getXmlSchemaUrl(), tableProxyOraclev9i.getXmlSchemaElement(), bl);
                }
            } else {
                if (!table.isSubstitutable()) {
                    CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "NOT");
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "SUBSTITUTABLE");
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "AT");
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "ALL");
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "LEVELS");
                }
                this.appendObjectTypeColProperties(stringBuffer, table, tableProxyOraclev9i, bl);
            }
        } else if (list2.size() <= 0) {
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "-- No Columns");
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
        } else {
            boolean bl2 = true;
            boolean bl3 = true;
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                boolean bl4 = false;
                CompareObjectSelection compareObjectSelection2 = (CompareObjectSelection)iterator.next();
                columnProxyOraclev9i = null;
                column = (Column)compareObjectSelection2.getObject();
                bl3 = compareObjectSelection2.isSelected();
                if (column == null || !bl3) {
                    column = (Column)compareObjectSelection2.getCorrespondentNode().getObject();
                    if (column == null) continue;
                    bl4 = true;
                    columnProxyOraclev9i = (ColumnProxyOraclev9i)tableProxyOraclev9i2.getColumnProxy(column.getObjectID());
                } else {
                    columnProxyOraclev9i = (ColumnProxyOraclev9i)tableProxyOraclev9i.getColumnProxy(column.getObjectID());
                }
                if (!bl3 && !this.isRenamed() || column.isOid()) continue;
                if (columnProxyOraclev9i.getName().length() > columnProxyOraclev9i.getMaxNameLength()) {
                    CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "--  ERROR: Column name length exceeds maximum allowed length(" + columnProxyOraclev9i.getMaxNameLength() + ")");
                    CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
                    CDDLFileMaker.incrementErrors();
                }
                if (columnProxyOraclev9i.isCommentChanged() && !"".equalsIgnoreCase(columnProxyOraclev9i.getComment())) {
                    this.appendComment(stringBuffer, columnProxyOraclev9i);
                } else if (!"".equalsIgnoreCase(columnProxyOraclev9i.getObject().getComment())) {
                    this.appendComment(stringBuffer, columnProxyOraclev9i.getObject());
                }
                if (compareObjectSelection2.canBeCreate() && !compareObjectSelection2.isSelected() || compareObjectSelection2.canBeDrop() && compareObjectSelection2.isSelected()) continue;
                if (bl2) {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                    bl2 = false;
                } else {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ',');
                }
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateRenameTable.appendString(stringBuffer, ' ');
                String string = bl4 ? columnProxyOraclev9i.getName() : compareObjectSelection2.getChoosedPropertyValue(PropertiesComparator.NAME);
                string = this.storageDesign.getFormatedName(string);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, string);
                if (column.getContainer().getBasedOnStructuredType() == null) {
                    String string2 = bl4 && columnProxyOraclev9i != null ? column.getDatatypeString(columnProxyOraclev9i.getStorageDesign().getRDBMSType().getName()) : compareObjectSelection2.getChoosedPropertyValue(PropertiesComparator.DATA_TYPE);
                    stringBuffer.append(string2).append(' ');
                }
                if (tableProxyOraclev9i == null && tableProxyOraclev9i2 == null) continue;
                this.appendColumnOptions(stringBuffer, column, columnProxyOraclev9i, bl, compareObjectSelection2, bl3);
                this.appendInlineRefConstraint(stringBuffer, column, columnProxyOraclev9i, bl);
                CSSBCreateRenameTableOraclev10g.appendColumnConstraints(stringBuffer, column, columnProxyOraclev9i, bl, compareObjectSelection2);
            }
            this.appendSupplementalLoggings(stringBuffer, tableProxyOraclev9i, bl);
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private boolean hasNoMergeColumns(ContainedObject[] containedObjectArray) {
        if (this.isRenamed()) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < containedObjectArray.length; ++i) {
            Column column = (Column)containedObjectArray[i];
            if (column.shouldBeMerge()) continue;
            ++n;
        }
        return containedObjectArray.length == n;
    }

    private void appendColumnOptions(StringBuffer stringBuffer, Column column, ColumnProxyOraclev9i columnProxyOraclev9i, boolean bl, CompareObjectSelection compareObjectSelection, boolean bl2) {
        this.appendWithDefaultDefinition(stringBuffer, columnProxyOraclev9i, compareObjectSelection, bl2);
        String string = compareObjectSelection.getChoosedPropertyValue(PropertiesComparator.MANDATORY);
        boolean bl3 = Boolean.valueOf(string);
        if (bl3) {
            ColumnComparator columnComparator = (ColumnComparator)compareObjectSelection.getPropertiesComparator();
            ColumnProxy columnProxy = columnComparator.getTargetColumnProxy();
            if (!column.getNullsAllowed()) {
                this.appendNotNullDefinition(stringBuffer, columnProxyOraclev9i, bl);
            } else if (columnProxy != null) {
                this.appendNotNullDefinition(stringBuffer, (ColumnProxyOraclev9i)columnProxy, bl);
            }
        }
    }

    private void appendWithDefaultDefinition(StringBuffer stringBuffer, ColumnProxyOraclev9i columnProxyOraclev9i, CompareObjectSelection compareObjectSelection, boolean bl) {
        String string;
        String string2 = compareObjectSelection.getChoosedPropertyValue(PropertiesComparator.USES_DEFUALT_VALUE);
        boolean bl2 = Boolean.parseBoolean(string2);
        if (bl2 && (string = bl ? compareObjectSelection.getChoosedPropertyValue(PropertiesComparator.DEFAULT_VALUE) : columnProxyOraclev9i.getDefaultValue()) != null && !"".equalsIgnoreCase(string)) {
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "DEFAULT");
            String string3 = compareObjectSelection.getChoosedPropertyValue(PropertiesComparator.DATA_TYPE);
            String string4 = this.addQuotesToDefault(string3, string);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, string4);
        }
    }

    private PKProxyOraclev9i getPKProxy(TableProxyOraclev9i tableProxyOraclev9i) {
        PKProxySetOraclev9i pKProxySetOraclev9i = (PKProxySetOraclev9i)((StorageDesignOraclev9i)tableProxyOraclev9i.getStorageDesign()).getPKProxySet();
        if (pKProxySetOraclev9i != null) {
            Iterator iterator = pKProxySetOraclev9i.iterator();
            while (iterator.hasNext()) {
                PKProxyOraclev9i pKProxyOraclev9i = (PKProxyOraclev9i)iterator.next();
                if (!pKProxyOraclev9i.getTable().equals(tableProxyOraclev9i.getObject())) continue;
                return pKProxyOraclev9i;
            }
        }
        return null;
    }

    private void appendIndexes(StringBuffer stringBuffer, CompareObjectSelection compareObjectSelection, boolean bl) {
        List list = compareObjectSelection.getChildObjects(1);
        for (CompareObjectSelection compareObjectSelection2 : list) {
            StringBuffer stringBuffer2;
            Index index;
            if (compareObjectSelection2.canBeCreate() && !compareObjectSelection2.isSelected()) continue;
            if (!compareObjectSelection2.isSelected()) {
                index = (Index)compareObjectSelection2.getCorrespondentNode().getObject();
                if (index == null) continue;
                stringBuffer2 = this.getColumnsForRestore(compareObjectSelection.getCorrespondentNode(), index, bl, true);
                this.cssbIndex.setRenamed(this.isRenamed());
                this.cssbIndex.setRestoredColumns(stringBuffer2);
                this.cssbIndex.setRestoredExpression(index.getIndexExpression());
                this.cssbIndex.setTableName(this.getTableName(compareObjectSelection));
                this.cssbIndex.doAppend(stringBuffer, index, bl);
                continue;
            }
            index = (Index)compareObjectSelection2.getObject();
            if (index == null) continue;
            stringBuffer2 = this.getColumnsForRestore(compareObjectSelection, index, bl, true);
            this.cssbIndex.setRenamed(this.isRenamed());
            this.cssbIndex.setRestoredColumns(stringBuffer2);
            this.cssbIndex.setRestoredExpression(compareObjectSelection2.getChoosedPropertyValue(PropertiesComparator.INDEX_FUNCTION_EXPRESSION));
            this.cssbIndex.setTableName(this.getTableName(compareObjectSelection));
            this.cssbIndex.doAppend(stringBuffer, index, bl);
        }
    }

    private void appendPKAndUK(StringBuffer stringBuffer, CompareObjectSelection compareObjectSelection, boolean bl) {
        TableComparator tableComparator = (TableComparator)compareObjectSelection.getPropertiesComparator();
        TableProxyOraclev9i tableProxyOraclev9i = (TableProxyOraclev9i)tableComparator.getSourceTableProxy();
        TableProxyOraclev9i tableProxyOraclev9i2 = (TableProxyOraclev9i)tableComparator.getTargetTableProxy();
        List list = compareObjectSelection.getChildObjects(2);
        for (CompareObjectSelection compareObjectSelection2 : list) {
            UniqueOraclev9i uniqueOraclev9i;
            StringBuffer stringBuffer2;
            Object object;
            Index index;
            if (compareObjectSelection2.canBeCreate() && !compareObjectSelection2.isSelected()) continue;
            Index index2 = index = compareObjectSelection2.isSelected() ? (Index)compareObjectSelection2.getObject() : (Index)compareObjectSelection2.getCorrespondentNode().getObject();
            if (index != null && index.isOidKey()) continue;
            if (compareObjectSelection2.getChoosedPropertyValue(PropertiesComparator.INDEX_STATUS).equals("Primary Constraint")) {
                if ((Index)compareObjectSelection2.getObject() == null) {
                    if (compareObjectSelection2.isSelected() || !this.isNotEmpty(((StringBuffer)(object = this.getColumnsForRestore(compareObjectSelection.getCorrespondentNode(), (Index)compareObjectSelection2.getCorrespondentNode().getObject(), bl, false))).toString())) continue;
                    this.appendRestorePKDefinition(stringBuffer, tableProxyOraclev9i2, bl, (StringBuffer)object, compareObjectSelection2.getCorrespondentNode());
                    continue;
                }
                if (((Index)compareObjectSelection2.getObject()).isPK() && compareObjectSelection2.isSelected()) {
                    object = this.getColumnsForRestore(compareObjectSelection, (Index)compareObjectSelection2.getObject(), bl, false);
                    if (!this.isNotEmpty(((StringBuffer)object).toString())) continue;
                    this.appendPKDefinition(stringBuffer, tableProxyOraclev9i, (Index)compareObjectSelection2.getObject(), (StringBuffer)object, bl);
                    continue;
                }
                object = this.getColumnsForRestore(compareObjectSelection.getCorrespondentNode(), (Index)compareObjectSelection2.getCorrespondentNode().getObject(), bl, false);
                if (!this.isNotEmpty(((StringBuffer)object).toString())) continue;
                this.appendPKDefinition(stringBuffer, tableProxyOraclev9i2, (Index)compareObjectSelection2.getCorrespondentNode().getObject(), (StringBuffer)object, bl);
                continue;
            }
            object = compareObjectSelection2.getCorrespondentNode();
            if ((Index)compareObjectSelection2.getObject() == null) {
                if (compareObjectSelection2.isSelected()) continue;
                if (((Index)((ModelIdObjectSelection)object).getObject()).isUnique()) {
                    stringBuffer2 = this.getColumnsForRestore(compareObjectSelection.getCorrespondentNode(), (Index)compareObjectSelection2.getCorrespondentNode().getObject(), bl, false);
                    if (!this.isNotEmpty(stringBuffer2.toString())) continue;
                    uniqueOraclev9i = (UniqueOraclev9i)tableProxyOraclev9i2.getUniqueKeys().getObjectByID(((ModelIdObjectSelection)object).getObject().getObjectID());
                    this.appendUniqueDefinition(stringBuffer, tableProxyOraclev9i2, uniqueOraclev9i, bl, stringBuffer2);
                    continue;
                }
                stringBuffer2 = this.getColumnsForRestore(compareObjectSelection.getCorrespondentNode(), (Index)((ModelIdObjectSelection)object).getObject(), bl, true);
                if (!this.isNotEmpty(stringBuffer2.toString()) || !this.cssbIndex.canHandle(((ModelIdObjectSelection)object).getObject())) continue;
                this.cssbIndex.setRenamed(this.isRenamed());
                this.cssbIndex.setRestoredColumns(stringBuffer2);
                this.cssbIndex.setTableName(this.getTableName(this.tableObj));
                this.cssbIndex.doAppend(stringBuffer, ((ModelIdObjectSelection)object).getObject(), bl);
                continue;
            }
            if (((Index)compareObjectSelection2.getObject()).isUnique() && compareObjectSelection2.isSelected()) {
                stringBuffer2 = this.getColumnsForRestore(compareObjectSelection, (Index)compareObjectSelection2.getObject(), bl, false);
                if (!this.isNotEmpty(stringBuffer2.toString())) continue;
                uniqueOraclev9i = (UniqueOraclev9i)tableProxyOraclev9i.getUniqueKeys().getObjectByID(compareObjectSelection2.getObject().getObjectID());
                this.appendUniqueDefinition(stringBuffer, tableProxyOraclev9i, uniqueOraclev9i, bl, stringBuffer2);
                continue;
            }
            if (((Index)compareObjectSelection2.getCorrespondentNode().getObject()).isUnique()) {
                stringBuffer2 = this.getColumnsForRestore(compareObjectSelection.getCorrespondentNode(), (Index)compareObjectSelection2.getCorrespondentNode().getObject(), bl, false);
                if (!this.isNotEmpty(stringBuffer2.toString())) continue;
                uniqueOraclev9i = (UniqueOraclev9i)tableProxyOraclev9i2.getUniqueKeys().getObjectByID(((ModelIdObjectSelection)object).getObject().getObjectID());
                this.appendUniqueDefinition(stringBuffer, tableProxyOraclev9i2, uniqueOraclev9i, bl, stringBuffer2);
                continue;
            }
            stringBuffer2 = this.getColumnsForRestore(compareObjectSelection, (Index)compareObjectSelection2.getObject(), bl, true);
            if (!this.isNotEmpty(stringBuffer2.toString()) || !this.cssbIndex.canHandle(compareObjectSelection2.getObject())) continue;
            this.cssbIndex.setRenamed(this.isRenamed());
            this.cssbIndex.setRestoredColumns(stringBuffer2);
            this.cssbIndex.setTableName(this.getTableName(this.tableObj));
            this.cssbIndex.doAppend(stringBuffer, compareObjectSelection2.getObject(), bl);
        }
    }

    private void appendPKDefinition(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, Index index, StringBuffer stringBuffer2, boolean bl) {
        StringBuffer stringBuffer3 = new StringBuffer();
        String string = "";
        if (tableProxyOraclev9i != null) {
            Index index2;
            this.pk = this.getPKProxy(tableProxyOraclev9i);
            if (this.pk != null && this.pk.getObject() == index && ((index2 = this.pk.getIndex()).shouldBeMerge() || this.isRenamed()) && !this.hasNoMergeColumns(index2.getElements()) && !"".equalsIgnoreCase(this.pk.getColumns())) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
                if (this.pk.isCommentChanged() && !"".equalsIgnoreCase(this.pk.getComment())) {
                    this.appendComment(stringBuffer, this.pk);
                } else if (!"".equalsIgnoreCase(this.pk.getObject().getComment())) {
                    this.appendComment(stringBuffer, this.pk.getObject());
                }
                String string2 = this.pk.getName();
                if (string2.length() > tableProxyOraclev9i.getMaxNameLength()) {
                    CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "--  ERROR: PK name length exceeds maximum allowed length(" + tableProxyOraclev9i.getMaxNameLength() + ")");
                    CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
                    CDDLFileMaker.incrementErrors();
                }
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "ALTER");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "TABLE");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, this.getTableName(this.tableObj));
                CSSBCreateRenameTable.appendNewLine(stringBuffer3, bl, 1);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "ADD");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "CONSTRAINT");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, this.storageDesign.getFormatedName(string2));
                string = stringBuffer3.toString();
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "PRIMARY KEY");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, '(');
                if (!"".equals(index2.getIndexExpression())) {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, index2.getIndexExpression());
                } else {
                    this.appendStringWithSpace(stringBuffer3, stringBuffer2);
                }
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, ')');
                if (!"NO".equalsIgnoreCase(this.pk.getDeferrable())) {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "DEFERRABLE");
                    if ("DEFERRED".equalsIgnoreCase(this.pk.getInitially())) {
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "INITIALLY");
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "DEFERRED");
                    }
                }
                if (!"YES".equalsIgnoreCase(this.pk.getEnable())) {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "DISABLE");
                    if ("YES".equalsIgnoreCase(this.pk.getValidate())) {
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "VALIDATE");
                    }
                }
                if (!"YES".equalsIgnoreCase(this.pk.getValidate())) {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "NOVALIDATE");
                }
                if (!"NO".equalsIgnoreCase(this.pk.getUsingIndex())) {
                    this.appendUsingIndex(stringBuffer3, this.pk, bl);
                }
                this.appendToBuffer(stringBuffer, stringBuffer3, string);
                this.appendLineFinisher(stringBuffer3, bl);
                this.appendToBuffer(stringBuffer, stringBuffer3, string);
                CDDLFileMaker.incrementAlterTable();
            }
        }
    }

    private void appendRestorePKDefinition(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl, StringBuffer stringBuffer2, CompareObjectSelection compareObjectSelection) {
        StringBuffer stringBuffer3 = new StringBuffer();
        String string = "";
        if (tableProxyOraclev9i != null) {
            Index index;
            this.pk = this.getPKProxy(tableProxyOraclev9i);
            if (this.pk != null && ((index = this.pk.getIndex()).shouldBeMerge() || this.isRenamed()) && this.isNotEmpty(stringBuffer2.toString()) && !"".equalsIgnoreCase(this.pk.getColumns())) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
                if (this.pk.isCommentChanged() && !"".equalsIgnoreCase(this.pk.getComment())) {
                    this.appendComment(stringBuffer, this.pk);
                } else if (!"".equalsIgnoreCase(this.pk.getObject().getComment())) {
                    this.appendComment(stringBuffer, this.pk.getObject());
                }
                String string2 = this.storageDesign.getFormatedName(this.pk.getName());
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "ALTER");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "TABLE");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, this.getTableName(this.tableObj));
                CSSBCreateRenameTable.appendNewLine(stringBuffer3, bl, 1);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "ADD");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "CONSTRAINT");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, string2);
                string = stringBuffer3.toString();
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "PRIMARY KEY");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, '(');
                this.appendStringWithSpace(stringBuffer3, stringBuffer2);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, ')');
                if (!"NO".equalsIgnoreCase(this.pk.getDeferrable())) {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "DEFERRABLE");
                    if ("DEFERRED".equalsIgnoreCase(this.pk.getInitially())) {
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "INITIALLY");
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "DEFERRED");
                    }
                }
                if (!"YES".equalsIgnoreCase(this.pk.getEnable())) {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "DISABLE");
                    if ("YES".equalsIgnoreCase(this.pk.getValidate())) {
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "VALIDATE");
                    }
                }
                if (!"YES".equalsIgnoreCase(this.pk.getValidate())) {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "NOVALIDATE");
                }
                if (!"NO".equalsIgnoreCase(this.pk.getUsingIndex())) {
                    this.appendUsingIndex(stringBuffer3, this.pk, bl);
                }
                this.appendToBuffer(stringBuffer, stringBuffer3, string);
                CSSBCreateRenameTable.appendNewLine(stringBuffer3, bl, 0);
                this.appendLineFinisher(stringBuffer3, bl);
                this.appendToBuffer(stringBuffer, stringBuffer3, string);
                CDDLFileMaker.incrementAlterTable();
            }
        }
    }

    private void appendSupplementalLoggings(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        if (tableProxyOraclev9i != null && !"".equalsIgnoreCase(tableProxyOraclev9i.getSuplementalLogGroupName())) {
            this.appendComma(stringBuffer);
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "SUPPLEMENTAL");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "LOG");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "GROUP");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyOraclev9i.getSuplementalLogGroupName()));
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(tableProxyOraclev9i.getAllSuplementalLogColumns()));
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
            if (tableProxyOraclev9i.getSuplementalLogConditions().equalsIgnoreCase("ALWAYS")) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "ALWAYS");
            }
        }
    }

    @Override
    protected boolean appendTableConstraintsDefinition(StringBuffer stringBuffer, TableProxyOracle tableProxyOracle, boolean bl, boolean bl2) {
        return bl2;
    }

    private void appendUsingIndex(StringBuffer stringBuffer, PKProxyOraclev9i pKProxyOraclev9i, boolean bl) {
        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "USING INDEX");
        if ("BY INDEX NAME".equalsIgnoreCase(pKProxyOraclev9i.getUsingIndex()) && pKProxyOraclev9i.getExistingIndex() != null) {
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(pKProxyOraclev9i.getExistingIndex().getUserNameAndName()));
        } else {
            if ("LOCAL PARTITIONED".equalsIgnoreCase(pKProxyOraclev9i.getUsingIndex())) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "LOCAL");
            } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(pKProxyOraclev9i.getUsingIndex())) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, pKProxyOraclev9i.getCreateIndexStatement());
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
            } else if ("GLOBAL PARTITIONED".equalsIgnoreCase(pKProxyOraclev9i.getUsingIndex())) {
                this.appendGlobalIndex(stringBuffer, pKProxyOraclev9i, bl);
            }
            if (pKProxyOraclev9i.getIndexSegment() != null) {
                this.appendSegment(stringBuffer, (SegmentOraclev9i)pKProxyOraclev9i.getIndexSegment(), false, bl, pKProxyOraclev9i.getTableSpace(), pKProxyOraclev9i.getLogging());
            } else {
                if (pKProxyOraclev9i.getTableSpace() != null) {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(pKProxyOraclev9i.getTableSpace().getName()));
                    CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                }
                if (this.storageDesign.isOpen()) {
                    if ("YES".equalsIgnoreCase(pKProxyOraclev9i.getLogging())) {
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "LOGGING");
                        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                    } else if ("NO".equalsIgnoreCase(pKProxyOraclev9i.getLogging())) {
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "NOLOGGING");
                        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                    }
                }
            }
            if (pKProxyOraclev9i.getIndexSort().equalsIgnoreCase("NO")) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "NOSORT");
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            } else if (pKProxyOraclev9i.getIndexSort().equalsIgnoreCase("REVERSE")) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "REVERSE");
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            }
            if (pKProxyOraclev9i.getComputeStatistics().equalsIgnoreCase("YES")) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "COMPUTE STATISTICS");
            }
        }
    }

    private void appendUniqueUsingIndex(StringBuffer stringBuffer, UniqueOraclev9i uniqueOraclev9i, boolean bl) {
        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "USING INDEX");
        if ("BY INDEX NAME".equalsIgnoreCase(uniqueOraclev9i.getUsingIndex()) && uniqueOraclev9i.getExistingIndex() != null) {
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(uniqueOraclev9i.getExistingIndex().getUserNameAndName()));
        } else {
            if ("LOCAL PARTITIONED".equalsIgnoreCase(uniqueOraclev9i.getUsingIndex())) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "LOCAL");
            } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(uniqueOraclev9i.getUsingIndex())) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, uniqueOraclev9i.getCreateIndexStatement());
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
            } else if (uniqueOraclev9i.getUsingIndex().equalsIgnoreCase("GLOBAL PARTITIONED")) {
                this.appendUniqueGlobalIndex(stringBuffer, uniqueOraclev9i, bl);
            }
            if (uniqueOraclev9i.getIndexSegment() != null) {
                this.appendSegment(stringBuffer, (SegmentOraclev9i)uniqueOraclev9i.getIndexSegment(), false, bl, uniqueOraclev9i.getTableSpace(), uniqueOraclev9i.getLogging());
            } else {
                if (uniqueOraclev9i.getTableSpace() != null) {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(uniqueOraclev9i.getTableSpace().getName()));
                    CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                }
                if ("YES".equalsIgnoreCase(uniqueOraclev9i.getLogging())) {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "LOGGING");
                    CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                } else if ("NO".equalsIgnoreCase(uniqueOraclev9i.getLogging())) {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "NOLOGGING");
                    CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                }
            }
            if (uniqueOraclev9i.getIndexSort().equalsIgnoreCase("NO")) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "NOSORT");
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            } else if (uniqueOraclev9i.getIndexSort().equalsIgnoreCase("REVERSE")) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "REVERSE");
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            }
            if (uniqueOraclev9i.getComputeStatistics().equalsIgnoreCase("YES")) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "COMPUTE STATISTICS");
            }
        }
    }

    private void appendUniqueGlobalIndex(StringBuffer stringBuffer, UniqueOraclev9i uniqueOraclev9i, boolean bl) {
        if (uniqueOraclev9i.getUsingIndexGlobalPL() != null) {
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "GLOBAL");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "PARTITION");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "BY");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "RANGE");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(uniqueOraclev9i.getUsingIndexGlobalPL().getAllGlobalPartColumns()));
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
            this.appendGlobalPartitions(stringBuffer, (IndexGlobalPartitionsListOraclev9i)uniqueOraclev9i.getUsingIndexGlobalPL(), bl);
        }
    }

    private void appendGlobalIndex(StringBuffer stringBuffer, PKProxyOraclev9i pKProxyOraclev9i, boolean bl) {
        if (pKProxyOraclev9i.getIndexGlobalPL() != null) {
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "GLOBAL");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "PARTITION");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "BY");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "RANGE");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(pKProxyOraclev9i.getIndexGlobalPL().getAllGlobalPartColumns()));
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
            this.appendGlobalPartitions(stringBuffer, (IndexGlobalPartitionsListOraclev9i)pKProxyOraclev9i.getIndexGlobalPL(), bl);
        }
    }

    private void appendGlobalPartitions(StringBuffer stringBuffer, IndexGlobalPartitionsListOraclev9i indexGlobalPartitionsListOraclev9i, boolean bl) {
        IndexGlobalPartitionSetOraclev9i indexGlobalPartitionSetOraclev9i = (IndexGlobalPartitionSetOraclev9i)((StorageDesignOraclev9i)indexGlobalPartitionsListOraclev9i.getStorageDesign()).getIndexGlobalPartitionSet();
        Object[] objectArray = indexGlobalPartitionSetOraclev9i.toArray();
        Arrays.sort(objectArray, new GlobalPossitionComparator());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        Iterator iterator = arrayList.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            IndexGlobalPartitionOraclev9i indexGlobalPartitionOraclev9i = (IndexGlobalPartitionOraclev9i)iterator.next();
            if (indexGlobalPartitionOraclev9i.getIndexGlobalPartList() == null || !indexGlobalPartitionOraclev9i.getIndexGlobalPartList().toString().equalsIgnoreCase(indexGlobalPartitionsListOraclev9i.toString())) continue;
            if (bl2) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                bl2 = false;
            } else {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ',');
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            }
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "PARTITION");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexGlobalPartitionOraclev9i.getName()));
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "VALUES LESS THAN");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, indexGlobalPartitionOraclev9i.getValueList());
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
            if (indexGlobalPartitionOraclev9i.getSegment() != null) {
                this.appendSegment(stringBuffer, (SegmentOraclev9i)indexGlobalPartitionOraclev9i.getSegment(), false, bl, indexGlobalPartitionOraclev9i.getTableSpace(), indexGlobalPartitionOraclev9i.getLogging());
                continue;
            }
            if (indexGlobalPartitionOraclev9i.getTableSpace() != null) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(indexGlobalPartitionOraclev9i.getTableSpace().getName()));
            }
            if (!this.storageDesign.isOpen()) continue;
            if ("YES".equalsIgnoreCase(indexGlobalPartitionOraclev9i.getLogging())) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 2);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "LOGGING");
                continue;
            }
            if (!"NO".equalsIgnoreCase(indexGlobalPartitionOraclev9i.getLogging())) continue;
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 2);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "NOLOGGING");
        }
        if (!bl2) {
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected void appendTableCommentOn(StringBuffer stringBuffer, Table table, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        block4: {
            StringBuffer stringBuffer2;
            block3: {
                stringBuffer2 = new StringBuffer();
                if (tableProxyOraclev9i == null) break block3;
                this.appendCommentOn(stringBuffer2, tableProxyOraclev9i, bl);
                this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
                ColumnProxy[] columnProxyArray = tableProxyOraclev9i.getColumnProxies();
                ColumnProxy columnProxy = null;
                for (int i = 0; i < columnProxyArray.length; ++i) {
                    columnProxy = columnProxyArray[i];
                    String string = "";
                    string = columnProxy.getCommentInRDBMS() != null && columnProxy.isCommentInRDBMSChanged() ? columnProxy.getCommentInRDBMS() : columnProxy.getColumn().getCommentInRDBMS();
                    if (string.equalsIgnoreCase("")) continue;
                    CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 0);
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "COMMENT ON");
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "COLUMN");
                    String string2 = this.storageDesign.getFormatedName(tableProxyOraclev9i.getLongName()) + '.' + this.storageDesign.getFormatedName(columnProxy.getName());
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, string2);
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "IS");
                    CSSBCreateRenameTable.appendString(stringBuffer2, '\'');
                    CSSBCreateRenameTable.appendString(stringBuffer2, this.replaceSingleQuote(string));
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, '\'');
                    this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
                    CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 0);
                    this.appendLineFinisher(stringBuffer2, bl);
                    this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
                }
                break block4;
            }
            if (table == null) break block4;
            if (table.getCommentInRDBMS() != null && !"".equalsIgnoreCase(table.getCommentInRDBMS())) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 0);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "COMMENT ON");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "TABLE");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(table.getLongName()));
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "IS");
                CSSBCreateRenameTable.appendString(stringBuffer2, '\'');
                CSSBCreateRenameTable.appendString(stringBuffer2, this.replaceSingleQuote(table.getCommentInRDBMS()));
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, '\'');
                this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
                CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 0);
                this.appendLineFinisher(stringBuffer2, bl);
                this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
            }
            ContainedObject[] containedObjectArray = table.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                Column column = (Column)containedObjectArray[i];
                if (column.getCommentInRDBMS() == null || "".equalsIgnoreCase(column.getCommentInRDBMS())) continue;
                CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 0);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "COMMENT ON");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "COLUMN");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(column.getLongName()));
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "IS");
                CSSBCreateRenameTable.appendString(stringBuffer2, '\'');
                CSSBCreateRenameTable.appendString(stringBuffer2, this.replaceSingleQuote(column.getCommentInRDBMS()));
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, '\'');
                this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
                CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 0);
                this.appendLineFinisher(stringBuffer2, bl);
                this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
            }
        }
    }

    private void appendPartitionList(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        PartitionListOraclev9i partitionListOraclev9i = (PartitionListOraclev9i)tableProxyOraclev9i.getPartitionList();
        if (partitionListOraclev9i != null) {
            String string = partitionListOraclev9i.getPartitionType();
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            if ("RANGE".equalsIgnoreCase(string)) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "PARTITION");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "BY");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "RANGE");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getColumnList()));
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
                this.appendPartitions(stringBuffer, partitionListOraclev9i, false, bl);
            } else if ("COMPOSITE BY HASH".equalsIgnoreCase(string)) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "PARTITION");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "BY");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "RANGE");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getColumnList()));
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "BY");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "HASH");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getSubPartitionsColumnList()));
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
                if ("NO".equals(partitionListOraclev9i.getUseSubpartStorageTemplate())) {
                    if (partitionListOraclev9i.getSubPartitionsQuantity() > 1 || !"".equals(partitionListOraclev9i.getSubPartitionsTableSpaces())) {
                        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "SUBPARTITIONS");
                        this.appendStringWithSpace(stringBuffer, partitionListOraclev9i.getSubPartitionsQuantity());
                        if (!"".equals(partitionListOraclev9i.getSubPartitionsTableSpaces())) {
                            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "STORE IN");
                            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getAllSubPartitionsTableSpaces()));
                            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
                        }
                    }
                } else {
                    this.appendHashSubPartitionTemplates(stringBuffer, tableProxyOraclev9i, bl);
                }
                this.appendPartitions(stringBuffer, partitionListOraclev9i, true, bl);
            } else if ("COMPOSITE BY LIST".equalsIgnoreCase(string)) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "PARTITION");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "BY");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "RANGE");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getColumnList()));
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "BY");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "LIST");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getSubPartitionsColumnList()));
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
                this.appendListSubPartitionTemplates(stringBuffer, tableProxyOraclev9i, bl);
                this.appendPartitions(stringBuffer, partitionListOraclev9i, true, bl);
            } else if ("HASH BY QUANTITY".equalsIgnoreCase(string)) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "PARTITION");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "BY");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "HASH");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getColumnList()));
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "PARTITIONS");
                this.appendStringWithSpace(stringBuffer, partitionListOraclev9i.getHashPQuantity());
                if (!"".equals(partitionListOraclev9i.getHashPTableSpaces())) {
                    CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "STORE IN");
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getAllHashPTableSpaces()));
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
                }
                if (!"".equals(partitionListOraclev9i.getIOTOverflowHashPTS())) {
                    CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "OVERFLOW");
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "STORE IN");
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getAllIOTOverflowHashPTS()));
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
                }
            } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(string)) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "PARTITION");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "BY");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "HASH");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getColumnList()));
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
                this.appendHashPartitions(stringBuffer, tableProxyOraclev9i, bl);
            } else if ("LIST".equalsIgnoreCase(string)) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "PARTITION");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "BY");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "LIST");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionListOraclev9i.getColumnList()));
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
                this.appendListPartitions(stringBuffer, tableProxyOraclev9i, bl);
            }
        }
    }

    private void appendListSubPartitionTemplates(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        StorageObjectCollection storageObjectCollection = tableProxyOraclev9i.getListStorageTemplates();
        if (storageObjectCollection.size() > 0) {
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "SUBPARTITION");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "TEMPLATE");
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
            for (int i = 0; i < storageObjectCollection.size(); ++i) {
                ListStorageTemplatePartitionOraclev9i listStorageTemplatePartitionOraclev9i = (ListStorageTemplatePartitionOraclev9i)storageObjectCollection.getElement(i);
                if (i > 0) {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ',');
                }
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 2);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listStorageTemplatePartitionOraclev9i.getName()));
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "VALUES");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                if (!"".equalsIgnoreCase(listStorageTemplatePartitionOraclev9i.getValueList())) {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, listStorageTemplatePartitionOraclev9i.getValueList());
                } else {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "DEFAULT");
                }
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
                this.appendPartStorage(stringBuffer, listStorageTemplatePartitionOraclev9i, bl);
            }
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendHashSubPartitionTemplates(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        if (tableProxyOraclev9i.getListStorageTemplates().size() > 0) {
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "SUBPARTITION");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "TEMPLATE");
            Iterator iterator = tableProxyOraclev9i.getListStorageTemplates().iterator();
            boolean bl2 = true;
            while (iterator.hasNext()) {
                HashPartitionOraclev9i hashPartitionOraclev9i = (HashPartitionOraclev9i)iterator.next();
                if (bl2) {
                    CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                    bl2 = false;
                } else {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ',');
                }
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOraclev9i.getName()));
                this.appendPartStorage(stringBuffer, hashPartitionOraclev9i, bl);
            }
            if (!bl2) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private void appendPartStorage(StringBuffer stringBuffer, AbstractStorageObjectOracle abstractStorageObjectOracle, boolean bl) {
        TableSpaceOracle tableSpaceOracle = null;
        TableSpaceOracle tableSpaceOracle2 = null;
        StorageObjectCollection storageObjectCollection = null;
        if (abstractStorageObjectOracle instanceof HashPartitionOraclev9i) {
            tableSpaceOracle = ((HashPartitionOraclev9i)abstractStorageObjectOracle).getTableSpace();
            tableSpaceOracle2 = ((HashPartitionOraclev9i)abstractStorageObjectOracle).getIotOverflowTablespace();
            storageObjectCollection = ((HashPartitionOraclev9i)abstractStorageObjectOracle).getLobs();
        } else if (abstractStorageObjectOracle instanceof ListStorageTemplatePartitionOraclev9i) {
            tableSpaceOracle = ((ListStorageTemplatePartitionOraclev9i)abstractStorageObjectOracle).getTablespace();
            storageObjectCollection = ((ListStorageTemplatePartitionOraclev9i)abstractStorageObjectOracle).getLobs();
        }
        if (tableSpaceOracle != null) {
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 2);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
        }
        if (tableSpaceOracle2 != null) {
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 2);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "OVERFLOW");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle2.getName()));
        }
        if (storageObjectCollection != null) {
            Iterator iterator = storageObjectCollection.iterator();
            while (iterator.hasNext()) {
                AbstractStorageObjectOracle abstractStorageObjectOracle2;
                Object e = iterator.next();
                if (e instanceof LobStorageOraclev9i) {
                    abstractStorageObjectOracle2 = (LobStorageOraclev9i)e;
                    if (((LobStorageOracle)abstractStorageObjectOracle2).getTableSpace() == null && ((LobStorageOracle)abstractStorageObjectOracle2).getLobSegmentName().trim().equals("")) continue;
                    CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 2);
                    this.appendLobPartitioningStorage(stringBuffer, abstractStorageObjectOracle2.getName(), ((LobStorageOracle)abstractStorageObjectOracle2).getColumn(), ((LobStorageOracle)abstractStorageObjectOracle2).getLobSegmentName(), ((LobStorageOracle)abstractStorageObjectOracle2).getTableSpace(), bl);
                    continue;
                }
                if (!(e instanceof HashPartitionLobItemOraclev9i) || ((HashPartitionLobItemOracle)(abstractStorageObjectOracle2 = (HashPartitionLobItemOraclev9i)e)).getTableSpace() == null) continue;
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 2);
                this.appendLobPartitioningStorage(stringBuffer, abstractStorageObjectOracle2.getName(), ((HashPartitionLobItemOracle)abstractStorageObjectOracle2).getLobColumn(), "", ((HashPartitionLobItemOracle)abstractStorageObjectOracle2).getTableSpace(), bl);
            }
        }
    }

    private void appendListPartitions(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        Iterator iterator = tableProxyOraclev9i.getPartitions().iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            Table table;
            ListPartitionOraclev9i listPartitionOraclev9i = (ListPartitionOraclev9i)iterator.next();
            if (bl2) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                bl2 = false;
            } else {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ',');
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            }
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "PARTITION");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listPartitionOraclev9i.getName()));
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "VALUES");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
            if (!"".equalsIgnoreCase(listPartitionOraclev9i.getColumns())) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, listPartitionOraclev9i.getColumns());
            } else {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "DEFAULT");
            }
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
            if (listPartitionOraclev9i.getSegment() != null) {
                this.appendSegment(stringBuffer, (SegmentOraclev9i)listPartitionOraclev9i.getSegment(), true, bl, listPartitionOraclev9i.getTablespace(), listPartitionOraclev9i.getLogging());
            }
            if (listPartitionOraclev9i.getDataSegmentCompression().equalsIgnoreCase("NO")) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "NOCOMPRESS");
            } else if (listPartitionOraclev9i.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "COMPRESS");
            }
            if (listPartitionOraclev9i.getSegment() == null) {
                if (listPartitionOraclev9i.getTablespace() != null) {
                    CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listPartitionOraclev9i.getTablespace().getName()));
                }
                if (this.storageDesign.isOpen()) {
                    if (listPartitionOraclev9i.getLogging().equalsIgnoreCase("YES")) {
                        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "LOGGING");
                    } else if (listPartitionOraclev9i.getLogging().equalsIgnoreCase("NO")) {
                        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "NOLOGGING");
                    }
                }
            }
            if ((table = (Table)this.tableObj.getObject()).isSpatialTable()) continue;
            Iterator iterator2 = listPartitionOraclev9i.getLobStorages().iterator();
            while (iterator2.hasNext()) {
                LobStorageOracle lobStorageOracle = (LobStorageOracle)iterator2.next();
                this.appendLobStorage(stringBuffer, (LobStorageOraclev9i)lobStorageOracle, bl);
            }
        }
        if (!bl2) {
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendPartitions(StringBuffer stringBuffer, PartitionListOraclev9i partitionListOraclev9i, boolean bl, boolean bl2) {
        PartitionSetOracle partitionSetOracle = ((StorageDesignOraclev9i)partitionListOraclev9i.getStorageDesign()).getPartitionSet();
        Object[] objectArray = partitionSetOracle.toArray();
        Arrays.sort(objectArray, new PossitionComparator());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add(objectArray[i]);
        }
        Iterator iterator = arrayList.iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            Object object;
            PartitionOracle partitionOracle = (PartitionOracle)iterator.next();
            if (partitionOracle.getPartitionList() == null || partitionOracle.getPartitionList() != partitionListOraclev9i) continue;
            if (bl3) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 1);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 1);
                bl3 = false;
            } else {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ',');
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 1);
            }
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "PARTITION");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(partitionOracle.getName()));
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "VALUES LESS THAN");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, partitionOracle.getValueList());
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
            if (partitionOracle.getSegment() != null) {
                this.appendSegment(stringBuffer, (SegmentOraclev9i)partitionOracle.getSegment(), true, bl2, partitionOracle.getTableSpace(), partitionOracle.getLogging());
            } else if (partitionOracle.getIOTOverflowSegment() != null) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "OVERFLOW");
                this.appendSegment(stringBuffer, (SegmentOraclev9i)partitionOracle.getIOTOverflowSegment(), true, bl2, partitionOracle.getTableSpace(), partitionOracle.getLogging());
            } else {
                if (partitionOracle.getTableSpace() != null) {
                    CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 2);
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(partitionOracle.getTableSpace().getName()));
                }
                if (partitionOracle.getLogging().equalsIgnoreCase("NO")) {
                    CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 2);
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "NOLOGGING");
                } else if (partitionOracle.getLogging().equalsIgnoreCase("YES")) {
                    CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 2);
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "LOGGING");
                }
            }
            Table table = (Table)this.tableObj.getObject();
            if (!table.isSpatialTable()) {
                Iterator iterator2 = partitionOracle.getLobs().iterator();
                while (iterator2.hasNext()) {
                    object = (LobStorageOracle)iterator2.next();
                    this.appendLobStorage(stringBuffer, (LobStorageOraclev9i)object, bl2);
                }
            }
            if (!bl || this.appendHashSubPartitions(stringBuffer, (PartitionOraclev9i)partitionOracle, partitionListOraclev9i, bl2)) continue;
            if (partitionOracle.getSubPartitionsQuantity() > 0) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 1);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "SUBPARTITIONS");
                this.appendStringWithSpace(stringBuffer, partitionOracle.getSubPartitionsQuantity());
                if ("".equalsIgnoreCase(partitionOracle.getSubPartitionsTableSpaces())) continue;
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 1);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "STORE IN");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(partitionOracle.getAllSubPartitionsTableSpaces()));
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
                continue;
            }
            if (partitionOracle.getListPartitions().size() <= 0) continue;
            boolean bl4 = true;
            object = partitionOracle.getListPartitions().iterator();
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
            while (object.hasNext()) {
                ListStorageTemplatePartitionOraclev9i listStorageTemplatePartitionOraclev9i = (ListStorageTemplatePartitionOraclev9i)object.next();
                if (!bl4) {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ',');
                } else {
                    bl4 = false;
                }
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 2);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(listStorageTemplatePartitionOraclev9i.getName()));
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "VALUES");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, listStorageTemplatePartitionOraclev9i.getValueList());
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
                this.appendPartStorage(stringBuffer, listStorageTemplatePartitionOraclev9i, bl2);
            }
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
        }
        if (!bl3) {
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private boolean appendHashSubPartitions(StringBuffer stringBuffer, PartitionOraclev9i partitionOraclev9i, PartitionListOraclev9i partitionListOraclev9i, boolean bl) {
        boolean bl2 = false;
        if (partitionListOraclev9i.getUseSubpartStorageTemplate().equalsIgnoreCase("NO")) {
            HashPartitionSetOracle hashPartitionSetOracle = ((StorageDesignOracle)partitionOraclev9i.getStorageDesign()).getHashPartitionSet();
            Iterator iterator = hashPartitionSetOracle.iterator();
            boolean bl3 = true;
            while (iterator.hasNext()) {
                HashPartitionOraclev9i hashPartitionOraclev9i = (HashPartitionOraclev9i)iterator.next();
                if (hashPartitionOraclev9i.getSubPartitionOf() != partitionOraclev9i) continue;
                if (bl3) {
                    CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                    bl3 = false;
                    bl2 = true;
                } else {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ',');
                    CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                }
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "SUBPARTITION");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOraclev9i.getName()));
                this.appendPartStorage(stringBuffer, hashPartitionOraclev9i, bl);
            }
            if (!bl3) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
            }
        }
        return bl2;
    }

    private boolean appendHashPartitions(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        boolean bl2 = false;
        Iterator iterator = tableProxyOraclev9i.getPartitions().iterator();
        boolean bl3 = true;
        while (iterator.hasNext()) {
            HashPartitionOraclev9i hashPartitionOraclev9i = (HashPartitionOraclev9i)iterator.next();
            if (bl3) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                bl3 = false;
                bl2 = true;
            } else {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ',');
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            }
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "PARTITION");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOraclev9i.getName()));
            if (hashPartitionOraclev9i.getTableSpace() != null) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(hashPartitionOraclev9i.getTableSpace().getName()));
            }
            this.appendHashPLobItems(stringBuffer, hashPartitionOraclev9i, bl);
        }
        if (!bl3) {
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
        }
        return bl2;
    }

    private void appendHashPLobItems(StringBuffer stringBuffer, HashPartitionOraclev9i hashPartitionOraclev9i, boolean bl) {
        HashPartitionLobItemSetOraclev9i hashPartitionLobItemSetOraclev9i = (HashPartitionLobItemSetOraclev9i)((StorageDesignOraclev9i)hashPartitionOraclev9i.getStorageDesign()).getHashPartitionLobItemSet();
        Iterator iterator = hashPartitionLobItemSetOraclev9i.iterator();
        while (iterator.hasNext()) {
            HashPartitionLobItemOraclev9i hashPartitionLobItemOraclev9i = (HashPartitionLobItemOraclev9i)iterator.next();
            if (hashPartitionLobItemOraclev9i.getHashPartition() == null || !hashPartitionLobItemOraclev9i.getHashPartition().toString().equalsIgnoreCase(hashPartitionOraclev9i.toString())) continue;
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 2);
            this.appendLobPartitioningStorage(stringBuffer, hashPartitionLobItemOraclev9i.getName(), hashPartitionLobItemOraclev9i.getLobColumn(), "", hashPartitionLobItemOraclev9i.getTableSpace(), bl);
        }
    }

    private void appendLobPartitioningStorage(StringBuffer stringBuffer, String string, Object object, String string2, TableSpaceOracle tableSpaceOracle, boolean bl) {
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "LOB");
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
        String string3 = "";
        if (object != null) {
            string3 = object.toString();
        }
        if (string3.length() > 0) {
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string3));
        } else {
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
            stringBuffer.append("--  ERROR: Lob ");
            stringBuffer.append(string);
            stringBuffer.append(" has no Column specified");
            CDDLFileMaker.incrementErrors();
        }
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "STORE AS");
        if (!string2.equalsIgnoreCase("")) {
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string2));
        } else if (tableSpaceOracle == null) {
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
        }
        if (tableSpaceOracle != null) {
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendLobStorage(StringBuffer stringBuffer, LobStorageOraclev9i lobStorageOraclev9i, boolean bl) {
        if (lobStorageOraclev9i != null) {
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "LOB");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(lobStorageOraclev9i.getColumn()));
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "STORE AS");
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 2);
            if (lobStorageOraclev9i.getTableSpace() != null) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(lobStorageOraclev9i.getTableSpace().getName()));
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 2);
            }
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "STORAGE");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 3);
            if (lobStorageOraclev9i.getSCInitialExtent() > 0L) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getSCInitialExtent());
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 3);
            }
            if (lobStorageOraclev9i.getSCNextExtent() > 0L) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getSCNextExtent());
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 3);
            }
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getSCPctIncrease());
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 3);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "MINEXTENTS");
            this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getSCMinExtents());
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 3);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getSCMaxExtents());
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 3);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "FREELISTS");
            this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getSCFreeLists());
            if (lobStorageOraclev9i.getSCFreelistGroups() > 1) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 3);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "FREELIST");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "GROUPS");
                this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getSCFreelistGroups());
            }
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 3);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "BUFFER_POOL");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getSCBufferPool());
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 2);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 2);
            if (lobStorageOraclev9i.getChunk() > 0) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "CHUNK");
                this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getChunk());
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 2);
            }
            if (lobStorageOraclev9i.getOldVersions().equalsIgnoreCase("RETENTION")) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "RETENTION");
            } else {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "PCTVERSION");
                this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getPCTVersion());
            }
            if (lobStorageOraclev9i.getSCFreelistGroups() <= 1 && lobStorageOraclev9i.getFreepools() > 0) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 2);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "FREEPOOLS");
                this.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getFreepools());
            }
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 2);
            if ("ENABLE".equalsIgnoreCase(lobStorageOraclev9i.getStorageInRow())) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "ENABLE");
            } else {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "DISABLE");
            }
            stringBuffer.append("STORAGE IN ROW");
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 2);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, lobStorageOraclev9i.getCache());
            if (!"CACHE".equalsIgnoreCase(lobStorageOraclev9i.getCache())) {
                if ("YES".equalsIgnoreCase(lobStorageOraclev9i.getLogging())) {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(lobStorageOraclev9i.getLogging())) {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "NOLOGGING");
                }
            }
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendSegment(StringBuffer stringBuffer, SegmentOraclev9i segmentOraclev9i, boolean bl, boolean bl2, TableSpaceOracle tableSpaceOracle, String string) {
        if (segmentOraclev9i != null) {
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 2);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "PCTFREE");
            this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getPCTFree());
            if (bl) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 2);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "PCTUSED");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getPCTUsed());
            }
            if (segmentOraclev9i.getInitrans() > 1) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 2);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "INITRANS");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getInitrans());
            }
            if (segmentOraclev9i.getMaxTrans() > 1) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 2);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "MAXTRANS");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getMaxTrans());
            }
            if (tableSpaceOracle != null) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 2);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
            } else if (segmentOraclev9i.getTableSpace() != null) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 2);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(segmentOraclev9i.getTableSpace().getName()));
            }
            if (!"".equals(string)) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 2);
                if (string.equalsIgnoreCase("NO")) {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "NOLOGGING");
                } else {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "LOGGING");
                }
            }
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 2);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "STORAGE");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 2);
            if (segmentOraclev9i.getSCInitialExtent() > 0L) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCInitialExtent());
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 2);
            }
            if (segmentOraclev9i.getSCNextExtent() > 0L) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCNextExtent());
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 2);
            }
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCPctIncrease());
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 2);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "MINEXTENTS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCMinExtents());
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 2);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCMaxExtents());
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 2);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "FREELISTS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCFreeLists());
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 2);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "FREELIST");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "GROUPS");
            this.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCFreelistGroups());
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 2);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "BUFFER_POOL");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, segmentOraclev9i.getSCBufferPool());
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl2, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendTableSpace(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        TableSpaceOracle tableSpaceOracle = tableProxyOraclev9i.getTableSpace();
        if (tableSpaceOracle != null && !"[NONE]".equalsIgnoreCase(tableSpaceOracle.getName())) {
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "TABLESPACE");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableSpaceOracle.getName()));
        }
    }

    private void appendOrganization(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        if ("INDEX".equalsIgnoreCase(tableProxyOraclev9i.getOrganization())) {
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "ORGANIZATION");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "INDEX");
        }
        if (tableProxyOraclev9i.getSegment() == null) {
            this.appendTableSpace(stringBuffer, tableProxyOraclev9i, bl);
            if ("YES".equalsIgnoreCase(tableProxyOraclev9i.getLogging())) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "LOGGING");
            } else if ("NO".equalsIgnoreCase(tableProxyOraclev9i.getLogging())) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "NOLOGGING");
            }
        } else {
            this.appendSegment(stringBuffer, (SegmentOraclev9i)tableProxyOraclev9i.getSegment(), true, bl, tableProxyOraclev9i.getTableSpace(), tableProxyOraclev9i.getLogging());
        }
        if ("INDEX".equalsIgnoreCase(tableProxyOraclev9i.getOrganization())) {
            SegmentOraclev9i segmentOraclev9i;
            if (tableProxyOraclev9i.getIOTMappingTable().equalsIgnoreCase("YES")) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "MAPPING TABLE");
            }
            if (tableProxyOraclev9i.getIotPctThreshold() > 0) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "PCTTHRESHOLD");
                this.appendStringWithSpace(stringBuffer, tableProxyOraclev9i.getIotPctThreshold());
            }
            if (tableProxyOraclev9i.getIotCompress() > 0) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "COMPRESS");
                this.appendStringWithSpace(stringBuffer, tableProxyOraclev9i.getIotCompress());
            }
            if ((segmentOraclev9i = (SegmentOraclev9i)tableProxyOraclev9i.getIotOverflowSegment()) != null || tableProxyOraclev9i.getIotIncluding() != null) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                if (tableProxyOraclev9i.getIotIncluding() != null) {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "INCLUDING");
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableProxyOraclev9i.getIotIncluding().getName()));
                    CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                }
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "OVERFLOW");
                if (segmentOraclev9i != null) {
                    TableSpaceOracle tableSpaceOracle = segmentOraclev9i.getTableSpace();
                    if (tableSpaceOracle == null) {
                        tableSpaceOracle = tableProxyOraclev9i.getTableSpace();
                    }
                    this.appendSegment(stringBuffer, segmentOraclev9i, true, bl, tableSpaceOracle, tableProxyOraclev9i.getLogging());
                }
            }
        } else if (tableProxyOraclev9i.getDataSegmentCompression().equalsIgnoreCase("YES")) {
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "COMPRESS");
        }
        if ("YES".equalsIgnoreCase(tableProxyOraclev9i.getPartitioned())) {
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            if ("ENABLE".equalsIgnoreCase(tableProxyOraclev9i.getParttitionedRowMovement())) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "ENABLE");
            } else {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "DISABLE");
            }
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "ROW MOVEMENT");
        }
    }

    private void appendCluster(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        ClusterOraclev9i clusterOraclev9i = (ClusterOraclev9i)tableProxyOraclev9i.getCluster();
        if (clusterOraclev9i != null) {
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "CLUSTER");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(clusterOraclev9i.getLongName()));
            if (!"".equalsIgnoreCase(tableProxyOraclev9i.getClusterColumns())) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormattedNameList(tableProxyOraclev9i.getAllClusterColumns()));
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
            }
        } else {
            this.appendOrganization(stringBuffer, tableProxyOraclev9i, bl);
            Table table = (Table)this.tableObj.getObject();
            if (!table.isSpatialTable()) {
                for (int i = 0; i < tableProxyOraclev9i.getLobStorages().size(); ++i) {
                    this.appendLobStorage(stringBuffer, (LobStorageOraclev9i)tableProxyOraclev9i.getLobStorages().getElement(i), bl);
                }
            }
        }
    }

    private void appendUniqueDefinition(StringBuffer stringBuffer, TableProxyOracle tableProxyOracle, UniqueOraclev9i uniqueOraclev9i, boolean bl, StringBuffer stringBuffer2) {
        StringBuffer stringBuffer3 = new StringBuffer();
        String string = "";
        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
        if (uniqueOraclev9i.isCommentChanged() && !"".equalsIgnoreCase(uniqueOraclev9i.getComment())) {
            this.appendComment(stringBuffer, uniqueOraclev9i);
        } else if (!"".equalsIgnoreCase(uniqueOraclev9i.getObject().getComment())) {
            this.appendComment(stringBuffer, uniqueOraclev9i.getObject());
        }
        String string2 = uniqueOraclev9i.getName();
        if (string2.length() > tableProxyOracle.getMaxNameLength()) {
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "--  ERROR: UK name length exceeds maximum allowed length(" + tableProxyOracle.getMaxNameLength() + ")");
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
            CDDLFileMaker.incrementErrors();
        }
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "ALTER");
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "TABLE");
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, this.getTableName(this.tableObj));
        CSSBCreateRenameTable.appendNewLine(stringBuffer3, bl, 1);
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "ADD");
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "CONSTRAINT");
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, this.storageDesign.getFormatedName(string2));
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "UNIQUE");
        string = stringBuffer3.toString();
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, '(');
        this.appendString(stringBuffer3, stringBuffer2);
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, ')');
        if (!"NO".equalsIgnoreCase(uniqueOraclev9i.getDeferrable())) {
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(uniqueOraclev9i.getInitially())) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "INITIALLY");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "DEFERRED");
            }
        }
        if (!"YES".equalsIgnoreCase(uniqueOraclev9i.getEnable())) {
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "DISABLE");
            if ("YES".equalsIgnoreCase(uniqueOraclev9i.getValidate())) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "VALIDATE");
            }
        }
        if (!"YES".equalsIgnoreCase(uniqueOraclev9i.getValidate())) {
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer3, "NOVALIDATE");
        }
        if (!"NO".equalsIgnoreCase(uniqueOraclev9i.getUsingIndex())) {
            this.appendUniqueUsingIndex(stringBuffer3, uniqueOraclev9i, bl);
        }
        this.appendToBuffer(stringBuffer, stringBuffer3, string);
        this.appendLineFinisher(stringBuffer3, bl);
        this.appendToBuffer(stringBuffer, stringBuffer3, string);
        CDDLFileMaker.incrementAlterTable();
    }

    private void appendPermissions(StringBuffer stringBuffer, TableProxyOracle tableProxyOracle, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        PermissionsSetOracle permissionsSetOracle = ((StorageDesignOracle)tableProxyOracle.getStorageDesign()).getPermissionsSet();
        Iterator iterator = permissionsSetOracle.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            PermissionsOraclev9i permissionsOraclev9i = (PermissionsOraclev9i)iterator.next();
            if (permissionsOraclev9i.getTable() != null && permissionsOraclev9i.getTable().equals(tableProxyOracle) && !permissionsOraclev9i.getPrivileges().equalsIgnoreCase("")) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
                this.appendComment(stringBuffer, permissionsOraclev9i);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "GRANT");
                this.appendPrivileges(stringBuffer2, permissionsOraclev9i);
                this.appendObject(stringBuffer2, permissionsOraclev9i, bl);
                this.appendTo(stringBuffer2, permissionsOraclev9i);
                this.appendHierrarchyOption(stringBuffer2, permissionsOraclev9i, bl);
                string = "GRANT ON " + this.getPermissionsON(permissionsOraclev9i) + " TO " + this.getPermissionsTO(permissionsOraclev9i);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 0);
                stringBuffer2.append(';');
                CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
            }
            if (permissionsOraclev9i.getTable() != null && permissionsOraclev9i.getTable().equals(tableProxyOracle) && !permissionsOraclev9i.getPrivilegesWithGrantOption().equalsIgnoreCase("")) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
                this.appendComment(stringBuffer, permissionsOraclev9i);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "GRANT");
                this.appendPrivilegesWithGrantOption(stringBuffer2, permissionsOraclev9i);
                this.appendObject(stringBuffer2, permissionsOraclev9i, bl);
                this.appendTo(stringBuffer2, permissionsOraclev9i);
                this.appendGrantOption(stringBuffer2, permissionsOraclev9i);
                this.appendHierrarchyOption(stringBuffer2, permissionsOraclev9i, bl);
                string = "GRANT ON " + this.getPermissionsON(permissionsOraclev9i) + " TO " + this.getPermissionsTO(permissionsOraclev9i);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 0);
                stringBuffer2.append(';');
                CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
            }
            if (permissionsOraclev9i.getColumnsTable() == null || !permissionsOraclev9i.getColumnsTable().equals(tableProxyOracle) || permissionsOraclev9i.getColumns().isEmpty()) continue;
            ArrayList arrayList = permissionsOraclev9i.getColumns();
            for (int i = 0; i < arrayList.size(); ++i) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
                this.appendComment(stringBuffer, permissionsOraclev9i);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "GRANT");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, permissionsOraclev9i.getPrivs((String)arrayList.get(i)).trim());
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, '(');
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(arrayList.get(i).toString()));
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, ')');
                this.appendObject(stringBuffer2, permissionsOraclev9i, bl);
                this.appendTo(stringBuffer2, permissionsOraclev9i);
                this.appendGrantOption(stringBuffer2, permissionsOraclev9i);
                this.appendHierrarchyOption(stringBuffer2, permissionsOraclev9i, bl);
                string = "GRANT ON " + this.getPermissionsON(permissionsOraclev9i) + " TO " + this.getPermissionsTO(permissionsOraclev9i);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
                CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 0);
                stringBuffer2.append(';');
                CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 0);
                this.appendToBuffer(stringBuffer, stringBuffer2, string);
            }
        }
        if (!bl2) {
            this.appendDropPackage(stringBuffer, this.storageDesign.getFormatedName(tableProxyOracle.getUser().getName()), bl);
        }
    }

    private String getPermissionsTO(PermissionsOraclev9i permissionsOraclev9i) {
        if (permissionsOraclev9i.getUser() != null) {
            return permissionsOraclev9i.getUser().getLongName();
        }
        if (permissionsOraclev9i.getRole() != null) {
            return permissionsOraclev9i.getRole().getLongName();
        }
        return "";
    }

    private String getPermissionsON(PermissionsOraclev9i permissionsOraclev9i) {
        if (permissionsOraclev9i.getTable() != null) {
            return permissionsOraclev9i.getTable().getLongName();
        }
        if (permissionsOraclev9i.getView() != null) {
            return permissionsOraclev9i.getView().getLongName();
        }
        if (permissionsOraclev9i.getSequence() != null) {
            return permissionsOraclev9i.getSequence().getLongName();
        }
        if (permissionsOraclev9i.getSnapshot() != null) {
            return permissionsOraclev9i.getSnapshot().getLongName();
        }
        if (permissionsOraclev9i.getProc() != null) {
            return permissionsOraclev9i.getProc().getLongName();
        }
        if (permissionsOraclev9i.getDirectoryOracle() != null) {
            return permissionsOraclev9i.getDirectoryOracle().getLongName();
        }
        if (permissionsOraclev9i.getStructuredTypeOracle() != null) {
            return permissionsOraclev9i.getStructuredTypeOracle().getLongName();
        }
        if (permissionsOraclev9i.getCollectionTypeOracle() != null) {
            return permissionsOraclev9i.getCollectionTypeOracle().getLongName();
        }
        if (permissionsOraclev9i.getExternalTableOracle() != null) {
            return permissionsOraclev9i.getExternalTableOracle().getLongName();
        }
        return "";
    }

    private void appendPrivileges(StringBuffer stringBuffer, PermissionsOraclev9i permissionsOraclev9i) {
        stringBuffer.append(permissionsOraclev9i.getPrivileges());
    }

    private void appendPrivilegesWithGrantOption(StringBuffer stringBuffer, PermissionsOraclev9i permissionsOraclev9i) {
        stringBuffer.append(permissionsOraclev9i.getPrivilegesWithGrantOption());
    }

    private void appendObject(StringBuffer stringBuffer, PermissionsOraclev9i permissionsOraclev9i, boolean bl) {
        if (permissionsOraclev9i.getTable() != null) {
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "ON");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.getTableName(this.tableObj));
        }
    }

    private void appendTo(StringBuffer stringBuffer, PermissionsOraclev9i permissionsOraclev9i) {
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "TO");
        if ("YES".equalsIgnoreCase(permissionsOraclev9i.getPublic())) {
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "PUBLIC");
        } else {
            if (permissionsOraclev9i.getUser() != null) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev9i.getUser().getName()));
            }
            if (permissionsOraclev9i.getRole() != null) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(permissionsOraclev9i.getRole().getName()));
            }
        }
    }

    private void appendGrantOption(StringBuffer stringBuffer, PermissionsOraclev9i permissionsOraclev9i) {
        if (permissionsOraclev9i.getRole() == null) {
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "WITH GRANT OPTION");
        }
    }

    private void appendHierrarchyOption(StringBuffer stringBuffer, PermissionsOraclev9i permissionsOraclev9i, boolean bl) {
        if ("YES".equalsIgnoreCase(permissionsOraclev9i.getHierarchyOption())) {
            CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "WITH HIERARCHY OPTION");
        }
    }

    private void appendDropPackage(StringBuffer stringBuffer, String string, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
        stringBuffer2.append("DROP PACKAGE ").append(string).append(".perm_manager;");
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
    }

    private void appendIndexes(StringBuffer stringBuffer, TableProxyOracle tableProxyOracle, CompareObjectSelection compareObjectSelection, boolean bl) {
        this.appendIndexes(stringBuffer, compareObjectSelection, bl);
        this.appendPKAndUK(stringBuffer, compareObjectSelection, bl);
    }

    private void appendTableLevelCheckConstraints(StringBuffer stringBuffer, TableSelection tableSelection, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        List list = tableSelection.getChildObjects(4);
        for (CompareObjectSelection compareObjectSelection : list) {
            TableCheckConstraintOracle tableCheckConstraintOracle;
            String string;
            TableLevelConstraint tableLevelConstraint;
            TableProxyOracle tableProxyOracle;
            TableComparator tableComparator = (TableComparator)tableSelection.getPropertiesComparator();
            if (!compareObjectSelection.isSelected()) {
                compareObjectSelection = compareObjectSelection.getCorrespondentNode();
                tableProxyOracle = (TableProxyOracle)tableComparator.getTargetTableProxy();
            } else {
                tableProxyOracle = (TableProxyOracle)tableComparator.getSourceTableProxy();
            }
            if ((tableLevelConstraint = (TableLevelConstraint)compareObjectSelection.getObject()) == null || tableProxyOracle == null || "".equals(string = tableLevelConstraint.getRule()) || (tableCheckConstraintOracle = tableProxyOracle.getTableConstraint(tableLevelConstraint)) == null) continue;
            String string2 = tableCheckConstraintOracle.getName();
            if (string2.toUpperCase().startsWith("SYS_")) {
                string2 = "";
            }
            CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 0);
            CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 0);
            if (string2.length() > tableCheckConstraintOracle.getMaxNameLength()) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, "--  ERROR: Table constraint name length exceeds maximum allowed length(" + tableCheckConstraintOracle.getMaxNameLength() + ")");
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
                CDDLFileMaker.incrementErrors();
            }
            String string3 = this.storageDesign.getFormatedName(string2);
            String string4 = this.storageDesign.getFormatedName(this.getTableName(tableSelection));
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "ALTER");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "TABLE");
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, string4);
            CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 1);
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "ADD");
            if (!"".equals(string2)) {
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "CONSTRAINT");
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, string3);
                CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 1);
            }
            CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "CHECK");
            CSSBCreateRenameTable.appendString(stringBuffer2, '(');
            CSSBCreateRenameTable.appendString(stringBuffer2, tableCheckConstraintOracle.getTableConstraint().getRule());
            CSSBCreateRenameTable.appendString(stringBuffer2, ')');
            this.appendTableConstraintState(stringBuffer2, tableCheckConstraintOracle, bl);
            String string5 = "Alter Table " + string4 + " Add Constraint " + string3;
            this.appendToBuffer(stringBuffer, stringBuffer2, string5);
            CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 0);
            stringBuffer2.append(';');
            CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 0);
            this.appendToBuffer(stringBuffer, stringBuffer2, "");
            CDDLFileMaker.incrementAlterTable();
        }
    }

    private StringBuffer getColumnsForRestore(CompareObjectSelection compareObjectSelection, Index index, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl3 = false;
        List list = compareObjectSelection.getChildObjects(0);
        block0: for (Column column : index.getElementsCollection()) {
            for (CompareObjectSelection compareObjectSelection2 : list) {
                ModelIDObject modelIDObject = compareObjectSelection2.getObject();
                if (modelIDObject == null || !modelIDObject.equals(column)) continue;
                if (compareObjectSelection2.canBeCreate() && !compareObjectSelection2.isSelected() || compareObjectSelection2.canBeDrop() && compareObjectSelection2.getCorrespondentNode().isSelected()) continue block0;
                if (bl3) {
                    stringBuffer.append(',');
                    CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                    stringBuffer.append(' ');
                }
                String string = compareObjectSelection2.isSelected() ? compareObjectSelection2.getChoosedPropertyValue(PropertiesComparator.NAME) : compareObjectSelection2.getCorrespondentNode().getObject().getName();
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
                if (bl2) {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, index.getColumnSortOrder(compareObjectSelection2.getObject()));
                }
                bl3 = true;
                continue block0;
            }
        }
        return stringBuffer;
    }

    public boolean isRenamed() {
        return this.isRenamed;
    }

    public void setRenamed(boolean bl) {
        this.isRenamed = bl;
    }

    public String getTableName(CompareObjectSelection compareObjectSelection) {
        String string = compareObjectSelection.getChoosedPropertyValue(PropertiesComparator.SCHEMA);
        if ("".equals(string)) {
            String string2 = compareObjectSelection.getChoosedPropertyValue(PropertiesComparator.NAME);
            return this.storageDesign.getFormatedName(string2);
        }
        String string3 = this.storageDesign.getFormatedName(string) + '.' + this.storageDesign.getFormatedName(compareObjectSelection.getChoosedPropertyValue(PropertiesComparator.NAME));
        return string3;
    }

    private String getColumnName(CompareObjectSelection compareObjectSelection) {
        return compareObjectSelection.getChoosedPropertyValue(PropertiesComparator.NAME);
    }

    private void createExtDirectory(StringBuffer stringBuffer, TableSelection tableSelection, boolean bl) {
        Object object;
        ModelObject modelObject;
        StringBuffer stringBuffer2 = new StringBuffer();
        Table table = null;
        TableProxyOracle tableProxyOracle = null;
        if (tableSelection == null) {
            return;
        }
        if (tableSelection.getObject() instanceof Table) {
            table = (Table)tableSelection.getObject();
            modelObject = table.getDesign();
            object = ((Design)modelObject).getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOracle)((Design)modelObject).getStorageDesign((RDBMSSite)object, table);
            tableProxyOracle = (TableProxyOraclev9i)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        } else if (tableSelection.getObject() instanceof TableProxyOracle) {
            tableProxyOracle = (TableProxyOracle)tableSelection.getObject();
            table = (Table)tableProxyOracle.getObject();
            modelObject = table.getDesign();
            this.storageDesign = (StorageDesignOraclev9i)((Design)modelObject).getStorageDesign(((Design)modelObject).getSelectedRDBMSSite(), table);
        } else {
            return;
        }
        modelObject = (TableSelection)tableSelection.getCorrespondentNode();
        object = ((TableSelection)modelObject).getUnloadDirectory();
        if ("".equals(object)) {
            object = ((ModelIdObjectSelection)modelObject).getObject().getDesign().getUnloadDirectory();
        }
        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "CREATE OR REPLACE DIRECTORY");
        this.directoryName = table.getName() + "_dir";
        if (this.directoryName.length() > 30) {
            this.directoryName = table.getName();
        }
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(this.directoryName));
        CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 1);
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "AS");
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "'" + (String)object + "'");
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
        this.appendLineFinisher(stringBuffer2, bl);
    }

    private void createExtTable(StringBuffer stringBuffer, String string, TableSelection tableSelection, String string2, boolean bl) {
        Object object;
        StringBuffer stringBuffer2 = new StringBuffer();
        Table table = null;
        TableProxyOracle tableProxyOracle = null;
        if (tableSelection == null) {
            return;
        }
        if (tableSelection.getObject() instanceof Table) {
            table = (Table)tableSelection.getObject();
            object = table.getDesign();
            RDBMSSite rDBMSSite = ((Design)object).getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOracle)((Design)object).getStorageDesign(rDBMSSite, table);
            tableProxyOracle = (TableProxyOraclev9i)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        } else if (tableSelection.getObject() instanceof TableProxyOracle) {
            tableProxyOracle = (TableProxyOracle)tableSelection.getObject();
            table = (Table)tableProxyOracle.getObject();
            object = table.getDesign();
            this.storageDesign = (StorageDesignOraclev9i)((Design)object).getStorageDesign(((Design)object).getSelectedRDBMSSite(), table);
        }
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "CREATE");
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "TABLE");
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, string);
        object = stringBuffer2.toString();
        this.appendElementListExt(stringBuffer2, tableProxyOracle, tableSelection, bl);
        CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 1);
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "ORGANIZATION");
        CSSBCreateRenameTable.appendString(stringBuffer2, "EXTERNAL");
        CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 1);
        CSSBCreateRenameTable.appendString(stringBuffer2, '(');
        CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 2);
        CSSBCreateRenameTable.appendString(stringBuffer2, "TYPE oracle_loader");
        CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 2);
        CSSBCreateRenameTable.appendString(stringBuffer2, "DEFAULT DIRECTORY " + this.storageDesign.getFormatedName(this.directoryName));
        CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 2);
        CSSBCreateRenameTable.appendString(stringBuffer2, "ACCESS PARAMETERS");
        CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 2);
        CSSBCreateRenameTable.appendString(stringBuffer2, '(');
        CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 3);
        CSSBCreateRenameTable.appendString(stringBuffer2, "RECORDS DELIMITED BY '|@*|\\r\\n'");
        CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 3);
        CSSBCreateRenameTable.appendString(stringBuffer2, "FIELDS TERMINATED BY '|' OPTIONALLY ENCLOSED BY '\"' NOTRIM");
        this.addColumnsAndTransforms(stringBuffer2, tableProxyOracle, tableSelection);
        CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 2);
        CSSBCreateRenameTable.appendString(stringBuffer2, ')');
        CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 2);
        CSSBCreateRenameTable.appendString(stringBuffer2, "LOCATION");
        CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 2);
        CSSBCreateRenameTable.appendString(stringBuffer2, '(');
        CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 3);
        CSSBCreateRenameTable.appendString(stringBuffer2, "'" + string2 + ".txt'");
        CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 2);
        CSSBCreateRenameTable.appendString(stringBuffer2, ')');
        CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 1);
        CSSBCreateRenameTable.appendString(stringBuffer2, ") REJECT LIMIT 0");
        this.appendToBuffer(stringBuffer, stringBuffer2, (String)object);
        CSSBCreateRenameTable.appendNewLine(stringBuffer2, bl, 0);
        this.appendLineFinisher(stringBuffer2, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
        CDDLFileMaker.incrementCreateTable();
    }

    private void dropExtTable(StringBuffer stringBuffer, String string, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "DROP TABLE");
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, string);
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
        this.appendLineFinisher(stringBuffer2, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
        CDDLFileMaker.incrementDropTable();
    }

    private void dropExtDir(StringBuffer stringBuffer, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
        CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 0);
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, "DROP DIRECTORY");
        CSSBCreateRenameTable.appendStringWithSpace(stringBuffer2, this.storageDesign.getFormatedName(this.directoryName));
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
        this.appendLineFinisher(stringBuffer2, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, stringBuffer2.toString());
    }

    private void appendElementListExt(StringBuffer stringBuffer, TableProxyOracle tableProxyOracle, TableSelection tableSelection, boolean bl) {
        List list = tableSelection.getChildObjects(0);
        if (list.size() > 0) {
            boolean bl2 = true;
            for (CompareObjectSelection compareObjectSelection : list) {
                if (compareObjectSelection.canBeCreate() || compareObjectSelection.canBeDrop() && compareObjectSelection.isSelected()) continue;
                CompareObjectSelection compareObjectSelection2 = compareObjectSelection.getCorrespondentNode();
                if (bl2) {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, '(');
                    bl2 = false;
                } else {
                    CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ',');
                }
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateRenameTable.appendString(stringBuffer, ' ');
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(compareObjectSelection2.getChoosedPropertyValue(PropertiesComparator.NAME)));
                Column column = (Column)compareObjectSelection2.getObject();
                String string = column == null ? compareObjectSelection2.getChoosedPropertyValue(PropertiesComparator.DATA_TYPE) : column.getDatatypeString(tableProxyOracle.getStorageDesign().getRDBMSType().getName());
                if (string.equalsIgnoreCase("BFILE")) {
                    string = "VARCHAR2 (255 BYTE)";
                }
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, string);
            }
            if (!bl2) {
                CSSBCreateRenameTable.appendNewLine(stringBuffer, bl, 1);
                CSSBCreateRenameTable.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private void appendBitmapJoinIndexes(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        Iterator iterator = tableProxyOraclev9i.getBjIndexes().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.ssbBJIndex == null) {
                this.ssbBJIndex = new SSBCreateBitmapJoinIndexOraclev9i();
            }
            if (!this.ssbBJIndex.canHandle(e)) continue;
            this.ssbBJIndex.doAppendBJIndex(stringBuffer, e, bl);
        }
    }

    private void appendAutoIncTriggers(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        Table table = (Table)tableProxyOraclev9i.getObject();
        for (Column column : table.getElementsCollection()) {
            if (!column.isAutoIncrementColumn()) continue;
            if (this.ssbAutoIncCol == null) {
                this.ssbAutoIncCol = new SSBAutoIncrementColumnOracle(this.storageDesign);
            }
            this.ssbAutoIncCol.appendAutoIncrementSequenceAndTrigger(stringBuffer, column, bl);
        }
    }

    private void appendTriggers(StringBuffer stringBuffer, TableProxyOraclev9i tableProxyOraclev9i, boolean bl) {
        Iterator iterator = tableProxyOraclev9i.getTriggers().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.ssbTriggers == null) {
                this.ssbTriggers = new SSBTriggerOraclev9i();
            }
            if (!this.ssbTriggers.canHandle(e)) continue;
            this.ssbTriggers.doAppendTrigger(stringBuffer, e, bl);
        }
    }

    private String newline() {
        return SQLStatementBuilder.NEWLINE;
    }

    public String newTab() {
        return "    ";
    }

    public static String getColumnAndTypePresentation(String string, String string2, Design design) {
        String string3 = string2.toUpperCase();
        if (string3.indexOf("CHAR") > -1) {
            String string4 = Token.getValBetweenBrackets(string3);
            if (string4.length() > 0) {
                return string + " CHAR (" + Token.getFirstToken(string4) + ')';
            }
        } else {
            if (string3.indexOf("DATE") > -1) {
                return string + " CHAR DATE_FORMAT DATE MASK '" + design.getEngDateFormat() + "'";
            }
            if (string3.indexOf("TIMESTAMP") > -1) {
                if (string3.indexOf("ZONE") == -1) {
                    return string + " CHAR DATE_FORMAT TIMESTAMP MASK '" + design.getEngTimestampFormat() + "'";
                }
                if (string3.indexOf("LOCAL") == -1) {
                    return string + " CHAR DATE_FORMAT TIMESTAMP WITH TIMEZONE MASK '" + design.getEngTimestampWTZFormat() + "'";
                }
                return string + " CHAR DATE_FORMAT TIMESTAMP WITH LOCAL TIMEZONE MASK '" + design.getEngTimestampFormat() + "'";
            }
        }
        return string;
    }

    private void addColumnsAndTransforms(StringBuffer stringBuffer, TableProxy tableProxy, TableSelection tableSelection) {
        List list = tableSelection.getChildObjects(0);
        Design design = tableProxy.getDesign();
        if (list.size() > 0) {
            boolean bl = true;
            for (CompareObjectSelection compareObjectSelection : list) {
                if (compareObjectSelection.canBeCreate() || compareObjectSelection.canBeDrop() && compareObjectSelection.isSelected()) continue;
                CompareObjectSelection compareObjectSelection2 = compareObjectSelection.getCorrespondentNode();
                String string = this.storageDesign.getFormatedName(compareObjectSelection2.getChoosedPropertyValue(PropertiesComparator.NAME));
                if (!string.startsWith("\"")) {
                    string = '\"' + string.toUpperCase() + '\"';
                }
                String string2 = "";
                Column column = (Column)compareObjectSelection2.getObject();
                if (column != null) {
                    string2 = column.getDatatypeString(tableProxy.getStorageDesign().getRDBMSType().getName());
                }
                if (bl) {
                    stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
                    stringBuffer.append('(');
                    bl = false;
                } else {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
                stringBuffer.append(CSSBCreateRenameTable.getColumnAndTypePresentation(string, string2, design));
            }
            if (!bl) {
                stringBuffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
                stringBuffer.append(')');
            }
        }
    }

    static class PossitionComparator
    implements Comparator {
        PossitionComparator() {
        }

        public int compare(Object object, Object object2) {
            if (((PartitionOraclev9i)object).getPosition() > ((PartitionOraclev9i)object2).getPosition()) {
                return 1;
            }
            if (((PartitionOraclev9i)object).getPosition() < ((PartitionOraclev9i)object2).getPosition()) {
                return -1;
            }
            return 0;
        }
    }

    static class GlobalPossitionComparator
    implements Comparator {
        GlobalPossitionComparator() {
        }

        public int compare(Object object, Object object2) {
            if (((IndexGlobalPartitionOraclev9i)object).getPosition() > ((IndexGlobalPartitionOraclev9i)object2).getPosition()) {
                return 1;
            }
            if (((IndexGlobalPartitionOraclev9i)object).getPosition() < ((IndexGlobalPartitionOraclev9i)object2).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

