/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBTableOraclev10g;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateTableOraclev10g;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ColumnProxyOraclev9i;

public abstract class AbstractCSSBOraclev9i
extends AbstractCSSBOracle {
    private DesignObject sType;
    protected StorageDesignOracle storageDesign;

    protected void appendXMLTypeColumnProps(StringBuffer stringBuffer, ColumnProxyOraclev9i columnProxyOraclev9i, boolean bl) {
        AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 1);
        AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "XMLTYPE");
        AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "COLUMN");
        AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOraclev9i.getName()));
        AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "STORE AS");
        if (columnProxyOraclev9i.getStoreAs().equalsIgnoreCase("OBJECT RELATIONAL")) {
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "OBJECT RELATIONAL");
        } else {
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "CLOB");
            String string = columnProxyOraclev9i.getLobSegmentName();
            if (string != null && string.length() > 0) {
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(string));
            }
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 1);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, '(');
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 2);
            if (columnProxyOraclev9i.getTablespace() != null) {
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "TABLESPACE");
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOraclev9i.getTablespace().getName()));
                AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 2);
            }
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "STORAGE");
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, '(');
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 3);
            if (columnProxyOraclev9i.getSCInitialExtent() > 0L) {
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "INITIAL");
                this.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getSCInitialExtent());
                AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 3);
            }
            if (columnProxyOraclev9i.getSCNextExtent() > 0L) {
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "NEXT");
                this.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getSCNextExtent());
                AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 3);
            }
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "PCTINCREASE");
            this.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getSCPctIncrease());
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 3);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "MINEXTENTS");
            this.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getSCMinExtents());
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 3);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "MAXEXTENTS");
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getSCMaxExtents());
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 3);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "FREELISTS");
            this.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getSCFreeLists());
            if (columnProxyOraclev9i.getSCFreelistGroups() > 1) {
                AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 3);
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "FREELIST");
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "GROUPS");
                this.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getSCFreelistGroups());
            }
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 3);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "BUFFER_POOL");
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getSCBufferPool());
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 2);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, ')');
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 2);
            if (columnProxyOraclev9i.getChunk() > 0) {
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "CHUNK");
                this.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getChunk());
                AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 2);
            }
            if (columnProxyOraclev9i.getOldVersions().equalsIgnoreCase("RETENTION")) {
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "RETENTION");
            } else {
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "PCTVERSION");
                this.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getPCTVersion());
            }
            if (columnProxyOraclev9i.getSCFreelistGroups() <= 1 && columnProxyOraclev9i.getFreepools() > 0) {
                AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 2);
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "FREEPOOLS");
                this.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getFreepools());
            }
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 2);
            if ("ENABLE".equalsIgnoreCase(columnProxyOraclev9i.getStorageInRow())) {
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "ENABLE");
            } else {
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "DISABLE");
            }
            stringBuffer.append("STORAGE IN ROW");
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 2);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getCache());
            if (!"CACHE".equalsIgnoreCase(columnProxyOraclev9i.getCache())) {
                if ("YES".equalsIgnoreCase(columnProxyOraclev9i.getLogging())) {
                    AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(columnProxyOraclev9i.getLogging())) {
                    AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "NOLOGGING");
                }
            }
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 1);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
        this.appendXMLSchemaSpec(stringBuffer, columnProxyOraclev9i.getXmlSchemaUrl(), columnProxyOraclev9i.getXmlSchemaElement(), bl);
    }

    protected void appendXMLSchemaSpec(StringBuffer stringBuffer, String string, String string2, boolean bl) {
        if (string2 != null && string2.length() > 0) {
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 2);
            if (string != null && string.length() > 0) {
                stringBuffer.append("XMLSCHEMA").append(' ').append('\"').append(string).append('\"');
                AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 2);
            }
            stringBuffer.append("ELEMENT").append(' ').append('\"').append(string2).append('\"').append(' ');
        }
    }

    protected void appendVarrayColumnProp(StringBuffer stringBuffer, ColumnProxyOraclev9i columnProxyOraclev9i, boolean bl) {
        if (this.hasVarrayClause(columnProxyOraclev9i)) {
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 1);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "VARRAY");
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOraclev9i.getName()));
            this.appendSubstitutableColumnClause(stringBuffer, columnProxyOraclev9i, bl, false);
            if (!columnProxyOraclev9i.getLobSegname().equals("")) {
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "STORE AS");
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "LOB");
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOraclev9i.getLobSegname()));
            }
        }
    }

    protected void appendObjectTypeColProperties(StringBuffer stringBuffer, Table table, TableProxyOracle tableProxyOracle, boolean bl) {
        if (table.isBST() && tableProxyOracle != null) {
            ModelIDObject modelIDObject;
            int n;
            Column[] columnArray = (Column[])table.getElements();
            boolean bl2 = false;
            if (table.getOidPKColumns().size() > 0 || tableProxyOracle.getTableCheckConstraints().size() > 0) {
                bl2 = true;
            }
            if (!bl2) {
                Column column;
                for (n = 0; n < columnArray.length && !(bl2 = this.shouldGenerateObjectPropDefinition(column = columnArray[n], (ColumnProxyOracle)(modelIDObject = (ColumnProxyOracle)tableProxyOracle.getColumnProxy(column.getObjectID())))); ++n) {
                }
            }
            if (bl2) {
                n = 1;
                AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 1);
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, '(');
                for (int i = 0; i < columnArray.length; ++i) {
                    modelIDObject = columnArray[i];
                    ColumnProxyOraclev9i columnProxyOraclev9i = (ColumnProxyOraclev9i)tableProxyOracle.getColumnProxy(modelIDObject.getObjectID());
                    if (!this.shouldGenerateObjectPropDefinition((Column)modelIDObject, columnProxyOraclev9i)) continue;
                    if (n == 0) {
                        this.appendComma(stringBuffer);
                    } else {
                        n = 0;
                    }
                    AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 1);
                    AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getStorageDesign().getFormatedName(columnProxyOraclev9i.getName()));
                    this.appendColumnOptions(stringBuffer, (Column)modelIDObject, columnProxyOraclev9i, bl);
                    this.appendInlineRefConstraint(stringBuffer, (Column)modelIDObject, columnProxyOraclev9i, bl);
                    CSSBCreateTableOraclev10g.appendColumnConstraints(stringBuffer, (Column)modelIDObject, columnProxyOraclev9i, bl);
                }
                n = this.appendTableConstraintsDefinition(stringBuffer, tableProxyOracle, bl, n != 0) ? 1 : 0;
                if (table.getOidPKColumns().size() > 0) {
                    if (n == 0) {
                        this.appendComma(stringBuffer);
                    } else {
                        n = 0;
                    }
                    this.appendPK_ObjectType(stringBuffer, table, tableProxyOracle, bl);
                }
                AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 1);
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, ')');
            }
        }
    }

    private boolean shouldGenerateObjectPropDefinition(Column column, ColumnProxyOracle columnProxyOracle) {
        if (column.isOid()) {
            return false;
        }
        if (!column.getNullsAllowed()) {
            return true;
        }
        String string = columnProxyOracle.getDefaultValue();
        if (string != null && !"".equalsIgnoreCase(string)) {
            return true;
        }
        if (column.isReference() && "YES".equalsIgnoreCase(columnProxyOracle.getWithRowId())) {
            return true;
        }
        return SSBTableOraclev10g.willGenerateInlineColumnConstrOra(column, columnProxyOracle);
    }

    private void appendPK_ObjectType(StringBuffer stringBuffer, Table table, TableProxyOracle tableProxyOracle, boolean bl) {
        String string = this.storageDesign.getFormatedName(tableProxyOracle.getPKName());
        if (!"".equals(string)) {
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 1);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "CONSTRAINT");
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, string);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "PRIMARY KEY");
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, '(');
            boolean bl2 = true;
            for (Column column : table.getOidPKColumns()) {
                ColumnProxyOracle columnProxyOracle = (ColumnProxyOracle)tableProxyOracle.getColumnProxy(column.getObjectID());
                if (bl2) {
                    bl2 = false;
                } else {
                    AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, ',');
                }
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, columnProxyOracle.getStorageDesign().getFormatedName(columnProxyOracle.getName()));
            }
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
    }

    protected void appendInlineRefConstraint(StringBuffer stringBuffer, Column column, ColumnProxyOraclev9i columnProxyOraclev9i, boolean bl) {
        this.appendWithRowid(stringBuffer, column, columnProxyOraclev9i, bl);
    }

    private void appendWithRowid(StringBuffer stringBuffer, Column column, ColumnProxyOraclev9i columnProxyOraclev9i, boolean bl) {
        if (column.isReference() && "YES".equalsIgnoreCase(columnProxyOraclev9i.getWithRowId())) {
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 2);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "WITH");
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "ROWID");
        }
    }

    protected void appendColumnOptions(StringBuffer stringBuffer, Column column, ColumnProxyOraclev9i columnProxyOraclev9i, boolean bl) {
        this.appendWithDefaultDefinition(stringBuffer, columnProxyOraclev9i);
        if (!column.getNullsAllowed()) {
            this.appendNotNullDefinition(stringBuffer, columnProxyOraclev9i, bl);
        }
    }

    protected void appendWithDefaultDefinition(StringBuffer stringBuffer, ColumnProxyOraclev9i columnProxyOraclev9i) {
        boolean bl = columnProxyOraclev9i.getStorageDesign().isOpen();
        String string = "";
        Column column = columnProxyOraclev9i.getColumn();
        string = !bl ? column.getDefaultValue() : columnProxyOraclev9i.getDefaultValue();
        if (string != null && !"".equalsIgnoreCase(string)) {
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "DEFAULT");
            String string2 = column.getDatatypeString("Oracle9i");
            String string3 = this.addQuotesToDefault(string2, string);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, string3);
        }
    }

    protected boolean appendTableConstraintsDefinition(StringBuffer stringBuffer, TableProxyOracle tableProxyOracle, boolean bl, boolean bl2) {
        if (tableProxyOracle != null) {
            Iterator iterator = tableProxyOracle.getTableCheckConstraints().iterator();
            while (iterator.hasNext()) {
                TableCheckConstraintOracle tableCheckConstraintOracle = (TableCheckConstraintOracle)iterator.next();
                TableLevelConstraint tableLevelConstraint = tableCheckConstraintOracle.getTableConstraint();
                if (!tableLevelConstraint.shouldBeMerge()) continue;
                String string = tableCheckConstraintOracle.getTableConstraint().getRule();
                String string2 = tableCheckConstraintOracle.getName();
                if (string2.toUpperCase().startsWith("SYS_")) {
                    string2 = "";
                }
                if (!"".equals(string2) || "".equals(string)) continue;
                if (bl2) {
                    bl2 = false;
                } else {
                    this.appendComma(stringBuffer);
                }
                AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 1);
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "CHECK");
                AbstractCSSBOraclev9i.appendString(stringBuffer, '(');
                AbstractCSSBOraclev9i.appendString(stringBuffer, string);
                AbstractCSSBOraclev9i.appendString(stringBuffer, ')');
                this.appendTableConstraintState(stringBuffer, tableCheckConstraintOracle, bl);
            }
        }
        return bl2;
    }

    protected void appendTableConstraintState(StringBuffer stringBuffer, TableCheckConstraintOracle tableCheckConstraintOracle, boolean bl) {
        if (!"NO".equalsIgnoreCase(tableCheckConstraintOracle.getDeferrable())) {
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 2);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(tableCheckConstraintOracle.getInitially())) {
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "INITIALLY");
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "DEFERRED");
            }
        }
        if ("NO".equalsIgnoreCase(tableCheckConstraintOracle.getEnable())) {
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 2);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "DISABLE");
            if ("YES".equalsIgnoreCase(tableCheckConstraintOracle.getValidate())) {
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "VALIDATE");
            }
        }
        if ("NO".equalsIgnoreCase(tableCheckConstraintOracle.getValidate())) {
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 2);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "NOVALIDATE");
        }
        if (tableCheckConstraintOracle.getExceptionsTable() != null) {
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 2);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "EXCEPTIONS");
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "INTO");
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(tableCheckConstraintOracle.getExceptionsTable().getName()));
        }
    }

    protected void appendNotNullDefinition(StringBuffer stringBuffer, ColumnProxyOraclev9i columnProxyOraclev9i, boolean bl) {
        String string;
        String string2 = string = columnProxyOraclev9i.isNotNullConstraintNameChanged() ? columnProxyOraclev9i.getNncName() : columnProxyOraclev9i.getColumn().getNotNullConstraintName();
        if (!"NO".equalsIgnoreCase(columnProxyOraclev9i.getNncDeferrable()) || !"YES".equalsIgnoreCase(columnProxyOraclev9i.getNncEnable()) || !"YES".equalsIgnoreCase(columnProxyOraclev9i.getNncValidate()) || string != null && !"".equals(string)) {
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 1);
            AbstractCSSBOraclev9i.appendString(stringBuffer, ' ');
            if (!columnProxyOraclev9i.getDesign().getAppView().getSettings().notNullShortFormGeneration() && string != null && !"".equals(string)) {
                string = this.storageDesign.getFormatedName(string);
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "CONSTRAINT");
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, string);
            }
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "NOT");
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "NULL");
            if (!"NO".equalsIgnoreCase(columnProxyOraclev9i.getNncDeferrable())) {
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "DEFERRABLE");
                if ("DEFERRED".equalsIgnoreCase(columnProxyOraclev9i.getNncInitially())) {
                    AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "INITIALLY");
                    AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "DEFERRED");
                }
            }
            if (!"YES".equalsIgnoreCase(columnProxyOraclev9i.getNncEnable())) {
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "DISABLE");
                if ("YES".equalsIgnoreCase(columnProxyOraclev9i.getNncValidate())) {
                    AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "VALIDATE");
                }
            }
            if (!"YES".equalsIgnoreCase(columnProxyOraclev9i.getNncValidate())) {
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "NOVALIDATE");
            }
        } else {
            AbstractCSSBOraclev9i.appendString(stringBuffer, ' ');
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "NOT");
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "NULL");
        }
    }

    protected void appendNestedTableColumnProp(StringBuffer stringBuffer, ColumnProxyOraclev9i columnProxyOraclev9i, boolean bl) {
        if (!columnProxyOraclev9i.getNtStorageTable().equals("")) {
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 1);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "NESTED");
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "TABLE");
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOraclev9i.getName()));
            this.appendSubstitutableColumnClause(stringBuffer, columnProxyOraclev9i, bl, false);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "STORE AS");
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getNtStorageTable());
            if (!columnProxyOraclev9i.getAdditionalNTS().equals("")) {
                AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 1);
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, '(');
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getAdditionalNTS());
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, ')');
            }
            if (!columnProxyOraclev9i.getNtReturn().equals("")) {
                AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 1);
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "RETURN");
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "AS");
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getNtReturn());
            }
        }
    }

    protected void appendSubstitutableColumnClause(StringBuffer stringBuffer, ColumnProxyOraclev9i columnProxyOraclev9i, boolean bl, boolean bl2) {
        Column column = columnProxyOraclev9i.getColumn();
        Table table = (Table)column.getContainerWithKeyObject();
        if (table.isBST() && !table.isSubstitutable()) {
            return;
        }
        if (!column.isReference()) {
            if (column.isAllowSubtypeSubstitution()) {
                if (bl2 && (column.isRestrictedTypeSubstitution() && column.getPermittedSubTypes().size() == 1 || columnProxyOraclev9i.getSubtitutable().equals("ONLY FOR TYPE"))) {
                    AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 1);
                    AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "COLUMN");
                    AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOraclev9i.getName()));
                    AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "IS");
                    AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "OF");
                    AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "TYPE");
                    AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, '(');
                    AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "ONLY");
                    if (column.isRestrictedTypeSubstitution() && column.getPermittedSubTypes().size() == 1) {
                        StructuredType structuredType = (StructuredType)column.getPermittedSubTypes().get(0);
                        StructuredTypeProxyOracle structuredTypeProxyOracle = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(structuredType);
                        if (structuredTypeProxyOracle != null) {
                            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(structuredTypeProxyOracle.getLongName()));
                        } else {
                            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(structuredType.getName()));
                        }
                    } else {
                        AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, columnProxyOraclev9i.getElementType());
                    }
                    AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, ')');
                } else if (columnProxyOraclev9i.getSubtitutable().equals("YES") || columnProxyOraclev9i.getSubtitutable().equals("NO")) {
                    if (bl2) {
                        AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 1);
                        AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "COLUMN");
                        AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOraclev9i.getName()));
                    }
                    if (columnProxyOraclev9i.getSubtitutable().equals("NO")) {
                        AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "NOT");
                    }
                    AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "SUBSTITUTABLE");
                    AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "AT");
                    AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "ALL");
                    AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "LEVELS");
                }
            } else {
                if (bl2) {
                    AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 1);
                    AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "COLUMN");
                    AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, this.storageDesign.getFormatedName(columnProxyOraclev9i.getName()));
                }
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "NOT");
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "SUBSTITUTABLE");
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "AT");
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "ALL");
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "LEVELS");
            }
        }
    }

    private boolean hasVarrayClause(ColumnProxyOraclev9i columnProxyOraclev9i) {
        return !columnProxyOraclev9i.getSubtitutable().equals("") || !columnProxyOraclev9i.getLobSegname().equals("");
    }

    protected void appendRegisterSpatialTable(StringBuffer stringBuffer, Table table, SpatialColumnDefObject spatialColumnDefObject, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = "";
        AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 0);
        AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer2, "INSERT");
        AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer2, "INTO");
        AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer2, "USER_SDO_GEOM_METADATA");
        string = stringBuffer2.toString();
        this.appendSpatialColumnDefinition(stringBuffer2, table, spatialColumnDefObject, bl);
        this.appendFunctionDefinition(stringBuffer2, table, spatialColumnDefObject, bl);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
        AbstractCSSBOraclev9i.appendNewLine(stringBuffer2, bl, 0);
        this.appendLineFinisher(stringBuffer2, bl);
        AbstractCSSBOraclev9i.appendNewLine(stringBuffer2, bl, 0);
        this.appendToBuffer(stringBuffer, stringBuffer2, string);
    }

    private void appendFunctionDefinition(StringBuffer stringBuffer, Table table, SpatialColumnDefObject spatialColumnDefObject, boolean bl) {
        if (spatialColumnDefObject.isFunction()) {
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 1);
            AbstractCSSBOraclev9i.appendString(stringBuffer, "VALUES");
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 1);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, '(');
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 2);
            AbstractCSSBOraclev9i.appendString(stringBuffer, '\'');
            AbstractCSSBOraclev9i.appendString(stringBuffer, this.storageDesign.getFormatedName(table.getName()));
            AbstractCSSBOraclev9i.appendString(stringBuffer, '\'');
            AbstractCSSBOraclev9i.appendString(stringBuffer, ',');
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 2);
            AbstractCSSBOraclev9i.appendString(stringBuffer, '\'');
            AbstractCSSBOraclev9i.appendString(stringBuffer, spatialColumnDefObject.getFuncExpression());
            AbstractCSSBOraclev9i.appendString(stringBuffer, '\'');
            AbstractCSSBOraclev9i.appendString(stringBuffer, ',');
            AbstractCSSBOraclev9i.appendSpace(stringBuffer);
            this.appendTableDimensional(stringBuffer, spatialColumnDefObject, bl);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, ',');
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 2);
            if (spatialColumnDefObject.getSystemID() == null || spatialColumnDefObject.getSystemID().trim().equals("")) {
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "NULL");
            } else {
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, spatialColumnDefObject.getSystemID());
            }
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 1);
            AbstractCSSBOraclev9i.appendString(stringBuffer, ')');
        }
    }

    private void appendSpatialColumnDefinition(StringBuffer stringBuffer, Table table, SpatialColumnDefObject spatialColumnDefObject, boolean bl) {
        if (spatialColumnDefObject.getSpatialColumn() != null) {
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, '(');
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "TABLE_NAME");
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, ',');
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "COLUMN_NAME");
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, ',');
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "DIMINFO");
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, ',');
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "SRID");
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, ')');
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 1);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "VALUES");
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, '(');
            AbstractCSSBOraclev9i.appendString(stringBuffer, '\'');
            AbstractCSSBOraclev9i.appendString(stringBuffer, this.storageDesign.getFormatedName(table.getName()));
            AbstractCSSBOraclev9i.appendString(stringBuffer, '\'');
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, ',');
            AbstractCSSBOraclev9i.appendString(stringBuffer, '\'');
            Datatype datatype = spatialColumnDefObject.getSpatialColumn().getDataType();
            String string = this.storageDesign.getFormatedName(spatialColumnDefObject.getSpatialColumn().getName());
            if (datatype instanceof StructuredType) {
                if (this.sType == null) {
                    this.sType = table.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName("SDO_GEOMETRY");
                }
                StructuredType structuredType = (StructuredType)datatype;
                for (TypeElement typeElement : structuredType.getAllElements()) {
                    if (typeElement.getType() != this.sType) continue;
                    string = string.concat(".").concat(this.storageDesign.getFormatedName(typeElement.getName()));
                    break;
                }
            }
            AbstractCSSBOraclev9i.appendString(stringBuffer, string);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, '\'');
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, ',');
            this.appendTableDimensional(stringBuffer, spatialColumnDefObject, bl);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, ',');
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 2);
            if (spatialColumnDefObject.getSystemID() == null || spatialColumnDefObject.getSystemID().trim().equals("")) {
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "NULL");
            } else {
                AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, spatialColumnDefObject.getSystemID());
            }
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 1);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, ')');
        }
    }

    private void appendTableDimensional(StringBuffer stringBuffer, SpatialColumnDefObject spatialColumnDefObject, boolean bl) {
        AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 2);
        AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "MDSYS.SDO_DIM_ARRAY");
        AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, '(');
        Iterator iterator = spatialColumnDefObject.getTableDimensions().iterator();
        while (iterator.hasNext()) {
            SpatialColumnDefObject.TableDimension tableDimension = (SpatialColumnDefObject.TableDimension)iterator.next();
            AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 3);
            AbstractCSSBOraclev9i.appendStringWithSpace(stringBuffer, "MDSYS.SDO_DIM_ELEMENT");
            AbstractCSSBOraclev9i.appendString(stringBuffer, '(');
            AbstractCSSBOraclev9i.appendString(stringBuffer, '\'');
            AbstractCSSBOraclev9i.appendString(stringBuffer, this.storageDesign.getFormatedName(tableDimension.getName()));
            AbstractCSSBOraclev9i.appendString(stringBuffer, '\'');
            AbstractCSSBOraclev9i.appendString(stringBuffer, ',');
            AbstractCSSBOraclev9i.appendString(stringBuffer, tableDimension.getLowBoundary());
            AbstractCSSBOraclev9i.appendString(stringBuffer, ',');
            AbstractCSSBOraclev9i.appendString(stringBuffer, tableDimension.getUpperBoundary());
            AbstractCSSBOraclev9i.appendString(stringBuffer, ',');
            AbstractCSSBOraclev9i.appendString(stringBuffer, tableDimension.getTolerance());
            AbstractCSSBOraclev9i.appendString(stringBuffer, ')');
            if (!iterator.hasNext()) continue;
            AbstractCSSBOraclev9i.appendString(stringBuffer, ',');
        }
        AbstractCSSBOraclev9i.appendNewLine(stringBuffer, bl, 2);
        AbstractCSSBOraclev9i.appendString(stringBuffer, ')');
    }
}

