/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.ddl.CompareRelationalModels;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;

public class DDLDistinctTypeComparator
extends PropertiesComparator {
    private DistinctType sourceType;
    private DistinctType targetType;
    private CompareRelationalModels selectionObject;

    public DDLDistinctTypeComparator(DistinctType distinctType, DistinctType distinctType2) {
        super(distinctType, distinctType2);
        this.sourceType = distinctType;
        this.targetType = distinctType2;
        this.initPropertiesList();
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentsAndNotes();
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromDistTypeToDistType();
    }

    private void copyPropertiesFromDistTypeToDistType() {
        if (this.sourceType != null && this.targetType != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
            }
        }
    }

    public CompareRelationalModels getSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareRelationalModels compareRelationalModels) {
        this.selectionObject = compareRelationalModels;
    }

    @Override
    public String getLeftName() {
        return this.sourceType != null ? MessageFormat.format(Messages.getString("DDLDistinctTypeComparator.SourceDistinctType"), this.sourceType.getName()) : "";
    }

    @Override
    public String getRightName() {
        return this.targetType != null ? MessageFormat.format(Messages.getString("DDLDistinctTypeComparator.TargetDistinctType"), this.targetType.getName()) : "";
    }
}

