/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.ddl.CompareRelationalModels;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;

public class DDLCollectionTypeComparator
extends PropertiesComparator {
    private CollectionType sourceType;
    private CollectionType targetType;
    private CompareRelationalModels selectionObject;

    public DDLCollectionTypeComparator(CollectionType collectionType, CollectionType collectionType2) {
        super(collectionType, collectionType2);
        this.sourceType = collectionType;
        this.targetType = collectionType2;
        this.initPropertiesList();
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentsAndNotes();
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromCollTypeToCollType();
    }

    private void copyPropertiesFromCollTypeToCollType() {
        if (this.sourceType != null && this.targetType != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
            }
        }
    }

    public CompareRelationalModels getSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareRelationalModels compareRelationalModels) {
        this.selectionObject = compareRelationalModels;
    }

    @Override
    public String getLeftName() {
        return this.sourceType != null ? MessageFormat.format(Messages.getString("DDLCollectionTypeComparator.SourceCollectionType"), this.sourceType.getName()) : "";
    }

    @Override
    public String getRightName() {
        return this.targetType != null ? MessageFormat.format(Messages.getString("DDLCollectionTypeComparator.TargetCollectionType"), this.targetType.getName()) : "";
    }
}

