/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.CompareCWDDesigns;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;

public class StructuredTypeComparator
extends PropertiesComparator {
    private StructuredType sourceType;
    private StructuredType targetType;
    private CompareCWDDesigns selectionObject;

    public StructuredTypeComparator(StructuredType structuredType, StructuredType structuredType2) {
        super(structuredType, structuredType2);
        this.sourceType = structuredType;
        this.targetType = structuredType2;
        this.initPropertiesList();
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentsAndNotes();
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromStrTypeToStrType();
    }

    private void copyPropertiesFromStrTypeToStrType() {
        if (this.sourceType != null && this.targetType != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
            }
        }
    }

    public void presetTypeElemsOrder() {
        EngPropertyHolder engPropertyHolder = this.getPropertyHolderByName(STRUCTURED_TYPE);
        if (engPropertyHolder != null) {
            if (this.getLeftSelectionObject() != null) {
                engPropertyHolder.setRightValue(this.targetType != null ? this.getElementsToString(this.targetType) : "");
                CompareCWDDesigns[] compareCWDDesignsArray = this.getTypeElemNodes(this.getSelectionObject());
                engPropertyHolder.setLeftValue(this.sourceType != null ? this.getElementsToString(compareCWDDesignsArray) : "");
                if (!this.equalElementsOrderNew(this.sourceType, this.targetType)) {
                    engPropertyHolder.setSelected(true);
                    engPropertyHolder.setModified(true);
                } else {
                    engPropertyHolder.setSelected(false);
                    engPropertyHolder.setModified(false);
                }
            } else {
                engPropertyHolder.setLeftValue(this.sourceType != null ? this.getElementsToString(this.sourceType) : "");
                engPropertyHolder.setRightValue(this.targetType != null ? this.getElementsToString(this.targetType) : "");
                if (!this.equalElementsOrderNew(this.sourceType, this.targetType)) {
                    engPropertyHolder.setSelected(true);
                    engPropertyHolder.setModified(true);
                }
            }
        }
    }

    private boolean isBeforeUnchangedElement(int n, CompareCWDDesigns[] compareCWDDesignsArray) {
        for (int i = n + 1; i < compareCWDDesignsArray.length; ++i) {
            if (compareCWDDesignsArray[i].getStatus() != ModelIdObjectSelection.STATE_UNCHANGED) continue;
            return true;
        }
        return false;
    }

    private boolean equalElementsOrderNew(StructuredType structuredType, StructuredType structuredType2) {
        if (this.getLeftSelectionObject() != null) {
            CompareCWDDesigns[] compareCWDDesignsArray = this.getTypeElemNodes(this.getSelectionObject());
            for (int i = 0; i < compareCWDDesignsArray.length; ++i) {
                CompareCWDDesigns compareCWDDesigns = compareCWDDesignsArray[i];
                if (compareCWDDesigns.getStatus() == ModelIdObjectSelection.STATE_NEW && this.isBeforeUnchangedElement(i, compareCWDDesignsArray)) {
                    return false;
                }
                if (compareCWDDesigns.getStatus() != ModelIdObjectSelection.STATE_UNCHANGED && compareCWDDesigns.getStatus() != ModelIdObjectSelection.STATE_MODIFIED) continue;
            }
            return true;
        }
        return this.equalElementsOrder(structuredType, structuredType2);
    }

    private boolean equalElementsOrder(StructuredType structuredType, StructuredType structuredType2) {
        if (structuredType == null || structuredType2 == null) {
            return true;
        }
        TypeElement[] typeElementArray = structuredType.getElements();
        TypeElement[] typeElementArray2 = structuredType2.getElements();
        for (int i = 0; i < typeElementArray.length; ++i) {
            if (i > typeElementArray2.length - 1) {
                return true;
            }
            TypeElement typeElement = typeElementArray[i];
            TypeElement typeElement2 = typeElementArray2[i];
            if (typeElement2.getImportedId() != null && typeElement.getObjectID().equals(typeElement2.getImportedId()) || typeElement2.getName().equals(typeElement.getName()) || typeElement2.getDataType().toString().equals(typeElement.getDataType().toString())) continue;
            return false;
        }
        return true;
    }

    private CompareCWDDesigns[] getTypeElemNodes(CompareCWDDesigns compareCWDDesigns) {
        ArrayList<CompareCWDDesigns> arrayList = new ArrayList<CompareCWDDesigns>();
        CompareCWDDesigns compareCWDDesigns2 = (CompareCWDDesigns)compareCWDDesigns.getChild(0);
        int n = compareCWDDesigns2.getNumberOfChildren();
        for (int i = 0; i < n; ++i) {
            CompareCWDDesigns compareCWDDesigns3 = (CompareCWDDesigns)compareCWDDesigns2.getChild(i);
            if (compareCWDDesigns3.getStatus() == ModelIdObjectSelection.STATE_DELETED || (!compareCWDDesigns3.isSelected() || compareCWDDesigns3.getStatus() != ModelIdObjectSelection.STATE_NEW) && compareCWDDesigns3.getStatus() == ModelIdObjectSelection.STATE_NEW) continue;
            arrayList.add(compareCWDDesigns3);
        }
        return arrayList.toArray(new CompareCWDDesigns[0]);
    }

    private String getElementsToString(StructuredType structuredType) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<TypeElement> iterator = Arrays.asList(structuredType.getElements()).iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            TypeElement typeElement = iterator.next();
            if (bl) {
                stringBuffer.append(typeElement.getName());
                bl = false;
                continue;
            }
            stringBuffer.append("; ").append(typeElement.getName());
        }
        return stringBuffer.toString();
    }

    private String getElementsToString(CompareCWDDesigns[] compareCWDDesignsArray) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < compareCWDDesignsArray.length; ++i) {
            TypeElement typeElement = (TypeElement)compareCWDDesignsArray[i].getObject();
            if (bl) {
                stringBuffer.append(typeElement.getName());
                bl = false;
                continue;
            }
            stringBuffer.append("; ").append(typeElement.getName());
        }
        return stringBuffer.toString();
    }

    public CompareCWDDesigns getSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareCWDDesigns compareCWDDesigns) {
        this.selectionObject = compareCWDDesigns;
    }

    @Override
    public String getLeftName() {
        if (!this.sourceType.getName().equalsIgnoreCase("SDO_GEOMETRY")) {
            return MessageFormat.format(Messages.getString("StructuredTypeComparator.SourceStructureType"), this.sourceType.getName());
        }
        return "";
    }

    @Override
    public String getRightName() {
        return this.targetType != null ? MessageFormat.format(Messages.getString("StructuredTypeComparator.TargetStructureType"), this.targetType.getName()) : "";
    }
}

