/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.Note;
import oracle.dbtools.crest.model.design.compare.ColumnComparator;
import oracle.dbtools.crest.model.design.compare.CompareModelToModel;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.AttributeComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.DesignHandler;
import oracle.dbtools.crest.model.design.compare.cwddesign.TypeElementComparator;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DTInheritance;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.InheritanceRelation;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.model.xtdmapping.ExtendedMap;
import oracle.dbtools.crest.model.xtdmapping.MappingCollector;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.util.logging.Logger;

public class MergingCWDDesigns {
    private static final Logger LOGGER = new Logger(MergingCWDDesigns.class);
    protected Map comparatorsMap;
    protected static Map objectsMap = new TreeMap();
    private List fkeys = new ArrayList();
    double shift = 0.0;
    private int left = 20;
    private int top = 20;
    private int width = 35;
    private int height = 25;
    private int count = 0;
    private int maxTablePerRow;
    private boolean notEmpty = false;
    Map dtMap = new TreeMap();
    Map stMap = new TreeMap();
    Map ctMap = new TreeMap();
    List dtList = new ArrayList();
    List ctList = new ArrayList();
    List stList = new ArrayList();
    List types = new ArrayList();
    Map incompleteTypes = new TreeMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DesignHandler designHandler, Map map, Map map2, ProgressDialog progressDialog) {
        this.comparatorsMap = map;
        objectsMap = map2;
        designHandler.getSourceDesign().setPropagatePKChahges(false);
        try {
            Object object;
            Object object22;
            DesignPartView designPartView;
            Object object3;
            designHandler.getSourceDesign().loadDesignLevelSettings();
            this.resetAllObjects();
            if (designHandler.getSourceDataTypesDesign() != null) {
                this.resetAllObjects();
                this.scanForUsedTypes(designHandler, designHandler.getSourceDesign());
                this.createIncompleteTypes(designHandler.getTargetDataTypesDesign());
                this.processDistinctTypes(designHandler.getSourceDataTypesDesign(), designHandler.getTargetDataTypesDesign());
                object3 = designHandler.getTargetDataTypesDesign().getMainView().getWorkSpace().getDiagramBounds();
                if (object3 != null) {
                    this.top = (int)((RectangularShape)object3).getHeight();
                }
                this.processStructuredTypes(designHandler.getSourceDataTypesDesign(), designHandler.getTargetDataTypesDesign());
                this.processCollectionTypes(designHandler.getSourceDataTypesDesign(), designHandler.getTargetDataTypesDesign());
                this.processNotes(designHandler.getSourceDataTypesDesign(), designHandler.getTargetDataTypesDesign());
                designPartView = designHandler.getSourceDataTypesDesign().getMainView();
                DesignPartView designPartView2 = designHandler.getTargetDataTypesDesign().getMainView();
                DesignPartView.copyDisplayDrawingProperties(designPartView, designPartView2);
                if (!this.notEmpty) {
                    this.copyDisplayTopViews(designPartView, designPartView2);
                }
            }
            progressDialog.setNote(Messages.getString("MergingCWDDesigns.ProcessingLogicalModel"));
            progressDialog.setProgress(10);
            if (designHandler.isLogicalIsSelected()) {
                MergingModels.createUsedClassificationypes(designHandler.getSourceLogicalDesign(), designHandler.getTargetLogicalDesign());
                this.resetAllObjects();
                this.processModel(designHandler.getSourceLogicalDesign(), designHandler.getTargetLogicalDesign());
                this.processEntities(designHandler.getSourceLogicalDesign(), designHandler.getTargetLogicalDesign());
                this.processRelations(designHandler.getSourceLogicalDesign(), designHandler.getTargetLogicalDesign());
                this.processInheritances(designHandler.getSourceLogicalDesign(), designHandler.getTargetLogicalDesign());
                this.processEntityViews(designHandler.getSourceLogicalDesign(), designHandler.getTargetLogicalDesign());
                this.processNotes(designHandler.getSourceLogicalDesign(), designHandler.getTargetLogicalDesign());
                object3 = designHandler.getSourceLogicalDesign().getMainView();
                designPartView = designHandler.getTargetLogicalDesign().getMainView();
                DesignPartView.copyDisplayDrawingProperties((DesignPartView)object3, designPartView);
                this.copyDisplayTopViews((DesignPartView)object3, designPartView);
                for (Object object22 : ((DesignPartView)object3).getSubordinateViews()) {
                    object = this.getCorrespondingSubordinateView(designPartView, ((DesignPartView)object22).getDPVId());
                    if (object != null) continue;
                    object = designPartView.addSubordinateView();
                    ((DesignPartView)object).setImportedId(((DesignPartView)object22).getDPVId());
                    this.copyPropertiesFromSubViewToSubView((DesignPartView)object22, (DesignPartView)object);
                    DesignPartView.copyDisplayDrawingProperties((DesignPartView)object22, (DesignPartView)object);
                    this.copyDisplayTopViews((DesignPartView)object22, (DesignPartView)object);
                }
                this.processLogSubViews(designHandler.getSourceLogicalDesign(), designHandler.getTargetLogicalDesign());
            }
            double d = 10.0;
            int n = designHandler.getSourceRelationalModels().size();
            object22 = designHandler.getSourceRelationalModels().iterator();
            while (object22.hasNext()) {
                progressDialog.setNote(Messages.getString("MergingCWDDesigns.ProcessingRelationalModels"));
                progressDialog.setProgress((int)(d += 40.0 / (double)n));
                object = (String)object22.next();
                String string = designHandler.getTargetRelationalModelID((String)object);
                RelationalDesign relationalDesign = (RelationalDesign)designHandler.getSourceDesign().getRelationalDesigns().getById((String)object);
                RelationalDesign relationalDesign2 = (RelationalDesign)designHandler.getTargetDesign().getRelationalDesigns().getById(string);
                if (relationalDesign == null || relationalDesign2 == null) continue;
                MergingModels.createUsedClassificationypes(relationalDesign, relationalDesign2);
                map2.put(relationalDesign.getObjectID(), relationalDesign2);
                this.resetAllObjects();
                this.processModel(relationalDesign, relationalDesign2);
                this.processSchemaObjects(relationalDesign, relationalDesign2);
                this.fkeys.clear();
                relationalDesign.getFKIndexAssociationSet().addAllElementsTo(this.fkeys);
                this.processTables(relationalDesign, relationalDesign2);
                this.processForeignKeys();
                this.processTableViews(relationalDesign, relationalDesign2);
                this.processNotes(relationalDesign, relationalDesign2);
                DesignPartView designPartView3 = relationalDesign.getMainView();
                DesignPartView designPartView4 = relationalDesign2.getMainView();
                DesignPartView.copyDisplayDrawingProperties(designPartView3, designPartView4);
                this.copyDisplayTopViews(designPartView3, designPartView4);
                for (DesignPartView designPartView5 : designPartView3.getSubordinateViews()) {
                    DesignPartView designPartView6 = this.getCorrespondingSubordinateView(designPartView4, designPartView5.getDPVId());
                    if (designPartView6 == null) {
                        designPartView6 = designPartView4.addSubordinateView();
                        designPartView6.setImportedId(designPartView5.getDPVId());
                    }
                    this.copyPropertiesFromSubViewToSubView(designPartView5, designPartView6);
                    DesignPartView.copyDisplayDrawingProperties(designPartView5, designPartView6);
                    this.copyDisplayTopViews(designPartView5, designPartView6);
                }
                this.processRelSubViews(relationalDesign, relationalDesign2);
            }
            object = designHandler.getTargetDesign().getExtendedMap();
            this.importMappings(designHandler.getSourceLogicalDesign(), (ExtendedMap)object);
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error("MergingCWDDesigns.execute()", runtimeException);
        }
        finally {
            designHandler.getSourceDesign().setPropagatePKChahges(true);
        }
    }

    private void resetAllObjects() {
        this.left = 20;
        this.top = 20;
        this.width = 35;
        this.height = 25;
        this.notEmpty = false;
        this.count = 0;
    }

    private void processModel(DesignPart designPart, DesignPart designPart2) {
        PropertiesComparator propertiesComparator = (PropertiesComparator)this.comparatorsMap.get(designPart.getObjectID() + designPart2.getObjectID());
        if (propertiesComparator != null) {
            propertiesComparator.copySelectedProperties();
        }
    }

    private void processSchemaObjects(RelationalDesign relationalDesign, RelationalDesign relationalDesign2) {
        if (relationalDesign2.getSchemaObjectSet().size() > 0 && this.count == 0) {
            this.notEmpty = true;
        }
        Iterator iterator = relationalDesign.getSchemaObjectSet().iterator();
        while (iterator.hasNext()) {
            SchemaObject schemaObject = (SchemaObject)iterator.next();
            this.processSchemaObject(relationalDesign2, schemaObject);
        }
    }

    private void processSchemaObject(RelationalDesign relationalDesign, SchemaObject schemaObject) {
        SchemaObject schemaObject2 = (SchemaObject)objectsMap.get(schemaObject.getObjectID());
        if (schemaObject2 == null) {
            schemaObject2 = (SchemaObject)relationalDesign.getSchemaObjectSet().getByName(schemaObject.getName());
            if (schemaObject2 == null) {
                schemaObject2 = relationalDesign.createSchemaObject(schemaObject.getName());
            }
            schemaObject2.setImportedId(schemaObject.getObjectID());
            objectsMap.put(schemaObject.getObjectID(), schemaObject2);
        }
    }

    private void processNotes(DesignPart designPart, DesignPart designPart2) {
        if (designPart.getNoteSet() != null && designPart2.getNoteSet() != null) {
            Iterator iterator = designPart.getNoteSet().iterator();
            while (iterator.hasNext()) {
                Note note = (Note)iterator.next();
                if (!note.shouldBeMerge()) continue;
                Note note2 = (Note)objectsMap.get(note.getObjectID());
                if (note2 == null) {
                    note2 = designPart2.getNoteSet().createNote(null);
                    note2.setImportedId(note.getObjectID());
                    note2.setText(note.getText());
                    objectsMap.put(note.getObjectID(), note2);
                    continue;
                }
                PropertiesComparator propertiesComparator = (PropertiesComparator)this.comparatorsMap.get(note.getObjectID() + note2.getObjectID());
                if (propertiesComparator == null) continue;
                propertiesComparator.copySelectedProperties();
            }
        }
    }

    private void processEntities(LogicalDesign logicalDesign, LogicalDesign logicalDesign2) {
        Iterator iterator = logicalDesign.getEntitySet().iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            if (entity.shouldBeMerge()) {
                this.processEntity(entity, logicalDesign, logicalDesign2);
            }
            if (entity.getBasedOnStructuredType() == null) {
                this.processAttributes(entity);
            }
            this.processKeys(entity);
        }
        this.processAttributeProps(logicalDesign, logicalDesign2);
    }

    private void processAttributeProps(LogicalDesign logicalDesign, LogicalDesign logicalDesign2) {
        Iterator iterator = logicalDesign.getEntitySet().iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            if (!entity.shouldBeMerge()) continue;
            ContainedObject[] containedObjectArray = entity.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                Attribute attribute;
                Attribute attribute2 = (Attribute)containedObjectArray[i];
                String string = attribute2.getReferedAttribute();
                if (string == null) continue;
                Attribute attribute3 = (Attribute)objectsMap.get(attribute2.getObjectID());
                if (attribute3 == null) {
                    attribute3 = (Attribute)logicalDesign2.getDesign().getDesignObject(attribute2.getObjectID());
                }
                if (attribute3 == null || (attribute = (Attribute)objectsMap.get(string)) == null) continue;
                attribute3.setReferedAttribute(attribute.getObjectID());
            }
        }
    }

    public DesignPartView getCorrespondingSubordinateView(DesignPartView designPartView, String string) {
        for (DesignPartView designPartView2 : designPartView.getSubordinateViews()) {
            if (!string.equals(designPartView2.getDPVId()) && !string.equals(designPartView2.getImportedId())) continue;
            return designPartView2;
        }
        return null;
    }

    private void moveGraphical(LogicalDesign logicalDesign, LogicalDesign logicalDesign2, DesignObject designObject, DesignObject designObject2) {
        float f = (float)Math.sqrt(logicalDesign.getEntitySet().size());
        this.maxTablePerRow = (int)f;
        if (Math.sqrt(f * f) != (double)f) {
            ++this.maxTablePerRow;
        }
        ++this.maxTablePerRow;
        Rectangle2D rectangle2D = logicalDesign2.getMainView().getWorkSpace().getDiagramBounds();
        TopView topView = designObject.getTopView();
        if (topView.getCellView() != null) {
            Dimension dimension = designObject2.getTopView().getSize();
            if (this.count == 0) {
                this.top = (int)((double)((int)rectangle2D.getHeight()) + dimension.getHeight());
                this.left = 20;
            }
            ++this.count;
            this.width = (int)dimension.getWidth();
            this.height = (int)Math.max(dimension.getHeight(), (double)this.height);
            topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), designObject2.getTopView().getSize()));
        }
        this.left = this.left + this.width + 50;
        if (this.count == this.maxTablePerRow) {
            this.count = 0;
            this.left = 20;
            this.top = this.top + this.height + 50;
            this.height = 25;
        }
    }

    private void processEntity(Entity entity, LogicalDesign logicalDesign, LogicalDesign logicalDesign2) {
        Entity entity2 = (Entity)objectsMap.get(entity.getObjectID());
        if (entity2 == null) {
            if (logicalDesign2.getEntitySet().size() > 0 && this.count == 0) {
                this.notEmpty = true;
            }
            entity2 = logicalDesign2.createEntity(entity.getName());
            entity2.setImportedId(entity.getObjectID());
            objectsMap.put(entity.getObjectID(), entity2);
            this.copyPropertiesFromEntityToEntity(entity, entity2, logicalDesign2);
            if (this.notEmpty) {
                this.moveGraphical(logicalDesign, logicalDesign2, (DesignObject)entity2, (DesignObject)entity);
            } else {
                ++this.count;
                this.setObjectBounds(entity, entity2);
            }
        } else {
            PropertiesComparator propertiesComparator = (PropertiesComparator)this.comparatorsMap.get(entity.getObjectID() + entity2.getObjectID());
            if (propertiesComparator != null) {
                propertiesComparator.copySelectedProperties();
            }
        }
    }

    private void processTables(RelationalDesign relationalDesign, RelationalDesign relationalDesign2) {
        Iterator iterator = relationalDesign.getTableSet().iterator();
        while (iterator.hasNext()) {
            Table table;
            Table table2 = (Table)iterator.next();
            if (table2.shouldBeMerge()) {
                Object object;
                table = this.processTable(table2, relationalDesign, relationalDesign2);
                this.processColumns(table2);
                if (table2.getBasedOnStructuredType() != null) {
                    this.processST_Columns(table2);
                }
                this.processIndexes(table2);
                this.processConstraints(table2);
                table.setSpatialTable(table2.isSpatialTable());
                table.getSpatialDefinitions().clear();
                for (Object object2 : table2.getSpatialDefinitions()) {
                    object = new SpatialColumnDefObject(table);
                    ((SpatialColumnDefObject)object2).copyTo((SpatialColumnDefObject)object, objectsMap);
                    table.addSpatialDefinition((SpatialColumnDefObject)object);
                }
                table.setBeforeDrop(table2.getBeforeDrop());
                table.setBeforeCreate(table2.getBeforeCreate());
                table.setAfterCreate(table2.getAfterCreate());
                table.setEndOfScript(table2.getEndOfScript());
                table.setShouldGenerateScript(table2.getShouldGenerateScript());
                table.getColumnGroupsSet().clear();
                for (Object object2 : table2.getColumnGroupsSet()) {
                    object = table.createColumnGroup(((Table.ColumnGroup)object2).getName(), null);
                    table.getColumnGroupsSet().add(object);
                    ((Table.ColumnGroup)object2).copy((Table.ColumnGroup)object, objectsMap);
                }
                continue;
            }
            table = (Table)objectsMap.get(table2.getObjectID());
            if (table == null) continue;
            table.setShouldMerge(false);
        }
    }

    private void processST_Columns(Table table) {
        Table table2 = (Table)objectsMap.get(table.getObjectID());
        if (table2 != null) {
            for (Column column : table.getElementsCollectionImmutable()) {
                String string = column.getStructAttributeID();
                if (string == null) continue;
                ModelIDObject modelIDObject = (ModelIDObject)objectsMap.get(string);
                String string2 = string;
                if (modelIDObject != null) {
                    string2 = modelIDObject.getObjectID();
                }
                if (string2 == null) continue;
                Column column2 = (Column)table2.getElementByStructAttributeID(string2);
                if (column2 == null) {
                    column2 = (Column)table2.getElementByStructAttributeID(string);
                }
                if (column2 == null) continue;
                objectsMap.put(column.getObjectID(), column2);
            }
        }
    }

    private void processIndexes(Table table) {
        Table table2 = (Table)objectsMap.get(table.getObjectID());
        if (table2 != null) {
            KeyObject[] keyObjectArray = table.getKeys();
            for (int i = 0; i < keyObjectArray.length; ++i) {
                Object object;
                KeyObject keyObject = keyObjectArray[i];
                if (keyObject.isFK() || !keyObject.shouldBeMerge()) continue;
                Index index = (Index)objectsMap.get(keyObject.getObjectID());
                if (index == null) {
                    SchemaObject schemaObject;
                    index = table2.createIndex();
                    index.setImportedId(keyObject.getObjectID());
                    object = keyObject.getSchemaObject();
                    if (object != null && (schemaObject = (SchemaObject)objectsMap.get(((ModelIDObject)object).getObjectID())) != null) {
                        index.setSchemaObject(schemaObject);
                    }
                    index.setName(keyObject.getName());
                    objectsMap.put(keyObject.getObjectID(), index);
                    this.copyPropertiesFromIndexToIndex((Index)keyObject, index);
                    continue;
                }
                object = (PropertiesComparator)this.comparatorsMap.get(keyObject.getObjectID() + index.getObjectID());
                if (object == null) continue;
                ((PropertiesComparator)object).copySelectedProperties();
            }
        }
    }

    private void processKeys(Entity entity) {
        Entity entity2 = (Entity)objectsMap.get(entity.getObjectID());
        if (entity2 != null) {
            KeyObject[] keyObjectArray = entity.getKeys();
            for (int i = 0; i < keyObjectArray.length; ++i) {
                KeyObject keyObject = keyObjectArray[i];
                if (keyObject.isFK() || !keyObject.shouldBeMerge()) continue;
                CandidateKey candidateKey = (CandidateKey)objectsMap.get(keyObject.getObjectID());
                if (candidateKey == null) {
                    candidateKey = entity2.createCandidateKey();
                    candidateKey.setImportedId(keyObject.getObjectID());
                    candidateKey.setName(keyObject.getName());
                    objectsMap.put(keyObject.getObjectID(), candidateKey);
                    this.copyPropertiesFromKeyToKey((CandidateKey)keyObject, candidateKey);
                    continue;
                }
                PropertiesComparator propertiesComparator = (PropertiesComparator)this.comparatorsMap.get(keyObject.getObjectID() + candidateKey.getObjectID());
                if (propertiesComparator == null) continue;
                propertiesComparator.copySelectedProperties();
            }
        }
    }

    private void copyPropertiesFromKeyToKey(CandidateKey candidateKey, CandidateKey candidateKey2) {
        ContainedObject[] containedObjectArray;
        if (candidateKey.getGeneratorID() != null && !ModelIDObject.USER_GENERATED.equals(candidateKey.getGeneratorID()) && (containedObjectArray = (ContainedObject[])objectsMap.get(candidateKey.getGeneratorID())) != null && containedObjectArray instanceof Index) {
            candidateKey2.setGeneratorID(containedObjectArray.getObjectID());
        }
        candidateKey2.setComment(candidateKey2.getComment());
        candidateKey2.setNotes(candidateKey2.getNotes());
        containedObjectArray = candidateKey.getElements();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            ContainedObject containedObject = containedObjectArray[i];
            Attribute attribute = (Attribute)objectsMap.get(containedObject.getObjectID());
            if (attribute == null || attribute.getContainer() != candidateKey2.getContainerObject()) continue;
            candidateKey2.add(attribute);
        }
        if (candidateKey.isPK()) {
            candidateKey2.makePK();
        }
    }

    private void copyPropertiesFromIndexToIndex(Index index, Index index2) {
        ContainedObject[] containedObjectArray;
        if (index.getGeneratorID() != null && !ModelIDObject.USER_GENERATED.equals(index.getGeneratorID()) && (containedObjectArray = (ContainedObject[])objectsMap.get(index.getGeneratorID())) != null && containedObjectArray instanceof CandidateKey) {
            index2.setGeneratorID(containedObjectArray.getObjectID());
        }
        index2.setCommentInRDBMS(index.getCommentInRDBMS());
        index2.setComment(index.getComment());
        index2.setNotes(index.getNotes());
        containedObjectArray = index.getElements();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            ContainedObject containedObject = containedObjectArray[i];
            Column column = (Column)objectsMap.get(containedObject.getObjectID());
            if (column == null || column.getContainer() != index2.getContainerObject()) continue;
            String string = index.getColumnSortOrder(containedObject);
            index2.add(column);
            index2.setColumnSortOrder(column, string);
        }
        index2.setIndexState(index.getIndexState());
        index2.setIndexExpression(index.getIndexExpression());
        index2.setSpatialIndex(index.isSpatialIndex());
        index2.setLayerType(index.getLayerType());
        index2.setDimensionsNumber(index.getDimensionsNumber());
        index2.setGeodetic(index.getGeodetic());
    }

    private void processColumns(Table table) {
        ContainedObject[] containedObjectArray = table.getElements();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            ColumnComparator columnComparator;
            Column column = (Column)containedObjectArray[i];
            if (!column.shouldBeMerge()) continue;
            Column column2 = (Column)objectsMap.get(column.getObjectID());
            Table table2 = (Table)objectsMap.get(table.getObjectID());
            if (column2 == null && table2 != null) {
                column2 = table2.createColumn(column.getName());
                column2.setImportedId(column.getObjectID());
                column2.moveToIndex(column.getIndex());
                objectsMap.put(column.getObjectID(), column2);
                MergingModels.copyPropertiesFromColumnToColumn(column, column2);
                continue;
            }
            if (column2 == null || (columnComparator = (ColumnComparator)this.comparatorsMap.get(column.getObjectID() + column2.getObjectID())) == null) continue;
            columnComparator.copySelectedProperties();
            column2.moveToIndex(column.getIndex());
        }
    }

    private void processConstraints(Table table) {
        Table table2 = (Table)objectsMap.get(table.getObjectID());
        if (table2 != null) {
            for (TableLevelConstraint tableLevelConstraint : table.getCheckConstraints()) {
                if (!tableLevelConstraint.shouldBeMerge()) continue;
                TableLevelConstraint tableLevelConstraint2 = (TableLevelConstraint)objectsMap.get(tableLevelConstraint.getObjectID());
                if (tableLevelConstraint2 == null) {
                    tableLevelConstraint2 = table2.createCheckConstraint(tableLevelConstraint.getName(), tableLevelConstraint.getRule());
                    tableLevelConstraint2.setImportedId(tableLevelConstraint.getObjectID());
                    table2.addCheckConstraint(tableLevelConstraint2);
                    objectsMap.put(tableLevelConstraint.getObjectID(), tableLevelConstraint2);
                    continue;
                }
                PropertiesComparator propertiesComparator = (PropertiesComparator)this.comparatorsMap.get(tableLevelConstraint.getObjectID() + tableLevelConstraint2.getObjectID());
                if (propertiesComparator == null) continue;
                propertiesComparator.copySelectedProperties();
            }
        }
    }

    private void processAttributes(Entity entity) {
        ContainedObject[] containedObjectArray = entity.getElements();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            Attribute attribute;
            Attribute attribute2 = (Attribute)containedObjectArray[i];
            if (attribute2.shouldBeMerge()) {
                AttributeComparator attributeComparator;
                attribute = (Attribute)objectsMap.get(attribute2.getObjectID());
                Entity entity2 = (Entity)objectsMap.get(entity.getObjectID());
                if (attribute == null && entity2 != null) {
                    attribute = entity2.createAttribute(attribute2.getName());
                    attribute.setImportedId(attribute2.getObjectID());
                    attribute.moveToIndex(attribute2.getIndex());
                    objectsMap.put(attribute2.getObjectID(), attribute);
                    this.copyPropertiesFromAttributeToAttribute(attribute2, attribute);
                    continue;
                }
                if (attribute == null || (attributeComparator = (AttributeComparator)this.comparatorsMap.get(attribute2.getObjectID() + attribute.getObjectID())) == null) continue;
                attributeComparator.copySelectedProperties();
                attribute.moveToIndex(attribute2.getIndex());
                continue;
            }
            if (!entity.shouldBeMerge() || (attribute = (Attribute)objectsMap.get(attribute2.getObjectID())) == null) continue;
            attribute.moveToIndex(attribute2.getIndex());
        }
    }

    private void copyPropertiesFromAttributeToAttribute(Attribute attribute, Attribute attribute2) {
        DesignObject designObject;
        attribute2.setTemporaryWriteable(true);
        if (attribute.getGeneratorID() != null && !ModelIDObject.USER_GENERATED.equals(attribute.getGeneratorID()) && (designObject = (DesignObject)objectsMap.get(attribute.getGeneratorID())) != null && (designObject instanceof Column || designObject instanceof Relation)) {
            attribute2.setGeneratorID(designObject.getObjectID());
        }
        MergingModels.copyPropertiesFromCOWD_To_COWD(attribute, attribute2, objectsMap);
        attribute2.setSource(attribute.getSource());
        attribute2.setSynonym(attribute.getSynonym());
        attribute2.setPreferredAbbreviation(attribute.getPreferredAbbreviation());
        attribute2.setImportedId(attribute.getObjectID());
        attribute2.setTemporaryWriteable(false);
    }

    private Table processTable(Table table, RelationalDesign relationalDesign, RelationalDesign relationalDesign2) {
        Table table2 = (Table)objectsMap.get(table.getObjectID());
        if (table2 == null) {
            SchemaObject schemaObject;
            if (relationalDesign2.getTableSet().size() > 0 && this.count == 0) {
                this.notEmpty = true;
            }
            table2 = relationalDesign2.createTable();
            table2.setImportedId(table.getObjectID());
            SchemaObject schemaObject2 = table.getSchemaObject();
            if (schemaObject2 != null && (schemaObject = (SchemaObject)objectsMap.get(schemaObject2.getObjectID())) != null) {
                table2.setSchemaObject(schemaObject);
            }
            table2.setName(table.getName());
            objectsMap.put(table.getObjectID(), table2);
            this.copyPropertiesFromTableToTable(table, table2);
            if (this.notEmpty) {
                this.moveGraphical(relationalDesign, relationalDesign2, (DesignObject)table2, (DesignObject)table);
            } else {
                ++this.count;
                this.setObjectBounds(table, table2);
            }
        } else {
            PropertiesComparator propertiesComparator = (PropertiesComparator)this.comparatorsMap.get(table.getObjectID() + table2.getObjectID());
            if (propertiesComparator != null) {
                propertiesComparator.copySelectedProperties();
            }
        }
        return table2;
    }

    private void setObjectBounds(DesignObject designObject, DesignObject designObject2) {
        if (designObject2.getTopView().getCellView() != null && designObject.getTopView().getBounds() != null) {
            designObject2.getTopView().getCellView().setNewBounds(designObject.getTopView().getBounds());
        }
    }

    private void moveGraphical(RelationalDesign relationalDesign, RelationalDesign relationalDesign2, DesignObject designObject, DesignObject designObject2) {
        float f = (float)Math.sqrt(relationalDesign.getTableSet().size());
        this.maxTablePerRow = (int)f;
        if (Math.sqrt(f * f) != (double)f) {
            ++this.maxTablePerRow;
        }
        ++this.maxTablePerRow;
        Rectangle2D rectangle2D = relationalDesign2.getMainView().getWorkSpace().getDiagramBounds();
        TopView topView = designObject.getTopView();
        if (topView.getCellView() != null) {
            Dimension dimension = designObject2.getTopView().getSize();
            if (this.count == 0) {
                this.top = (int)((double)((int)rectangle2D.getHeight()) + dimension.getHeight());
                this.left = 20;
            }
            ++this.count;
            this.width = (int)dimension.getWidth();
            this.height = (int)Math.max(dimension.getHeight(), (double)this.height);
            topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), designObject2.getTopView().getSize()));
        }
        this.left = this.left + this.width + 50;
        if (this.count == this.maxTablePerRow) {
            this.count = 0;
            this.left = 20;
            this.top = this.top + this.height + 50;
            this.height = 25;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPropertiesFromTableToTable(Table table, Table table2) {
        DesignObject designObject;
        if (table.getGeneratorID() != null && !ModelIDObject.USER_GENERATED.equals(table.getGeneratorID()) && (designObject = (DesignObject)objectsMap.get(table.getGeneratorID())) != null && designObject instanceof Entity) {
            table2.setGeneratorID(designObject.getObjectID());
        }
        table2.setMinVolumes(table.getMinVolumes());
        table2.setExpectedVolumes(table.getExpectedVolumes());
        table2.setMaxVolumes(table.getMaxVolumes());
        table2.setGrowthPercent(table.getGrowthPercent());
        table2.setGrowthType(table.getGrowthType());
        table2.setNormalForm(table.getNormalForm());
        table2.setAdequatelyNormalized(table.getAdequatelyNormalized());
        table2.setTypeID(table.getTypeID());
        table2.setScope(table.getScope());
        designObject = table.getBasedOnStructuredType();
        if (designObject != null) {
            StructuredType structuredType = (StructuredType)CompareModelToModel.getCorrespondingObject(table2.getDesign().getDataTypesDesign().getStructuredTypeSet(), designObject);
            if (structuredType != null) {
                ApplicationView.loading = true;
                try {
                    table2.setBasedOnStructuredType(structuredType);
                }
                finally {
                    ApplicationView.loading = false;
                }
            }
        } else {
            table2.setBasedOnStructuredType(null);
        }
        table2.setAllowTypeSubstitution(table.isAllowTypeSubstitution());
        table2.setComment(table.getComment());
        table2.setCommentInRDBMS(table.getCommentInRDBMS());
        table2.setNotes(table.getNotes());
        table2.setAbbreviation(table.getAbbreviation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPropertiesFromEntityToEntity(Entity entity, Entity entity2, LogicalDesign logicalDesign) {
        DesignObject designObject;
        if (entity.getGeneratorID() != null && !ModelIDObject.USER_GENERATED.equals(entity.getGeneratorID()) && (designObject = (DesignObject)objectsMap.get(entity.getGeneratorID())) != null && designObject instanceof Table) {
            entity2.setGeneratorID(designObject.getObjectID());
        }
        entity2.setOwner(entity.getOwner());
        entity2.setSynonym(entity.getSynonym());
        entity2.setFwdEngineeringStrategyName(entity.getFwdEngineeringStrategyName());
        entity2.setSource(entity.getSource());
        entity2.setTypeID(entity.getTypeID());
        entity2.setScope(entity.getScope());
        designObject = entity.getBasedOnStructuredType();
        if (designObject != null) {
            StructuredType structuredType = (StructuredType)CompareModelToModel.getCorrespondingObject(entity2.getDesign().getDataTypesDesign().getStructuredTypeSet(), designObject);
            if (structuredType != null) {
                ApplicationView.loading = true;
                try {
                    entity2.setBasedOnStructuredType(structuredType);
                }
                finally {
                    ApplicationView.loading = false;
                }
            }
        } else {
            entity2.setBasedOnStructuredType(null);
        }
        entity2.setAllowTypeSubstitution(entity.isAllowTypeSubstitution());
        entity2.setMinVolumes(entity.getMinVolumes());
        entity2.setExpectedVolumes(entity.getExpectedVolumes());
        entity2.setMaxVolumes(entity.getMaxVolumes());
        entity2.setGrowthPercent(entity.getGrowthPercent());
        entity2.setGrowthType(entity.getGrowthType());
        entity2.setNormalForm(entity.getNormalForm());
        entity2.setAdequatelyNormalized(entity.getAdequatelyNormalized());
        entity2.setComment(entity.getComment());
        entity2.setCommentInRDBMS(entity.getCommentInRDBMS());
        entity2.setNotes(entity.getNotes());
        entity2.setSynonym(entity.getSynonym());
        entity2.setSynonymToDisplay(entity.getSynonymToDisplay());
        entity2.setPreferredAbbreviation(entity.getPreferredAbbreviation());
        entity2.setImportedId(entity.getObjectID());
        entity2.setShortName(entity.getShortName());
    }

    private void processRelations(LogicalDesign logicalDesign, LogicalDesign logicalDesign2) {
        Iterator iterator = logicalDesign.getRelationSet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Relation relation = (Relation)iterator.next();
            Relation relation2 = (Relation)objectsMap.get(relation.getObjectID());
            if (!relation.shouldBeMerge()) continue;
            if (relation2 == null) {
                object = (Entity)objectsMap.get(relation.getSourceEntity().getObjectID());
                ObjectListener objectListener = (Entity)objectsMap.get(relation.getTargetEntity().getObjectID());
                if (object != null && objectListener != null) {
                    DesignObject designObject;
                    DesignObject designObject2;
                    relation2 = logicalDesign2.createRelation(relation.getName());
                    relation2.setTargetEntity((Entity)objectListener);
                    relation2.setSourceEntity((Entity)object);
                    relation2.setSourceTV((TVEntity)((MultiShapedDesignObject)object).getTopView());
                    relation2.setTargetTV((TVEntity)((MultiShapedDesignObject)((Object)objectListener)).getTopView());
                    objectsMap.put(relation.getObjectID(), relation2);
                    if (relation.getGeneratorID() != null && !ModelIDObject.USER_GENERATED.equals(relation.getGeneratorID()) && (designObject2 = (DesignObject)objectsMap.get(relation.getGeneratorID())) != null && (designObject2 instanceof FKIndexAssociation || designObject2 instanceof Table)) {
                        relation2.setGeneratorID(designObject2.getObjectID());
                    }
                    for (int i = 0; i < relation.getTargetEntity().getAllElementsGeneratedBy(relation).length; ++i) {
                        designObject = (Attribute)relation.getTargetEntity().getAllElementsGeneratedBy(relation)[i];
                        Attribute attribute = (Attribute)((ContainerObject)objectListener).getElementByName(designObject.getName());
                        if (attribute == null) continue;
                        String string = designObject.getReferedAttribute();
                        Attribute attribute2 = (Attribute)relation.getSourceEntity().getElementByID(string);
                        if (attribute2 != null) {
                            Attribute attribute3 = (Attribute)((ContainerObject)object).getElementByName(attribute2.getName());
                            attribute.setReferedAttribute(attribute3.getObjectID());
                        }
                        attribute.setGeneratorID(relation2.getObjectID());
                    }
                    relation2.setFireCardinalityChange(false);
                    if (relation.isIdentifying()) {
                        relation2.setIdentifying(relation.isIdentifying());
                    }
                    if ((designObject2 = relation.getDominantRole()) != null && designObject2 != relation.getNONEEntity() && (designObject = (DesignObject)objectsMap.get(designObject2.getObjectID())) != null && designObject instanceof Entity) {
                        relation2.setDominantRole((Entity)designObject);
                    }
                    relation2.setOptionalSource(relation.isOptionalSource());
                    relation2.setOptionalTarget(relation.isOptionalTarget());
                    relation2.setSourceCardinality(relation.getSourceCardinality());
                    relation2.setFireCardinalityChange(true);
                    relation2.setTargetCardinality(relation.getTargetCardinality());
                    relation2.setBelongsToSourcePK(relation.belongsToSourcePK());
                    relation2.setBelongsToTargetPK(relation.belongsToTargetPK());
                    relation2.setImportedId(relation.getObjectID());
                }
            } else {
                object = (PropertiesComparator)this.comparatorsMap.get(relation.getObjectID() + relation2.getObjectID());
                if (object != null) {
                    ((PropertiesComparator)object).copySelectedProperties();
                }
            }
            if (relation2 == null) continue;
            for (ObjectListener objectListener : relation2.getAllTVRelations()) {
                ((TVRelation)objectListener).resetEdgeParams();
            }
        }
    }

    private void processInheritances(LogicalDesign logicalDesign, LogicalDesign logicalDesign2) {
        Iterator iterator = logicalDesign.getInheritanceRelationSet().iterator();
        while (iterator.hasNext()) {
            Object object;
            InheritanceRelation inheritanceRelation = (InheritanceRelation)iterator.next();
            if (!inheritanceRelation.shouldBeMerge()) continue;
            InheritanceRelation inheritanceRelation2 = (InheritanceRelation)objectsMap.get(inheritanceRelation.getObjectID());
            if (inheritanceRelation2 == null) {
                object = inheritanceRelation.getSourceEntity();
                Entity entity = inheritanceRelation.getTargetEntity();
                if (object == null || entity == null) continue;
                Entity entity2 = (Entity)objectsMap.get(((ModelIDObject)object).getObjectID());
                Entity entity3 = (Entity)objectsMap.get(entity.getObjectID());
                if (entity2 == null || entity3 == null) continue;
                entity3.setHierarchicalParent(entity2);
                InheritanceRelation inheritanceRelation3 = (InheritanceRelation)entity3.getInheritanceRelation();
                if (inheritanceRelation3 == null) continue;
                inheritanceRelation3.setName(inheritanceRelation.getName());
                inheritanceRelation3.setImportedId(inheritanceRelation.getObjectID());
                inheritanceRelation3.setComment(inheritanceRelation.getComment());
                inheritanceRelation3.setCommentInRDBMS(inheritanceRelation.getCommentInRDBMS());
                inheritanceRelation3.setNotes(inheritanceRelation.getNotes());
                objectsMap.put(inheritanceRelation.getObjectID(), inheritanceRelation3);
                continue;
            }
            object = (PropertiesComparator)this.comparatorsMap.get(inheritanceRelation.getObjectID() + inheritanceRelation2.getObjectID());
            if (object == null) continue;
            ((PropertiesComparator)object).copySelectedProperties();
        }
    }

    private void processForeignKeys() {
        for (int i = 0; i < this.fkeys.size(); ++i) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)this.fkeys.get(i);
            FKIndexAssociation fKIndexAssociation2 = (FKIndexAssociation)objectsMap.get(fKIndexAssociation.getObjectID());
            if (!fKIndexAssociation.shouldBeMerge()) continue;
            if (fKIndexAssociation2 == null) {
                if (!fKIndexAssociation.getLocalFKIndex().shouldBeMerge()) continue;
                this.processFK(fKIndexAssociation);
                continue;
            }
            PropertiesComparator propertiesComparator = (PropertiesComparator)this.comparatorsMap.get(fKIndexAssociation.getObjectID() + fKIndexAssociation2.getObjectID());
            if (propertiesComparator == null) continue;
            propertiesComparator.copySelectedProperties();
            this.synchronizeFKColumns(fKIndexAssociation, fKIndexAssociation2);
        }
    }

    public void processFK(FKIndexAssociation fKIndexAssociation) {
        Index index;
        KeyObject keyObject;
        Table table = fKIndexAssociation.getRemoteTable();
        Table table2 = (Table)fKIndexAssociation.getContainerWithKeyObject();
        Table table3 = (Table)objectsMap.get(table.getObjectID());
        Table table4 = (Table)objectsMap.get(table2.getObjectID());
        if (table3 != null && table4 != null && (keyObject = (KeyObject)objectsMap.get((index = fKIndexAssociation.getRemoteIndex()).getObjectID())) != null) {
            DesignObject designObject;
            FKIndexAssociation fKIndexAssociation2 = table4.addFK(keyObject);
            fKIndexAssociation2.setImportedId(table.getObjectID());
            fKIndexAssociation.copy(fKIndexAssociation2);
            fKIndexAssociation2.setName(fKIndexAssociation.getName());
            objectsMap.put(fKIndexAssociation.getObjectID(), fKIndexAssociation2);
            if (fKIndexAssociation.getGeneratorID() != null && !ModelIDObject.USER_GENERATED.equals(fKIndexAssociation.getGeneratorID()) && (designObject = (DesignObject)objectsMap.get(fKIndexAssociation.getGeneratorID())) != null && designObject instanceof Table) {
                fKIndexAssociation2.setGeneratorID(designObject.getObjectID());
            }
            this.synchronizeFKColumns(fKIndexAssociation, fKIndexAssociation2);
            fKIndexAssociation2.setDeleteRule(fKIndexAssociation.getDeleteRule());
            fKIndexAssociation2.setComment(fKIndexAssociation.getComment());
            fKIndexAssociation2.setCommentInRDBMS(fKIndexAssociation.getCommentInRDBMS());
            fKIndexAssociation2.setNotes(fKIndexAssociation.getNotes());
            fKIndexAssociation2.setMandatory(fKIndexAssociation.isMandatory());
            fKIndexAssociation2.setTransferable(fKIndexAssociation.isTransferable());
            fKIndexAssociation2.resetEdgeParams();
        }
    }

    public void synchronizeFKColumns(FKIndexAssociation fKIndexAssociation, FKIndexAssociation fKIndexAssociation2) {
        KeyObject keyObject = fKIndexAssociation.getKeyObject();
        if (keyObject != null) {
            int n;
            Column[] columnArray = (Column[])keyObject.getElements();
            Table table = (Table)fKIndexAssociation.getContainerWithKeyObject();
            Table table2 = (Table)fKIndexAssociation2.getContainerWithKeyObject();
            ArrayList<Column> arrayList = new ArrayList<Column>();
            for (n = 0; n < columnArray.length; ++n) {
                Column column = table.getFKColumn(fKIndexAssociation, columnArray[n]);
                if (column == null) continue;
                Column column2 = (Column)objectsMap.get(column.getObjectID());
                Column column3 = null;
                if (column2 != null) {
                    column3 = (Column)objectsMap.get(columnArray[n].getObjectID());
                    if (column3 == null) continue;
                    column2.addFKAssociation(column3, fKIndexAssociation2);
                    fKIndexAssociation2.getLocalFKIndex().add(column2);
                    arrayList.add(column2);
                    continue;
                }
                column3 = (Column)objectsMap.get(columnArray[n].getObjectID());
                if (column3 == null) continue;
                column2 = table2.createColumnFK(column3, fKIndexAssociation2);
                column2.setName(column.getName());
                MergingModels.copyPropertiesFromColumnToColumn(column, column2);
                fKIndexAssociation2.getLocalFKIndex().add(column2);
                arrayList.add(column2);
            }
            for (n = 0; n < arrayList.size(); ++n) {
                fKIndexAssociation2.getLocalFKIndex().moveToIndex((ContainedObject)arrayList.get(n), n);
            }
        }
    }

    private void processTableViews(RelationalDesign relationalDesign, RelationalDesign relationalDesign2) {
        Iterator iterator = relationalDesign.getTableViewSet().iterator();
        while (iterator.hasNext()) {
            TableView tableView = (TableView)iterator.next();
            if (!tableView.shouldBeMerge()) continue;
            this.processTableView(tableView, relationalDesign, relationalDesign2);
        }
    }

    private void processTableView(TableView tableView, RelationalDesign relationalDesign, RelationalDesign relationalDesign2) {
        TableView tableView2 = (TableView)objectsMap.get(tableView.getObjectID());
        if (tableView2 == null) {
            SchemaObject schemaObject;
            if (relationalDesign2.getTableViewSet().size() > 0 && this.count == 0) {
                this.notEmpty = true;
            }
            tableView2 = relationalDesign2.createTableView(tableView.getName());
            tableView2.setImportedId(tableView.getObjectID());
            objectsMap.put(tableView.getObjectID(), tableView2);
            SchemaObject schemaObject2 = tableView.getSchemaObject();
            if (schemaObject2 != null && (schemaObject = (SchemaObject)objectsMap.get(schemaObject2.getObjectID())) != null) {
                tableView2.setSchemaObject(schemaObject);
            }
            this.copyPropertiesFromTableViewToTableView(tableView, tableView2, relationalDesign);
            if (this.notEmpty) {
                this.moveGraphical(relationalDesign, relationalDesign2, (DesignObject)tableView2, (DesignObject)tableView);
            } else {
                ++this.count;
                this.setObjectBounds(tableView, tableView2);
            }
        } else {
            PropertiesComparator propertiesComparator = (PropertiesComparator)this.comparatorsMap.get(tableView.getObjectID() + tableView2.getObjectID());
            if (propertiesComparator != null) {
                propertiesComparator.copySelectedProperties();
            }
        }
    }

    private void copyPropertiesFromTableViewToTableView(TableView tableView, TableView tableView2, RelationalDesign relationalDesign) {
        DesignObject designObject;
        DesignObject designObject2;
        DesignObject designObject3;
        if (tableView.getGeneratorID() != null && !ModelIDObject.USER_GENERATED.equals(tableView.getGeneratorID()) && (designObject3 = (DesignObject)objectsMap.get(tableView.getGeneratorID())) != null && designObject3 instanceof EntityView) {
            tableView2.setGeneratorID(designObject3.getObjectID());
        }
        tableView2.setSyntaxProvider(tableView.getSyntaxProvider());
        tableView2.setComment(tableView.getComment());
        tableView2.setCommentInRDBMS(tableView.getCommentInRDBMS());
        tableView2.setNotes(tableView.getNotes());
        tableView2.setWhere(tableView.getWhere());
        tableView2.setGroupBy(tableView.getGroupBy());
        tableView2.setHaving(tableView.getHaving());
        tableView2.setUserDefined(tableView.getUserDefined());
        tableView2.setUserDefinedSQL(tableView.getUserDefinedSQL());
        designObject3 = tableView.getBasedOnStructuredType();
        if (designObject3 != null) {
            StructuredType structuredType = (StructuredType)objectsMap.get(designObject3.getObjectID());
            if (structuredType != null) {
                tableView2.setBasedOnStructuredType(structuredType);
            }
        } else {
            tableView2.setBasedOnStructuredType(null);
        }
        for (Object object : tableView.getContainerMap().keySet()) {
            String string = tableView.getContainerID((String)object);
            designObject2 = (Table)relationalDesign.getTableSet().getObjectByID(string);
            if (designObject2 == null || (designObject = (Table)objectsMap.get(designObject2.getObjectID())) == null) continue;
            tableView2.addToContainers((ContainerObject)designObject, (String)object);
        }
        for (String string : tableView.getOrderByMap().keySet()) {
            Object object;
            object = (ColumnView)tableView.getObjectByID(tableView.getOrderByList(), string);
            if (object != null) {
                designObject2 = new ColumnView(tableView2.getDesignPart());
                designObject2.setDesign(tableView2.getDesign());
                this.copyColumnToColumn((ColumnView)object, (ColumnView)designObject2);
                ((AbstractViewElement)designObject2).setView(tableView2);
                tableView2.addToOrderBy((ContainedObject)designObject2, (String)tableView.getOrderByMap().get(string));
                objectsMap.put(((ModelIDObject)object).getObjectID(), designObject2);
                continue;
            }
            System.out.println("MergingCWDDesigns.copyPropertiesFromTableViewToTableView: Unable to find ColumnView: " + string);
        }
        if (!tableView.isBST()) {
            for (int i = 0; i < tableView.getElements().length; ++i) {
                designObject2 = (ColumnView)tableView.getElements()[i];
                designObject = new ColumnView(tableView2.getDesignPart());
                designObject.setDesign(tableView2.getDesign());
                this.copyColumnToColumn((ColumnView)designObject2, (ColumnView)designObject);
                ((AbstractViewElement)designObject).setView(tableView2);
                ((ContainedObject)designObject).setContainer(tableView2);
                tableView2.add((ContainedObject)designObject);
                objectsMap.put(designObject2.getObjectID(), designObject);
            }
        }
        for (int i = 0; i < tableView.getGroupByList().size(); ++i) {
            designObject2 = (ColumnView)tableView.getGroupByList().get(i);
            designObject = (ColumnView)objectsMap.get(designObject2.getObjectID());
            if (designObject == null) continue;
            tableView2.addGroupByList((ContainedObject)designObject);
        }
    }

    public void copyColumnToColumn(ColumnView columnView, ColumnView columnView2) {
        DesignObject designObject;
        if (columnView.getGeneratorID() != null && !ModelIDObject.USER_GENERATED.equals(columnView.getGeneratorID()) && (designObject = (DesignObject)objectsMap.get(columnView.getGeneratorID())) != null && designObject instanceof AttributeView) {
            columnView2.setGeneratorID(designObject.getObjectID());
        }
        columnView.copyDefaults(columnView2);
        columnView2.setTableAlias(columnView.getTableAlias());
        columnView2.setAlias(columnView.getAlias());
        columnView2.setExpression(columnView.getExpression());
        columnView2.setDataType(columnView.getDataType());
        if (columnView.getReferencedColumn() != null) {
            designObject = (Column)objectsMap.get(columnView.getReferencedColumn().getObjectID());
            columnView2.setReferencedColumn((ContainedObjectWithDomain)designObject);
        }
        if (columnView.getTable() != null) {
            designObject = (Table)objectsMap.get(columnView.getTable().getObjectID());
            columnView2.setTable((ContainerWithKeyObject)designObject);
        }
        columnView2.setScopeId(columnView.getScopeId());
        columnView2.setReference(columnView.isReference());
        columnView2.setStructuredType(columnView.getStructuredType());
    }

    private void processEntityViews(LogicalDesign logicalDesign, LogicalDesign logicalDesign2) {
        Iterator iterator = logicalDesign.getEntityViewSet().iterator();
        while (iterator.hasNext()) {
            EntityView entityView = (EntityView)iterator.next();
            if (!entityView.shouldBeMerge()) continue;
            this.processEntityView(entityView, logicalDesign, logicalDesign2);
        }
    }

    private void processEntityView(EntityView entityView, LogicalDesign logicalDesign, LogicalDesign logicalDesign2) {
        EntityView entityView2 = (EntityView)objectsMap.get(entityView.getObjectID());
        if (entityView2 == null) {
            if (logicalDesign2.getEntityViewSet().size() > 0 && this.count == 0) {
                this.notEmpty = true;
            }
            entityView2 = logicalDesign2.createEntityView(entityView.getName());
            entityView2.setImportedId(entityView.getObjectID());
            objectsMap.put(entityView.getObjectID(), entityView2);
            this.copyPropertiesFromEntityViewToEntityView(entityView, entityView2, logicalDesign);
            if (this.notEmpty) {
                this.moveGraphical(logicalDesign, logicalDesign2, (DesignObject)entityView2, (DesignObject)entityView);
            } else {
                ++this.count;
                this.setObjectBounds(entityView, entityView2);
            }
        } else {
            PropertiesComparator propertiesComparator = (PropertiesComparator)this.comparatorsMap.get(entityView.getObjectID() + entityView2.getObjectID());
            if (propertiesComparator != null) {
                propertiesComparator.copySelectedProperties();
            }
        }
    }

    private void copyPropertiesFromEntityViewToEntityView(EntityView entityView, EntityView entityView2, LogicalDesign logicalDesign) {
        DesignObject designObject;
        DesignObject designObject2;
        Iterator iterator;
        if (entityView.getGeneratorID() != null && !ModelIDObject.USER_GENERATED.equals(entityView.getGeneratorID()) && (iterator = (DesignObject)objectsMap.get(entityView.getGeneratorID())) != null && iterator instanceof TableView) {
            entityView2.setGeneratorID(((ModelIDObject)((Object)iterator)).getObjectID());
        }
        entityView2.setComment(entityView.getComment());
        entityView2.setCommentInRDBMS(entityView.getCommentInRDBMS());
        entityView2.setNotes(entityView.getNotes());
        entityView2.setWhere(entityView.getWhere());
        entityView2.setGroupBy(entityView.getGroupBy());
        entityView2.setHaving(entityView.getHaving());
        entityView2.setUserDefined(entityView.getUserDefined());
        entityView2.setUserDefinedSQL(entityView.getUserDefinedSQL());
        entityView2.setBasedOnStructuredType(entityView.getBasedOnStructuredType());
        for (Object object : entityView.getContainerMap().keySet()) {
            String string = entityView.getContainerID((String)object);
            designObject2 = (Entity)logicalDesign.getEntitySet().getObjectByID(string);
            if (designObject2 == null || (designObject = (Entity)objectsMap.get(designObject2.getObjectID())) == null) continue;
            entityView2.addToContainers((ContainerObject)designObject, (String)object);
        }
        for (String string : entityView.getOrderByMap().keySet()) {
            Object object;
            object = (AttributeView)entityView.getObjectByID(entityView.getOrderByList(), string);
            if (object != null) {
                designObject2 = new AttributeView(entityView2.getDesignPart());
                designObject2.setDesign(entityView2.getDesign());
                this.copyAttributeToAttribute((AttributeView)object, (AttributeView)designObject2);
                ((AbstractViewElement)designObject2).setView(entityView2);
                entityView2.addToOrderBy((ContainedObject)designObject2, (String)entityView.getOrderByMap().get(string));
                objectsMap.put(((ModelIDObject)object).getObjectID(), designObject2);
                continue;
            }
            System.out.println("MergingCWDDesigns.copyPropertiesFromTableViewToTableView: Unable to find ColumnView: " + string);
        }
        if (!entityView.isBST()) {
            for (int i = 0; i < entityView.getElements().length; ++i) {
                designObject2 = (AttributeView)entityView.getElements()[i];
                designObject = new AttributeView(entityView2.getDesignPart());
                designObject.setDesign(entityView2.getDesign());
                this.copyAttributeToAttribute((AttributeView)designObject2, (AttributeView)designObject);
                ((AbstractViewElement)designObject).setView(entityView2);
                ((ContainedObject)designObject).setContainer(entityView2);
                entityView2.add((ContainedObject)designObject);
                objectsMap.put(designObject2.getObjectID(), designObject);
            }
        }
        for (int i = 0; i < entityView.getGroupByList().size(); ++i) {
            designObject2 = (AttributeView)entityView.getGroupByList().get(i);
            designObject = (AttributeView)objectsMap.get(designObject2.getObjectID());
            if (designObject == null) continue;
            entityView2.addGroupByList((ContainedObject)designObject);
        }
    }

    public void copyAttributeToAttribute(AttributeView attributeView, AttributeView attributeView2) {
        DesignObject designObject;
        if (attributeView.getGeneratorID() != null && !ModelIDObject.USER_GENERATED.equals(attributeView.getGeneratorID()) && (designObject = (DesignObject)objectsMap.get(attributeView.getGeneratorID())) != null && designObject instanceof ColumnView) {
            attributeView2.setGeneratorID(designObject.getObjectID());
        }
        attributeView.copyDefaults(attributeView2);
        attributeView2.setTableAlias(attributeView.getTableAlias());
        attributeView2.setAlias(attributeView.getAlias());
        attributeView2.setExpression(attributeView.getExpression());
        attributeView2.setDataType(attributeView.getDataType());
        if (attributeView.getReferencedColumn() != null) {
            designObject = (Attribute)objectsMap.get(attributeView.getReferencedAttribute().getObjectID());
            attributeView2.setReferencedAttribute((ContainedObjectWithDomain)designObject);
        }
        if (attributeView.getEntity() != null) {
            designObject = (Entity)objectsMap.get(attributeView.getEntity().getObjectID());
            attributeView2.setEntity((Entity)designObject);
        }
        attributeView2.setScopeId(attributeView.getScopeId());
        attributeView2.setReference(attributeView.isReference());
        attributeView2.setStructuredType(attributeView.getStructuredType());
    }

    private void processLogSubViews(LogicalDesign logicalDesign, LogicalDesign logicalDesign2) {
        Iterator iterator = logicalDesign.getLogicalDesignSubviews().iterator();
        while (iterator.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
            if (!designPartViewPlaceHolder.shouldBeMerge()) continue;
            this.processLogicalSubView(designPartViewPlaceHolder.getDesignPartView(), logicalDesign, logicalDesign2);
        }
    }

    private void processLogicalSubView(DesignPartView designPartView, LogicalDesign logicalDesign, LogicalDesign logicalDesign2) {
        DesignPartView designPartView2 = (DesignPartView)objectsMap.get(designPartView.getDPVId());
        if (designPartView2 == null) {
            designPartView2 = logicalDesign2.createDesignPartSubView();
            designPartView2.setImportedId(designPartView.getDPVId());
            objectsMap.put(designPartView.getDPVId(), designPartView2);
            this.copyPropertiesFromSubViewToSubView(designPartView, designPartView2);
            DesignPartView.copyDisplayDrawingProperties(designPartView, designPartView2);
            this.copyDisplayTopViews(designPartView, designPartView2);
            for (DesignPartView designPartView3 : designPartView.getSubordinateViews()) {
                DesignPartView designPartView4 = this.getCorrespondingSubordinateView(designPartView2, designPartView3.getDPVId());
                if (designPartView4 != null) continue;
                designPartView4 = designPartView2.addSubordinateView();
                designPartView4.setImportedId(designPartView3.getDPVId());
                this.copyPropertiesFromSubViewToSubView(designPartView3, designPartView4);
                DesignPartView.copyDisplayDrawingProperties(designPartView3, designPartView4);
                this.copyDisplayTopViews(designPartView3, designPartView4);
            }
            ++this.count;
        } else {
            PropertiesComparator propertiesComparator = (PropertiesComparator)this.comparatorsMap.get(designPartView.getPlaceHolder().getObjectID());
            if (propertiesComparator != null) {
                propertiesComparator.copySelectedProperties();
            }
        }
    }

    private void copyDisplayTopViews(DesignPartView designPartView, DesignPartView designPartView2) {
        TopView topView;
        Object object;
        DesignObject designObject;
        DesignObject designObject2;
        ApplicationView applicationView = designPartView.getApplicationView();
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        for (TopView topView2 : designPartView.getTopviewsList()) {
            if (topView2.isConnection()) continue;
            designObject2 = topView2.getModel();
            if (designObject2 instanceof Note) {
                // empty if block
            }
            if ((designObject = (DesignObject)objectsMap.get(designObject2.getObjectID())) == null) continue;
            object = designObject.getFirstViewForDPV(designPartView2);
            if (object == null) {
                object = designPartView2.createTopViewFor(designObject);
            } else if (designPartView.isMainDiagram()) {
                topView = designObject2.getFirstViewForDPV(designPartView);
                if (topView != topView2) {
                    object = designPartView2.createTopViewFor(designObject);
                }
            } else {
                topView = (TopView)treeMap.get(topView2.getViewID());
                if (topView == null) {
                    object = ((TopView)object).createViewSynonim(designPartView2);
                }
            }
            applicationView.setGraphicalPropsFor((TopView)object, applicationView.getGraphicalPropsFor(topView2));
            treeMap.put(topView2.getViewID(), object);
        }
        for (TopView topView2 : designPartView.getTopviewsList()) {
            if (!topView2.isConnection() || !(topView2 instanceof TVConnector) || (designObject = (DesignObject)objectsMap.get((designObject2 = topView2.getModel()).getObjectID())) == null || !(designObject instanceof ConnectionInterface)) continue;
            object = (ConnectionInterface)((Object)designObject);
            topView = ((ConnectionInterface)((Object)designObject2)).getSourceTopView(designPartView);
            TopView topView3 = ((ConnectionInterface)((Object)designObject2)).getTargetTopView(designPartView);
            if (topView == null || topView3 == null) continue;
            TopView topView4 = (TopView)treeMap.get(topView.getViewID());
            TopView topView5 = (TopView)treeMap.get(topView3.getViewID());
            if (topView4 == null || topView5 == null) continue;
            object.setSourceTopView(topView4);
            object.setTargetTopView(topView5);
            if (designPartView.isAutoRoute()) continue;
            TVConnector tVConnector = (TVConnector)object.getViewFor(designPartView2);
            DesignPartView.copyConnectionPoints((TVConnector)topView2, tVConnector);
        }
    }

    private void processRelSubViews(RelationalDesign relationalDesign, RelationalDesign relationalDesign2) {
        Iterator iterator = relationalDesign.getPhysicalDesignSubviews().iterator();
        while (iterator.hasNext()) {
            DesignPartViewPlaceHolder designPartViewPlaceHolder = (DesignPartViewPlaceHolder)iterator.next();
            if (!designPartViewPlaceHolder.shouldBeMerge()) continue;
            this.processRelationalSubView(designPartViewPlaceHolder.getDesignPartView(), relationalDesign, relationalDesign2);
        }
    }

    private void processRelationalSubView(DesignPartView designPartView, RelationalDesign relationalDesign, RelationalDesign relationalDesign2) {
        DesignPartView designPartView2 = (DesignPartView)objectsMap.get(designPartView.getDPVId());
        if (designPartView2 == null) {
            designPartView2 = relationalDesign2.createDesignPartSubView();
            designPartView2.setImportedId(designPartView.getDPVId());
            objectsMap.put(designPartView.getDPVId(), designPartView2);
            this.copyPropertiesFromSubViewToSubView(designPartView, designPartView2);
            DesignPartView.copyDisplayDrawingProperties(designPartView, designPartView2);
            this.copyDisplayTopViews(designPartView, designPartView2);
            for (DesignPartView designPartView3 : designPartView.getSubordinateViews()) {
                DesignPartView designPartView4 = this.getCorrespondingSubordinateView(designPartView2, designPartView3.getDPVId());
                if (designPartView4 != null) continue;
                designPartView4 = designPartView2.addSubordinateView();
                designPartView4.setImportedId(designPartView3.getDPVId());
                this.copyPropertiesFromSubViewToSubView(designPartView3, designPartView4);
                DesignPartView.copyDisplayDrawingProperties(designPartView3, designPartView4);
                this.copyDisplayTopViews(designPartView3, designPartView4);
            }
            ++this.count;
        } else {
            PropertiesComparator propertiesComparator = (PropertiesComparator)this.comparatorsMap.get(((DesignPartViewPlaceHolder)designPartView.getPlaceHolder()).getObjectID());
            if (propertiesComparator != null) {
                propertiesComparator.copySelectedProperties();
            }
        }
    }

    private void copyPropertiesFromSubViewToSubView(DesignPartView designPartView, DesignPartView designPartView2) {
        designPartView2.setGeneratorId(designPartView.getPlaceHolder().getObjectID());
        designPartView2.setName(designPartView.getName());
        designPartView2.setMustBeVisible(designPartView.mustBeVisible());
        designPartView2.getPlaceHolder().setComment(designPartView.getPlaceHolder().getComment());
    }

    private void processDistinctTypes(DataTypesDesign dataTypesDesign, DataTypesDesign dataTypesDesign2) {
        for (DistinctType distinctType : this.dtList) {
            this.processDistinctType(distinctType, dataTypesDesign, dataTypesDesign2);
        }
    }

    private void processDistinctType(DistinctType distinctType, DataTypesDesign dataTypesDesign, DataTypesDesign dataTypesDesign2) {
        DistinctType distinctType2 = (DistinctType)this.incompleteTypes.get(distinctType.getObjectID());
        if (distinctType2 != null) {
            this.copyPropertiesFromDistTypeToDistType(distinctType, distinctType2);
            ++this.count;
        } else {
            distinctType2 = (DistinctType)objectsMap.get(distinctType.getObjectID());
            if (distinctType2 == null) {
                distinctType2 = dataTypesDesign2.createDistinctType();
                distinctType2.setImportedId(distinctType.getObjectID());
                objectsMap.put(distinctType.getObjectID(), distinctType2);
                this.copyPropertiesFromDistTypeToDistType(distinctType, distinctType2);
                ++this.count;
            } else {
                PropertiesComparator propertiesComparator = (PropertiesComparator)this.comparatorsMap.get(distinctType.getObjectID() + distinctType2.getObjectID());
                if (propertiesComparator != null) {
                    propertiesComparator.copySelectedProperties();
                }
            }
        }
    }

    private void copyPropertiesFromDistTypeToDistType(DistinctType distinctType, DistinctType distinctType2) {
        distinctType2.setGeneratorID(distinctType.getObjectID());
        distinctType2.setName(distinctType.getName());
        LogicalDatatype logicalDatatype = (LogicalDatatype)distinctType2.getDesign().getLogicalDatatypeSet().getByName(distinctType.getLogicalDataType().getName());
        distinctType2.setLogicalDataType(logicalDatatype);
        distinctType2.setSize(distinctType.getSize());
        distinctType2.setPrecision(distinctType.getPrecision());
        distinctType2.setScale(distinctType.getScale());
        distinctType2.setComment(distinctType.getComment());
        distinctType2.setCommentInRDBMS(distinctType.getCommentInRDBMS());
        distinctType2.setNotes(distinctType.getNotes());
    }

    private void processStructuredTypes(DataTypesDesign dataTypesDesign, DataTypesDesign dataTypesDesign2) {
        for (StructuredType structuredType : this.stList) {
            this.processStructuredType(structuredType, dataTypesDesign, dataTypesDesign2);
            this.processElementType(structuredType);
            this.processMethod(structuredType);
        }
    }

    private void processStructuredType(StructuredType structuredType, DataTypesDesign dataTypesDesign, DataTypesDesign dataTypesDesign2) {
        StructuredType structuredType2 = (StructuredType)this.incompleteTypes.get(structuredType.getObjectID());
        if (structuredType2 != null) {
            this.copyPropertiesFromStrTypeToStrType(structuredType, structuredType2);
            if (this.notEmpty && structuredType != null) {
                this.moveGraphical(dataTypesDesign, dataTypesDesign2, (DesignObject)structuredType2, (DesignObject)structuredType);
            } else {
                ++this.count;
            }
        } else {
            structuredType2 = (StructuredType)objectsMap.get(structuredType.getObjectID());
            if (structuredType2 == null) {
                structuredType2 = dataTypesDesign2.createStructuredType();
                structuredType2.setImportedId(structuredType.getObjectID());
                objectsMap.put(structuredType.getObjectID(), structuredType2);
                this.copyPropertiesFromStrTypeToStrType(structuredType, structuredType2);
                if (this.notEmpty) {
                    this.moveGraphical(dataTypesDesign, dataTypesDesign2, (DesignObject)structuredType2, (DesignObject)structuredType);
                } else {
                    ++this.count;
                }
            } else {
                PropertiesComparator propertiesComparator = (PropertiesComparator)this.comparatorsMap.get(structuredType.getObjectID() + structuredType2.getObjectID());
                if (propertiesComparator != null) {
                    propertiesComparator.copySelectedProperties();
                }
            }
        }
    }

    private void copyPropertiesFromStrTypeToStrType(StructuredType structuredType, StructuredType structuredType2) {
        structuredType2.setName(structuredType.getName());
        MergingCWDDesigns.copySourceStamp(structuredType, structuredType2);
        StructuredType structuredType3 = structuredType.getParentType();
        if (structuredType3 != null) {
            DTInheritance dTInheritance;
            StructuredType structuredType4 = (StructuredType)objectsMap.get(structuredType3.getObjectID());
            structuredType2.setParentType(structuredType4, false);
            DTInheritance dTInheritance2 = structuredType2.getInheritanceRelation();
            if (dTInheritance2 != null && (dTInheritance = structuredType.getInheritanceRelation()) != null) {
                objectsMap.put(dTInheritance.getObjectID(), dTInheritance2);
            }
        }
        structuredType2.setPredefined(structuredType.isPredefined());
        structuredType2.setFinal(structuredType.isFinal());
        structuredType2.setInstantiable(structuredType.isInstantiable());
        structuredType2.setComment(structuredType.getComment());
        structuredType2.setNotes(structuredType.getNotes());
    }

    private static void copySourceStamp(ModelObject modelObject, ModelObject modelObject2) {
        if (modelObject != null && modelObject2 != null) {
            if (!"".equals(modelObject.getSourceConnName()) && "".equals(modelObject2.getSourceConnName())) {
                modelObject2.setSourceConnName(modelObject.getSourceConnName());
                modelObject2.setSourceObjName(modelObject.getSourceObjName());
                modelObject2.setSourceObjSchema(modelObject.getSourceObjSchema());
            }
            if (!"".equals(modelObject.getSourceDDLFile()) && "".equals(modelObject2.getSourceDDLFile())) {
                modelObject2.setSourceDDLFile(modelObject.getSourceDDLFile());
            }
        }
    }

    private void processElementType(StructuredType structuredType) {
        TypeElement[] typeElementArray = structuredType.getElements();
        for (int i = 0; i < typeElementArray.length; ++i) {
            TypeElementComparator typeElementComparator;
            TypeElement typeElement = typeElementArray[i];
            if (!typeElement.shouldBeMerge()) continue;
            TypeElement typeElement2 = (TypeElement)objectsMap.get(typeElement.getObjectID());
            StructuredType structuredType2 = (StructuredType)objectsMap.get(structuredType.getObjectID());
            if (typeElement2 == null && structuredType2 != null) {
                typeElement2 = structuredType2.createTypeElement(typeElement.getName());
                typeElement2.setImportedId(typeElement.getObjectID());
                objectsMap.put(typeElement.getObjectID(), typeElement2);
                this.copyPropertiesFromTypeElemToTypeElem(typeElement, typeElement2);
                continue;
            }
            if (typeElement2 == null || (typeElementComparator = (TypeElementComparator)this.comparatorsMap.get(typeElement.getObjectID() + typeElement2.getObjectID())) == null) continue;
            typeElementComparator.copySelectedProperties();
        }
    }

    private void copyPropertiesFromTypeElemToTypeElem(TypeElement typeElement, TypeElement typeElement2) {
        DTReference dTReference;
        typeElement2.setGeneratorID(typeElement.getObjectID());
        typeElement2.setName(typeElement.getName());
        DesignObject designObject = typeElement.getType();
        DesignObject designObject2 = null;
        if (designObject instanceof LogicalDatatype) {
            designObject2 = typeElement2.getDesign().getLogicalDatatypeSet().getByName(typeElement.getType().getName());
        } else if (typeElement.getType() instanceof DistinctType) {
            designObject2 = CompareModelToModel.getCorrespondingObject(typeElement2.getDesign().getDataTypesDesign().getDistinctTypeSet(), designObject);
        } else if (typeElement.getType() instanceof CollectionType) {
            designObject2 = CompareModelToModel.getCorrespondingObject(typeElement2.getDesign().getDataTypesDesign().getCollectionTypeSet(), designObject);
        } else if (typeElement.getType() instanceof StructuredType) {
            designObject2 = CompareModelToModel.getCorrespondingObject(typeElement2.getDesign().getDataTypesDesign().getStructuredTypeSet(), designObject);
        }
        typeElement2.setType(designObject2);
        typeElement2.setSize(typeElement.getSize());
        typeElement2.setPrecision(typeElement.getPrecision());
        typeElement2.setScale(typeElement.getScale());
        typeElement2.setReference(typeElement.isReference());
        typeElement2.setMandatory(typeElement.isMandatory());
        typeElement2.setComment(typeElement.getComment());
        typeElement2.setNotes(typeElement.getNotes());
        typeElement2.updateReferenceNew();
        DTReference dTReference2 = typeElement2.getReferenceRelation();
        if (dTReference2 != null && (dTReference = typeElement.getReferenceRelation()) != null) {
            objectsMap.put(dTReference.getObjectID(), dTReference2);
        }
        MergingCWDDesigns.copySourceStamp(typeElement, typeElement2);
    }

    private void processMethod(StructuredType structuredType) {
        StructuredType structuredType2 = (StructuredType)objectsMap.get(structuredType.getObjectID());
        if (structuredType2 != null) {
            Method[] methodArray = structuredType.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Method method = methodArray[i];
                if (!method.shouldBeMerge()) continue;
                Method method2 = (Method)objectsMap.get(method.getObjectID());
                if (method2 == null) {
                    method2 = structuredType2.createMethod(method.getName());
                    method2.setImportedId(method.getObjectID());
                    objectsMap.put(method.getObjectID(), method2);
                    this.copyPropertiesFromMethodToMethod(method, method2);
                    continue;
                }
                PropertiesComparator propertiesComparator = (PropertiesComparator)this.comparatorsMap.get(method.getObjectID() + method2.getObjectID());
                if (propertiesComparator == null) continue;
                propertiesComparator.copySelectedProperties();
            }
        }
    }

    private void copyPropertiesFromMethodToMethod(Method method, Method method2) {
        Object object;
        method2.setGeneratorID(method.getObjectID());
        method2.setName(method.getName());
        method2.setConstructor(method.isConstructor());
        method2.setOverriding(method.isOverriding());
        if (method.getOverridedMethod() != null) {
            object = (Method)method2.getDesign().getDataTypesDesign().getMethodSet().getByName(method.getOverridedMethod().getName());
            method2.setOverridedMethod((Method)object);
        }
        if (method.getReturnValue() != null) {
            object = new MethodParam(method2.getDesignPart());
            method.getReturnValue().copyDataType((MethodParam)object);
            method2.setReturnValue((MethodParam)object);
        }
        for (MethodParam methodParam : method.getParameters()) {
            MethodParam methodParam2 = new MethodParam(method2.getDesignPart());
            methodParam.copy(methodParam2);
            methodParam.copyDataType(methodParam2);
            method2.addParameter(methodParam2);
            objectsMap.put(methodParam.getObjectID(), methodParam2);
        }
        method2.setBody(method.getBody());
        method2.setComment(method.getComment());
        method2.setNotes(method.getNotes());
        MergingCWDDesigns.copySourceStamp(method, method2);
    }

    private void processCollectionTypes(DataTypesDesign dataTypesDesign, DataTypesDesign dataTypesDesign2) {
        for (CollectionType collectionType : this.ctList) {
            this.processCollectionType(collectionType, dataTypesDesign, dataTypesDesign2);
        }
    }

    private void processCollectionType(CollectionType collectionType, DataTypesDesign dataTypesDesign, DataTypesDesign dataTypesDesign2) {
        CollectionType collectionType2 = (CollectionType)this.incompleteTypes.get(collectionType.getObjectID());
        if (collectionType2 != null) {
            this.copyPropertiesFromCollTypeToCollType(collectionType, collectionType2);
            ++this.count;
        } else {
            collectionType2 = (CollectionType)objectsMap.get(collectionType.getObjectID());
            if (collectionType2 == null) {
                collectionType2 = dataTypesDesign2.createCollectionType();
                collectionType2.setImportedId(collectionType.getObjectID());
                objectsMap.put(collectionType.getObjectID(), collectionType2);
                this.copyPropertiesFromCollTypeToCollType(collectionType, collectionType2);
                ++this.count;
            } else {
                PropertiesComparator propertiesComparator = (PropertiesComparator)this.comparatorsMap.get(collectionType.getObjectID() + collectionType2.getObjectID());
                if (propertiesComparator != null) {
                    propertiesComparator.copySelectedProperties();
                }
            }
        }
    }

    private void copyPropertiesFromCollTypeToCollType(CollectionType collectionType, CollectionType collectionType2) {
        collectionType2.setGeneratorID(collectionType.getObjectID());
        collectionType2.setName(collectionType.getName());
        collectionType2.setType(collectionType.getType());
        collectionType2.setMaxElement(collectionType.getMaxElement());
        collectionType.getElementType().copyDataType(collectionType2.getElementType());
        DesignObject designObject = collectionType.getDataType();
        if (designObject != null && designObject instanceof Domain) {
            Domain domain = collectionType.getElementType().getDomain();
            Domain domain2 = (Domain)CompareModelToModel.getCorrespondingObject(collectionType2.getDesign().getDomainSet(), domain);
            if (domain2 != null) {
                collectionType2.getElementType().setType(domain2);
            } else {
                domain2 = collectionType2.getDesign().getDomainSet().createDomain();
                domain2.setDesign(collectionType2.getDesign());
                domain2.setOwnerDesign(collectionType2.getDesign());
                domain.copyTo(domain2);
                LogicalDatatype logicalDatatype = (LogicalDatatype)CompareModelToModel.getCorrespondingObject(collectionType2.getDesign().getLogicalDatatypeSet(), domain.getLogicalDatatype());
                if (logicalDatatype != null) {
                    domain2.setLogicalDatatype(logicalDatatype);
                }
                domain2.setFileName(domain.getFileName());
                domain2.setDirty(true);
                collectionType2.getElementType().setType(domain2);
            }
        } else if (designObject != null && !(designObject instanceof LogicalDatatype)) {
            DesignObject designObject2 = (DesignObject)objectsMap.get(designObject.getObjectID());
            collectionType2.getElementType().setType(designObject2);
        }
        collectionType2.setComment(collectionType.getComment());
        collectionType2.setNotes(collectionType.getNotes());
    }

    private void moveGraphical(DataTypesDesign dataTypesDesign, DataTypesDesign dataTypesDesign2, DesignObject designObject, DesignObject designObject2) {
        float f = (float)Math.sqrt(dataTypesDesign.getStructuredTypeSet().size());
        this.maxTablePerRow = (int)f;
        if (Math.sqrt(f * f) != (double)f) {
            ++this.maxTablePerRow;
        }
        ++this.maxTablePerRow;
        TopView topView = designObject.getTopView();
        if (topView.getCellView() != null && designObject2.getTopView() != null) {
            Dimension dimension = designObject2.getTopView().getSize();
            if (this.count == 0) {
                this.top += (int)dimension.getHeight();
                this.left = 20;
            }
            ++this.count;
            this.width = (int)dimension.getWidth();
            this.height = (int)Math.max(dimension.getHeight(), (double)this.height);
            topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), designObject2.getTopView().getSize()));
        }
        this.left = this.left + this.width + 50;
        if (this.count == this.maxTablePerRow) {
            this.count = 0;
            this.left = 20;
            this.top = this.top + this.height + 50;
            this.height = 25;
        }
    }

    private void importMappings(LogicalDesign logicalDesign, ExtendedMap extendedMap) {
        DesignObject designObject;
        ExtendedMap extendedMap2 = logicalDesign.getDesign().getExtendedMap();
        Iterator iterator = logicalDesign.getEntitySet().iterator();
        while (iterator.hasNext()) {
            Object object2;
            designObject = (Entity)iterator.next();
            if (!designObject.shouldBeMerge() || !this.importMapping(designObject, extendedMap2, extendedMap)) continue;
            for (Object object2 : ((ContainerObject)designObject).getElementsCollection()) {
                this.importMapping((DesignObject)object2, extendedMap2, extendedMap);
            }
            object2 = ((ContainerWithKeyObject)designObject).getKeys();
            for (int i = 0; i < ((KeyObject[])object2).length; ++i) {
                this.importMapping(object2[i], extendedMap2, extendedMap);
            }
        }
        iterator = logicalDesign.getRelationSet().iterator();
        while (iterator.hasNext()) {
            designObject = (Relation)iterator.next();
            if (!designObject.shouldBeMerge()) continue;
            this.importMapping(designObject, extendedMap2, extendedMap);
        }
        iterator = logicalDesign.getEntityViewSet().iterator();
        while (iterator.hasNext()) {
            designObject = (EntityView)iterator.next();
            if (!designObject.shouldBeMerge()) continue;
            this.importMapping(designObject, extendedMap2, extendedMap);
        }
    }

    private boolean importMapping(DesignObject designObject, ExtendedMap extendedMap, ExtendedMap extendedMap2) {
        Object object;
        boolean bl = false;
        String string = designObject.getObjectID();
        Object object2 = (DesignObject)objectsMap.get(string);
        if (designObject instanceof Attribute && ((Attribute)designObject).isFKAttribute()) {
            object2 = object = extendedMap2.getDesign().getDesignObject(((ModelIDObject)object2).getObjectID());
        }
        if (object2 != null) {
            object = extendedMap.getOrCreateCollector(designObject);
            for (XtdMapping xtdMapping : ((MappingCollector)object).getAllMappings()) {
                if (xtdMapping.isDeleted()) continue;
                if (xtdMapping.isOwnerDesignPartLoaded() && xtdMapping.isTargetDesignPartLoaded()) {
                    String string2 = xtdMapping.getOtherID(string);
                    DesignObject designObject2 = xtdMapping.getObjectMappedTo(designObject);
                    DesignObject designObject3 = (DesignObject)objectsMap.get(string2);
                    if (designObject3 == null && designObject2 != null && designObject2 instanceof Attribute && ((Attribute)designObject2).isFKAttribute()) {
                        designObject3 = extendedMap2.getDesign().getDesignObject(string2);
                    }
                    if (designObject3 == null) continue;
                    XtdMapping xtdMapping2 = extendedMap2.getMapping((DesignObject)object2, designObject3);
                    bl = true;
                    if (xtdMapping2 != null) continue;
                    extendedMap2.createMapping((DesignObject)object2, designObject3);
                    continue;
                }
                return false;
            }
        }
        return bl;
    }

    private void scanForUsedTypes(DesignHandler designHandler, Design design) {
        ModelIDObject modelIDObject;
        this.dtMap.clear();
        this.ctMap.clear();
        this.stMap.clear();
        this.dtList.clear();
        this.ctList.clear();
        this.stList.clear();
        this.types.clear();
        if (designHandler.isLogicalIsSelected()) {
            this.scanLogicalDesign(design.getLogicalDesign());
        }
        for (String string : designHandler.getSourceRelationalModels()) {
            modelIDObject = (RelationalDesign)designHandler.getSourceDesign().getRelationalDesigns().getById(string);
            this.scanRelationalModel((RelationalDesign)modelIDObject);
        }
        this.scanDataTypesModel(design.getDataTypesDesign());
        this.types.addAll(this.ctList);
        this.types.addAll(this.stList);
        for (int i = 0; i < this.types.size(); ++i) {
            modelIDObject = (DesignObject)this.types.get(i);
            if (modelIDObject instanceof CollectionType) {
                this.scanCollectionType((CollectionType)modelIDObject);
                continue;
            }
            if (!(modelIDObject instanceof StructuredType)) continue;
            this.scanStructuredType((StructuredType)modelIDObject);
        }
    }

    private void scanForUsedTypes(RelationalDesign relationalDesign, Design design) {
        this.dtMap.clear();
        this.ctMap.clear();
        this.stMap.clear();
        this.dtList.clear();
        this.ctList.clear();
        this.stList.clear();
        this.types.clear();
        this.scanRelationalModel(relationalDesign);
        this.scanDataTypesModel(design.getDataTypesDesign());
        this.types.addAll(this.ctList);
        this.types.addAll(this.stList);
        for (int i = 0; i < this.types.size(); ++i) {
            DesignObject designObject = (DesignObject)this.types.get(i);
            if (designObject instanceof CollectionType) {
                this.scanCollectionType((CollectionType)designObject);
                continue;
            }
            if (!(designObject instanceof StructuredType)) continue;
            this.scanStructuredType((StructuredType)designObject);
        }
    }

    private void createIncompleteTypes(DataTypesDesign dataTypesDesign) {
        DesignObject designObject;
        if (dataTypesDesign.getStructuredTypeSet().size() > 1) {
            this.notEmpty = true;
        }
        this.incompleteTypes.clear();
        for (AbstractDTObject abstractDTObject : this.dtList) {
            designObject = (DesignObject)objectsMap.get(abstractDTObject.getObjectID());
            if (designObject != null) continue;
            designObject = dataTypesDesign.createDistinctType();
            designObject.setImportedId(abstractDTObject.getObjectID());
            objectsMap.put(abstractDTObject.getObjectID(), designObject);
            this.incompleteTypes.put(abstractDTObject.getObjectID(), designObject);
        }
        for (AbstractDTObject abstractDTObject : this.ctList) {
            designObject = (DesignObject)objectsMap.get(abstractDTObject.getObjectID());
            if (designObject != null) continue;
            designObject = dataTypesDesign.createCollectionType();
            designObject.setImportedId(abstractDTObject.getObjectID());
            objectsMap.put(abstractDTObject.getObjectID(), designObject);
            this.incompleteTypes.put(abstractDTObject.getObjectID(), designObject);
        }
        for (AbstractDTObject abstractDTObject : this.stList) {
            designObject = null;
            if (abstractDTObject.getName().equalsIgnoreCase("SDO_GEOMETRY")) {
                designObject = dataTypesDesign.getStructuredTypeSet().getByName("SDO_GEOMETRY");
                if (designObject != null) {
                    objectsMap.put(abstractDTObject.getObjectID(), designObject);
                    this.incompleteTypes.put(abstractDTObject.getObjectID(), designObject);
                }
            } else {
                designObject = (DesignObject)objectsMap.get(abstractDTObject.getObjectID());
            }
            if (designObject != null) continue;
            designObject = dataTypesDesign.createStructuredType();
            designObject.setImportedId(abstractDTObject.getObjectID());
            objectsMap.put(abstractDTObject.getObjectID(), designObject);
            this.incompleteTypes.put(abstractDTObject.getObjectID(), designObject);
        }
    }

    private void scanCollectionType(CollectionType collectionType) {
        DesignObject designObject = collectionType.getElementType().getType();
        this.processDataType(designObject);
    }

    private void scanStructuredType(StructuredType structuredType) {
        StructuredType structuredType2 = structuredType.getParentType();
        if (structuredType2 != null && !this.stMap.containsKey(structuredType2.getObjectID())) {
            this.stMap.put(structuredType2.getObjectID(), structuredType2);
            this.stList.add(structuredType2);
            this.types.add(structuredType2);
        }
        this.scanST_Attributes(structuredType);
        this.scanST_Methods(structuredType);
    }

    private void processDataType(DesignObject designObject) {
        if (designObject instanceof CollectionType) {
            if (!this.ctMap.containsKey(designObject.getObjectID())) {
                this.ctMap.put(designObject.getObjectID(), designObject);
                this.ctList.add(designObject);
                this.types.add(designObject);
            }
        } else if (designObject instanceof StructuredType && !this.stMap.containsKey(designObject.getObjectID())) {
            this.stMap.put(designObject.getObjectID(), designObject);
            this.stList.add(designObject);
            this.types.add(designObject);
        }
    }

    private void scanST_Attributes(StructuredType structuredType) {
        TypeElement[] typeElementArray = structuredType.getElements();
        for (int i = 0; i < typeElementArray.length; ++i) {
            DesignObject designObject = typeElementArray[i].getType();
            this.processDataType(designObject);
        }
    }

    private void scanST_Methods(StructuredType structuredType) {
        Method[] methodArray = structuredType.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            DesignObject designObject;
            MethodParam methodParam2;
            for (MethodParam methodParam2 : methodArray[i].getParameters()) {
                designObject = methodParam2.getType();
                this.processDataType(designObject);
            }
            methodParam2 = methodArray[i].getReturnValue();
            if (methodParam2 == null) continue;
            designObject = methodParam2.getType();
            this.processDataType(designObject);
        }
    }

    private void scanLogicalDesign(LogicalDesign logicalDesign) {
        Iterator iterator = logicalDesign.getEntitySet().iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            if (!entity.shouldBeMerge()) continue;
            if (entity.getBasedOnStructuredType() != null) {
                StructuredType structuredType = entity.getBasedOnStructuredType();
                if (this.stMap.containsKey(entity.getObjectID())) continue;
                this.stMap.put(entity.getObjectID(), structuredType);
                this.stList.add(structuredType);
                continue;
            }
            this.scanContainedElements(entity);
        }
    }

    private void scanContainedElements(ContainerWithKeyObject containerWithKeyObject) {
        for (ContainedObjectWithDomain containedObjectWithDomain : containerWithKeyObject.getElementsCollection()) {
            AbstractDTObject abstractDTObject;
            if (containedObjectWithDomain.getUse() == 3) {
                abstractDTObject = containedObjectWithDomain.getStructuredType();
                if (abstractDTObject == null || this.stMap.containsKey(abstractDTObject.getObjectID())) continue;
                this.stMap.put(abstractDTObject.getObjectID(), abstractDTObject);
                this.stList.add(abstractDTObject);
                continue;
            }
            if (containedObjectWithDomain.getUse() == 4) {
                abstractDTObject = containedObjectWithDomain.getCollectionType();
                if (abstractDTObject == null || this.ctMap.containsKey(abstractDTObject.getObjectID())) continue;
                this.ctMap.put(abstractDTObject.getObjectID(), abstractDTObject);
                this.ctList.add(abstractDTObject);
                continue;
            }
            if (containedObjectWithDomain.getUse() != 2 || (abstractDTObject = containedObjectWithDomain.getDistinctType()) == null || this.dtMap.containsKey(abstractDTObject.getObjectID())) continue;
            this.dtMap.put(abstractDTObject.getObjectID(), abstractDTObject);
            this.dtList.add(abstractDTObject);
        }
    }

    private void scanRelationalModel(RelationalDesign relationalDesign) {
        Iterator iterator = relationalDesign.getTableSet().iterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            if (!table.shouldBeMerge()) continue;
            if (table.getBasedOnStructuredType() != null) {
                StructuredType structuredType = table.getBasedOnStructuredType();
                if (structuredType == null || this.stMap.containsKey(table.getObjectID())) continue;
                this.stMap.put(table.getObjectID(), structuredType);
                this.stList.add(structuredType);
                continue;
            }
            this.scanContainedElements(table);
        }
    }

    private void scanDataTypesModel(DataTypesDesign dataTypesDesign) {
        AbstractDTObject abstractDTObject;
        Iterator iterator = dataTypesDesign.getDistinctTypeSet().iterator();
        while (iterator.hasNext()) {
            abstractDTObject = (DistinctType)iterator.next();
            if (abstractDTObject == null || !abstractDTObject.shouldBeMerge() || this.dtMap.containsKey(abstractDTObject.getObjectID())) continue;
            this.dtMap.put(abstractDTObject.getObjectID(), abstractDTObject);
            this.dtList.add(abstractDTObject);
        }
        iterator = dataTypesDesign.getCollectionTypeSet().iterator();
        while (iterator.hasNext()) {
            abstractDTObject = (CollectionType)iterator.next();
            if (abstractDTObject == null || !abstractDTObject.shouldBeMerge() || this.ctMap.containsKey(abstractDTObject.getObjectID())) continue;
            this.ctMap.put(abstractDTObject.getObjectID(), abstractDTObject);
            this.ctList.add(abstractDTObject);
            if (!(((CollectionType)abstractDTObject).getElementType().getType() instanceof StructuredType)) continue;
        }
        iterator = dataTypesDesign.getStructuredTypeSet().iterator();
        while (iterator.hasNext()) {
            abstractDTObject = (StructuredType)iterator.next();
            if (abstractDTObject == null || this.stMap.containsKey(abstractDTObject.getObjectID())) continue;
            this.stMap.put(abstractDTObject.getObjectID(), abstractDTObject);
            this.stList.add(abstractDTObject);
        }
    }

    public void processDataTypesDesign(RelationalDesign relationalDesign, RelationalDesign relationalDesign2, Map map, Map map2) {
        this.comparatorsMap = map;
        objectsMap = map2;
        this.resetAllObjects();
        Design design = relationalDesign.getDesign();
        Design design2 = relationalDesign2.getDesign();
        DataTypesDesign dataTypesDesign = design2.getDataTypesDesign();
        DataTypesDesign dataTypesDesign2 = design.getDataTypesDesign();
        this.scanForUsedTypes(relationalDesign, relationalDesign.getDesign());
        this.createIncompleteTypes(design2.getDataTypesDesign());
        this.processDistinctTypes(design.getDataTypesDesign(), design2.getDataTypesDesign());
        Rectangle2D rectangle2D = dataTypesDesign.getMainView().getWorkSpace().getDiagramBounds();
        if (rectangle2D != null) {
            this.top = (int)rectangle2D.getHeight();
        }
        this.processCollectionTypes(dataTypesDesign2, dataTypesDesign);
        this.processStructuredTypes(dataTypesDesign2, dataTypesDesign);
        this.processNotes(dataTypesDesign2, dataTypesDesign);
        DesignPartView designPartView = dataTypesDesign2.getMainView();
        DesignPartView designPartView2 = dataTypesDesign.getMainView();
        DesignPartView.copyDisplayDrawingProperties(designPartView, designPartView2);
        if (!this.notEmpty) {
            this.copyDisplayTopViews(designPartView, designPartView2);
        }
    }
}

