/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.EntityView;

public class EntityViewComparator
extends PropertiesComparator {
    private EntityView source;
    private EntityView target;

    EntityViewComparator(EntityView entityView, EntityView entityView2) {
        super(entityView, entityView2);
        this.source = entityView;
        this.target = entityView2;
        this.initPropertiesList();
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromViewToView();
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentsAndNotes();
        PropertyHolder propertyHolder = new PropertyHolder(STRUCTURED_TYPE);
        if (this.source != null && this.source.getBasedOnStructuredType() != null) {
            propertyHolder.setLeftValue(this.source.getBasedOnStructuredType().getName());
        } else {
            propertyHolder.setLeftValue("");
        }
        if (this.target != null && this.target.getBasedOnStructuredType() != null) {
            propertyHolder.setRightValue(this.target.getBasedOnStructuredType().getName());
        } else {
            propertyHolder.setRightValue("");
        }
        if (this.source != null && this.target != null && this.source.getBasedOnStructuredType() != this.target.getBasedOnStructuredType()) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(WHERE_PROPERTY);
        propertyHolder.setLeftValue(this.source != null ? this.source.getWhere() : "");
        propertyHolder.setRightValue(this.target != null ? this.target.getWhere() : "");
        if (this.source != null && this.target != null && !this.source.getWhere().equals(this.target.getWhere())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(HAVING_PROPERTY);
        propertyHolder.setLeftValue(this.source != null ? this.source.getHaving() : "");
        propertyHolder.setRightValue(this.target != null ? this.target.getHaving() : "");
        if (this.source != null && this.target != null && !this.source.getHaving().equals(this.target.getHaving())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(USER_DEFINED_DQL);
        propertyHolder.setLeftValue(this.source != null ? this.source.getUserDefinedSQL() : "");
        propertyHolder.setRightValue(this.target != null ? this.target.getUserDefinedSQL() : "");
        if (this.source != null && this.target != null && !this.source.getUserDefinedSQL().equals(this.target.getUserDefinedSQL())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
    }

    private void copyPropertiesFromViewToView() {
        if (this.source != null && this.target != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(STRUCTURED_TYPE)) {
                    this.target.setBasedOnStructuredType(this.source.getBasedOnStructuredType());
                    continue;
                }
                if (engPropertyHolder.getName().equals(WHERE_PROPERTY)) {
                    this.target.setWhere(this.source.getWhere());
                    continue;
                }
                if (engPropertyHolder.getName().equals(HAVING_PROPERTY)) {
                    this.target.setHaving(this.source.getHaving());
                    continue;
                }
                if (!engPropertyHolder.getName().equals(USER_DEFINED_DQL)) continue;
                this.target.setUserDefinedSQL(this.source.getUserDefinedSQL());
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.source != null ? MessageFormat.format(Messages.getString("EntityViewComparator.SourceView"), this.source.getName()) : "";
    }

    @Override
    public String getRightName() {
        return this.target != null ? MessageFormat.format(Messages.getString("EntityViewComparator.TargetView"), this.target.getName()) : "";
    }
}

