/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;

public class DesignHandler {
    private Design sourceDesign;
    private Design targetDesign;
    private Map map = new TreeMap();
    private boolean logicalIsSelected = false;
    private List newRelationals = new ArrayList();
    private List subViews = new ArrayList();
    private List modelsToDeleteOnCancel = new ArrayList();

    public DesignHandler(Design design, Design design2) {
        this.sourceDesign = design;
        this.targetDesign = design2;
    }

    public String getSourceName() {
        return this.sourceDesign.getName();
    }

    public String getTargetName() {
        return this.targetDesign.getName();
    }

    public void addRelationalModelMap(RelationalDesign relationalDesign, RelationalDesign relationalDesign2) {
        this.map.put(relationalDesign.getObjectID(), relationalDesign2.getObjectID());
    }

    public List getSourceRelationalModels() {
        return Arrays.asList(this.map.keySet().toArray());
    }

    public List getTargetRelationalModels() {
        return Arrays.asList(this.map.values().toArray());
    }

    public String getTargetRelationalModelID(String string) {
        return (String)this.map.get(string);
    }

    public Design getSourceDesign() {
        return this.sourceDesign;
    }

    public DataTypesDesign getSourceDataTypesDesign() {
        return this.sourceDesign.getDataTypesDesign();
    }

    public LogicalDesign getSourceLogicalDesign() {
        return this.sourceDesign.getLogicalDesign();
    }

    public Design getTargetDesign() {
        return this.targetDesign;
    }

    public DataTypesDesign getTargetDataTypesDesign() {
        return this.targetDesign.getDataTypesDesign();
    }

    public LogicalDesign getTargetLogicalDesign() {
        return this.targetDesign.getLogicalDesign();
    }

    public boolean isLogicalIsSelected() {
        return this.logicalIsSelected;
    }

    public void setLogicalIsSelected(boolean bl) {
        this.logicalIsSelected = bl;
    }

    public List getNewRelationals() {
        return this.newRelationals;
    }

    public void addNewRelational(RelationalDesign relationalDesign) {
        this.newRelationals.add(relationalDesign);
    }

    public List getSubViews() {
        return this.subViews;
    }

    public void addSubView(DesignPartViewPlaceHolder designPartViewPlaceHolder) {
        this.subViews.add(designPartViewPlaceHolder);
    }

    public List getModelsToDeleteOnCancel() {
        return this.modelsToDeleteOnCancel;
    }
}

