/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.cwddesign;

import java.text.MessageFormat;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;

public class CWDModelComparator
extends PropertiesComparator {
    private DesignPart sourceDes;
    private DesignPart targetDes;

    public CWDModelComparator(DesignPart designPart, DesignPart designPart2) {
        super(null, null);
        this.sourceDes = designPart;
        this.targetDes = designPart2;
        this.initPropertiesList();
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
    }

    protected void initPropertiesList() {
        this.initNameProperty();
        this.initCommentsAndNotes();
    }

    @Override
    public String getLeftName() {
        return this.sourceDes != null ? MessageFormat.format(Messages.getString("CWDModelComparator.SourceModel"), this.sourceDes.getName()) : "";
    }

    @Override
    public String getRightName() {
        return this.targetDes != null ? MessageFormat.format(Messages.getString("CWDModelComparator.TargetModel"), this.targetDes.getName()) : "";
    }

    @Override
    protected void initNameProperty() {
        PropertyHolder propertyHolder = new PropertyHolder(NAME);
        propertyHolder.setLeftValue(this.sourceDes != null ? this.sourceDes.getName() : "");
        propertyHolder.setRightValue(this.targetDes != null ? this.targetDes.getName() : "");
        if (this.sourceDes != null && this.targetDes != null) {
            if (this.caseSensitive) {
                if (!this.sourceDes.getName().equals(this.targetDes.getName())) {
                    propertyHolder.setModified(true);
                    propertyHolder.setSelected(false);
                }
            } else if (!this.sourceDes.getName().equalsIgnoreCase(this.targetDes.getName())) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(false);
            }
        }
        this.propertiesList.add(propertyHolder);
    }

    @Override
    protected void initCommentsAndNotes() {
        PropertyHolder propertyHolder = new PropertyHolder(COMMENT);
        propertyHolder.setLeftValue(this.sourceDes != null ? this.sourceDes.getComment() : "");
        propertyHolder.setRightValue(this.targetDes != null ? this.targetDes.getComment() : "");
        if (this.sourceDes != null && this.targetDes != null && !this.sourceDes.getComment().equals(this.targetDes.getComment())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(NOTES);
        propertyHolder.setLeftValue(this.sourceDes != null ? this.sourceDes.getNotes() : "");
        propertyHolder.setRightValue(this.targetDes != null ? this.targetDes.getNotes() : "");
        if (this.sourceDes != null && this.targetDes != null && !this.sourceDes.getNotes().equals(this.targetDes.getNotes())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
    }

    @Override
    protected void copyPropertiesFromLeftToRight() {
        if (this.sourceDes != null && this.targetDes != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(NAME)) {
                    this.targetDes.setName(this.sourceDes.getName());
                    continue;
                }
                if (engPropertyHolder.getName().equals(COMMENT)) {
                    this.targetDes.setComment(this.sourceDes.getComment());
                    continue;
                }
                if (!engPropertyHolder.getName().equals(NOTES)) continue;
                this.targetDes.setNotes(this.sourceDes.getNotes());
            }
            this.targetDes.setDirty(this.isDirty());
        }
    }

    @Override
    public String getID() {
        if (this.sourceDes != null && this.targetDes != null) {
            return this.sourceDes.getObjectID() + this.targetDes.getObjectID();
        }
        if (this.sourceDes != null) {
            return this.sourceDes.getObjectID();
        }
        if (this.targetDes != null) {
            return this.targetDes.getObjectID();
        }
        return "null";
    }

    public DesignPart getSourceModel() {
        return this.sourceDes;
    }

    public DesignPart getTargetModel() {
        return this.targetDes;
    }
}

