/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;

public class TableConstraintComparator
extends PropertiesComparator {
    private TableLevelConstraint sourceConstraint;
    private TableLevelConstraint targetConstraint;

    public TableConstraintComparator(TableLevelConstraint tableLevelConstraint, TableLevelConstraint tableLevelConstraint2) {
        super(tableLevelConstraint, tableLevelConstraint2);
        this.sourceConstraint = tableLevelConstraint;
        this.targetConstraint = tableLevelConstraint2;
        this.initPropertiesList();
    }

    private void initPropertiesList() {
        this.initNameProperty();
        PropertyHolder propertyHolder = new PropertyHolder(RULE);
        if (this.sourceConstraint != null) {
            propertyHolder.setLeftValue(this.sourceConstraint.getRule());
        }
        if (this.targetConstraint != null) {
            propertyHolder.setRightValue(this.targetConstraint.getRule());
        }
        if (this.sourceConstraint != null && this.targetConstraint != null && !this.sourceConstraint.getRule().equals(this.targetConstraint.getRule())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        if (this.sourceConstraint != null && this.targetConstraint != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected() || !engPropertyHolder.getName().equals(RULE)) continue;
                this.targetConstraint.setRule(this.sourceConstraint.getRule());
            }
        }
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceConstraint == null && this.targetConstraint != null) {
            return true;
        }
        return super.hasToBeDrop();
    }
}

