/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.TableProxy;

public class TableComparator
extends PropertiesComparator {
    private final Table sourceTable;
    private final Table targetTable;
    private TableProxy sourceTableProxy;
    private TableProxy targetTableProxy;

    public TableComparator(Table table, Table table2) {
        super(table, table2);
        this.sourceTable = table;
        this.targetTable = table2;
        this.initPropertiesList();
    }

    public TableComparator(Table table, Table table2, TableProxy tableProxy, TableProxy tableProxy2) {
        super(table, table2);
        this.sourceTable = table;
        this.targetTable = table2;
        this.sourceTableProxy = tableProxy;
        this.targetTableProxy = tableProxy2;
        this.initPropertiesList();
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyPropertiesFromTableToTable();
    }

    protected void initPropertiesList() {
        PropertyHolder propertyHolder;
        this.initNameProperty();
        if (this.sourceTableProxy != null || this.targetTableProxy != null) {
            this.initSchemaProperty();
        }
        this.initCommentsAndNotes();
        if (!DDL_ONLY) {
            propertyHolder = new PropertyHolder(ABBREVIATION);
            propertyHolder.setLeftValue(this.sourceTable != null ? this.sourceTable.getAbbreviation() : "");
            propertyHolder.setRightValue(this.targetTable != null ? this.targetTable.getAbbreviation() : "");
            if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getAbbreviation().equals(this.targetTable.getAbbreviation())) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
            this.propertiesList.add(propertyHolder);
            propertyHolder = new PropertyHolder(TEMP_TABLE_SCOPE);
            propertyHolder.setLeftValue(this.sourceTable != null ? this.sourceTable.getScope() : "");
            propertyHolder.setRightValue(this.targetTable != null ? this.targetTable.getScope() : "");
            if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getScope().equals(this.targetTable.getScope())) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
            this.propertiesList.add(propertyHolder);
            propertyHolder = new PropertyHolder(TABLE_TYPE);
            propertyHolder.setLeftValue(this.sourceTable != null ? this.sourceTable.getDesign().getDLSettings().getClassificationTypeNameByID(this.sourceTable.getTypeID()) : "");
            propertyHolder.setRightValue(this.targetTable != null ? this.targetTable.getDesign().getDLSettings().getClassificationTypeNameByID(this.targetTable.getTypeID()) : "");
            if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getTypeID().equals(this.targetTable.getTypeID())) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
            this.propertiesList.add(propertyHolder);
        }
        propertyHolder = new PropertyHolder(STRUCTURED_TYPE);
        String string = null;
        if (this.sourceTable != null && this.sourceTable.getBasedOnStructuredType() != null) {
            string = this.sourceTable.getBasedOnStructuredType().getName();
            propertyHolder.setLeftValue(string);
        } else {
            propertyHolder.setLeftValue("");
        }
        String string2 = null;
        if (this.targetTable != null && this.targetTable.getBasedOnStructuredType() != null) {
            string2 = this.targetTable.getBasedOnStructuredType().getName();
            propertyHolder.setRightValue(string2);
        } else {
            propertyHolder.setRightValue("");
        }
        if (string != null && string2 != null) {
            if (!string.equalsIgnoreCase(string2)) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
        } else if (string != string2) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(SPATIAL_TABLE);
        propertyHolder.setDDLHolder(true);
        propertyHolder.setLeftValue(this.sourceTable != null ? String.valueOf(this.sourceTable.isSpatialTable()) : "");
        propertyHolder.setRightValue(this.targetTable != null ? String.valueOf(this.targetTable.isSpatialTable()) : "");
        if (this.sourceTable != null && this.targetTable != null && this.sourceTable.isSpatialTable() != this.targetTable.isSpatialTable()) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        if (!DDL_ONLY) {
            propertyHolder = new PropertyHolder(MIN_VOLUMES);
            propertyHolder.setLeftValue(this.sourceTable != null ? this.sourceTable.getMinVolumes() : "");
            propertyHolder.setRightValue(this.targetTable != null ? this.targetTable.getMinVolumes() : "");
            if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getMinVolumes().equals(this.targetTable.getMinVolumes())) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
            this.propertiesList.add(propertyHolder);
            propertyHolder = new PropertyHolder(EXPECTED_VOLUMES);
            propertyHolder.setLeftValue(this.sourceTable != null ? this.sourceTable.getExpectedVolumes() : "");
            propertyHolder.setRightValue(this.targetTable != null ? this.targetTable.getExpectedVolumes() : "");
            if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getExpectedVolumes().equals(this.targetTable.getExpectedVolumes())) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
            this.propertiesList.add(propertyHolder);
            propertyHolder = new PropertyHolder(MAX_VOLUMES);
            propertyHolder.setLeftValue(this.sourceTable != null ? this.sourceTable.getMaxVolumes() : "");
            propertyHolder.setRightValue(this.targetTable != null ? this.targetTable.getMaxVolumes() : "");
            if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getMaxVolumes().equals(this.targetTable.getMaxVolumes())) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
            this.propertiesList.add(propertyHolder);
            propertyHolder = new PropertyHolder(GROWTH_PERCENT);
            propertyHolder.setLeftValue(this.sourceTable != null ? this.sourceTable.getGrowthPercent() : "");
            propertyHolder.setRightValue(this.targetTable != null ? this.targetTable.getGrowthPercent() : "");
            if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getGrowthPercent().equals(this.targetTable.getGrowthPercent())) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
            this.propertiesList.add(propertyHolder);
            propertyHolder = new PropertyHolder(GROWTH_TYPE);
            propertyHolder.setLeftValue(this.sourceTable != null ? this.sourceTable.getGrowthType() : "");
            propertyHolder.setRightValue(this.targetTable != null ? this.targetTable.getGrowthType() : "");
            if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getGrowthType().equals(this.targetTable.getGrowthType())) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
            this.propertiesList.add(propertyHolder);
            propertyHolder = new PropertyHolder(NORMAL_FORM);
            propertyHolder.setLeftValue(this.sourceTable != null ? this.sourceTable.getNormalForm() : "");
            propertyHolder.setRightValue(this.targetTable != null ? this.targetTable.getNormalForm() : "");
            if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getNormalForm().equals(this.targetTable.getNormalForm())) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
            this.propertiesList.add(propertyHolder);
            propertyHolder = new PropertyHolder(ADEQUATELY_NORMALIZED);
            propertyHolder.setLeftValue(this.sourceTable != null ? this.sourceTable.getAdequatelyNormalized() : "");
            propertyHolder.setRightValue(this.targetTable != null ? this.targetTable.getAdequatelyNormalized() : "");
            if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getAdequatelyNormalized().equals(this.targetTable.getAdequatelyNormalized())) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
            this.propertiesList.add(propertyHolder);
        }
        propertyHolder = new PropertyHolder(COLUMNS_ORDER);
        propertyHolder.setLeftValue(this.sourceTable != null ? this.getElementsToString(this.sourceTable) : "");
        propertyHolder.setRightValue(this.targetTable != null ? this.getElementsToString(this.targetTable) : "");
        if (!this.equalColumnsOrderNew(this.sourceTable, this.targetTable)) {
            propertyHolder.setSelected(true);
            propertyHolder.setModified(true);
        }
        if (!this.useColumnsOrder) {
            propertyHolder.setSelected(false);
        }
        this.propertiesList.add(propertyHolder);
        if (!DDL_ONLY) {
            propertyHolder = new PropertyHolder(INCLUDE_SCRIPTS);
            propertyHolder.setDDLHolder(false);
            propertyHolder.setLeftValue(this.sourceTable != null ? String.valueOf(this.sourceTable.getShouldGenerateScript()) : "");
            propertyHolder.setRightValue(this.targetTable != null ? String.valueOf(this.targetTable.getShouldGenerateScript()) : "");
            if (this.sourceTable != null && this.targetTable != null && this.sourceTable.getShouldGenerateScript() != this.targetTable.getShouldGenerateScript()) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
            this.propertiesList.add(propertyHolder);
            propertyHolder = new PropertyHolder(BEFORE_DROP_SCRIPT);
            propertyHolder.setDDLHolder(false);
            propertyHolder.setLeftValue(this.sourceTable != null ? this.sourceTable.getBeforeDrop() : "");
            propertyHolder.setRightValue(this.targetTable != null ? this.targetTable.getBeforeDrop() : "");
            if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getBeforeDrop().equals(this.targetTable.getBeforeDrop())) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
            this.propertiesList.add(propertyHolder);
            propertyHolder = new PropertyHolder(BEFORE_CREATE_SCRIPT);
            propertyHolder.setDDLHolder(false);
            propertyHolder.setLeftValue(this.sourceTable != null ? this.sourceTable.getBeforeCreate() : "");
            propertyHolder.setRightValue(this.targetTable != null ? this.targetTable.getBeforeCreate() : "");
            if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getBeforeCreate().equals(this.targetTable.getBeforeCreate())) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
            this.propertiesList.add(propertyHolder);
            propertyHolder = new PropertyHolder(AFTER_CREATE_SCRIPT);
            propertyHolder.setDDLHolder(false);
            propertyHolder.setLeftValue(this.sourceTable != null ? this.sourceTable.getAfterCreate() : "");
            propertyHolder.setRightValue(this.targetTable != null ? this.targetTable.getAfterCreate() : "");
            if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getAfterCreate().equals(this.targetTable.getAfterCreate())) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
            this.propertiesList.add(propertyHolder);
            propertyHolder = new PropertyHolder(END_OF_SCRIPT);
            propertyHolder.setDDLHolder(false);
            propertyHolder.setLeftValue(this.sourceTable != null ? this.sourceTable.getEndOfScript() : "");
            propertyHolder.setRightValue(this.targetTable != null ? this.targetTable.getEndOfScript() : "");
            if (this.sourceTable != null && this.targetTable != null && !this.sourceTable.getEndOfScript().equals(this.targetTable.getEndOfScript())) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
            this.propertiesList.add(propertyHolder);
        }
    }

    private void copyPropertiesFromTableToTable() {
        if (this.sourceTable != null && this.targetTable != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(TEMP_TABLE_SCOPE)) {
                    this.targetTable.setScope(this.sourceTable.getScope());
                    continue;
                }
                if (engPropertyHolder.getName().equals(ABBREVIATION)) {
                    this.targetTable.setAbbreviation(this.sourceTable.getAbbreviation());
                    continue;
                }
                if (engPropertyHolder.getName().equals(TABLE_TYPE)) {
                    this.targetTable.setTypeID(this.sourceTable.getTypeID());
                    continue;
                }
                if (engPropertyHolder.getName().equals(STRUCTURED_TYPE)) {
                    this.targetTable.setBasedOnStructuredType(this.sourceTable.getBasedOnStructuredType());
                    continue;
                }
                if (engPropertyHolder.getName().equals(SPATIAL_TABLE)) {
                    this.targetTable.setSpatialTable(this.sourceTable.isSpatialTable());
                    continue;
                }
                if (engPropertyHolder.getName().equals(MIN_VOLUMES)) {
                    this.targetTable.setMinVolumes(this.sourceTable.getMinVolumes());
                    continue;
                }
                if (engPropertyHolder.getName().equals(EXPECTED_VOLUMES)) {
                    this.targetTable.setExpectedVolumes(this.sourceTable.getExpectedVolumes());
                    continue;
                }
                if (engPropertyHolder.getName().equals(MAX_VOLUMES)) {
                    this.targetTable.setMaxVolumes(this.sourceTable.getMaxVolumes());
                    continue;
                }
                if (engPropertyHolder.getName().equals(GROWTH_PERCENT)) {
                    this.targetTable.setGrowthPercent(this.sourceTable.getGrowthPercent());
                    continue;
                }
                if (engPropertyHolder.getName().equals(GROWTH_TYPE)) {
                    this.targetTable.setGrowthType(this.sourceTable.getGrowthType());
                    continue;
                }
                if (engPropertyHolder.getName().equals(NORMAL_FORM)) {
                    this.targetTable.setNormalForm(this.sourceTable.getNormalForm());
                    continue;
                }
                if (engPropertyHolder.getName().equals(ADEQUATELY_NORMALIZED)) {
                    this.targetTable.setAdequatelyNormalized(this.sourceTable.getAdequatelyNormalized());
                    continue;
                }
                if (engPropertyHolder.getName().equals(SCHEMA)) {
                    if (this.sourceTableProxy != null && this.targetTableProxy != null && this.sourceTableProxy.getUserSchema() != null) {
                        this.targetTableProxy.setUserSchema(this.sourceTableProxy.getUserSchema().getName());
                    }
                    if (this.sourceTable == null || this.targetTable == null) continue;
                    this.setSchemaObject(this.sourceTable, this.targetTable);
                    continue;
                }
                if (engPropertyHolder.getName().equals(INCLUDE_SCRIPTS)) {
                    this.targetTable.setShouldGenerateScript(this.sourceTable.getShouldGenerateScript());
                    continue;
                }
                if (engPropertyHolder.getName().equals(BEFORE_DROP_SCRIPT)) {
                    this.targetTable.setBeforeDrop(this.sourceTable.getBeforeDrop());
                    continue;
                }
                if (engPropertyHolder.getName().equals(BEFORE_CREATE_SCRIPT)) {
                    this.targetTable.setBeforeCreate(this.sourceTable.getBeforeCreate());
                    continue;
                }
                if (engPropertyHolder.getName().equals(AFTER_CREATE_SCRIPT)) {
                    this.targetTable.setAfterCreate(this.sourceTable.getAfterCreate());
                    continue;
                }
                if (!engPropertyHolder.getName().equals(END_OF_SCRIPT)) continue;
                this.targetTable.setEndOfScript(this.sourceTable.getEndOfScript());
            }
        }
    }

    private void setSchemaObject(Table table, Table table2) {
        SchemaObject schemaObject = table.getSchemaObject();
        if (schemaObject != null) {
            SchemaObject schemaObject2 = (SchemaObject)((RelationalDesign)table2.getDesignPart()).getSchemaObjectSet().getObjectByID(schemaObject.getObjectID());
            if (schemaObject2 == null) {
                schemaObject2 = (SchemaObject)((RelationalDesign)table2.getDesignPart()).getSchemaObjectSet().getByName(schemaObject.getName());
            }
            if (schemaObject2 != null) {
                table2.setSchemaObject(schemaObject2);
            }
        }
    }

    @Override
    public String getLeftName() {
        return this.sourceTable != null ? MessageFormat.format(Messages.getString("TableComparator.SourceTableL"), this.sourceTable.getName()) : "";
    }

    @Override
    public String getRightName() {
        return this.targetTable != null ? MessageFormat.format(Messages.getString("TableComparator.TargetTable"), this.targetTable.getName()) : "";
    }

    private String getElementsToString(Table table) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<ContainedObject> iterator = Arrays.asList(table.getElements()).iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            ContainedObject containedObject = iterator.next();
            if (bl) {
                stringBuffer.append(containedObject.getName());
                bl = false;
                continue;
            }
            stringBuffer.append("; ").append(containedObject.getName());
        }
        return stringBuffer.toString();
    }

    private boolean equalColumnOrder(Table table, Table table2) {
        if (this.sourceTable == null || table2 == null) {
            return true;
        }
        ContainedObject[] containedObjectArray = table.getElements();
        ContainedObject[] containedObjectArray2 = table2.getElements();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            if (i > containedObjectArray2.length - 1) {
                return true;
            }
            Column column = (Column)containedObjectArray[i];
            Column column2 = (Column)containedObjectArray2[i];
            if (column2.getImportedId() != null && column.getObjectID().equals(column2.getImportedId()) || column2.getName().equals(column.getName()) || column2.getDataType().toString().equals(column.getDataType().toString()) && column.getContainer().getElementByName(column2.getName()) == null) continue;
            return false;
        }
        return true;
    }

    private boolean equalColumnsOrderNew(Table table, Table table2) {
        if (this.getLeftSelectionObject() != null) {
            CompareObjectSelection[] compareObjectSelectionArray = this.getColumnNodes(this.getLeftSelectionObject());
            for (int i = 0; i < compareObjectSelectionArray.length; ++i) {
                Column column;
                CompareObjectSelection compareObjectSelection = compareObjectSelectionArray[i];
                if (compareObjectSelection.getStatus() == ModelIdObjectSelection.STATE_NEW && this.isBeforeUnchangedColumn(i, compareObjectSelectionArray)) {
                    return false;
                }
                if (compareObjectSelection.getStatus() != ModelIdObjectSelection.STATE_UNCHANGED && compareObjectSelection.getStatus() != ModelIdObjectSelection.STATE_MODIFIED || (column = (Column)compareObjectSelection.getCorrespondentNode().getObject()) == null || i == column.getIndex()) continue;
                return false;
            }
            return true;
        }
        return this.equalColumnOrder(table, table2);
    }

    private CompareObjectSelection[] getColumnNodes(CompareObjectSelection compareObjectSelection) {
        ArrayList<CompareObjectSelection> arrayList = new ArrayList<CompareObjectSelection>();
        CompareObjectSelection compareObjectSelection2 = (CompareObjectSelection)compareObjectSelection.getChild(0);
        int n = compareObjectSelection2.getNumberOfChildren();
        for (int i = 0; i < n; ++i) {
            CompareObjectSelection compareObjectSelection3 = (CompareObjectSelection)compareObjectSelection2.getChild(i);
            if (compareObjectSelection3.getStatus() == ModelIdObjectSelection.STATE_DELETED || (!compareObjectSelection3.isSelected() || compareObjectSelection3.getStatus() != ModelIdObjectSelection.STATE_NEW) && compareObjectSelection3.getStatus() == ModelIdObjectSelection.STATE_NEW) continue;
            arrayList.add(compareObjectSelection3);
        }
        return arrayList.toArray(new CompareObjectSelection[0]);
    }

    private boolean isBeforeUnchangedColumn(int n, CompareObjectSelection[] compareObjectSelectionArray) {
        for (int i = n + 1; i < compareObjectSelectionArray.length; ++i) {
            if (compareObjectSelectionArray[i].getStatus() != ModelIdObjectSelection.STATE_UNCHANGED) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean hasToBeRename() {
        if (this.sourceTable != null && this.targetTable != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected() || !engPropertyHolder.getName().equals(TABLE_TYPE) && !engPropertyHolder.getName().equals(SCHEMA) && (!this.useColumnsOrder || this.equalColumnsOrderNew(this.sourceTable, this.targetTable))) continue;
                return true;
            }
        }
        return super.hasToBeRename();
    }

    @Override
    protected boolean hasToBeRenameOnly() {
        if (!this.hasToBeRename() && this.sourceTable != null && this.targetTable != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected() || !engPropertyHolder.getName().equals(NAME)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceTable == null && this.targetTable != null) {
            return true;
        }
        return super.hasToBeDrop();
    }

    protected void initSchemaProperty() {
        PropertyHolder propertyHolder = new PropertyHolder(SCHEMA);
        String string = "";
        if (this.sourceTableProxy != null) {
            string = this.sourceTableProxy.getSchemaImplementationName();
        }
        if ("".equals(string) && this.sourceTable != null && this.sourceTable.getSchemaObject() != null) {
            string = this.sourceTable.getSchemaObject().getName();
        }
        String string2 = "";
        if (this.targetTableProxy != null) {
            string2 = this.targetTableProxy.getSchemaImplementationName();
        }
        if ("".equals(string2) && this.targetTable != null && this.targetTable.getSchemaObject() != null) {
            string2 = this.targetTable.getSchemaObject().getName();
        }
        propertyHolder.setLeftValue(string);
        propertyHolder.setRightValue(string2);
        if (this.caseSensitive) {
            if (!propertyHolder.getLeftValue().equals(propertyHolder.getRightValue())) {
                propertyHolder.setModified(true);
                if (this.useSchema) {
                    propertyHolder.setSelected(true);
                } else {
                    propertyHolder.setFiltered(true);
                }
            }
        } else if (!propertyHolder.getLeftValue().equalsIgnoreCase(propertyHolder.getRightValue())) {
            propertyHolder.setModified(true);
            if (this.useSchema) {
                propertyHolder.setSelected(true);
            } else {
                propertyHolder.setFiltered(true);
            }
        }
        this.propertiesList.add(propertyHolder);
    }

    public Table getSourceTable() {
        return this.sourceTable;
    }

    public TableProxy getSourceTableProxy() {
        return this.sourceTableProxy;
    }

    public Table getTargetTable() {
        return this.targetTable;
    }

    public TableProxy getTargetTableProxy() {
        return this.targetTableProxy;
    }

    public void presetColumnsOrder() {
        EngPropertyHolder engPropertyHolder = this.getPropertyHolderByName(COLUMNS_ORDER);
        if (engPropertyHolder != null) {
            if (this.getLeftSelectionObject() != null) {
                engPropertyHolder.setRightValue(this.targetTable != null ? this.getElementsToString(this.targetTable) : "");
                CompareObjectSelection[] compareObjectSelectionArray = this.getColumnNodes(this.getLeftSelectionObject());
                engPropertyHolder.setLeftValue(this.sourceTable != null ? this.getElementsToString(compareObjectSelectionArray) : "");
                if (!this.equalColumnsOrderNew(this.sourceTable, this.targetTable)) {
                    engPropertyHolder.setSelected(true);
                    engPropertyHolder.setModified(true);
                } else {
                    engPropertyHolder.setSelected(false);
                    engPropertyHolder.setModified(false);
                }
            } else {
                engPropertyHolder.setLeftValue(this.sourceTable != null ? this.getElementsToString(this.sourceTable) : "");
                engPropertyHolder.setRightValue(this.targetTable != null ? this.getElementsToString(this.targetTable) : "");
                if (!this.equalColumnsOrderNew(this.sourceTable, this.targetTable)) {
                    engPropertyHolder.setSelected(true);
                    engPropertyHolder.setModified(true);
                }
            }
            if (!this.useColumnsOrder) {
                engPropertyHolder.setSelected(false);
            }
        }
    }

    private String getElementsToString(CompareObjectSelection[] compareObjectSelectionArray) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < compareObjectSelectionArray.length; ++i) {
            ContainedObject containedObject = (ContainedObject)compareObjectSelectionArray[i].getObject();
            if (bl) {
                stringBuffer.append(containedObject.getName());
                bl = false;
                continue;
            }
            stringBuffer.append("; ").append(containedObject.getName());
        }
        return stringBuffer.toString();
    }
}

