/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.util.options.Settings;

public abstract class PropertiesComparator
extends PropertyNames {
    private DesignObject left_do;
    private DesignObject right_do;
    protected List propertiesList = new ArrayList();
    protected boolean isDroped = false;
    protected boolean caseSensitive = false;
    protected boolean useSchema = true;
    protected boolean useColumnsOrder = true;
    protected boolean useDataTypeKind = false;
    protected boolean useGenInDDL = true;
    private CompareObjectSelection selectionObject;
    public static boolean DDL_ONLY = false;

    public PropertiesComparator(DesignObject designObject, DesignObject designObject2) {
        this.left_do = designObject;
        this.right_do = designObject2;
        Settings settings = null;
        if (designObject != null) {
            settings = designObject.getDesignPart().getAppView().getSettings();
        } else if (designObject2 != null) {
            settings = designObject2.getDesignPart().getAppView().getSettings();
        }
        if (settings != null) {
            this.caseSensitive = settings.isCaseSensitiveNamesInCompare();
            this.useSchema = settings.isUseSchemaPropertyInCompare();
            this.useColumnsOrder = settings.isUseColumnsOrderPropertyInCompare();
            this.useDataTypeKind = settings.isUseDataTypeKindInCompare();
            if (DDL_ONLY) {
                this.useGenInDDL = settings.isUseGenInDDLInCompare();
            }
        }
    }

    public List getPropertiesList() {
        return this.propertiesList;
    }

    public abstract void copySelectedProperties();

    public String getLeftName() {
        if (this.left_do != null) {
            return this.left_do.getName();
        }
        return "";
    }

    public String getRightName() {
        if (this.right_do != null) {
            return this.right_do.getName();
        }
        return "";
    }

    protected void initNameProperty() {
        PropertyHolder propertyHolder = new PropertyHolder(NAME);
        propertyHolder.setLeftValue(this.left_do != null ? this.left_do.getName() : "");
        propertyHolder.setRightValue(this.right_do != null ? this.right_do.getName() : "");
        if (this.caseSensitive) {
            if (!propertyHolder.getLeftValue().equals(propertyHolder.getRightValue())) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
        } else if (!propertyHolder.getLeftValue().equalsIgnoreCase(propertyHolder.getRightValue())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
    }

    protected void initCommentsAndNotes() {
        this.initCommentsAndNotes(true);
    }

    protected void initCommentsAndNotes(boolean bl) {
        PropertyHolder propertyHolder;
        if (!DDL_ONLY) {
            propertyHolder = new PropertyHolder(COMMENT);
            propertyHolder.setDDLHolder(false);
            propertyHolder.setLeftValue(this.left_do != null ? this.left_do.getComment() : "");
            propertyHolder.setRightValue(this.right_do != null ? this.right_do.getComment() : "");
            if (this.left_do != null && this.right_do != null && !this.left_do.getComment().equals(this.right_do.getComment())) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
            this.propertiesList.add(propertyHolder);
        }
        if (bl) {
            propertyHolder = new PropertyHolder(COMMENT_IN_RDBMS);
            propertyHolder.setDDLHolder(true);
            propertyHolder.setLeftValue(this.left_do != null ? this.left_do.getCommentInRDBMS() : "");
            propertyHolder.setRightValue(this.right_do != null ? this.right_do.getCommentInRDBMS() : "");
            if (this.left_do != null && this.right_do != null && !this.left_do.getCommentInRDBMS().equals(this.right_do.getCommentInRDBMS())) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
            this.propertiesList.add(propertyHolder);
        }
        if (!DDL_ONLY) {
            propertyHolder = new PropertyHolder(NOTES);
            propertyHolder.setDDLHolder(false);
            propertyHolder.setLeftValue(this.left_do != null ? this.left_do.getNotes() : "");
            propertyHolder.setRightValue(this.right_do != null ? this.right_do.getNotes() : "");
            if (this.left_do != null && this.right_do != null && !this.left_do.getNotes().equals(this.right_do.getNotes())) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
            this.propertiesList.add(propertyHolder);
        }
    }

    protected void copyPropertiesFromLeftToRight() {
        if (this.left_do != null && this.right_do != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(NAME)) {
                    this.right_do.setName(this.left_do.getName());
                    continue;
                }
                if (engPropertyHolder.getName().equals(COMMENT)) {
                    this.right_do.setComment(this.left_do.getComment());
                    continue;
                }
                if (engPropertyHolder.getName().equals(COMMENT_IN_RDBMS)) {
                    this.right_do.setCommentInRDBMS(this.left_do.getCommentInRDBMS());
                    continue;
                }
                if (engPropertyHolder.getName().equals(NOTES)) {
                    this.right_do.setNotes(this.left_do.getNotes());
                    continue;
                }
                if (!engPropertyHolder.getName().equals(INDEX_FUNCTION_EXPRESSION)) continue;
                ((Index)this.right_do).setIndexExpression(((Index)this.left_do).getIndexExpression());
            }
            if (this.isDirty()) {
                this.right_do.setDirty(true);
            }
        }
    }

    public boolean isModified() {
        if (this.left_do != null && this.right_do == null) {
            return true;
        }
        for (EngPropertyHolder engPropertyHolder : this.getPropertiesList()) {
            if (!engPropertyHolder.isModified() || engPropertyHolder.isFiltered()) continue;
            return true;
        }
        return false;
    }

    public String getID() {
        if (this.left_do != null && this.right_do != null) {
            return this.left_do.getObjectID() + this.right_do.getObjectID();
        }
        if (this.left_do != null) {
            return this.left_do.getObjectID();
        }
        if (this.right_do != null) {
            return this.right_do.getObjectID();
        }
        return "null";
    }

    protected boolean hasToBeRename() {
        return false;
    }

    protected boolean hasToBeRenameOnly() {
        return false;
    }

    protected boolean hasToBeDrop() {
        return false;
    }

    protected boolean isDirty() {
        for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
            if (!engPropertyHolder.isModified() || !engPropertyHolder.isSelected()) continue;
            return true;
        }
        return false;
    }

    public CompareObjectSelection getLeftSelectionObject() {
        return this.selectionObject;
    }

    public void setLeftSelectionObject(CompareObjectSelection compareObjectSelection) {
        this.selectionObject = compareObjectSelection;
    }

    public String getChoosedPropertyValue(String string) {
        return this.getChoosedPropertyValue(string, true);
    }

    public String getChoosedPropertyValue(String string, boolean bl) {
        for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
            if (!engPropertyHolder.getName().equals(string)) continue;
            if (!bl) {
                return engPropertyHolder.getRightValue();
            }
            if (this.left_do == null) {
                return engPropertyHolder.getRightValue();
            }
            if (this.right_do == null) {
                return engPropertyHolder.getLeftValue();
            }
            if (engPropertyHolder.isSelected()) {
                return engPropertyHolder.getLeftValue();
            }
            return engPropertyHolder.getRightValue();
        }
        return "";
    }

    public EngPropertyHolder getPropertyHolderByName(String string) {
        for (EngPropertyHolder engPropertyHolder : this.getPropertiesList()) {
            if (!engPropertyHolder.getName().equals(string)) continue;
            return engPropertyHolder;
        }
        return null;
    }

    public boolean isDDLModified() {
        for (EngPropertyHolder engPropertyHolder : this.getPropertiesList()) {
            if (!engPropertyHolder.isSelected() || !engPropertyHolder.isDDLHolder() || engPropertyHolder.isFiltered()) continue;
            return true;
        }
        return false;
    }

    public List getAllSelectedPH() {
        ArrayList<PropertyHolder> arrayList = new ArrayList<PropertyHolder>();
        for (PropertyHolder propertyHolder : this.propertiesList) {
            if (!propertyHolder.isSelected()) continue;
            arrayList.add(propertyHolder);
        }
        return arrayList;
    }
}

