/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.AbstractViewElement;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.compare.AbstractMerging;
import oracle.dbtools.crest.model.design.compare.ColumnComparator;
import oracle.dbtools.crest.model.design.compare.CompareModelToModel;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.cwddesign.MergingCWDDesigns;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.engineering.EngCOPropertiesComparator;
import oracle.dbtools.crest.model.design.logical.Attribute;
import oracle.dbtools.crest.model.design.logical.AttributeView;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.EntityView;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.SequenceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SnapshotOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.compare.ModelChooserDialog;
import oracle.dbtools.crest.util.logging.Logger;

public class MergingModels
extends AbstractMerging {
    private static final Logger LOGGER = new Logger(MergingModels.class);
    private List fkeys = new ArrayList();
    private RelationalDesign sourceDesignPart;
    private RelationalDesign targetDesignPart;
    private static Map allObject;
    double shift = 0.0;
    private int left = 20;
    private int top = 20;
    private int width = 35;
    private int height = 25;
    private int count = 0;
    private int maxTablePerRow;
    private boolean notEmpty = false;

    public MergingModels(Design design) {
        super(design);
    }

    @Override
    public void execute(Map map) {
        this.execute(null, map, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DesignPart designPart, Map map, Map map2) {
        this.comparatorsMap = map;
        AbstractMerging.objectsMap = map2;
        this.design.setPropagatePKChahges(false);
        this.targetDesPartID = designPart.getObjectID();
        this.targetDesignPart = this.design.getRelationalDesign();
        this.sourceDesignPart = (RelationalDesign)designPart;
        try {
            int n;
            this.design.setMerging(true);
            this.design.setCorrespondenceMap(map2);
            this.sourceDesignPart.getDesign().loadDesignLevelSettings();
            MergingModels.createUsedClassificationypes(this.sourceDesignPart, this.targetDesignPart);
            for (n = 0; n < this.sourceDesignPart.getImportConnectionStamps().size(); ++n) {
                this.targetDesignPart.addImportConnectionStamp(this.sourceDesignPart.getImportConnectionStamp(n));
            }
            for (n = 0; n < this.sourceDesignPart.getImportDDLFileStamps().size(); ++n) {
                this.targetDesignPart.addImportDDLFileStamp(this.sourceDesignPart.getImportDDLFileStamp(n));
            }
            MergingCWDDesigns mergingCWDDesigns = new MergingCWDDesigns();
            mergingCWDDesigns.processDataTypesDesign(this.sourceDesignPart, this.targetDesignPart, map, map2);
            this.fkeys.clear();
            this.sourceDesignPart.getFKIndexAssociationSet().addAllElementsTo(this.fkeys);
            this.resetAllObjects();
            this.processSchemaObjects();
            if (ModelChooserDialog.isSelectedDatabase) {
                this.proccessSnapshots();
                this.proccessSequence();
            }
            this.processTables();
            this.processForeignKeys();
            this.reorderColumns();
            this.processTableViews();
            if (ModelChooserDialog.isSelectedDatabase) {
                ApplicationView.loading = true;
                this.sourceDesignPart.getStorageDesign().cloneFromMemoryToAnotherSD_MD(this.targetDesignPart.getStorageDesign(), map2, true);
                this.targetDesignPart.getStorageDesign().setOpen(true);
                this.targetDesignPart.getStorageDesign().setTempModel(false);
                this.targetDesignPart.getStorageDesign(this.targetDesignPart.getSelectedRDBMSSite()).sortCollections();
            }
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error("MergingModels.execute()", runtimeException);
        }
        finally {
            ApplicationView.loading = false;
            this.design.setPropagatePKChahges(true);
            this.design.setMerging(false);
            this.design.setCorrespondenceMap(null);
        }
    }

    public static void createUsedClassificationypes(DesignPart designPart, DesignPart designPart2) {
        Design.DLSettings dLSettings = designPart2.getDesign().getDLSettings();
        List list = designPart.getUsedClassificationTypes();
        for (ClassificationType classificationType : list) {
            ClassificationType classificationType2 = dLSettings.getClassificationTypeByID(classificationType.getTypeID());
            if (classificationType2 != null) continue;
            classificationType2 = new ClassificationType(classificationType.getTypeName(), new Color(classificationType.getTypeColor().getRGB()), classificationType.getTypeID(), classificationType.getTypePrefix());
            dLSettings.addClassificationType(classificationType2);
        }
    }

    private void processTables() {
        Iterator iterator = this.sourceDesignPart.getTableSet().iterator();
        while (iterator.hasNext()) {
            Table table;
            Table table2 = (Table)iterator.next();
            if (table2.shouldBeMerge()) {
                Object object;
                table = (Table)objectsMap.get(table2.getObjectID());
                boolean bl = false;
                if (table == null) {
                    bl = true;
                }
                table = this.processTable(table2, table);
                MergingModels.copySourceStamp(table2, table);
                this.processColumns(table2);
                if (table2.getBasedOnStructuredType() != null) {
                    this.processST_Columns(table2);
                }
                this.processIndexes(table2);
                this.processConstraints(table2);
                table.setSpatialTable(table2.isSpatialTable());
                table.getSpatialDefinitions().clear();
                for (Object object2 : table2.getSpatialDefinitions()) {
                    object = new SpatialColumnDefObject(table);
                    ((SpatialColumnDefObject)object2).copyTo((SpatialColumnDefObject)object, objectsMap);
                    table.addSpatialDefinition((SpatialColumnDefObject)object);
                }
                if (!PropertiesComparator.DDL_ONLY && bl) {
                    table.setBeforeDrop(table2.getBeforeDrop());
                    table.setBeforeCreate(table2.getBeforeCreate());
                    table.setAfterCreate(table2.getAfterCreate());
                    table.setEndOfScript(table2.getEndOfScript());
                    table.setShouldGenerateScript(table2.getShouldGenerateScript());
                }
                if (PropertiesComparator.DDL_ONLY) continue;
                table.getColumnGroupsSet().clear();
                for (Object object2 : table2.getColumnGroupsSet()) {
                    object = table.createColumnGroup(((Table.ColumnGroup)object2).getName(), null);
                    table.getColumnGroupsSet().add(object);
                    ((Table.ColumnGroup)object2).copy((Table.ColumnGroup)object, objectsMap);
                }
                continue;
            }
            table = (Table)objectsMap.get(table2.getObjectID());
            if (table == null) continue;
            table.setShouldMerge(false);
        }
    }

    private void reorderColumns() {
        Iterator iterator = this.sourceDesignPart.getTableSet().iterator();
        while (iterator.hasNext()) {
            Table table = (Table)iterator.next();
            if (!table.shouldBeMerge()) continue;
            ContainedObject[] containedObjectArray = table.getElements();
            for (int i = 0; i < containedObjectArray.length; ++i) {
                Column column;
                Column column2 = (Column)containedObjectArray[i];
                if (!column2.shouldBeMerge() || (column = (Column)objectsMap.get(column2.getObjectID())) == null) continue;
                column.moveToIndex(column2.getIndex());
            }
        }
    }

    private Table processTable(Table table, Table table2) {
        if (table2 == null) {
            SchemaObject schemaObject;
            if (this.targetDesignPart.getTableSet().size() > 0 && this.count == 0) {
                this.notEmpty = true;
            }
            table2 = this.targetDesignPart.createTable();
            table2.setImportedId(table.getObjectID());
            SchemaObject schemaObject2 = table.getSchemaObject();
            if (schemaObject2 != null && (schemaObject = (SchemaObject)objectsMap.get(schemaObject2.getObjectID())) != null) {
                table2.setSchemaObject(schemaObject);
            }
            table2.setName(table.getName());
            objectsMap.put(table.getObjectID(), table2);
            this.copyPropertiesFromTableToTable(table, table2);
            if (this.notEmpty) {
                this.moveGraphical(this.sourceDesignPart, this.targetDesignPart, table2, table);
            } else {
                ++this.count;
                this.setObjectBounds(table, table2);
            }
        } else {
            PropertiesComparator propertiesComparator = (PropertiesComparator)this.comparatorsMap.get(table.getObjectID() + table2.getObjectID());
            if (propertiesComparator != null) {
                propertiesComparator.copySelectedProperties();
            }
        }
        return table2;
    }

    private void setObjectBounds(DesignObject designObject, DesignObject designObject2) {
        if (designObject2.getTopView().getCellView() != null && designObject.getTopView().getBounds() != null) {
            designObject2.getTopView().getCellView().setNewBounds(designObject.getTopView().getBounds());
        }
    }

    private void moveGraphical(RelationalDesign relationalDesign, RelationalDesign relationalDesign2, DesignObject designObject, DesignObject designObject2) {
        float f = (float)Math.sqrt(relationalDesign.getTableSet().size());
        this.maxTablePerRow = (int)f;
        if (Math.sqrt(f * f) != (double)f) {
            ++this.maxTablePerRow;
        }
        ++this.maxTablePerRow;
        Rectangle2D rectangle2D = relationalDesign2.getMainView().getWorkSpace().getDiagramBounds();
        TopView topView = designObject.getTopView();
        if (topView.getCellView() != null) {
            Dimension dimension = designObject2.getTopView().getSize();
            if (this.count == 0) {
                this.top = (int)((double)((int)rectangle2D.getHeight()) + dimension.getHeight());
                this.left = 20;
            }
            ++this.count;
            this.width = (int)dimension.getWidth();
            this.height = (int)Math.max(dimension.getHeight(), (double)this.height);
            topView.getCellView().setNewBounds(new Rectangle(new Point(this.left, this.top), designObject2.getTopView().getSize()));
        }
        this.left = this.left + this.width + 50;
        if (this.count == this.maxTablePerRow) {
            this.count = 0;
            this.left = 20;
            this.top = this.top + this.height + 50;
            this.height = 25;
        }
    }

    private void resetAllObjects() {
        this.left = 20;
        this.top = 20;
        this.width = 35;
        this.height = 25;
        this.notEmpty = false;
        this.count = 0;
    }

    private static void copySourceStamp(ModelObject modelObject, ModelObject modelObject2) {
        if (modelObject != null && modelObject2 != null) {
            if (!"".equals(modelObject.getSourceConnName()) && "".equals(modelObject2.getSourceConnName())) {
                modelObject2.setSourceConnName(modelObject.getSourceConnName());
                modelObject2.setSourceObjName(modelObject.getSourceObjName());
                modelObject2.setSourceObjSchema(modelObject.getSourceObjSchema());
            }
            if (!"".equals(modelObject.getSourceDDLFile()) && "".equals(modelObject2.getSourceDDLFile())) {
                modelObject2.setSourceDDLFile(modelObject.getSourceDDLFile());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPropertiesFromTableToTable(Table table, Table table2) {
        DesignObject designObject;
        if (table.getGeneratorID() != null && !ModelIDObject.USER_GENERATED.equals(table.getGeneratorID()) && (designObject = (DesignObject)objectsMap.get(table.getGeneratorID())) != null && designObject instanceof Entity) {
            table2.setGeneratorID(designObject.getObjectID());
        }
        table2.setMinVolumes(table.getMinVolumes());
        table2.setExpectedVolumes(table.getExpectedVolumes());
        table2.setMaxVolumes(table.getMaxVolumes());
        table2.setGrowthPercent(table.getGrowthPercent());
        table2.setGrowthType(table.getGrowthType());
        table2.setNormalForm(table.getNormalForm());
        table2.setAdequatelyNormalized(table.getAdequatelyNormalized());
        table2.setTypeID(table.getTypeID());
        table2.setScope(table.getScope());
        designObject = table.getBasedOnStructuredType();
        if (designObject != null) {
            StructuredType structuredType = (StructuredType)objectsMap.get(designObject.getObjectID());
            if (structuredType != null) {
                ApplicationView.loading = true;
                try {
                    table2.setBasedOnStructuredType(structuredType);
                }
                finally {
                    ApplicationView.loading = false;
                }
            }
        } else {
            table2.setBasedOnStructuredType(null);
        }
        table2.setComment(table.getComment());
        table2.setCommentInRDBMS(table.getCommentInRDBMS());
        table2.setNotes(table.getNotes());
    }

    private void processColumns(Table table) {
        ContainedObject[] containedObjectArray = table.getElements();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            Column column;
            Column column2 = (Column)containedObjectArray[i];
            if (column2.shouldBeMerge()) {
                ColumnComparator columnComparator;
                column = (Column)objectsMap.get(column2.getObjectID());
                Table table2 = (Table)objectsMap.get(table.getObjectID());
                if (column == null && table2 != null) {
                    column = table2.createColumn(column2.getName());
                    column.setImportedId(column2.getObjectID());
                    column.moveToIndex(column2.getIndex());
                    objectsMap.put(column2.getObjectID(), column);
                    MergingModels.copyPropertiesFromColumnToColumn(column2, column);
                    MergingModels.copySourceStamp(column2, column);
                } else if (column != null && (columnComparator = (ColumnComparator)this.comparatorsMap.get(column2.getObjectID() + column.getObjectID())) != null) {
                    columnComparator.copySelectedProperties();
                    column.moveToIndex(column2.getIndex());
                }
                if (column == null) continue;
                column.setShouldMerge(true);
                continue;
            }
            if (!table.shouldBeMerge() || (column = (Column)objectsMap.get(column2.getObjectID())) == null) continue;
            column.moveToIndex(column2.getIndex());
            column.setShouldMerge(false);
        }
    }

    private void processST_Columns(Table table) {
        Table table2 = (Table)objectsMap.get(table.getObjectID());
        if (table2 != null) {
            for (Column column : table.getElementsCollectionImmutable()) {
                String string = column.getStructAttributeID();
                if (string == null) continue;
                ModelIDObject modelIDObject = (ModelIDObject)objectsMap.get(string);
                String string2 = string;
                if (modelIDObject != null) {
                    string2 = modelIDObject.getObjectID();
                }
                if (string2 == null) continue;
                Column column2 = (Column)table2.getElementByStructAttributeID(string2);
                if (column2 == null) {
                    column2 = (Column)table2.getElementByStructAttributeID(string);
                }
                if (column2 == null) continue;
                objectsMap.put(column.getObjectID(), column2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyPropertiesFromColumnToColumn(Column column, Column column2) {
        try {
            DesignObject designObject;
            column2.setTemporaryWriteable(true);
            if (column.getGeneratorID() != null && !ModelIDObject.USER_GENERATED.equals(column.getGeneratorID()) && (designObject = (DesignObject)objectsMap.get(column.getGeneratorID())) != null && designObject instanceof Attribute) {
                column2.setGeneratorID(designObject.getObjectID());
            }
            MergingModels.copyPropertiesFromCOWD_To_COWD(column, column2, objectsMap);
            MergingModels.copyColumnSpecificProperties(column, column2);
        }
        finally {
            column2.setTemporaryWriteable(false);
        }
    }

    public static void copyDataTypeFromCOWD_To_COWD(ContainedObjectWithDomain containedObjectWithDomain, ContainedObjectWithDomain containedObjectWithDomain2, boolean bl) {
        containedObjectWithDomain2.setUse(containedObjectWithDomain.getUse());
        if (containedObjectWithDomain.getUse() == 0) {
            if (containedObjectWithDomain.getDomain() != null) {
                Domain domain = containedObjectWithDomain.getDomain();
                Domain domain2 = (Domain)CompareModelToModel.getCorrespondingObject(containedObjectWithDomain2.getDesign().getDomainSet(), domain);
                if (domain2 != null) {
                    containedObjectWithDomain2.setDomain(domain2);
                } else if (bl) {
                    domain2 = containedObjectWithDomain2.getDesign().getDomainSet().createDomain();
                    domain2.setDesign(containedObjectWithDomain2.getDesign());
                    domain2.setOwnerDesign(containedObjectWithDomain2.getDesign());
                    domain.copyTo(domain2);
                    LogicalDatatype logicalDatatype = (LogicalDatatype)CompareModelToModel.getCorrespondingObject(containedObjectWithDomain2.getDesign().getLogicalDatatypeSet(), domain.getLogicalDatatype());
                    if (logicalDatatype != null) {
                        domain2.setLogicalDatatype(logicalDatatype);
                    }
                    domain2.setFileName(domain.getFileName());
                    domain2.setDirty(true);
                    containedObjectWithDomain2.setDomain(domain2);
                } else {
                    LogicalDatatype logicalDatatype;
                    LogicalDatatype logicalDatatype2 = containedObjectWithDomain.getLogicalDatatype();
                    if (logicalDatatype2 != null && (logicalDatatype = (LogicalDatatype)containedObjectWithDomain2.getDesign().getLogicalDatatypeSet().getByName(logicalDatatype2.getName())) != null) {
                        containedObjectWithDomain2.setLogicalDatatype(logicalDatatype);
                        containedObjectWithDomain2.setUse((short)1);
                    }
                }
            }
        } else if (containedObjectWithDomain.getUse() == 1) {
            LogicalDatatype logicalDatatype;
            LogicalDatatype logicalDatatype3 = containedObjectWithDomain.getLogicalDatatype();
            if (logicalDatatype3 != null && (logicalDatatype = (LogicalDatatype)containedObjectWithDomain2.getDesign().getLogicalDatatypeSet().getByName(logicalDatatype3.getName())) != null) {
                containedObjectWithDomain2.setLogicalDatatype(logicalDatatype);
            }
        } else if (containedObjectWithDomain.getUse() == 3) {
            StructuredType structuredType = containedObjectWithDomain.getStructuredType();
            StructuredType structuredType2 = (StructuredType)CompareModelToModel.getCorrespondingObject(containedObjectWithDomain2.getDesign().getDataTypesDesign().getStructuredTypeSet(), structuredType);
            if (structuredType2 != null) {
                containedObjectWithDomain2.setStructuredType(structuredType2);
            }
            containedObjectWithDomain2.setReference(containedObjectWithDomain.isReference());
            Iterator iterator = containedObjectWithDomain.getPermittedSubTypes().iterator();
            List list = containedObjectWithDomain2.getPermittedSubTypes();
            list.clear();
            while (iterator.hasNext()) {
                StructuredType structuredType3 = (StructuredType)iterator.next();
                structuredType2 = (StructuredType)CompareModelToModel.getCorrespondingObject(containedObjectWithDomain2.getDesign().getDataTypesDesign().getStructuredTypeSet(), structuredType3);
                if (structuredType2 == null) continue;
                list.add(structuredType2);
            }
        } else if (containedObjectWithDomain.getUse() == 4) {
            CollectionType collectionType = containedObjectWithDomain.getCollectionType();
            CollectionType collectionType2 = (CollectionType)CompareModelToModel.getCorrespondingObject(containedObjectWithDomain2.getDesign().getDataTypesDesign().getCollectionTypeSet(), collectionType);
            if (collectionType2 != null) {
                containedObjectWithDomain2.setCollectionType(collectionType2);
            }
        } else if (containedObjectWithDomain.getUse() == 2) {
            DistinctType distinctType = containedObjectWithDomain.getDistinctType();
            DistinctType distinctType2 = (DistinctType)CompareModelToModel.getCorrespondingObject(containedObjectWithDomain2.getDesign().getDataTypesDesign().getDistinctTypeSet(), distinctType);
            if (distinctType2 != null) {
                containedObjectWithDomain2.setDistinctType(distinctType2);
            }
        }
        containedObjectWithDomain2.setDataTypeParameter("size", containedObjectWithDomain.getSize());
        containedObjectWithDomain2.setDataTypeParameter("precision", containedObjectWithDomain.getPrecision());
        containedObjectWithDomain2.setDataTypeParameter("scale", containedObjectWithDomain.getScale());
        containedObjectWithDomain2.copyParametersFrom(containedObjectWithDomain);
        MergingModels.copySourceStamp(containedObjectWithDomain, containedObjectWithDomain2);
    }

    public static void copyPropertiesFromCOWD_To_COWD(ContainedObjectWithDomain containedObjectWithDomain, ContainedObjectWithDomain containedObjectWithDomain2, Map map) {
        containedObjectWithDomain2.setTemporaryWriteable(true);
        MergingModels.copyDataTypeFromCOWD_To_COWD(containedObjectWithDomain, containedObjectWithDomain2, true);
        if (containedObjectWithDomain.getScope() != null) {
            ContainerObject containerObject = containedObjectWithDomain.getScope();
            DesignObject designObject = (DesignObject)map.get(containerObject.getObjectID());
            if (designObject == null) {
                if (containerObject instanceof Table) {
                    designObject = CompareModelToModel.getCorrespondingObject(containedObjectWithDomain2.getDesign().getRelationalDesign().getTableSet(), containerObject);
                } else if (containerObject instanceof Entity) {
                    designObject = CompareModelToModel.getCorrespondingObject(containedObjectWithDomain2.getDesign().getLogicalDesign().getEntitySet(), containerObject);
                }
            }
            if (designObject != null) {
                containedObjectWithDomain2.setScopeId(designObject.getObjectID());
            } else {
                containedObjectWithDomain2.setScopeId(null);
            }
        } else {
            containedObjectWithDomain2.setScopeId(null);
        }
        containedObjectWithDomain2.setAllowSubtypeSubstitution(containedObjectWithDomain.isAllowSubtypeSubstitution());
        containedObjectWithDomain2.setNullsAllowed(containedObjectWithDomain.getNullsAllowed());
        containedObjectWithDomain2.setConstraintName(containedObjectWithDomain.getConstraintName());
        containedObjectWithDomain2.setDefaultValue(containedObjectWithDomain.getDefaultValue());
        containedObjectWithDomain2.setUsesDefaultValue(containedObjectWithDomain.getUsesDefaultValue());
        containedObjectWithDomain2.setCommentInRDBMS(containedObjectWithDomain.getCommentInRDBMS());
        containedObjectWithDomain2.setComment(containedObjectWithDomain.getComment());
        containedObjectWithDomain2.setNotes(containedObjectWithDomain.getNotes());
        containedObjectWithDomain2.setSourceType(containedObjectWithDomain.getSourceType());
        containedObjectWithDomain2.setFormulaDesc(containedObjectWithDomain.getFormulaDesc());
        containedObjectWithDomain2.setTemporaryWriteable(false);
        containedObjectWithDomain2.setUseDomainConstraints(containedObjectWithDomain.getUseDomainConstraints());
        if (!containedObjectWithDomain.getUseDomainConstraints()) {
            EngCOPropertiesComparator.copyCheckConstraint(containedObjectWithDomain, containedObjectWithDomain2);
            EngCOPropertiesComparator.copyRangeConstraint(containedObjectWithDomain, containedObjectWithDomain2);
            EngCOPropertiesComparator.copyLOVConstraint(containedObjectWithDomain, containedObjectWithDomain2);
        }
    }

    private static void copyColumnSpecificProperties(Column column, Column column2) {
        column2.setTemporaryWriteable(true);
        column2.setAbbreviation(column.getAbbreviation());
        column2.setComputed(column.isComputed());
        column2.setNotNullConstraintName(column.getNotNullConstraintName());
        column2.setDefaultLabel(column.getDefaultLabel());
        column2.setDefaultFormatMask(column.getDefaultFormatMask());
        column2.setDefaultFormDisplayWidth(column.getDefaultFormDisplayWidth());
        column2.setDefaultFormMaximumWidth(column.getDefaultFormMaximumWidth());
        column2.setDefaultFormHeight(column.getDefaultFormHeight());
        column2.setDefaultHelpText(column.getDefaultHelpText());
        column2.setDefaultReadOnly(column.isDefaultReadOnly());
        column2.setDefaultDisplayedOnReports(column.isDefaultDisplayedOnReports());
        column2.setDefaultDisplayedOnForms(column.isDefaultDisplayedOnForms());
        column2.setDefaultDisplayAs(column.getDefaultDisplayAs());
        column2.setOid(column.isOid());
        column2.setContainsPII(column.isContainsPII());
        column2.setContainsSensitiveInformation(column.isContainsSensitiveInformation());
        column2.setMaskData(column.isMaskData());
        column2.setAutoIncrementColumn(column.isAutoIncrementColumn());
        column2.setIdentityColumn(column.isIdentityColumn());
        column2.setAutoIncrementGenerateAlways(column.isAutoIncrementGenerateAlways());
        column2.setAutoIncrementStartWith(column.getAutoIncrementStartWith());
        column2.setAutoIncrementIncrementBy(column.getAutoIncrementIncrementBy());
        column2.setAutoIncrementMinValue(column.getAutoIncrementMinValue());
        column2.setAutoIncrementMaxValue(column.getAutoIncrementMaxValue());
        column2.setAutoIncrementCycle(column.isAutoIncrementCycle());
        column2.setAutoIncrementDisableCache(column.isAutoIncrementDisableCache());
        column2.setAutoIncrementCache(column.getAutoIncrementCache());
        column2.setAutoIncrementOrder(column.isAutoIncrementOrder());
        column2.setAutoIncrementSequenceName(column.getAutoIncrementSequenceName());
        column2.setAutoIncrementTriggerName(column.getAutoIncrementTriggerName());
        column2.setAutoIncrementGenerateTrigger(column.isAutoIncrementGenerateTrigger());
        column2.setTemporaryWriteable(false);
    }

    private void processIndexes(Table table) {
        Table table2 = (Table)objectsMap.get(table.getObjectID());
        if (table2 != null) {
            KeyObject[] keyObjectArray = table.getKeys();
            for (int i = 0; i < keyObjectArray.length; ++i) {
                KeyObject keyObject = keyObjectArray[i];
                if (keyObject.isFK()) continue;
                Index index = (Index)objectsMap.get(keyObject.getObjectID());
                if (keyObject.shouldBeMerge()) {
                    Object object;
                    if (index == null) {
                        SchemaObject schemaObject;
                        index = table2.createIndex();
                        index.setImportedId(keyObject.getObjectID());
                        object = keyObject.getSchemaObject();
                        if (object != null && (schemaObject = (SchemaObject)objectsMap.get(((ModelIDObject)object).getObjectID())) != null) {
                            index.setSchemaObject(schemaObject);
                        }
                        objectsMap.put(keyObject.getObjectID(), index);
                        this.copyPropertiesFromIndexToIndex((Index)keyObject, index);
                        index.setName(keyObject.getName());
                        MergingModels.copySourceStamp(keyObject, index);
                    } else {
                        object = (PropertiesComparator)this.comparatorsMap.get(keyObject.getObjectID() + index.getObjectID());
                        if (object != null) {
                            ((PropertiesComparator)object).copySelectedProperties();
                        }
                    }
                    index.setShouldMerge(true);
                    continue;
                }
                if (index == null) continue;
                index.setShouldMerge(false);
            }
        }
    }

    private void copyPropertiesFromIndexToIndex(Index index, Index index2) {
        ContainedObject[] containedObjectArray;
        if (index.getGeneratorID() != null && !ModelIDObject.USER_GENERATED.equals(index.getGeneratorID()) && (containedObjectArray = (ContainedObject[])objectsMap.get(index.getGeneratorID())) != null && containedObjectArray instanceof CandidateKey) {
            index2.setGeneratorID(containedObjectArray.getObjectID());
        }
        index2.setCommentInRDBMS(index.getCommentInRDBMS());
        index2.setComment(index.getComment());
        index2.setNotes(index.getNotes());
        containedObjectArray = index.getElements();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            ContainedObject containedObject = containedObjectArray[i];
            String string = index.getColumnSortOrder(containedObject);
            Column column = (Column)objectsMap.get(containedObject.getObjectID());
            if (column == null || column.getContainer() != index2.getContainerObject()) continue;
            index2.add(column);
            index2.setColumnSortOrder(column, string);
        }
        index2.setIndexState(index.getIndexState());
        index2.setIndexExpression(index.getIndexExpression());
        index2.setSpatialIndex(index.isSpatialIndex());
        index2.setLayerType(index.getLayerType());
        index2.setDimensionsNumber(index.getDimensionsNumber());
        index2.setGeodetic(index.getGeodetic());
    }

    public static void synchronizeColumnsFromIndexToKey(Index index, Index index2) {
        int n;
        ContainedObject[] containedObjectArray = index.getElements();
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            Column column = (Column)containedObjectArray[i];
            Column column2 = MergingModels.getTargetColumn(column);
            if (column2 == null) continue;
            arrayList.add(column2);
            index2.add(column2);
            String string = index.getColumnSortOrder(column);
            index2.setColumnSortOrder(column2, string);
        }
        ContainedObject[] containedObjectArray2 = index2.getElements();
        for (n = 0; n < containedObjectArray2.length; ++n) {
            if (arrayList.contains(containedObjectArray2[n])) continue;
            index2.remove(containedObjectArray2[n]);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            index2.moveToIndex((ContainedObject)arrayList.get(n), n);
        }
    }

    private static Column getTargetColumn(Column column) {
        Column column2 = (Column)objectsMap.get(column.getObjectID());
        return column2;
    }

    private void processConstraints(Table table) {
        Table table2 = (Table)objectsMap.get(table.getObjectID());
        if (table2 != null) {
            List list = table.getCheckConstraints();
            for (TableLevelConstraint tableLevelConstraint : list) {
                TableLevelConstraint tableLevelConstraint2 = (TableLevelConstraint)objectsMap.get(tableLevelConstraint.getObjectID());
                if (tableLevelConstraint.shouldBeMerge()) {
                    if (tableLevelConstraint2 == null) {
                        tableLevelConstraint2 = table2.createCheckConstraint(tableLevelConstraint.getName(), tableLevelConstraint.getRule());
                        tableLevelConstraint2.setImportedId(tableLevelConstraint.getObjectID());
                        table2.addCheckConstraint(tableLevelConstraint2);
                        objectsMap.put(tableLevelConstraint.getObjectID(), tableLevelConstraint2);
                        MergingModels.copySourceStamp(tableLevelConstraint, tableLevelConstraint2);
                    } else {
                        PropertiesComparator propertiesComparator = (PropertiesComparator)this.comparatorsMap.get(tableLevelConstraint.getObjectID() + tableLevelConstraint2.getObjectID());
                        if (propertiesComparator != null) {
                            propertiesComparator.copySelectedProperties();
                        }
                    }
                    tableLevelConstraint2.setShouldMerge(true);
                    continue;
                }
                if (tableLevelConstraint2 == null) continue;
                tableLevelConstraint2.setShouldMerge(false);
            }
        }
    }

    private void processForeignKeys() {
        for (int i = 0; i < this.fkeys.size(); ++i) {
            FKIndexAssociation fKIndexAssociation = (FKIndexAssociation)this.fkeys.get(i);
            FKIndexAssociation fKIndexAssociation2 = (FKIndexAssociation)objectsMap.get(fKIndexAssociation.getObjectID());
            if (fKIndexAssociation.getContainerWithKeyObject().shouldBeMerge()) {
                if (fKIndexAssociation.shouldBeMerge()) {
                    if (fKIndexAssociation2 == null) {
                        this.processFK(fKIndexAssociation);
                    } else {
                        PropertiesComparator propertiesComparator = (PropertiesComparator)this.comparatorsMap.get(fKIndexAssociation.getObjectID() + fKIndexAssociation2.getObjectID());
                        if (propertiesComparator != null) {
                            propertiesComparator.copySelectedProperties();
                            this.synchronizeFKColumns(fKIndexAssociation, fKIndexAssociation2);
                            fKIndexAssociation2.resetEdgeParams();
                        }
                    }
                    if (fKIndexAssociation2 == null) continue;
                    fKIndexAssociation2.setShouldMerge(true);
                    fKIndexAssociation2.getLocalFKIndex().setShouldMerge(true);
                    continue;
                }
                if (fKIndexAssociation2 == null) continue;
                fKIndexAssociation2.setShouldMerge(false);
                fKIndexAssociation2.getLocalFKIndex().setShouldMerge(false);
                continue;
            }
            if (fKIndexAssociation2 == null) continue;
            fKIndexAssociation2.setShouldMerge(false);
            fKIndexAssociation2.getLocalFKIndex().setShouldMerge(false);
        }
    }

    public void processFK(FKIndexAssociation fKIndexAssociation) {
        Table table = fKIndexAssociation.getRemoteTable();
        Table table2 = (Table)fKIndexAssociation.getContainerWithKeyObject();
        Table table3 = (Table)objectsMap.get(table.getObjectID());
        Table table4 = (Table)objectsMap.get(table2.getObjectID());
        if (table3 == null && table4 != null) {
            table3 = (Table)table4.getDesign().getDesignObject(table.getObjectID());
        }
        if (table3 != null && table4 != null) {
            Index index = fKIndexAssociation.getRemoteIndex();
            KeyObject keyObject = (KeyObject)objectsMap.get(index.getObjectID());
            if (keyObject == null) {
                keyObject = (KeyObject)table4.getDesign().getDesignObject(index.getObjectID());
            }
            if (keyObject != null) {
                DesignObject designObject;
                FKIndexAssociation fKIndexAssociation2 = table4.addFK(keyObject);
                objectsMap.put(fKIndexAssociation.getObjectID(), fKIndexAssociation2);
                objectsMap.put(fKIndexAssociation.getLocalFKIndex().getObjectID(), fKIndexAssociation2.getLocalFKIndex());
                if (fKIndexAssociation.getGeneratorID() != null && !ModelIDObject.USER_GENERATED.equals(fKIndexAssociation.getGeneratorID()) && (designObject = (DesignObject)objectsMap.get(fKIndexAssociation.getGeneratorID())) != null && designObject instanceof Relation) {
                    fKIndexAssociation2.setGeneratorID(designObject.getObjectID());
                }
                fKIndexAssociation2.setImportedId(fKIndexAssociation.getObjectID());
                fKIndexAssociation2.setName(fKIndexAssociation.getName());
                MergingModels.copySourceStamp(fKIndexAssociation, fKIndexAssociation2);
                this.synchronizeFKColumns(fKIndexAssociation, fKIndexAssociation2);
                fKIndexAssociation2.setDeleteRule(fKIndexAssociation.getDeleteRule());
                fKIndexAssociation2.setComment(fKIndexAssociation.getComment());
                fKIndexAssociation2.setCommentInRDBMS(fKIndexAssociation.getCommentInRDBMS());
                fKIndexAssociation2.setNotes(fKIndexAssociation.getNotes());
                fKIndexAssociation2.setMandatory(fKIndexAssociation.isMandatory());
                fKIndexAssociation2.setTransferable(fKIndexAssociation.isTransferable());
                fKIndexAssociation2.resetEdgeParams();
            }
        }
    }

    private void processTableViews() {
        Iterator iterator = this.sourceDesignPart.getTableViewSet().iterator();
        while (iterator.hasNext()) {
            TableView tableView = (TableView)iterator.next();
            if (!tableView.shouldBeMerge()) continue;
            TableView tableView2 = this.processTableView(tableView);
            MergingModels.copySourceStamp(tableView, tableView2);
        }
    }

    private TableView processTableView(TableView tableView) {
        TableView tableView2 = (TableView)objectsMap.get(tableView.getObjectID());
        if (tableView2 == null) {
            SchemaObject schemaObject;
            if (this.targetDesignPart.getTableViewSet().size() > 0 && this.count == 0) {
                this.notEmpty = true;
            }
            tableView2 = this.targetDesignPart.createTableView(tableView.getName());
            tableView2.setImportedId(tableView.getObjectID());
            objectsMap.put(tableView.getObjectID(), tableView2);
            SchemaObject schemaObject2 = tableView.getSchemaObject();
            if (schemaObject2 != null && (schemaObject = (SchemaObject)objectsMap.get(schemaObject2.getObjectID())) != null) {
                tableView2.setSchemaObject(schemaObject);
            }
            this.copyPropertiesFromTableViewToTableView(tableView, tableView2);
            if (this.notEmpty) {
                this.moveGraphical(this.sourceDesignPart, this.targetDesignPart, tableView2, tableView);
            } else {
                ++this.count;
                this.setObjectBounds(tableView, tableView2);
            }
        } else {
            PropertiesComparator propertiesComparator = (PropertiesComparator)this.comparatorsMap.get(tableView.getObjectID() + tableView2.getObjectID());
            if (propertiesComparator != null) {
                propertiesComparator.copySelectedProperties();
            }
        }
        return tableView2;
    }

    private void proccessSnapshots() {
        StorageDesign storageDesign = this.sourceDesignPart.getStorageDesign();
        if (storageDesign instanceof StorageDesignOracle) {
            StorageDesignOracle storageDesignOracle = (StorageDesignOracle)storageDesign;
            Iterator iterator = storageDesignOracle.getSnapshotSet().iterator();
            while (iterator.hasNext()) {
                SnapshotOracle snapshotOracle = (SnapshotOracle)iterator.next();
                if (!snapshotOracle.shouldBeMerge()) continue;
                SnapshotOracle snapshotOracle2 = this.processSnapshot(snapshotOracle);
                MergingModels.copySourceStamp(snapshotOracle, snapshotOracle2);
            }
        }
    }

    private SnapshotOracle processSnapshot(SnapshotOracle snapshotOracle) {
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.targetDesignPart.getStorageDesign();
        SnapshotOracle snapshotOracle2 = (SnapshotOracle)objectsMap.get(snapshotOracle.getObjectID());
        if (snapshotOracle2 == null) {
            snapshotOracle2 = storageDesignOracle.getSnapshotSet().createSnapshot();
            objectsMap.put(snapshotOracle.getObjectID(), snapshotOracle2);
            snapshotOracle.copy(snapshotOracle2);
        } else {
            PropertiesComparator propertiesComparator = (PropertiesComparator)this.comparatorsMap.get(snapshotOracle.getObjectID() + snapshotOracle2.getObjectID());
            if (propertiesComparator != null) {
                propertiesComparator.copySelectedProperties();
                snapshotOracle2.setDirty(true);
            }
        }
        return snapshotOracle2;
    }

    private void proccessSequence() {
        StorageDesign storageDesign = this.sourceDesignPart.getStorageDesign();
        if (storageDesign instanceof StorageDesignOracle) {
            StorageDesignOracle storageDesignOracle = (StorageDesignOracle)storageDesign;
            Iterator iterator = storageDesignOracle.getSequenceSet().iterator();
            while (iterator.hasNext()) {
                SequenceOracle sequenceOracle = (SequenceOracle)iterator.next();
                if (!sequenceOracle.shouldBeMerge()) continue;
                SequenceOracle sequenceOracle2 = this.proccessSequence(sequenceOracle);
                MergingModels.copySourceStamp(sequenceOracle, sequenceOracle2);
            }
        }
    }

    private SequenceOracle proccessSequence(SequenceOracle sequenceOracle) {
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)this.targetDesignPart.getStorageDesign();
        SequenceOracle sequenceOracle2 = (SequenceOracle)objectsMap.get(sequenceOracle.getObjectID());
        if (sequenceOracle2 == null) {
            sequenceOracle2 = storageDesignOracle.getSequenceSet().createSequence();
            objectsMap.put(sequenceOracle.getObjectID(), sequenceOracle2);
            sequenceOracle.copy(sequenceOracle2);
        } else {
            PropertiesComparator propertiesComparator = (PropertiesComparator)this.comparatorsMap.get(sequenceOracle.getObjectID() + sequenceOracle2.getObjectID());
            if (propertiesComparator != null) {
                propertiesComparator.copySelectedProperties();
                sequenceOracle2.setDirty(true);
            }
        }
        return sequenceOracle2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPropertiesFromTableViewToTableView(TableView tableView, TableView tableView2) {
        DesignObject designObject;
        DesignObject designObject2;
        DesignObject designObject3;
        if (tableView.getGeneratorID() != null && !ModelIDObject.USER_GENERATED.equals(tableView.getGeneratorID()) && (designObject3 = (DesignObject)objectsMap.get(tableView.getGeneratorID())) != null && designObject3 instanceof EntityView) {
            tableView2.setGeneratorID(designObject3.getObjectID());
        }
        tableView2.setComment(tableView.getComment());
        tableView2.setCommentInRDBMS(tableView.getCommentInRDBMS());
        tableView2.setNotes(tableView.getNotes());
        designObject3 = tableView.getBasedOnStructuredType();
        if (designObject3 != null) {
            StructuredType structuredType = (StructuredType)objectsMap.get(designObject3.getObjectID());
            if (structuredType != null) {
                try {
                    tableView2.setBasedOnStructuredType(structuredType);
                }
                finally {
                    ApplicationView.loading = false;
                }
            }
        } else {
            tableView2.setBasedOnStructuredType(null);
        }
        tableView2.setSyntaxProvider(tableView.getSyntaxProvider());
        tableView2.setWhere(tableView.getWhere());
        tableView2.setGroupBy(tableView.getGroupBy());
        tableView2.setHaving(tableView.getHaving());
        tableView2.setUserDefined(tableView.getUserDefined());
        tableView2.setUserDefinedSQL(tableView.getUserDefinedSQL());
        for (Object object : tableView.getContainerMap().keySet()) {
            String string = tableView.getContainerID((String)object);
            designObject2 = (Table)this.sourceDesignPart.getTableSet().getObjectByID(string);
            if (designObject2 == null || (designObject = (Table)objectsMap.get(designObject2.getObjectID())) == null) continue;
            tableView2.addToContainers((ContainerObject)designObject, (String)object);
        }
        for (String string : tableView.getOrderByMap().keySet()) {
            Object object;
            object = (ColumnView)tableView.getObjectByID(tableView.getOrderByList(), string);
            if (object != null) {
                designObject2 = new ColumnView(tableView2.getDesignPart());
                designObject2.setDesign(tableView2.getDesign());
                MergingModels.copyColumnToColumn((ColumnView)object, (ColumnView)designObject2);
                ((AbstractViewElement)designObject2).setView(tableView2);
                tableView2.addToOrderBy((ContainedObject)designObject2, (String)tableView.getOrderByMap().get(string));
                objectsMap.put(((ModelIDObject)object).getObjectID(), designObject2);
                continue;
            }
            System.out.println("MergingModels.copyPropertiesFromTableViewToTableView: Unable to find ColumnView: " + string);
        }
        if (!tableView.isBST()) {
            for (int i = 0; i < tableView.getElements().length; ++i) {
                designObject2 = (ColumnView)tableView.getElements()[i];
                designObject = new ColumnView(tableView2.getDesignPart());
                designObject.setDesign(tableView2.getDesign());
                MergingModels.copyColumnToColumn((ColumnView)designObject2, (ColumnView)designObject);
                ((AbstractViewElement)designObject).setView(tableView2);
                ((ContainedObject)designObject).setContainer(tableView2);
                tableView2.add((ContainedObject)designObject);
                objectsMap.put(designObject2.getObjectID(), designObject);
            }
        }
        for (int i = 0; i < tableView.getGroupByList().size(); ++i) {
            designObject2 = (ColumnView)tableView.getGroupByList().get(i);
            designObject = (ColumnView)objectsMap.get(designObject2.getObjectID());
            if (designObject == null) continue;
            tableView2.addGroupByList((ContainedObject)designObject);
        }
    }

    public static void copyColumnToColumn(ColumnView columnView, ColumnView columnView2) {
        DesignObject designObject;
        if (columnView.getGeneratorID() != null && !ModelIDObject.USER_GENERATED.equals(columnView.getGeneratorID()) && (designObject = (DesignObject)objectsMap.get(columnView.getGeneratorID())) != null && designObject instanceof AttributeView) {
            columnView2.setGeneratorID(designObject.getObjectID());
        }
        columnView.copyDefaults(columnView2);
        columnView2.setTableAlias(columnView.getTableAlias());
        columnView2.setAlias(columnView.getAlias());
        columnView2.setExpression(columnView.getExpression());
        columnView2.setDataType(columnView.getDataType());
        if (columnView.getReferencedColumn() != null) {
            designObject = (Column)objectsMap.get(columnView.getReferencedColumn().getObjectID());
            columnView2.setReferencedColumn((ContainedObjectWithDomain)designObject);
        }
        if (columnView.getTable() != null) {
            designObject = (Table)objectsMap.get(columnView.getTable().getObjectID());
            columnView2.setTable((ContainerWithKeyObject)designObject);
        }
        columnView2.setScopeId(columnView.getScopeId());
        columnView2.setReference(columnView.isReference());
        columnView2.setStructuredType(columnView.getStructuredType());
    }

    public static boolean haveIdenticalColumnsAndSortType(Index index, Index index2, Map map) {
        if (index.getElementsCollection().size() != index2.getElementsCollection().size()) {
            return false;
        }
        ContainedObject[] containedObjectArray = index.getElements();
        for (int i = 0; i < containedObjectArray.length; ++i) {
            Column column = (Column)containedObjectArray[i];
            Column column2 = (Column)index2.getElement(i);
            if (index.getTable().isBST() && index2.getTable().isBST() ? !column2.getName().equals(column.getName()) : !column2.equals(map.get(column.getObjectID()))) {
                return false;
            }
            if (index.isPK() || index.isUnique() || index.getColumnSortOrder(column).equals(index2.getColumnSortOrder(column2))) continue;
            return false;
        }
        return true;
    }

    public static Map getAllObject() {
        return allObject;
    }

    public static void setColumnScope(Column column, Column column2) {
        Table table;
        Table table2 = (Table)column.getScope();
        if (table2 != null && (table = (Table)objectsMap.get(table2.getObjectID())) != null) {
            column2.setScopeId(table.getObjectID());
        }
    }

    public void synchronizeFKColumns(FKIndexAssociation fKIndexAssociation, FKIndexAssociation fKIndexAssociation2) {
        KeyObject keyObject = fKIndexAssociation.getKeyObject();
        if (keyObject != null) {
            int n;
            Column[] columnArray = (Column[])keyObject.getElements();
            Table table = (Table)fKIndexAssociation.getContainerWithKeyObject();
            Table table2 = (Table)fKIndexAssociation2.getContainerWithKeyObject();
            ArrayList<Column> arrayList = new ArrayList<Column>();
            for (n = 0; n < columnArray.length; ++n) {
                Column column = table.getFKColumn(fKIndexAssociation, columnArray[n]);
                if (column == null) continue;
                Column column2 = (Column)AbstractMerging.objectsMap.get(column.getObjectID());
                Column column3 = null;
                if (column2 != null) {
                    String string = columnArray[n].getObjectID();
                    column3 = (Column)AbstractMerging.objectsMap.get(string);
                    if (column3 == null) {
                        column3 = (Column)table2.getDesign().getDesignObject(string);
                    }
                    if (column3 == null) continue;
                    column2.addFKAssociation(column3, fKIndexAssociation2);
                    fKIndexAssociation2.getLocalFKIndex().add(column2);
                    arrayList.add(column2);
                    continue;
                }
                column3 = (Column)AbstractMerging.objectsMap.get(columnArray[n].getObjectID());
                if (column3 == null) continue;
                column2 = table2.createColumnFK(column3, fKIndexAssociation2);
                column2.setName(column.getName());
                MergingModels.copyPropertiesFromColumnToColumn(column, column2);
                MergingModels.copySourceStamp(column, column2);
                column2.moveToIndex(column.getIndex());
                fKIndexAssociation2.getLocalFKIndex().add(column2);
                arrayList.add(column2);
                AbstractMerging.objectsMap.put(column.getObjectID(), column2);
            }
            for (n = 0; n < arrayList.size(); ++n) {
                fKIndexAssociation2.getLocalFKIndex().moveToIndex((ContainedObject)arrayList.get(n), n);
            }
        }
    }

    public static void synchronizeColumnsView(TableView tableView, TableView tableView2) {
        DesignObject designObject;
        DesignObject designObject2;
        tableView2.removeAllFromElements();
        for (Object object : tableView.getContainerMap().keySet()) {
            String string = tableView.getContainerID((String)object);
            designObject2 = tableView.getDesign().getDesignObject(string);
            if (designObject2 == null || (designObject = (DesignObject)objectsMap.get(designObject2.getObjectID())) == null || !(designObject instanceof ContainerObject)) continue;
            tableView2.addToContainers((ContainerObject)designObject, (String)object);
        }
        tableView2.removeAllElements();
        tableView2.removeAllGroupByList();
        for (String string : tableView.getOrderByMap().keySet()) {
            Object object;
            object = (ColumnView)tableView.getObjectByID(tableView.getOrderByList(), string);
            if (object != null) {
                designObject2 = new ColumnView(tableView2.getDesignPart());
                designObject2.setDesign(tableView2.getDesign());
                MergingModels.copyColumnToColumn((ColumnView)object, (ColumnView)designObject2);
                ((AbstractViewElement)designObject2).setView(tableView2);
                tableView2.addToOrderBy((ContainedObject)designObject2, (String)tableView.getOrderByMap().get(string));
                objectsMap.put(((ModelIDObject)object).getObjectID(), designObject2);
                continue;
            }
            System.out.println("MergingModels.copyPropertiesFromTableViewToTableView: Unable to find ColumnView: " + string);
        }
        if (!tableView.isBST()) {
            for (int i = 0; i < tableView.getElements().length; ++i) {
                designObject2 = (ColumnView)tableView.getElements()[i];
                designObject = new ColumnView(tableView2.getDesignPart());
                designObject.setDesign(tableView2.getDesign());
                MergingModels.copyColumnToColumn((ColumnView)designObject2, (ColumnView)designObject);
                ((AbstractViewElement)designObject).setView(tableView2);
                ((ContainedObject)designObject).setContainer(tableView2);
                tableView2.add((ContainedObject)designObject);
                objectsMap.put(designObject2.getObjectID(), designObject);
            }
        }
        tableView2.removeAllFromOrderBy();
        for (int i = 0; i < tableView.getGroupByList().size(); ++i) {
            designObject2 = (ColumnView)tableView.getGroupByList().get(i);
            designObject = (ColumnView)objectsMap.get(designObject2.getObjectID());
            if (designObject == null) continue;
            tableView2.addGroupByList((ContainedObject)designObject);
        }
    }

    private void processSchemaObjects() {
        if (this.targetDesignPart.getSchemaObjectSet().size() > 0 && this.count == 0) {
            this.notEmpty = true;
        }
        Iterator iterator = this.sourceDesignPart.getSchemaObjectSet().iterator();
        while (iterator.hasNext()) {
            SchemaObject schemaObject = (SchemaObject)iterator.next();
            this.processSchemaObject(schemaObject);
        }
    }

    private void processSchemaObject(SchemaObject schemaObject) {
        SchemaObject schemaObject2 = (SchemaObject)objectsMap.get(schemaObject.getObjectID());
        if (schemaObject2 == null) {
            schemaObject2 = (SchemaObject)this.targetDesignPart.getSchemaObjectSet().getByName(schemaObject.getName());
            if (schemaObject2 == null) {
                schemaObject2 = this.targetDesignPart.createSchemaObject(schemaObject.getName());
            }
            schemaObject2.setImportedId(schemaObject.getObjectID());
            objectsMap.put(schemaObject.getObjectID(), schemaObject2);
        }
    }
}

