/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.Filter;

public class FilteredSelection
extends CompareObjectSelection {
    private Filter filter;
    private List filterChilds = new ArrayList();
    private static Integer NO_FILTER_STATUS = new Integer(-1);

    public FilteredSelection(ModelIDObject modelIDObject) {
        super(modelIDObject);
    }

    public FilteredSelection(String string) {
        super(string);
    }

    public FilteredSelection(String string, Filter filter) {
        super(string);
        this.filter = filter;
    }

    @Override
    public int getNumberOfChildren() {
        if (this.filter == null || this.filter.getFilterList().contains(NO_FILTER_STATUS)) {
            return this.childs.size();
        }
        return this.filterChilds.size();
    }

    @Override
    public ModelObject getChild(int n) {
        if ((this.filter == null || this.filter.getFilterList().contains(NO_FILTER_STATUS)) && this.childs.size() > 0) {
            return (ModelObject)this.childs.get(n);
        }
        if (this.filterChilds.size() > 0) {
            return (ModelObject)this.filterChilds.get(n);
        }
        return null;
    }

    @Override
    public Object getChildPlain(int n) {
        return this.getChild(n);
    }

    @Override
    public int getIndexForChild(ModelObject modelObject) {
        if ((this.filter == null || this.filter.getFilterList().contains(NO_FILTER_STATUS)) && this.childs.size() > 0) {
            return this.childs.indexOf(modelObject);
        }
        if (this.filterChilds.size() > 0) {
            return this.filterChilds.indexOf(modelObject);
        }
        return -1;
    }

    @Override
    public int getIndexForChild(Object object) {
        if ((this.filter == null || this.filter.getFilterList().contains(NO_FILTER_STATUS)) && this.childs.size() > 0) {
            return this.childs.indexOf(object);
        }
        if (this.filterChilds.size() > 0) {
            return this.filterChilds.indexOf(object);
        }
        return -1;
    }

    @Override
    public boolean isLeaf() {
        return this.getNumberOfChildren() == 0;
    }

    public void setFilter(Filter filter) {
        this.filterChilds = new ArrayList();
        this.filter = filter;
        if (filter != null) {
            for (int i = 0; i < this.childs.size(); ++i) {
                ModelIdObjectSelection modelIdObjectSelection = (ModelIdObjectSelection)this.childs.get(i);
                if (modelIdObjectSelection.isFiltered(filter.getFilterList()) || modelIdObjectSelection.hasFilteredChilds(filter.getFilterList())) {
                    this.filterChilds.add(modelIdObjectSelection);
                }
                if (modelIdObjectSelection.getObject() == null || !(modelIdObjectSelection instanceof FilteredSelection)) continue;
                ((FilteredSelection)modelIdObjectSelection).setFilter(filter);
            }
        }
    }
}

