/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import oracle.dbtools.crest.exports.ddl.DDLGenerator;
import oracle.dbtools.crest.exports.ddl.DDLGeneratorSpecific;
import oracle.dbtools.crest.exports.ddl.SSBErrorHandler;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.ColumnComparator;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.TableComparator;
import oracle.dbtools.crest.model.design.compare.TableViewComparator;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBAlterColumn;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBAlterIndex;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBAlterTable;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBAlterTableConstraint;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBCreateTable;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropColumn;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropIndex;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropSequence;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropSnapshot;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropTable;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropTableConstraint;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropTableView;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBFKIndex;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBRenameTable;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBSequence;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBSnapshot;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBTableView;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.swingui.compare.ModelChooserDialog;

public class CompareObjectSelection
extends ModelIdObjectSelection {
    private PropertiesComparator propertiesComparator;
    private CompareObjectSelection correspondentNode;
    private JComponent dependentComponent;
    private boolean editable = true;
    private String rname;
    private DDLGenerator dropGenerator;
    protected Map fkMap = new TreeMap();
    private DDLGenerator generator;
    public static final int TABLE_INDEX = 1;
    public static final int VIEW_INDEX = 2;
    public static final int SNAPSHOT_INDEX = 3;
    public static final int SEQUENCE_INDEX = 4;
    public static final int TABLE_COLUMN = 0;
    public static final int TABLE_INDEX_KEY = 1;
    public static final int TABLE_PK_UK = 2;
    public static final int TABLE_FK = 3;
    public static final int TABLE_CONSTRAINT = 4;
    private String dataTypeConversion = "";
    private boolean updateDependent = true;

    public CompareObjectSelection(ModelIDObject modelIDObject) {
        super(modelIDObject);
    }

    public CompareObjectSelection(String string) {
        super(string);
    }

    public PropertiesComparator getPropertiesComparator() {
        return this.propertiesComparator;
    }

    public void setPropertiesComparator(PropertiesComparator propertiesComparator) {
        this.propertiesComparator = propertiesComparator;
    }

    public CompareObjectSelection getCorrespondentNode() {
        return this.correspondentNode;
    }

    public void setCorrespondentNode(CompareObjectSelection compareObjectSelection) {
        this.correspondentNode = compareObjectSelection;
    }

    public void applySelectionToEngineering() {
        if (this.getObject() != null) {
            this.getObject().setShouldMerge(this.isSelected());
        }
        int n = this.getNumberOfChildren();
        for (int i = 0; i < n; ++i) {
            CompareObjectSelection compareObjectSelection = (CompareObjectSelection)this.getChild(i);
            compareObjectSelection.applySelectionToEngineering();
        }
    }

    public void setStatus(int n) {
        if (n == STATE_MODIFIED) {
            if (this.status != STATE_NEW && this.status != STATE_DELETED) {
                this.status = n;
            }
        } else {
            this.status = n;
        }
    }

    public void presetStatus(int n) {
        this.status = n;
    }

    public boolean isModified() {
        if (this.propertiesComparator != null) {
            return this.propertiesComparator.isModified();
        }
        return false;
    }

    public boolean hasChildsWithChangeStatus() {
        for (CompareObjectSelection compareObjectSelection : this.childs) {
            if (!compareObjectSelection.isModified() && this.status == STATE_UNCHANGED) continue;
            return true;
        }
        for (CompareObjectSelection compareObjectSelection : this.childs) {
            if (!compareObjectSelection.hasChildsWithChangeStatus()) continue;
            return true;
        }
        return false;
    }

    public void resetModifiedStatus() {
        for (CompareObjectSelection compareObjectSelection : this.childs) {
            compareObjectSelection.resetModifiedStatus();
            if (compareObjectSelection.getStatus() == STATE_UNCHANGED) continue;
            this.setStatus(STATE_MODIFIED);
        }
        if (this.isModified() || this.hasChildsWithChangeStatus()) {
            this.setStatus(STATE_MODIFIED);
        }
    }

    @Override
    public String getName() {
        ModelIDObject modelIDObject = this.getObject();
        if (modelIDObject != null) {
            if (this.rname != null) {
                return this.rname;
            }
            if (modelIDObject instanceof KeyObject && ((KeyObject)modelIDObject).isPK()) {
                return "(PK) " + modelIDObject.getName();
            }
            if (modelIDObject instanceof Column) {
                return "(" + ((Column)modelIDObject).getIndex() + ")" + modelIDObject.getName();
            }
            return modelIDObject.getName();
        }
        if (this.rname != null) {
            return this.rname;
        }
        return super.getName();
    }

    @Override
    public boolean setName(String string) {
        this.rname = string;
        super.setName(string);
        return true;
    }

    public JComponent getDependentComponent() {
        return this.dependentComponent;
    }

    public void setDependentComponent(JComponent jComponent) {
        this.dependentComponent = jComponent;
    }

    @Override
    public void setSelected(boolean bl) {
        boolean bl2 = this.selected;
        super.setSelected(bl);
        if (bl2 != bl && this.updateDependent && this.dependentComponent != null) {
            this.dependentComponent.updateUI();
        }
    }

    public void setSelected(boolean bl, boolean bl2) {
        boolean bl3 = this.updateDependent;
        this.updateDependent = bl2;
        this.setSelected(bl);
        this.updateDependent = bl3;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean canBeRename() {
        if (this.getPropertiesComparator() instanceof TableComparator) {
            if (!this.getPropertiesComparator().hasToBeRename() && !this.isLeaf()) {
                if (this.childs.size() > 0) {
                    return this.isChangeColumnsType((CompareObjectSelection)this.childs.get(0));
                }
                return false;
            }
            return true;
        }
        if (this.getPropertiesComparator() instanceof TableViewComparator) {
            return this.getPropertiesComparator().hasToBeRename();
        }
        return false;
    }

    public boolean canBeRenameOnly() {
        if (this.getPropertiesComparator() instanceof TableComparator && !this.canBeRename()) {
            return this.getPropertiesComparator().hasToBeRenameOnly();
        }
        return false;
    }

    private boolean isChangeColumnsType(CompareObjectSelection compareObjectSelection) {
        for (CompareObjectSelection compareObjectSelection2 : compareObjectSelection.childs) {
            if (!(compareObjectSelection2.getPropertiesComparator() instanceof ColumnComparator) || !((ColumnComparator)compareObjectSelection2.getPropertiesComparator()).isRecreateTable()) continue;
            return true;
        }
        return false;
    }

    public Iterator ddlDropObjects() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getDropTableComparator((CompareObjectSelection)this.getChild(1)));
        arrayList.addAll(this.getDropViewComparator((CompareObjectSelection)this.getChild(2)));
        if (ModelChooserDialog.isSelectedDatabase) {
            arrayList.addAll(this.getDropSnapshotComparator((CompareObjectSelection)this.getChild(3)));
            arrayList.addAll(this.getDropSequenceComparator((CompareObjectSelection)this.getChild(4)));
        }
        return arrayList.iterator();
    }

    private List getDropSequenceComparator(CompareObjectSelection compareObjectSelection) {
        ArrayList<CompareObjectSelection> arrayList = new ArrayList<CompareObjectSelection>();
        if (compareObjectSelection != null) {
            for (CompareObjectSelection compareObjectSelection2 : compareObjectSelection.childs) {
                if (!compareObjectSelection2.isSelected() || !compareObjectSelection2.canBeDrop()) continue;
                arrayList.add(compareObjectSelection2);
            }
        }
        return arrayList;
    }

    private List getDropSnapshotComparator(CompareObjectSelection compareObjectSelection) {
        ArrayList<CompareObjectSelection> arrayList = new ArrayList<CompareObjectSelection>();
        if (compareObjectSelection != null) {
            for (CompareObjectSelection compareObjectSelection2 : compareObjectSelection.childs) {
                if (!compareObjectSelection2.isSelected() || !compareObjectSelection2.canBeDrop()) continue;
                arrayList.add(compareObjectSelection2);
            }
        }
        return arrayList;
    }

    private List getDropViewComparator(CompareObjectSelection compareObjectSelection) {
        ArrayList<CompareObjectSelection> arrayList = new ArrayList<CompareObjectSelection>();
        for (CompareObjectSelection compareObjectSelection2 : compareObjectSelection.childs) {
            if (!compareObjectSelection2.isSelected() || !compareObjectSelection2.canBeDrop() && !compareObjectSelection2.canBeRename()) continue;
            arrayList.add(compareObjectSelection2);
        }
        return arrayList;
    }

    private List getDropTableComparator(CompareObjectSelection compareObjectSelection) {
        ArrayList<CompareObjectSelection> arrayList = new ArrayList<CompareObjectSelection>();
        if (compareObjectSelection != null) {
            for (CompareObjectSelection compareObjectSelection2 : compareObjectSelection.childs) {
                if (!(compareObjectSelection2.getPropertiesComparator() instanceof TableComparator)) continue;
                if (compareObjectSelection2.isSelected() && compareObjectSelection2.canBeDrop()) {
                    arrayList.add(compareObjectSelection2);
                    continue;
                }
                if (compareObjectSelection2.canBeRename()) continue;
                this.getChildsToBeDrop(arrayList, compareObjectSelection2);
            }
        }
        return arrayList;
    }

    private void getChildsToBeDrop(List list, CompareObjectSelection compareObjectSelection) {
        for (CompareObjectSelection compareObjectSelection2 : compareObjectSelection.childs) {
            if (compareObjectSelection2.isSelected() && compareObjectSelection2.canBeDrop()) {
                list.add(compareObjectSelection2);
            }
            this.getChildsToBeDrop(list, compareObjectSelection2);
        }
    }

    public Iterator ddlCreateObjects() {
        return this.ddlObjects();
    }

    public Iterator ddlObjects() {
        ArrayList arrayList = new ArrayList();
        if (ModelChooserDialog.isSelectedDatabase) {
            arrayList.addAll(this.getSnapshotComparator((CompareObjectSelection)this.getChild(3)));
            arrayList.addAll(this.getSequenceComparator((CompareObjectSelection)this.getChild(4)));
        }
        arrayList.addAll(this.getTableComparator((CompareObjectSelection)this.getChild(1)));
        arrayList.addAll(this.getSelectedObjectsFor((CompareObjectSelection)this.getChild(1), 0));
        arrayList.addAll(this.getSelectedObjectsFor((CompareObjectSelection)this.getChild(1), 1));
        arrayList.addAll(this.getSelectedObjectsFor((CompareObjectSelection)this.getChild(1), 2));
        arrayList.addAll(this.getSelectedObjectsFor((CompareObjectSelection)this.getChild(1), 4));
        arrayList.addAll(this.getFKComparator((CompareObjectSelection)this.getChild(1)));
        arrayList.addAll(this.getTableViewComparator((CompareObjectSelection)this.getChild(2)));
        return arrayList.iterator();
    }

    private List getSequenceComparator(CompareObjectSelection compareObjectSelection) {
        ArrayList<CompareObjectSelection> arrayList = new ArrayList<CompareObjectSelection>();
        if (compareObjectSelection != null) {
            for (CompareObjectSelection compareObjectSelection2 : compareObjectSelection.childs) {
                if (!compareObjectSelection2.isSelected() || !compareObjectSelection2.canBeCreate()) continue;
                arrayList.add(compareObjectSelection2);
            }
        }
        return arrayList;
    }

    private List getSnapshotComparator(CompareObjectSelection compareObjectSelection) {
        ArrayList<CompareObjectSelection> arrayList = new ArrayList<CompareObjectSelection>();
        if (compareObjectSelection != null) {
            for (CompareObjectSelection compareObjectSelection2 : compareObjectSelection.childs) {
                if (!compareObjectSelection2.isSelected() || !compareObjectSelection2.canBeCreate()) continue;
                arrayList.add(compareObjectSelection2);
            }
        }
        return arrayList;
    }

    private List getTableViewComparator(CompareObjectSelection compareObjectSelection) {
        ArrayList<CompareObjectSelection> arrayList = new ArrayList<CompareObjectSelection>();
        if (compareObjectSelection != null) {
            for (CompareObjectSelection compareObjectSelection2 : compareObjectSelection.childs) {
                if (!compareObjectSelection2.isSelected() || compareObjectSelection2.canBeDrop() && !compareObjectSelection2.canBeRename()) continue;
                arrayList.add(compareObjectSelection2);
            }
        }
        return arrayList;
    }

    private List getFKComparator(CompareObjectSelection compareObjectSelection) {
        ArrayList arrayList = new ArrayList();
        if (compareObjectSelection != null) {
            for (CompareObjectSelection compareObjectSelection2 : compareObjectSelection.childs) {
                if (compareObjectSelection2.getNumberOfChildren() < 3) continue;
                CompareObjectSelection compareObjectSelection3 = (CompareObjectSelection)compareObjectSelection2.getChild(3);
                Iterator iterator = compareObjectSelection3.childs.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(iterator.next());
                }
            }
        }
        return arrayList;
    }

    private List getTableComparator(CompareObjectSelection compareObjectSelection) {
        ArrayList<CompareObjectSelection> arrayList = new ArrayList<CompareObjectSelection>();
        if (compareObjectSelection != null) {
            for (CompareObjectSelection compareObjectSelection2 : compareObjectSelection.childs) {
                if (!(compareObjectSelection2.getPropertiesComparator() instanceof TableComparator) || !compareObjectSelection2.isSelected() || compareObjectSelection2.canBeDrop()) continue;
                arrayList.add(compareObjectSelection2);
            }
        }
        return arrayList;
    }

    private List getSelectedObjectsFor(CompareObjectSelection compareObjectSelection, int n) {
        ArrayList<CompareObjectSelection> arrayList = new ArrayList<CompareObjectSelection>();
        if (compareObjectSelection != null) {
            for (CompareObjectSelection compareObjectSelection2 : compareObjectSelection.childs) {
                if (compareObjectSelection2.canBeCreate() || !compareObjectSelection2.isSelected() || compareObjectSelection2.canBeRename() || compareObjectSelection2.getNumberOfChildren() <= n) continue;
                CompareObjectSelection compareObjectSelection3 = (CompareObjectSelection)compareObjectSelection2.getChild(n);
                for (CompareObjectSelection compareObjectSelection4 : compareObjectSelection3.childs) {
                    if (!compareObjectSelection4.isSelected() || compareObjectSelection4.canBeDrop() || !compareObjectSelection4.isDDLModified()) continue;
                    arrayList.add(compareObjectSelection4);
                }
            }
        }
        return arrayList;
    }

    public boolean canBeDrop() {
        return this.getPropertiesComparator().hasToBeDrop();
    }

    public boolean canBeCreate() {
        return this.getStatus() == STATE_NEW;
    }

    public void removeDDLObjects() {
        this.fkMap.clear();
    }

    public DDLGenerator getDDLDropGenerator() {
        if (this.dropGenerator == null) {
            this.dropGenerator = this.createDDLDropGenerator();
            this.dropGenerator.setLabel("DropGen");
            this.dropGenerator.append(SSBErrorHandler.getInstance());
        }
        return this.dropGenerator;
    }

    protected DDLGenerator createDDLDropGenerator() {
        DDLGeneratorSpecific dDLGeneratorSpecific = new DDLGeneratorSpecific();
        dDLGeneratorSpecific.append(new CSSBDropTable());
        dDLGeneratorSpecific.append(new CSSBDropTableView());
        dDLGeneratorSpecific.append(new CSSBDropTableConstraint());
        dDLGeneratorSpecific.append(new CSSBDropIndex(this.fkMap));
        dDLGeneratorSpecific.append(new CSSBDropColumn());
        dDLGeneratorSpecific.append(new CSSBDropSnapshot());
        dDLGeneratorSpecific.append(new CSSBDropSequence());
        return dDLGeneratorSpecific;
    }

    public DDLGenerator getDDLGenerator() {
        if (this.generator == null) {
            this.generator = this.createDDLGenerator();
            this.generator.append(SSBErrorHandler.getInstance());
        }
        return this.generator;
    }

    protected DDLGenerator createDDLGenerator() {
        DDLGeneratorSpecific dDLGeneratorSpecific = new DDLGeneratorSpecific();
        CSSBCreateTable cSSBCreateTable = new CSSBCreateTable();
        dDLGeneratorSpecific.append(cSSBCreateTable);
        dDLGeneratorSpecific.append(new CSSBRenameTable(this.fkMap));
        dDLGeneratorSpecific.append(new CSSBAlterTable());
        dDLGeneratorSpecific.append(new CSSBAlterIndex(this.fkMap));
        dDLGeneratorSpecific.append(new CSSBAlterColumn());
        dDLGeneratorSpecific.append(new CSSBAlterTableConstraint());
        dDLGeneratorSpecific.append(new CSSBFKIndex(this.fkMap));
        dDLGeneratorSpecific.append(new CSSBSnapshot(cSSBCreateTable));
        dDLGeneratorSpecific.append(new CSSBSequence());
        dDLGeneratorSpecific.append(new CSSBTableView());
        return dDLGeneratorSpecific;
    }

    public List getObjectsForRestore(int n) {
        ArrayList<CompareObjectSelection> arrayList = new ArrayList<CompareObjectSelection>();
        if (this.getNumberOfChildren() > n) {
            CompareObjectSelection compareObjectSelection = (CompareObjectSelection)this.childs.get(n);
            for (CompareObjectSelection compareObjectSelection2 : compareObjectSelection.childs) {
                if (!compareObjectSelection2.canBeDrop() || compareObjectSelection2.isSelected()) continue;
                arrayList.add(compareObjectSelection2.getCorrespondentNode());
            }
        }
        return arrayList;
    }

    public List getChildObjects(int n) {
        ArrayList arrayList = new ArrayList();
        if (this.getNumberOfChildren() > n) {
            CompareObjectSelection compareObjectSelection = (CompareObjectSelection)this.childs.get(n);
            arrayList.addAll(compareObjectSelection.childs);
        }
        return arrayList;
    }

    public void setObject(ModelIDObject modelIDObject) {
        this.object = modelIDObject;
        this.elDescriptor = modelIDObject.getClass();
    }

    public CompareObjectSelection getChild(Object object) {
        for (CompareObjectSelection compareObjectSelection : this.childs) {
            if (compareObjectSelection.getObject() != object) continue;
            return compareObjectSelection;
        }
        return null;
    }

    public CompareObjectSelection getChildNested(Object object, int n) {
        int n2 = n - 1;
        if (n2 >= 0) {
            if (this.getObject() == object) {
                return this;
            }
            for (CompareObjectSelection compareObjectSelection : this.childs) {
                CompareObjectSelection compareObjectSelection2;
                if (compareObjectSelection.getObject() == object) {
                    return compareObjectSelection;
                }
                if (n2 <= 0 || (compareObjectSelection2 = compareObjectSelection.getChildNested(object, n2)) == null || compareObjectSelection2.getObject() != object) continue;
                return compareObjectSelection2;
            }
        }
        return null;
    }

    public String getChoosedPropertyValue(String string) {
        return this.getPropertiesComparator().getChoosedPropertyValue(string);
    }

    public String getChoosedPropertyValue(String string, boolean bl) {
        return this.getPropertiesComparator().getChoosedPropertyValue(string, bl);
    }

    public String getMergedProperty(String string) {
        EngPropertyHolder engPropertyHolder = this.getPropertiesComparator().getPropertyHolderByName(string);
        String string2 = engPropertyHolder.isSelected() ? engPropertyHolder.getLeftValue() : engPropertyHolder.getRightValue();
        return string2;
    }

    public CompareObjectSelection getTableNode() {
        if (this.getParent() != null) {
            return (CompareObjectSelection)((ModelObject)this.getParent()).getParent();
        }
        return null;
    }

    public boolean isDDLModified() {
        return this.getPropertiesComparator().isDDLModified();
    }

    public String getDataTypeConversion() {
        return this.dataTypeConversion;
    }

    public void setDataTypeConversion(String string) {
        this.dataTypeConversion = string;
    }

    @Override
    public String getLongName() {
        if (this.getObject() != null) {
            return this.getObject().getLongName();
        }
        return this.getName();
    }

    @Override
    public boolean isFiltered(List list) {
        for (Integer n : list) {
            if (n.intValue() != this.getStatus()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFilteredChilds(List list) {
        for (CompareObjectSelection compareObjectSelection : this.getChilds()) {
            if (!compareObjectSelection.isFiltered(list) && !compareObjectSelection.hasFilteredChilds(list)) continue;
            return true;
        }
        return false;
    }
}

