/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import oracle.dbtools.crest.model.design.compare.COPropertiesComparator;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;

public class ColumnComparator
extends COPropertiesComparator {
    private Column targetColumn;
    private Column sourceColumn;
    private ColumnProxy sourceColumnProxy;
    private ColumnProxy targetColumnProxy;
    private boolean tableShouldBeRecreated = false;

    public ColumnComparator(Column column, Column column2) {
        super(column, column2);
        EngPropertyHolder engPropertyHolder;
        this.targetColumn = column2;
        this.sourceColumn = column;
        this.initPropertiesList();
        if (this.sourceColumn != null && !this.sourceColumn.getAppView().getSettings().isUseDataTypeKindInCompare() && (engPropertyHolder = this.getPropertyHolderByName(DATA_TYPE_KIND)) != null) {
            engPropertyHolder.setFiltered(true);
            engPropertyHolder.setEditable(false);
        }
    }

    public ColumnComparator(Column column, Column column2, ColumnProxy columnProxy, ColumnProxy columnProxy2) {
        super(column, column2);
        EngPropertyHolder engPropertyHolder;
        this.targetColumn = column2;
        this.sourceColumn = column;
        this.sourceColumnProxy = columnProxy;
        this.targetColumnProxy = columnProxy2;
        this.initPropertiesList();
        if (column != null && !column.getAppView().getSettings().isUseDataTypeKindInCompare() && (engPropertyHolder = this.getPropertyHolderByName(DATA_TYPE_KIND)) != null) {
            engPropertyHolder.setFiltered(true);
            engPropertyHolder.setEditable(false);
        }
    }

    @Override
    public void copySelectedProperties() {
        this.copyPropertiesFromLeftToRight();
        this.copyScopeFromColumnToColumn();
    }

    public Column getTargetColumn() {
        return this.targetColumn;
    }

    public Column getSourceColumn() {
        return this.sourceColumn;
    }

    @Override
    protected void initPropertiesList() {
        super.initPropertiesList();
        PropertyHolder propertyHolder = new PropertyHolder(SCOPE);
        Entity entity = null;
        if (this.targetColumn != null && this.targetColumn.getScope() != null) {
            propertyHolder.setRightValue(this.targetColumn.getScope().getName());
        } else {
            propertyHolder.setRightValue("");
        }
        if (this.sourceColumn != null && this.sourceColumn.getScope() != null) {
            propertyHolder.setLeftValue(this.sourceColumn.getScope().getName());
            entity = ((Table)this.sourceColumn.getScope()).getEngEntity();
        } else {
            propertyHolder.setLeftValue("");
        }
        if (this.sourceColumn != null && this.targetColumn != null && entity != this.targetColumn.getScope()) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
    }

    private void copyScopeFromColumnToColumn() {
        if (this.sourceColumn != null && this.targetColumn != null) {
            this.targetColumn.setTemporaryWriteable(true);
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected() || !engPropertyHolder.getName().equals(SCOPE)) continue;
                if (this.sourceColumn.getScope() != null) {
                    MergingModels.setColumnScope(this.sourceColumn, this.targetColumn);
                    continue;
                }
                this.targetColumn.setScopeId(null);
            }
            this.targetColumn.setTemporaryWriteable(false);
        }
    }

    @Override
    public String getLeftName() {
        return this.sourceColumn != null ? this.sourceColumn.getContainerWithKeyObject().getName() + "." + this.sourceColumn.getName() : "";
    }

    @Override
    public String getRightName() {
        return this.targetColumn != null ? this.targetColumn.getContainerWithKeyObject().getName() + "." + this.targetColumn.getName() : "";
    }

    @Override
    protected boolean hasToBeRename() {
        if (this.sourceColumn != null && this.targetColumn != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.getName().equals(PropertiesComparator.DATA_TYPE) || !engPropertyHolder.isSelected()) continue;
                return true;
            }
        }
        return super.hasToBeRename();
    }

    @Override
    protected boolean hasToBeDrop() {
        if (this.sourceColumn == null && this.targetColumn != null) {
            return true;
        }
        return super.hasToBeDrop();
    }

    public ColumnProxy getSourceColumnProxy() {
        return this.sourceColumnProxy;
    }

    public ColumnProxy getTargetColumnProxy() {
        return this.targetColumnProxy;
    }

    public boolean isDataTypeChanged() {
        if (this.sourceColumn != null && this.targetColumn != null) {
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.getName().equals(PropertiesComparator.DATA_TYPE) || !engPropertyHolder.isModified()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isTableShouldBeRecreated() {
        return this.tableShouldBeRecreated;
    }

    public void setTableShouldBeRecreated(boolean bl) {
        this.tableShouldBeRecreated = bl;
    }

    public boolean isRecreateTable() {
        return this.isTableShouldBeRecreated() && this.hasToBeRename();
    }
}

