/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.compare.MergingModels;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.engineering.EngCOPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertiesComparator;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Column;

public abstract class COPropertiesComparator
extends PropertiesComparator {
    private ContainedObjectWithDomain left_co;
    private ContainedObjectWithDomain right_co;

    public COPropertiesComparator(ContainedObjectWithDomain containedObjectWithDomain, ContainedObjectWithDomain containedObjectWithDomain2) {
        super(containedObjectWithDomain, containedObjectWithDomain2);
        this.left_co = containedObjectWithDomain;
        this.right_co = containedObjectWithDomain2;
    }

    public static String decodeDataTypeKindToString(short s) {
        if (s == 0) {
            return Messages.getString("COPropertiesComparator.Domain");
        }
        if (s == 1) {
            return Messages.getString("COPropertiesComparator.LogicalType");
        }
        if (s == 2) {
            return Messages.getString("COPropertiesComparator.DistinctType");
        }
        if (s == 3) {
            return Messages.getString("COPropertiesComparator.StructuredType");
        }
        if (s == 4) {
            return Messages.getString("COPropertiesComparator.CollectionType");
        }
        return "";
    }

    public static String getType(ContainedObjectWithDomain containedObjectWithDomain) {
        String string = containedObjectWithDomain.getDesign().getDomainSet().getDefaultDomain().getDataType().toString();
        short s = containedObjectWithDomain.getUse();
        if (s == 0 && containedObjectWithDomain.getDomain() != null) {
            string = containedObjectWithDomain.getDomain().getName();
        } else if (s == 1) {
            string = containedObjectWithDomain.getLogicalDatatype().getName();
        } else if (s == 2) {
            if (containedObjectWithDomain.getDistinctType() != null) {
                string = containedObjectWithDomain.getDistinctType().getName();
            }
        } else if (s == 3) {
            if (containedObjectWithDomain.getStructuredType() != null) {
                string = containedObjectWithDomain.isReference() ? "REF " + containedObjectWithDomain.getStructuredType().getName() : containedObjectWithDomain.getStructuredType().getName();
            }
        } else if (s == 4 && containedObjectWithDomain.getCollectionType() != null) {
            string = containedObjectWithDomain.getCollectionType().getName();
        }
        return string;
    }

    protected void initPropertiesList() {
        Object object;
        Object object2;
        Object object3;
        this.initNameProperty();
        EngCOPropertiesComparator.processDataTypeAndUse(this.propertiesList, this.left_co, this.right_co);
        PropertyHolder propertyHolder = new PropertyHolder(MANDATORY);
        propertyHolder.setDDLHolder(true);
        propertyHolder.setLeftValue(this.left_co != null ? String.valueOf(!this.left_co.getNullsAllowed()) : "");
        propertyHolder.setRightValue(this.right_co != null ? String.valueOf(!this.right_co.getNullsAllowed()) : "");
        if (this.left_co != null && this.right_co != null && this.left_co.getNullsAllowed() != this.right_co.getNullsAllowed()) {
            if (this.left_co.isFKElement() && this.right_co.isFKElement()) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
                propertyHolder.setRightValue(propertyHolder.getRightValue() + "(FK)");
            } else {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
        }
        this.propertiesList.add(propertyHolder);
        if (this.left_co != null && this.left_co instanceof Column && this.right_co != null && this.right_co instanceof Column) {
            Column column = (Column)this.left_co;
            object3 = (Column)this.right_co;
            propertyHolder = new PropertyHolder(NNC_NAME);
            propertyHolder.setDDLHolder(true);
            object2 = column.getNotNullConstraintName();
            if (object2 == null) {
                object2 = "";
            }
            if ((object = ((Column)object3).getNotNullConstraintName()) == null) {
                object = "";
            }
            propertyHolder.setLeftValue((String)object2);
            propertyHolder.setRightValue((String)object);
            if (!((String)object2).equalsIgnoreCase((String)object)) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
            this.propertiesList.add(propertyHolder);
        }
        propertyHolder = new PropertyHolder(DEFAULT_VALUE);
        propertyHolder.setDDLHolder(true);
        propertyHolder.setLeftValue(this.left_co != null ? this.left_co.getDefaultValue() : "");
        propertyHolder.setRightValue(this.right_co != null ? this.right_co.getDefaultValue() : "");
        if (this.left_co != null && this.right_co != null && !this.left_co.getDefaultValue().trim().equals(this.right_co.getDefaultValue().trim())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        boolean bl = true;
        if (this.left_co != null && this.right_co != null && this.left_co.getUseDomainConstraints() && PropertiesComparator.DDL_ONLY) {
            bl = false;
        }
        if (bl) {
            this.propertiesList.add(EngCOPropertiesComparator.createCheckConstrNamePH(this.left_co, this.right_co));
        }
        if (!PropertiesComparator.DDL_ONLY) {
            propertyHolder = new PropertyHolder(EngPropertiesComparator.USE_DOMAIN_CONSTRAINT);
            propertyHolder.setLeftValue(this.left_co != null ? String.valueOf(this.left_co.getUseDomainConstraints()) : "");
            propertyHolder.setRightValue(this.right_co != null ? String.valueOf(this.right_co.getUseDomainConstraints()) : "");
            if (this.left_co != null && this.right_co != null && this.left_co.getUseDomainConstraints() != this.right_co.getUseDomainConstraints()) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
            this.propertiesList.add(propertyHolder);
        }
        if (this.left_co != null && !this.left_co.getUseDomainConstraints() || this.right_co != null && !this.right_co.getUseDomainConstraints()) {
            object3 = EngCOPropertiesComparator.createCheckConstrPH(this.left_co, this.right_co);
            object2 = EngCOPropertiesComparator.createRangeConstrPH(this.left_co, this.right_co);
            object = EngCOPropertiesComparator.createLOVConstraintPH(this.left_co, this.right_co);
            if ((((EngPropertyHolder)object3).isModified() || ((EngPropertyHolder)object2).isModified() || ((EngPropertyHolder)object).isModified()) && EngCOPropertiesComparator.isConstrCondConsistent(this.left_co, this.right_co)) {
                ((EngPropertyHolder)object3).setSelected(false);
                ((EngPropertyHolder)object2).setSelected(false);
                ((EngPropertyHolder)object).setSelected(false);
            }
            this.propertiesList.add(object3);
            this.propertiesList.add(object2);
            this.propertiesList.add(object);
        }
        this.initCommentsAndNotes();
        if (!PropertiesComparator.DDL_ONLY) {
            propertyHolder = new PropertyHolder(SOURCE_TYPE);
            propertyHolder.setLeftValue(this.left_co != null ? this.left_co.getSourceType() : "");
            propertyHolder.setRightValue(this.right_co != null ? this.right_co.getSourceType() : "");
            if (this.left_co != null && this.right_co != null && !this.left_co.getSourceType().equals(this.right_co.getSourceType())) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
            this.propertiesList.add(propertyHolder);
        }
        if (this.left_co instanceof Column || this.right_co instanceof Column) {
            propertyHolder = new PropertyHolder(COMPUTED);
            propertyHolder.setLeftValue(this.left_co != null ? String.valueOf(((Column)this.left_co).isComputed()) : "");
            propertyHolder.setRightValue(this.right_co != null ? String.valueOf(((Column)this.right_co).isComputed()) : "");
            if (this.left_co != null && this.right_co != null && !((Column)this.left_co).isComputed().equals(((Column)this.right_co).isComputed())) {
                propertyHolder.setModified(true);
                propertyHolder.setSelected(true);
            }
            this.propertiesList.add(propertyHolder);
        }
        propertyHolder = new PropertyHolder(FORMULA_DESC);
        propertyHolder.setLeftValue(this.left_co != null ? this.left_co.getFormulaDesc() : "");
        propertyHolder.setRightValue(this.right_co != null ? this.right_co.getFormulaDesc() : "");
        if (this.left_co != null && this.right_co != null && !this.left_co.getFormulaDesc().equals(this.right_co.getFormulaDesc())) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
        propertyHolder = new PropertyHolder(TYPE_SUBSTITUTION);
        propertyHolder.setLeftValue(this.left_co != null ? String.valueOf(this.left_co.isAllowSubtypeSubstitution()) : "");
        propertyHolder.setRightValue(this.right_co != null ? String.valueOf(this.right_co.isAllowSubtypeSubstitution()) : "");
        if (this.left_co != null && this.right_co != null && this.left_co.isAllowSubtypeSubstitution() != this.right_co.isAllowSubtypeSubstitution()) {
            propertyHolder.setModified(true);
            propertyHolder.setSelected(true);
        }
        this.propertiesList.add(propertyHolder);
    }

    @Override
    protected void copyPropertiesFromLeftToRight() {
        if (this.left_co != null && this.right_co != null) {
            this.right_co.setTemporaryWriteable(true);
            super.copyPropertiesFromLeftToRight();
            for (EngPropertyHolder engPropertyHolder : this.propertiesList) {
                if (!engPropertyHolder.isSelected()) continue;
                if (engPropertyHolder.getName().equals(DATA_TYPE) || engPropertyHolder.getName().equals(DATA_TYPE_KIND) || engPropertyHolder.getName().equals(NATIVE_DATA_TYPE)) {
                    MergingModels.copyDataTypeFromCOWD_To_COWD(this.left_co, this.right_co, true);
                    continue;
                }
                if (engPropertyHolder.getName().equals(TYPE_SUBSTITUTION)) {
                    this.right_co.setAllowSubtypeSubstitution(this.left_co.isAllowSubtypeSubstitution());
                    continue;
                }
                if (engPropertyHolder.getName().equals(MANDATORY)) {
                    this.right_co.setNullsAllowed(this.left_co.getNullsAllowed());
                    continue;
                }
                if (engPropertyHolder.getName().equals(NNC_NAME) && this.right_co instanceof Column && this.left_co instanceof Column) {
                    ((Column)this.right_co).setNotNullConstraintName(((Column)this.left_co).getNotNullConstraintName());
                    continue;
                }
                if (engPropertyHolder.getName().equals(DEFAULT_VALUE)) {
                    this.right_co.setDefaultValue(this.left_co.getDefaultValue());
                    continue;
                }
                if (engPropertyHolder.getName().equals(USES_DEFUALT_VALUE)) {
                    this.right_co.setUsesDefaultValue(this.left_co.getUsesDefaultValue());
                    continue;
                }
                if (engPropertyHolder.getName().equals(SOURCE_TYPE)) {
                    this.right_co.setSourceType(this.left_co.getSourceType());
                    continue;
                }
                if (engPropertyHolder.getName().equals(COMPUTED)) {
                    ((Column)this.right_co).setComputed(((Column)this.left_co).isComputed());
                    continue;
                }
                if (engPropertyHolder.getName().equals(FORMULA_DESC)) {
                    this.right_co.setFormulaDesc(this.left_co.getFormulaDesc());
                    continue;
                }
                if (engPropertyHolder.getName().equals(EngPropertiesComparator.CHECK_CONSTRAINT_NAME)) {
                    this.right_co.setConstraintName(this.left_co.getConstraintName());
                    continue;
                }
                if (engPropertyHolder.getName().equals(EngPropertiesComparator.USE_DOMAIN_CONSTRAINT)) {
                    this.right_co.setUseDomainConstraints(this.left_co.getUseDomainConstraints());
                    continue;
                }
                if (engPropertyHolder.getName().equals(EngPropertiesComparator.CHECK_CONSTRAINT)) {
                    EngCOPropertiesComparator.copyCheckConstraint(this.left_co, this.right_co);
                    continue;
                }
                if (engPropertyHolder.getName().equals(EngPropertiesComparator.RANGE_CONSTRAINT)) {
                    EngCOPropertiesComparator.copyRangeConstraint(this.left_co, this.right_co);
                    continue;
                }
                if (!engPropertyHolder.getName().equals(EngPropertiesComparator.LOV_CONSTRAINT)) continue;
                EngCOPropertiesComparator.copyLOVConstraint(this.left_co, this.right_co);
            }
            this.right_co.setTemporaryWriteable(false);
        }
    }
}

