/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.xtdmapping.XtdMapping;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;

public abstract class AbstractMerging {
    protected Design design;
    protected DesignPartView processedDPV;
    protected String targetDesPartID;
    protected Map comparatorsMap;
    protected static Map objectsMap = new TreeMap();

    public AbstractMerging(Design design) {
        this.design = design;
    }

    public abstract void execute(Map var1);

    public DesignObject[] getProcessedObjects(DesignObjectSet designObjectSet) {
        if (this.processedDPV == null || this.processedDPV == this.processedDPV.getDesignPart().getMainView()) {
            return (DesignObject[])designObjectSet.toArray();
        }
        ArrayList<DesignObject> arrayList = new ArrayList<DesignObject>();
        Iterator iterator = designObjectSet.iterator();
        while (iterator.hasNext()) {
            DesignObject designObject = (DesignObject)iterator.next();
            if (!designObject.hasRepresentationInDPV(this.processedDPV)) continue;
            arrayList.add(designObject);
        }
        return arrayList.toArray(designObjectSet.getProtoArray());
    }

    public void setGraphicalPropertiesOnNewObject(ContainerObject containerObject, ContainerObject containerObject2) {
        ApplicationView applicationView = containerObject.getDesign().getAppView();
        if (applicationView != null) {
            applicationView.setGraphicalPropsFor(containerObject2, applicationView.getGraphicalPropsFor(containerObject));
        }
    }

    public boolean isModified(XtdMapping xtdMapping, DesignObject designObject) {
        return xtdMapping.getOwnerObject().getChange().getTime() > xtdMapping.getCreationTime();
    }

    public boolean isModified(XtdMapping xtdMapping) {
        long l = 2000L;
        return xtdMapping.getOwnerObject().getChange().getTime() > xtdMapping.getCreationTime() + l || xtdMapping.getTargetObject().getChange().getTime() > xtdMapping.getCreationTime() + l;
    }

    public Map getComparatorsMap() {
        return this.comparatorsMap;
    }

    public static Map getObjectsMap() {
        return objectsMap;
    }
}

