/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.dbtools.crest.model.Messages;
import oracle.dbtools.crest.model.MultiShapedDesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.swingui.editor.NoteEditor;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;
import oracle.ide.Ide;

public class Note
extends MultiShapedDesignObject
implements EditableFonts {
    private static final String DEFAULT_TEXT = Messages.getString("Note.DoubleClickToedit");
    private List editableFonts;
    public static final String TYPE_NAME = "Note";

    public Note(DesignPart designPart) {
        super(designPart);
        this.setComment(DEFAULT_TEXT);
        this.initEditableFonts();
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    public String getText() {
        return this.getComment();
    }

    public void setText(String string) {
        this.setComment(string);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            NoteEditor noteEditor = new NoteEditor(this.getDesign().getAppView(), this);
            noteEditor.showDialog();
        }
    }

    private void initEditableFonts() {
        DefaultFontAndColor defaultFontAndColor;
        this.editableFonts = new ArrayList();
        if (this.getDesignPart() != null && (defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject(TYPE_NAME)) != null) {
            for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                this.editableFonts.add(fontObject.copy());
            }
        }
    }

    @Override
    public List getEditableFonts() {
        return this.editableFonts;
    }

    @Override
    public FontObject getFontObject(String string) {
        for (FontObject fontObject : this.editableFonts) {
            if (!string.equalsIgnoreCase(fontObject.getType())) continue;
            return fontObject;
        }
        return null;
    }

    @Override
    public void resetFontsAndColors(boolean bl) {
        if (bl) {
            DefaultFontAndColor defaultFontAndColor;
            this.editableFonts.clear();
            if (this.getDesignPart() != null && (defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject(TYPE_NAME)) != null) {
                for (FontObject fontObject : defaultFontAndColor.getEditableFonts()) {
                    this.editableFonts.add(fontObject.copy());
                }
            }
            this.setBackgroundColor(null);
            this.setForegroundColor(null);
        } else {
            DefaultFontAndColor defaultFontAndColor = this.getDesignPart().getDesign().getDLSettings().getDefaultFCObject(TYPE_NAME);
            if (defaultFontAndColor != null) {
                if (this.getBackgroundColor() == null) {
                    this.setBackgroundColor(defaultFontAndColor.getBackgroundColor());
                }
                if (this.getForegroundColor() == null) {
                    this.setForegroundColor(defaultFontAndColor.getForegroundColor());
                }
            }
        }
        this.setUseDefaultColor(bl);
    }

    @Override
    public void remove() {
        this.remove(true);
    }

    public void remove(boolean bl) {
        if (bl) {
            int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("Note.SureYouWantToDelete"), this.getName()), Messages.getString("Note.ConfirmObjectDelete"), 0);
            if (n == 0) {
                super.remove();
            }
        } else {
            super.remove();
        }
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "note/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

